package Task::Lingua::Any::Numbers;
use strict;
use warnings;

our $VERSION = '0.19';

1;

__END__

=pod

=encoding utf8

=head1 NAME

Task::Lingua::Any::Numbers - Installs all number to word modules.

=head1 SYNOPSIS

None.

=head1 DESCRIPTION

This document describes version C<0.19> of C<Task::Lingua::Any::Numbers>
released on C<5 July 2016>.

This is a tool to install everything needed for a full L<Lingua::Any::Numbers>
interface. See the L<Task> module for the rationale.

=head1 PREREQUISITIES

   Lingua::AF::Numbers
   Lingua::BG::Numbers
   Lingua::EN::Numbers
   Lingua::EU::Numbers
   Lingua::FR::Numbers
   Lingua::HU::Numbers
   Lingua::IT::Numbers
   Lingua::JA::Numbers
   Lingua::NL::Numbers
   Lingua::PL::Numbers
   Lingua::SV::Numbers
   Lingua::TR::Numbers
   Lingua::ZH::Numbers
   Lingua::CS::Num2Word
   Lingua::DE::Num2Word
   Lingua::ES::Numeros
   Lingua::ID::Nums2Words
   Lingua::NO::Num2Word
   Lingua::PT::Nums2Word
   Lingua::PT::Nums2Ords
   Lingua::Any::Numbers

=head1 SEE ALSO

L<Lingua::Any::Numbers>, L<Task>.

=head1 AUTHOR

Burak Gursoy <burak@cpan.org>.

=head1 COPYRIGHT

Copyright 2009 - 2016 Burak Gursoy. All rights reserved.

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.0 or,
at your option, any later version of Perl 5 you may have available.
=cut
