# Generated by default/object.tt
package Paws::WAFV2::LabelSummary;
  use Moose;
  has Name => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::LabelSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::LabelSummary object:

  $service_obj->Method(Att1 => { Name => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::LabelSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

List of labels used by one or more of the rules of a RuleGroup. This
summary object is used for the following rule group lists:

=over

=item *

C<AvailableLabels> - Labels that rules add to matching requests. These
labels are defined in the C<RuleLabels> for a Rule.

=item *

C<ConsumedLabels> - Labels that rules match against. These labels are
defined in a C<LabelMatchStatement> specification, in the Statement
definition of a rule.

=back


=head1 ATTRIBUTES


=head2 Name => Str

An individual label specification.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

