# Generated by default/object.tt
package Paws::LookoutEquipment::InferenceSchedulerSummary;
  use Moose;
  has DataDelayOffsetInMinutes => (is => 'ro', isa => 'Int');
  has DataUploadFrequency => (is => 'ro', isa => 'Str');
  has InferenceSchedulerArn => (is => 'ro', isa => 'Str');
  has InferenceSchedulerName => (is => 'ro', isa => 'Str');
  has ModelArn => (is => 'ro', isa => 'Str');
  has ModelName => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutEquipment::InferenceSchedulerSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutEquipment::InferenceSchedulerSummary object:

  $service_obj->Method(Att1 => { DataDelayOffsetInMinutes => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutEquipment::InferenceSchedulerSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->DataDelayOffsetInMinutes

=head1 DESCRIPTION

Contains information about the specific inference scheduler, including
data delay offset, model name and ARN, status, and so on.

=head1 ATTRIBUTES


=head2 DataDelayOffsetInMinutes => Int

E<gt> A period of time (in minutes) by which inference on the data is
delayed after the data starts. For instance, if an offset delay time of
five minutes was selected, inference will not begin on the data until
the first data measurement after the five minute mark. For example, if
five minutes is selected, the inference scheduler will wake up at the
configured frequency with the additional five minute delay time to
check the customer S3 bucket. The customer can upload data at the same
frequency and they don't need to stop and restart the scheduler when
uploading new data.


=head2 DataUploadFrequency => Str

How often data is uploaded to the source S3 bucket for the input data.
This value is the length of time between data uploads. For instance, if
you select 5 minutes, Amazon Lookout for Equipment will upload the
real-time data to the source bucket once every 5 minutes. This
frequency also determines how often Amazon Lookout for Equipment starts
a scheduled inference on your data. In this example, it starts once
every 5 minutes.


=head2 InferenceSchedulerArn => Str

The Amazon Resource Name (ARN) of the inference scheduler.


=head2 InferenceSchedulerName => Str

The name of the inference scheduler.


=head2 ModelArn => Str

The Amazon Resource Name (ARN) of the ML model used by the inference
scheduler.


=head2 ModelName => Str

The name of the ML model used for the inference scheduler.


=head2 Status => Str

Indicates the status of the inference scheduler.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutEquipment>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

