#!/usr/bin/perl -w
#
#    decimalFormatSymbols.pl
#
#    $Id: decimalFormatSymbols.pl,v 1.3 2002/06/30 04:39:05 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;
use strict;

use POSIX qw(locale_h errno strftime);
#use Time::Local;
use utf8;

use ExtUtils::testlib;
use ICU qw(U_ZERO_ERROR); 
use ICU::DecimalFormatSymbols;
use ICU::Locale;

my $status = U_ZERO_ERROR;
my $dfs = new ICU::DecimalFormatSymbols();
my $en_l = new ICU::Locale('en_US');
my $dfs_en = new ICU::DecimalFormatSymbols($en_l, \$status);
my $dfs_dup = new ICU::DecimalFormatSymbols($dfs);
$dfs_dup = undef;

print "<pre>\n";
show_decimalFormatSymbols('en_US');
show_decimalFormatSymbols('de_DE');
show_decimalFormatSymbols('fr_FR');
show_decimalFormatSymbols('ja_JP');

sub show_decimalFormatSymbols {
    my ($locale_str) = @_;

    my $locale = new ICU::Locale($locale_str);
    $status = U_ZERO_ERROR;
    my $dfs = new ICU::DecimalFormatSymbols($locale, \$status);

    # decimal separator
    my $decimal_sep = $dfs->getSymbol(kDecimalSeparatorSymbol);
    print "$locale_str decimal separator = $decimal_sep\n";
}
print "done\n";
print "</pre>\n";

exit(0);
