#!/usr/bin/perl

package eBay::API::XML::Call::GetAllBidders;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetAllBidders.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetAllBidders

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetAllBidders inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetAllBidders::GetAllBiddersRequestType;
use eBay::API::XML::Call::GetAllBidders::GetAllBiddersResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetAllBidders';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetAllBidders::GetAllBiddersRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetAllBidders::GetAllBiddersResponseType';
}

#
# input properties
#

=head2 setCallMode()

Specifies which bidder information to return.

  RequiredInput: Yes
#    Argument: 'ns:GetAllBiddersModeCodeType'

=cut
       
sub setCallMode {
   my $self   = shift;
   my $sCallMode = shift;
   $self->getRequestDataType()->setCallMode($sCallMode);
}

=head2 setIncludeBiddingSummary()

Specifies whether return BiddingSummary container for each offer.

  RequiredInput: Conditionally
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeBiddingSummary {
   my $self   = shift;
   my $sIncludeBiddingSummary = shift;
   $self->getRequestDataType()->setIncludeBiddingSummary($sIncludeBiddingSummary);
}

=head2 setItemID()

The item ID for which to retrieve the list of bidders.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}



#
# output properties
#

=head2 getBidArray()

Contains a list of OfferType objects. Each
OfferType object represents the data for one bidder and bid.

  Returned: Always
#    Returns: 'ns:OfferArrayType'

=cut
       
sub getBidArray {
   my $self = shift;
   return $self->getResponseDataType()->getBidArray();
}

=head2 getHighBidder()

eBay user ID for the user with the highest bid (or the earliest timestamp, in the event of a tie); a second chance offer candidate.

  Returned: Always
#    Returns: 'ns:UserIDType'

=cut
       
sub getHighBidder {
   my $self = shift;
   return $self->getResponseDataType()->getHighBidder();
}

=head2 getHighestBid()

Bid amount offered by the HighBidder.

  Returned: Always
#    Returns: 'ns:AmountType'

=cut
       
sub getHighestBid {
   my $self = shift;
   return $self->getResponseDataType()->getHighestBid();
}

=head2 getListingStatus()

Specifies an active or ended listing's status in eBay's processing workflow.
If a listing ends with a sale (or sales), eBay needs to update the sale details (e.g., winning bidder) and other information. This processing
can take several minutes. If you retrieve a sold item, use this listing status information to determine whether eBay has finished processing the listing so that you can be sure the winning bidder and other details are correct and complete.

  Returned: Always
#    Returns: 'ns:ListingStatusCodeType'

=cut
       
sub getListingStatus {
   my $self = shift;
   return $self->getResponseDataType()->getListingStatus();
}





1;   
