# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Games-Dice-Probability.t.22-stoopid.t'

#########################

use strict;
use warnings;
use Test;

my $diceobj;

BEGIN { plan tests => 11690 };

INIT {
    use Games::Dice::Probability;

    $diceobj = Games::Dice::Probability->new("2d6+3d10*5d4*(3d4+2d10)");
}

# Confirm objects were created.
ok($diceobj->isa("Games::Dice::Probability"),1);

# Confirm attributes.
ok($diceobj->min(),77);
ok($diceobj->max(),19212);
ok($diceobj->bounds()->[0],77);
ok($diceobj->bounds()->[1],19212);
ok($diceobj->probability(77),4.23855251736111e-12);
ok($diceobj->probability(78),8.47710503472222e-12);
ok($diceobj->probability(79),1.27156575520833e-11);
ok($diceobj->probability(80),1.69542100694444e-11);
ok($diceobj->probability(81),2.11927625868056e-11);
ok($diceobj->probability(82),2.54313151041667e-11);
ok($diceobj->probability(83),2.11927625868056e-11);
ok($diceobj->probability(84),1.69542100694444e-11);
ok($diceobj->probability(85),1.27156575520833e-11);
ok($diceobj->probability(86),8.47710503472222e-12);
ok($diceobj->probability(87),4.23855251736111e-12);
ok($diceobj->probability(92),4.23855251736111e-11);
ok($diceobj->probability(93),8.47710503472222e-11);
ok($diceobj->probability(94),1.27156575520833e-10);
ok($diceobj->probability(95),1.69542100694444e-10);
ok($diceobj->probability(96),2.11927625868056e-10);
ok($diceobj->probability(97),2.54313151041667e-10);
ok($diceobj->probability(98),2.11927625868056e-10);
ok($diceobj->probability(99),1.69542100694444e-10);
ok($diceobj->probability(100),1.27156575520833e-10);
ok($diceobj->probability(101),8.47710503472222e-11);
ok($diceobj->probability(102),5.51011827256944e-11);
ok($diceobj->probability(103),2.54313151041667e-11);
ok($diceobj->probability(104),3.814697265625e-11);
ok($diceobj->probability(105),5.08626302083333e-11);
ok($diceobj->probability(106),6.35782877604167e-11);
ok($diceobj->probability(107),2.03450520833333e-10);
ok($diceobj->probability(108),3.17891438802083e-10);
ok($diceobj->probability(109),4.32332356770833e-10);
ok($diceobj->probability(110),6.52737087673611e-10);
ok($diceobj->probability(111),8.73141818576389e-10);
ok($diceobj->probability(112),1.09354654947917e-09);
ok($diceobj->probability(113),1.05963812934028e-09);
ok($diceobj->probability(114),1.03844536675347e-09);
ok($diceobj->probability(115),1.01725260416667e-09);
ok($diceobj->probability(116),7.84132215711806e-10);
ok($diceobj->probability(117),5.51011827256944e-10);
ok($diceobj->probability(118),3.17891438802083e-10);
ok($diceobj->probability(119),2.11927625868056e-10);
ok($diceobj->probability(120),1.05963812934028e-10);
ok($diceobj->probability(122),4.23855251736111e-10);
ok($diceobj->probability(123),8.47710503472222e-10);
ok($diceobj->probability(124),1.27156575520833e-09);
ok($diceobj->probability(125),1.69542100694444e-09);
ok($diceobj->probability(126),2.11927625868056e-09);
ok($diceobj->probability(127),2.56856282552083e-09);
ok($diceobj->probability(128),2.80592176649306e-09);
ok($diceobj->probability(129),3.04328070746528e-09);
ok($diceobj->probability(130),3.2806396484375e-09);
ok($diceobj->probability(131),3.51799858940972e-09);
ok($diceobj->probability(132),3.75535753038194e-09);
ok($diceobj->probability(133),3.94185384114583e-09);
ok($diceobj->probability(134),3.2806396484375e-09);
ok($diceobj->probability(135),2.61942545572917e-09);
ok($diceobj->probability(136),1.95821126302083e-09);
ok($diceobj->probability(137),1.85648600260417e-09);
ok($diceobj->probability(138),1.7547607421875e-09);
ok($diceobj->probability(139),1.678466796875e-09);
ok($diceobj->probability(140),2.23795572916667e-09);
ok($diceobj->probability(141),2.79744466145833e-09);
ok($diceobj->probability(142),3.7384033203125e-09);
ok($diceobj->probability(143),3.56038411458333e-09);
ok($diceobj->probability(144),3.38236490885417e-09);
ok($diceobj->probability(145),3.204345703125e-09);
ok($diceobj->probability(146),4.82771131727431e-09);
ok($diceobj->probability(147),6.45107693142361e-09);
ok($diceobj->probability(148),7.31150309244792e-09);
ok($diceobj->probability(149),9.68509250217014e-09);
ok($diceobj->probability(150),1.20586819118924e-08);
ok($diceobj->probability(151),1.44322713216146e-08);
ok($diceobj->probability(152),1.43983629014757e-08);
ok($diceobj->probability(153),1.43644544813368e-08);
ok($diceobj->probability(154),1.47120157877604e-08);
ok($diceobj->probability(155),1.31522284613715e-08);
ok($diceobj->probability(156),1.15924411349826e-08);
ok($diceobj->probability(157),1.00326538085937e-08);
ok($diceobj->probability(158),7.88370768229167e-09);
ok($diceobj->probability(159),5.73476155598958e-09);
ok($diceobj->probability(160),3.5858154296875e-09);
ok($diceobj->probability(161),2.39054361979167e-09);
ok($diceobj->probability(162),2.08536783854167e-09);
ok($diceobj->probability(163),1.78019205729167e-09);
ok($diceobj->probability(164),5.46773274739583e-09);
ok($diceobj->probability(165),9.1552734375e-09);
ok($diceobj->probability(166),1.28428141276042e-08);
ok($diceobj->probability(167),1.78019205729167e-08);
ok($diceobj->probability(168),2.09808349609375e-08);
ok($diceobj->probability(169),2.41597493489583e-08);
ok($diceobj->probability(170),2.81016031901042e-08);
ok($diceobj->probability(171),3.204345703125e-08);
ok($diceobj->probability(172),3.59853108723958e-08);
ok($diceobj->probability(173),3.7384033203125e-08);
ok($diceobj->probability(174),3.96728515625e-08);
ok($diceobj->probability(175),4.1961669921875e-08);
ok($diceobj->probability(176),3.4332275390625e-08);
ok($diceobj->probability(177),2.75293986002604e-08);
ok($diceobj->probability(178),2.07265218098958e-08);
ok($diceobj->probability(179),1.51952107747396e-08);
ok($diceobj->probability(180),9.66389973958333e-09);
ok($diceobj->probability(181),4.13258870442708e-09);
ok($diceobj->probability(182),1.38007269965278e-08);
ok($diceobj->probability(183),2.18158298068576e-08);
ok($diceobj->probability(184),2.98309326171875e-08);
ok($diceobj->probability(185),3.78460354275174e-08);
ok($diceobj->probability(186),4.58611382378472e-08);
ok($diceobj->probability(187),5.38762410481771e-08);
ok($diceobj->probability(188),4.42081027560764e-08);
ok($diceobj->probability(189),3.53664822048611e-08);
ok($diceobj->probability(190),2.65248616536458e-08);
ok($diceobj->probability(191),2.60755750868056e-08);
ok($diceobj->probability(192),2.56262885199653e-08);
ok($diceobj->probability(193),2.5177001953125e-08);
ok($diceobj->probability(194),4.32120429144965e-08);
ok($diceobj->probability(195),6.12470838758681e-08);
ok($diceobj->probability(196),7.92821248372396e-08);
ok($diceobj->probability(197),8.24101765950521e-08);
ok($diceobj->probability(198),8.83992513020833e-08);
ok($diceobj->probability(199),9.43883260091146e-08);
ok($diceobj->probability(200),8.74498155381944e-08);
ok($diceobj->probability(201),8.05113050672743e-08);
ok($diceobj->probability(202),7.81377156575521e-08);
ok($diceobj->probability(203),8.04011027018229e-08);
ok($diceobj->probability(204),7.69424438476563e-08);
ok($diceobj->probability(205),7.34837849934896e-08);
ok($diceobj->probability(206),6.69521755642361e-08);
ok($diceobj->probability(207),6.04205661349826e-08);
ok($diceobj->probability(208),4.47591145833333e-08);
ok($diceobj->probability(209),3.0975341796875e-08);
ok($diceobj->probability(210),2.00525919596354e-08);
ok($diceobj->probability(211),9.12984212239583e-09);
ok($diceobj->probability(212),2.58297390407986e-08);
ok($diceobj->probability(213),4.25296359592014e-08);
ok($diceobj->probability(214),6.37944539388021e-08);
ok($diceobj->probability(215),8.50592719184028e-08);
ok($diceobj->probability(216),1.06324089898003e-07);
ok($diceobj->probability(217),1.27588907877604e-07);
ok($diceobj->probability(218),1.43411424424913e-07);
ok($diceobj->probability(219),1.59233940972222e-07);
ok($diceobj->probability(220),1.75056457519531e-07);
ok($diceobj->probability(221),1.9087897406684e-07);
ok($diceobj->probability(222),2.10516187879774e-07);
ok($diceobj->probability(223),2.30153401692708e-07);
ok($diceobj->probability(224),1.96880764431424e-07);
ok($diceobj->probability(225),1.63608127170139e-07);
ok($diceobj->probability(226),1.43686930338542e-07);
ok($diceobj->probability(227),1.29424201117622e-07);
ok($diceobj->probability(228),1.07532077365451e-07);
ok($diceobj->probability(229),8.56399536132813e-08);
ok($diceobj->probability(230),1.00835164388021e-07);
ok($diceobj->probability(231),1.1603037516276e-07);
ok($diceobj->probability(232),1.04522705078125e-07);
ok($diceobj->probability(233),1.0077158610026e-07);
ok($diceobj->probability(234),1.00835164388021e-07);
ok($diceobj->probability(235),1.00898742675781e-07);
ok($diceobj->probability(236),1.10350714789497e-07);
ok($diceobj->probability(237),1.19802686903212e-07);
ok($diceobj->probability(238),1.42606099446615e-07);
ok($diceobj->probability(239),1.32921006944444e-07);
ok($diceobj->probability(240),1.23235914442274e-07);
ok($diceobj->probability(241),1.13550821940104e-07);
ok($diceobj->probability(242),1.49875217013889e-07);
ok($diceobj->probability(243),1.86199612087674e-07);
ok($diceobj->probability(244),2.22524007161458e-07);
ok($diceobj->probability(245),2.96380784776476e-07);
ok($diceobj->probability(246),3.70237562391493e-07);
ok($diceobj->probability(247),4.5172373453776e-07);
ok($diceobj->probability(248),4.13025750054253e-07);
ok($diceobj->probability(249),3.74327765570747e-07);
ok($diceobj->probability(250),3.3562978108724e-07);
ok($diceobj->probability(251),2.60014004177517e-07);
ok($diceobj->probability(252),1.89942253960503e-07);
ok($diceobj->probability(253),1.0461171468099e-07);
ok($diceobj->probability(254),1.5167236328125e-07);
ok($diceobj->probability(255),1.9873301188151e-07);
ok($diceobj->probability(256),2.45793660481771e-07);
ok($diceobj->probability(257),3.1364017062717e-07);
ok($diceobj->probability(258),3.85975307888455e-07);
ok($diceobj->probability(259),4.6593983968099e-07);
ok($diceobj->probability(260),4.10694546169705e-07);
ok($diceobj->probability(261),3.5544925265842e-07);
ok($diceobj->probability(262),3.05836995442708e-07);
ok($diceobj->probability(263),2.51570807562934e-07);
ok($diceobj->probability(264),1.71695285373264e-07);
ok($diceobj->probability(265),9.18197631835938e-08);
ok($diceobj->probability(266),1.4312744140625e-07);
ok($diceobj->probability(267),1.94435119628906e-07);
ok($diceobj->probability(268),2.34476725260417e-07);
ok($diceobj->probability(269),2.76845296223958e-07);
ok($diceobj->probability(270),3.34790547688802e-07);
ok($diceobj->probability(271),3.92735799153646e-07);
ok($diceobj->probability(272),4.19612460666233e-07);
ok($diceobj->probability(273),4.46489122178819e-07);
ok($diceobj->probability(274),4.78998819986979e-07);
ok($diceobj->probability(275),5.39673699273003e-07);
ok($diceobj->probability(276),6.00348578559028e-07);
ok($diceobj->probability(277),6.68843587239583e-07);
ok($diceobj->probability(278),6.08740912543403e-07);
ok($diceobj->probability(279),5.48638237847222e-07);
ok($diceobj->probability(280),4.88535563151042e-07);
ok($diceobj->probability(281),3.72102525499132e-07);
ok($diceobj->probability(282),3.36121453179253e-07);
ok($diceobj->probability(283),2.84500122070312e-07);
ok($diceobj->probability(284),3.28966776529948e-07);
ok($diceobj->probability(285),3.73433430989583e-07);
ok($diceobj->probability(286),4.17900085449219e-07);
ok($diceobj->probability(287),4.92833455403646e-07);
ok($diceobj->probability(288),4.0686289469401e-07);
ok($diceobj->probability(289),3.28712463378906e-07);
ok($diceobj->probability(290),4.18239169650608e-07);
ok($diceobj->probability(291),5.07765875922309e-07);
ok($diceobj->probability(292),5.9729258219401e-07);
ok($diceobj->probability(293),6.82216220431858e-07);
ok($diceobj->probability(294),8.47591824001736e-07);
ok($diceobj->probability(295),1.01296742757161e-06);
ok($diceobj->probability(296),8.9302486843533e-07);
ok($diceobj->probability(297),7.73082309299045e-07);
ok($diceobj->probability(298),6.5313975016276e-07);
ok($diceobj->probability(299),6.19294908311632e-07);
ok($diceobj->probability(300),5.85450066460504e-07);
ok($diceobj->probability(301),5.51605224609375e-07);
ok($diceobj->probability(302),6.88980950249566e-07);
ok($diceobj->probability(303),8.26356675889757e-07);
ok($diceobj->probability(304),9.63732401529948e-07);
ok($diceobj->probability(305),9.33515760633681e-07);
ok($diceobj->probability(306),9.03299119737413e-07);
ok($diceobj->probability(307),8.73082478841146e-07);
ok($diceobj->probability(308),6.97305467393663e-07);
ok($diceobj->probability(309),5.21528455946181e-07);
ok($diceobj->probability(310),4.02971903483073e-07);
ok($diceobj->probability(311),3.68211534288194e-07);
ok($diceobj->probability(312),3.33451165093316e-07);
ok($diceobj->probability(313),2.98690795898437e-07);
ok($diceobj->probability(314),4.38160366482205e-07);
ok($diceobj->probability(315),5.77629937065972e-07);
ok($diceobj->probability(316),6.0265858968099e-07);
ok($diceobj->probability(317),7.2472890218099e-07);
ok($diceobj->probability(318),8.4679921468099e-07);
ok($diceobj->probability(319),9.6886952718099e-07);
ok($diceobj->probability(320),9.14806789822049e-07);
ok($diceobj->probability(321),8.60744052463108e-07);
ok($diceobj->probability(322),1.00243886311849e-06);
ok($diceobj->probability(323),9.50050354003906e-07);
ok($diceobj->probability(324),8.97661844889323e-07);
ok($diceobj->probability(325),8.4527333577474e-07);
ok($diceobj->probability(326),1.09081268310547e-06);
ok($diceobj->probability(327),1.34788513183594e-06);
ok($diceobj->probability(328),1.32788340250651e-06);
ok($diceobj->probability(329),1.40492333306207e-06);
ok($diceobj->probability(330),1.48196326361762e-06);
ok($diceobj->probability(331),1.55900319417318e-06);
ok($diceobj->probability(332),1.41663021511502e-06);
ok($diceobj->probability(333),1.25119103325738e-06);
ok($diceobj->probability(334),1.22428894042969e-06);
ok($diceobj->probability(335),1.197386847602e-06);
ok($diceobj->probability(336),1.17048475477431e-06);
ok($diceobj->probability(337),1.14358266194661e-06);
ok($diceobj->probability(338),1.23318566216363e-06);
ok($diceobj->probability(339),1.33432176378038e-06);
ok($diceobj->probability(340),1.43545786539714e-06);
ok($diceobj->probability(341),1.53659396701389e-06);
ok($diceobj->probability(342),1.64471096462674e-06);
ok($diceobj->probability(343),1.75282796223958e-06);
ok($diceobj->probability(344),1.48150549994575e-06);
ok($diceobj->probability(345),1.224488152398e-06);
ok($diceobj->probability(346),9.6747080485026e-07);
ok($diceobj->probability(347),7.11945427788628e-07);
ok($diceobj->probability(348),4.42458258734809e-07);
ok($diceobj->probability(349),1.7297108968099e-07);
ok($diceobj->probability(350),1.70279608832465e-07);
ok($diceobj->probability(351),1.38977898491753e-07);
ok($diceobj->probability(352),2.19281514485677e-07);
ok($diceobj->probability(353),4.19964260525174e-07);
ok($diceobj->probability(354),7.61142306857639e-07);
ok($diceobj->probability(355),1.1023203531901e-06);
ok($diceobj->probability(356),1.4550060696072e-06);
ok($diceobj->probability(357),1.8219969007704e-06);
ok($diceobj->probability(358),1.96577707926432e-06);
ok($diceobj->probability(359),1.89922756618924e-06);
ok($diceobj->probability(360),1.5656492445204e-06);
ok($diceobj->probability(361),1.23207092285156e-06);
ok($diceobj->probability(362),1.62688785129123e-06);
ok($diceobj->probability(363),2.0217047797309e-06);
ok($diceobj->probability(364),2.52812703450521e-06);
ok($diceobj->probability(365),3.18251715766059e-06);
ok($diceobj->probability(366),4.05491722954644e-06);
ok($diceobj->probability(367),4.92731730143229e-06);
ok($diceobj->probability(368),4.34292687310113e-06);
ok($diceobj->probability(369),3.75853644476997e-06);
ok($diceobj->probability(370),3.1741460164388e-06);
ok($diceobj->probability(371),2.43583255343967e-06);
ok($diceobj->probability(372),1.52852800157335e-06);
ok($diceobj->probability(373),6.21223449707031e-07);
ok($diceobj->probability(374),4.42314147949219e-07);
ok($diceobj->probability(375),2.63404846191406e-07);
ok($diceobj->probability(376),8.44955444335937e-08);
ok($diceobj->probability(377),1.43602159288194e-08);
ok($diceobj->probability(378),2.87204318576389e-08);
ok($diceobj->probability(379),4.30806477864583e-08);
ok($diceobj->probability(380),3.81562974717882e-07);
ok($diceobj->probability(381),7.20045301649306e-07);
ok($diceobj->probability(382),1.06543223063151e-06);
ok($diceobj->probability(383),1.38209872775608e-06);
ok($diceobj->probability(384),1.69876522488064e-06);
ok($diceobj->probability(385),2.01543172200521e-06);
ok($diceobj->probability(386),2.04942915174696e-06);
ok($diceobj->probability(387),2.22266303168403e-06);
ok($diceobj->probability(388),2.38208770751953e-06);
ok($diceobj->probability(389),2.55587259928385e-06);
ok($diceobj->probability(390),2.72965749104818e-06);
ok($diceobj->probability(391),2.9034423828125e-06);
ok($diceobj->probability(392),2.94489118787977e-06);
ok($diceobj->probability(393),2.70786709255642e-06);
ok($diceobj->probability(394),2.65741984049479e-06);
ok($diceobj->probability(395),2.60697258843316e-06);
ok($diceobj->probability(396),2.55652533637153e-06);
ok($diceobj->probability(397),2.5060780843099e-06);
ok($diceobj->probability(398),2.83747778998481e-06);
ok($diceobj->probability(399),3.30811394585503e-06);
ok($diceobj->probability(400),3.41940561930339e-06);
ok($diceobj->probability(401),3.56522030300564e-06);
ok($diceobj->probability(402),4.09231397840712e-06);
ok($diceobj->probability(403),4.61940765380859e-06);
ok($diceobj->probability(404),4.28988138834635e-06);
ok($diceobj->probability(405),3.96035512288411e-06);
ok($diceobj->probability(406),3.81050109863281e-06);
ok($diceobj->probability(407),3.86123233371311e-06);
ok($diceobj->probability(408),3.14940558539497e-06);
ok($diceobj->probability(409),2.43757883707682e-06);
ok($diceobj->probability(410),2.40775638156467e-06);
ok($diceobj->probability(411),2.37793392605252e-06);
ok($diceobj->probability(412),2.34811147054036e-06);
ok($diceobj->probability(413),1.8135494656033e-06);
ok($diceobj->probability(414),1.66026645236545e-06);
ok($diceobj->probability(415),1.5069834391276e-06);
ok($diceobj->probability(416),1.12846374511719e-06);
ok($diceobj->probability(417),7.49944051106771e-07);
ok($diceobj->probability(418),5.68580627441406e-07);
ok($diceobj->probability(419),6.56848483615451e-07);
ok($diceobj->probability(420),7.45116339789496e-07);
ok($diceobj->probability(421),8.33384195963542e-07);
ok($diceobj->probability(422),1.86118655734592e-06);
ok($diceobj->probability(423),2.8889889187283e-06);
ok($diceobj->probability(424),3.52247873942057e-06);
ok($diceobj->probability(425),4.15596856011285e-06);
ok($diceobj->probability(426),4.78945838080512e-06);
ok($diceobj->probability(427),5.43722788492839e-06);
ok($diceobj->probability(428),4.41624535454644e-06);
ok($diceobj->probability(429),3.3952628241645e-06);
ok($diceobj->probability(430),2.5714365641276e-06);
ok($diceobj->probability(431),2.02080620659722e-06);
ok($diceobj->probability(432),1.47017584906684e-06);
ok($diceobj->probability(433),8.90986124674479e-07);
ok($diceobj->probability(434),2.26945241292318e-06);
ok($diceobj->probability(435),3.64791870117188e-06);
ok($diceobj->probability(436),5.02638498942057e-06);
ok($diceobj->probability(437),5.85860782199436e-06);
ok($diceobj->probability(438),6.69083065456814e-06);
ok($diceobj->probability(439),7.53733317057292e-06);
ok($diceobj->probability(440),6.14473554823134e-06);
ok($diceobj->probability(441),4.75213792588976e-06);
ok($diceobj->probability(442),4.07433827718099e-06);
ok($diceobj->probability(443),3.85190751817491e-06);
ok($diceobj->probability(444),3.62947675916884e-06);
ok($diceobj->probability(445),3.40704600016276e-06);
ok($diceobj->probability(446),4.30416531032986e-06);
ok($diceobj->probability(447),5.20128462049696e-06);
ok($diceobj->probability(448),4.66880798339844e-06);
ok($diceobj->probability(449),3.77154032389323e-06);
ok($diceobj->probability(450),3.36439768473307e-06);
ok($diceobj->probability(451),2.95725504557292e-06);
ok($diceobj->probability(452),3.28535715738932e-06);
ok($diceobj->probability(453),3.61345926920573e-06);
ok($diceobj->probability(454),4.65635935465495e-06);
ok($diceobj->probability(455),5.88172912597656e-06);
ok($diceobj->probability(456),6.12684885660807e-06);
ok($diceobj->probability(457),6.57713572184245e-06);
ok($diceobj->probability(458),5.67200978597005e-06);
ok($diceobj->probability(459),4.76688385009766e-06);
ok($diceobj->probability(460),3.86175791422526e-06);
ok($diceobj->probability(461),3.10818142361111e-06);
ok($diceobj->probability(462),2.84920586480035e-06);
ok($diceobj->probability(463),2.17989603678385e-06);
ok($diceobj->probability(464),2.65254126654731e-06);
ok($diceobj->probability(465),3.12518649631076e-06);
ok($diceobj->probability(466),3.59783172607422e-06);
ok($diceobj->probability(467),3.76739925808377e-06);
ok($diceobj->probability(468),3.92801496717665e-06);
ok($diceobj->probability(469),4.2937978108724e-06);
ok($diceobj->probability(470),4.31210411919488e-06);
ok($diceobj->probability(471),4.33041042751736e-06);
ok($diceobj->probability(472),4.34871673583984e-06);
ok($diceobj->probability(473),4.5185301038954e-06);
ok($diceobj->probability(474),4.69281938340929e-06);
ok($diceobj->probability(475),4.86710866292318e-06);
ok($diceobj->probability(476),4.05591328938802e-06);
ok($diceobj->probability(477),3.25881958007813e-06);
ok($diceobj->probability(478),2.56643931070964e-06);
ok($diceobj->probability(479),1.87408023410373e-06);
ok($diceobj->probability(480),1.18172115749783e-06);
ok($diceobj->probability(481),4.89362080891927e-07);
ok($diceobj->probability(482),2.63422648111979e-06);
ok($diceobj->probability(483),4.75088755289714e-06);
ok($diceobj->probability(484),6.65812174479167e-06);
ok($diceobj->probability(485),8.58773549397786e-06);
ok($diceobj->probability(486),1.08005905151367e-05);
ok($diceobj->probability(487),1.30134455362956e-05);
ok($diceobj->probability(488),1.15919537014431e-05);
ok($diceobj->probability(489),1.0184563530816e-05);
ok($diceobj->probability(490),8.88188680013021e-06);
ok($diceobj->probability(491),7.53445095486111e-06);
ok($diceobj->probability(492),6.08255598280165e-06);
ok($diceobj->probability(493),4.63066101074219e-06);
ok($diceobj->probability(494),4.3693118625217e-06);
ok($diceobj->probability(495),4.10796271430122e-06);
ok($diceobj->probability(496),3.84661356608073e-06);
ok($diceobj->probability(497),4.47873009575738e-06);
ok($diceobj->probability(498),4.47004106309679e-06);
ok($diceobj->probability(499),4.4613520304362e-06);
ok($diceobj->probability(500),4.87041473388672e-06);
ok($diceobj->probability(501),5.27947743733724e-06);
ok($diceobj->probability(502),6.02222442626953e-06);
ok($diceobj->probability(503),5.02279917399089e-06);
ok($diceobj->probability(504),4.48539733886719e-06);
ok($diceobj->probability(505),3.94799550374349e-06);
ok($diceobj->probability(506),5.50382402208116e-06);
ok($diceobj->probability(507),7.05965254041884e-06);
ok($diceobj->probability(508),7.94811248779297e-06);
ok($diceobj->probability(509),9.89686754014757e-06);
ok($diceobj->probability(510),1.18456225925022e-05);
ok($diceobj->probability(511),1.37943776448568e-05);
ok($diceobj->probability(512),1.18894365098741e-05);
ok($diceobj->probability(513),9.98449537489149e-06);
ok($diceobj->probability(514),8.7603759765625e-06);
ok($diceobj->probability(515),7.30748070610894e-06);
ok($diceobj->probability(516),5.85458543565538e-06);
ok($diceobj->probability(517),4.40169016520182e-06);
ok($diceobj->probability(518),4.37649620903863e-06);
ok($diceobj->probability(519),4.35130225287543e-06);
ok($diceobj->probability(520),3.63183339436849e-06);
ok($diceobj->probability(521),2.80228932698568e-06);
ok($diceobj->probability(522),3.01592508951823e-06);
ok($diceobj->probability(523),3.22956085205078e-06);
ok($diceobj->probability(524),3.77670288085938e-06);
ok($diceobj->probability(525),4.32384490966797e-06);
ok($diceobj->probability(526),5.21812438964844e-06);
ok($diceobj->probability(527),6.52701907687717e-06);
ok($diceobj->probability(528),5.74955410427517e-06);
ok($diceobj->probability(529),4.97208913167318e-06);
ok($diceobj->probability(530),5.95203399658203e-06);
ok($diceobj->probability(531),6.93197886149089e-06);
ok($diceobj->probability(532),7.91192372639974e-06);
ok($diceobj->probability(533),8.36192237006293e-06);
ok($diceobj->probability(534),9.95866987440321e-06);
ok($diceobj->probability(535),1.15554173787435e-05);
ok($diceobj->probability(536),9.63511996799045e-06);
ok($diceobj->probability(537),7.71482255723741e-06);
ok($diceobj->probability(538),5.79452514648437e-06);
ok($diceobj->probability(539),4.13920084635417e-06);
ok($diceobj->probability(540),2.27673848470052e-06);
ok($diceobj->probability(541),7.43293762207031e-07);
ok($diceobj->probability(542),3.89105055067274e-06);
ok($diceobj->probability(543),7.03880733913846e-06);
ok($diceobj->probability(544),1.01865641276042e-05);
ok($diceobj->probability(545),1.33343209160699e-05);
ok($diceobj->probability(546),1.68299780951606e-05);
ok($diceobj->probability(547),1.9667599995931e-05);
ok($diceobj->probability(548),1.75296783447266e-05);
ok($diceobj->probability(549),1.53917566935221e-05);
ok($diceobj->probability(550),1.32538350423177e-05);
ok($diceobj->probability(551),1.11159133911133e-05);
ok($diceobj->probability(552),9.3911616007487e-06);
ok($diceobj->probability(553),7.99542744954427e-06);
ok($diceobj->probability(554),7.85845438639323e-06);
ok($diceobj->probability(555),7.72148132324219e-06);
ok($diceobj->probability(556),7.58450826009115e-06);
ok($diceobj->probability(557),7.4475351969401e-06);
ok($diceobj->probability(558),5.75122833251953e-06);
ok($diceobj->probability(559),4.05492146809896e-06);
ok($diceobj->probability(560),3.07859632703993e-06);
ok($diceobj->probability(561),2.1022711859809e-06);
ok($diceobj->probability(562),3.52759043375651e-06);
ok($diceobj->probability(563),5.27150048149957e-06);
ok($diceobj->probability(564),7.91724310980903e-06);
ok($diceobj->probability(565),1.05629857381185e-05);
ok($diceobj->probability(566),1.32831149631076e-05);
ok($diceobj->probability(567),1.60032441880968e-05);
ok($diceobj->probability(568),1.39200846354167e-05);
ok($diceobj->probability(569),1.18481572469076e-05);
ok($diceobj->probability(570),9.77622985839844e-06);
ok($diceobj->probability(571),7.70430246988932e-06);
ok($diceobj->probability(572),5.96013387044271e-06);
ok($diceobj->probability(573),4.21596527099609e-06);
ok($diceobj->probability(574),5.69302876790365e-06);
ok($diceobj->probability(575),6.19185553656684e-06);
ok($diceobj->probability(576),6.69068230523003e-06);
ok($diceobj->probability(577),7.19861348470052e-06);
ok($diceobj->probability(578),1.01088460286458e-05);
ok($diceobj->probability(579),1.30190785725911e-05);
ok($diceobj->probability(580),1.42901357014974e-05);
ok($diceobj->probability(581),1.62096065945096e-05);
ok($diceobj->probability(582),1.8129522535536e-05);
ok($diceobj->probability(583),2.00312296549479e-05);
ok($diceobj->probability(584),1.61453755696615e-05);
ok($diceobj->probability(585),1.2259521484375e-05);
ok($diceobj->probability(586),9.19325510660807e-06);
ok($diceobj->probability(587),7.3502688937717e-06);
ok($diceobj->probability(588),5.50639258490668e-06);
ok($diceobj->probability(589),3.67162068684896e-06);
ok($diceobj->probability(590),6.11293368869358e-06);
ok($diceobj->probability(591),8.55424669053819e-06);
ok($diceobj->probability(592),1.09955596923828e-05);
ok($diceobj->probability(593),1.09903123643663e-05);
ok($diceobj->probability(594),1.09855100843641e-05);
ok($diceobj->probability(595),1.0980707804362e-05);
ok($diceobj->probability(596),1.01132117377387e-05);
ok($diceobj->probability(597),9.4995837741428e-06);
ok($diceobj->probability(598),8.88595581054688e-06);
ok($diceobj->probability(599),9.49560801188151e-06);
ok($diceobj->probability(600),1.01052602132161e-05);
ok($diceobj->probability(601),1.07149124145508e-05);
ok($diceobj->probability(602),1.27202818128798e-05);
ok($diceobj->probability(603),1.42179150051541e-05);
ok($diceobj->probability(604),1.57155481974284e-05);
ok($diceobj->probability(605),1.72131813897027e-05);
ok($diceobj->probability(606),1.8710814581977e-05);
ok($diceobj->probability(607),2.0832150777181e-05);
ok($diceobj->probability(608),1.7876222398546e-05);
ok($diceobj->probability(609),1.51741621229384e-05);
ok($diceobj->probability(610),1.27137629191081e-05);
ok($diceobj->probability(611),1.02555889553494e-05);
ok($diceobj->probability(612),7.79741499159071e-06);
ok($diceobj->probability(613),4.09183502197266e-06);
ok($diceobj->probability(614),4.66202629937066e-06);
ok($diceobj->probability(615),5.23221757676866e-06);
ok($diceobj->probability(616),5.31908671061198e-06);
ok($diceobj->probability(617),5.40150536431207e-06);
ok($diceobj->probability(618),7.71876441107856e-06);
ok($diceobj->probability(619),1.06597264607747e-05);
ok($diceobj->probability(620),1.17006725735135e-05);
ok($diceobj->probability(621),1.27416186862522e-05);
ok($diceobj->probability(622),1.4024289449056e-05);
ok($diceobj->probability(623),1.54061635335286e-05);
ok($diceobj->probability(624),1.23183568318685e-05);
ok($diceobj->probability(625),9.23055013020833e-06);
ok($diceobj->probability(626),9.47473314073351e-06);
ok($diceobj->probability(627),9.72472720675998e-06);
ok($diceobj->probability(628),9.97459411621094e-06);
ok($diceobj->probability(629),1.03418477376302e-05);
ok($diceobj->probability(630),1.29439417521159e-05);
ok($diceobj->probability(631),1.55460357666016e-05);
ok($diceobj->probability(632),1.73256429036458e-05);
ok($diceobj->probability(633),1.90936279296875e-05);
ok($diceobj->probability(634),2.08616765340169e-05);
ok($diceobj->probability(635),2.21040174696181e-05);
ok($diceobj->probability(636),2.33463584052192e-05);
ok($diceobj->probability(637),2.45886993408203e-05);
ok($diceobj->probability(638),2.03300688001845e-05);
ok($diceobj->probability(639),1.65598085191515e-05);
ok($diceobj->probability(640),1.27895482381185e-05);
ok($diceobj->probability(641),9.33063083224826e-06);
ok($diceobj->probability(642),8.18972693549262e-06);
ok($diceobj->probability(643),7.04882303873698e-06);
ok($diceobj->probability(644),9.84939575195313e-06);
ok($diceobj->probability(645),1.16848500569661e-05);
ok($diceobj->probability(646),1.35874430338542e-05);
ok($diceobj->probability(647),1.54900360107422e-05);
ok($diceobj->probability(648),1.2756601969401e-05);
ok($diceobj->probability(649),1.00231679280599e-05);
ok($diceobj->probability(650),1.07180870903863e-05);
ok($diceobj->probability(651),1.18955654568142e-05);
ok($diceobj->probability(652),1.42445246378581e-05);
ok($diceobj->probability(653),1.65938017103407e-05);
ok($diceobj->probability(654),2.12610922919379e-05);
ok($diceobj->probability(655),2.59283828735352e-05);
ok($diceobj->probability(656),2.37389670477973e-05);
ok($diceobj->probability(657),2.15495512220595e-05);
ok($diceobj->probability(658),1.68157577514648e-05);
ok($diceobj->probability(659),1.20813284979926e-05);
ok($diceobj->probability(660),7.3468992445204e-06);
ok($diceobj->probability(661),2.61246999104818e-06);
ok($diceobj->probability(662),6.11097971598307e-06);
ok($diceobj->probability(663),9.60948944091797e-06);
ok($diceobj->probability(664),1.44137573242188e-05);
ok($diceobj->probability(665),1.95987531873915e-05);
ok($diceobj->probability(666),2.47837490505642e-05);
ok($diceobj->probability(667),3.02191797892253e-05);
ok($diceobj->probability(668),2.60454389784071e-05);
ok($diceobj->probability(669),2.1871698167589e-05);
ok($diceobj->probability(670),1.76979573567708e-05);
ok($diceobj->probability(671),1.27633963690864e-05);
ok($diceobj->probability(672),7.82883538140191e-06);
ok($diceobj->probability(673),2.39340464274089e-06);
ok($diceobj->probability(674),6.68402777777778e-06);
ok($diceobj->probability(675),1.09746509128147e-05);
ok($diceobj->probability(676),1.52652740478516e-05);
ok($diceobj->probability(677),2.11368052164714e-05);
ok($diceobj->probability(678),2.75759633382161e-05);
ok($diceobj->probability(679),3.42655563354492e-05);
ok($diceobj->probability(680),3.11122131347656e-05);
ok($diceobj->probability(681),2.7958869934082e-05);
ok($diceobj->probability(682),2.60748291015625e-05);
ok($diceobj->probability(683),2.17897923787435e-05);
ok($diceobj->probability(684),1.63695017496745e-05);
ok($diceobj->probability(685),1.09492111206055e-05);
ok($diceobj->probability(686),1.13799243503147e-05);
ok($diceobj->probability(687),1.18106375800239e-05);
ok($diceobj->probability(688),1.02329889933268e-05);
ok($diceobj->probability(689),9.85583835177951e-06);
ok($diceobj->probability(690),1.00463146633572e-05);
ok($diceobj->probability(691),1.02367909749349e-05);
ok($diceobj->probability(692),8.78008948432075e-06);
ok($diceobj->probability(693),7.3233879937066e-06);
ok($diceobj->probability(694),6.07550303141276e-06);
ok($diceobj->probability(695),7.2652096218533e-06);
ok($diceobj->probability(696),8.45491621229384e-06);
ok($diceobj->probability(697),9.64462280273438e-06);
ok($diceobj->probability(698),1.13474951850043e-05);
ok($diceobj->probability(699),1.30503675672743e-05);
ok($diceobj->probability(700),1.52834828694661e-05);
ok($diceobj->probability(701),1.26414150661892e-05);
ok($diceobj->probability(702),1.29007424248589e-05);
ok($diceobj->probability(703),1.31600697835286e-05);
ok($diceobj->probability(704),1.57064225938585e-05);
ok($diceobj->probability(705),1.82527754041884e-05);
ok($diceobj->probability(706),2.30948130289714e-05);
ok($diceobj->probability(707),3.03744422064887e-05);
ok($diceobj->probability(708),3.18512810601128e-05);
ok($diceobj->probability(709),3.3328119913737e-05);
ok($diceobj->probability(710),3.06324428982205e-05);
ok($diceobj->probability(711),2.7936765882704e-05);
ok($diceobj->probability(712),2.06497192382812e-05);
ok($diceobj->probability(713),1.33626725938585e-05);
ok($diceobj->probability(714),8.97702111138238e-06);
ok($diceobj->probability(715),4.59136962890625e-06);
ok($diceobj->probability(716),3.21326785617405e-06);
ok($diceobj->probability(717),3.63894568549262e-06);
ok($diceobj->probability(718),6.36030832926432e-06);
ok($diceobj->probability(719),9.08167097303602e-06);
ok($diceobj->probability(720),1.18030336168077e-05);
ok($diceobj->probability(721),1.45243962605794e-05);
ok($diceobj->probability(722),2.72923278808594e-05);
ok($diceobj->probability(723),3.64527002970378e-05);
ok($diceobj->probability(724),4.56130727132161e-05);
ok($diceobj->probability(725),5.47734451293945e-05);
ok($diceobj->probability(726),6.39338175455729e-05);
ok($diceobj->probability(727),7.30950927734375e-05);
ok($diceobj->probability(728),6.08776134914822e-05);
ok($diceobj->probability(729),5.04639138115777e-05);
ok($diceobj->probability(730),4.31274668375651e-05);
ok($diceobj->probability(731),3.63384501139323e-05);
ok($diceobj->probability(732),2.95494333902995e-05);
ok($diceobj->probability(733),2.27586110432943e-05);
ok($diceobj->probability(734),2.49152586195204e-05);
ok($diceobj->probability(735),2.70719061957465e-05);
ok($diceobj->probability(736),2.30740483601888e-05);
ok($diceobj->probability(737),1.87582567003038e-05);
ok($diceobj->probability(738),1.45991219414605e-05);
ok($diceobj->probability(739),1.04408899943034e-05);
ok($diceobj->probability(740),7.74979061550564e-06);
ok($diceobj->probability(741),5.0586912367079e-06);
ok($diceobj->probability(742),5.44484456380208e-06);
ok($diceobj->probability(743),5.1841311984592e-06);
ok($diceobj->probability(744),4.61010403103299e-06);
ok($diceobj->probability(745),4.03607686360677e-06);
ok($diceobj->probability(746),3.4631093343099e-06);
ok($diceobj->probability(747),2.89014180501302e-06);
ok($diceobj->probability(748),2.31717427571615e-06);
ok($diceobj->probability(749),1.80202060275608e-06);
ok($diceobj->probability(750),2.39929623074002e-06);
ok($diceobj->probability(751),2.99657185872396e-06);
ok($diceobj->probability(752),5.22014617919922e-06);
ok($diceobj->probability(753),7.44372049967448e-06);
ok($diceobj->probability(754),9.66729482014974e-06);
ok($diceobj->probability(755),1.22504255506727e-05);
ok($diceobj->probability(756),1.29220114813911e-05);
ok($diceobj->probability(757),1.35935974121094e-05);
ok($diceobj->probability(758),1.73190434773763e-05);
ok($diceobj->probability(759),2.10444895426432e-05);
ok($diceobj->probability(760),2.47699356079102e-05);
ok($diceobj->probability(761),2.86967976888021e-05);
ok($diceobj->probability(762),3.48295593261719e-05);
ok($diceobj->probability(763),4.09623209635417e-05);
ok($diceobj->probability(764),3.61042277018229e-05);
ok($diceobj->probability(765),3.12461344401042e-05);
ok($diceobj->probability(766),2.63880411783854e-05);
ok($diceobj->probability(767),2.24249860975477e-05);
ok($diceobj->probability(768),1.5961676703559e-05);
ok($diceobj->probability(769),9.49836730957031e-06);
ok($diceobj->probability(770),1.33273018731011e-05);
ok($diceobj->probability(771),1.71562364366319e-05);
ok($diceobj->probability(772),2.64361826578776e-05);
ok($diceobj->probability(773),3.33218044704861e-05);
ok($diceobj->probability(774),4.14575534396701e-05);
ok($diceobj->probability(775),4.95933024088542e-05);
ok($diceobj->probability(776),4.97638363308377e-05);
ok($diceobj->probability(777),4.99344974093967e-05);
ok($diceobj->probability(778),3.9203135172526e-05);
ok($diceobj->probability(779),2.97696431477865e-05);
ok($diceobj->probability(780),2.03361511230469e-05);
ok($diceobj->probability(781),1.09026590983073e-05);
ok($diceobj->probability(782),1.1885863410102e-05);
ok($diceobj->probability(783),1.28688134087457e-05);
ok($diceobj->probability(784),1.93027750651042e-05);
ok($diceobj->probability(785),2.57463794284397e-05);
ok($diceobj->probability(786),3.54297426011827e-05);
ok($diceobj->probability(787),4.51131057739258e-05);
ok($diceobj->probability(788),4.19282913208008e-05);
ok($diceobj->probability(789),3.87436040242513e-05);
ok($diceobj->probability(790),3.55589167277018e-05);
ok($diceobj->probability(791),3.23549440171984e-05);
ok($diceobj->probability(792),2.26714536878798e-05);
ok($diceobj->probability(793),1.29879633585612e-05);
ok($diceobj->probability(794),1.85356352064345e-05);
ok($diceobj->probability(795),2.40833070543077e-05);
ok($diceobj->probability(796),2.9630978902181e-05);
ok($diceobj->probability(797),3.51882934570312e-05);
ok($diceobj->probability(798),4.39853668212891e-05);
ok($diceobj->probability(799),5.27824401855469e-05);
ok($diceobj->probability(800),4.48623869154188e-05);
ok($diceobj->probability(801),3.69423336452908e-05);
ok($diceobj->probability(802),3.39767328898112e-05);
ok($diceobj->probability(803),3.10111321343316e-05);
ok($diceobj->probability(804),2.8045531378852e-05);
ok($diceobj->probability(805),2.50799306233724e-05);
ok($diceobj->probability(806),2.91573630438911e-05);
ok($diceobj->probability(807),3.33960300021701e-05);
ok($diceobj->probability(808),2.77257919311523e-05);
ok($diceobj->probability(809),2.20555538601345e-05);
ok($diceobj->probability(810),1.63853157891168e-05);
ok($diceobj->probability(811),1.0715077718099e-05);
ok($diceobj->probability(812),1.15318806966146e-05);
ok($diceobj->probability(813),1.20262145996094e-05);
ok($diceobj->probability(814),1.74816767374674e-05);
ok($diceobj->probability(815),2.29371388753255e-05);
ok($diceobj->probability(816),2.83926010131836e-05);
ok($diceobj->probability(817),3.38480631510417e-05);
ok($diceobj->probability(818),3.05780410766602e-05);
ok($diceobj->probability(819),2.74692535400391e-05);
ok($diceobj->probability(820),2.43471145629883e-05);
ok($diceobj->probability(821),2.470154232449e-05);
ok($diceobj->probability(822),2.50559700859918e-05);
ok($diceobj->probability(823),2.54103978474935e-05);
ok($diceobj->probability(824),2.63857311672635e-05);
ok($diceobj->probability(825),2.73610644870334e-05);
ok($diceobj->probability(826),2.83430735270182e-05);
ok($diceobj->probability(827),2.45369169447157e-05);
ok($diceobj->probability(828),2.07307603624132e-05);
ok($diceobj->probability(829),1.69246037801107e-05);
ok($diceobj->probability(830),1.62136077880859e-05);
ok($diceobj->probability(831),1.55026117960612e-05);
ok($diceobj->probability(832),1.47916158040365e-05);
ok($diceobj->probability(833),1.32272508409288e-05);
ok($diceobj->probability(834),1.46078957451714e-05);
ok($diceobj->probability(835),1.65836334228516e-05);
ok($diceobj->probability(836),1.73581653171115e-05);
ok($diceobj->probability(837),1.81326972113715e-05);
ok($diceobj->probability(838),1.98412577311198e-05);
ok($diceobj->probability(839),2.37161636352539e-05);
ok($diceobj->probability(840),2.17010498046875e-05);
ok($diceobj->probability(841),1.84957504272461e-05);
ok($diceobj->probability(842),3.0652109781901e-05);
ok($diceobj->probability(843),4.2808469136556e-05);
ok($diceobj->probability(844),5.30967712402344e-05);
ok($diceobj->probability(845),6.33823182847765e-05);
ok($diceobj->probability(846),7.66128751966688e-05);
ok($diceobj->probability(847),9.16920725504557e-05);
ok($diceobj->probability(848),7.72491582234701e-05);
ok($diceobj->probability(849),6.50807571411133e-05);
ok($diceobj->probability(850),5.38463846842448e-05);
ok($diceobj->probability(851),4.26133897569444e-05);
ok($diceobj->probability(852),3.29506005181207e-05);
ok($diceobj->probability(853),2.07807159423828e-05);
ok($diceobj->probability(854),2.33718872070313e-05);
ok($diceobj->probability(855),2.14140319824219e-05);
ok($diceobj->probability(856),1.94561767578125e-05);
ok($diceobj->probability(857),1.87383100721571e-05);
ok($diceobj->probability(858),1.48800320095486e-05);
ok($diceobj->probability(859),1.22753016153971e-05);
ok($diceobj->probability(860),1.35919528537326e-05);
ok($diceobj->probability(861),1.7183117336697e-05);
ok($diceobj->probability(862),2.07742818196615e-05);
ok($diceobj->probability(863),2.18854692247179e-05);
ok($diceobj->probability(864),2.45668623182509e-05);
ok($diceobj->probability(865),2.72482554117839e-05);
ok($diceobj->probability(866),3.38934156629774e-05);
ok($diceobj->probability(867),4.0538575914171e-05);
ok($diceobj->probability(868),4.71837361653646e-05);
ok($diceobj->probability(869),5.51451365152995e-05);
ok($diceobj->probability(870),6.31074905395508e-05);
ok($diceobj->probability(871),7.10698445638021e-05);
ok($diceobj->probability(872),5.936156378852e-05);
ok($diceobj->probability(873),4.76532830132378e-05);
ok($diceobj->probability(874),3.59450022379557e-05);
ok($diceobj->probability(875),2.4084218343099e-05);
ok($diceobj->probability(876),1.22215270996094e-05);
ok($diceobj->probability(877),4.61641947428385e-07);
ok($diceobj->probability(878),4.66198391384549e-07);
ok($diceobj->probability(879),4.70754835340712e-07);
ok($diceobj->probability(880),4.75311279296875e-07);
ok($diceobj->probability(881),5.56119283040365e-07);
ok($diceobj->probability(882),1.03910700480143e-05);
ok($diceobj->probability(883),2.00204086303711e-05);
ok($diceobj->probability(884),3.44956843058268e-05);
ok($diceobj->probability(885),4.89709599812826e-05);
ok($diceobj->probability(886),6.45874659220378e-05);
ok($diceobj->probability(887),8.0203971862793e-05);
ok($diceobj->probability(888),7.63140996297201e-05);
ok($diceobj->probability(889),7.25270334879557e-05);
ok($diceobj->probability(890),5.90901819864909e-05);
ok($diceobj->probability(891),4.5653330485026e-05);
ok($diceobj->probability(892),2.99340184529622e-05);
ok($diceobj->probability(893),1.74551645914714e-05);
ok($diceobj->probability(894),1.47294998168945e-05);
ok($diceobj->probability(895),1.20038350423177e-05);
ok($diceobj->probability(896),1.41030629475911e-05);
ok($diceobj->probability(897),1.62022908528646e-05);
ok($diceobj->probability(898),2.46845245361328e-05);
ok($diceobj->probability(899),2.69170973036024e-05);
ok($diceobj->probability(900),2.9149670071072e-05);
ok($diceobj->probability(901),3.13822428385417e-05);
ok($diceobj->probability(902),4.61628172132704e-05);
ok($diceobj->probability(903),6.09433915879991e-05);
ok($diceobj->probability(904),6.52404149373372e-05);
ok($diceobj->probability(905),7.23153856065538e-05);
ok($diceobj->probability(906),7.93903562757704e-05);
ok($diceobj->probability(907),8.6465326944987e-05);
ok($diceobj->probability(908),6.84442943996853e-05);
ok($diceobj->probability(909),5.04232618543837e-05);
ok($diceobj->probability(910),3.76440048217773e-05);
ok($diceobj->probability(911),2.50960032145182e-05);
ok($diceobj->probability(912),2.00655746459961e-05);
ok($diceobj->probability(913),1.5035146077474e-05);
ok($diceobj->probability(914),2.49351247151693e-05);
ok($diceobj->probability(915),3.48351033528646e-05);
ok($diceobj->probability(916),4.47350819905599e-05);
ok($diceobj->probability(917),5.46350606282552e-05);
ok($diceobj->probability(918),4.94998931884766e-05);
ok($diceobj->probability(919),4.43647257486979e-05);
ok($diceobj->probability(920),3.66283162434896e-05);
ok($diceobj->probability(921),2.88919067382812e-05);
ok($diceobj->probability(922),2.1962890625e-05);
ok($diceobj->probability(923),1.50338745117188e-05);
ok($diceobj->probability(924),1.56224314371745e-05);
ok($diceobj->probability(925),1.62109883626302e-05);
ok($diceobj->probability(926),2.59151458740234e-05);
ok($diceobj->probability(927),3.56193033854167e-05);
ok($diceobj->probability(928),4.37086741129557e-05);
ok($diceobj->probability(929),5.17980448404948e-05);
ok($diceobj->probability(930),5.99029922485352e-05);
ok($diceobj->probability(931),6.80079396565755e-05);
ok($diceobj->probability(932),5.61587778727214e-05);
ok($diceobj->probability(933),4.48932647705078e-05);
ok($diceobj->probability(934),3.44351450602214e-05);
ok($diceobj->probability(935),2.39770253499349e-05);
ok($diceobj->probability(936),1.34877522786458e-05);
ok($diceobj->probability(937),5.11010487874349e-06);
ok($diceobj->probability(938),1.94310718112522e-05);
ok($diceobj->probability(939),3.25847413804796e-05);
ok($diceobj->probability(940),4.5738410949707e-05);
ok($diceobj->probability(941),5.88920805189345e-05);
ok($diceobj->probability(942),7.20613267686632e-05);
ok($diceobj->probability(943),8.10073216756185e-05);
ok($diceobj->probability(944),6.66677898830838e-05);
ok($diceobj->probability(945),5.29119067721897e-05);
ok($diceobj->probability(946),3.91560236612956e-05);
ok($diceobj->probability(947),3.01860597398546e-05);
ok($diceobj->probability(948),2.12160958184136e-05);
ok($diceobj->probability(949),1.43577575683594e-05);
ok($diceobj->probability(950),1.91436767578125e-05);
ok($diceobj->probability(951),2.39295959472656e-05);
ok($diceobj->probability(952),3.02563730875651e-05);
ok($diceobj->probability(953),2.70113118489583e-05);
ok($diceobj->probability(954),2.70936838785807e-05);
ok($diceobj->probability(955),2.71760559082031e-05);
ok($diceobj->probability(956),2.72584279378255e-05);
ok($diceobj->probability(957),2.73407999674479e-05);
ok($diceobj->probability(958),2.43414560953776e-05);
ok($diceobj->probability(959),2.61480585734049e-05);
ok($diceobj->probability(960),2.1299794514974e-05);
ok($diceobj->probability(961),1.6451530456543e-05);
ok($diceobj->probability(962),3.02925406561957e-05);
ok($diceobj->probability(963),4.41335508558485e-05);
ok($diceobj->probability(964),5.95154190063477e-05);
ok($diceobj->probability(965),7.48572328355577e-05);
ok($diceobj->probability(966),9.3526479932997e-05);
ok($diceobj->probability(967),0.000112195727030436);
ok($diceobj->probability(968),9.40464231703016e-05);
ok($diceobj->probability(969),7.58971193101671e-05);
ok($diceobj->probability(970),6.24438985188802e-05);
ok($diceobj->probability(971),4.91014099121094e-05);
ok($diceobj->probability(972),3.57589213053385e-05);
ok($diceobj->probability(973),2.24164326985677e-05);
ok($diceobj->probability(974),3.29072740342882e-05);
ok($diceobj->probability(975),4.33981153700087e-05);
ok($diceobj->probability(976),4.44967905680339e-05);
ok($diceobj->probability(977),4.8208139207628e-05);
ok($diceobj->probability(978),5.19194878472222e-05);
ok($diceobj->probability(979),5.56308364868164e-05);
ok($diceobj->probability(980),4.73740810818142e-05);
ok($diceobj->probability(981),3.91173256768121e-05);
ok($diceobj->probability(982),4.27471160888672e-05);
ok($diceobj->probability(983),4.08794445461697e-05);
ok($diceobj->probability(984),3.90117730034722e-05);
ok($diceobj->probability(985),3.71441014607747e-05);
ok($diceobj->probability(986),4.15404807196723e-05);
ok($diceobj->probability(987),4.59368599785699e-05);
ok($diceobj->probability(988),3.59523137410482e-05);
ok($diceobj->probability(989),2.87618509928385e-05);
ok($diceobj->probability(990),2.26500574747721e-05);
ok($diceobj->probability(991),1.65382639567057e-05);
ok($diceobj->probability(992),2.69495391845703e-05);
ok($diceobj->probability(993),3.73608144124349e-05);
ok($diceobj->probability(994),5.49647776285807e-05);
ok($diceobj->probability(995),7.25687408447266e-05);
ok($diceobj->probability(996),8.80153656005859e-05);
ok($diceobj->probability(997),0.000103461990356445);
ok($diceobj->probability(998),8.58624776204427e-05);
ok($diceobj->probability(999),6.82629648844401e-05);
ok($diceobj->probability(1000),5.06590016682943e-05);
ok($diceobj->probability(1001),3.30550384521484e-05);
ok($diceobj->probability(1002),2.02141571044922e-05);
ok($diceobj->probability(1003),1.39402770996094e-05);
ok($diceobj->probability(1004),2.41894658406576e-05);
ok($diceobj->probability(1005),3.44386545817057e-05);
ok($diceobj->probability(1006),4.46900685628255e-05);
ok($diceobj->probability(1007),5.49414825439453e-05);
ok($diceobj->probability(1008),5.78240712483724e-05);
ok($diceobj->probability(1009),4.75726572672526e-05);
ok($diceobj->probability(1010),6.15071445041233e-05);
ok($diceobj->probability(1011),7.54416317409939e-05);
ok($diceobj->probability(1012),8.93761189778646e-05);
ok($diceobj->probability(1013),0.000103310606214735);
ok($diceobj->probability(1014),0.000121533754136827);
ok($diceobj->probability(1015),0.000146323903401693);
ok($diceobj->probability(1016),0.000125334209865994);
ok($diceobj->probability(1017),0.000104360474480523);
ok($diceobj->probability(1018),8.33867390950521e-05);
ok($diceobj->probability(1019),6.24130037095812e-05);
ok($diceobj->probability(1020),4.02307722303602e-05);
ok($diceobj->probability(1021),1.80485407511393e-05);
ok($diceobj->probability(1022),2.13871468438043e-05);
ok($diceobj->probability(1023),2.46938366360135e-05);
ok($diceobj->probability(1024),2.80005264282227e-05);
ok($diceobj->probability(1025),3.13100772433811e-05);
ok($diceobj->probability(1026),3.76689063178168e-05);
ok($diceobj->probability(1027),4.40277353922526e-05);
ok($diceobj->probability(1028),4.19980790879991e-05);
ok($diceobj->probability(1029),3.99843809339735e-05);
ok($diceobj->probability(1030),3.79706827799479e-05);
ok($diceobj->probability(1031),3.64519415961372e-05);
ok($diceobj->probability(1032),3.00431399875217e-05);
ok($diceobj->probability(1033),2.36343383789062e-05);
ok($diceobj->probability(1034),1.96298599243164e-05);
ok($diceobj->probability(1035),1.56253814697266e-05);
ok($diceobj->probability(1036),1.16209030151367e-05);
ok($diceobj->probability(1037),7.4124018351237e-06);
ok($diceobj->probability(1038),5.64893086751302e-06);
ok($diceobj->probability(1039),3.88545989990234e-06);
ok($diceobj->probability(1040),4.17925516764323e-06);
ok($diceobj->probability(1041),4.47305043538411e-06);
ok($diceobj->probability(1042),1.72416559855143e-05);
ok($diceobj->probability(1043),2.89219919840495e-05);
ok($diceobj->probability(1044),4.06023279825846e-05);
ok($diceobj->probability(1045),5.22826639811198e-05);
ok($diceobj->probability(1046),6.40226576063368e-05);
ok($diceobj->probability(1047),7.78220155504015e-05);
ok($diceobj->probability(1048),6.66717529296875e-05);
ok($diceobj->probability(1049),5.63159645928277e-05);
ok($diceobj->probability(1050),4.59601762559679e-05);
ok($diceobj->probability(1051),3.56043879191081e-05);
ok($diceobj->probability(1052),3.49818335639106e-05);
ok($diceobj->probability(1053),3.02405505710178e-05);
ok($diceobj->probability(1054),3.79740778605143e-05);
ok($diceobj->probability(1055),5.03976058959961e-05);
ok($diceobj->probability(1056),6.28211339314779e-05);
ok($diceobj->probability(1057),7.52446619669596e-05);
ok($diceobj->probability(1058),8.44085269504123e-05);
ok($diceobj->probability(1059),9.56317562527127e-05);
ok($diceobj->probability(1060),0.000106854985555013);
ok($diceobj->probability(1061),0.000108698213365343);
ok($diceobj->probability(1062),0.000110541441175673);
ok($diceobj->probability(1063),0.000112384668986003);
ok($diceobj->probability(1064),9.13088904486762e-05);
ok($diceobj->probability(1065),7.02331119113498e-05);
ok($diceobj->probability(1066),5.23436228434245e-05);
ok($diceobj->probability(1067),3.91441345214844e-05);
ok($diceobj->probability(1068),2.59446461995443e-05);
ok($diceobj->probability(1069),1.27451578776042e-05);
ok($diceobj->probability(1070),1.59314473470052e-05);
ok($diceobj->probability(1071),1.91177368164062e-05);
ok($diceobj->probability(1072),1.59314473470052e-05);
ok($diceobj->probability(1073),1.66948742336697e-05);
ok($diceobj->probability(1074),1.74583011203342e-05);
ok($diceobj->probability(1075),1.82217280069987e-05);
ok($diceobj->probability(1076),1.89851548936632e-05);
ok($diceobj->probability(1077),1.97485817803277e-05);
ok($diceobj->probability(1078),2.36982981363932e-05);
ok($diceobj->probability(1079),1.97485817803277e-05);
ok($diceobj->probability(1080),2.33834372626411e-05);
ok($diceobj->probability(1081),2.70182927449544e-05);
ok($diceobj->probability(1082),6.31165017022027e-05);
ok($diceobj->probability(1083),9.9214710659451e-05);
ok($diceobj->probability(1084),0.000135312919616699);
ok($diceobj->probability(1085),0.000175372246636285);
ok($diceobj->probability(1086),0.000200262429979112);
ok($diceobj->probability(1087),0.000225154838562012);
ok($diceobj->probability(1088),0.000185120540195041);
ok($diceobj->probability(1089),0.000145086241828071);
ok($diceobj->probability(1090),0.000107785682678223);
ok($diceobj->probability(1091),7.68767335679796e-05);
ok($diceobj->probability(1092),5.35523562961155e-05);
ok($diceobj->probability(1093),3.02235285441081e-05);
ok($diceobj->probability(1094),5.39748085869683e-05);
ok($diceobj->probability(1095),7.77260886298286e-05);
ok($diceobj->probability(1096),9.6009890238444e-05);
ok($diceobj->probability(1097),0.000101476266649034);
ok($diceobj->probability(1098),0.000106942643059625);
ok($diceobj->probability(1099),0.000112411244710286);
ok($diceobj->probability(1100),8.86463377210829e-05);
ok($diceobj->probability(1101),6.48814307318793e-05);
ok($diceobj->probability(1102),5.43184407552083e-05);
ok($diceobj->probability(1103),5.01698642306858e-05);
ok($diceobj->probability(1104),4.60212877061632e-05);
ok($diceobj->probability(1105),4.18727111816406e-05);
ok($diceobj->probability(1106),5.3863885667589e-05);
ok($diceobj->probability(1107),6.84249454074436e-05);
ok($diceobj->probability(1108),6.20496495564779e-05);
ok($diceobj->probability(1109),5.56743537055122e-05);
ok($diceobj->probability(1110),4.92990578545464e-05);
ok($diceobj->probability(1111),4.29237620035807e-05);
ok($diceobj->probability(1112),3.35024727715386e-05);
ok($diceobj->probability(1113),1.8941413031684e-05);
ok($diceobj->probability(1114),1.48485310872396e-05);
ok($diceobj->probability(1115),1.07556491427951e-05);
ok($diceobj->probability(1116),6.66276719835069e-06);
ok($diceobj->probability(1117),2.56988525390625e-06);
ok($diceobj->probability(1118),8.47710503472222e-09);
ok($diceobj->probability(1119),1.69542100694444e-08);
ok($diceobj->probability(1120),2.54313151041667e-08);
ok($diceobj->probability(1121),3.39084201388889e-08);
ok($diceobj->probability(1122),2.06852001614041e-05);
ok($diceobj->probability(1123),4.13364919026693e-05);
ok($diceobj->probability(1124),6.62185584174262e-05);
ok($diceobj->probability(1125),9.11006249321832e-05);
ok($diceobj->probability(1126),0.00011598269144694);
ok($diceobj->probability(1127),0.000142594197591146);
ok($diceobj->probability(1128),0.000127920074462891);
ok($diceobj->probability(1129),0.000113615976969401);
ok($diceobj->probability(1130),9.08248986138238e-05);
ok($diceobj->probability(1131),6.80338202582465e-05);
ok($diceobj->probability(1132),4.52427419026693e-05);
ok($diceobj->probability(1133),1.90157784356011e-05);
ok($diceobj->probability(1134),1.34316296047635e-05);
ok($diceobj->probability(1135),7.10742950439453e-06);
ok($diceobj->probability(1136),1.59110260009766e-05);
ok($diceobj->probability(1137),2.47146224975586e-05);
ok($diceobj->probability(1138),3.35182189941406e-05);
ok($diceobj->probability(1139),4.40052668253581e-05);
ok($diceobj->probability(1140),5.44923146565755e-05);
ok($diceobj->probability(1141),6.53493881225586e-05);
ok($diceobj->probability(1142),6.06147638956706e-05);
ok($diceobj->probability(1143),5.58801396687826e-05);
ok($diceobj->probability(1144),5.11455154418945e-05);
ok($diceobj->probability(1145),4.64338853624132e-05);
ok($diceobj->probability(1146),5.43197207980686e-05);
ok($diceobj->probability(1147),6.2205556233724e-05);
ok($diceobj->probability(1148),6.86345842149523e-05);
ok($diceobj->probability(1149),7.50636121961806e-05);
ok($diceobj->probability(1150),8.14926401774089e-05);
ok($diceobj->probability(1151),8.79216681586372e-05);
ok($diceobj->probability(1152),7.01459587944878e-05);
ok($diceobj->probability(1153),5.23702494303385e-05);
ok($diceobj->probability(1154),6.2582516140408e-05);
ok($diceobj->probability(1155),7.27947828504774e-05);
ok($diceobj->probability(1156),8.30070495605469e-05);
ok($diceobj->probability(1157),0.000102471228705512);
ok($diceobj->probability(1158),0.000132781240675184);
ok($diceobj->probability(1159),0.000163091252644857);
ok($diceobj->probability(1160),0.000149762187533908);
ok($diceobj->probability(1161),0.00013643312242296);
ok($diceobj->probability(1162),0.00012318416595459);
ok($diceobj->probability(1163),9.1431384616428e-05);
ok($diceobj->probability(1164),6.02112876044379e-05);
ok($diceobj->probability(1165),2.89911905924479e-05);
ok($diceobj->probability(1166),1.95906321207682e-05);
ok($diceobj->probability(1167),1.01900736490885e-05);
ok($diceobj->probability(1168),6.29297892252604e-07);
ok($diceobj->probability(1169),3.204345703125e-07);
ok($diceobj->probability(1170),2.40325927734375e-07);
ok($diceobj->probability(1171),1.6021728515625e-07);
ok($diceobj->probability(1172),2.19710795084635e-05);
ok($diceobj->probability(1173),4.37819417317708e-05);
ok($diceobj->probability(1174),6.56729125976562e-05);
ok($diceobj->probability(1175),8.76161024305556e-05);
ok($diceobj->probability(1176),0.000109559292263455);
ok($diceobj->probability(1177),0.000131502482096354);
ok($diceobj->probability(1178),0.000124292394849989);
ok($diceobj->probability(1179),0.000117082307603624);
ok($diceobj->probability(1180),0.000109872220357259);
ok($diceobj->probability(1181),0.000102557695176866);
ok($diceobj->probability(1182),9.52431699964735e-05);
ok($diceobj->probability(1183),8.79286448160807e-05);
ok($diceobj->probability(1184),7.32477611965603e-05);
ok($diceobj->probability(1185),6.31794187757704e-05);
ok($diceobj->probability(1186),5.31110763549805e-05);
ok($diceobj->probability(1187),4.30949529012044e-05);
ok($diceobj->probability(1188),3.30788294474284e-05);
ok($diceobj->probability(1189),2.30627059936523e-05);
ok($diceobj->probability(1190),4.95983123779297e-05);
ok($diceobj->probability(1191),6.69088363647461e-05);
ok($diceobj->probability(1192),9.24277877807617e-05);
ok($diceobj->probability(1193),0.000117946739196777);
ok($diceobj->probability(1194),0.000143465690612793);
ok($diceobj->probability(1195),0.000168984642028809);
ok($diceobj->probability(1196),0.00015065746307373);
ok($diceobj->probability(1197),0.000136942825317383);
ok($diceobj->probability(1198),0.000107505098978678);
ok($diceobj->probability(1199),8.18676800198025e-05);
ok($diceobj->probability(1200),5.62302610609266e-05);
ok($diceobj->probability(1201),3.05928421020508e-05);
ok($diceobj->probability(1202),5.51872719658746e-05);
ok($diceobj->probability(1203),7.97817018296983e-05);
ok($diceobj->probability(1204),0.000111197026570638);
ok($diceobj->probability(1205),0.000135011736551921);
ok($diceobj->probability(1206),0.000158826446533203);
ok($diceobj->probability(1207),0.000182641156514486);
ok($diceobj->probability(1208),0.000149838299221463);
ok($diceobj->probability(1209),0.00011703544192844);
ok($diceobj->probability(1210),8.49263509114583e-05);
ok($diceobj->probability(1211),5.66208521525065e-05);
ok($diceobj->probability(1212),3.93085479736328e-05);
ok($diceobj->probability(1213),2.19962437947591e-05);
ok($diceobj->probability(1214),3.29927232530382e-05);
ok($diceobj->probability(1215),4.39892027113173e-05);
ok($diceobj->probability(1216),5.49856821695964e-05);
ok($diceobj->probability(1217),7.15696334838867e-05);
ok($diceobj->probability(1218),6.86916351318359e-05);
ok($diceobj->probability(1219),6.58136367797852e-05);
ok($diceobj->probability(1220),6.29909515380859e-05);
ok($diceobj->probability(1221),6.01682662963867e-05);
ok($diceobj->probability(1222),5.73455810546875e-05);
ok($diceobj->probability(1223),4.33380974663628e-05);
ok($diceobj->probability(1224),3.52749294704861e-05);
ok($diceobj->probability(1225),2.72117614746094e-05);
ok($diceobj->probability(1226),3.13043382432726e-05);
ok($diceobj->probability(1227),3.56315188937717e-05);
ok($diceobj->probability(1228),3.99586995442708e-05);
ok($diceobj->probability(1229),4.98799218071832e-05);
ok($diceobj->probability(1230),6.23255835639106e-05);
ok($diceobj->probability(1231),7.4771245320638e-05);
ok($diceobj->probability(1232),6.27394782172309e-05);
ok($diceobj->probability(1233),5.02385033501519e-05);
ok($diceobj->probability(1234),6.04489008585612e-05);
ok($diceobj->probability(1235),7.06592983669705e-05);
ok($diceobj->probability(1236),8.08696958753798e-05);
ok($diceobj->probability(1237),9.35119883219401e-05);
ok($diceobj->probability(1238),0.000118420651753743);
ok($diceobj->probability(1239),0.000143563919067383);
ok($diceobj->probability(1240),0.000123284441630046);
ok($diceobj->probability(1241),0.000103004964192708);
ok($diceobj->probability(1242),8.27368036905924e-05);
ok($diceobj->probability(1243),5.76048533121745e-05);
ok($diceobj->probability(1244),3.37746471828885e-05);
ok($diceobj->probability(1245),9.94444105360243e-06);
ok($diceobj->probability(1246),8.82560729980469e-06);
ok($diceobj->probability(1247),7.70677354600694e-06);
ok($diceobj->probability(1248),6.56530592176649e-06);
ok($diceobj->probability(1249),7.85573323567708e-06);
ok($diceobj->probability(1250),2.73653666178385e-05);
ok($diceobj->probability(1251),4.6875e-05);
ok($diceobj->probability(1252),6.70157623291016e-05);
ok($diceobj->probability(1253),8.71565246582031e-05);
ok($diceobj->probability(1254),0.000107308603922526);
ok($diceobj->probability(1255),0.000127460683186849);
ok($diceobj->probability(1256),0.000111347855461968);
ok($diceobj->probability(1257),9.52350277370877e-05);
ok($diceobj->probability(1258),7.78599421183268e-05);
ok($diceobj->probability(1259),6.0484856499566e-05);
ok($diceobj->probability(1260),4.31097708808051e-05);
ok($diceobj->probability(1261),2.57346852620443e-05);
ok($diceobj->probability(1262),6.75808970133464e-05);
ok($diceobj->probability(1263),0.000109427108764648);
ok($diceobj->probability(1264),0.000151904449462891);
ok($diceobj->probability(1265),0.000194381790161133);
ok($diceobj->probability(1266),0.000236859130859375);
ok($diceobj->probability(1267),0.00028065788269043);
ok($diceobj->probability(1268),0.000235423215230306);
ok($diceobj->probability(1269),0.000190188547770182);
ok($diceobj->probability(1270),0.000144953880310059);
ok($diceobj->probability(1271),9.97192128499349e-05);
ok($diceobj->probability(1272),5.44845453898112e-05);
ok($diceobj->probability(1273),6.6070556640625e-06);
ok($diceobj->probability(1274),5.28564453125e-06);
ok($diceobj->probability(1275),3.9642333984375e-06);
ok($diceobj->probability(1276),1.26492818196615e-05);
ok($diceobj->probability(1277),2.33900324503581e-05);
ok($diceobj->probability(1278),3.41908645629883e-05);
ok($diceobj->probability(1279),4.6313107808431e-05);
ok($diceobj->probability(1280),5.84353510538737e-05);
ok($diceobj->probability(1281),7.05575942993164e-05);
ok($diceobj->probability(1282),7.60619481404622e-05);
ok($diceobj->probability(1283),7.74548975626628e-05);
ok($diceobj->probability(1284),7.87276840209961e-05);
ok($diceobj->probability(1285),8.00004704793294e-05);
ok($diceobj->probability(1286),8.12732569376628e-05);
ok($diceobj->probability(1287),8.25460433959961e-05);
ok($diceobj->probability(1288),6.70352300008138e-05);
ok($diceobj->probability(1289),7.20601018269857e-05);
ok($diceobj->probability(1290),7.91627756754557e-05);
ok($diceobj->probability(1291),8.62654495239258e-05);
ok($diceobj->probability(1292),9.33681233723958e-05);
ok($diceobj->probability(1293),0.000100470797220866);
ok($diceobj->probability(1294),0.000121240615844727);
ok($diceobj->probability(1295),0.000105050468444824);
ok($diceobj->probability(1296),8.48248799641927e-05);
ok($diceobj->probability(1297),6.45992914835612e-05);
ok($diceobj->probability(1298),7.33504825168186e-05);
ok($diceobj->probability(1299),8.21016735500759e-05);
ok($diceobj->probability(1300),9.03086344401042e-05);
ok($diceobj->probability(1301),0.000116995578342014);
ok($diceobj->probability(1302),0.000158952831692166);
ok($diceobj->probability(1303),0.000200910085042318);
ok($diceobj->probability(1304),0.000184921408759223);
ok($diceobj->probability(1305),0.000168932732476128);
ok($diceobj->probability(1306),0.000153216171264648);
ok($diceobj->probability(1307),0.000137578281826443);
ok($diceobj->probability(1308),9.54352145724826e-05);
ok($diceobj->probability(1309),5.32921473185221e-05);
ok($diceobj->probability(1310),4.0110600789388e-05);
ok($diceobj->probability(1311),3.47091293334961e-05);
ok($diceobj->probability(1312),2.93076578776042e-05);
ok($diceobj->probability(1313),2.37563027275933e-05);
ok($diceobj->probability(1314),3.14575364854601e-05);
ok($diceobj->probability(1315),3.91587702433268e-05);
ok($diceobj->probability(1316),4.68676333957248e-05);
ok($diceobj->probability(1317),3.90163464016385e-05);
ok($diceobj->probability(1318),3.11650594075521e-05);
ok($diceobj->probability(1319),2.33775244818793e-05);
ok($diceobj->probability(1320),1.55899895562066e-05);
ok($diceobj->probability(1321),7.80245463053385e-06);
ok($diceobj->probability(1322),4.62610287136502e-05);
ok($diceobj->probability(1323),9.24996778700087e-05);
ok($diceobj->probability(1324),0.000138738327026367);
ok($diceobj->probability(1325),0.00018834041595459);
ok($diceobj->probability(1326),0.000237942504882812);
ok($diceobj->probability(1327),0.000287544593811035);
ok($diceobj->probability(1328),0.000249920166863335);
ok($diceobj->probability(1329),0.000212295739915636);
ok($diceobj->probability(1330),0.000174671312967936);
ok($diceobj->probability(1331),0.000130334926181369);
ok($diceobj->probability(1332),9.38544633653429e-05);
ok($diceobj->probability(1333),6.16226196289062e-05);
ok($diceobj->probability(1334),6.5105480617947e-05);
ok($diceobj->probability(1335),6.85883416069878e-05);
ok($diceobj->probability(1336),7.20712025960286e-05);
ok($diceobj->probability(1337),7.8910043504503e-05);
ok($diceobj->probability(1338),7.00370364718967e-05);
ok($diceobj->probability(1339),5.26667912801107e-05);
ok($diceobj->probability(1340),4.05622482299805e-05);
ok($diceobj->probability(1341),2.84577051798503e-05);
ok($diceobj->probability(1342),1.63531621297201e-05);
ok($diceobj->probability(1343),4.24861907958984e-06);
ok($diceobj->probability(1346),3.39558919270833e-05);
ok($diceobj->probability(1347),6.79117838541667e-05);
ok($diceobj->probability(1348),0.00010186767578125);
ok($diceobj->probability(1349),0.000135823567708333);
ok($diceobj->probability(1350),0.000169779459635417);
ok($diceobj->probability(1351),0.0002037353515625);
ok($diceobj->probability(1352),0.000191147736443414);
ok($diceobj->probability(1353),0.000178560121324327);
ok($diceobj->probability(1354),0.000174411379496257);
ok($diceobj->probability(1355),0.000170262637668186);
ok($diceobj->probability(1356),0.000166113895840115);
ok($diceobj->probability(1357),0.000161965154012044);
ok($diceobj->probability(1358),0.000149035750495063);
ok($diceobj->probability(1359),0.000136106346978082);
ok($diceobj->probability(1360),0.000106299196879069);
ok($diceobj->probability(1361),7.64920467800564e-05);
ok($diceobj->probability(1362),5.87901645236545e-05);
ok($diceobj->probability(1363),4.10882822672526e-05);
ok($diceobj->probability(1364),4.47546768188477e-05);
ok($diceobj->probability(1365),4.84210713704427e-05);
ok($diceobj->probability(1366),6.0534922281901e-05);
ok($diceobj->probability(1367),8.47782601250542e-05);
ok($diceobj->probability(1368),8.48110622829861e-05);
ok($diceobj->probability(1369),8.4843864440918e-05);
ok($diceobj->probability(1370),9.6539552476671e-05);
ok($diceobj->probability(1371),0.000108235240512424);
ok($diceobj->probability(1372),0.000119913762410482);
ok($diceobj->probability(1373),0.00010733331044515);
ok($diceobj->probability(1374),0.000112085405985514);
ok($diceobj->probability(1375),0.000116837501525879);
ok($diceobj->probability(1376),9.82638253106011e-05);
ok($diceobj->probability(1377),8.05322435167101e-05);
ok($diceobj->probability(1378),6.28092447916667e-05);
ok($diceobj->probability(1379),6.28600014580621e-05);
ok($diceobj->probability(1380),5.24561987982856e-05);
ok($diceobj->probability(1381),4.20523961385091e-05);
ok($diceobj->probability(1382),4.72298007541233e-05);
ok($diceobj->probability(1383),5.0723016526964e-05);
ok($diceobj->probability(1384),5.42162322998047e-05);
ok($diceobj->probability(1385),4.64209111531576e-05);
ok($diceobj->probability(1386),4.38528696695964e-05);
ok($diceobj->probability(1387),4.12848281860352e-05);
ok($diceobj->probability(1388),6.50968975490994e-05);
ok($diceobj->probability(1389),8.97510613335503e-05);
ok($diceobj->probability(1390),0.000114405225118001);
ok($diceobj->probability(1391),0.000144703657362196);
ok($diceobj->probability(1392),0.000175002089606391);
ok($diceobj->probability(1393),0.000205300521850586);
ok($diceobj->probability(1394),0.000171234342787001);
ok($diceobj->probability(1395),0.000137168163723416);
ok($diceobj->probability(1396),0.000103101984659831);
ok($diceobj->probability(1397),6.90468046400282e-05);
ok($diceobj->probability(1398),3.49916246202257e-05);
ok($diceobj->probability(1399),9.36444600423177e-07);
ok($diceobj->probability(1400),7.96869066026476e-07);
ok($diceobj->probability(1401),6.57293531629774e-07);
ok($diceobj->probability(1402),2.03661600748698e-05);
ok($diceobj->probability(1403),4.00530285305447e-05);
ok($diceobj->probability(1404),5.97398969862196e-05);
ok($diceobj->probability(1405),7.94267654418945e-05);
ok($diceobj->probability(1406),0.000128129408094618);
ok($diceobj->probability(1407),0.000176832050747342);
ok($diceobj->probability(1408),0.000185837809244792);
ok($diceobj->probability(1409),0.000194854566786024);
ok($diceobj->probability(1410),0.000219250276353624);
ok($diceobj->probability(1411),0.000243645985921224);
ok($diceobj->probability(1412),0.000210311296251085);
ok($diceobj->probability(1413),0.000176976606580946);
ok($diceobj->probability(1414),0.000163490358988444);
ok($diceobj->probability(1415),0.000150004111395942);
ok($diceobj->probability(1416),0.000105759959750705);
ok($diceobj->probability(1417),6.15158081054688e-05);
ok($diceobj->probability(1418),4.61368560791016e-05);
ok($diceobj->probability(1419),3.07579040527344e-05);
ok($diceobj->probability(1420),1.53789520263672e-05);
ok($diceobj->probability(1423),3.62396240234375e-08);
ok($diceobj->probability(1424),7.2479248046875e-08);
ok($diceobj->probability(1425),1.08718872070313e-07);
ok($diceobj->probability(1426),1.4495849609375e-07);
ok($diceobj->probability(1427),1.93912506103516e-06);
ok($diceobj->probability(1428),3.73329162597656e-06);
ok($diceobj->probability(1429),5.45497894287109e-06);
ok($diceobj->probability(1430),2.17336569892036e-05);
ok($diceobj->probability(1431),3.8012335035536e-05);
ok($diceobj->probability(1432),8.38512166341146e-05);
ok($diceobj->probability(1433),0.000126174244350857);
ok($diceobj->probability(1434),0.0001684972720676);
ok($diceobj->probability(1435),0.000210856539408366);
ok($diceobj->probability(1436),0.000224101825290256);
ok($diceobj->probability(1437),0.000237347111172146);
ok($diceobj->probability(1438),0.000191471989949544);
ok($diceobj->probability(1439),0.00014735479566786);
ok($diceobj->probability(1440),0.000103237601386176);
ok($diceobj->probability(1441),5.91204071044922e-05);
ok($diceobj->probability(1442),0.000107160449557834);
ok($diceobj->probability(1443),0.000155200492011176);
ok($diceobj->probability(1444),0.000232800738016764);
ok($diceobj->probability(1445),0.000310400984022352);
ok($diceobj->probability(1446),0.000388035435146756);
ok($diceobj->probability(1447),0.000466301918029785);
ok($diceobj->probability(1448),0.000389367908901638);
ok($diceobj->probability(1449),0.000312433899773492);
ok($diceobj->probability(1450),0.000235499890645345);
ok($diceobj->probability(1451),0.000160949304368761);
ok($diceobj->probability(1452),8.64282438490126e-05);
ok($diceobj->probability(1453),1.06431198120117e-05);
ok($diceobj->probability(1454),3.13724644978841e-05);
ok($diceobj->probability(1455),5.21018091837565e-05);
ok($diceobj->probability(1456),7.28311538696289e-05);
ok($diceobj->probability(1457),8.87936528523763e-05);
ok($diceobj->probability(1458),0.000133144315083822);
ok($diceobj->probability(1459),0.000178127009073893);
ok($diceobj->probability(1460),0.000191304961310493);
ok($diceobj->probability(1461),0.000204482913547092);
ok($diceobj->probability(1462),0.000217660865783691);
ok($diceobj->probability(1463),0.000233222240871853);
ok($diceobj->probability(1464),0.000191781891716851);
ok($diceobj->probability(1465),0.000157881291707357);
ok($diceobj->probability(1466),0.000130847507052951);
ok($diceobj->probability(1467),0.000103813722398546);
ok($diceobj->probability(1468),7.67799377441406e-05);
ok($diceobj->probability(1469),4.97461530897352e-05);
ok($diceobj->probability(1470),5.1262198554145e-05);
ok($diceobj->probability(1471),3.76987457275391e-05);
ok($diceobj->probability(1472),4.72072389390734e-05);
ok($diceobj->probability(1473),5.67157321506076e-05);
ok($diceobj->probability(1474),6.77986780802409e-05);
ok($diceobj->probability(1475),7.88816240098741e-05);
ok($diceobj->probability(1476),8.99645699395074e-05);
ok($diceobj->probability(1477),0.000108587265014648);
ok($diceobj->probability(1478),9.31134753757053e-05);
ok($diceobj->probability(1479),7.76396857367622e-05);
ok($diceobj->probability(1480),5.90169906616211e-05);
ok($diceobj->probability(1481),4.03994878133138e-05);
ok($diceobj->probability(1482),2.17819849650065e-05);
ok($diceobj->probability(1483),3.16448211669922e-06);
ok($diceobj->probability(1484),6.5670649210612e-06);
ok($diceobj->probability(1485),9.96964772542318e-06);
ok($diceobj->probability(1486),1.49466832478841e-05);
ok($diceobj->probability(1487),4.14795981513129e-05);
ok($diceobj->probability(1488),6.80125130547418e-05);
ok($diceobj->probability(1489),9.45454279581706e-05);
ok($diceobj->probability(1490),0.000111155531141493);
ok($diceobj->probability(1491),0.000127765634324816);
ok($diceobj->probability(1492),0.000144375737508138);
ok($diceobj->probability(1493),0.000117858505249023);
ok($diceobj->probability(1494),9.13412729899089e-05);
ok($diceobj->probability(1495),6.48240407307943e-05);
ok($diceobj->probability(1496),4.32369020250108e-05);
ok($diceobj->probability(1497),2.31988864474826e-05);
ok($diceobj->probability(1498),1.70383580525716e-05);
ok($diceobj->probability(1499),3.2444093492296e-05);
ok($diceobj->probability(1500),4.78498289320204e-05);
ok($diceobj->probability(1501),6.32555643717448e-05);
ok($diceobj->probability(1502),9.44036780463325e-05);
ok($diceobj->probability(1503),0.00012245354546441);
ok($diceobj->probability(1504),0.000122748438517253);
ok($diceobj->probability(1505),0.000123043331570095);
ok($diceobj->probability(1506),0.000123338224622938);
ok($diceobj->probability(1507),0.000123633117675781);
ok($diceobj->probability(1508),9.24850040011936e-05);
ok($diceobj->probability(1509),6.28860134548611e-05);
ok($diceobj->probability(1510),4.72334925333659e-05);
ok($diceobj->probability(1511),3.15809716118707e-05);
ok($diceobj->probability(1512),1.59284506903754e-05);
ok($diceobj->probability(1513),2.75929768880208e-07);
ok($diceobj->probability(1514),5.19900851779514e-05);
ok($diceobj->probability(1515),0.000103704240587023);
ok($diceobj->probability(1516),0.000155280431111654);
ok($diceobj->probability(1517),0.000206856621636285);
ok($diceobj->probability(1518),0.000258432812160916);
ok($diceobj->probability(1519),0.000310009002685547);
ok($diceobj->probability(1520),0.000260873582628038);
ok($diceobj->probability(1521),0.000211742930942112);
ok($diceobj->probability(1522),0.000173954950968424);
ok($diceobj->probability(1523),0.000149236696031359);
ok($diceobj->probability(1524),0.000124518441094293);
ok($diceobj->probability(1525),9.98001861572266e-05);
ok($diceobj->probability(1526),0.000121569633483887);
ok($diceobj->probability(1527),0.000143329544067383);
ok($diceobj->probability(1528),0.00014254207611084);
ok($diceobj->probability(1529),0.000115615158081055);
ok($diceobj->probability(1530),8.86882400512695e-05);
ok($diceobj->probability(1531),6.17613220214844e-05);
ok($diceobj->probability(1532),5.94411892361111e-05);
ok($diceobj->probability(1533),5.71258248223199e-05);
ok($diceobj->probability(1534),6.60841496785482e-05);
ok($diceobj->probability(1535),8.81121995713976e-05);
ok($diceobj->probability(1536),0.000110140249464247);
ok($diceobj->probability(1537),0.000132168299357096);
ok($diceobj->probability(1538),0.000129949548509386);
ok($diceobj->probability(1539),0.000127730797661675);
ok($diceobj->probability(1540),0.000125512046813965);
ok($diceobj->probability(1541),0.000128759290907118);
ok($diceobj->probability(1542),0.000174747509426541);
ok($diceobj->probability(1543),0.000220735727945964);
ok($diceobj->probability(1544),0.000249133398267958);
ok($diceobj->probability(1545),0.000277531068589952);
ok($diceobj->probability(1546),0.000305928738911947);
ok($diceobj->probability(1547),0.000323394419352214);
ok($diceobj->probability(1548),0.000255378150939941);
ok($diceobj->probability(1549),0.000197379404703776);
ok($diceobj->probability(1550),0.00015918995751275);
ok($diceobj->probability(1551),0.000121000510321723);
ok($diceobj->probability(1552),8.28246688842773e-05);
ok($diceobj->probability(1553),5.01148223876953e-05);
ok($diceobj->probability(1554),6.01459503173828e-05);
ok($diceobj->probability(1555),5.01420338948568e-05);
ok($diceobj->probability(1556),4.01381174723307e-05);
ok($diceobj->probability(1557),3.01342010498047e-05);
ok($diceobj->probability(1558),2.01030731201172e-05);
ok($diceobj->probability(1559),1.00719451904297e-05);
ok($diceobj->probability(1560),4.08172607421875e-08);
ok($diceobj->probability(1561),2.72115071614583e-08);
ok($diceobj->probability(1562),5.93001514010959e-05);
ok($diceobj->probability(1563),0.00011857309129503);
ok($diceobj->probability(1564),0.000177859636942546);
ok($diceobj->probability(1565),0.000237146182590061);
ok($diceobj->probability(1566),0.000296589385138618);
ok($diceobj->probability(1567),0.000356032587687174);
ok($diceobj->probability(1568),0.000297030512491862);
ok($diceobj->probability(1569),0.000238028437296549);
ok($diceobj->probability(1570),0.000198780199686686);
ok($diceobj->probability(1571),0.000159531962076823);
ok($diceobj->probability(1572),0.000119970410664876);
ok($diceobj->probability(1573),8.04088592529297e-05);
ok($diceobj->probability(1574),9.98782263861762e-05);
ok($diceobj->probability(1575),0.000137589475843641);
ok($diceobj->probability(1576),0.000135793050130208);
ok($diceobj->probability(1577),0.00014202463361952);
ok($diceobj->probability(1578),0.000148412874009874);
ok($diceobj->probability(1579),0.000154801114400228);
ok($diceobj->probability(1580),0.000161317168341743);
ok($diceobj->probability(1581),0.00013134945763482);
ok($diceobj->probability(1582),0.000121135584513346);
ok($diceobj->probability(1583),9.48664347330729e-05);
ok($diceobj->probability(1584),6.85972849527995e-05);
ok($diceobj->probability(1585),4.2328135172526e-05);
ok($diceobj->probability(1586),8.18654378255208e-05);
ok($diceobj->probability(1587),0.000139644622802734);
ok($diceobj->probability(1588),0.000197423807779948);
ok($diceobj->probability(1589),0.000263229518466526);
ok($diceobj->probability(1590),0.000329035229153103);
ok($diceobj->probability(1591),0.000394840939839681);
ok($diceobj->probability(1592),0.000329033745659722);
ok($diceobj->probability(1593),0.000263226551479763);
ok($diceobj->probability(1594),0.000197419357299805);
ok($diceobj->probability(1595),0.000131612904866536);
ok($diceobj->probability(1596),6.58064524332682e-05);
ok($diceobj->probability(1597),1.30653381347656e-07);
ok($diceobj->probability(1598),1.38909445868598e-05);
ok($diceobj->probability(1599),2.7651235792372e-05);
ok($diceobj->probability(1600),4.14115269978841e-05);
ok($diceobj->probability(1601),5.51718182033963e-05);
ok($diceobj->probability(1602),9.23761325412326e-05);
ok($diceobj->probability(1603),0.000129319140116374);
ok($diceobj->probability(1604),0.000139002872043186);
ok($diceobj->probability(1605),0.000148686603969998);
ok($diceobj->probability(1606),0.00015837033589681);
ok($diceobj->probability(1607),0.000168054067823622);
ok($diceobj->probability(1608),0.000130849753485786);
ok($diceobj->probability(1609),9.37760925292969e-05);
ok($diceobj->probability(1610),7.03320693969727e-05);
ok($diceobj->probability(1611),4.68880462646484e-05);
ok($diceobj->probability(1612),2.83810043334961e-05);
ok($diceobj->probability(1613),9.87396240234375e-06);
ok($diceobj->probability(1614),1.48207982381185e-05);
ok($diceobj->probability(1615),1.97676340738932e-05);
ok($diceobj->probability(1616),2.4714469909668e-05);
ok($diceobj->probability(1617),3.05387115478516e-05);
ok($diceobj->probability(1618),2.64889907836914e-05);
ok($diceobj->probability(1619),2.88670349121094e-05);
ok($diceobj->probability(1620),3.12253697713216e-05);
ok($diceobj->probability(1621),3.35837046305339e-05);
ok($diceobj->probability(1622),8.93181694878472e-05);
ok($diceobj->probability(1623),0.000143297822740343);
ok($diceobj->probability(1624),0.00020221445719401);
ok($diceobj->probability(1625),0.000248275561862522);
ok($diceobj->probability(1626),0.00029454456753201);
ok($diceobj->probability(1627),0.000341800003051758);
ok($diceobj->probability(1628),0.000282303178575304);
ok($diceobj->probability(1629),0.000223683759901259);
ok($diceobj->probability(1630),0.000165064341227214);
ok($diceobj->probability(1631),0.000112872687445747);
ok($diceobj->probability(1632),6.02849409315321e-05);
ok($diceobj->probability(1633),5.72433471679687e-06);
ok($diceobj->probability(1634),2.50042046440972e-05);
ok($diceobj->probability(1635),4.42840745713976e-05);
ok($diceobj->probability(1636),6.35639444986979e-05);
ok($diceobj->probability(1637),8.28438144259983e-05);
ok($diceobj->probability(1638),0.000102321730719672);
ok($diceobj->probability(1639),0.000122786076863607);
ok($diceobj->probability(1640),0.000145628759596083);
ok($diceobj->probability(1641),0.000168471442328559);
ok($diceobj->probability(1642),0.000191314125061035);
ok($diceobj->probability(1643),0.000214156807793511);
ok($diceobj->probability(1644),0.000236999490525987);
ok($diceobj->probability(1645),0.000259842173258464);
ok($diceobj->probability(1646),0.000216535144382053);
ok($diceobj->probability(1647),0.000173228115505642);
ok($diceobj->probability(1648),0.000129921086629232);
ok($diceobj->probability(1649),8.66140577528212e-05);
ok($diceobj->probability(1650),4.33070288764106e-05);
ok($diceobj->probability(1652),3.39585876464844e-05);
ok($diceobj->probability(1653),6.79171752929687e-05);
ok($diceobj->probability(1654),0.000101875762939453);
ok($diceobj->probability(1655),0.000135835092332628);
ok($diceobj->probability(1656),0.000169794421725803);
ok($diceobj->probability(1657),0.000203753751118978);
ok($diceobj->probability(1658),0.000177079433865017);
ok($diceobj->probability(1659),0.000150405116611057);
ok($diceobj->probability(1660),0.000123730799357096);
ok($diceobj->probability(1661),9.70549986097548e-05);
ok($diceobj->probability(1662),7.03791978624132e-05);
ok($diceobj->probability(1663),4.37033971150716e-05);
ok($diceobj->probability(1664),3.64191267225477e-05);
ok($diceobj->probability(1665),2.91348563300239e-05);
ok($diceobj->probability(1666),4.06604766845703e-05);
ok($diceobj->probability(1667),5.21868387858073e-05);
ok($diceobj->probability(1668),7.36387888590495e-05);
ok($diceobj->probability(1669),9.50907389322917e-05);
ok($diceobj->probability(1670),0.000123826217651367);
ok($diceobj->probability(1671),0.000152561696370443);
ok($diceobj->probability(1672),0.000143677393595378);
ok($diceobj->probability(1673),0.000134793090820313);
ok($diceobj->probability(1674),0.000119317881266276);
ok($diceobj->probability(1675),0.00010384267171224);
ok($diceobj->probability(1676),8.83845223320855e-05);
ok($diceobj->probability(1677),7.29263729519314e-05);
ok($diceobj->probability(1678),7.62781143188477e-05);
ok($diceobj->probability(1679),7.96298556857639e-05);
ok($diceobj->probability(1680),6.63866466946072e-05);
ok($diceobj->probability(1681),5.31434377034505e-05);
ok($diceobj->probability(1682),0.000131762750413683);
ok($diceobj->probability(1683),0.000210382063123915);
ok($diceobj->probability(1684),0.000289001375834147);
ok($diceobj->probability(1685),0.000389645669725206);
ok($diceobj->probability(1686),0.000503550232781304);
ok($diceobj->probability(1687),0.000617454795837402);
ok($diceobj->probability(1688),0.000547583134969076);
ok($diceobj->probability(1689),0.000477711474100749);
ok($diceobj->probability(1690),0.000407839813232422);
ok($diceobj->probability(1691),0.000293918190002441);
ok($diceobj->probability(1692),0.000199892285664876);
ok($diceobj->probability(1693),0.000105866381327311);
ok($diceobj->probability(1694),0.0001037371190389);
ok($diceobj->probability(1695),0.000101607856750488);
ok($diceobj->probability(1696),0.000124901644388835);
ok($diceobj->probability(1697),0.000170220413208008);
ok($diceobj->probability(1698),0.00017574774424235);
ok($diceobj->probability(1699),0.000181275075276693);
ok($diceobj->probability(1700),0.000186802406311035);
ok($diceobj->probability(1701),0.000192329737345378);
ok($diceobj->probability(1702),0.00015997013092041);
ok($diceobj->probability(1703),0.000132991663614909);
ok($diceobj->probability(1704),0.000125908915201823);
ok($diceobj->probability(1705),0.000118826166788737);
ok($diceobj->probability(1706),0.000111743418375651);
ok($diceobj->probability(1707),0.000104678789774577);
ok($diceobj->probability(1708),9.7118886311849e-05);
ok($diceobj->probability(1709),7.87967046101888e-05);
ok($diceobj->probability(1710),6.04745229085286e-05);
ok($diceobj->probability(1711),4.21523412068685e-05);
ok($diceobj->probability(1712),4.44088533189562e-05);
ok($diceobj->probability(1713),4.66291258070204e-05);
ok($diceobj->probability(1714),6.18085606892904e-05);
ok($diceobj->probability(1715),8.23691346910265e-05);
ok($diceobj->probability(1716),0.000102929708692763);
ok($diceobj->probability(1717),0.000123490282694499);
ok($diceobj->probability(1718),0.000152917755974664);
ok($diceobj->probability(1719),0.00018236334906684);
ok($diceobj->probability(1720),0.000211808942159017);
ok($diceobj->probability(1721),0.000241254535251194);
ok($diceobj->probability(1722),0.00027070012834337);
ok($diceobj->probability(1723),0.000300145721435547);
ok($diceobj->probability(1724),0.000250121434529622);
ok($diceobj->probability(1725),0.000200097147623698);
ok($diceobj->probability(1726),0.000150072860717773);
ok($diceobj->probability(1727),0.00010114020453559);
ok($diceobj->probability(1728),5.22075483534071e-05);
ok($diceobj->probability(1729),3.27489217122396e-06);
ok($diceobj->probability(1730),6.52154159545898e-05);
ok($diceobj->probability(1731),0.000136667633056641);
ok($diceobj->probability(1732),0.000208119850158691);
ok($diceobj->probability(1733),0.00027738880581326);
ok($diceobj->probability(1734),0.000346657761467828);
ok($diceobj->probability(1735),0.000415926717122396);
ok($diceobj->probability(1736),0.0003651330142551);
ok($diceobj->probability(1737),0.000295315924750434);
ok($diceobj->probability(1738),0.000225525220235189);
ok($diceobj->probability(1739),0.000156826146443685);
ok($diceobj->probability(1740),8.8127072652181e-05);
ok($diceobj->probability(1741),1.94279988606771e-05);
ok($diceobj->probability(1742),8.69363149007161e-06);
ok($diceobj->probability(1743),7.47095743815104e-06);
ok($diceobj->probability(1744),6.19551340738932e-06);
ok($diceobj->probability(1745),4.9200693766276e-06);
ok($diceobj->probability(1746),3.64462534586589e-06);
ok($diceobj->probability(1747),2.36918131510417e-06);
ok($diceobj->probability(1748),1.95672776963976e-06);
ok($diceobj->probability(1749),1.54427422417535e-06);
ok($diceobj->probability(1750),1.18058522542318e-06);
ok($diceobj->probability(1751),8.16896226671007e-07);
ok($diceobj->probability(1752),3.5776858859592e-06);
ok($diceobj->probability(1753),6.3384755452474e-06);
ok($diceobj->probability(1754),9.48533376057943e-06);
ok($diceobj->probability(1755),1.26321919759115e-05);
ok($diceobj->probability(1756),1.57342910766602e-05);
ok($diceobj->probability(1757),4.83883963690864e-05);
ok($diceobj->probability(1758),7.47935443454319e-05);
ok($diceobj->probability(1759),0.000101198692321777);
ok($diceobj->probability(1760),0.000127603840298123);
ok($diceobj->probability(1761),0.000154008988274468);
ok($diceobj->probability(1762),0.000232954177856445);
ok($diceobj->probability(1763),0.000252795355055067);
ok($diceobj->probability(1764),0.00027576101091173);
ok($diceobj->probability(1765),0.000298726666768392);
ok($diceobj->probability(1766),0.0003583031378852);
ok($diceobj->probability(1767),0.000417879609002007);
ok($diceobj->probability(1768),0.000372420756022135);
ok($diceobj->probability(1769),0.000356514015197754);
ok($diceobj->probability(1770),0.000358729184468587);
ok($diceobj->probability(1771),0.000360944353739421);
ok($diceobj->probability(1772),0.000289937892489963);
ok($diceobj->probability(1773),0.000223646397060818);
ok($diceobj->probability(1774),0.000209872563680013);
ok($diceobj->probability(1775),0.000196098518371582);
ok($diceobj->probability(1776),0.000146080652872721);
ok($diceobj->probability(1777),9.60627873738607e-05);
ok($diceobj->probability(1778),8.26557371351454e-05);
ok($diceobj->probability(1779),5.98187552558051e-05);
ok($diceobj->probability(1780),3.69817733764648e-05);
ok($diceobj->probability(1781),1.41448974609375e-05);
ok($diceobj->probability(1782),9.429931640625e-06);
ok($diceobj->probability(1783),4.7149658203125e-06);
ok($diceobj->probability(1784),2.67211278279622e-05);
ok($diceobj->probability(1785),5.34422556559245e-05);
ok($diceobj->probability(1786),8.01633834838867e-05);
ok($diceobj->probability(1787),0.000116805839538574);
ok($diceobj->probability(1788),0.000153448295593262);
ok($diceobj->probability(1789),0.000190090751647949);
ok($diceobj->probability(1790),0.000173290952046712);
ok($diceobj->probability(1791),0.000156491152445475);
ok($diceobj->probability(1792),0.000139691352844238);
ok($diceobj->probability(1793),0.000103048896789551);
ok($diceobj->probability(1794),8.97793451944987e-05);
ok($diceobj->probability(1795),7.65097935994466e-05);
ok($diceobj->probability(1796),9.30818769666884e-05);
ok($diceobj->probability(1797),0.00010965396033393);
ok($diceobj->probability(1798),0.000126226043701172);
ok($diceobj->probability(1799),0.000152719455295139);
ok($diceobj->probability(1800),0.000132467057969835);
ok($diceobj->probability(1801),0.000112214660644531);
ok($diceobj->probability(1802),0.000169898677402072);
ok($diceobj->probability(1803),0.000227582694159614);
ok($diceobj->probability(1804),0.000285266710917155);
ok($diceobj->probability(1805),0.000342950727674696);
ok($diceobj->probability(1806),0.000424007648891873);
ok($diceobj->probability(1807),0.000505291786193848);
ok($diceobj->probability(1808),0.000421341573927138);
ok($diceobj->probability(1809),0.000337391361660427);
ok($diceobj->probability(1810),0.000253441149393717);
ok($diceobj->probability(1811),0.000169490937127007);
ok($diceobj->probability(1812),8.55407248602973e-05);
ok($diceobj->probability(1813),1.13608042399089e-06);
ok($diceobj->probability(1814),9.08864339192708e-07);
ok($diceobj->probability(1815),6.81648254394531e-07);
ok($diceobj->probability(1816),4.54432169596354e-07);
ok($diceobj->probability(1817),2.09581883748372e-05);
ok($diceobj->probability(1818),4.14619445800781e-05);
ok($diceobj->probability(1819),6.21929168701172e-05);
ok($diceobj->probability(1820),8.29238891601562e-05);
ok($diceobj->probability(1821),0.000103654861450195);
ok($diceobj->probability(1822),0.000177176462809245);
ok($diceobj->probability(1823),0.000209236119588216);
ok($diceobj->probability(1824),0.000241295776367188);
ok($diceobj->probability(1825),0.000273355433146159);
ok($diceobj->probability(1826),0.000324503474765354);
ok($diceobj->probability(1827),0.000375651516384549);
ok($diceobj->probability(1828),0.000321218299865723);
ok($diceobj->probability(1829),0.000287748179965549);
ok($diceobj->probability(1830),0.000254278060065375);
ok($diceobj->probability(1831),0.000220807940165202);
ok($diceobj->probability(1832),0.000149161050584581);
ok($diceobj->probability(1833),7.75141610039605e-05);
ok($diceobj->probability(1834),5.86579004923503e-05);
ok($diceobj->probability(1835),3.93373913235135e-05);
ok($diceobj->probability(1836),2.00168821546766e-05);
ok($diceobj->probability(1837),6.96372985839844e-07);
ok($diceobj->probability(1838),3.00423516167535e-05);
ok($diceobj->probability(1839),5.93883302476671e-05);
ok($diceobj->probability(1840),8.87343088785807e-05);
ok($diceobj->probability(1841),0.000118312411838108);
ok($diceobj->probability(1842),0.000154846945868598);
ok($diceobj->probability(1843),0.000191381479899089);
ok($diceobj->probability(1844),0.000168759808010525);
ok($diceobj->probability(1845),0.000146138136121962);
ok($diceobj->probability(1846),0.000123516464233398);
ok($diceobj->probability(1847),0.000100894792344835);
ok($diceobj->probability(1848),6.43602583143446e-05);
ok($diceobj->probability(1849),2.78257242838542e-05);
ok($diceobj->probability(1850),9.53049723307292e-05);
ok($diceobj->probability(1851),0.000162784220377604);
ok($diceobj->probability(1852),0.000230263468424479);
ok($diceobj->probability(1853),0.000297742716471354);
ok($diceobj->probability(1854),0.000372178395589193);
ok($diceobj->probability(1855),0.000446614074707031);
ok($diceobj->probability(1856),0.000372178395589193);
ok($diceobj->probability(1857),0.000297742716471354);
ok($diceobj->probability(1858),0.000223460578918457);
ok($diceobj->probability(1859),0.00014917844136556);
ok($diceobj->probability(1860),7.48963038126628e-05);
ok($diceobj->probability(1861),2.63399124145508e-05);
ok($diceobj->probability(1862),5.227173699273e-05);
ok($diceobj->probability(1863),7.82035615709093e-05);
ok($diceobj->probability(1864),0.000113076400756836);
ok($diceobj->probability(1865),0.000151329146491157);
ok($diceobj->probability(1866),0.000189581892225477);
ok($diceobj->probability(1867),0.000176383145650228);
ok($diceobj->probability(1868),0.000163079325358073);
ok($diceobj->probability(1869),0.000149775505065918);
ok($diceobj->probability(1870),0.000118129030863444);
ok($diceobj->probability(1871),7.97227435641819e-05);
ok($diceobj->probability(1872),7.40946239895291e-05);
ok($diceobj->probability(1873),9.41922505696615e-05);
ok($diceobj->probability(1874),0.000195306629604763);
ok($diceobj->probability(1875),0.000296421008639865);
ok($diceobj->probability(1876),0.000406783485412598);
ok($diceobj->probability(1877),0.000521219253540039);
ok($diceobj->probability(1878),0.000570098686218262);
ok($diceobj->probability(1879),0.000618978118896484);
ok($diceobj->probability(1880),0.000505929120381673);
ok($diceobj->probability(1881),0.000392880121866862);
ok($diceobj->probability(1882),0.000279831123352051);
ok($diceobj->probability(1883),0.000186628786722819);
ok($diceobj->probability(1884),0.000126204617818197);
ok($diceobj->probability(1885),6.57804489135742e-05);
ok($diceobj->probability(1886),8.63204956054687e-05);
ok($diceobj->probability(1887),0.0001070134862264);
ok($diceobj->probability(1888),0.000127706476847331);
ok($diceobj->probability(1889),0.000106625989278158);
ok($diceobj->probability(1890),8.55455017089844e-05);
ok($diceobj->probability(1891),6.44650141398112e-05);
ok($diceobj->probability(1892),0.00010175114525689);
ok($diceobj->probability(1893),0.000138731388515896);
ok($diceobj->probability(1894),0.000175711631774902);
ok($diceobj->probability(1895),0.000233925306532118);
ok($diceobj->probability(1896),0.000292138981289334);
ok($diceobj->probability(1897),0.00035035265604655);
ok($diceobj->probability(1898),0.000291833093431261);
ok($diceobj->probability(1899),0.000233466474745009);
ok($diceobj->probability(1900),0.000175099856058757);
ok($diceobj->probability(1901),0.000116733237372504);
ok($diceobj->probability(1902),7.04103554619683e-05);
ok($diceobj->probability(1903),2.40874735514323e-05);
ok($diceobj->probability(1904),3.61312103271484e-05);
ok($diceobj->probability(1905),4.81749471028646e-05);
ok($diceobj->probability(1906),8.68984858194987e-05);
ok($diceobj->probability(1907),0.000125622024536133);
ok($diceobj->probability(1908),0.000140258089701335);
ok($diceobj->probability(1909),0.000154894154866536);
ok($diceobj->probability(1910),0.000169530220031738);
ok($diceobj->probability(1911),0.00018416628519694);
ok($diceobj->probability(1912),0.000145442746480306);
ok($diceobj->probability(1913),0.000114782524108887);
ok($diceobj->probability(1914),9.61660385131836e-05);
ok($diceobj->probability(1915),7.75495529174805e-05);
ok($diceobj->probability(1916),5.9185791015625e-05);
ok($diceobj->probability(1917),4.08220291137695e-05);
ok($diceobj->probability(1918),4.9138069152832e-05);
ok($diceobj->probability(1919),4.13274765014648e-05);
ok($diceobj->probability(1920),3.35168838500977e-05);
ok($diceobj->probability(1921),2.57062911987305e-05);
ok($diceobj->probability(1922),9.78749847412109e-05);
ok($diceobj->probability(1923),0.000170043678283691);
ok($diceobj->probability(1924),0.000242212371826172);
ok($diceobj->probability(1925),0.000322444381713867);
ok($diceobj->probability(1926),0.000402676391601563);
ok($diceobj->probability(1927),0.000485883865356445);
ok($diceobj->probability(1928),0.00040837459564209);
ok($diceobj->probability(1929),0.000330865325927734);
ok($diceobj->probability(1930),0.000253356056213379);
ok($diceobj->probability(1931),0.000175846786499023);
ok($diceobj->probability(1932),9.8337516784668e-05);
ok($diceobj->probability(1933),1.48773193359375e-05);
ok($diceobj->probability(1934),2.03717549641927e-05);
ok($diceobj->probability(1935),2.58661905924479e-05);
ok($diceobj->probability(1936),3.13606262207031e-05);
ok($diceobj->probability(1937),3.68550618489583e-05);
ok($diceobj->probability(1938),7.33194986979167e-05);
ok($diceobj->probability(1939),0.000112759399414063);
ok($diceobj->probability(1940),0.000137832429673937);
ok($diceobj->probability(1941),0.000162905459933811);
ok($diceobj->probability(1942),0.000187978490193685);
ok($diceobj->probability(1943),0.000213051520453559);
ok($diceobj->probability(1944),0.000176184548272027);
ok($diceobj->probability(1945),0.000139317576090495);
ok($diceobj->probability(1946),0.000138392363654243);
ok($diceobj->probability(1947),0.00013746715121799);
ok($diceobj->probability(1948),0.000136541938781738);
ok($diceobj->probability(1949),0.000135616726345486);
ok($diceobj->probability(1950),0.000165661515129937);
ok($diceobj->probability(1951),0.000195706303914388);
ok($diceobj->probability(1952),0.000208349927266439);
ok($diceobj->probability(1953),0.00022099355061849);
ok($diceobj->probability(1954),0.00023363717397054);
ok($diceobj->probability(1955),0.0002463103612264);
ok($diceobj->probability(1956),0.000258983548482259);
ok($diceobj->probability(1957),0.000272165718078613);
ok($diceobj->probability(1958),0.000227442923651801);
ok($diceobj->probability(1959),0.000182720129224989);
ok($diceobj->probability(1960),0.000137997334798177);
ok($diceobj->probability(1961),9.32154125637478e-05);
ok($diceobj->probability(1962),8.00349638197157e-05);
ok($diceobj->probability(1963),6.5836550394694e-05);
ok($diceobj->probability(1964),9.68994776407878e-05);
ok($diceobj->probability(1965),0.000127962404886882);
ok($diceobj->probability(1966),0.000159025332132975);
ok($diceobj->probability(1967),0.000190117823282878);
ok($diceobj->probability(1968),0.000158007367451986);
ok($diceobj->probability(1969),0.000126405893961589);
ok($diceobj->probability(1970),9.48044204711914e-05);
ok($diceobj->probability(1971),6.32029469807943e-05);
ok($diceobj->probability(1972),3.16014734903971e-05);
ok($diceobj->probability(1974),1.55766805013021e-08);
ok($diceobj->probability(1975),3.11533610026042e-08);
ok($diceobj->probability(1976),4.67300415039063e-08);
ok($diceobj->probability(1977),6.23067220052083e-08);
ok($diceobj->probability(1978),1.724853515625e-05);
ok($diceobj->probability(1979),3.44347635904948e-05);
ok($diceobj->probability(1980),5.1589838663737e-05);
ok($diceobj->probability(1981),6.87449137369792e-05);
ok($diceobj->probability(1982),0.000203691012064616);
ok($diceobj->probability(1983),0.000338637110392253);
ok($diceobj->probability(1984),0.000439241905212402);
ok($diceobj->probability(1985),0.000539846700032552);
ok($diceobj->probability(1986),0.000640486780802409);
ok($diceobj->probability(1987),0.000741126861572266);
ok($diceobj->probability(1988),0.000606184895833333);
ok($diceobj->probability(1989),0.000471242930094401);
ok($diceobj->probability(1990),0.000353471616109212);
ok($diceobj->probability(1991),0.000265151629977756);
ok($diceobj->probability(1992),0.000176792225307888);
ok($diceobj->probability(1993),8.84328206380208e-05);
ok($diceobj->probability(1994),0.000117864439222548);
ok($diceobj->probability(1995),0.000147296057807075);
ok($diceobj->probability(1996),0.000176727676391602);
ok($diceobj->probability(1997),0.000155946201748318);
ok($diceobj->probability(1998),0.00013518443637424);
ok($diceobj->probability(1999),0.000114422671000163);
ok($diceobj->probability(2000),9.36609056260851e-05);
ok($diceobj->probability(2001),7.28991402520074e-05);
ok($diceobj->probability(2002),6.75987752278646e-05);
ok($diceobj->probability(2003),7.43706130981445e-05);
ok($diceobj->probability(2004),0.000145632387797038);
ok($diceobj->probability(2005),0.000216894162495931);
ok($diceobj->probability(2006),0.000288155937194824);
ok($diceobj->probability(2007),0.000359417711893717);
ok($diceobj->probability(2008),0.000399756685892741);
ok($diceobj->probability(2009),0.000448785222371419);
ok($diceobj->probability(2010),0.000368833885192871);
ok($diceobj->probability(2011),0.000288882548014323);
ok($diceobj->probability(2012),0.000208931210835775);
ok($diceobj->probability(2013),0.000128979873657227);
ok($diceobj->probability(2014),6.44899368286133e-05);
ok($diceobj->probability(2017),2.10444132486979e-08);
ok($diceobj->probability(2018),0.000110638788011339);
ok($diceobj->probability(2019),0.000221256531609429);
ok($diceobj->probability(2020),0.00033187427520752);
ok($diceobj->probability(2021),0.00044249201880561);
ok($diceobj->probability(2022),0.0005531097624037);
ok($diceobj->probability(2023),0.000663685417175293);
ok($diceobj->probability(2024),0.000553067673577203);
ok($diceobj->probability(2025),0.000446211539374457);
ok($diceobj->probability(2026),0.000347537167867025);
ok($diceobj->probability(2027),0.000266710014343262);
ok($diceobj->probability(2028),0.000185882860819499);
ok($diceobj->probability(2029),0.000105076751708984);
ok($diceobj->probability(2030),0.000167951766120063);
ok($diceobj->probability(2031),0.000223303561740451);
ok($diceobj->probability(2032),0.000262773717244466);
ok($diceobj->probability(2033),0.000266549436781142);
ok($diceobj->probability(2034),0.000270325156317817);
ok($diceobj->probability(2035),0.000274100875854492);
ok($diceobj->probability(2036),0.000211707746717665);
ok($diceobj->probability(2037),0.000153076226976183);
ok($diceobj->probability(2038),0.00010166269938151);
ok($diceobj->probability(2039),6.80963897705078e-05);
ok($diceobj->probability(2040),3.45300801595052e-05);
ok($diceobj->probability(2041),9.63770548502604e-07);
ok($diceobj->probability(2042),5.98830625745985e-05);
ok($diceobj->probability(2043),0.000118802354600694);
ok($diceobj->probability(2044),0.000178203531901042);
ok($diceobj->probability(2045),0.000237604709201389);
ok($diceobj->probability(2046),0.000297005886501736);
ok($diceobj->probability(2047),0.000356407063802083);
ok($diceobj->probability(2048),0.00029703926510281);
ok($diceobj->probability(2049),0.000237671466403537);
ok($diceobj->probability(2050),0.000186979370117188);
ok($diceobj->probability(2051),0.000136287273830838);
ok($diceobj->probability(2052),8.55951775444878e-05);
ok($diceobj->probability(2053),3.4903081258138e-05);
ok($diceobj->probability(2054),7.1232181125217e-05);
ok($diceobj->probability(2055),0.000107561280992296);
ok($diceobj->probability(2056),0.000126538976033529);
ok($diceobj->probability(2057),0.000145516671074761);
ok($diceobj->probability(2058),0.000164494366115994);
ok($diceobj->probability(2059),0.000204889678955078);
ok($diceobj->probability(2060),0.000197743648952908);
ok($diceobj->probability(2061),0.000190597618950738);
ok($diceobj->probability(2062),0.000192127291361491);
ok($diceobj->probability(2063),0.000193656963772244);
ok($diceobj->probability(2064),0.000195186636182997);
ok($diceobj->probability(2065),0.000153881072998047);
ok($diceobj->probability(2066),0.000124664624532064);
ok($diceobj->probability(2067),9.54481760660807e-05);
ok($diceobj->probability(2068),6.62317276000977e-05);
ok($diceobj->probability(2069),3.70152791341146e-05);
ok($diceobj->probability(2070),7.79883066813151e-06);
ok($diceobj->probability(2072),1.26159328884549e-05);
ok($diceobj->probability(2073),2.52318657769097e-05);
ok($diceobj->probability(2074),3.78477986653646e-05);
ok($diceobj->probability(2075),5.04637315538194e-05);
ok($diceobj->probability(2076),6.30796644422743e-05);
ok($diceobj->probability(2077),7.56955973307292e-05);
ok($diceobj->probability(2078),6.30796644422743e-05);
ok($diceobj->probability(2079),5.04637315538194e-05);
ok($diceobj->probability(2080),3.78477986653646e-05);
ok($diceobj->probability(2081),4.46588473849826e-05);
ok($diceobj->probability(2082),0.000114033309088813);
ok($diceobj->probability(2083),0.000183407770792643);
ok($diceobj->probability(2084),0.000265398165384928);
ok($diceobj->probability(2085),0.000347388559977214);
ok($diceobj->probability(2086),0.000429378954569499);
ok($diceobj->probability(2087),0.000472515385945638);
ok($diceobj->probability(2088),0.000390524991353353);
ok($diceobj->probability(2089),0.000308534596761068);
ok($diceobj->probability(2090),0.000227252400716146);
ok($diceobj->probability(2091),0.000145970204671224);
ok($diceobj->probability(2092),9.59000142415365e-05);
ok($diceobj->probability(2093),6.52568054199219e-05);
ok($diceobj->probability(2094),9.71770095825195e-05);
ok($diceobj->probability(2095),0.000134989903767904);
ok($diceobj->probability(2096),0.000171386400858561);
ok($diceobj->probability(2097),0.000207782897949219);
ok($diceobj->probability(2098),0.000181755383809408);
ok($diceobj->probability(2099),0.000155727869669596);
ok($diceobj->probability(2100),0.000129700355529785);
ok($diceobj->probability(2101),9.1887461344401e-05);
ok($diceobj->probability(2102),0.000123527247111003);
ok($diceobj->probability(2103),0.000155167032877604);
ok($diceobj->probability(2104),0.00021801882425944);
ok($diceobj->probability(2105),0.000280870615641276);
ok($diceobj->probability(2106),0.000343722407023112);
ok($diceobj->probability(2107),0.000412466888427734);
ok($diceobj->probability(2108),0.000375264697604709);
ok($diceobj->probability(2109),0.000338062506781684);
ok($diceobj->probability(2110),0.00030086254119873);
ok($diceobj->probability(2111),0.000263662575615777);
ok($diceobj->probability(2112),0.000226462610032823);
ok($diceobj->probability(2113),0.00018926264444987);
ok($diceobj->probability(2114),0.000230056232876248);
ok($diceobj->probability(2115),0.000270849821302626);
ok($diceobj->probability(2116),0.000311638959248861);
ok($diceobj->probability(2117),0.000352428097195096);
ok($diceobj->probability(2118),0.00039321723514133);
ok($diceobj->probability(2119),0.000434006373087565);
ok($diceobj->probability(2120),0.00036167049407959);
ok($diceobj->probability(2121),0.000289334615071615);
ok($diceobj->probability(2122),0.000217000961303711);
ok($diceobj->probability(2123),0.000144667307535807);
ok($diceobj->probability(2124),7.23336537679037e-05);
ok($diceobj->probability(2127),3.20663452148437e-07);
ok($diceobj->probability(2128),6.41326904296875e-07);
ok($diceobj->probability(2129),9.61990356445313e-07);
ok($diceobj->probability(2130),2.57604853312174e-05);
ok($diceobj->probability(2131),5.05589803059896e-05);
ok($diceobj->probability(2132),7.53574752807617e-05);
ok($diceobj->probability(2133),9.9514643351237e-05);
ok($diceobj->probability(2134),0.000123671811421712);
ok($diceobj->probability(2135),0.000147828979492187);
ok($diceobj->probability(2136),0.000123030484517415);
ok($diceobj->probability(2137),9.82319895426432e-05);
ok($diceobj->probability(2138),7.34334945678711e-05);
ok($diceobj->probability(2139),4.89556630452474e-05);
ok($diceobj->probability(2140),2.44778315226237e-05);
ok($diceobj->probability(2144),3.9259401957194e-05);
ok($diceobj->probability(2145),7.8518803914388e-05);
ok($diceobj->probability(2146),0.000117778205871582);
ok($diceobj->probability(2147),0.000214142735799154);
ok($diceobj->probability(2148),0.000310507265726725);
ok($diceobj->probability(2149),0.000406871795654297);
ok($diceobj->probability(2150),0.00042471752166748);
ok($diceobj->probability(2151),0.000442563247680664);
ok($diceobj->probability(2152),0.000460408973693848);
ok($diceobj->probability(2153),0.000364044443766276);
ok($diceobj->probability(2154),0.000267679913838704);
ok($diceobj->probability(2155),0.000171315383911133);
ok($diceobj->probability(2156),0.000114210255940755);
ok($diceobj->probability(2157),5.71051279703776e-05);
ok($diceobj->probability(2158),3.71200561523438e-05);
ok($diceobj->probability(2159),7.42401123046875e-05);
ok($diceobj->probability(2160),0.000111360168457031);
ok($diceobj->probability(2161),0.000148480224609375);
ok($diceobj->probability(2162),0.000341095564100477);
ok($diceobj->probability(2163),0.00053371090359158);
ok($diceobj->probability(2164),0.000652086130777995);
ok($diceobj->probability(2165),0.00077046135796441);
ok($diceobj->probability(2166),0.000888836585150825);
ok($diceobj->probability(2167),0.00100721181233724);
ok($diceobj->probability(2168),0.000815504519144694);
ok($diceobj->probability(2169),0.000623797225952148);
ok($diceobj->probability(2170),0.000469209988911947);
ok($diceobj->probability(2171),0.000314622751871745);
ok($diceobj->probability(2172),0.000160097694396973);
ok($diceobj->probability(2173),5.57263692220052e-06);
ok($diceobj->probability(2174),4.72677018907335e-06);
ok($diceobj->probability(2175),3.88090345594618e-06);
ok($diceobj->probability(2176),3.03503672281901e-06);
ok($diceobj->probability(2177),2.29644775390625e-06);
ok($diceobj->probability(2178),1.79327646891276e-05);
ok($diceobj->probability(2179),3.3569081624349e-05);
ok($diceobj->probability(2180),8.68672900729709e-05);
ok($diceobj->probability(2181),0.000140165498521593);
ok($diceobj->probability(2182),0.000193463706970215);
ok($diceobj->probability(2183),0.000246547359890408);
ok($diceobj->probability(2184),0.000266694662306044);
ok($diceobj->probability(2185),0.00028684196472168);
ok($diceobj->probability(2186),0.00032496280670166);
ok($diceobj->probability(2187),0.000363314208984375);
ok($diceobj->probability(2188),0.00040166561126709);
ok($diceobj->probability(2189),0.000441165152655707);
ok($diceobj->probability(2190),0.000497163959079319);
ok($diceobj->probability(2191),0.00055316276550293);
ok($diceobj->probability(2192),0.00046295295715332);
ok($diceobj->probability(2193),0.000372282028198242);
ok($diceobj->probability(2194),0.000281611099243164);
ok($diceobj->probability(2195),0.000188858447604709);
ok($diceobj->probability(2196),9.61057959662543e-05);
ok($diceobj->probability(2197),3.35314432779948e-06);
ok($diceobj->probability(2198),2.08172268337674e-06);
ok($diceobj->probability(2199),1.29610273573134e-05);
ok($diceobj->probability(2200),2.384033203125e-05);
ok($diceobj->probability(2201),3.5760498046875e-05);
ok($diceobj->probability(2202),9.05466079711914e-05);
ok($diceobj->probability(2203),0.000145332717895508);
ok($diceobj->probability(2204),0.000200118827819824);
ok($diceobj->probability(2205),0.000231064605712891);
ok($diceobj->probability(2206),0.000262012608846029);
ok($diceobj->probability(2207),0.000300070465935601);
ok($diceobj->probability(2208),0.000252396435207791);
ok($diceobj->probability(2209),0.00020472240447998);
ok($diceobj->probability(2210),0.000168743642171224);
ok($diceobj->probability(2211),0.000144685045878092);
ok($diceobj->probability(2212),0.000164167073567708);
ok($diceobj->probability(2213),0.000169429393344455);
ok($diceobj->probability(2214),0.000217557657029894);
ok($diceobj->probability(2215),0.000265685920715332);
ok($diceobj->probability(2216),0.000290423647562663);
ok($diceobj->probability(2217),0.000315161374409994);
ok($diceobj->probability(2218),0.000252811177571615);
ok($diceobj->probability(2219),0.00019757083468967);
ok($diceobj->probability(2220),0.000142330491807726);
ok($diceobj->probability(2221),8.70901489257812e-05);
ok($diceobj->probability(2222),4.35450744628906e-05);
ok($diceobj->probability(2225),2.8007083468967e-05);
ok($diceobj->probability(2226),5.6014166937934e-05);
ok($diceobj->probability(2227),8.4021250406901e-05);
ok($diceobj->probability(2228),0.000112028333875868);
ok($diceobj->probability(2229),0.000140035417344835);
ok($diceobj->probability(2230),0.000168042500813802);
ok($diceobj->probability(2231),0.000140035417344835);
ok($diceobj->probability(2232),0.000112028333875868);
ok($diceobj->probability(2233),8.4021250406901e-05);
ok($diceobj->probability(2234),5.61034944322374e-05);
ok($diceobj->probability(2235),2.86435021294488e-05);
ok($diceobj->probability(2236),1.18350982666016e-06);
ok($diceobj->probability(2237),1.73060099283854e-06);
ok($diceobj->probability(2238),2.27769215901693e-06);
ok($diceobj->probability(2239),2.82478332519531e-06);
ok($diceobj->probability(2240),3.19321950276693e-06);
ok($diceobj->probability(2241),2.64612833658854e-06);
ok($diceobj->probability(2242),7.14216613769531e-05);
ok($diceobj->probability(2243),0.000140197194417318);
ok($diceobj->probability(2244),0.000208972727457682);
ok($diceobj->probability(2245),0.000277748260498047);
ok($diceobj->probability(2246),0.000400415293375651);
ok($diceobj->probability(2247),0.00052354008992513);
ok($diceobj->probability(2248),0.000508019638061523);
ok($diceobj->probability(2249),0.000492499186197917);
ok($diceobj->probability(2250),0.00047697873433431);
ok($diceobj->probability(2251),0.000461458282470703);
ok($diceobj->probability(2252),0.000369084137810601);
ok($diceobj->probability(2253),0.000276709993150499);
ok($diceobj->probability(2254),0.00025365847269694);
ok($diceobj->probability(2255),0.000230606952243381);
ok($diceobj->probability(2256),0.000213235516018338);
ok($diceobj->probability(2257),0.000195864079793294);
ok($diceobj->probability(2258),0.000170793512132433);
ok($diceobj->probability(2259),0.000145722944471571);
ok($diceobj->probability(2260),0.00012065237681071);
ok($diceobj->probability(2261),9.55818091498481e-05);
ok($diceobj->probability(2262),5.91510730319553e-05);
ok($diceobj->probability(2263),2.90785471598307e-05);
ok($diceobj->probability(2264),3.00615098741319e-05);
ok($diceobj->probability(2265),3.10444725884332e-05);
ok($diceobj->probability(2266),3.20274353027344e-05);
ok($diceobj->probability(2267),3.30103980170356e-05);
ok($diceobj->probability(2268),3.96734449598524e-05);
ok($diceobj->probability(2269),3.36200714111328e-05);
ok($diceobj->probability(2270),8.62026850382487e-05);
ok($diceobj->probability(2271),0.000138785298665365);
ok($diceobj->probability(2272),0.00019136791229248);
ok($diceobj->probability(2273),0.000243950525919596);
ok($diceobj->probability(2274),0.000296533139546712);
ok($diceobj->probability(2275),0.000355473963419596);
ok($diceobj->probability(2276),0.000296228302849664);
ok($diceobj->probability(2277),0.000240692626105415);
ok($diceobj->probability(2278),0.000185156949361165);
ok($diceobj->probability(2279),0.000142641597323947);
ok($diceobj->probability(2280),0.00010012624528673);
ok($diceobj->probability(2281),5.76108932495117e-05);
ok($diceobj->probability(2282),0.000129680692884657);
ok($diceobj->probability(2283),0.000194330524868435);
ok($diceobj->probability(2284),0.000258980356852214);
ok($diceobj->probability(2285),0.000297589539421929);
ok($diceobj->probability(2286),0.000336198721991645);
ok($diceobj->probability(2287),0.000374807904561361);
ok($diceobj->probability(2288),0.000302738104926215);
ok($diceobj->probability(2289),0.000234378289116753);
ok($diceobj->probability(2290),0.000240070711771647);
ok($diceobj->probability(2291),0.000258783459133572);
ok($diceobj->probability(2292),0.000277496206495497);
ok($diceobj->probability(2293),0.000296208953857422);
ok($diceobj->probability(2294),0.000370261192321777);
ok($diceobj->probability(2295),0.000444313430786133);
ok($diceobj->probability(2296),0.000370261192321777);
ok($diceobj->probability(2297),0.000326015841166178);
ok($diceobj->probability(2298),0.000281770490010579);
ok($diceobj->probability(2299),0.00023752513885498);
ok($diceobj->probability(2300),0.000193279787699382);
ok($diceobj->probability(2301),0.000169559415181478);
ok($diceobj->probability(2302),0.00022720827738444);
ok($diceobj->probability(2303),0.000225243364969889);
ok($diceobj->probability(2304),0.000223278452555339);
ok($diceobj->probability(2305),0.000221313540140788);
ok($diceobj->probability(2306),0.000290723944769965);
ok($diceobj->probability(2307),0.000319084392123752);
ok($diceobj->probability(2308),0.000332810846964518);
ok($diceobj->probability(2309),0.000376344189114041);
ok($diceobj->probability(2310),0.000419877531263563);
ok($diceobj->probability(2311),0.000463410873413086);
ok($diceobj->probability(2312),0.000456994166904026);
ok($diceobj->probability(2313),0.000471102439032661);
ok($diceobj->probability(2314),0.000500237274169922);
ok($diceobj->probability(2315),0.000529372109307183);
ok($diceobj->probability(2316),0.000558506944444444);
ok($diceobj->probability(2317),0.000587641779581706);
ok($diceobj->probability(2318),0.000502550760904948);
ok($diceobj->probability(2319),0.00041745974222819);
ok($diceobj->probability(2320),0.000316949590047201);
ok($diceobj->probability(2321),0.000216439437866211);
ok($diceobj->probability(2322),0.000116601435343424);
ok($diceobj->probability(2323),1.6763432820638e-05);
ok($diceobj->probability(2324),9.72601572672526e-06);
ok($diceobj->probability(2325),2.6885986328125e-06);
ok($diceobj->probability(2326),3.36074829101563e-06);
ok($diceobj->probability(2327),4.04728783501519e-06);
ok($diceobj->probability(2328),3.38952806260851e-06);
ok($diceobj->probability(2329),2.73176829020182e-06);
ok($diceobj->probability(2330),2.07400851779514e-06);
ok($diceobj->probability(2331),1.41624874538845e-06);
ok($diceobj->probability(2332),7.58488972981771e-07);
ok($diceobj->probability(2333),7.19494289822049e-08);
ok($diceobj->probability(2334),5.75595431857639e-08);
ok($diceobj->probability(2335),4.31696573893229e-08);
ok($diceobj->probability(2336),2.87797715928819e-08);
ok($diceobj->probability(2337),1.4389885796441e-08);
ok($diceobj->probability(2342),0.000144314778645833);
ok($diceobj->probability(2343),0.000288629557291667);
ok($diceobj->probability(2344),0.0004329443359375);
ok($diceobj->probability(2345),0.000577259114583333);
ok($diceobj->probability(2346),0.000721573893229167);
ok($diceobj->probability(2347),0.000865888671875);
ok($diceobj->probability(2348),0.000723074425591363);
ok($diceobj->probability(2349),0.000580260179307726);
ok($diceobj->probability(2350),0.000437445933024089);
ok($diceobj->probability(2351),0.000294957059224447);
ok($diceobj->probability(2352),0.000152468185424805);
ok($diceobj->probability(2353),9.97931162516276e-06);
ok($diceobj->probability(2354),7.13936275906033e-05);
ok($diceobj->probability(2355),0.000132807943556044);
ok($diceobj->probability(2356),0.000194222259521484);
ok($diceobj->probability(2357),0.000254985830518934);
ok($diceobj->probability(2358),0.000315749719407823);
ok($diceobj->probability(2359),0.000376513608296712);
ok($diceobj->probability(2360),0.000313599077860514);
ok($diceobj->probability(2361),0.000250684547424316);
ok($diceobj->probability(2362),0.000187770016988118);
ok($diceobj->probability(2363),0.000125180859035916);
ok($diceobj->probability(2364),6.25910653008355e-05);
ok($diceobj->probability(2365),1.27156575520833e-09);
ok($diceobj->probability(2366),9.5367431640625e-10);
ok($diceobj->probability(2367),6.35782877604167e-10);
ok($diceobj->probability(2368),4.0716298421224e-05);
ok($diceobj->probability(2369),8.14319610595703e-05);
ok($diceobj->probability(2370),0.000122147941589355);
ok($diceobj->probability(2371),0.000162863922119141);
ok($diceobj->probability(2372),0.000203579902648926);
ok($diceobj->probability(2373),0.000244295883178711);
ok($diceobj->probability(2374),0.000203579902648926);
ok($diceobj->probability(2375),0.000162863922119141);
ok($diceobj->probability(2376),0.000122147941589355);
ok($diceobj->probability(2377),8.157470703125e-05);
ok($diceobj->probability(2378),0.000125512084960937);
ok($diceobj->probability(2379),0.000169449462890625);
ok($diceobj->probability(2380),0.000254102821350098);
ok($diceobj->probability(2381),0.00033875617980957);
ok($diceobj->probability(2382),0.000474187800089518);
ok($diceobj->probability(2383),0.000609333928426107);
ok($diceobj->probability(2384),0.000575458831787109);
ok($diceobj->probability(2385),0.000541583735148112);
ok($diceobj->probability(2386),0.000507708638509115);
ok($diceobj->probability(2387),0.000473833541870117);
ok($diceobj->probability(2388),0.000338401921590169);
ok($diceobj->probability(2389),0.000203170267740885);
ok($diceobj->probability(2390),0.000152449226379395);
ok($diceobj->probability(2391),0.000101728185017904);
ok($diceobj->probability(2392),5.10071436564128e-05);
ok($diceobj->probability(2393),2.86102294921875e-07);
ok($diceobj->probability(2394),1.08553568522135e-05);
ok($diceobj->probability(2395),2.13101704915365e-05);
ok($diceobj->probability(2396),6.73056920369466e-05);
ok($diceobj->probability(2397),0.000113301213582357);
ok($diceobj->probability(2398),0.000159296735127767);
ok($diceobj->probability(2399),0.000205292256673177);
ok($diceobj->probability(2400),0.000230263710021973);
ok($diceobj->probability(2401),0.000255292383829753);
ok($diceobj->probability(2402),0.000318639797634549);
ok($diceobj->probability(2403),0.000381987211439345);
ok($diceobj->probability(2404),0.000445334625244141);
ok($diceobj->probability(2405),0.000508682039048937);
ok($diceobj->probability(2406),0.00058254148695204);
ok($diceobj->probability(2407),0.000656400934855143);
ok($diceobj->probability(2408),0.000547000779045953);
ok($diceobj->probability(2409),0.000437600623236762);
ok($diceobj->probability(2410),0.000328200467427572);
ok($diceobj->probability(2411),0.000218800311618381);
ok($diceobj->probability(2412),0.000109400155809191);
ok($diceobj->probability(2417),5.22655910915799e-06);
ok($diceobj->probability(2418),1.0453118218316e-05);
ok($diceobj->probability(2419),1.5679677327474e-05);
ok($diceobj->probability(2420),2.09457609388563e-05);
ok($diceobj->probability(2421),2.62118445502387e-05);
ok($diceobj->probability(2422),7.33118057250977e-05);
ok($diceobj->probability(2423),0.000109958648681641);
ok($diceobj->probability(2424),0.000146605491638184);
ok($diceobj->probability(2425),0.000183252334594727);
ok($diceobj->probability(2426),0.000219820128546821);
ok($diceobj->probability(2427),0.000256387922498915);
ok($diceobj->probability(2428),0.000209287961324056);
ok($diceobj->probability(2429),0.000167414559258355);
ok($diceobj->probability(2430),0.000125541157192654);
ok($diceobj->probability(2431),8.36677551269531e-05);
ok($diceobj->probability(2432),7.45854314168294e-05);
ok($diceobj->probability(2433),0.000123182474772135);
ok($diceobj->probability(2434),0.000228453140258789);
ok($diceobj->probability(2435),0.000333723805745443);
ok($diceobj->probability(2436),0.000438994471232096);
ok($diceobj->probability(2437),0.00054426513671875);
ok($diceobj->probability(2438),0.000584854888916016);
ok($diceobj->probability(2439),0.000510085906982422);
ok($diceobj->probability(2440),0.000405637435913086);
ok($diceobj->probability(2441),0.00030118896484375);
ok($diceobj->probability(2442),0.000196740493774414);
ok($diceobj->probability(2443),9.22920227050781e-05);
ok($diceobj->probability(2444),1.89507166544596e-05);
ok($diceobj->probability(2445),3.28877766927083e-06);
ok($diceobj->probability(2446),2.46658325195312e-06);
ok($diceobj->probability(2447),1.64438883463542e-06);
ok($diceobj->probability(2448),8.22194417317708e-07);
ok($diceobj->probability(2450),7.55458407931858e-05);
ok($diceobj->probability(2451),0.000151091681586372);
ok($diceobj->probability(2452),0.000230205980936686);
ok($diceobj->probability(2453),0.000309320280287001);
ok($diceobj->probability(2454),0.000388434579637316);
ok($diceobj->probability(2455),0.00046754887898763);
ok($diceobj->probability(2456),0.000395571496751573);
ok($diceobj->probability(2457),0.000323594114515517);
ok($diceobj->probability(2458),0.000244479815165202);
ok($diceobj->probability(2459),0.000190774133470323);
ok($diceobj->probability(2460),0.000137068451775445);
ok($diceobj->probability(2461),8.33627700805664e-05);
ok($diceobj->probability(2462),0.000105202929178874);
ok($diceobj->probability(2463),0.000127043088277181);
ok($diceobj->probability(2464),0.000152451705932617);
ok($diceobj->probability(2465),0.000127043088277181);
ok($diceobj->probability(2466),0.000181191126505534);
ok($diceobj->probability(2467),0.000235388425191243);
ok($diceobj->probability(2468),0.000289585723876953);
ok($diceobj->probability(2469),0.000343783022562663);
ok($diceobj->probability(2470),0.000397980321248372);
ok($diceobj->probability(2471),0.000477586237589518);
ok($diceobj->probability(2472),0.000439323501586914);
ok($diceobj->probability(2473),0.000400962244669596);
ok($diceobj->probability(2474),0.000362600987752279);
ok($diceobj->probability(2475),0.000324239730834961);
ok($diceobj->probability(2476),0.000285878473917643);
ok($diceobj->probability(2477),0.000286096267700195);
ok($diceobj->probability(2478),0.00028338139851888);
ok($diceobj->probability(2479),0.000280715789794922);
ok($diceobj->probability(2480),0.000278050181070964);
ok($diceobj->probability(2481),0.000275384572347005);
ok($diceobj->probability(2482),0.000272800534566244);
ok($diceobj->probability(2483),0.000193058395385742);
ok($diceobj->probability(2484),0.000154560915629069);
ok($diceobj->probability(2485),0.000116063435872396);
ok($diceobj->probability(2486),9.43813959757487e-05);
ok($diceobj->probability(2487),7.26993560791016e-05);
ok($diceobj->probability(2488),5.08541742960612e-05);
ok($diceobj->probability(2489),6.75880432128906e-05);
ok($diceobj->probability(2490),8.43219121297201e-05);
ok($diceobj->probability(2491),0.000101055781046549);
ok($diceobj->probability(2492),8.41587702433268e-05);
ok($diceobj->probability(2493),6.72617594401042e-05);
ok($diceobj->probability(2494),5.04463195800781e-05);
ok($diceobj->probability(2495),3.36308797200521e-05);
ok($diceobj->probability(2496),1.6815439860026e-05);
ok($diceobj->probability(2498),8.38505850897895e-05);
ok($diceobj->probability(2499),0.000167701170179579);
ok($diceobj->probability(2500),0.000251551755269369);
ok($diceobj->probability(2501),0.000340609084235297);
ok($diceobj->probability(2502),0.000434243503146701);
ok($diceobj->probability(2503),0.000527877922058105);
ok($diceobj->probability(2504),0.000453811170789931);
ok($diceobj->probability(2505),0.000379744419521756);
ok($diceobj->probability(2506),0.000305677668253581);
ok($diceobj->probability(2507),0.000221197429233127);
ok($diceobj->probability(2508),0.000127563010321723);
ok($diceobj->probability(2509),3.3928591410319e-05);
ok($diceobj->probability(2510),7.49626922607422e-05);
ok($diceobj->probability(2511),0.000115996793111165);
ok($diceobj->probability(2512),0.000157030893961589);
ok($diceobj->probability(2513),0.000203310309516059);
ok($diceobj->probability(2514),0.000254166815016005);
ok($diceobj->probability(2515),0.000305023320515951);
ok($diceobj->probability(2516),0.000254243956671821);
ok($diceobj->probability(2517),0.000203464592827691);
ok($diceobj->probability(2518),0.000152685228983561);
ok($diceobj->probability(2519),0.000101828723483615);
ok($diceobj->probability(2520),5.09722179836697e-05);
ok($diceobj->probability(2521),1.15712483723958e-07);
ok($diceobj->probability(2522),0.000201876763237847);
ok($diceobj->probability(2523),0.00040363781399197);
ok($diceobj->probability(2524),0.000605398864746094);
ok($diceobj->probability(2525),0.000807198486328125);
ok($diceobj->probability(2526),0.00100899810791016);
ok($diceobj->probability(2527),0.00121079772949219);
ok($diceobj->probability(2528),0.00100899810791016);
ok($diceobj->probability(2529),0.00080975159962972);
ok($diceobj->probability(2530),0.000610505091349284);
ok($diceobj->probability(2531),0.000411258583068848);
ok($diceobj->probability(2532),0.000231003774007161);
ok($diceobj->probability(2533),5.07489649454753e-05);
ok($diceobj->probability(2534),7.22937774658203e-05);
ok($diceobj->probability(2535),8.87323633829753e-05);
ok($diceobj->probability(2536),0.00010517094930013);
ok($diceobj->probability(2537),0.000160324363708496);
ok($diceobj->probability(2538),0.000177494379679362);
ok($diceobj->probability(2539),0.000194664395650228);
ok($diceobj->probability(2540),0.000211834411621094);
ok($diceobj->probability(2541),0.000231557540893555);
ok($diceobj->probability(2542),0.000251280670166016);
ok($diceobj->probability(2543),0.000210869026184082);
ok($diceobj->probability(2544),0.000189449081420898);
ok($diceobj->probability(2545),0.000168029136657715);
ok($diceobj->probability(2546),0.000146609191894531);
ok($diceobj->probability(2547),0.000125189247131348);
ok($diceobj->probability(2548),0.000103769302368164);
ok($diceobj->probability(2549),8.64744186401367e-05);
ok($diceobj->probability(2550),0.000112898317972819);
ok($diceobj->probability(2551),0.000139322217305501);
ok($diceobj->probability(2552),0.000210955958896213);
ok($diceobj->probability(2553),0.000282589700486925);
ok($diceobj->probability(2554),0.000355011177062988);
ok($diceobj->probability(2555),0.000444727537367079);
ok($diceobj->probability(2556),0.00044700633154975);
ok($diceobj->probability(2557),0.000449285125732422);
ok($diceobj->probability(2558),0.000361144235399034);
ok($diceobj->probability(2559),0.000273003345065647);
ok($diceobj->probability(2560),0.000183286984761556);
ok($diceobj->probability(2561),9.35706244574653e-05);
ok($diceobj->probability(2562),8.33805677625868e-05);
ok($diceobj->probability(2563),7.31905110677083e-05);
ok($diceobj->probability(2564),0.000108210296630859);
ok($diceobj->probability(2565),0.00014323008219401);
ok($diceobj->probability(2566),0.000179037602742513);
ok($diceobj->probability(2567),0.00024238224029541);
ok($diceobj->probability(2568),0.000234111836751302);
ok($diceobj->probability(2569),0.000225841433207194);
ok($diceobj->probability(2570),0.000217571029663086);
ok($diceobj->probability(2571),0.000209300626118978);
ok($diceobj->probability(2572),0.00020103022257487);
ok($diceobj->probability(2573),0.000137685585021973);
ok($diceobj->probability(2574),0.000110148468017578);
ok($diceobj->probability(2575),8.26113510131836e-05);
ok($diceobj->probability(2576),0.000138100992838542);
ok($diceobj->probability(2577),0.0001935906346639);
ok($diceobj->probability(2578),0.000263871637980143);
ok($diceobj->probability(2579),0.000361689758300781);
ok($diceobj->probability(2580),0.000459507878621419);
ok($diceobj->probability(2581),0.000557325998942057);
ok($diceobj->probability(2582),0.00048909060160319);
ok($diceobj->probability(2583),0.000420855204264323);
ok($diceobj->probability(2584),0.000323037083943685);
ok($diceobj->probability(2585),0.000225218963623047);
ok($diceobj->probability(2586),0.000140966796875);
ok($diceobj->probability(2587),5.67146301269531e-05);
ok($diceobj->probability(2588),5.54892222086589e-05);
ok($diceobj->probability(2589),5.42638142903646e-05);
ok($diceobj->probability(2590),6.78297678629557e-05);
ok($diceobj->probability(2591),8.13957214355469e-05);
ok($diceobj->probability(2592),6.78297678629557e-05);
ok($diceobj->probability(2593),5.42638142903646e-05);
ok($diceobj->probability(2594),0.000122836558024089);
ok($diceobj->probability(2595),0.000191409301757813);
ok($diceobj->probability(2596),0.000259982045491536);
ok($diceobj->probability(2597),0.00032855478922526);
ok($diceobj->probability(2598),0.000410693486531576);
ok($diceobj->probability(2599),0.000492832183837891);
ok($diceobj->probability(2600),0.000410693486531576);
ok($diceobj->probability(2601),0.00032855478922526);
ok($diceobj->probability(2602),0.000294794260660807);
ok($diceobj->probability(2603),0.000274534984164768);
ok($diceobj->probability(2604),0.000254275707668728);
ok($diceobj->probability(2605),0.000234016431172689);
ok($diceobj->probability(2606),0.000295998530917698);
ok($diceobj->probability(2607),0.000357980630662706);
ok($diceobj->probability(2608),0.000323206392923991);
ok($diceobj->probability(2609),0.000261429651048448);
ok($diceobj->probability(2610),0.000199652909172906);
ok($diceobj->probability(2611),0.000137876167297363);
ok($diceobj->probability(2612),7.71064631144206e-05);
ok($diceobj->probability(2613),1.63367589314779e-05);
ok($diceobj->probability(2614),3.94522349039714e-06);
ok($diceobj->probability(2615),5.05494011773004e-06);
ok($diceobj->probability(2616),6.16465674506293e-06);
ok($diceobj->probability(2617),7.27437337239583e-06);
ok($diceobj->probability(2618),6.06197781032986e-06);
ok($diceobj->probability(2619),4.84958224826389e-06);
ok($diceobj->probability(2620),6.78581873575846e-05);
ok($diceobj->probability(2621),0.000130866792466905);
ok($diceobj->probability(2622),0.000193875397576226);
ok($diceobj->probability(2623),0.000256884002685547);
ok($diceobj->probability(2624),0.000322108607821994);
ok($diceobj->probability(2625),0.000387333212958442);
ok($diceobj->probability(2626),0.000324115816752116);
ok($diceobj->probability(2627),0.000264169396294488);
ok($diceobj->probability(2628),0.00020422297583686);
ok($diceobj->probability(2629),0.000144276555379232);
ok($diceobj->probability(2630),8.23229259914822e-05);
ok($diceobj->probability(2631),2.03692966037326e-05);
ok($diceobj->probability(2632),2.26366678873698e-05);
ok($diceobj->probability(2633),1.83620876736111e-05);
ok($diceobj->probability(2634),1.40875074598524e-05);
ok($diceobj->probability(2635),9.81292724609375e-06);
ok($diceobj->probability(2636),6.54195149739583e-06);
ok($diceobj->probability(2637),3.27701568603516e-06);
ok($diceobj->probability(2638),1.20798746744792e-08);
ok($diceobj->probability(2639),1.81198120117187e-08);
ok($diceobj->probability(2640),2.41597493489583e-08);
ok($diceobj->probability(2641),5.99797566731771e-07);
ok($diceobj->probability(2642),0.000163297297159831);
ok($diceobj->probability(2643),0.000325982716878255);
ok($diceobj->probability(2644),0.00048866813659668);
ok($diceobj->probability(2645),0.000651353556315104);
ok($diceobj->probability(2646),0.000814038976033529);
ok($diceobj->probability(2647),0.000975638910929362);
ok($diceobj->probability(2648),0.000843762817382813);
ok($diceobj->probability(2649),0.0007118927637736);
ok($diceobj->probability(2650),0.000580022710164388);
ok($diceobj->probability(2651),0.000448152656555176);
ok($diceobj->probability(2652),0.000316282602945964);
ok($diceobj->probability(2653),0.000184874725341797);
ok($diceobj->probability(2654),0.00022431160820855);
ok($diceobj->probability(2655),0.000263748491075304);
ok($diceobj->probability(2656),0.000303185373942057);
ok($diceobj->probability(2657),0.000342622256808811);
ok($diceobj->probability(2658),0.000382059139675564);
ok($diceobj->probability(2659),0.000421549733479818);
ok($diceobj->probability(2660),0.000351291444566515);
ok($diceobj->probability(2661),0.000281033155653212);
ok($diceobj->probability(2662),0.000257633679707845);
ok($diceobj->probability(2663),0.000234234203762478);
ok($diceobj->probability(2664),0.00022574351840549);
ok($diceobj->probability(2665),0.000217252833048503);
ok($diceobj->probability(2666),0.000279020436604818);
ok($diceobj->probability(2667),0.000340788040161133);
ok($diceobj->probability(2668),0.000308838017781576);
ok($diceobj->probability(2669),0.000276887995402018);
ok($diceobj->probability(2670),0.000215120391845703);
ok($diceobj->probability(2671),0.000153352788289388);
ok($diceobj->probability(2672),9.15851847330729e-05);
ok($diceobj->probability(2673),2.98175811767578e-05);
ok($diceobj->probability(2674),1.49087905883789e-05);
ok($diceobj->probability(2675),3.99252573649089e-06);
ok($diceobj->probability(2676),7.98505147298177e-06);
ok($diceobj->probability(2677),1.19775772094727e-05);
ok($diceobj->probability(2678),1.59701029459635e-05);
ok($diceobj->probability(2679),1.99626286824544e-05);
ok($diceobj->probability(2680),2.39551544189453e-05);
ok($diceobj->probability(2681),1.99626286824544e-05);
ok($diceobj->probability(2682),1.59701029459635e-05);
ok($diceobj->probability(2683),1.19775772094727e-05);
ok($diceobj->probability(2684),7.98505147298177e-06);
ok($diceobj->probability(2685),3.99252573649089e-06);
ok($diceobj->probability(2690),9.91584565904405e-05);
ok($diceobj->probability(2691),0.000198316913180881);
ok($diceobj->probability(2692),0.000297475369771322);
ok($diceobj->probability(2693),0.00041365966796875);
ok($diceobj->probability(2694),0.000529843966166178);
ok($diceobj->probability(2695),0.000646028264363607);
ok($diceobj->probability(2696),0.000563895649380154);
ok($diceobj->probability(2697),0.000481763034396701);
ok($diceobj->probability(2698),0.000399630419413249);
ok($diceobj->probability(2699),0.00028344612121582);
ok($diceobj->probability(2700),0.000167261823018392);
ok($diceobj->probability(2701),5.10775248209635e-05);
ok($diceobj->probability(2702),0.000152471639845106);
ok($diceobj->probability(2703),0.000253865754869249);
ok($diceobj->probability(2704),0.000355259869893392);
ok($diceobj->probability(2705),0.000473679826524523);
ok($diceobj->probability(2706),0.000635546578301324);
ok($diceobj->probability(2707),0.000797413330078125);
ok($diceobj->probability(2708),0.000722440168592665);
ok($diceobj->probability(2709),0.000647467007107205);
ok($diceobj->probability(2710),0.000572493845621745);
ok($diceobj->probability(2711),0.000497520684136285);
ok($diceobj->probability(2712),0.000335653932359484);
ok($diceobj->probability(2713),0.000173787180582682);
ok($diceobj->probability(2714),0.000130340385437012);
ok($diceobj->probability(2715),8.68935902913411e-05);
ok($diceobj->probability(2716),4.34467951456706e-05);
ok($diceobj->probability(2719),5.46451568603516e-05);
ok($diceobj->probability(2720),0.000109290313720703);
ok($diceobj->probability(2721),0.000163935470581055);
ok($diceobj->probability(2722),0.000273819770812988);
ok($diceobj->probability(2723),0.000383704071044922);
ok($diceobj->probability(2724),0.000493588371276855);
ok($diceobj->probability(2725),0.000494182357788086);
ok($diceobj->probability(2726),0.000494776344299316);
ok($diceobj->probability(2727),0.000495370330810547);
ok($diceobj->probability(2728),0.000385486030578613);
ok($diceobj->probability(2729),0.00027560173034668);
ok($diceobj->probability(2730),0.000165810890197754);
ok($diceobj->probability(2731),0.00011066520690918);
ok($diceobj->probability(2732),0.000173327708774143);
ok($diceobj->probability(2733),0.000235990210639106);
ok($diceobj->probability(2734),0.000353891855875651);
ok($diceobj->probability(2735),0.000471793501112196);
ok($diceobj->probability(2736),0.000589508226182726);
ok($diceobj->probability(2737),0.000707222951253255);
ok($diceobj->probability(2738),0.000658386739095052);
ok($diceobj->probability(2739),0.000613268839518229);
ok($diceobj->probability(2740),0.000568150939941406);
ok($diceobj->probability(2741),0.000523033040364583);
ok($diceobj->probability(2742),0.000478008600870768);
ok($diceobj->probability(2743),0.000432984161376953);
ok($diceobj->probability(2744),0.000367637040879991);
ok($diceobj->probability(2745),0.000294853295220269);
ok($diceobj->probability(2746),0.000237022018432617);
ok($diceobj->probability(2747),0.000179190741644965);
ok($diceobj->probability(2748),0.000121359464857313);
ok($diceobj->probability(2749),6.35281880696615e-05);
ok($diceobj->probability(2750),7.47623443603516e-05);
ok($diceobj->probability(2751),8.97148132324219e-05);
ok($diceobj->probability(2752),8.66285705566406e-05);
ok($diceobj->probability(2753),8.35423278808594e-05);
ok($diceobj->probability(2754),8.04560852050781e-05);
ok($diceobj->probability(2755),7.73698425292969e-05);
ok($diceobj->probability(2756),0.00010039005279541);
ok($diceobj->probability(2757),0.000123431854248047);
ok($diceobj->probability(2758),0.000137693672180176);
ok($diceobj->probability(2759),0.000151955490112305);
ok($diceobj->probability(2760),0.000166217308044434);
ok($diceobj->probability(2761),0.000180479125976563);
ok($diceobj->probability(2762),0.000175924339294434);
ok($diceobj->probability(2763),0.000171326370239258);
ok($diceobj->probability(2764),0.000178594627380371);
ok($diceobj->probability(2765),0.000185862884521484);
ok($diceobj->probability(2766),0.000193131141662598);
ok($diceobj->probability(2767),0.000200399398803711);
ok($diceobj->probability(2768),0.000166981506347656);
ok($diceobj->probability(2769),0.000133585205078125);
ok($diceobj->probability(2770),0.000100188903808594);
ok($diceobj->probability(2771),6.67926025390625e-05);
ok($diceobj->probability(2772),3.33963012695313e-05);
ok($diceobj->probability(2774),0.000127978960673014);
ok($diceobj->probability(2775),0.000255957921346029);
ok($diceobj->probability(2776),0.000383936882019043);
ok($diceobj->probability(2777),0.000511915842692057);
ok($diceobj->probability(2778),0.000639894803365072);
ok($diceobj->probability(2779),0.000767873764038086);
ok($diceobj->probability(2780),0.000639894803365072);
ok($diceobj->probability(2781),0.000511915842692057);
ok($diceobj->probability(2782),0.000383936882019043);
ok($diceobj->probability(2783),0.000255957921346029);
ok($diceobj->probability(2784),0.000127978960673014);
ok($diceobj->probability(2785),1.24626159667969e-05);
ok($diceobj->probability(2786),2.60488722059462e-05);
ok($diceobj->probability(2787),3.96351284450955e-05);
ok($diceobj->probability(2788),5.32213846842448e-05);
ok($diceobj->probability(2789),6.68076409233941e-05);
ok($diceobj->probability(2790),8.03938971625434e-05);
ok($diceobj->probability(2791),6.9054921468099e-05);
ok($diceobj->probability(2792),5.56107838948568e-05);
ok($diceobj->probability(2793),4.21666463216146e-05);
ok($diceobj->probability(2794),2.87225087483724e-05);
ok($diceobj->probability(2795),1.93883895874023e-05);
ok($diceobj->probability(2796),1.00542704264323e-05);
ok($diceobj->probability(2797),1.31827672322591e-05);
ok($diceobj->probability(2798),1.71506669786241e-05);
ok($diceobj->probability(2799),2.11185667249891e-05);
ok($diceobj->probability(2800),2.50864664713542e-05);
ok($diceobj->probability(2801),2.08343293931749e-05);
ok($diceobj->probability(2802),6.86208682590061e-05);
ok($diceobj->probability(2803),0.000116407407124837);
ok($diceobj->probability(2804),0.000164336064656576);
ok($diceobj->probability(2805),0.000212264722188314);
ok($diceobj->probability(2806),0.000260193379720052);
ok($diceobj->probability(2807),0.000371219355265299);
ok($diceobj->probability(2808),0.000378167978922526);
ok($diceobj->probability(2809),0.000385116602579753);
ok($diceobj->probability(2810),0.000484922353956434);
ok($diceobj->probability(2811),0.000584728105333116);
ok($diceobj->probability(2812),0.000684533856709798);
ok($diceobj->probability(2813),0.000666365008884006);
ok($diceobj->probability(2814),0.000700234837002224);
ok($diceobj->probability(2815),0.000734104665120443);
ok($diceobj->probability(2816),0.00058226023779975);
ok($diceobj->probability(2817),0.000430415810479058);
ok($diceobj->probability(2818),0.000318569628397624);
ok($diceobj->probability(2819),0.000265710745917426);
ok($diceobj->probability(2820),0.000212851863437229);
ok($diceobj->probability(2821),0.000159992980957031);
ok($diceobj->probability(2822),0.000199991226196289);
ok($diceobj->probability(2823),0.000240058771769206);
ok($diceobj->probability(2824),0.000200129826863607);
ok($diceobj->probability(2825),0.000160200881958008);
ok($diceobj->probability(2826),0.000120271937052409);
ok($diceobj->probability(2827),8.03429921468099e-05);
ok($diceobj->probability(2828),4.04140472412109e-05);
ok($diceobj->probability(2829),3.46501668294271e-07);
ok($diceobj->probability(2830),2.77201334635417e-07);
ok($diceobj->probability(2831),2.07901000976562e-07);
ok($diceobj->probability(2832),1.38600667317708e-07);
ok($diceobj->probability(2833),6.93003336588542e-08);
ok($diceobj->probability(2837),2.45382944742839e-05);
ok($diceobj->probability(2838),4.90765889485677e-05);
ok($diceobj->probability(2839),7.36148834228516e-05);
ok($diceobj->probability(2840),9.81531778971354e-05);
ok($diceobj->probability(2841),0.000122691472371419);
ok($diceobj->probability(2842),0.000147229766845703);
ok($diceobj->probability(2843),0.000122691472371419);
ok($diceobj->probability(2844),9.87000147501628e-05);
ok($diceobj->probability(2845),7.47085571289062e-05);
ok($diceobj->probability(2846),5.07170995076497e-05);
ok($diceobj->probability(2847),2.67256418863932e-05);
ok($diceobj->probability(2848),2.73418426513672e-06);
ok($diceobj->probability(2849),3.28102111816406e-06);
ok($diceobj->probability(2850),2.73418426513672e-06);
ok($diceobj->probability(2851),2.18734741210938e-06);
ok($diceobj->probability(2852),4.33670255872938e-05);
ok($diceobj->probability(2853),8.45467037624783e-05);
ok($diceobj->probability(2854),0.000125726381937663);
ok($diceobj->probability(2855),0.000166906060112847);
ok($diceobj->probability(2856),0.000208632575141059);
ok($diceobj->probability(2857),0.000250359090169271);
ok($diceobj->probability(2858),0.000294724485609267);
ok($diceobj->probability(2859),0.000339089881049262);
ok($diceobj->probability(2860),0.000383455276489258);
ok($diceobj->probability(2861),0.000427820671929253);
ok($diceobj->probability(2862),0.000561655710008409);
ok($diceobj->probability(2863),0.000695490748087565);
ok($diceobj->probability(2864),0.000698868480258518);
ok($diceobj->probability(2865),0.000702246212429471);
ok($diceobj->probability(2866),0.000705623944600423);
ok($diceobj->probability(2867),0.000709001676771376);
ok($diceobj->probability(2868),0.000533440123664008);
ok($diceobj->probability(2869),0.000357878570556641);
ok($diceobj->probability(2870),0.00026840892791748);
ok($diceobj->probability(2871),0.00017893928527832);
ok($diceobj->probability(2872),8.94696426391602e-05);
ok($diceobj->probability(2873),1.24607086181641e-06);
ok($diceobj->probability(2874),2.49214172363281e-06);
ok($diceobj->probability(2875),4.18947219848633e-05);
ok($diceobj->probability(2876),8.12973022460937e-05);
ok($diceobj->probability(2877),0.000120765546162923);
ok($diceobj->probability(2878),0.000160233790079753);
ok($diceobj->probability(2879),0.000197209892272949);
ok($diceobj->probability(2880),0.000234185994466146);
ok($diceobj->probability(2881),0.000194849077860514);
ok($diceobj->probability(2882),0.000359482565985786);
ok($diceobj->probability(2883),0.000523984726799859);
ok($diceobj->probability(2884),0.000688486887613932);
ok($diceobj->probability(2885),0.000854235119289822);
ok($diceobj->probability(2886),0.00101998335096571);
ok($diceobj->probability(2887),0.00122388809204102);
ok($diceobj->probability(2888),0.00101985202365451);
ok($diceobj->probability(2889),0.000815881618923611);
ok($diceobj->probability(2890),0.000617708854675293);
ok($diceobj->probability(2891),0.000419536090426975);
ok($diceobj->probability(2892),0.000241846406724718);
ok($diceobj->probability(2893),6.41567230224609e-05);
ok($diceobj->probability(2894),9.04374440511068e-05);
ok($diceobj->probability(2895),0.000116718165079753);
ok($diceobj->probability(2896),0.000131403605143229);
ok($diceobj->probability(2897),0.000146089045206706);
ok($diceobj->probability(2898),0.00011980832417806);
ok($diceobj->probability(2899),9.35276031494141e-05);
ok($diceobj->probability(2900),8.845337761773e-05);
ok($diceobj->probability(2901),8.3379152086046e-05);
ok($diceobj->probability(2902),8.48013051350911e-05);
ok($diceobj->probability(2903),8.62234581841363e-05);
ok($diceobj->probability(2904),0.000108128691779243);
ok($diceobj->probability(2905),0.000130033925374349);
ok($diceobj->probability(2906),0.000155920516120063);
ok($diceobj->probability(2907),0.000181807106865777);
ok($diceobj->probability(2908),0.000206296221415202);
ok($diceobj->probability(2909),0.000255005145602756);
ok($diceobj->probability(2910),0.00030371406979031);
ok($diceobj->probability(2911),0.000352422993977865);
ok($diceobj->probability(2912),0.000329549717373318);
ok($diceobj->probability(2913),0.000306676440768772);
ok($diceobj->probability(2914),0.000372731781005859);
ok($diceobj->probability(2915),0.000390347501966688);
ok($diceobj->probability(2916),0.000407963222927517);
ok($diceobj->probability(2917),0.000425578943888346);
ok($diceobj->probability(2918),0.000506821335686578);
ok($diceobj->probability(2919),0.000588063727484809);
ok($diceobj->probability(2920),0.000492846361796061);
ok($diceobj->probability(2921),0.000421848805745443);
ok($diceobj->probability(2922),0.000350851249694824);
ok($diceobj->probability(2923),0.000279853693644206);
ok($diceobj->probability(2924),0.000174391492207845);
ok($diceobj->probability(2925),6.89292907714844e-05);
ok($diceobj->probability(2926),5.16969680786133e-05);
ok($diceobj->probability(2927),8.51204172770182e-05);
ok($diceobj->probability(2928),0.000178128865559896);
ok($diceobj->probability(2929),0.000271137313842773);
ok($diceobj->probability(2930),0.000381378084818522);
ok($diceobj->probability(2931),0.000491618855794271);
ok($diceobj->probability(2932),0.00060185962677002);
ok($diceobj->probability(2933),0.000610788853963216);
ok($diceobj->probability(2934),0.000500548082987467);
ok($diceobj->probability(2935),0.000390307312011719);
ok($diceobj->probability(2936),0.00028006654103597);
ok($diceobj->probability(2937),0.000169825770060221);
ok($diceobj->probability(2938),5.95849990844727e-05);
ok($diceobj->probability(2942),8.1696523030599e-05);
ok($diceobj->probability(2943),0.000163393046061198);
ok($diceobj->probability(2944),0.000245089569091797);
ok($diceobj->probability(2945),0.000326786092122396);
ok($diceobj->probability(2946),0.000417292785644531);
ok($diceobj->probability(2947),0.000507801577250163);
ok($diceobj->probability(2948),0.000434917322794596);
ok($diceobj->probability(2949),0.00036203306833903);
ok($diceobj->probability(2950),0.000289148813883464);
ok($diceobj->probability(2951),0.000216264559427897);
ok($diceobj->probability(2952),0.000125759963989258);
ok($diceobj->probability(2953),3.52511723836263e-05);
ok($diceobj->probability(2954),2.64389038085937e-05);
ok($diceobj->probability(2955),1.76266352335612e-05);
ok($diceobj->probability(2956),8.81436665852865e-06);
ok($diceobj->probability(2957),2.09808349609375e-09);
ok($diceobj->probability(2960),1.42457750108507e-07);
ok($diceobj->probability(2961),2.84915500217014e-07);
ok($diceobj->probability(2962),4.27373250325521e-07);
ok($diceobj->probability(2963),5.69831000434028e-07);
ok($diceobj->probability(2964),7.12288750542535e-07);
ok($diceobj->probability(2965),8.54746500651042e-07);
ok($diceobj->probability(2966),6.67596605088976e-05);
ok($diceobj->probability(2967),0.000132664574517144);
ok($diceobj->probability(2968),0.000198569488525391);
ok($diceobj->probability(2969),0.000264474402533637);
ok($diceobj->probability(2970),0.000330379316541884);
ok($diceobj->probability(2971),0.00039628423055013);
ok($diceobj->probability(2972),0.00041350094265408);
ok($diceobj->probability(2973),0.00043071765475803);
ok($diceobj->probability(2974),0.000447934366861979);
ok($diceobj->probability(2975),0.000465151078965929);
ok($diceobj->probability(2976),0.000482367791069878);
ok($diceobj->probability(2977),0.000501891059875488);
ok($diceobj->probability(2978),0.000421065033806695);
ok($diceobj->probability(2979),0.000340239007737901);
ok($diceobj->probability(2980),0.000259412981669108);
ok($diceobj->probability(2981),0.000178586955600315);
ok($diceobj->probability(2982),9.77609295315213e-05);
ok($diceobj->probability(2983),1.23217900594076e-05);
ok($diceobj->probability(2984),9.88373226589627e-06);
ok($diceobj->probability(2985),7.44567447238498e-06);
ok($diceobj->probability(2986),5.0076166788737e-06);
ok($diceobj->probability(2987),2.56955888536241e-06);
ok($diceobj->probability(2988),1.31501091851128e-07);
ok($diceobj->probability(2992),2.49299112955729e-05);
ok($diceobj->probability(2993),4.98598225911458e-05);
ok($diceobj->probability(2994),0.000141334648132324);
ok($diceobj->probability(2995),0.000232809473673503);
ok($diceobj->probability(2996),0.000324284299214681);
ok($diceobj->probability(2997),0.000415759124755859);
ok($diceobj->probability(2998),0.000457374127705892);
ok($diceobj->probability(2999),0.000498989130655924);
ok($diceobj->probability(3000),0.000407514305114746);
ok($diceobj->probability(3001),0.000316039479573568);
ok($diceobj->probability(3002),0.000283919592963325);
ok($diceobj->probability(3003),0.000251799706353082);
ok($diceobj->probability(3004),0.000244609731038411);
ok($diceobj->probability(3005),0.000283283543056912);
ok($diceobj->probability(3006),0.000388502269321018);
ok($diceobj->probability(3007),0.000493720995585124);
ok($diceobj->probability(3008),0.000480229843987359);
ok($diceobj->probability(3009),0.000466738692389594);
ok($diceobj->probability(3010),0.000453247540791829);
ok($diceobj->probability(3011),0.000348028814527724);
ok($diceobj->probability(3012),0.000242810088263618);
ok($diceobj->probability(3013),0.000137591361999512);
ok($diceobj->probability(3014),9.17275746663411e-05);
ok($diceobj->probability(3015),4.58637873331706e-05);
ok($diceobj->probability(3018),1.00714365641276e-06);
ok($diceobj->probability(3019),2.01428731282552e-06);
ok($diceobj->probability(3020),3.02143096923828e-06);
ok($diceobj->probability(3021),4.02857462565104e-06);
ok($diceobj->probability(3022),5.0357182820638e-06);
ok($diceobj->probability(3023),6.04286193847656e-06);
ok($diceobj->probability(3024),5.0357182820638e-06);
ok($diceobj->probability(3025),4.02857462565104e-06);
ok($diceobj->probability(3026),0.000154365158081055);
ok($diceobj->probability(3027),0.000312478001912435);
ok($diceobj->probability(3028),0.000470590845743815);
ok($diceobj->probability(3029),0.000628703689575195);
ok($diceobj->probability(3030),0.000787823677062988);
ok($diceobj->probability(3031),0.000946943664550781);
ok($diceobj->probability(3032),0.000803376197814941);
ok($diceobj->probability(3033),0.000644256210327148);
ok($diceobj->probability(3034),0.000485136222839355);
ok($diceobj->probability(3035),0.000326016235351563);
ok($diceobj->probability(3036),0.00016689624786377);
ok($diceobj->probability(3037),7.77626037597656e-06);
ok($diceobj->probability(3038),3.06732177734375e-05);
ok($diceobj->probability(3039),6.1346435546875e-05);
ok($diceobj->probability(3040),9.20845031738281e-05);
ok($diceobj->probability(3041),0.000122822570800781);
ok($diceobj->probability(3042),0.000203321952819824);
ok($diceobj->probability(3043),0.000283821334838867);
ok($diceobj->probability(3044),0.000347957191467285);
ok($diceobj->probability(3045),0.000412093048095703);
ok($diceobj->probability(3046),0.00047609920501709);
ok($diceobj->probability(3047),0.000540604917738173);
ok($diceobj->probability(3048),0.000505588001675076);
ok($diceobj->probability(3049),0.000470571085611979);
ok($diceobj->probability(3050),0.00037626156700982);
ok($diceobj->probability(3051),0.000281952048407661);
ok($diceobj->probability(3052),0.000187707379659017);
ok($diceobj->probability(3053),9.24635993109809e-05);
ok($diceobj->probability(3054),4.69811333550347e-05);
ok($diceobj->probability(3055),1.49866739908854e-06);
ok($diceobj->probability(3056),9.99111599392361e-07);
ok($diceobj->probability(3057),4.99555799696181e-07);
ok($diceobj->probability(3061),2.89891560872396e-06);
ok($diceobj->probability(3062),0.000137549819946289);
ok($diceobj->probability(3063),0.000272200724283854);
ok($diceobj->probability(3064),0.000406851628621419);
ok($diceobj->probability(3065),0.000541502532958984);
ok($diceobj->probability(3066),0.00067615343729655);
ok($diceobj->probability(3067),0.000805006510416667);
ok($diceobj->probability(3068),0.000670355606079102);
ok($diceobj->probability(3069),0.000535704701741536);
ok($diceobj->probability(3070),0.000401053797403971);
ok($diceobj->probability(3071),0.000266544990539551);
ok($diceobj->probability(3072),0.00013203618367513);
ok($diceobj->probability(3073),4.26292419433594e-07);
ok($diceobj->probability(3074),4.2616950141059e-05);
ok($diceobj->probability(3075),8.48076078626845e-05);
ok($diceobj->probability(3076),0.00012699826558431);
ok($diceobj->probability(3077),0.000168904728359646);
ok($diceobj->probability(3078),0.000210811191134983);
ok($diceobj->probability(3079),0.000252717653910319);
ok($diceobj->probability(3080),0.000233550029330783);
ok($diceobj->probability(3081),0.000214382404751248);
ok($diceobj->probability(3082),0.000284549649556478);
ok($diceobj->probability(3083),0.000354858991834852);
ok($diceobj->probability(3084),0.000425168334113227);
ok($diceobj->probability(3085),0.000495477676391602);
ok($diceobj->probability(3086),0.000561789512634277);
ok($diceobj->probability(3087),0.000628101348876953);
ok($diceobj->probability(3088),0.000515743446350098);
ok($diceobj->probability(3089),0.000405029042561849);
ok($diceobj->probability(3090),0.0002943146387736);
ok($diceobj->probability(3091),0.000183600234985352);
ok($diceobj->probability(3092),9.59088643391927e-05);
ok($diceobj->probability(3093),8.21749369303385e-06);
ok($diceobj->probability(3094),9.86099243164062e-06);
ok($diceobj->probability(3095),8.21749369303385e-06);
ok($diceobj->probability(3096),8.60225041707357e-05);
ok($diceobj->probability(3097),0.000163827514648437);
ok($diceobj->probability(3098),0.000241632525126139);
ok($diceobj->probability(3099),0.000319437535603841);
ok($diceobj->probability(3100),0.000397242546081543);
ok($diceobj->probability(3101),0.000476691055297852);
ok($diceobj->probability(3102),0.000397321065266927);
ok($diceobj->probability(3103),0.000317951075236003);
ok($diceobj->probability(3104),0.000238581085205078);
ok($diceobj->probability(3105),0.000159211095174154);
ok($diceobj->probability(3106),7.98411051432292e-05);
ok($diceobj->probability(3107),1.69403669569227e-05);
ok($diceobj->probability(3108),3.33310996161567e-05);
ok($diceobj->probability(3109),4.97218322753906e-05);
ok($diceobj->probability(3110),6.61125649346246e-05);
ok($diceobj->probability(3111),8.25032975938585e-05);
ok($diceobj->probability(3112),9.88940302530924e-05);
ok($diceobj->probability(3113),8.23462592230903e-05);
ok($diceobj->probability(3114),6.58770073784722e-05);
ok($diceobj->probability(3115),4.94077555338542e-05);
ok($diceobj->probability(3116),3.29385036892361e-05);
ok($diceobj->probability(3117),1.64692518446181e-05);
ok($diceobj->probability(3122),0.000174704416063097);
ok($diceobj->probability(3123),0.000349408832126194);
ok($diceobj->probability(3124),0.00052411324818929);
ok($diceobj->probability(3125),0.000698817664252387);
ok($diceobj->probability(3126),0.000873522080315484);
ok($diceobj->probability(3127),0.00104824652353923);
ok($diceobj->probability(3128),0.000873562134636773);
ok($diceobj->probability(3129),0.000698877745734321);
ok($diceobj->probability(3130),0.000532138353983561);
ok($diceobj->probability(3131),0.000365398962232802);
ok($diceobj->probability(3132),0.000198659570482042);
ok($diceobj->probability(3133),3.18801244099935e-05);
ok($diceobj->probability(3134),4.14088567097982e-05);
ok($diceobj->probability(3135),5.09375890096029e-05);
ok($diceobj->probability(3136),4.45763270060221e-05);
ok($diceobj->probability(3137),9.2921511332194e-05);
ok($diceobj->probability(3138),0.000184358787536621);
ok($diceobj->probability(3139),0.000275816090901693);
ok($diceobj->probability(3140),0.000364065869649251);
ok($diceobj->probability(3141),0.00045231564839681);
ok($diceobj->probability(3142),0.000548510424296061);
ok($diceobj->probability(3143),0.000535292307535807);
ok($diceobj->probability(3144),0.000435890007019043);
ok($diceobj->probability(3145),0.000336487706502279);
ok($diceobj->probability(3146),0.000238689168294271);
ok($diceobj->probability(3147),0.000140890630086263);
ok($diceobj->probability(3148),8.82144292195638e-05);
ok($diceobj->probability(3149),9.02446746826172e-05);
ok($diceobj->probability(3150),0.000135367012023926);
ok($diceobj->probability(3151),0.000180489349365234);
ok($diceobj->probability(3152),0.000313823072645399);
ok($diceobj->probability(3153),0.000447156795925564);
ok($diceobj->probability(3154),0.000490245844523112);
ok($diceobj->probability(3155),0.00053333489312066);
ok($diceobj->probability(3156),0.000576423941718207);
ok($diceobj->probability(3157),0.000619512990315755);
ok($diceobj->probability(3158),0.00048617926703559);
ok($diceobj->probability(3159),0.000352845543755425);
ok($diceobj->probability(3160),0.000264634157816569);
ok($diceobj->probability(3161),0.000181624895731608);
ok($diceobj->probability(3162),9.86156336466471e-05);
ok($diceobj->probability(3163),1.56063715616862e-05);
ok($diceobj->probability(3164),2.0823860168457e-05);
ok($diceobj->probability(3165),2.60413487752279e-05);
ok($diceobj->probability(3166),3.12588373819987e-05);
ok($diceobj->probability(3167),2.60720782809787e-05);
ok($diceobj->probability(3168),2.08853191799588e-05);
ok($diceobj->probability(3169),1.56985600789388e-05);
ok($diceobj->probability(3170),0.000138833554585775);
ok($diceobj->probability(3171),0.000261968549092611);
ok($diceobj->probability(3172),0.000385103543599447);
ok($diceobj->probability(3173),0.000513440661960178);
ok($diceobj->probability(3174),0.000641777780320909);
ok($diceobj->probability(3175),0.000770114898681641);
ok($diceobj->probability(3176),0.000642030970255534);
ok($diceobj->probability(3177),0.000513947041829427);
ok($diceobj->probability(3178),0.00038586311340332);
ok($diceobj->probability(3179),0.000257779184977214);
ok($diceobj->probability(3180),0.000129695256551107);
ok($diceobj->probability(3181),2.89369583129883e-05);
ok($diceobj->probability(3182),5.59940338134766e-05);
ok($diceobj->probability(3183),8.30511093139649e-05);
ok($diceobj->probability(3184),0.000110108184814453);
ok($diceobj->probability(3185),0.000137165260314941);
ok($diceobj->probability(3186),0.00016422233581543);
ok($diceobj->probability(3187),0.000136628150939941);
ok($diceobj->probability(3188),0.000109302520751953);
ok($diceobj->probability(3189),8.19768905639648e-05);
ok($diceobj->probability(3190),5.46512603759766e-05);
ok($diceobj->probability(3191),2.73256301879883e-05);
ok($diceobj->probability(3192),1.80961608886719e-06);
ok($diceobj->probability(3193),3.61923217773438e-06);
ok($diceobj->probability(3194),8.42814805772569e-05);
ok($diceobj->probability(3195),0.00016494372897678);
ok($diceobj->probability(3196),0.000245605977376302);
ok($diceobj->probability(3197),0.000326268225775825);
ok($diceobj->probability(3198),0.000403311241997613);
ok($diceobj->probability(3199),0.000480354258219401);
ok($diceobj->probability(3200),0.000399692009819878);
ok($diceobj->probability(3201),0.000319029761420356);
ok($diceobj->probability(3202),0.000285024477640788);
ok($diceobj->probability(3203),0.00025101919386122);
ok($diceobj->probability(3204),0.000218823526170519);
ok($diceobj->probability(3205),0.000186627858479818);
ok($diceobj->probability(3206),0.000233284823099772);
ok($diceobj->probability(3207),0.000279941787719727);
ok($diceobj->probability(3208),0.000233284823099772);
ok($diceobj->probability(3209),0.000186627858479818);
ok($diceobj->probability(3210),0.000139970893859863);
ok($diceobj->probability(3211),9.33139292399088e-05);
ok($diceobj->probability(3212),4.66569646199544e-05);
ok($diceobj->probability(3213),3.57074737548828e-05);
ok($diceobj->probability(3214),7.14149475097656e-05);
ok($diceobj->probability(3215),0.000128246837192112);
ok($diceobj->probability(3216),0.000185078726874457);
ok($diceobj->probability(3217),0.000241910616556803);
ok($diceobj->probability(3218),0.000298742506239149);
ok($diceobj->probability(3219),0.00028415944841173);
ok($diceobj->probability(3220),0.00026957639058431);
ok($diceobj->probability(3221),0.000212744500901964);
ok($diceobj->probability(3222),0.000183902672661675);
ok($diceobj->probability(3223),0.000155060844421387);
ok($diceobj->probability(3224),0.000126219016181098);
ok($diceobj->probability(3225),0.000133084661695692);
ok($diceobj->probability(3226),0.00014006601969401);
ok($diceobj->probability(3227),0.000168171793619792);
ok($diceobj->probability(3228),0.000140297444661458);
ok($diceobj->probability(3229),0.000112423095703125);
ok($diceobj->probability(3230),8.45487467447917e-05);
ok($diceobj->probability(3231),5.66743977864583e-05);
ok($diceobj->probability(3232),6.56030019124349e-05);
ok($diceobj->probability(3233),7.45316060384115e-05);
ok($diceobj->probability(3234),0.000111450271606445);
ok($diceobj->probability(3235),0.000148368937174479);
ok($diceobj->probability(3236),0.000235009320576986);
ok($diceobj->probability(3237),0.000321649703979492);
ok($diceobj->probability(3238),0.000334337043762207);
ok($diceobj->probability(3239),0.000347024383544922);
ok($diceobj->probability(3240),0.000359711723327637);
ok($diceobj->probability(3241),0.000372399063110352);
ok($diceobj->probability(3242),0.000417071317036947);
ok($diceobj->probability(3243),0.000461743570963542);
ok($diceobj->probability(3244),0.000543450202941895);
ok($diceobj->probability(3245),0.000625156834920247);
ok($diceobj->probability(3246),0.0007068634668986);
ok($diceobj->probability(3247),0.000788570098876953);
ok($diceobj->probability(3248),0.000657141749064128);
ok($diceobj->probability(3249),0.000525713399251302);
ok($diceobj->probability(3250),0.000395694198608398);
ok($diceobj->probability(3251),0.000276319550408257);
ok($diceobj->probability(3252),0.000172484147813585);
ok($diceobj->probability(3253),6.86487452189128e-05);
ok($diceobj->probability(3254),9.6241692437066e-05);
ok($diceobj->probability(3255),0.000123834639655219);
ok($diceobj->probability(3256),0.000148609288533529);
ok($diceobj->probability(3257),0.000152151311238607);
ok($diceobj->probability(3258),0.000124614842732747);
ok($diceobj->probability(3259),9.7078374226888e-05);
ok($diceobj->probability(3260),6.95419057210286e-05);
ok($diceobj->probability(3261),4.20054372151693e-05);
ok($diceobj->probability(3262),1.58781178792318e-05);
ok($diceobj->probability(3263),2.82393561469184e-07);
ok($diceobj->probability(3264),2.25914849175347e-07);
ok($diceobj->probability(3265),1.6943613688151e-07);
ok($diceobj->probability(3266),7.37587610880534e-05);
ok($diceobj->probability(3267),0.000147348086039225);
ok($diceobj->probability(3268),0.000220937410990397);
ok($diceobj->probability(3269),0.000298385514153375);
ok($diceobj->probability(3270),0.000375833617316352);
ok($diceobj->probability(3271),0.000453281720479329);
ok($diceobj->probability(3272),0.000383438216315375);
ok($diceobj->probability(3273),0.000313594712151421);
ok($diceobj->probability(3274),0.000243751207987467);
ok($diceobj->probability(3275),0.00016630310482449);
ok($diceobj->probability(3276),8.88550016615126e-05);
ok($diceobj->probability(3277),1.14068984985352e-05);
ok($diceobj->probability(3278),0.000150682406955295);
ok($diceobj->probability(3279),0.000289957915412055);
ok($diceobj->probability(3280),0.000429233423868815);
ok($diceobj->probability(3281),0.000572311231825087);
ok($diceobj->probability(3282),0.000715389039781359);
ok($diceobj->probability(3283),0.00085846684773763);
ok($diceobj->probability(3284),0.000715389039781359);
ok($diceobj->probability(3285),0.000572311231825087);
ok($diceobj->probability(3286),0.000429233423868815);
ok($diceobj->probability(3287),0.000286155615912543);
ok($diceobj->probability(3288),0.000143077807956272);
ok($diceobj->probability(3291),3.29307556152344e-05);
ok($diceobj->probability(3292),6.58615112304688e-05);
ok($diceobj->probability(3293),9.87922668457031e-05);
ok($diceobj->probability(3294),0.000131723022460938);
ok($diceobj->probability(3295),0.000164653778076172);
ok($diceobj->probability(3296),0.000197584533691406);
ok($diceobj->probability(3297),0.000164653778076172);
ok($diceobj->probability(3298),0.000131723022460938);
ok($diceobj->probability(3299),9.87922668457031e-05);
ok($diceobj->probability(3300),6.58615112304688e-05);
ok($diceobj->probability(3301),3.29307556152344e-05);
ok($diceobj->probability(3302),0.000100156784057617);
ok($diceobj->probability(3303),0.000200313568115234);
ok($diceobj->probability(3304),0.000300470352172852);
ok($diceobj->probability(3305),0.000400627136230469);
ok($diceobj->probability(3306),0.000500783920288086);
ok($diceobj->probability(3307),0.000600940704345703);
ok($diceobj->probability(3308),0.000500877041286892);
ok($diceobj->probability(3309),0.000400813378228082);
ok($diceobj->probability(3310),0.000300749715169271);
ok($diceobj->probability(3311),0.00020068605211046);
ok($diceobj->probability(3312),0.000100622389051649);
ok($diceobj->probability(3313),5.58725992838542e-07);
ok($diceobj->probability(3314),4.1484875149197e-05);
ok($diceobj->probability(3315),8.24110243055556e-05);
ok($diceobj->probability(3316),0.000123337173461914);
ok($diceobj->probability(3317),0.000239410959879557);
ok($diceobj->probability(3318),0.000355484746297201);
ok($diceobj->probability(3319),0.000471558532714844);
ok($diceobj->probability(3320),0.000505686899820963);
ok($diceobj->probability(3321),0.000539815266927083);
ok($diceobj->probability(3322),0.000573943634033203);
ok($diceobj->probability(3323),0.000457776726616753);
ok($diceobj->probability(3324),0.000341609819200304);
ok($diceobj->probability(3325),0.000225442911783854);
ok($diceobj->probability(3326),0.000150295274522569);
ok($diceobj->probability(3327),7.69311989678277e-05);
ok($diceobj->probability(3328),3.56712341308594e-06);
ok($diceobj->probability(3329),5.35068511962891e-06);
ok($diceobj->probability(3330),4.8405392964681e-05);
ok($diceobj->probability(3331),9.14601008097331e-05);
ok($diceobj->probability(3332),0.000134514808654785);
ok($diceobj->probability(3333),0.000174002393086751);
ok($diceobj->probability(3334),0.000253171094258626);
ok($diceobj->probability(3335),0.000332339795430501);
ok($diceobj->probability(3336),0.000328966204325358);
ok($diceobj->probability(3337),0.000325602429707845);
ok($diceobj->probability(3338),0.000322238655090332);
ok($diceobj->probability(3339),0.000320658442179362);
ok($diceobj->probability(3340),0.000239715995788574);
ok($diceobj->probability(3341),0.000158773549397786);
ok($diceobj->probability(3342),0.000119102249145508);
ok($diceobj->probability(3343),7.94113159179687e-05);
ok($diceobj->probability(3344),3.97203826904297e-05);
ok($diceobj->probability(3345),2.9449462890625e-08);
ok($diceobj->probability(3346),6.02287165323893e-05);
ok($diceobj->probability(3347),0.000120427983601888);
ok($diceobj->probability(3348),0.000180627250671387);
ok($diceobj->probability(3349),0.000240836334228516);
ok($diceobj->probability(3350),0.000301224072774251);
ok($diceobj->probability(3351),0.000361611811319987);
ok($diceobj->probability(3352),0.000301581382751465);
ok($diceobj->probability(3353),0.000241550954182943);
ok($diceobj->probability(3354),0.000181520525614421);
ok($diceobj->probability(3355),0.000121490097045898);
ok($diceobj->probability(3356),6.11023585001628e-05);
ok($diceobj->probability(3357),7.14619954427083e-07);
ok($diceobj->probability(3358),5.35964965820313e-07);
ok($diceobj->probability(3359),3.57309977213542e-07);
ok($diceobj->probability(3360),1.78654988606771e-07);
ok($diceobj->probability(3362),0.000210222451951769);
ok($diceobj->probability(3363),0.000420444903903537);
ok($diceobj->probability(3364),0.000630667355855306);
ok($diceobj->probability(3365),0.000840889807807075);
ok($diceobj->probability(3366),0.00105111225975884);
ok($diceobj->probability(3367),0.00126133471171061);
ok($diceobj->probability(3368),0.00112040057712131);
ok($diceobj->probability(3369),0.00097946644253201);
ok($diceobj->probability(3370),0.000838532307942708);
ok($diceobj->probability(3371),0.000697598173353407);
ok($diceobj->probability(3372),0.000556664038764106);
ok($diceobj->probability(3373),0.000415729904174805);
ok($diceobj->probability(3374),0.000346441586812337);
ok($diceobj->probability(3375),0.00027715326944987);
ok($diceobj->probability(3376),0.000207864952087402);
ok($diceobj->probability(3377),0.00016175365447998);
ok($diceobj->probability(3378),0.000115642356872559);
ok($diceobj->probability(3379),6.95310592651367e-05);
ok($diceobj->probability(3380),9.27080790201823e-05);
ok($diceobj->probability(3381),0.000115885098775228);
ok($diceobj->probability(3382),0.00018363956451416);
ok($diceobj->probability(3383),0.000207346611022949);
ok($diceobj->probability(3384),0.000231053657531738);
ok($diceobj->probability(3385),0.000254760704040527);
ok($diceobj->probability(3386),0.000278467750549316);
ok($diceobj->probability(3387),0.000302174797058105);
ok($diceobj->probability(3388),0.000236726951599121);
ok($diceobj->probability(3389),0.000189842885335286);
ok($diceobj->probability(3390),0.000186753069559733);
ok($diceobj->probability(3391),0.00018366325378418);
ok($diceobj->probability(3392),0.000180573438008626);
ok($diceobj->probability(3393),0.000177483622233073);
ok($diceobj->probability(3394),0.000218971252441406);
ok($diceobj->probability(3395),0.000264386918809679);
ok($diceobj->probability(3396),0.000222214084201389);
ok($diceobj->probability(3397),0.000180041249593099);
ok($diceobj->probability(3398),0.000137868414984809);
ok($diceobj->probability(3399),9.56955803765191e-05);
ok($diceobj->probability(3400),5.35227457682292e-05);
ok($diceobj->probability(3401),8.1070793999566e-06);
ok($diceobj->probability(3402),4.56620576646593e-05);
ok($diceobj->probability(3403),8.3217035929362e-05);
ok($diceobj->probability(3404),0.00014589109632704);
ok($diceobj->probability(3405),0.000208565156724718);
ok($diceobj->probability(3406),0.000271239217122396);
ok($diceobj->probability(3407),0.000335534693400065);
ok($diceobj->probability(3408),0.000321477381388346);
ok($diceobj->probability(3409),0.000307420069376628);
ok($diceobj->probability(3410),0.000243124593098958);
ok($diceobj->probability(3411),0.000178829116821289);
ok($diceobj->probability(3412),0.000114733912150065);
ok($diceobj->probability(3413),5.06387074788411e-05);
ok($diceobj->probability(3414),2.57198969523112e-05);
ok($diceobj->probability(3415),8.0108642578125e-07);
ok($diceobj->probability(3416),1.00135803222656e-06);
ok($diceobj->probability(3417),1.20162963867188e-06);
ok($diceobj->probability(3418),1.00135803222656e-06);
ok($diceobj->probability(3419),8.0108642578125e-07);
ok($diceobj->probability(3420),6.00814819335938e-07);
ok($diceobj->probability(3421),4.00543212890625e-07);
ok($diceobj->probability(3422),0.000119542388916016);
ok($diceobj->probability(3423),0.000238684234619141);
ok($diceobj->probability(3424),0.000358026351928711);
ok($diceobj->probability(3425),0.000477368469238281);
ok($diceobj->probability(3426),0.000596710586547852);
ok($diceobj->probability(3427),0.000716052703857422);
ok($diceobj->probability(3428),0.000596710586547852);
ok($diceobj->probability(3429),0.000477368469238281);
ok($diceobj->probability(3430),0.000358026351928711);
ok($diceobj->probability(3431),0.000238684234619141);
ok($diceobj->probability(3432),0.00011934211730957);
ok($diceobj->probability(3434),8.77237955729167e-05);
ok($diceobj->probability(3435),0.000175447591145833);
ok($diceobj->probability(3436),0.00026317138671875);
ok($diceobj->probability(3437),0.000350895182291667);
ok($diceobj->probability(3438),0.000438618977864583);
ok($diceobj->probability(3439),0.0005263427734375);
ok($diceobj->probability(3440),0.000438618977864583);
ok($diceobj->probability(3441),0.000350895182291667);
ok($diceobj->probability(3442),0.00026317138671875);
ok($diceobj->probability(3443),0.000175447591145833);
ok($diceobj->probability(3444),8.77237955729167e-05);
ok($diceobj->probability(3452),2.48481750488281e-05);
ok($diceobj->probability(3453),5.00458399454753e-05);
ok($diceobj->probability(3454),7.52435048421224e-05);
ok($diceobj->probability(3455),0.00010044116973877);
ok($diceobj->probability(3456),0.000125638834635417);
ok($diceobj->probability(3457),0.000150836499532064);
ok($diceobj->probability(3458),0.000226319927639431);
ok($diceobj->probability(3459),0.000301104376051161);
ok($diceobj->probability(3460),0.000449184099833171);
ok($diceobj->probability(3461),0.00059726382361518);
ok($diceobj->probability(3462),0.00074534354739719);
ok($diceobj->probability(3463),0.000893423271179199);
ok($diceobj->probability(3464),0.000866386943393283);
ok($diceobj->probability(3465),0.000839700105455187);
ok($diceobj->probability(3466),0.00066642271677653);
ok($diceobj->probability(3467),0.000538745901319716);
ok($diceobj->probability(3468),0.000411069085862901);
ok($diceobj->probability(3469),0.000283392270406087);
ok($diceobj->probability(3470),0.000287721210055881);
ok($diceobj->probability(3471),0.000292050149705675);
ok($diceobj->probability(3472),0.000369674364725749);
ok($diceobj->probability(3473),0.000356097433302138);
ok($diceobj->probability(3474),0.000342676268683539);
ok($diceobj->probability(3475),0.000329255104064941);
ok($diceobj->probability(3476),0.000251786655849881);
ok($diceobj->probability(3477),0.00017431820763482);
ok($diceobj->probability(3478),9.68497594197591e-05);
ok($diceobj->probability(3479),6.49818844265408e-05);
ok($diceobj->probability(3480),3.28024758232964e-05);
ok($diceobj->probability(3481),6.23067220052083e-07);
ok($diceobj->probability(3482),3.63855997721354e-06);
ok($diceobj->probability(3483),6.654052734375e-06);
ok($diceobj->probability(3484),9.66954549153646e-06);
ok($diceobj->probability(3485),1.26850382486979e-05);
ok($diceobj->probability(3486),1.58562978108724e-05);
ok($diceobj->probability(3487),1.90275573730469e-05);
ok($diceobj->probability(3488),1.58562978108724e-05);
ok($diceobj->probability(3489),1.26850382486979e-05);
ok($diceobj->probability(3490),9.51377868652344e-06);
ok($diceobj->probability(3491),6.34251912434896e-06);
ok($diceobj->probability(3492),3.17125956217448e-06);
ok($diceobj->probability(3498),6.65969848632813e-06);
ok($diceobj->probability(3499),1.33193969726563e-05);
ok($diceobj->probability(3500),1.99790954589844e-05);
ok($diceobj->probability(3501),2.66387939453125e-05);
ok($diceobj->probability(3502),5.06925964355469e-05);
ok($diceobj->probability(3503),7.47463989257812e-05);
ok($diceobj->probability(3504),8.54808044433594e-05);
ok($diceobj->probability(3505),9.62152099609375e-05);
ok($diceobj->probability(3506),0.000106949615478516);
ok($diceobj->probability(3507),0.000117684020996094);
ok($diceobj->probability(3508),9.36302185058594e-05);
ok($diceobj->probability(3509),6.9576416015625e-05);
ok($diceobj->probability(3510),5.21823120117188e-05);
ok($diceobj->probability(3511),3.59726715087891e-05);
ok($diceobj->probability(3512),0.000107617357042101);
ok($diceobj->probability(3513),0.000179262042575412);
ok($diceobj->probability(3514),0.00026830083211263);
ok($diceobj->probability(3515),0.000357339621649848);
ok($diceobj->probability(3516),0.000446378411187066);
ok($diceobj->probability(3517),0.000533048273722331);
ok($diceobj->probability(3518),0.000444009484185113);
ok($diceobj->probability(3519),0.000354970694647895);
ok($diceobj->probability(3520),0.000265931905110677);
ok($diceobj->probability(3521),0.000191084382798937);
ok($diceobj->probability(3522),0.000199829694959852);
ok($diceobj->probability(3523),0.000209759470621745);
ok($diceobj->probability(3524),0.000307543572319878);
ok($diceobj->probability(3525),0.000405327674018012);
ok($diceobj->probability(3526),0.000503111775716146);
ok($diceobj->probability(3527),0.000572513342963325);
ok($diceobj->probability(3528),0.000474729241265191);
ok($diceobj->probability(3529),0.000376945139567057);
ok($diceobj->probability(3530),0.000382108548482259);
ok($diceobj->probability(3531),0.000387271957397461);
ok($diceobj->probability(3532),0.000392435366312663);
ok($diceobj->probability(3533),0.000411790042453342);
ok($diceobj->probability(3534),0.000514737553066678);
ok($diceobj->probability(3535),0.000617685063680013);
ok($diceobj->probability(3536),0.000514745924207899);
ok($diceobj->probability(3537),0.000411806784735786);
ok($diceobj->probability(3538),0.000383393287658691);
ok($diceobj->probability(3539),0.000354979790581597);
ok($diceobj->probability(3540),0.000326566293504503);
ok($diceobj->probability(3541),0.000298152796427409);
ok($diceobj->probability(3542),0.000372670067681207);
ok($diceobj->probability(3543),0.000447187338935004);
ok($diceobj->probability(3544),0.000408219273885091);
ok($diceobj->probability(3545),0.000369251208835178);
ok($diceobj->probability(3546),0.000330283143785265);
ok($diceobj->probability(3547),0.000291315078735352);
ok($diceobj->probability(3548),0.00025235538482666);
ok($diceobj->probability(3549),0.000213395690917969);
ok($diceobj->probability(3550),0.000177829742431641);
ok($diceobj->probability(3551),0.000172123336791992);
ok($diceobj->probability(3552),0.000166416931152344);
ok($diceobj->probability(3553),0.000160710525512695);
ok($diceobj->probability(3554),0.000155004119873047);
ok($diceobj->probability(3555),0.000198712921142578);
ok($diceobj->probability(3556),0.000277987670898437);
ok($diceobj->probability(3557),0.000297543334960938);
ok($diceobj->probability(3558),0.000317098999023438);
ok($diceobj->probability(3559),0.000336654663085937);
ok($diceobj->probability(3560),0.000356210327148437);
ok($diceobj->probability(3561),0.000276935577392578);
ok($diceobj->probability(3562),0.000197660827636719);
ok($diceobj->probability(3563),0.000148245620727539);
ok($diceobj->probability(3564),9.88304138183594e-05);
ok($diceobj->probability(3565),4.94152069091797e-05);
ok($diceobj->probability(3566),5.00427881876628e-05);
ok($diceobj->probability(3567),0.000100086339314779);
ok($diceobj->probability(3568),0.000150129890441895);
ok($diceobj->probability(3569),0.00020017344156901);
ok($diceobj->probability(3570),0.000250216992696126);
ok($diceobj->probability(3571),0.000300260543823242);
ok($diceobj->probability(3572),0.000354737985399034);
ok($diceobj->probability(3573),0.00040921390109592);
ok($diceobj->probability(3574),0.000463689816792806);
ok($diceobj->probability(3575),0.000518165732489692);
ok($diceobj->probability(3576),0.000572641648186578);
ok($diceobj->probability(3577),0.000647617556254069);
ok($diceobj->probability(3578),0.00056359731886122);
ok($diceobj->probability(3579),0.000479577844407823);
ok($diceobj->probability(3580),0.000395558369954427);
ok($diceobj->probability(3581),0.000311538895501031);
ok($diceobj->probability(3582),0.000227519421047635);
ok($diceobj->probability(3583),0.000102499961853027);
ok($diceobj->probability(3584),8.19999694824219e-05);
ok($diceobj->probability(3585),6.14999771118164e-05);
ok($diceobj->probability(3586),7.90186564127604e-05);
ok($diceobj->probability(3587),9.65373357137044e-05);
ok($diceobj->probability(3588),0.000114056015014648);
ok($diceobj->probability(3589),0.000152074686686198);
ok($diceobj->probability(3590),0.00022975230746799);
ok($diceobj->probability(3591),0.000307429928249783);
ok($diceobj->probability(3592),0.000309070205688477);
ok($diceobj->probability(3593),0.000329021814134386);
ok($diceobj->probability(3594),0.000348973422580295);
ok($diceobj->probability(3595),0.000368925031026204);
ok($diceobj->probability(3596),0.000309558741251628);
ok($diceobj->probability(3597),0.000250192451477051);
ok($diceobj->probability(3598),0.000228844833374023);
ok($diceobj->probability(3599),0.000170874553256565);
ok($diceobj->probability(3600),0.000112904273139106);
ok($diceobj->probability(3601),5.49339930216471e-05);
ok($diceobj->probability(3602),0.000220827314588759);
ok($diceobj->probability(3603),0.00038672063615587);
ok($diceobj->probability(3604),0.000552613957722982);
ok($diceobj->probability(3605),0.000736818610297309);
ok($diceobj->probability(3606),0.000921023262871636);
ok($diceobj->probability(3607),0.00110522791544596);
ok($diceobj->probability(3608),0.000921023262871636);
ok($diceobj->probability(3609),0.000736818610297309);
ok($diceobj->probability(3610),0.000552613957722982);
ok($diceobj->probability(3611),0.000368409305148654);
ok($diceobj->probability(3612),0.000200669127570258);
ok($diceobj->probability(3613),3.2928949991862e-05);
ok($diceobj->probability(3614),4.9393424987793e-05);
ok($diceobj->probability(3615),6.5857899983724e-05);
ok($diceobj->probability(3616),8.2322374979655e-05);
ok($diceobj->probability(3617),9.87868499755859e-05);
ok($diceobj->probability(3618),8.2322374979655e-05);
ok($diceobj->probability(3619),6.5857899983724e-05);
ok($diceobj->probability(3620),4.9393424987793e-05);
ok($diceobj->probability(3621),3.2928949991862e-05);
ok($diceobj->probability(3622),1.6464474995931e-05);
ok($diceobj->probability(3627),5.97635904947917e-09);
ok($diceobj->probability(3628),1.19527180989583e-08);
ok($diceobj->probability(3629),1.96690029568142e-07);
ok($diceobj->probability(3630),3.81427341037326e-07);
ok($diceobj->probability(3631),5.6616465250651e-07);
ok($diceobj->probability(3632),4.03388765123155e-05);
ok($diceobj->probability(3633),8.00996356540256e-05);
ok($diceobj->probability(3634),0.000119860394795736);
ok($diceobj->probability(3635),0.000159263632032606);
ok($diceobj->probability(3636),0.000198666869269477);
ok($diceobj->probability(3637),0.000238070106506348);
ok($diceobj->probability(3638),0.000198297394646539);
ok($diceobj->probability(3639),0.000158530659145779);
ok($diceobj->probability(3640),0.00011876392364502);
ok($diceobj->probability(3641),7.91759490966797e-05);
ok($diceobj->probability(3642),0.000123772481282552);
ok($diceobj->probability(3643),0.000168369013468424);
ok($diceobj->probability(3644),0.000252553520202637);
ok($diceobj->probability(3645),0.000336738026936849);
ok($diceobj->probability(3646),0.000420922533671061);
ok($diceobj->probability(3647),0.000510102102491591);
ok($diceobj->probability(3648),0.000430912657843696);
ok($diceobj->probability(3649),0.000351723213195801);
ok($diceobj->probability(3650),0.000339016715155707);
ok($diceobj->probability(3651),0.000326310217115614);
ok($diceobj->probability(3652),0.000313603719075521);
ok($diceobj->probability(3653),0.000290907096862793);
ok($diceobj->probability(3654),0.000352394981384277);
ok($diceobj->probability(3655),0.000413882865905762);
ok($diceobj->probability(3656),0.000344408887227376);
ok($diceobj->probability(3657),0.000274934908548991);
ok($diceobj->probability(3658),0.000205460929870605);
ok($diceobj->probability(3659),0.000140982013278537);
ok($diceobj->probability(3660),7.65030966864692e-05);
ok($diceobj->probability(3661),1.2024180094401e-05);
ok($diceobj->probability(3662),1.00201500786675e-05);
ok($diceobj->probability(3663),8.01612006293403e-06);
ok($diceobj->probability(3664),6.01209004720052e-06);
ok($diceobj->probability(3665),4.00806003146701e-06);
ok($diceobj->probability(3666),2.00403001573351e-06);
ok($diceobj->probability(3674),7.46423933241102e-05);
ok($diceobj->probability(3675),0.00014928478664822);
ok($diceobj->probability(3676),0.000223927179972331);
ok($diceobj->probability(3677),0.000299983872307671);
ok($diceobj->probability(3678),0.000376040564643012);
ok($diceobj->probability(3679),0.000452097256978353);
ok($diceobj->probability(3680),0.000378869162665473);
ok($diceobj->probability(3681),0.000305641068352593);
ok($diceobj->probability(3682),0.000261621805826823);
ok($diceobj->probability(3683),0.000214773945278592);
ok($diceobj->probability(3684),0.00016792608473036);
ok($diceobj->probability(3685),0.000121078224182129);
ok($diceobj->probability(3686),0.000148872756958008);
ok($diceobj->probability(3687),0.000176667289733887);
ok($diceobj->probability(3688),0.000146044158935547);
ok($diceobj->probability(3689),0.000116835327148438);
ok($diceobj->probability(3690),8.76264953613281e-05);
ok($diceobj->probability(3691),5.8452631632487e-05);
ok($diceobj->probability(3692),2.92787679036458e-05);
ok($diceobj->probability(3693),1.04904174804688e-07);
ok($diceobj->probability(3694),1.39872233072917e-07);
ok($diceobj->probability(3695),1.74840291341146e-07);
ok($diceobj->probability(3696),2.09808349609375e-07);
ok($diceobj->probability(3697),1.74840291341146e-07);
ok($diceobj->probability(3698),0.000132200177510579);
ok($diceobj->probability(3699),0.000264225514729818);
ok($diceobj->probability(3700),0.000396250851949056);
ok($diceobj->probability(3701),0.000528276189168294);
ok($diceobj->probability(3702),0.000660301526387533);
ok($diceobj->probability(3703),0.000792361831665039);
ok($diceobj->probability(3704),0.000660301526387533);
ok($diceobj->probability(3705),0.000529046885172526);
ok($diceobj->probability(3706),0.00039779224395752);
ok($diceobj->probability(3707),0.000335122027926975);
ok($diceobj->probability(3708),0.00027245181189643);
ok($diceobj->probability(3709),0.000209781595865885);
ok($diceobj->probability(3710),0.000279171685112847);
ok($diceobj->probability(3711),0.000346950446234809);
ok($diceobj->probability(3712),0.000414729207356771);
ok($diceobj->probability(3713),0.000345339118109809);
ok($diceobj->probability(3714),0.000276779043409559);
ok($diceobj->probability(3715),0.00020821896870931);
ok($diceobj->probability(3716),0.00013965889400906);
ok($diceobj->probability(3717),7.19044833713108e-05);
ok($diceobj->probability(3718),4.1500727335612e-06);
ok($diceobj->probability(3719),4.98008728027344e-06);
ok($diceobj->probability(3720),4.47237650553385e-05);
ok($diceobj->probability(3721),8.44674428304036e-05);
ok($diceobj->probability(3722),0.000124553680419922);
ok($diceobj->probability(3723),0.00016463991800944);
ok($diceobj->probability(3724),0.000204726155598958);
ok($diceobj->probability(3725),0.000244812393188477);
ok($diceobj->probability(3726),0.000240757433573405);
ok($diceobj->probability(3727),0.000236702473958333);
ok($diceobj->probability(3728),0.000245317056443956);
ok($diceobj->probability(3729),0.000253931638929579);
ok($diceobj->probability(3730),0.000262546221415202);
ok($diceobj->probability(3731),0.000271160803900825);
ok($diceobj->probability(3732),0.00024799673292372);
ok($diceobj->probability(3733),0.000224832661946615);
ok($diceobj->probability(3734),0.000175301827324761);
ok($diceobj->probability(3735),0.000125770992702908);
ok($diceobj->probability(3736),7.62401580810547e-05);
ok($diceobj->probability(3737),2.67093234592014e-05);
ok($diceobj->probability(3738),1.33546617296007e-05);
ok($diceobj->probability(3742),7.18576431274414e-05);
ok($diceobj->probability(3743),0.000143715286254883);
ok($diceobj->probability(3744),0.000215572929382324);
ok($diceobj->probability(3745),0.000287430572509766);
ok($diceobj->probability(3746),0.000477031262715658);
ok($diceobj->probability(3747),0.000666631952921549);
ok($diceobj->probability(3748),0.000712517356872559);
ok($diceobj->probability(3749),0.000758402760823568);
ok($diceobj->probability(3750),0.000804288164774577);
ok($diceobj->probability(3751),0.000850173568725586);
ok($diceobj->probability(3752),0.000675894037882487);
ok($diceobj->probability(3753),0.000501743253072103);
ok($diceobj->probability(3754),0.00039945011138916);
ok($diceobj->probability(3755),0.000297156969706217);
ok($diceobj->probability(3756),0.000194863828023275);
ok($diceobj->probability(3757),9.2570686340332e-05);
ok($diceobj->probability(3758),7.73782730102539e-05);
ok($diceobj->probability(3759),9.52629725138346e-05);
ok($diceobj->probability(3760),0.000113147672017415);
ok($diceobj->probability(3761),0.000131032371520996);
ok($diceobj->probability(3762),0.000148917071024577);
ok($diceobj->probability(3763),0.000166801770528158);
ok($diceobj->probability(3764),0.000261602846781413);
ok($diceobj->probability(3765),0.000289863459269206);
ok($diceobj->probability(3766),0.000318124071756999);
ok($diceobj->probability(3767),0.000346384684244792);
ok($diceobj->probability(3768),0.000374645296732585);
ok($diceobj->probability(3769),0.000402905909220378);
ok($diceobj->probability(3770),0.000307976086934408);
ok($diceobj->probability(3771),0.000246380869547526);
ok($diceobj->probability(3772),0.00018715035756429);
ok($diceobj->probability(3773),0.000127919845581055);
ok($diceobj->probability(3774),6.8689333597819e-05);
ok($diceobj->probability(3775),9.45882161458333e-06);
ok($diceobj->probability(3776),1.18235270182292e-05);
ok($diceobj->probability(3777),1.4188232421875e-05);
ok($diceobj->probability(3778),1.18235270182292e-05);
ok($diceobj->probability(3779),9.45882161458333e-06);
ok($diceobj->probability(3780),7.0941162109375e-06);
ok($diceobj->probability(3781),4.72941080729167e-06);
ok($diceobj->probability(3782),0.000183479796515571);
ok($diceobj->probability(3783),0.00036223018222385);
ok($diceobj->probability(3784),0.000543345273335775);
ok($diceobj->probability(3785),0.0007244603644477);
ok($diceobj->probability(3786),0.000905575455559625);
ok($diceobj->probability(3787),0.00108669054667155);
ok($diceobj->probability(3788),0.000905575455559625);
ok($diceobj->probability(3789),0.0007244603644477);
ok($diceobj->probability(3790),0.000543345273335775);
ok($diceobj->probability(3791),0.00036223018222385);
ok($diceobj->probability(3792),0.000181115091111925);
ok($diceobj->probability(3797),3.25553894042969e-05);
ok($diceobj->probability(3798),6.51107788085938e-05);
ok($diceobj->probability(3799),9.76661682128906e-05);
ok($diceobj->probability(3800),0.000130221557617188);
ok($diceobj->probability(3801),0.000162776947021484);
ok($diceobj->probability(3802),0.00022977471669515);
ok($diceobj->probability(3803),0.000231661707560221);
ok($diceobj->probability(3804),0.000233548698425293);
ok($diceobj->probability(3805),0.000235435689290365);
ok($diceobj->probability(3806),0.000237322680155436);
ok($diceobj->probability(3807),0.000239209671020508);
ok($diceobj->probability(3808),0.000172211901346842);
ok($diceobj->probability(3809),0.000137769521077474);
ok($diceobj->probability(3810),0.000172777519226074);
ok($diceobj->probability(3811),0.000207785517374674);
ok($diceobj->probability(3812),0.000242793515523275);
ok($diceobj->probability(3813),0.000277801513671875);
ok($diceobj->probability(3814),0.000347251892089844);
ok($diceobj->probability(3815),0.000416702270507813);
ok($diceobj->probability(3816),0.000347251892089844);
ok($diceobj->probability(3817),0.000277801513671875);
ok($diceobj->probability(3818),0.000208351135253906);
ok($diceobj->probability(3819),0.000138900756835937);
ok($diceobj->probability(3820),6.94503784179687e-05);
ok($diceobj->probability(3824),6.10566669040256e-05);
ok($diceobj->probability(3825),0.000122113333808051);
ok($diceobj->probability(3826),0.000183170000712077);
ok($diceobj->probability(3827),0.000286831631130642);
ok($diceobj->probability(3828),0.000390493261549208);
ok($diceobj->probability(3829),0.000494154891967773);
ok($diceobj->probability(3830),0.000478610560099284);
ok($diceobj->probability(3831),0.000463066228230794);
ok($diceobj->probability(3832),0.000447521896362305);
ok($diceobj->probability(3833),0.000346767637464735);
ok($diceobj->probability(3834),0.000246013378567166);
ok($diceobj->probability(3835),0.000145259119669596);
ok($diceobj->probability(3836),9.97467846340603e-05);
ok($diceobj->probability(3837),5.42344495985243e-05);
ok($diceobj->probability(3838),8.72211456298828e-06);
ok($diceobj->probability(3839),5.81474304199219e-06);
ok($diceobj->probability(3840),2.90737152099609e-06);
ok($diceobj->probability(3842),0.000113603070576986);
ok($diceobj->probability(3843),0.000227206141153971);
ok($diceobj->probability(3844),0.000340809211730957);
ok($diceobj->probability(3845),0.000454412282307943);
ok($diceobj->probability(3846),0.000568015352884928);
ok($diceobj->probability(3847),0.000681618423461914);
ok($diceobj->probability(3848),0.000568015352884928);
ok($diceobj->probability(3849),0.000454412282307943);
ok($diceobj->probability(3850),0.000340809211730957);
ok($diceobj->probability(3851),0.000227206141153971);
ok($diceobj->probability(3852),0.000135689023335775);
ok($diceobj->probability(3853),4.41719055175781e-05);
ok($diceobj->probability(3854),6.62578582763672e-05);
ok($diceobj->probability(3855),8.83438110351562e-05);
ok($diceobj->probability(3856),0.000110429763793945);
ok($diceobj->probability(3857),0.000132515716552734);
ok($diceobj->probability(3858),0.000110429763793945);
ok($diceobj->probability(3859),8.86120478312174e-05);
ok($diceobj->probability(3860),6.67943318684896e-05);
ok($diceobj->probability(3861),4.49766159057617e-05);
ok($diceobj->probability(3862),2.31588999430339e-05);
ok($diceobj->probability(3863),1.13561630249023e-05);
ok($diceobj->probability(3864),2.16393788655599e-05);
ok($diceobj->probability(3865),3.13861211140951e-05);
ok($diceobj->probability(3866),8.78912183973524e-05);
ok($diceobj->probability(3867),0.00014439631568061);
ok($diceobj->probability(3868),0.000200901412963867);
ok($diceobj->probability(3869),0.000237376552157932);
ok($diceobj->probability(3870),0.000273851691351997);
ok($diceobj->probability(3871),0.000310595067342122);
ok($diceobj->probability(3872),0.000253821733262804);
ok($diceobj->probability(3873),0.000197048399183485);
ok($diceobj->probability(3874),0.000180111948649089);
ok($diceobj->probability(3875),0.000173190477159288);
ok($diceobj->probability(3876),0.000166269005669488);
ok($diceobj->probability(3877),0.000159347979227702);
ok($diceobj->probability(3878),0.000256644100613064);
ok($diceobj->probability(3879),0.000353940221998427);
ok($diceobj->probability(3880),0.000371562576293945);
ok($diceobj->probability(3881),0.000389184930589464);
ok($diceobj->probability(3882),0.000406807284884983);
ok($diceobj->probability(3883),0.000424428749084473);
ok($diceobj->probability(3884),0.00032713262769911);
ok($diceobj->probability(3885),0.000229836506313748);
ok($diceobj->probability(3886),0.000172377268473307);
ok($diceobj->probability(3887),0.000114918030632867);
ok($diceobj->probability(3888),5.74587927924262e-05);
ok($diceobj->probability(3889),2.1380615234375e-05);
ok($diceobj->probability(3890),9.44791793823242e-05);
ok($diceobj->probability(3891),0.000167577743530273);
ok($diceobj->probability(3892),0.000240676307678223);
ok($diceobj->probability(3893),0.000313774871826172);
ok($diceobj->probability(3894),0.000386873435974121);
ok($diceobj->probability(3895),0.00041721076965332);
ok($diceobj->probability(3896),0.000344112205505371);
ok($diceobj->probability(3897),0.000271013641357422);
ok($diceobj->probability(3898),0.000197915077209473);
ok($diceobj->probability(3899),0.000124816513061523);
ok($diceobj->probability(3900),5.17179489135742e-05);
ok($diceobj->probability(3902),0.000100308757358127);
ok($diceobj->probability(3903),0.000200617514716254);
ok($diceobj->probability(3904),0.000300926272074381);
ok($diceobj->probability(3905),0.000401235029432509);
ok($diceobj->probability(3906),0.000501543786790636);
ok($diceobj->probability(3907),0.000601852544148763);
ok($diceobj->probability(3908),0.000501752747429742);
ok($diceobj->probability(3909),0.00040165295071072);
ok($diceobj->probability(3910),0.000301553153991699);
ok($diceobj->probability(3911),0.000201453357272678);
ok($diceobj->probability(3912),0.000123049371507433);
ok($diceobj->probability(3913),4.46453857421875e-05);
ok($diceobj->probability(3914),6.61322360568576e-05);
ok($diceobj->probability(3915),8.76190863715278e-05);
ok($diceobj->probability(3916),0.000109105936686198);
ok($diceobj->probability(3917),0.000132147356669108);
ok($diceobj->probability(3918),0.000111797154744466);
ok($diceobj->probability(3919),9.14469528198242e-05);
ok($diceobj->probability(3920),7.13057115342882e-05);
ok($diceobj->probability(3921),5.11644702487522e-05);
ok($diceobj->probability(3922),6.92244338989258e-05);
ok($diceobj->probability(3923),8.41752582126194e-05);
ok($diceobj->probability(3924),0.000120821893480089);
ok($diceobj->probability(3925),0.000157468528747559);
ok($diceobj->probability(3926),0.000194115164015028);
ok($diceobj->probability(3927),0.000230761799282498);
ok($diceobj->probability(3928),0.000191006024678548);
ok($diceobj->probability(3929),0.000193635114034017);
ok($diceobj->probability(3930),0.000196264203389486);
ok($diceobj->probability(3931),0.000198893292744954);
ok($diceobj->probability(3932),0.000201522382100423);
ok($diceobj->probability(3933),0.000204151471455892);
ok($diceobj->probability(3934),0.00024498176574707);
ok($diceobj->probability(3935),0.000216438950432671);
ok($diceobj->probability(3936),0.000187896135118273);
ok($diceobj->probability(3937),0.000159353319803874);
ok($diceobj->probability(3938),0.000130810504489475);
ok($diceobj->probability(3939),0.000102267689175076);
ok($diceobj->probability(3940),7.37248738606771e-05);
ok($diceobj->probability(3941),6.14373948838976e-05);
ok($diceobj->probability(3942),4.91499159071181e-05);
ok($diceobj->probability(3943),3.68624369303385e-05);
ok($diceobj->probability(3944),2.4574957953559e-05);
ok($diceobj->probability(3945),1.22874789767795e-05);
ok($diceobj->probability(3946),7.42785135904948e-07);
ok($diceobj->probability(3947),1.4855702718099e-06);
ok($diceobj->probability(3948),2.22835540771484e-06);
ok($diceobj->probability(3949),2.97114054361979e-06);
ok($diceobj->probability(3950),3.71392567952474e-06);
ok($diceobj->probability(3951),4.45671081542969e-06);
ok($diceobj->probability(3952),3.71392567952474e-06);
ok($diceobj->probability(3953),2.97114054361979e-06);
ok($diceobj->probability(3954),6.8911870320638e-05);
ok($diceobj->probability(3955),0.000134852600097656);
ok($diceobj->probability(3956),0.000200793329874674);
ok($diceobj->probability(3957),0.000266734059651693);
ok($diceobj->probability(3958),0.000333417574564616);
ok($diceobj->probability(3959),0.000400101089477539);
ok($diceobj->probability(3960),0.000333417574564616);
ok($diceobj->probability(3961),0.000266734059651693);
ok($diceobj->probability(3962),0.000354928881327311);
ok($diceobj->probability(3963),0.00044312370300293);
ok($diceobj->probability(3964),0.000531318524678548);
ok($diceobj->probability(3965),0.000619513346354167);
ok($diceobj->probability(3966),0.000774391682942708);
ok($diceobj->probability(3967),0.00092927001953125);
ok($diceobj->probability(3968),0.000774391682942708);
ok($diceobj->probability(3969),0.000619513346354167);
ok($diceobj->probability(3970),0.000464719568888346);
ok($diceobj->probability(3971),0.000317734582689073);
ok($diceobj->probability(3972),0.0001707495964898);
ok($diceobj->probability(3973),4.57603454589844e-05);
ok($diceobj->probability(3974),7.56494310167101e-05);
ok($diceobj->probability(3975),0.000105538516574436);
ok($diceobj->probability(3976),0.000135258483886719);
ok($diceobj->probability(3977),0.000149360868665907);
ok($diceobj->probability(3978),0.000163463253445095);
ok($diceobj->probability(3979),0.00013357416788737);
ok($diceobj->probability(3980),0.000172792222764757);
ok($diceobj->probability(3981),0.000212010277642144);
ok($diceobj->probability(3982),0.000251312891642253);
ok($diceobj->probability(3983),0.000298424296908908);
ok($diceobj->probability(3984),0.000345535702175564);
ok($diceobj->probability(3985),0.000414642842610677);
ok($diceobj->probability(3986),0.000345535702175564);
ok($diceobj->probability(3987),0.000276428561740451);
ok($diceobj->probability(3988),0.000207321421305339);
ok($diceobj->probability(3989),0.000138214280870226);
ok($diceobj->probability(3990),6.91071404351129e-05);
ok($diceobj->probability(3992),9.34009975857205e-05);
ok($diceobj->probability(3993),0.000186801995171441);
ok($diceobj->probability(3994),0.000280202992757161);
ok($diceobj->probability(3995),0.000373603990342882);
ok($diceobj->probability(3996),0.000467004987928602);
ok($diceobj->probability(3997),0.000560405985514323);
ok($diceobj->probability(3998),0.000467004987928602);
ok($diceobj->probability(3999),0.000373603990342882);
ok($diceobj->probability(4000),0.000280202992757161);
ok($diceobj->probability(4001),0.000186801995171441);
ok($diceobj->probability(4002),0.000125422138637967);
ok($diceobj->probability(4003),6.40422821044922e-05);
ok($diceobj->probability(4004),9.61125055948893e-05);
ok($diceobj->probability(4005),0.000128182729085286);
ok($diceobj->probability(4006),0.000233869361877441);
ok($diceobj->probability(4007),0.000339555994669596);
ok($diceobj->probability(4008),0.000381200345357259);
ok($diceobj->probability(4009),0.000422844696044922);
ok($diceobj->probability(4010),0.000464390881856283);
ok($diceobj->probability(4011),0.000505937067667643);
ok($diceobj->probability(4012),0.000400250434875488);
ok($diceobj->probability(4013),0.000294563802083333);
ok($diceobj->probability(4014),0.000220898310343424);
ok($diceobj->probability(4015),0.000147232818603516);
ok($diceobj->probability(4016),7.36164093017578e-05);
ok($diceobj->probability(4027),9.84954833984375e-07);
ok($diceobj->probability(4028),1.96990966796875e-06);
ok($diceobj->probability(4029),2.95486450195312e-06);
ok($diceobj->probability(4030),3.9398193359375e-06);
ok($diceobj->probability(4031),4.92477416992187e-06);
ok($diceobj->probability(4032),6.16315205891927e-06);
ok($diceobj->probability(4033),5.43162027994792e-06);
ok($diceobj->probability(4034),0.000163676600986057);
ok($diceobj->probability(4035),0.000321921581692166);
ok($diceobj->probability(4036),0.000480166562398275);
ok($diceobj->probability(4037),0.000638411543104384);
ok($diceobj->probability(4038),0.000796149677700467);
ok($diceobj->probability(4039),0.000954872767130534);
ok($diceobj->probability(4040),0.000795642831590441);
ok($diceobj->probability(4041),0.000636412896050347);
ok($diceobj->probability(4042),0.000477182960510254);
ok($diceobj->probability(4043),0.000317953024970161);
ok($diceobj->probability(4044),0.00015897651248508);
ok($diceobj->probability(4048),3.12362670898437e-05);
ok($diceobj->probability(4049),6.24725341796875e-05);
ok($diceobj->probability(4050),0.000129058074951172);
ok($diceobj->probability(4051),0.000195643615722656);
ok($diceobj->probability(4052),0.000310178684658474);
ok($diceobj->probability(4053),0.000424713753594293);
ok($diceobj->probability(4054),0.000476776288350423);
ok($diceobj->probability(4055),0.000528838823106554);
ok($diceobj->probability(4056),0.000510202810499403);
ok($diceobj->probability(4057),0.000491566797892253);
ok($diceobj->probability(4058),0.00041214894188775);
ok($diceobj->probability(4059),0.000332731085883247);
ok($diceobj->probability(4060),0.000284549496968587);
ok($diceobj->probability(4061),0.000236367908053928);
ok($diceobj->probability(4062),0.000226175414191352);
ok($diceobj->probability(4063),0.000215982920328776);
ok($diceobj->probability(4064),0.000183505528767904);
ok($diceobj->probability(4065),0.000151028137207031);
ok($diceobj->probability(4066),0.000118550745646159);
ok($diceobj->probability(4067),8.60733540852865e-05);
ok($diceobj->probability(4068),4.83163197835286e-05);
ok($diceobj->probability(4069),1.05592854817708e-05);
ok($diceobj->probability(4070),7.91946411132812e-06);
ok($diceobj->probability(4071),5.27964274088542e-06);
ok($diceobj->probability(4072),2.63982137044271e-06);
ok($diceobj->probability(4082),0.00013097223493788);
ok($diceobj->probability(4083),0.00026194446987576);
ok($diceobj->probability(4084),0.000392916704813639);
ok($diceobj->probability(4085),0.000523888939751519);
ok($diceobj->probability(4086),0.000654861174689399);
ok($diceobj->probability(4087),0.000785833409627279);
ok($diceobj->probability(4088),0.000654861174689399);
ok($diceobj->probability(4089),0.000523888939751519);
ok($diceobj->probability(4090),0.000392916704813639);
ok($diceobj->probability(4091),0.00026194446987576);
ok($diceobj->probability(4092),0.00013097223493788);
ok($diceobj->probability(4094),3.09944152832031e-07);
ok($diceobj->probability(4095),6.19888305664063e-07);
ok($diceobj->probability(4096),9.29832458496094e-07);
ok($diceobj->probability(4097),5.81968095567491e-05);
ok($diceobj->probability(4098),0.00012519228193495);
ok($diceobj->probability(4099),0.000192187754313151);
ok($diceobj->probability(4100),0.000258563338385688);
ok($diceobj->probability(4101),0.000324938922458225);
ok($diceobj->probability(4102),0.000391314506530762);
ok($diceobj->probability(4103),0.000343776024712457);
ok($diceobj->probability(4104),0.000276780552334256);
ok($diceobj->probability(4105),0.000209785079956055);
ok($diceobj->probability(4106),0.000208960257636176);
ok($diceobj->probability(4107),0.000208135435316298);
ok($diceobj->probability(4108),0.000207310612996419);
ok($diceobj->probability(4109),0.000263442823621962);
ok($diceobj->probability(4110),0.000329303529527452);
ok($diceobj->probability(4111),0.000395164235432943);
ok($diceobj->probability(4112),0.000329303529527452);
ok($diceobj->probability(4113),0.000263442823621962);
ok($diceobj->probability(4114),0.000197582117716471);
ok($diceobj->probability(4115),0.000131721411810981);
ok($diceobj->probability(4116),0.000100727992587619);
ok($diceobj->probability(4117),6.97345733642578e-05);
ok($diceobj->probability(4118),0.000134649912516276);
ok($diceobj->probability(4119),0.000199565251668294);
ok($diceobj->probability(4120),0.000264480590820312);
ok($diceobj->probability(4121),0.000329395929972331);
ok($diceobj->probability(4122),0.000324576695760091);
ok($diceobj->probability(4123),0.000319757461547852);
ok($diceobj->probability(4124),0.000254842122395833);
ok($diceobj->probability(4125),0.000189950307210286);
ok($diceobj->probability(4126),0.00012505849202474);
ok($diceobj->probability(4127),8.03576787312826e-05);
ok($diceobj->probability(4128),7.05241521199544e-05);
ok($diceobj->probability(4129),6.06906255086263e-05);
ok($diceobj->probability(4130),8.09051513671875e-05);
ok($diceobj->probability(4131),0.000101072629292806);
ok($diceobj->probability(4132),0.000121240107218424);
ok($diceobj->probability(4133),0.000105295732286241);
ok($diceobj->probability(4134),8.93513573540582e-05);
ok($diceobj->probability(4135),7.3406982421875e-05);
ok($diceobj->probability(4136),5.74626074896918e-05);
ok($diceobj->probability(4137),4.154175652398e-05);
ok($diceobj->probability(4138),2.56209055582682e-05);
ok($diceobj->probability(4139),2.13507546318902e-05);
ok($diceobj->probability(4140),1.70806037055122e-05);
ok($diceobj->probability(4141),1.28104527791341e-05);
ok($diceobj->probability(4142),7.85987938774957e-05);
ok($diceobj->probability(4143),0.000144387134975857);
ok($diceobj->probability(4144),0.000210175476074219);
ok($diceobj->probability(4145),0.000280233968098958);
ok($diceobj->probability(4146),0.000350292460123698);
ok($diceobj->probability(4147),0.000420350952148438);
ok($diceobj->probability(4148),0.000350292460123698);
ok($diceobj->probability(4149),0.000283350003560384);
ok($diceobj->probability(4150),0.00021640754699707);
ok($diceobj->probability(4151),0.000149465090433757);
ok($diceobj->probability(4152),8.25226338704427e-05);
ok($diceobj->probability(4153),1.55801773071289e-05);
ok($diceobj->probability(4154),1.86962127685547e-05);
ok($diceobj->probability(4155),1.55801773071289e-05);
ok($diceobj->probability(4156),1.24641418457031e-05);
ok($diceobj->probability(4157),9.34810638427734e-06);
ok($diceobj->probability(4158),6.23207092285156e-06);
ok($diceobj->probability(4159),3.11603546142578e-06);
ok($diceobj->probability(4160),6.13655090332031e-05);
ok($diceobj->probability(4161),0.000122731018066406);
ok($diceobj->probability(4162),0.000256177660624186);
ok($diceobj->probability(4163),0.000389624303181966);
ok($diceobj->probability(4164),0.000523070945739746);
ok($diceobj->probability(4165),0.000656517588297526);
ok($diceobj->probability(4166),0.0006672332127889);
ok($diceobj->probability(4167),0.000677948837280273);
ok($diceobj->probability(4168),0.000544502194722494);
ok($diceobj->probability(4169),0.000411055552164714);
ok($diceobj->probability(4170),0.000277608909606934);
ok($diceobj->probability(4171),0.000144162267049154);
ok($diceobj->probability(4172),7.20811335245768e-05);
ok($diceobj->probability(4178),3.85612911648221e-06);
ok($diceobj->probability(4179),7.71225823296441e-06);
ok($diceobj->probability(4180),1.15683873494466e-05);
ok($diceobj->probability(4181),1.54245164659288e-05);
ok($diceobj->probability(4182),8.28449079725477e-05);
ok($diceobj->probability(4183),0.000150265299479167);
ok($diceobj->probability(4184),0.000209973432752821);
ok($diceobj->probability(4185),0.000269681566026476);
ok($diceobj->probability(4186),0.00032938969930013);
ok($diceobj->probability(4187),0.00038925853729248);
ok($diceobj->probability(4188),0.000365615844726562);
ok($diceobj->probability(4189),0.000341973152160645);
ok($diceobj->probability(4190),0.000322186588711209);
ok($diceobj->probability(4191),0.000302400025261773);
ok($diceobj->probability(4192),0.000282613461812337);
ok($diceobj->probability(4193),0.00026250548892551);
ok($diceobj->probability(4194),0.000218727789984809);
ok($diceobj->probability(4195),0.000174950091044108);
ok($diceobj->probability(4196),0.000131172392103407);
ok($diceobj->probability(4197),8.73946931627062e-05);
ok($diceobj->probability(4198),4.36169942220052e-05);
ok($diceobj->probability(4201),5.8929443359375e-05);
ok($diceobj->probability(4202),0.000238554937574599);
ok($diceobj->probability(4203),0.000418180431789822);
ok($diceobj->probability(4204),0.000597805926005046);
ok($diceobj->probability(4205),0.000777431420220269);
ok($diceobj->probability(4206),0.000957056914435493);
ok($diceobj->probability(4207),0.00101882396697998);
ok($diceobj->probability(4208),0.000839198917812771);
ok($diceobj->probability(4209),0.000659573868645562);
ok($diceobj->probability(4210),0.000479948819478353);
ok($diceobj->probability(4211),0.000300323770311144);
ok($diceobj->probability(4212),0.000120698721143934);
ok($diceobj->probability(4213),2.22524007161458e-09);
ok($diceobj->probability(4214),4.72404691908095e-05);
ok($diceobj->probability(4215),9.44787131415473e-05);
ok($diceobj->probability(4216),0.000141716957092285);
ok($diceobj->probability(4217),0.000188955201043023);
ok($diceobj->probability(4218),0.000236264652676053);
ok($diceobj->probability(4219),0.000283574549357096);
ok($diceobj->probability(4220),0.000236407068040636);
ok($diceobj->probability(4221),0.000189239586724175);
ok($diceobj->probability(4222),0.000142072105407715);
ok($diceobj->probability(4223),9.49046240912543e-05);
ok($diceobj->probability(4224),4.75947274102105e-05);
ok($diceobj->probability(4225),2.84830729166667e-07);
ok($diceobj->probability(4226),7.20080057779948e-05);
ok($diceobj->probability(4227),0.000157017199198405);
ok($diceobj->probability(4228),0.000242026392618815);
ok($diceobj->probability(4229),0.000327035586039225);
ok($diceobj->probability(4230),0.000412115987141927);
ok($diceobj->probability(4231),0.000497196388244629);
ok($diceobj->probability(4232),0.000438688023885091);
ok($diceobj->probability(4233),0.000353607622782389);
ok($diceobj->probability(4234),0.000270407104492187);
ok($diceobj->probability(4235),0.000187206586201986);
ok($diceobj->probability(4236),0.000104006067911784);
ok($diceobj->probability(4237),2.0805549621582e-05);
ok($diceobj->probability(4238),9.3994140625e-06);
ok($diceobj->probability(4239),1.1279296875e-05);
ok($diceobj->probability(4240),9.3994140625e-06);
ok($diceobj->probability(4241),7.51953125e-06);
ok($diceobj->probability(4242),5.6396484375e-06);
ok($diceobj->probability(4243),3.759765625e-06);
ok($diceobj->probability(4244),1.8798828125e-06);
ok($diceobj->probability(4252),1.33923594156901e-05);
ok($diceobj->probability(4253),2.67847188313802e-05);
ok($diceobj->probability(4254),4.01770782470703e-05);
ok($diceobj->probability(4255),5.35694376627604e-05);
ok($diceobj->probability(4256),6.69617970784505e-05);
ok($diceobj->probability(4257),8.03541564941406e-05);
ok($diceobj->probability(4258),0.000127976099650065);
ok($diceobj->probability(4259),0.00017559804280599);
ok($diceobj->probability(4260),0.000223219985961914);
ok($diceobj->probability(4261),0.000270841929117839);
ok($diceobj->probability(4262),0.000318463872273763);
ok($diceobj->probability(4263),0.000366085815429688);
ok($diceobj->probability(4264),0.000305071512858073);
ok($diceobj->probability(4265),0.000244269243876139);
ok($diceobj->probability(4266),0.000183466974894206);
ok($diceobj->probability(4267),0.000122664705912272);
ok($diceobj->probability(4268),6.18624369303385e-05);
ok($diceobj->probability(4269),1.06016794840495e-06);
ok($diceobj->probability(4270),1.27220153808594e-06);
ok($diceobj->probability(4271),1.06016794840495e-06);
ok($diceobj->probability(4272),8.48134358723958e-07);
ok($diceobj->probability(4273),6.36100769042969e-07);
ok($diceobj->probability(4274),4.24067179361979e-07);
ok($diceobj->probability(4275),2.1203358968099e-07);
ok($diceobj->probability(4277),3.7235599093967e-05);
ok($diceobj->probability(4278),7.4471198187934e-05);
ok($diceobj->probability(4279),0.000111706797281901);
ok($diceobj->probability(4280),0.000148946211073134);
ok($diceobj->probability(4281),0.000186185624864366);
ok($diceobj->probability(4282),0.000223425038655599);
ok($diceobj->probability(4283),0.000186193254258898);
ok($diceobj->probability(4284),0.000148961469862196);
ok($diceobj->probability(4285),0.000111729685465495);
ok($diceobj->probability(4286),0.000182275093926324);
ok($diceobj->probability(4287),0.000252820502387153);
ok($diceobj->probability(4288),0.000323365910847982);
ok($diceobj->probability(4289),0.000431146918402778);
ok($diceobj->probability(4290),0.000538927925957574);
ok($diceobj->probability(4291),0.00064670893351237);
ok($diceobj->probability(4292),0.000603673434787326);
ok($diceobj->probability(4293),0.000560637936062283);
ok($diceobj->probability(4294),0.00051760243733724);
ok($diceobj->probability(4295),0.000474566938612196);
ok($diceobj->probability(4296),0.000431531439887153);
ok($diceobj->probability(4297),0.000388495941162109);
ok($diceobj->probability(4298),0.000323746617635091);
ok($diceobj->probability(4299),0.000258997294108073);
ok($diceobj->probability(4300),0.000194247970581055);
ok($diceobj->probability(4301),0.000129498647054036);
ok($diceobj->probability(4302),6.47493235270182e-05);
ok($diceobj->probability(4303),2.89253234863281e-05);
ok($diceobj->probability(4304),5.78506469726563e-05);
ok($diceobj->probability(4305),8.67759704589844e-05);
ok($diceobj->probability(4306),0.000115701293945313);
ok($diceobj->probability(4307),0.000144626617431641);
ok($diceobj->probability(4308),0.000173551940917969);
ok($diceobj->probability(4309),0.000144626617431641);
ok($diceobj->probability(4310),0.000115701293945313);
ok($diceobj->probability(4311),8.67759704589844e-05);
ok($diceobj->probability(4312),5.78506469726563e-05);
ok($diceobj->probability(4313),2.89253234863281e-05);
ok($diceobj->probability(4314),3.1904411315918e-05);
ok($diceobj->probability(4315),6.38088226318359e-05);
ok($diceobj->probability(4316),9.57132339477539e-05);
ok($diceobj->probability(4317),0.000127617645263672);
ok($diceobj->probability(4318),0.00015952205657959);
ok($diceobj->probability(4319),0.000191426467895508);
ok($diceobj->probability(4320),0.00015952205657959);
ok($diceobj->probability(4321),0.000127617645263672);
ok($diceobj->probability(4322),0.000267375700208876);
ok($diceobj->probability(4323),0.00040713375515408);
ok($diceobj->probability(4324),0.000546891810099284);
ok($diceobj->probability(4325),0.000686649865044488);
ok($diceobj->probability(4326),0.00085831233130561);
ok($diceobj->probability(4327),0.00102997479756673);
ok($diceobj->probability(4328),0.00085831233130561);
ok($diceobj->probability(4329),0.000686649865044488);
ok($diceobj->probability(4330),0.000514987398783366);
ok($diceobj->probability(4331),0.000343324932522244);
ok($diceobj->probability(4332),0.000171662466261122);
ok($diceobj->probability(4334),2.5344361199273e-05);
ok($diceobj->probability(4335),5.0688722398546e-05);
ok($diceobj->probability(4336),7.6033083597819e-05);
ok($diceobj->probability(4337),0.00012805307176378);
ok($diceobj->probability(4338),0.000180073059929742);
ok($diceobj->probability(4339),0.000232093048095703);
ok($diceobj->probability(4340),0.000233424313863118);
ok($diceobj->probability(4341),0.000234755579630534);
ok($diceobj->probability(4342),0.000236358006795247);
ok($diceobj->probability(4343),0.000184609180026584);
ok($diceobj->probability(4344),0.000132860353257921);
ok($diceobj->probability(4345),8.11115264892578e-05);
ok($diceobj->probability(4346),5.47070609198676e-05);
ok($diceobj->probability(4347),2.83025953504774e-05);
ok($diceobj->probability(4348),1.35580698649089e-06);
ok($diceobj->probability(4349),1.1557854546441e-05);
ok($diceobj->probability(4350),2.17599021063911e-05);
ok($diceobj->probability(4351),3.19619496663411e-05);
ok($diceobj->probability(4352),4.45016437106662e-05);
ok($diceobj->probability(4353),5.70413377549913e-05);
ok($diceobj->probability(4354),9.54280853271484e-05);
ok($diceobj->probability(4355),0.000112868414984809);
ok($diceobj->probability(4356),0.00013030874464247);
ok($diceobj->probability(4357),0.00014774907430013);
ok($diceobj->probability(4358),0.000198449558681912);
ok($diceobj->probability(4359),0.000249150043063694);
ok($diceobj->probability(4360),0.000248698743184408);
ok($diceobj->probability(4361),0.00025872065226237);
ok($diceobj->probability(4362),0.000268742561340332);
ok($diceobj->probability(4363),0.000278764470418294);
ok($diceobj->probability(4364),0.000215253130594889);
ok($diceobj->probability(4365),0.000151741790771484);
ok($diceobj->probability(4366),0.000113806343078613);
ok($diceobj->probability(4367),7.58708953857422e-05);
ok($diceobj->probability(4368),3.79354476928711e-05);
ok($diceobj->probability(4370),0.000115481334262424);
ok($diceobj->probability(4371),0.000230962668524848);
ok($diceobj->probability(4372),0.000365486106872559);
ok($diceobj->probability(4373),0.000500009545220269);
ok($diceobj->probability(4374),0.00063453298356798);
ok($diceobj->probability(4375),0.00076905642191569);
ok($diceobj->probability(4376),0.000676595560709635);
ok($diceobj->probability(4377),0.000584435106913249);
ok($diceobj->probability(4378),0.000454190444946289);
ok($diceobj->probability(4379),0.000323945782979329);
ok($diceobj->probability(4380),0.00019370112101237);
ok($diceobj->probability(4381),6.34564590454102e-05);
ok($diceobj->probability(4382),4.07363933987088e-05);
ok($diceobj->probability(4383),1.74155129326714e-05);
ok($diceobj->probability(4384),1.31367365519206e-05);
ok($diceobj->probability(4385),8.8579601711697e-06);
ok($diceobj->probability(4386),4.57918379041884e-06);
ok($diceobj->probability(4387),3.00407409667969e-07);
ok($diceobj->probability(4391),3.61286799112956e-05);
ok($diceobj->probability(4392),7.22573598225912e-05);
ok($diceobj->probability(4393),0.000108386039733887);
ok($diceobj->probability(4394),0.000144514719645182);
ok($diceobj->probability(4395),0.000180643399556478);
ok($diceobj->probability(4396),0.000226439476013184);
ok($diceobj->probability(4397),0.000199978192647298);
ok($diceobj->probability(4398),0.000173516909281413);
ok($diceobj->probability(4399),0.000147055625915527);
ok($diceobj->probability(4400),0.000120594342549642);
ok($diceobj->probability(4401),9.41330591837565e-05);
ok($diceobj->probability(4402),0.00010999942779541);
ok($diceobj->probability(4403),0.000161994476318359);
ok($diceobj->probability(4404),0.000213989524841309);
ok($diceobj->probability(4405),0.000265984573364258);
ok($diceobj->probability(4406),0.000317979621887207);
ok($diceobj->probability(4407),0.000369974670410156);
ok($diceobj->probability(4408),0.000308312225341797);
ok($diceobj->probability(4409),0.000246649780273437);
ok($diceobj->probability(4410),0.000185602836608887);
ok($diceobj->probability(4411),0.000124555892944336);
ok($diceobj->probability(4412),0.000129489924112956);
ok($diceobj->probability(4413),0.000134423955281576);
ok($diceobj->probability(4414),0.000201020431518555);
ok($diceobj->probability(4415),0.000267616907755534);
ok($diceobj->probability(4416),0.000332982381184896);
ok($diceobj->probability(4417),0.000398347854614258);
ok($diceobj->probability(4418),0.000370777935451931);
ok($diceobj->probability(4419),0.000343208016289605);
ok($diceobj->probability(4420),0.000315638097127279);
ok($diceobj->probability(4421),0.000288068177964952);
ok($diceobj->probability(4422),0.000325165121290419);
ok($diceobj->probability(4423),0.000362262064615885);
ok($diceobj->probability(4424),0.000387286868625217);
ok($diceobj->probability(4425),0.000412311672634549);
ok($diceobj->probability(4426),0.00043733647664388);
ok($diceobj->probability(4427),0.000462361280653212);
ok($diceobj->probability(4428),0.000359283362494575);
ok($diceobj->probability(4429),0.000256205444335937);
ok($diceobj->probability(4430),0.000192154083251953);
ok($diceobj->probability(4431),0.000128102722167969);
ok($diceobj->probability(4432),6.40513610839844e-05);
ok($diceobj->probability(4435),3.2806396484375e-07);
ok($diceobj->probability(4436),6.561279296875e-07);
ok($diceobj->probability(4437),9.8419189453125e-07);
ok($diceobj->probability(4438),1.312255859375e-06);
ok($diceobj->probability(4439),2.96355353461372e-06);
ok($diceobj->probability(4440),4.61485120985243e-06);
ok($diceobj->probability(4441),5.61002095540365e-06);
ok($diceobj->probability(4442),6.60519070095486e-06);
ok($diceobj->probability(4443),7.60036044650608e-06);
ok($diceobj->probability(4444),8.59553019205729e-06);
ok($diceobj->probability(4445),6.94423251681858e-06);
ok($diceobj->probability(4446),5.29293484157986e-06);
ok($diceobj->probability(4447),3.9697011311849e-06);
ok($diceobj->probability(4448),6.28981696234809e-05);
ok($diceobj->probability(4449),0.000121826638115777);
ok($diceobj->probability(4450),0.000180755106608073);
ok($diceobj->probability(4451),0.000241006808810764);
ok($diceobj->probability(4452),0.000301258511013455);
ok($diceobj->probability(4453),0.000361510213216146);
ok($diceobj->probability(4454),0.000301258511013455);
ok($diceobj->probability(4455),0.000241006808810764);
ok($diceobj->probability(4456),0.000180755106608073);
ok($diceobj->probability(4457),0.000130353588528103);
ok($diceobj->probability(4458),7.99520704481337e-05);
ok($diceobj->probability(4459),2.95505523681641e-05);
ok($diceobj->probability(4460),3.94007364908854e-05);
ok($diceobj->probability(4461),4.92509206136068e-05);
ok($diceobj->probability(4462),5.91011047363281e-05);
ok($diceobj->probability(4463),4.92509206136068e-05);
ok($diceobj->probability(4464),3.94007364908854e-05);
ok($diceobj->probability(4465),2.95505523681641e-05);
ok($diceobj->probability(4466),2.00867123074002e-05);
ok($diceobj->probability(4467),1.06228722466363e-05);
ok($diceobj->probability(4468),4.50871785481771e-06);
ok($diceobj->probability(4469),8.24474758572049e-06);
ok($diceobj->probability(4470),1.19807773166233e-05);
ok($diceobj->probability(4471),1.5716807047526e-05);
ok($diceobj->probability(4472),1.86801486545139e-05);
ok($diceobj->probability(4473),2.16434902615017e-05);
ok($diceobj->probability(4474),1.7907460530599e-05);
ok($diceobj->probability(4475),1.41714307996962e-05);
ok($diceobj->probability(4476),1.04354010687934e-05);
ok($diceobj->probability(4477),6.69937133789062e-06);
ok($diceobj->probability(4478),3.34968566894531e-06);
ok($diceobj->probability(4482),6.04827117919922e-05);
ok($diceobj->probability(4483),0.000120965423583984);
ok($diceobj->probability(4484),0.000181448135375977);
ok($diceobj->probability(4485),0.000241930847167969);
ok($diceobj->probability(4486),0.000302413558959961);
ok($diceobj->probability(4487),0.000403501366509332);
ok($diceobj->probability(4488),0.000383623750474718);
ok($diceobj->probability(4489),0.000363746134440104);
ok($diceobj->probability(4490),0.000407546179029677);
ok($diceobj->probability(4491),0.000451346223619249);
ok($diceobj->probability(4492),0.000495146268208822);
ok($diceobj->probability(4493),0.000457736121283637);
ok($diceobj->probability(4494),0.000480808686150445);
ok($diceobj->probability(4495),0.000503881251017253);
ok($diceobj->probability(4496),0.000399598494635688);
ok($diceobj->probability(4497),0.000295315801832411);
ok($diceobj->probability(4498),0.000191033109029134);
ok($diceobj->probability(4499),0.000127355511983236);
ok($diceobj->probability(4500),6.36779149373372e-05);
ok($diceobj->probability(4501),3.17891438802083e-10);
ok($diceobj->probability(4502),7.15591261121962e-05);
ok($diceobj->probability(4503),0.000143117807176378);
ok($diceobj->probability(4504),0.00021467648824056);
ok($diceobj->probability(4505),0.000286235169304742);
ok($diceobj->probability(4506),0.000357793850368924);
ok($diceobj->probability(4507),0.000429352531433105);
ok($diceobj->probability(4508),0.000357793723212348);
ok($diceobj->probability(4509),0.000286234978569878);
ok($diceobj->probability(4510),0.000236112543741862);
ok($diceobj->probability(4511),0.000185990108913845);
ok($diceobj->probability(4512),0.000135867674085829);
ok($diceobj->probability(4513),8.57452392578125e-05);
ok($diceobj->probability(4514),0.000107181549072266);
ok($diceobj->probability(4515),0.000128617858886719);
ok($diceobj->probability(4516),0.000107181549072266);
ok($diceobj->probability(4517),8.57452392578125e-05);
ok($diceobj->probability(4518),6.43089294433594e-05);
ok($diceobj->probability(4519),4.28726196289062e-05);
ok($diceobj->probability(4520),2.14363098144531e-05);
ok($diceobj->probability(4524),5.38035074869792e-05);
ok($diceobj->probability(4525),0.000107607014973958);
ok($diceobj->probability(4526),0.000165156533983019);
ok($diceobj->probability(4527),0.000222706052992079);
ok($diceobj->probability(4528),0.000280255572001139);
ok($diceobj->probability(4529),0.0003378050910102);
ok($diceobj->probability(4530),0.000287747595045302);
ok($diceobj->probability(4531),0.000237690099080404);
ok($diceobj->probability(4532),0.000180140580071343);
ok($diceobj->probability(4533),0.000122591061062283);
ok($diceobj->probability(4534),6.50415420532226e-05);
ok($diceobj->probability(4535),7.49202304416233e-06);
ok($diceobj->probability(4536),3.74601152208116e-06);
ok($diceobj->probability(4538),9.53860176934136e-05);
ok($diceobj->probability(4539),0.000190772035386827);
ok($diceobj->probability(4540),0.000286158053080241);
ok($diceobj->probability(4541),0.000381544070773655);
ok($diceobj->probability(4542),0.000476930088467068);
ok($diceobj->probability(4543),0.000572316106160482);
ok($diceobj->probability(4544),0.000476930088467068);
ok($diceobj->probability(4545),0.000381544070773655);
ok($diceobj->probability(4546),0.000286158053080241);
ok($diceobj->probability(4547),0.000190772035386827);
ok($diceobj->probability(4548),9.53860176934136e-05);
ok($diceobj->probability(4552),2.70624796549479e-05);
ok($diceobj->probability(4553),5.41249593098958e-05);
ok($diceobj->probability(4554),8.11874389648438e-05);
ok($diceobj->probability(4555),0.000108249918619792);
ok($diceobj->probability(4556),0.000170953114827474);
ok($diceobj->probability(4557),0.000233656311035156);
ok($diceobj->probability(4558),0.000242234547932943);
ok($diceobj->probability(4559),0.000250830268859863);
ok($diceobj->probability(4560),0.000259425989786784);
ok($diceobj->probability(4561),0.000268021710713704);
ok($diceobj->probability(4562),0.000318708975050184);
ok($diceobj->probability(4563),0.000369396239386664);
ok($diceobj->probability(4564),0.000447145983378092);
ok($diceobj->probability(4565),0.000531347079806858);
ok($diceobj->probability(4566),0.000615548176235623);
ok($diceobj->probability(4567),0.000699749272664388);
ok($diceobj->probability(4568),0.000592845132615831);
ok($diceobj->probability(4569),0.000485940992567274);
ok($diceobj->probability(4570),0.000379036852518717);
ok($diceobj->probability(4571),0.000259177555508084);
ok($diceobj->probability(4572),0.00013931825849745);
ok($diceobj->probability(4573),1.94589614868164e-05);
ok($diceobj->probability(4574),1.29726409912109e-05);
ok($diceobj->probability(4575),6.48632049560547e-06);
ok($diceobj->probability(4578),6.09813690185547e-05);
ok($diceobj->probability(4579),0.000121962738037109);
ok($diceobj->probability(4580),0.000182944107055664);
ok($diceobj->probability(4581),0.000243925476074219);
ok($diceobj->probability(4582),0.000304906845092773);
ok($diceobj->probability(4583),0.000365888214111328);
ok($diceobj->probability(4584),0.000304906845092773);
ok($diceobj->probability(4585),0.000243925476074219);
ok($diceobj->probability(4586),0.000182944107055664);
ok($diceobj->probability(4587),0.000121962738037109);
ok($diceobj->probability(4588),6.09813690185547e-05);
ok($diceobj->probability(4592),5.50514517890082e-05);
ok($diceobj->probability(4593),0.000110102903578016);
ok($diceobj->probability(4594),0.000165154355367025);
ok($diceobj->probability(4595),0.000220205807156033);
ok($diceobj->probability(4596),0.000275257258945041);
ok($diceobj->probability(4597),0.000330308710734049);
ok($diceobj->probability(4598),0.000275257258945041);
ok($diceobj->probability(4599),0.000220205807156033);
ok($diceobj->probability(4600),0.000195905202229818);
ok($diceobj->probability(4601),0.000171604597303602);
ok($diceobj->probability(4602),0.000167087724473741);
ok($diceobj->probability(4603),0.00016257085164388);
ok($diceobj->probability(4604),0.000213105430603027);
ok($diceobj->probability(4605),0.000263640009562175);
ok($diceobj->probability(4606),0.000252672894795736);
ok($diceobj->probability(4607),0.000241705780029297);
ok($diceobj->probability(4608),0.00019117120107015);
ok($diceobj->probability(4609),0.000140636622111003);
ok($diceobj->probability(4610),0.000143122181362576);
ok($diceobj->probability(4611),0.000145607740614149);
ok($diceobj->probability(4612),0.000178844146728516);
ok($diceobj->probability(4613),0.000212080552842882);
ok($diceobj->probability(4614),0.000265100691053602);
ok($diceobj->probability(4615),0.000318120829264323);
ok($diceobj->probability(4616),0.000265100691053602);
ok($diceobj->probability(4617),0.000212080552842882);
ok($diceobj->probability(4618),0.000159060414632161);
ok($diceobj->probability(4619),0.000109712664286296);
ok($diceobj->probability(4620),6.03649139404297e-05);
ok($diceobj->probability(4621),1.10171635945638e-05);
ok($diceobj->probability(4622),0.000120980076260037);
ok($diceobj->probability(4623),0.00023094298892551);
ok($diceobj->probability(4624),0.000340905901590983);
ok($diceobj->probability(4625),0.000443524038526747);
ok($diceobj->probability(4626),0.000567711109585232);
ok($diceobj->probability(4627),0.000691898180643717);
ok($diceobj->probability(4628),0.000603504202100966);
ok($diceobj->probability(4629),0.000515110223558214);
ok($diceobj->probability(4630),0.000426716245015462);
ok($diceobj->probability(4631),0.000341994654337565);
ok($diceobj->probability(4632),0.000214135195414225);
ok($diceobj->probability(4633),8.62757364908854e-05);
ok($diceobj->probability(4634),6.47068023681641e-05);
ok($diceobj->probability(4635),4.31378682454427e-05);
ok($diceobj->probability(4636),2.15689341227214e-05);
ok($diceobj->probability(4642),2.72567749023438e-06);
ok($diceobj->probability(4643),5.39249250623915e-05);
ok($diceobj->probability(4644),0.000105124172634549);
ok($diceobj->probability(4645),0.000156323420206706);
ok($diceobj->probability(4646),0.000207522667778863);
ok($diceobj->probability(4647),0.00025872191535102);
ok($diceobj->probability(4648),0.000304469807942708);
ok($diceobj->probability(4649),0.000253270560370551);
ok($diceobj->probability(4650),0.000202071312798394);
ok($diceobj->probability(4651),0.000150872065226237);
ok($diceobj->probability(4652),9.99083752102322e-05);
ok($diceobj->probability(4653),4.89446851942274e-05);
ok($diceobj->probability(4654),7.06672668457031e-07);
ok($diceobj->probability(4655),9.42230224609375e-07);
ok($diceobj->probability(4656),1.17778778076172e-06);
ok($diceobj->probability(4657),1.41334533691406e-06);
ok($diceobj->probability(4658),1.17778778076172e-06);
ok($diceobj->probability(4659),9.42230224609375e-07);
ok($diceobj->probability(4660),7.06672668457031e-07);
ok($diceobj->probability(4661),4.71115112304687e-07);
ok($diceobj->probability(4662),2.35557556152344e-07);
ok($diceobj->probability(4671),1.47247314453125e-07);
ok($diceobj->probability(4672),2.9449462890625e-07);
ok($diceobj->probability(4673),4.41741943359375e-07);
ok($diceobj->probability(4674),5.889892578125e-07);
ok($diceobj->probability(4675),7.36236572265625e-07);
ok($diceobj->probability(4676),8.8348388671875e-07);
ok($diceobj->probability(4677),1.85846328735352e-05);
ok($diceobj->probability(4678),3.62857818603516e-05);
ok($diceobj->probability(4679),5.3986930847168e-05);
ok($diceobj->probability(4680),7.16880798339844e-05);
ok($diceobj->probability(4681),8.93892288208008e-05);
ok($diceobj->probability(4682),0.000223038974338108);
ok($diceobj->probability(4683),0.000321139174567329);
ok($diceobj->probability(4684),0.000419239374796549);
ok($diceobj->probability(4685),0.00051733957502577);
ok($diceobj->probability(4686),0.000615439775254991);
ok($diceobj->probability(4687),0.000713539975484212);
ok($diceobj->probability(4688),0.000579742982652452);
ok($diceobj->probability(4689),0.000463794386121962);
ok($diceobj->probability(4690),0.000347845789591471);
ok($diceobj->probability(4691),0.000231897193060981);
ok($diceobj->probability(4692),0.00011594859653049);
ok($diceobj->probability(4694),3.35745069715712e-05);
ok($diceobj->probability(4695),9.26767137315538e-05);
ok($diceobj->probability(4696),0.000151778920491536);
ok($diceobj->probability(4697),0.000210881127251519);
ok($diceobj->probability(4698),0.000269983334011502);
ok($diceobj->probability(4699),0.000329085540771484);
ok($diceobj->probability(4700),0.000322276878356934);
ok($diceobj->probability(4701),0.00026441281636556);
ok($diceobj->probability(4702),0.000206548754374186);
ok($diceobj->probability(4703),0.000148684692382812);
ok($diceobj->probability(4704),9.08206303914388e-05);
ok($diceobj->probability(4705),3.29565684000651e-05);
ok($diceobj->probability(4706),8.09433195326063e-05);
ok($diceobj->probability(4707),0.000154457770453559);
ok($diceobj->probability(4708),0.000227972221374512);
ok($diceobj->probability(4709),0.000301486672295464);
ok($diceobj->probability(4710),0.000375001123216417);
ok($diceobj->probability(4711),0.00044851557413737);
ok($diceobj->probability(4712),0.000373762978447808);
ok($diceobj->probability(4713),0.000299010382758247);
ok($diceobj->probability(4714),0.000224311192830404);
ok($diceobj->probability(4715),0.000149612002902561);
ok($diceobj->probability(4716),7.49128129747179e-05);
ok($diceobj->probability(4717),2.13623046875e-07);
ok($diceobj->probability(4718),2.6702880859375e-07);
ok($diceobj->probability(4719),3.204345703125e-07);
ok($diceobj->probability(4720),2.6702880859375e-07);
ok($diceobj->probability(4721),2.13623046875e-07);
ok($diceobj->probability(4722),1.6021728515625e-07);
ok($diceobj->probability(4723),1.068115234375e-07);
ok($diceobj->probability(4724),5.340576171875e-08);
ok($diceobj->probability(4727),3.0855475531684e-05);
ok($diceobj->probability(4728),6.17109510633681e-05);
ok($diceobj->probability(4729),9.25664265950521e-05);
ok($diceobj->probability(4730),0.000123421902126736);
ok($diceobj->probability(4731),0.00015427737765842);
ok($diceobj->probability(4732),0.000185132853190104);
ok($diceobj->probability(4733),0.00015427737765842);
ok($diceobj->probability(4734),0.000146856096055773);
ok($diceobj->probability(4735),0.000139434814453125);
ok($diceobj->probability(4736),0.000132013532850477);
ok($diceobj->probability(4737),0.00012459225124783);
ok($diceobj->probability(4738),0.000117170969645182);
ok($diceobj->probability(4739),0.000140605163574219);
ok($diceobj->probability(4740),0.000117170969645182);
ok($diceobj->probability(4741),9.37367757161458e-05);
ok($diceobj->probability(4742),7.03025817871094e-05);
ok($diceobj->probability(4743),4.68683878580729e-05);
ok($diceobj->probability(4744),2.34341939290365e-05);
ok($diceobj->probability(4745),1.24083624945747e-07);
ok($diceobj->probability(4746),2.48167249891493e-07);
ok($diceobj->probability(4747),3.7225087483724e-07);
ok($diceobj->probability(4748),4.96334499782986e-07);
ok($diceobj->probability(4749),6.20418124728733e-07);
ok($diceobj->probability(4750),7.44501749674479e-07);
ok($diceobj->probability(4751),6.20418124728733e-07);
ok($diceobj->probability(4752),1.22001563178168e-05);
ok($diceobj->probability(4753),2.37798945109049e-05);
ok($diceobj->probability(4754),0.000112382058037652);
ok($diceobj->probability(4755),0.000200984221564399);
ok($diceobj->probability(4756),0.000289586385091146);
ok($diceobj->probability(4757),0.000378312632242839);
ok($diceobj->probability(4758),0.000443631235758464);
ok($diceobj->probability(4759),0.000508949839274089);
ok($diceobj->probability(4760),0.000420223592122396);
ok($diceobj->probability(4761),0.000331497344970703);
ok($diceobj->probability(4762),0.000296100120544434);
ok($diceobj->probability(4763),0.000264194107055664);
ok($diceobj->probability(4764),0.000243991915384928);
ok($diceobj->probability(4765),0.000223789723714193);
ok($diceobj->probability(4766),0.000280609957377116);
ok($diceobj->probability(4767),0.000337430191040039);
ok($diceobj->probability(4768),0.000287592379252116);
ok($diceobj->probability(4769),0.000230772145589193);
ok($diceobj->probability(4770),0.00017395191192627);
ok($diceobj->probability(4771),0.000117131678263346);
ok($diceobj->probability(4772),6.03114446004232e-05);
ok($diceobj->probability(4773),3.4912109375e-06);
ok($diceobj->probability(4776),3.40461730957031e-07);
ok($diceobj->probability(4777),6.80923461914062e-07);
ok($diceobj->probability(4778),1.02138519287109e-06);
ok($diceobj->probability(4779),1.36184692382812e-06);
ok($diceobj->probability(4780),1.70230865478516e-06);
ok($diceobj->probability(4781),2.04277038574219e-06);
ok($diceobj->probability(4782),1.70230865478516e-06);
ok($diceobj->probability(4783),1.36184692382812e-06);
ok($diceobj->probability(4784),1.02138519287109e-06);
ok($diceobj->probability(4785),6.80923461914062e-07);
ok($diceobj->probability(4786),3.94311904907227e-05);
ok($diceobj->probability(4787),8.12402725219727e-05);
ok($diceobj->probability(4788),0.00012338981628418);
ok($diceobj->probability(4789),0.000165539360046387);
ok($diceobj->probability(4790),0.000300405671861437);
ok($diceobj->probability(4791),0.000435271983676487);
ok($diceobj->probability(4792),0.000491956837972005);
ok($diceobj->probability(4793),0.000542524062262641);
ok($diceobj->probability(4794),0.000593091286553277);
ok($diceobj->probability(4795),0.000643658510843913);
ok($diceobj->probability(4796),0.000508792199028863);
ok($diceobj->probability(4797),0.000373925887213813);
ok($diceobj->probability(4798),0.000278150304158529);
ok($diceobj->probability(4799),0.000185433536105686);
ok($diceobj->probability(4800),9.27167680528429e-05);
ok($diceobj->probability(4802),0.00010765983581543);
ok($diceobj->probability(4803),0.000215319671630859);
ok($diceobj->probability(4804),0.000322979507446289);
ok($diceobj->probability(4805),0.000430639343261719);
ok($diceobj->probability(4806),0.000538299179077148);
ok($diceobj->probability(4807),0.000645959014892578);
ok($diceobj->probability(4808),0.000538299179077148);
ok($diceobj->probability(4809),0.000456081085205078);
ok($diceobj->probability(4810),0.000373862991333008);
ok($diceobj->probability(4811),0.000291644897460938);
ok($diceobj->probability(4812),0.000209426803588867);
ok($diceobj->probability(4813),0.000127208709716797);
ok($diceobj->probability(4814),0.000152650451660156);
ok($diceobj->probability(4815),0.000127208709716797);
ok($diceobj->probability(4816),0.000101766967773438);
ok($diceobj->probability(4817),7.63252258300781e-05);
ok($diceobj->probability(4818),5.08834838867188e-05);
ok($diceobj->probability(4819),2.54417419433594e-05);
ok($diceobj->probability(4832),5.46418084038628e-05);
ok($diceobj->probability(4833),0.000109283616807726);
ok($diceobj->probability(4834),0.000163925425211589);
ok($diceobj->probability(4835),0.000218567233615451);
ok($diceobj->probability(4836),0.000273209042019314);
ok($diceobj->probability(4837),0.000327850850423177);
ok($diceobj->probability(4838),0.000273598247104221);
ok($diceobj->probability(4839),0.000219345643785265);
ok($diceobj->probability(4840),0.000165093040466309);
ok($diceobj->probability(4841),0.000110840437147352);
ok($diceobj->probability(4842),9.28329891628689e-05);
ok($diceobj->probability(4843),7.48255411783854e-05);
ok($diceobj->probability(4844),0.000110681491427951);
ok($diceobj->probability(4845),0.000146537441677517);
ok($diceobj->probability(4846),0.000182393391927083);
ok($diceobj->probability(4847),0.000262222951253255);
ok($diceobj->probability(4848),0.000269562199910482);
ok($diceobj->probability(4849),0.000276901448567708);
ok($diceobj->probability(4850),0.000284629902309842);
ok($diceobj->probability(4851),0.000292358356051975);
ok($diceobj->probability(4852),0.000300086809794108);
ok($diceobj->probability(4853),0.00023465953403049);
ok($diceobj->probability(4854),0.000205477413601345);
ok($diceobj->probability(4855),0.000176295293172201);
ok($diceobj->probability(4856),0.000147113172743056);
ok($diceobj->probability(4857),0.000117931052313911);
ok($diceobj->probability(4858),8.87489318847656e-05);
ok($diceobj->probability(4859),7.39574432373047e-05);
ok($diceobj->probability(4860),5.91659545898437e-05);
ok($diceobj->probability(4861),4.43744659423828e-05);
ok($diceobj->probability(4862),7.23761876424154e-05);
ok($diceobj->probability(4863),0.000100377909342448);
ok($diceobj->probability(4864),0.000182727813720703);
ok($diceobj->probability(4865),0.000279869206746419);
ok($diceobj->probability(4866),0.000397819646199544);
ok($diceobj->probability(4867),0.000515770085652669);
ok($diceobj->probability(4868),0.000548134104410807);
ok($diceobj->probability(4869),0.000580498123168945);
ok($diceobj->probability(4870),0.000504165776570638);
ok($diceobj->probability(4871),0.000427833429972331);
ok($diceobj->probability(4872),0.000309882990519206);
ok($diceobj->probability(4873),0.000191932551066081);
ok($diceobj->probability(4874),0.000121164109971788);
ok($diceobj->probability(4875),5.03956688774957e-05);
ok($diceobj->probability(4876),3.39754104614258e-05);
ok($diceobj->probability(4877),4.27150641547309e-05);
ok($diceobj->probability(4878),7.22637642754449e-05);
ok($diceobj->probability(4879),0.000101812464396159);
ok($diceobj->probability(4880),0.000122583588494195);
ok($diceobj->probability(4881),0.000143354712592231);
ok($diceobj->probability(4882),0.000164125836690267);
ok($diceobj->probability(4883),0.000134577136569553);
ok($diceobj->probability(4884),0.000105028436448839);
ok($diceobj->probability(4885),7.5479736328125e-05);
ok($diceobj->probability(4886),5.031982421875e-05);
ok($diceobj->probability(4887),2.5159912109375e-05);
ok($diceobj->probability(4898),6.41771740383572e-05);
ok($diceobj->probability(4899),0.000128354348076714);
ok($diceobj->probability(4900),0.000192531522115072);
ok($diceobj->probability(4901),0.000256708696153429);
ok($diceobj->probability(4902),0.000334174368116591);
ok($diceobj->probability(4903),0.000413656298319499);
ok($diceobj->probability(4904),0.000364783880445692);
ok($diceobj->probability(4905),0.000315911462571886);
ok($diceobj->probability(4906),0.000267039044698079);
ok($diceobj->probability(4907),0.000218166626824273);
ok($diceobj->probability(4908),0.000142717213100857);
ok($diceobj->probability(4909),6.32352828979492e-05);
ok($diceobj->probability(4910),4.79305267333984e-05);
ok($diceobj->probability(4911),3.26257705688477e-05);
ok($diceobj->probability(4912),1.73210144042969e-05);
ok($diceobj->probability(4913),2.01625823974609e-06);
ok($diceobj->probability(4915),5.71886698404948e-06);
ok($diceobj->probability(4916),7.39551120334201e-05);
ok($diceobj->probability(4917),0.000142191357082791);
ok($diceobj->probability(4918),0.000210427602132161);
ok($diceobj->probability(4919),0.000278663847181532);
ok($diceobj->probability(4920),0.000346900092230903);
ok($diceobj->probability(4921),0.000403698603312174);
ok($diceobj->probability(4922),0.000335462358262804);
ok($diceobj->probability(4923),0.000267226113213433);
ok($diceobj->probability(4924),0.000198989868164063);
ok($diceobj->probability(4925),0.000130753623114692);
ok($diceobj->probability(4926),6.25173780653212e-05);
ok($diceobj->probability(4930),4.85794067382812e-05);
ok($diceobj->probability(4931),9.71588134765625e-05);
ok($diceobj->probability(4932),0.000147758407592773);
ok($diceobj->probability(4933),0.000198358001708984);
ok($diceobj->probability(4934),0.000248957595825195);
ok($diceobj->probability(4935),0.000299557189941406);
ok($diceobj->probability(4936),0.000252997970581055);
ok($diceobj->probability(4937),0.000206438751220703);
ok($diceobj->probability(4938),0.000155839157104492);
ok($diceobj->probability(4939),0.000105239562988281);
ok($diceobj->probability(4940),5.46399688720703e-05);
ok($diceobj->probability(4941),4.04037475585938e-06);
ok($diceobj->probability(4942),5.73764292399089e-05);
ok($diceobj->probability(4943),0.000110712483723958);
ok($diceobj->probability(4944),0.000166068725585938);
ok($diceobj->probability(4945),0.000221424967447917);
ok($diceobj->probability(4946),0.000276781209309896);
ok($diceobj->probability(4947),0.000332137451171875);
ok($diceobj->probability(4948),0.000276781209309896);
ok($diceobj->probability(4949),0.000221424967447917);
ok($diceobj->probability(4950),0.000166068725585938);
ok($diceobj->probability(4951),0.000110712483723958);
ok($diceobj->probability(4952),9.94045384724935e-05);
ok($diceobj->probability(4953),8.80965932210286e-05);
ok($diceobj->probability(4954),0.000132144889831543);
ok($diceobj->probability(4955),0.000176193186442057);
ok($diceobj->probability(4956),0.000220241483052572);
ok($diceobj->probability(4957),0.000264289779663086);
ok($diceobj->probability(4958),0.000220241483052572);
ok($diceobj->probability(4959),0.000176193186442057);
ok($diceobj->probability(4960),0.000132144889831543);
ok($diceobj->probability(4961),8.92316351996528e-05);
ok($diceobj->probability(4962),4.6575681898329e-05);
ok($diceobj->probability(4963),3.91972859700521e-06);
ok($diceobj->probability(4964),5.31207190619575e-06);
ok($diceobj->probability(4965),6.70441521538628e-06);
ok($diceobj->probability(4966),8.09675852457682e-06);
ok($diceobj->probability(4967),7.2190178765191e-06);
ok($diceobj->probability(4968),5.82667456732856e-06);
ok($diceobj->probability(4969),4.43433125813802e-06);
ok($diceobj->probability(4970),4.10806232028537e-05);
ok($diceobj->probability(4971),7.77269151475694e-05);
ok($diceobj->probability(4972),0.000114373207092285);
ok($diceobj->probability(4973),0.000152154541015625);
ok($diceobj->probability(4974),0.000190193176269531);
ok($diceobj->probability(4975),0.000228231811523437);
ok($diceobj->probability(4976),0.000190193176269531);
ok($diceobj->probability(4977),0.000152154541015625);
ok($diceobj->probability(4978),0.000114115905761719);
ok($diceobj->probability(4979),7.60772705078125e-05);
ok($diceobj->probability(4980),3.80386352539063e-05);
ok($diceobj->probability(4993),1.1444091796875e-08);
ok($diceobj->probability(4994),4.76757049560547e-05);
ok($diceobj->probability(4995),9.53399658203125e-05);
ok($diceobj->probability(4996),0.00014300422668457);
ok($diceobj->probability(4997),0.000190668487548828);
ok($diceobj->probability(4998),0.000238332748413086);
ok($diceobj->probability(4999),0.00028597412109375);
ok($diceobj->probability(5000),0.000282339307996962);
ok($diceobj->probability(5001),0.000278704494900174);
ok($diceobj->probability(5002),0.000286503918965658);
ok($diceobj->probability(5003),0.000294303343031142);
ok($diceobj->probability(5004),0.000302102767096625);
ok($diceobj->probability(5005),0.000309913635253906);
ok($diceobj->probability(5006),0.000277318424648709);
ok($diceobj->probability(5007),0.000244723214043511);
ok($diceobj->probability(5008),0.00018925952911377);
ok($diceobj->probability(5009),0.000133795844184028);
ok($diceobj->probability(5010),7.8332159254286e-05);
ok($diceobj->probability(5011),2.28684743245443e-05);
ok($diceobj->probability(5012),1.14342371622721e-05);
ok($diceobj->probability(5018),5.5732790629069e-05);
ok($diceobj->probability(5019),0.000111465581258138);
ok($diceobj->probability(5020),0.000167198371887207);
ok($diceobj->probability(5021),0.000222931162516276);
ok($diceobj->probability(5022),0.000278663953145345);
ok($diceobj->probability(5023),0.000334396743774414);
ok($diceobj->probability(5024),0.000278774473402235);
ok($diceobj->probability(5025),0.000223152203030056);
ok($diceobj->probability(5026),0.000167529932657878);
ok($diceobj->probability(5027),0.000111907662285699);
ok($diceobj->probability(5028),5.628539191352e-05);
ok($diceobj->probability(5029),6.63121541341146e-07);
ok($diceobj->probability(5030),5.52601284450955e-07);
ok($diceobj->probability(5031),4.42081027560764e-07);
ok($diceobj->probability(5032),3.31560770670573e-07);
ok($diceobj->probability(5033),2.21040513780382e-07);
ok($diceobj->probability(5034),1.10520256890191e-07);
ok($diceobj->probability(5042),0.000183116650051541);
ok($diceobj->probability(5043),0.000366233300103082);
ok($diceobj->probability(5044),0.000549349950154622);
ok($diceobj->probability(5045),0.000732466600206163);
ok($diceobj->probability(5046),0.000915583250257704);
ok($diceobj->probability(5047),0.00109869990030924);
ok($diceobj->probability(5048),0.000915585475497776);
ok($diceobj->probability(5049),0.000732471050686306);
ok($diceobj->probability(5050),0.000549356625874837);
ok($diceobj->probability(5051),0.000374932717217339);
ok($diceobj->probability(5052),0.000200508808559842);
ok($diceobj->probability(5053),2.60848999023438e-05);
ok($diceobj->probability(5054),3.47731908162435e-05);
ok($diceobj->probability(5055),4.34614817301432e-05);
ok($diceobj->probability(5056),7.46925989786784e-05);
ok($diceobj->probability(5057),8.85426839192708e-05);
ok($diceobj->probability(5058),0.000102392768859863);
ok($diceobj->probability(5059),0.000116242853800456);
ok($diceobj->probability(5060),0.00013009516398112);
ok($diceobj->probability(5061),0.000143947474161784);
ok($diceobj->probability(5062),0.000149245045979818);
ok($diceobj->probability(5063),0.000163233133951823);
ok($diceobj->probability(5064),0.000177221221923828);
ok($diceobj->probability(5065),0.000191209309895833);
ok($diceobj->probability(5066),0.000205197397867839);
ok($diceobj->probability(5067),0.000219185485839844);
ok($diceobj->probability(5068),0.000182654571533203);
ok($diceobj->probability(5069),0.000146123657226562);
ok($diceobj->probability(5070),0.000109592742919922);
ok($diceobj->probability(5071),7.30618286132812e-05);
ok($diceobj->probability(5072),5.56334559122721e-05);
ok($diceobj->probability(5073),3.8205083211263e-05);
ok($diceobj->probability(5074),5.73076248168945e-05);
ok($diceobj->probability(5075),7.6410166422526e-05);
ok($diceobj->probability(5076),9.55127080281576e-05);
ok($diceobj->probability(5077),0.000114704895019531);
ok($diceobj->probability(5078),9.56919987996419e-05);
ok($diceobj->probability(5079),7.66791025797526e-05);
ok($diceobj->probability(5080),5.76662063598633e-05);
ok($diceobj->probability(5081),3.8653310139974e-05);
ok($diceobj->probability(5082),1.96404139200846e-05);
ok($diceobj->probability(5083),4.48226928710937e-07);
ok($diceobj->probability(5084),2.54898071289063e-05);
ok($diceobj->probability(5085),8.4860102335612e-05);
ok($diceobj->probability(5086),0.000144230397542318);
ok($diceobj->probability(5087),0.000203600692749023);
ok($diceobj->probability(5088),0.000262970987955729);
ok($diceobj->probability(5089),0.000322430928548177);
ok($diceobj->probability(5090),0.00033162841796875);
ok($diceobj->probability(5091),0.000272168477376302);
ok($diceobj->probability(5092),0.000212708536783854);
ok($diceobj->probability(5093),0.000153248596191406);
ok($diceobj->probability(5094),9.37886555989583e-05);
ok($diceobj->probability(5095),3.43287150065104e-05);
ok($diceobj->probability(5098),1.74914042154948e-05);
ok($diceobj->probability(5099),3.49828084309896e-05);
ok($diceobj->probability(5100),5.24742126464844e-05);
ok($diceobj->probability(5101),6.99656168619792e-05);
ok($diceobj->probability(5102),0.000149061681959364);
ok($diceobj->probability(5103),0.000228157747056749);
ok($diceobj->probability(5104),0.000272271003723145);
ok($diceobj->probability(5105),0.00031943167368571);
ok($diceobj->probability(5106),0.000369889386494954);
ok($diceobj->probability(5107),0.000420347099304199);
ok($diceobj->probability(5108),0.000347595490349664);
ok($diceobj->probability(5109),0.000274843881395128);
ok($diceobj->probability(5110),0.000219583676656087);
ok($diceobj->probability(5111),0.000158228645324707);
ok($diceobj->probability(5112),9.02795282999674e-05);
ok($diceobj->probability(5113),2.23304112752279e-05);
ok($diceobj->probability(5114),1.59859551323785e-05);
ok($diceobj->probability(5115),9.64149898952908e-06);
ok($diceobj->probability(5116),3.29704284667969e-06);
ok($diceobj->probability(5117),3.0517578125e-07);
ok($diceobj->probability(5118),6.103515625e-07);
ok($diceobj->probability(5119),9.1552734375e-07);
ok($diceobj->probability(5120),1.220703125e-06);
ok($diceobj->probability(5121),1.52587890625e-06);
ok($diceobj->probability(5122),2.08104070027669e-05);
ok($diceobj->probability(5123),3.94845835367839e-05);
ok($diceobj->probability(5124),5.81587600708008e-05);
ok($diceobj->probability(5125),7.68329366048177e-05);
ok($diceobj->probability(5126),9.55071131388346e-05);
ok($diceobj->probability(5127),0.000114181289672852);
ok($diceobj->probability(5128),9.48967615763346e-05);
ok($diceobj->probability(5129),7.59174092610677e-05);
ok($diceobj->probability(5130),5.69380569458008e-05);
ok($diceobj->probability(5131),3.79587046305339e-05);
ok($diceobj->probability(5132),6.36037868923611e-05);
ok($diceobj->probability(5133),8.92488691541884e-05);
ok($diceobj->probability(5134),0.000133873303731283);
ok($diceobj->probability(5135),0.000178497738308377);
ok($diceobj->probability(5136),0.000223122172885471);
ok($diceobj->probability(5137),0.000267746607462565);
ok($diceobj->probability(5138),0.000223122172885471);
ok($diceobj->probability(5139),0.000178497738308377);
ok($diceobj->probability(5140),0.000133873303731283);
ok($diceobj->probability(5141),8.92488691541884e-05);
ok($diceobj->probability(5142),4.46244345770942e-05);
ok($diceobj->probability(5150),5.41385650634766e-05);
ok($diceobj->probability(5151),0.000108277130126953);
ok($diceobj->probability(5152),0.00016241569519043);
ok($diceobj->probability(5153),0.000216554260253906);
ok($diceobj->probability(5154),0.000306336847941081);
ok($diceobj->probability(5155),0.000396119435628255);
ok($diceobj->probability(5156),0.000377624893188477);
ok($diceobj->probability(5157),0.000359130350748698);
ok($diceobj->probability(5158),0.000340635808308919);
ok($diceobj->probability(5159),0.000322141265869141);
ok($diceobj->probability(5160),0.000232358678181966);
ok($diceobj->probability(5161),0.000142576090494792);
ok($diceobj->probability(5162),0.000106932067871094);
ok($diceobj->probability(5163),7.12880452473958e-05);
ok($diceobj->probability(5164),3.56440226236979e-05);
ok($diceobj->probability(5170),3.32486470540365e-05);
ok($diceobj->probability(5171),6.64972941080729e-05);
ok($diceobj->probability(5172),9.97459411621094e-05);
ok($diceobj->probability(5173),0.000132994588216146);
ok($diceobj->probability(5174),0.000166243235270182);
ok($diceobj->probability(5175),0.000199491882324219);
ok($diceobj->probability(5176),0.000166243235270182);
ok($diceobj->probability(5177),0.000154643334282769);
ok($diceobj->probability(5178),0.000143043433295356);
ok($diceobj->probability(5179),0.000131443532307943);
ok($diceobj->probability(5180),0.00011984363132053);
ok($diceobj->probability(5181),0.000108243730333116);
ok($diceobj->probability(5182),0.00012989247639974);
ok($diceobj->probability(5183),0.000108243730333116);
ok($diceobj->probability(5184),8.65949842664931e-05);
ok($diceobj->probability(5185),6.49462381998698e-05);
ok($diceobj->probability(5186),9.79720857408312e-05);
ok($diceobj->probability(5187),0.000130997933281793);
ok($diceobj->probability(5188),0.000164023780822754);
ok($diceobj->probability(5189),0.000260407214694553);
ok($diceobj->probability(5190),0.000356790648566352);
ok($diceobj->probability(5191),0.000453174082438151);
ok($diceobj->probability(5192),0.000440208329094781);
ok($diceobj->probability(5193),0.000427242575751411);
ok($diceobj->probability(5194),0.00041427682240804);
ok($diceobj->probability(5195),0.000317893388536241);
ok($diceobj->probability(5196),0.000221509954664442);
ok($diceobj->probability(5197),0.000125126520792643);
ok($diceobj->probability(5198),8.34176805284288e-05);
ok($diceobj->probability(5199),4.17088402642144e-05);
ok($diceobj->probability(5202),5.34282938639323e-05);
ok($diceobj->probability(5203),0.000106856587727865);
ok($diceobj->probability(5204),0.000174288084242079);
ok($diceobj->probability(5205),0.000241719580756293);
ok($diceobj->probability(5206),0.000309151077270508);
ok($diceobj->probability(5207),0.000376582573784722);
ok($diceobj->probability(5208),0.000337157482571072);
ok($diceobj->probability(5209),0.000297732391357422);
ok($diceobj->probability(5210),0.000230735240512424);
ok($diceobj->probability(5211),0.000163738089667426);
ok($diceobj->probability(5212),9.67409388224284e-05);
ok($diceobj->probability(5213),2.97437879774306e-05);
ok($diceobj->probability(5214),1.6174930996365e-05);
ok($diceobj->probability(5215),2.60607401529948e-06);
ok($diceobj->probability(5216),2.1717283460829e-06);
ok($diceobj->probability(5217),1.73738267686632e-06);
ok($diceobj->probability(5218),1.30303700764974e-06);
ok($diceobj->probability(5219),8.6869133843316e-07);
ok($diceobj->probability(5220),4.3434566921658e-07);
ok($diceobj->probability(5222),6.53260548909505e-06);
ok($diceobj->probability(5223),1.30652109781901e-05);
ok($diceobj->probability(5224),1.95978164672852e-05);
ok($diceobj->probability(5225),2.61304219563802e-05);
ok($diceobj->probability(5226),3.26630274454753e-05);
ok($diceobj->probability(5227),5.48318862915039e-05);
ok($diceobj->probability(5228),6.39355341593425e-05);
ok($diceobj->probability(5229),7.3039182027181e-05);
ok($diceobj->probability(5230),8.21428298950195e-05);
ok($diceobj->probability(5231),9.12464777628581e-05);
ok($diceobj->probability(5232),0.000100350125630697);
ok($diceobj->probability(5233),7.8181266784668e-05);
ok($diceobj->probability(5234),6.25450134277344e-05);
ok($diceobj->probability(5235),4.69087600708008e-05);
ok($diceobj->probability(5236),3.12725067138672e-05);
ok($diceobj->probability(5237),1.56362533569336e-05);
ok($diceobj->probability(5238),4.28237915039063e-05);
ok($diceobj->probability(5239),8.56475830078125e-05);
ok($diceobj->probability(5240),0.000128471374511719);
ok($diceobj->probability(5241),0.000171502113342285);
ok($diceobj->probability(5242),0.000214532852172852);
ok($diceobj->probability(5243),0.000257563591003418);
ok($diceobj->probability(5244),0.000214946746826172);
ok($diceobj->probability(5245),0.000172329902648926);
ok($diceobj->probability(5246),0.00015897594028049);
ok($diceobj->probability(5247),0.000145208083258735);
ok($diceobj->probability(5248),0.000131440226236979);
ok($diceobj->probability(5249),0.000117672369215224);
ok($diceobj->probability(5250),0.000146728303697374);
ok($diceobj->probability(5251),0.000175784238179525);
ok($diceobj->probability(5252),0.000180055520799425);
ok($diceobj->probability(5253),0.000184533750745985);
ok($diceobj->probability(5254),0.000189011980692546);
ok($diceobj->probability(5255),0.000193490210639106);
ok($diceobj->probability(5256),0.000197968440585666);
ok($diceobj->probability(5257),0.000202446670532227);
ok($diceobj->probability(5258),0.000168705558776855);
ok($diceobj->probability(5259),0.000134964447021484);
ok($diceobj->probability(5260),0.000101223335266113);
ok($diceobj->probability(5261),6.74822235107422e-05);
ok($diceobj->probability(5262),3.37411117553711e-05);
ok($diceobj->probability(5267),1.22699228922526e-05);
ok($diceobj->probability(5268),2.45398457845052e-05);
ok($diceobj->probability(5269),3.68097686767578e-05);
ok($diceobj->probability(5270),4.90796915690104e-05);
ok($diceobj->probability(5271),6.1349614461263e-05);
ok($diceobj->probability(5272),7.38067754109701e-05);
ok($diceobj->probability(5273),6.17240905761719e-05);
ok($diceobj->probability(5274),4.96414057413737e-05);
ok($diceobj->probability(5275),3.75587209065755e-05);
ok($diceobj->probability(5276),2.54760360717773e-05);
ok($diceobj->probability(5277),1.33933512369792e-05);
ok($diceobj->probability(5278),9.36190287272135e-07);
ok($diceobj->probability(5279),7.48952229817708e-07);
ok($diceobj->probability(5280),4.66302235921224e-06);
ok($diceobj->probability(5281),8.57709248860677e-06);
ok($diceobj->probability(5282),0.000111336186726888);
ok($diceobj->probability(5283),0.000214095280965169);
ok($diceobj->probability(5284),0.000317041613260905);
ok($diceobj->probability(5285),0.000419987945556641);
ok($diceobj->probability(5286),0.000514731661478678);
ok($diceobj->probability(5287),0.000609475377400716);
ok($diceobj->probability(5288),0.00050652904510498);
ok($diceobj->probability(5289),0.000403582712809245);
ok($diceobj->probability(5290),0.000300636380513509);
ok($diceobj->probability(5291),0.000197690048217773);
ok($diceobj->probability(5292),0.000104269828796387);
ok($diceobj->probability(5293),1.0849609375e-05);
ok($diceobj->probability(5294),8.13876088460286e-05);
ok($diceobj->probability(5295),0.000151925608317057);
ok($diceobj->probability(5296),0.000222463607788086);
ok($diceobj->probability(5297),0.000293001607259115);
ok($diceobj->probability(5298),0.000352689997355143);
ok($diceobj->probability(5299),0.000412378387451172);
ok($diceobj->probability(5300),0.000341840387980143);
ok($diceobj->probability(5301),0.000271302388509115);
ok($diceobj->probability(5302),0.000200764389038086);
ok($diceobj->probability(5303),0.000130324406094021);
ok($diceobj->probability(5304),6.53092278374566e-05);
ok($diceobj->probability(5305),2.94049580891927e-07);
ok($diceobj->probability(5306),4.29681777954102e-05);
ok($diceobj->probability(5307),8.56423060099284e-05);
ok($diceobj->probability(5308),0.000128316434224447);
ok($diceobj->probability(5309),0.000170794529385037);
ok($diceobj->probability(5310),0.000213272624545627);
ok($diceobj->probability(5311),0.000255750719706217);
ok($diceobj->probability(5312),0.000213076591491699);
ok($diceobj->probability(5313),0.000170402463277181);
ok($diceobj->probability(5314),0.000127728335062663);
ok($diceobj->probability(5315),0.00010591180589464);
ok($diceobj->probability(5316),8.40952767266168e-05);
ok($diceobj->probability(5317),6.22787475585938e-05);
ok($diceobj->probability(5318),8.3038330078125e-05);
ok($diceobj->probability(5319),0.000103797912597656);
ok($diceobj->probability(5320),0.000124557495117188);
ok($diceobj->probability(5321),0.000103797912597656);
ok($diceobj->probability(5322),0.000127634518941243);
ok($diceobj->probability(5323),0.000151471125284831);
ok($diceobj->probability(5324),0.000175307731628418);
ok($diceobj->probability(5325),0.000199144337972005);
ok($diceobj->probability(5326),0.000233641115824382);
ok($diceobj->probability(5327),0.000288897476196289);
ok($diceobj->probability(5328),0.00025496145884196);
ok($diceobj->probability(5329),0.00022102544148763);
ok($diceobj->probability(5330),0.000187089424133301);
ok($diceobj->probability(5331),0.000153153406778971);
ok($diceobj->probability(5332),9.78970464070638e-05);
ok($diceobj->probability(5333),4.26406860351563e-05);
ok($diceobj->probability(5334),3.19805145263672e-05);
ok($diceobj->probability(5335),2.13203430175781e-05);
ok($diceobj->probability(5336),1.06601715087891e-05);
ok($diceobj->probability(5338),3.43577067057292e-07);
ok($diceobj->probability(5339),6.87154134114583e-07);
ok($diceobj->probability(5340),1.03073120117187e-06);
ok($diceobj->probability(5341),1.37430826822917e-06);
ok($diceobj->probability(5342),1.71788533528646e-06);
ok($diceobj->probability(5343),2.06146240234375e-06);
ok($diceobj->probability(5344),1.71788533528646e-06);
ok($diceobj->probability(5345),1.37430826822917e-06);
ok($diceobj->probability(5346),1.03073120117187e-06);
ok($diceobj->probability(5347),6.87154134114583e-07);
ok($diceobj->probability(5348),1.09978357950846e-05);
ok($diceobj->probability(5349),2.13085174560547e-05);
ok($diceobj->probability(5350),3.1962776184082e-05);
ok($diceobj->probability(5351),4.26170349121094e-05);
ok($diceobj->probability(5352),5.32712936401367e-05);
ok($diceobj->probability(5353),6.39255523681641e-05);
ok($diceobj->probability(5354),5.32712936401367e-05);
ok($diceobj->probability(5355),4.26170349121094e-05);
ok($diceobj->probability(5356),3.1962776184082e-05);
ok($diceobj->probability(5357),5.69688161214193e-05);
ok($diceobj->probability(5358),8.19748560587565e-05);
ok($diceobj->probability(5359),0.000106980895996094);
ok($diceobj->probability(5360),0.000142641194661458);
ok($diceobj->probability(5361),0.000178301493326823);
ok($diceobj->probability(5362),0.000213961791992187);
ok($diceobj->probability(5363),0.000178301493326823);
ok($diceobj->probability(5364),0.000142641194661458);
ok($diceobj->probability(5365),0.000106980895996094);
ok($diceobj->probability(5366),7.13205973307292e-05);
ok($diceobj->probability(5367),3.56602986653646e-05);
ok($diceobj->probability(5378),5.20761489868164e-05);
ok($diceobj->probability(5379),0.000104152297973633);
ok($diceobj->probability(5380),0.000156228446960449);
ok($diceobj->probability(5381),0.000208304595947266);
ok($diceobj->probability(5382),0.000260380744934082);
ok($diceobj->probability(5383),0.000312456893920898);
ok($diceobj->probability(5384),0.000295146963331434);
ok($diceobj->probability(5385),0.000277837032741971);
ok($diceobj->probability(5386),0.000260527102152506);
ok($diceobj->probability(5387),0.000243217171563043);
ok($diceobj->probability(5388),0.000225907240973579);
ok($diceobj->probability(5389),0.000208597310384115);
ok($diceobj->probability(5390),0.000173831091986762);
ok($diceobj->probability(5391),0.00013906487358941);
ok($diceobj->probability(5392),0.000104298655192057);
ok($diceobj->probability(5393),6.95324367947049e-05);
ok($diceobj->probability(5394),3.47662183973524e-05);
ok($diceobj->probability(5396),3.17891438802083e-10);
ok($diceobj->probability(5397),6.35782877604167e-10);
ok($diceobj->probability(5398),9.5367431640625e-10);
ok($diceobj->probability(5399),1.27156575520833e-09);
ok($diceobj->probability(5400),1.58945719401042e-09);
ok($diceobj->probability(5401),1.9073486328125e-09);
ok($diceobj->probability(5402),8.00588904486762e-05);
ok($diceobj->probability(5403),0.00016011587354872);
ok($diceobj->probability(5404),0.000240172856648763);
ok($diceobj->probability(5405),0.000320229839748806);
ok($diceobj->probability(5406),0.00040028682284885);
ok($diceobj->probability(5407),0.000480343805948893);
ok($diceobj->probability(5408),0.000400286504957411);
ok($diceobj->probability(5409),0.000320229203965929);
ok($diceobj->probability(5410),0.000257396278381348);
ok($diceobj->probability(5411),0.000194563352796766);
ok($diceobj->probability(5412),0.000131730427212185);
ok($diceobj->probability(5413),6.88975016276042e-05);
ok($diceobj->probability(5414),8.61218770345052e-05);
ok($diceobj->probability(5415),0.000103346252441406);
ok($diceobj->probability(5416),8.61218770345052e-05);
ok($diceobj->probability(5417),8.62269168429905e-05);
ok($diceobj->probability(5418),8.63319566514757e-05);
ok($diceobj->probability(5419),8.64369964599609e-05);
ok($diceobj->probability(5420),8.65420362684462e-05);
ok($diceobj->probability(5421),8.66470760769314e-05);
ok($diceobj->probability(5422),0.000103976491292318);
ok($diceobj->probability(5423),8.66470760769314e-05);
ok($diceobj->probability(5424),6.93176608615451e-05);
ok($diceobj->probability(5425),5.46797053019206e-05);
ok($diceobj->probability(5426),4.0041749742296e-05);
ok($diceobj->probability(5427),2.54104699028863e-05);
ok($diceobj->probability(5428),1.07791900634766e-05);
ok($diceobj->probability(5429),1.34773254394531e-05);
ok($diceobj->probability(5430),1.61754608154297e-05);
ok($diceobj->probability(5431),1.34906768798828e-05);
ok($diceobj->probability(5432),1.08058929443359e-05);
ok($diceobj->probability(5433),8.10775756835937e-06);
ok($diceobj->probability(5434),5.40962219238281e-06);
ok($diceobj->probability(5435),2.71148681640625e-06);
ok($diceobj->probability(5436),4.6855354309082e-05);
ok($diceobj->probability(5437),9.36906814575195e-05);
ok($diceobj->probability(5438),0.000140526008605957);
ok($diceobj->probability(5439),0.000187368011474609);
ok($diceobj->probability(5440),0.000234210014343262);
ok($diceobj->probability(5441),0.000281052017211914);
ok($diceobj->probability(5442),0.000264213943481445);
ok($diceobj->probability(5443),0.000247375869750977);
ok($diceobj->probability(5444),0.000230537796020508);
ok($diceobj->probability(5445),0.000213699722290039);
ok($diceobj->probability(5446),0.00019686164855957);
ok($diceobj->probability(5447),0.000180023574829102);
ok($diceobj->probability(5448),0.000150019645690918);
ok($diceobj->probability(5449),0.000120015716552734);
ok($diceobj->probability(5450),9.00117874145508e-05);
ok($diceobj->probability(5451),6.00078582763672e-05);
ok($diceobj->probability(5452),3.00039291381836e-05);
ok($diceobj->probability(5458),3.09944152832031e-07);
ok($diceobj->probability(5459),6.19888305664063e-07);
ok($diceobj->probability(5460),9.29832458496094e-07);
ok($diceobj->probability(5461),1.23977661132813e-06);
ok($diceobj->probability(5462),7.32843780517578e-05);
ok($diceobj->probability(5463),0.000145328979492187);
ok($diceobj->probability(5464),0.000216753692626953);
ok($diceobj->probability(5465),0.000288178405761719);
ok($diceobj->probability(5466),0.000359603118896484);
ok($diceobj->probability(5467),0.00043102783203125);
ok($diceobj->probability(5468),0.00035898323059082);
ok($diceobj->probability(5469),0.000286938629150391);
ok($diceobj->probability(5470),0.000215203971862793);
ok($diceobj->probability(5471),0.000143469314575195);
ok($diceobj->probability(5472),7.17346572875977e-05);
ok($diceobj->probability(5474),5.06979412502713e-05);
ok($diceobj->probability(5475),0.000101395882500543);
ok($diceobj->probability(5476),0.000183271090189616);
ok($diceobj->probability(5477),0.000265146297878689);
ok($diceobj->probability(5478),0.000347021505567763);
ok($diceobj->probability(5479),0.000428896713256836);
ok($diceobj->probability(5480),0.000409376038445367);
ok($diceobj->probability(5481),0.000389855363633898);
ok($diceobj->probability(5482),0.000307980155944824);
ok($diceobj->probability(5483),0.000227067184448242);
ok($diceobj->probability(5484),0.00014615421295166);
ok($diceobj->probability(5485),6.52412414550781e-05);
ok($diceobj->probability(5486),3.50262112087674e-05);
ok($diceobj->probability(5487),4.8111809624566e-06);
ok($diceobj->probability(5488),5.77341715494792e-06);
ok($diceobj->probability(5489),4.8111809624566e-06);
ok($diceobj->probability(5490),7.72830115424262e-06);
ok($diceobj->probability(5491),1.06454213460286e-05);
ok($diceobj->probability(5492),1.35625415378147e-05);
ok($diceobj->probability(5493),2.85438961452908e-05);
ok($diceobj->probability(5494),4.35252507527669e-05);
ok($diceobj->probability(5495),5.94688415527344e-05);
ok($diceobj->probability(5496),6.76537195841471e-05);
ok($diceobj->probability(5497),7.58385976155599e-05);
ok($diceobj->probability(5498),8.40234756469727e-05);
ok($diceobj->probability(5499),6.80798848470052e-05);
ok($diceobj->probability(5500),5.21362940470378e-05);
ok($diceobj->probability(5501),3.61927032470703e-05);
ok($diceobj->probability(5502),4.65297444661458e-05);
ok($diceobj->probability(5503),5.68667856852214e-05);
ok($diceobj->probability(5504),6.72038269042969e-05);
ok($diceobj->probability(5505),8.96051025390625e-05);
ok($diceobj->probability(5506),0.000112006378173828);
ok($diceobj->probability(5507),0.000134407653808594);
ok($diceobj->probability(5508),0.000112006378173828);
ok($diceobj->probability(5509),8.96051025390625e-05);
ok($diceobj->probability(5510),8.80667029486762e-05);
ok($diceobj->probability(5511),8.65283033582899e-05);
ok($diceobj->probability(5512),8.67484537760417e-05);
ok($diceobj->probability(5513),8.69686041937934e-05);
ok($diceobj->probability(5514),0.000109590030246311);
ok($diceobj->probability(5515),0.000132211456298828);
ok($diceobj->probability(5516),0.000113107130262587);
ok($diceobj->probability(5517),9.40028042263455e-05);
ok($diceobj->probability(5518),7.13813781738281e-05);
ok($diceobj->probability(5519),4.87599521213108e-05);
ok($diceobj->probability(5520),2.61385260687934e-05);
ok($diceobj->probability(5521),3.51710001627604e-06);
ok($diceobj->probability(5522),6.71213701036241e-05);
ok($diceobj->probability(5523),0.000130725640190972);
ok($diceobj->probability(5524),0.000196088460286458);
ok($diceobj->probability(5525),0.000261451280381944);
ok($diceobj->probability(5526),0.000326814100477431);
ok($diceobj->probability(5527),0.000413354848225911);
ok($diceobj->probability(5528),0.00036916995578342);
ok($diceobj->probability(5529),0.000324985063340929);
ok($diceobj->probability(5530),0.000280800170898437);
ok($diceobj->probability(5531),0.000236615278455946);
ok($diceobj->probability(5532),0.000192430386013455);
ok($diceobj->probability(5533),0.000105889638264974);
ok($diceobj->probability(5534),8.47117106119792e-05);
ok($diceobj->probability(5535),6.35337829589844e-05);
ok($diceobj->probability(5536),4.23558553059896e-05);
ok($diceobj->probability(5537),2.11779276529948e-05);
ok($diceobj->probability(5546),8.58331680297852e-05);
ok($diceobj->probability(5547),0.00017166633605957);
ok($diceobj->probability(5548),0.000257499504089355);
ok($diceobj->probability(5549),0.000343332672119141);
ok($diceobj->probability(5550),0.000429165840148926);
ok($diceobj->probability(5551),0.000514999008178711);
ok($diceobj->probability(5552),0.000429165840148926);
ok($diceobj->probability(5553),0.000343332672119141);
ok($diceobj->probability(5554),0.000257499504089355);
ok($diceobj->probability(5555),0.00017166633605957);
ok($diceobj->probability(5556),8.58331680297852e-05);
ok($diceobj->probability(5568),1.75918579101563e-05);
ok($diceobj->probability(5569),3.51837158203125e-05);
ok($diceobj->probability(5570),5.64164055718316e-05);
ok($diceobj->probability(5571),7.76490953233507e-05);
ok($diceobj->probability(5572),9.88817850748698e-05);
ok($diceobj->probability(5573),0.000120114474826389);
ok($diceobj->probability(5574),0.000106163448757595);
ok($diceobj->probability(5575),9.22124226888021e-05);
ok($diceobj->probability(5576),7.0979732937283e-05);
ok($diceobj->probability(5577),4.97470431857639e-05);
ok($diceobj->probability(5578),2.85143534342448e-05);
ok($diceobj->probability(5579),7.28166368272569e-06);
ok($diceobj->probability(5580),3.64083184136285e-06);
ok($diceobj->probability(5582),6.12703959147135e-07);
ok($diceobj->probability(5583),1.22540791829427e-06);
ok($diceobj->probability(5584),1.83811187744141e-06);
ok($diceobj->probability(5585),2.45081583658854e-06);
ok($diceobj->probability(5586),3.06351979573568e-06);
ok($diceobj->probability(5587),3.67622375488281e-06);
ok($diceobj->probability(5588),3.96492216322157e-05);
ok($diceobj->probability(5589),7.56222195095486e-05);
ok($diceobj->probability(5590),0.000111595217386882);
ok($diceobj->probability(5591),0.000149638917711046);
ok($diceobj->probability(5592),0.000187682618035211);
ok($diceobj->probability(5593),0.000225726318359375);
ok($diceobj->probability(5594),0.000191211318969727);
ok($diceobj->probability(5595),0.000156696319580078);
ok($diceobj->probability(5596),0.00012218132019043);
ok($diceobj->probability(5597),8.35249159071181e-05);
ok($diceobj->probability(5598),4.48685116238064e-05);
ok($diceobj->probability(5599),6.21210734049479e-06);
ok($diceobj->probability(5600),4.14140489366319e-06);
ok($diceobj->probability(5601),2.0707024468316e-06);
ok($diceobj->probability(5602),4.39414342244466e-05);
ok($diceobj->probability(5603),8.78828684488932e-05);
ok($diceobj->probability(5604),0.00013182430267334);
ok($diceobj->probability(5605),0.000175765736897786);
ok($diceobj->probability(5606),0.000219707171122233);
ok($diceobj->probability(5607),0.00026364860534668);
ok($diceobj->probability(5608),0.000219707171122233);
ok($diceobj->probability(5609),0.000175765736897786);
ok($diceobj->probability(5610),0.00013182430267334);
ok($diceobj->probability(5611),8.78828684488932e-05);
ok($diceobj->probability(5612),7.54451751708984e-05);
ok($diceobj->probability(5613),6.30074818929036e-05);
ok($diceobj->probability(5614),9.45112228393555e-05);
ok($diceobj->probability(5615),0.000126014963785807);
ok($diceobj->probability(5616),0.000157518704732259);
ok($diceobj->probability(5617),0.000189022445678711);
ok($diceobj->probability(5618),0.000211132494608561);
ok($diceobj->probability(5619),0.000233242543538411);
ok($diceobj->probability(5620),0.000255352592468262);
ok($diceobj->probability(5621),0.000277462641398112);
ok($diceobj->probability(5622),0.000299572690327962);
ok($diceobj->probability(5623),0.000321682739257813);
ok($diceobj->probability(5624),0.00026806894938151);
ok($diceobj->probability(5625),0.000214455159505208);
ok($diceobj->probability(5626),0.000160841369628906);
ok($diceobj->probability(5627),0.000119282633463542);
ok($diceobj->probability(5628),7.77238972981771e-05);
ok($diceobj->probability(5629),3.61651611328125e-05);
ok($diceobj->probability(5630),4.822021484375e-05);
ok($diceobj->probability(5631),6.02752685546875e-05);
ok($diceobj->probability(5632),7.2330322265625e-05);
ok($diceobj->probability(5633),6.02752685546875e-05);
ok($diceobj->probability(5634),6.26636123657227e-05);
ok($diceobj->probability(5635),6.50519561767578e-05);
ok($diceobj->probability(5636),6.7440299987793e-05);
ok($diceobj->probability(5637),6.98286437988281e-05);
ok($diceobj->probability(5638),7.22169876098633e-05);
ok($diceobj->probability(5639),8.66603851318359e-05);
ok($diceobj->probability(5640),7.22169876098633e-05);
ok($diceobj->probability(5641),5.77735900878906e-05);
ok($diceobj->probability(5642),4.3330192565918e-05);
ok($diceobj->probability(5643),2.88867950439453e-05);
ok($diceobj->probability(5644),1.48550669352214e-05);
ok($diceobj->probability(5645),8.42514038085938e-06);
ok($diceobj->probability(5646),1.64386113484701e-05);
ok($diceobj->probability(5647),2.44520823160807e-05);
ok($diceobj->probability(5648),3.24655532836914e-05);
ok($diceobj->probability(5649),4.04790242513021e-05);
ok($diceobj->probability(5650),4.76691563924154e-05);
ok($diceobj->probability(5651),3.96556854248047e-05);
ok($diceobj->probability(5652),3.1642214457194e-05);
ok($diceobj->probability(5653),2.36287434895833e-05);
ok($diceobj->probability(5654),1.56152725219727e-05);
ok($diceobj->probability(5655),7.60180155436198e-06);
ok($diceobj->probability(5657),3.80835639105903e-06);
ok($diceobj->probability(5658),7.61671278211806e-06);
ok($diceobj->probability(5659),1.14250691731771e-05);
ok($diceobj->probability(5660),1.52334255642361e-05);
ok($diceobj->probability(5661),1.90417819552951e-05);
ok($diceobj->probability(5662),2.28501383463542e-05);
ok($diceobj->probability(5663),1.90417819552951e-05);
ok($diceobj->probability(5664),1.52334255642361e-05);
ok($diceobj->probability(5665),1.14250691731771e-05);
ok($diceobj->probability(5666),7.61671278211806e-06);
ok($diceobj->probability(5667),3.80835639105903e-06);
ok($diceobj->probability(5672),4.77743318345812e-05);
ok($diceobj->probability(5673),9.55486636691623e-05);
ok($diceobj->probability(5674),0.000143322995503743);
ok($diceobj->probability(5675),0.000191097327338325);
ok($diceobj->probability(5676),0.000238871659172906);
ok($diceobj->probability(5677),0.000286645991007487);
ok($diceobj->probability(5678),0.000238871659172906);
ok($diceobj->probability(5679),0.000191097327338325);
ok($diceobj->probability(5680),0.000143322995503743);
ok($diceobj->probability(5681),9.55486636691623e-05);
ok($diceobj->probability(5682),4.77743318345812e-05);
ok($diceobj->probability(5683),2.93706258138021e-05);
ok($diceobj->probability(5684),5.87412516276042e-05);
ok($diceobj->probability(5685),8.81118774414062e-05);
ok($diceobj->probability(5686),0.000119494756062826);
ok($diceobj->probability(5687),0.000150877634684245);
ok($diceobj->probability(5688),0.000182260513305664);
ok($diceobj->probability(5689),0.000154902140299479);
ok($diceobj->probability(5690),0.000127543767293294);
ok($diceobj->probability(5691),0.000100185394287109);
ok($diceobj->probability(5692),6.88025156656901e-05);
ok($diceobj->probability(5693),3.74196370442708e-05);
ok($diceobj->probability(5694),6.03675842285156e-06);
ok($diceobj->probability(5695),4.02450561523437e-06);
ok($diceobj->probability(5696),2.01225280761719e-06);
ok($diceobj->probability(5702),4.99997160169813e-05);
ok($diceobj->probability(5703),9.99994320339627e-05);
ok($diceobj->probability(5704),0.000149999148050944);
ok($diceobj->probability(5705),0.000199998864067925);
ok($diceobj->probability(5706),0.000250025282965766);
ok($diceobj->probability(5707),0.000300051701863607);
ok($diceobj->probability(5708),0.000250078688727485);
ok($diceobj->probability(5709),0.000200105675591363);
ok($diceobj->probability(5710),0.000150132662455241);
ok($diceobj->probability(5711),0.000100159649319119);
ok($diceobj->probability(5712),5.01332304212782e-05);
ok($diceobj->probability(5713),1.068115234375e-07);
ok($diceobj->probability(5714),5.77236599392361e-05);
ok($diceobj->probability(5715),0.000115340508355035);
ok($diceobj->probability(5716),0.000172957356770833);
ok($diceobj->probability(5717),0.000230574205186632);
ok($diceobj->probability(5718),0.00028821775648329);
ok($diceobj->probability(5719),0.000345861307779948);
ok($diceobj->probability(5720),0.00028821775648329);
ok($diceobj->probability(5721),0.000230574205186632);
ok($diceobj->probability(5722),0.000221666005452474);
ok($diceobj->probability(5723),0.000212757805718316);
ok($diceobj->probability(5724),0.000203849605984158);
ok($diceobj->probability(5725),0.00019494140625);
ok($diceobj->probability(5726),0.0002436767578125);
ok($diceobj->probability(5727),0.000292412109375);
ok($diceobj->probability(5728),0.0002436767578125);
ok($diceobj->probability(5729),0.00019494140625);
ok($diceobj->probability(5730),0.0001462060546875);
ok($diceobj->probability(5731),9.7470703125e-05);
ok($diceobj->probability(5732),4.87353515625e-05);
ok($diceobj->probability(5735),1.69828202989366e-05);
ok($diceobj->probability(5736),3.39656405978733e-05);
ok($diceobj->probability(5737),5.09484608968099e-05);
ok($diceobj->probability(5738),6.79312811957465e-05);
ok($diceobj->probability(5739),8.49141014946832e-05);
ok($diceobj->probability(5740),0.00010189692179362);
ok($diceobj->probability(5741),8.49141014946832e-05);
ok($diceobj->probability(5742),6.79312811957465e-05);
ok($diceobj->probability(5743),5.09484608968099e-05);
ok($diceobj->probability(5744),3.72588687472873e-05);
ok($diceobj->probability(5745),2.35692765977648e-05);
ok($diceobj->probability(5746),9.87968444824219e-06);
ok($diceobj->probability(5747),1.31729125976562e-05);
ok($diceobj->probability(5748),3.18444569905599e-05);
ok($diceobj->probability(5749),5.05160013834635e-05);
ok($diceobj->probability(5750),6.26010894775391e-05);
ok($diceobj->probability(5751),7.46861775716146e-05);
ok($diceobj->probability(5752),9.34032948811849e-05);
ok($diceobj->probability(5753),0.000112120412190755);
ok($diceobj->probability(5754),0.000100080897013346);
ok($diceobj->probability(5755),8.80413818359375e-05);
ok($diceobj->probability(5756),7.92950948079427e-05);
ok($diceobj->probability(5757),7.05488077799479e-05);
ok($diceobj->probability(5758),4.85384623209635e-05);
ok($diceobj->probability(5759),2.65281168619792e-05);
ok($diceobj->probability(5760),1.98960876464844e-05);
ok($diceobj->probability(5761),1.32640584309896e-05);
ok($diceobj->probability(5762),8.13100263807509e-05);
ok($diceobj->probability(5763),0.000149355994330512);
ok($diceobj->probability(5764),0.000224033991495768);
ok($diceobj->probability(5765),0.000298711988661024);
ok($diceobj->probability(5766),0.00037338998582628);
ok($diceobj->probability(5767),0.000448067982991536);
ok($diceobj->probability(5768),0.00037338998582628);
ok($diceobj->probability(5769),0.000298711988661024);
ok($diceobj->probability(5770),0.000224033991495768);
ok($diceobj->probability(5771),0.000149355994330512);
ok($diceobj->probability(5772),7.46779971652561e-05);
ok($diceobj->probability(5777),1.27286911010742e-05);
ok($diceobj->probability(5778),3.72271219889323e-05);
ok($diceobj->probability(5779),6.17255528767904e-05);
ok($diceobj->probability(5780),8.62239837646484e-05);
ok($diceobj->probability(5781),0.000110722414652507);
ok($diceobj->probability(5782),0.00014590695699056);
ok($diceobj->probability(5783),0.000155634117126465);
ok($diceobj->probability(5784),0.000141821797688802);
ok($diceobj->probability(5785),0.000128009478251139);
ok($diceobj->probability(5786),0.000114197158813477);
ok($diceobj->probability(5787),0.000100384839375814);
ok($diceobj->probability(5788),6.52002970377604e-05);
ok($diceobj->probability(5789),4.27444458007812e-05);
ok($diceobj->probability(5790),3.20583343505859e-05);
ok($diceobj->probability(5791),2.13722229003906e-05);
ok($diceobj->probability(5792),1.06861114501953e-05);
ok($diceobj->probability(5798),5.32171461317274e-05);
ok($diceobj->probability(5799),0.00010668224758572);
ok($diceobj->probability(5800),0.000160147349039714);
ok($diceobj->probability(5801),0.000213612450493707);
ok($diceobj->probability(5802),0.000268897544013129);
ok($diceobj->probability(5803),0.000324182637532552);
ok($diceobj->probability(5804),0.00027303343878852);
ok($diceobj->probability(5805),0.000221388329399957);
ok($diceobj->probability(5806),0.000169743220011393);
ok($diceobj->probability(5807),0.00011809811062283);
ok($diceobj->probability(5808),6.28130171034071e-05);
ok($diceobj->probability(5809),7.52792358398438e-06);
ok($diceobj->probability(5810),3.17481994628906e-05);
ok($diceobj->probability(5811),5.62164306640625e-05);
ok($diceobj->probability(5812),8.06846618652344e-05);
ok($diceobj->probability(5813),0.000105152893066406);
ok($diceobj->probability(5814),0.000131441116333008);
ok($diceobj->probability(5815),0.000157729339599609);
ok($diceobj->probability(5816),0.000149244986640082);
ok($diceobj->probability(5817),0.000140760633680556);
ok($diceobj->probability(5818),0.000132276280721029);
ok($diceobj->probability(5819),0.000123791927761502);
ok($diceobj->probability(5820),0.000115307574801975);
ok($diceobj->probability(5821),0.000114074198404948);
ok($diceobj->probability(5822),0.000103521304660373);
ok($diceobj->probability(5823),9.29684109157986e-05);
ok($diceobj->probability(5824),8.2415517171224e-05);
ok($diceobj->probability(5825),7.18626234266493e-05);
ok($diceobj->probability(5826),8.41873592800564e-05);
ok($diceobj->probability(5827),8.20101420084635e-05);
ok($diceobj->probability(5828),9.76367950439453e-05);
ok($diceobj->probability(5829),0.000113263448079427);
ok($diceobj->probability(5830),0.000128890101114909);
ok($diceobj->probability(5831),0.000144516754150391);
ok($diceobj->probability(5832),0.000114388147989909);
ok($diceobj->probability(5833),9.15105183919271e-05);
ok($diceobj->probability(5834),8.23334587944878e-05);
ok($diceobj->probability(5835),7.31563991970486e-05);
ok($diceobj->probability(5836),6.39793395996094e-05);
ok($diceobj->probability(5837),5.48022800021701e-05);
ok($diceobj->probability(5838),6.85028500027127e-05);
ok($diceobj->probability(5839),8.22034200032552e-05);
ok($diceobj->probability(5840),6.85028500027127e-05);
ok($diceobj->probability(5841),5.48022800021701e-05);
ok($diceobj->probability(5842),4.11017100016276e-05);
ok($diceobj->probability(5843),2.74011400010851e-05);
ok($diceobj->probability(5844),1.37005700005425e-05);
ok($diceobj->probability(5852),3.07176081339518e-05);
ok($diceobj->probability(5853),6.14352162679036e-05);
ok($diceobj->probability(5854),0.000127869834899902);
ok($diceobj->probability(5855),0.000194304453531901);
ok($diceobj->probability(5856),0.0002607390721639);
ok($diceobj->probability(5857),0.000327173690795898);
ok($diceobj->probability(5858),0.000332173093159994);
ok($diceobj->probability(5859),0.000337172495524089);
ok($diceobj->probability(5860),0.00027073787689209);
ok($diceobj->probability(5861),0.000204382201300727);
ok($diceobj->probability(5862),0.000138026525709364);
ok($diceobj->probability(5863),7.16708501180013e-05);
ok($diceobj->probability(5864),3.60327826605903e-05);
ok($diceobj->probability(5865),3.94715203179253e-07);
ok($diceobj->probability(5866),4.73658243815104e-07);
ok($diceobj->probability(5867),2.56408225165473e-05);
ok($diceobj->probability(5868),5.08079867892795e-05);
ok($diceobj->probability(5869),7.59751510620117e-05);
ok($diceobj->probability(5870),0.000101142315334744);
ok($diceobj->probability(5871),0.000126309479607476);
ok($diceobj->probability(5872),0.000151476643880208);
ok($diceobj->probability(5873),0.00012623053656684);
ok($diceobj->probability(5874),0.000100984429253472);
ok($diceobj->probability(5875),7.57383219401042e-05);
ok($diceobj->probability(5876),5.04922146267361e-05);
ok($diceobj->probability(5877),2.52461073133681e-05);
ok($diceobj->probability(5882),4.40303166707357e-05);
ok($diceobj->probability(5883),8.80606333414714e-05);
ok($diceobj->probability(5884),0.000132090950012207);
ok($diceobj->probability(5885),0.000176121266682943);
ok($diceobj->probability(5886),0.000220151583353678);
ok($diceobj->probability(5887),0.000264181900024414);
ok($diceobj->probability(5888),0.000220151583353678);
ok($diceobj->probability(5889),0.000176127942403158);
ok($diceobj->probability(5890),0.000144044558207194);
ok($diceobj->probability(5891),0.00011196117401123);
ok($diceobj->probability(5892),8.0029296875e-05);
ok($diceobj->probability(5893),4.80974197387695e-05);
ok($diceobj->probability(5894),6.01958592732747e-05);
ok($diceobj->probability(5895),7.22809473673503e-05);
ok($diceobj->probability(5896),6.04855219523112e-05);
ok($diceobj->probability(5897),4.86900965372721e-05);
ok($diceobj->probability(5898),3.65916570027669e-05);
ok($diceobj->probability(5899),2.44932174682617e-05);
ok($diceobj->probability(5900),1.23947779337565e-05);
ok($diceobj->probability(5901),3.03014119466146e-07);
ok($diceobj->probability(5902),1.51507059733073e-07);
ok($diceobj->probability(5918),3.12332577175564e-06);
ok($diceobj->probability(5919),6.24665154351129e-06);
ok($diceobj->probability(5920),9.36997731526693e-06);
ok($diceobj->probability(5921),1.24933030870226e-05);
ok($diceobj->probability(5922),1.56166288587782e-05);
ok($diceobj->probability(5923),1.87399546305339e-05);
ok($diceobj->probability(5924),1.56166288587782e-05);
ok($diceobj->probability(5925),1.24933030870226e-05);
ok($diceobj->probability(5926),9.36997731526693e-06);
ok($diceobj->probability(5927),6.24665154351129e-06);
ok($diceobj->probability(5928),3.12332577175564e-06);
ok($diceobj->probability(5930),3.65528318617079e-05);
ok($diceobj->probability(5931),7.31056637234158e-05);
ok($diceobj->probability(5932),0.000109658495585124);
ok($diceobj->probability(5933),0.000146211327446832);
ok($diceobj->probability(5934),0.00018276415930854);
ok($diceobj->probability(5935),0.000219316991170247);
ok($diceobj->probability(5936),0.00018276415930854);
ok($diceobj->probability(5937),0.000146211327446832);
ok($diceobj->probability(5938),0.000109658495585124);
ok($diceobj->probability(5939),7.31056637234158e-05);
ok($diceobj->probability(5940),3.65528318617079e-05);
ok($diceobj->probability(5942),3.85771306355794e-05);
ok($diceobj->probability(5943),7.71542612711589e-05);
ok($diceobj->probability(5944),0.000115731391906738);
ok($diceobj->probability(5945),0.000154308522542318);
ok($diceobj->probability(5946),0.000192885653177897);
ok($diceobj->probability(5947),0.000231462783813477);
ok($diceobj->probability(5948),0.000192885653177897);
ok($diceobj->probability(5949),0.000154308522542318);
ok($diceobj->probability(5950),0.000115731391906738);
ok($diceobj->probability(5951),7.71542612711589e-05);
ok($diceobj->probability(5952),5.78091812133789e-05);
ok($diceobj->probability(5953),3.8464101155599e-05);
ok($diceobj->probability(5954),5.8039050632053e-05);
ok($diceobj->probability(5955),7.76140001085069e-05);
ok($diceobj->probability(5956),9.71889495849609e-05);
ok($diceobj->probability(5957),0.000116763899061415);
ok($diceobj->probability(5958),9.787474738227e-05);
ok($diceobj->probability(5959),7.8985595703125e-05);
ok($diceobj->probability(5960),5.9410646226671e-05);
ok($diceobj->probability(5961),3.9835696750217e-05);
ok($diceobj->probability(5962),2.0260747273763e-05);
ok($diceobj->probability(5963),6.85797797309028e-07);
ok($diceobj->probability(5964),3.42898898654514e-07);
ok($diceobj->probability(5969),1.03108300103082e-05);
ok($diceobj->probability(5970),2.06216600206163e-05);
ok($diceobj->probability(5971),3.09324900309245e-05);
ok($diceobj->probability(5972),4.12433200412326e-05);
ok($diceobj->probability(5973),5.15541500515408e-05);
ok($diceobj->probability(5974),6.1864980061849e-05);
ok($diceobj->probability(5975),5.15541500515408e-05);
ok($diceobj->probability(5976),4.12433200412326e-05);
ok($diceobj->probability(5977),3.09324900309245e-05);
ok($diceobj->probability(5978),2.06216600206163e-05);
ok($diceobj->probability(5979),1.03108300103082e-05);
ok($diceobj->probability(5982),3.16669209798177e-05);
ok($diceobj->probability(5983),6.33338419596354e-05);
ok($diceobj->probability(5984),9.50007629394531e-05);
ok($diceobj->probability(5985),0.000126667683919271);
ok($diceobj->probability(5986),0.000181054941813151);
ok($diceobj->probability(5987),0.000263202260335286);
ok($diceobj->probability(5988),0.000282015736897786);
ok($diceobj->probability(5989),0.000300829213460286);
ok($diceobj->probability(5990),0.000319642690022786);
ok($diceobj->probability(5991),0.000338456166585286);
ok($diceobj->probability(5992),0.000311828969319661);
ok($diceobj->probability(5993),0.000229681650797526);
ok($diceobj->probability(5994),0.000179201253255208);
ok($diceobj->probability(5995),0.000128720855712891);
ok($diceobj->probability(5996),7.82404581705729e-05);
ok($diceobj->probability(5997),2.77600606282552e-05);
ok($diceobj->probability(6002),5.49719874064128e-05);
ok($diceobj->probability(6003),0.000109943974812826);
ok($diceobj->probability(6004),0.000164915962219238);
ok($diceobj->probability(6005),0.000220526021321615);
ok($diceobj->probability(6006),0.000276136080423991);
ok($diceobj->probability(6007),0.000331746139526367);
ok($diceobj->probability(6008),0.000315493392944336);
ok($diceobj->probability(6009),0.000299240646362305);
ok($diceobj->probability(6010),0.000282987899780273);
ok($diceobj->probability(6011),0.000265459009806315);
ok($diceobj->probability(6012),0.000247930119832357);
ok($diceobj->probability(6013),0.000230401229858398);
ok($diceobj->probability(6014),0.000191681989034017);
ok($diceobj->probability(6015),0.000152962748209635);
ok($diceobj->probability(6016),0.000114243507385254);
ok($diceobj->probability(6017),7.61623382568359e-05);
ok($diceobj->probability(6018),3.8081169128418e-05);
ok($diceobj->probability(6034),3.64774068196615e-06);
ok($diceobj->probability(6035),7.29548136393229e-06);
ok($diceobj->probability(6036),1.09432220458984e-05);
ok($diceobj->probability(6037),1.45909627278646e-05);
ok($diceobj->probability(6038),1.82387034098307e-05);
ok($diceobj->probability(6039),2.18864440917969e-05);
ok($diceobj->probability(6040),1.82387034098307e-05);
ok($diceobj->probability(6041),1.45909627278646e-05);
ok($diceobj->probability(6042),1.09432220458984e-05);
ok($diceobj->probability(6043),7.29548136393229e-06);
ok($diceobj->probability(6044),3.64774068196615e-06);
ok($diceobj->probability(6047),3.74645657009549e-07);
ok($diceobj->probability(6048),7.49291314019097e-07);
ok($diceobj->probability(6049),1.12393697102865e-06);
ok($diceobj->probability(6050),8.19739659627279e-05);
ok($diceobj->probability(6051),0.000162823994954427);
ok($diceobj->probability(6052),0.000254442342122396);
ok($diceobj->probability(6053),0.000345311397976346);
ok($diceobj->probability(6054),0.000436180453830295);
ok($diceobj->probability(6055),0.000527049509684245);
ok($diceobj->probability(6056),0.000456967798868815);
ok($diceobj->probability(6057),0.000386886088053385);
ok($diceobj->probability(6058),0.000295267740885417);
ok($diceobj->probability(6059),0.000204024039374457);
ok($diceobj->probability(6060),0.000112780337863498);
ok($diceobj->probability(6061),2.15366363525391e-05);
ok($diceobj->probability(6062),1.07683181762695e-05);
ok($diceobj->probability(6063),2.34928131103516e-06);
ok($diceobj->probability(6064),4.69856262207031e-06);
ok($diceobj->probability(6065),7.04784393310547e-06);
ok($diceobj->probability(6066),9.39712524414063e-06);
ok($diceobj->probability(6067),1.17464065551758e-05);
ok($diceobj->probability(6068),1.40956878662109e-05);
ok($diceobj->probability(6069),1.17464065551758e-05);
ok($diceobj->probability(6070),9.39712524414063e-06);
ok($diceobj->probability(6071),1.64709938897027e-05);
ok($diceobj->probability(6072),2.35448625352648e-05);
ok($diceobj->probability(6073),3.06187311808268e-05);
ok($diceobj->probability(6074),6.94629245334201e-05);
ok($diceobj->probability(6075),0.000110656399197049);
ok($diceobj->probability(6076),0.000151849873860677);
ok($diceobj->probability(6077),0.000180700293646918);
ok($diceobj->probability(6078),0.000209750031365289);
ok($diceobj->probability(6079),0.000238799769083659);
ok($diceobj->probability(6080),0.000204308857387967);
ok($diceobj->probability(6081),0.000169817945692274);
ok($diceobj->probability(6082),0.00015621940612793);
ok($diceobj->probability(6083),0.000139037526448568);
ok($diceobj->probability(6084),0.000121457010904948);
ok($diceobj->probability(6085),0.000103876495361328);
ok($diceobj->probability(6086),0.000132898801167806);
ok($diceobj->probability(6087),0.000161921106974284);
ok($diceobj->probability(6088),0.000149158668518066);
ok($diceobj->probability(6089),0.000142899475097656);
ok($diceobj->probability(6090),0.000136839599609375);
ok($diceobj->probability(6091),0.000130779724121094);
ok($diceobj->probability(6092),0.000100146208869086);
ok($diceobj->probability(6093),6.9512693617079e-05);
ok($diceobj->probability(6094),5.97715504964193e-05);
ok($diceobj->probability(6095),5.00304073757596e-05);
ok($diceobj->probability(6096),4.02892642550998e-05);
ok($diceobj->probability(6097),3.05481211344401e-05);
ok($diceobj->probability(6098),2.54567676120334e-05);
ok($diceobj->probability(6099),2.03654140896267e-05);
ok($diceobj->probability(6100),1.52740605672201e-05);
ok($diceobj->probability(6101),1.01827070448134e-05);
ok($diceobj->probability(6102),5.09135352240668e-06);
ok($diceobj->probability(6120),2.57634480794271e-05);
ok($diceobj->probability(6121),5.15268961588542e-05);
ok($diceobj->probability(6122),0.000114203724331326);
ok($diceobj->probability(6123),0.000176880552503798);
ok($diceobj->probability(6124),0.00023955738067627);
ok($diceobj->probability(6125),0.000302234208848741);
ok($diceobj->probability(6126),0.000313384140862359);
ok($diceobj->probability(6127),0.000324534072875977);
ok($diceobj->probability(6128),0.000261857244703505);
ok($diceobj->probability(6129),0.000199180416531033);
ok($diceobj->probability(6130),0.000136503588358561);
ok($diceobj->probability(6131),7.38267601860894e-05);
ok($diceobj->probability(6132),3.69133800930447e-05);
ok($diceobj->probability(6139),7.11377461751302e-06);
ok($diceobj->probability(6140),1.45126978556315e-05);
ok($diceobj->probability(6141),2.191162109375e-05);
ok($diceobj->probability(6142),2.93105443318685e-05);
ok($diceobj->probability(6143),3.6709467569987e-05);
ok($diceobj->probability(6144),4.41083908081055e-05);
ok($diceobj->probability(6145),3.72797648111979e-05);
ok($diceobj->probability(6146),3.9526006910536e-05);
ok($diceobj->probability(6147),4.17722490098741e-05);
ok($diceobj->probability(6148),4.40184911092122e-05);
ok($diceobj->probability(6149),4.62647332085503e-05);
ok($diceobj->probability(6150),4.85109753078885e-05);
ok($diceobj->probability(6151),5.78709920247396e-05);
ok($diceobj->probability(6152),4.8225826687283e-05);
ok($diceobj->probability(6153),3.85806613498264e-05);
ok($diceobj->probability(6154),2.89354960123698e-05);
ok($diceobj->probability(6155),1.92903306749132e-05);
ok($diceobj->probability(6156),9.6451653374566e-06);
ok($diceobj->probability(6158),1.44328223334418e-05);
ok($diceobj->probability(6159),2.88656446668837e-05);
ok($diceobj->probability(6160),4.32984670003255e-05);
ok($diceobj->probability(6161),5.77312893337674e-05);
ok($diceobj->probability(6162),0.000107062678866916);
ok($diceobj->probability(6163),0.000156394068400065);
ok($diceobj->probability(6164),0.00017685981326633);
ok($diceobj->probability(6165),0.000197325558132595);
ok($diceobj->probability(6166),0.000217791302998861);
ok($diceobj->probability(6167),0.000238257047865126);
ok($diceobj->probability(6168),0.000188925658331977);
ok($diceobj->probability(6169),0.000139594268798828);
ok($diceobj->probability(6170),0.000104695701599121);
ok($diceobj->probability(6171),6.97971343994141e-05);
ok($diceobj->probability(6172),3.4898567199707e-05);
ok($diceobj->probability(6176),1.47914886474609e-05);
ok($diceobj->probability(6177),4.76336161295573e-05);
ok($diceobj->probability(6178),8.04757436116536e-05);
ok($diceobj->probability(6179),0.00011331787109375);
ok($diceobj->probability(6180),0.000146159998575846);
ok($diceobj->probability(6181),0.000179002126057943);
ok($diceobj->probability(6182),0.000182261276245117);
ok($diceobj->probability(6183),0.000149419148763021);
ok($diceobj->probability(6184),0.000116577021280924);
ok($diceobj->probability(6185),8.37348937988281e-05);
ok($diceobj->probability(6186),5.08927663167318e-05);
ok($diceobj->probability(6187),1.80506388346354e-05);
ok($diceobj->probability(6190),2.01749165852865e-05);
ok($diceobj->probability(6191),4.03498331705729e-05);
ok($diceobj->probability(6192),6.05247497558594e-05);
ok($diceobj->probability(6193),8.06996663411458e-05);
ok($diceobj->probability(6194),0.000100874582926432);
ok($diceobj->probability(6195),0.000121049499511719);
ok($diceobj->probability(6196),0.000100874582926432);
ok($diceobj->probability(6197),8.06996663411458e-05);
ok($diceobj->probability(6198),6.05247497558594e-05);
ok($diceobj->probability(6199),4.03498331705729e-05);
ok($diceobj->probability(6200),2.01749165852865e-05);
ok($diceobj->probability(6202),1.51189168294271e-07);
ok($diceobj->probability(6203),3.02378336588542e-07);
ok($diceobj->probability(6204),4.53567504882813e-07);
ok($diceobj->probability(6205),6.04756673177083e-07);
ok($diceobj->probability(6206),7.55945841471354e-07);
ok($diceobj->probability(6207),9.07135009765625e-07);
ok($diceobj->probability(6208),7.55945841471354e-07);
ok($diceobj->probability(6209),6.04756673177083e-07);
ok($diceobj->probability(6210),4.53567504882813e-07);
ok($diceobj->probability(6211),3.02378336588542e-07);
ok($diceobj->probability(6212),2.54873911539714e-05);
ok($diceobj->probability(6213),5.06724039713542e-05);
ok($diceobj->probability(6214),7.60086059570313e-05);
ok($diceobj->probability(6215),0.000101344807942708);
ok($diceobj->probability(6216),0.000126681009928385);
ok($diceobj->probability(6217),0.000152017211914063);
ok($diceobj->probability(6218),0.000126681009928385);
ok($diceobj->probability(6219),0.000101344807942708);
ok($diceobj->probability(6220),7.60086059570313e-05);
ok($diceobj->probability(6221),5.06724039713542e-05);
ok($diceobj->probability(6222),2.53362019856771e-05);
ok($diceobj->probability(6239),6.18267059326172e-06);
ok($diceobj->probability(6240),1.23653411865234e-05);
ok($diceobj->probability(6241),1.85480117797852e-05);
ok($diceobj->probability(6242),7.68570412529839e-05);
ok($diceobj->probability(6243),0.000135166070726183);
ok($diceobj->probability(6244),0.000193475100199382);
ok($diceobj->probability(6245),0.000239418788486057);
ok($diceobj->probability(6246),0.000285362476772732);
ok($diceobj->probability(6247),0.000331306165059408);
ok($diceobj->probability(6248),0.000272997135586209);
ok($diceobj->probability(6249),0.00021468810611301);
ok($diceobj->probability(6250),0.000156379076639811);
ok($diceobj->probability(6251),0.000104252717759874);
ok($diceobj->probability(6252),5.41491021050347e-05);
ok($diceobj->probability(6253),4.04548645019531e-06);
ok($diceobj->probability(6254),6.06822967529297e-06);
ok($diceobj->probability(6255),8.09097290039062e-06);
ok($diceobj->probability(6256),1.01137161254883e-05);
ok($diceobj->probability(6257),1.21364593505859e-05);
ok($diceobj->probability(6258),2.89115269978841e-05);
ok($diceobj->probability(6259),4.56865946451823e-05);
ok($diceobj->probability(6260),6.24616622924805e-05);
ok($diceobj->probability(6261),7.92367299397786e-05);
ok($diceobj->probability(6262),9.60117975870768e-05);
ok($diceobj->probability(6263),0.000112786865234375);
ok($diceobj->probability(6264),9.39890543619792e-05);
ok($diceobj->probability(6265),7.51912434895833e-05);
ok($diceobj->probability(6266),5.99070231119792e-05);
ok($diceobj->probability(6267),4.4622802734375e-05);
ok($diceobj->probability(6268),2.93385823567708e-05);
ok($diceobj->probability(6269),1.40543619791667e-05);
ok($diceobj->probability(6270),1.75679524739583e-05);
ok($diceobj->probability(6271),2.108154296875e-05);
ok($diceobj->probability(6272),4.21142196655273e-05);
ok($diceobj->probability(6273),6.31468963623047e-05);
ok($diceobj->probability(6274),9.06235504150391e-05);
ok($diceobj->probability(6275),0.000118100204467773);
ok($diceobj->probability(6276),0.000145576858520508);
ok($diceobj->probability(6277),0.000173053512573242);
ok($diceobj->probability(6278),0.00015495122273763);
ok($diceobj->probability(6279),0.000136848932902018);
ok($diceobj->probability(6280),0.000105858688354492);
ok($diceobj->probability(6281),9.87035200330946e-05);
ok($diceobj->probability(6282),9.15483517116971e-05);
ok($diceobj->probability(6283),8.43931833902995e-05);
ok($diceobj->probability(6284),0.000101784282260471);
ok($diceobj->probability(6285),0.000119175381130642);
ok($diceobj->probability(6286),0.000143010457356771);
ok($diceobj->probability(6287),0.000119175381130642);
ok($diceobj->probability(6288),9.53403049045139e-05);
ok($diceobj->probability(6289),7.15052286783854e-05);
ok($diceobj->probability(6290),4.76701524522569e-05);
ok($diceobj->probability(6291),2.38350762261285e-05);
ok($diceobj->probability(6294),2.00414657592773e-05);
ok($diceobj->probability(6295),4.00838851928711e-05);
ok($diceobj->probability(6296),6.01263046264648e-05);
ok($diceobj->probability(6297),8.01687240600586e-05);
ok($diceobj->probability(6298),0.000100211143493652);
ok($diceobj->probability(6299),0.000120253562927246);
ok($diceobj->probability(6300),0.000100213050842285);
ok($diceobj->probability(6301),8.01706314086914e-05);
ok($diceobj->probability(6302),0.000123012212117513);
ok($diceobj->probability(6303),0.000165853792826335);
ok($diceobj->probability(6304),0.000208695373535156);
ok($diceobj->probability(6305),0.000251536954243978);
ok($diceobj->probability(6306),0.000314420000712077);
ok($diceobj->probability(6307),0.000377304000854492);
ok($diceobj->probability(6308),0.000314420000712077);
ok($diceobj->probability(6309),0.000251536000569661);
ok($diceobj->probability(6310),0.000188652000427246);
ok($diceobj->probability(6311),0.000125768000284831);
ok($diceobj->probability(6312),6.28840001424154e-05);
ok($diceobj->probability(6320),1.03990130954319e-05);
ok($diceobj->probability(6321),2.07980261908637e-05);
ok($diceobj->probability(6322),3.11970392862956e-05);
ok($diceobj->probability(6323),4.15960523817274e-05);
ok($diceobj->probability(6324),5.19950654771593e-05);
ok($diceobj->probability(6325),6.23940785725911e-05);
ok($diceobj->probability(6326),5.22822274102105e-05);
ok($diceobj->probability(6327),5.10349697536892e-05);
ok($diceobj->probability(6328),4.9787712097168e-05);
ok($diceobj->probability(6329),4.85404544406467e-05);
ok($diceobj->probability(6330),4.72931967841254e-05);
ok($diceobj->probability(6331),4.60459391276042e-05);
ok($diceobj->probability(6332),5.46233707004123e-05);
ok($diceobj->probability(6333),4.54716152615017e-05);
ok($diceobj->probability(6334),3.63198598225911e-05);
ok($diceobj->probability(6335),2.71681043836806e-05);
ok($diceobj->probability(6336),1.801634894477e-05);
ok($diceobj->probability(6337),8.86459350585937e-06);
ok($diceobj->probability(6338),3.91164779663086e-05);
ok($diceobj->probability(6339),7.82329559326172e-05);
ok($diceobj->probability(6340),0.000117349433898926);
ok($diceobj->probability(6341),0.000156465911865234);
ok($diceobj->probability(6342),0.000195582389831543);
ok($diceobj->probability(6343),0.000234698867797852);
ok($diceobj->probability(6344),0.000195582389831543);
ok($diceobj->probability(6345),0.000156465911865234);
ok($diceobj->probability(6346),0.000117349433898926);
ok($diceobj->probability(6347),7.82329559326172e-05);
ok($diceobj->probability(6348),3.91164779663086e-05);
ok($diceobj->probability(6350),8.3251953125e-06);
ok($diceobj->probability(6351),1.6650390625e-05);
ok($diceobj->probability(6352),2.49755859375e-05);
ok($diceobj->probability(6353),3.330078125e-05);
ok($diceobj->probability(6354),4.16259765625e-05);
ok($diceobj->probability(6355),4.9951171875e-05);
ok($diceobj->probability(6356),4.16259765625e-05);
ok($diceobj->probability(6357),3.330078125e-05);
ok($diceobj->probability(6358),2.49755859375e-05);
ok($diceobj->probability(6359),1.6650390625e-05);
ok($diceobj->probability(6360),1.63627624511719e-05);
ok($diceobj->probability(6361),1.60751342773438e-05);
ok($diceobj->probability(6362),2.41127014160156e-05);
ok($diceobj->probability(6363),3.21502685546875e-05);
ok($diceobj->probability(6364),4.01878356933594e-05);
ok($diceobj->probability(6365),4.82254028320312e-05);
ok($diceobj->probability(6366),4.01878356933594e-05);
ok($diceobj->probability(6367),3.21502685546875e-05);
ok($diceobj->probability(6368),2.41127014160156e-05);
ok($diceobj->probability(6369),1.60751342773438e-05);
ok($diceobj->probability(6370),8.03756713867188e-06);
ok($diceobj->probability(6377),1.55713144938151e-05);
ok($diceobj->probability(6378),3.11426289876302e-05);
ok($diceobj->probability(6379),4.67139434814453e-05);
ok($diceobj->probability(6380),6.22852579752604e-05);
ok($diceobj->probability(6381),7.78565724690755e-05);
ok($diceobj->probability(6382),9.67866516113281e-05);
ok($diceobj->probability(6383),8.45741017659505e-05);
ok($diceobj->probability(6384),7.23615519205729e-05);
ok($diceobj->probability(6385),6.01490020751953e-05);
ok($diceobj->probability(6386),9.22033860948351e-05);
ok($diceobj->probability(6387),0.000124257770114475);
ok($diceobj->probability(6388),0.00014959462483724);
ok($diceobj->probability(6389),0.000190502794053819);
ok($diceobj->probability(6390),0.000231410963270399);
ok($diceobj->probability(6391),0.000272319132486979);
ok($diceobj->probability(6392),0.000224693433973524);
ok($diceobj->probability(6393),0.000177067735460069);
ok($diceobj->probability(6394),0.000132800801595052);
ok($diceobj->probability(6395),8.85338677300347e-05);
ok($diceobj->probability(6396),4.42669338650174e-05);
ok($diceobj->probability(6402),1.66089757283529e-05);
ok($diceobj->probability(6403),3.32179514567057e-05);
ok($diceobj->probability(6404),4.98269271850586e-05);
ok($diceobj->probability(6405),6.64359029134115e-05);
ok($diceobj->probability(6406),8.30448786417643e-05);
ok($diceobj->probability(6407),9.96538543701172e-05);
ok($diceobj->probability(6408),8.30448786417643e-05);
ok($diceobj->probability(6409),6.64359029134115e-05);
ok($diceobj->probability(6410),4.98269271850586e-05);
ok($diceobj->probability(6411),3.64108530680339e-05);
ok($diceobj->probability(6412),2.29947789510091e-05);
ok($diceobj->probability(6413),9.57870483398438e-06);
ok($diceobj->probability(6414),1.27716064453125e-05);
ok($diceobj->probability(6415),1.59645080566406e-05);
ok($diceobj->probability(6416),1.91574096679688e-05);
ok($diceobj->probability(6417),1.59645080566406e-05);
ok($diceobj->probability(6418),1.27716064453125e-05);
ok($diceobj->probability(6419),9.6282958984375e-06);
ok($diceobj->probability(6420),6.4849853515625e-06);
ok($diceobj->probability(6421),3.3416748046875e-06);
ok($diceobj->probability(6422),1.983642578125e-07);
ok($diceobj->probability(6423),2.47955322265625e-07);
ok($diceobj->probability(6424),1.3390858968099e-05);
ok($diceobj->probability(6425),2.6434580485026e-05);
ok($diceobj->probability(6426),3.94783020019531e-05);
ok($diceobj->probability(6427),5.25220235188802e-05);
ok($diceobj->probability(6428),8.84468926323785e-05);
ok($diceobj->probability(6429),0.000124371761745877);
ok($diceobj->probability(6430),0.000134110005696615);
ok($diceobj->probability(6431),0.000143897840711806);
ok($diceobj->probability(6432),0.000153685675726997);
ok($diceobj->probability(6433),0.000163473510742188);
ok($diceobj->probability(6434),0.000127499050564236);
ok($diceobj->probability(6435),9.15245903862847e-05);
ok($diceobj->probability(6436),6.86434427897135e-05);
ok($diceobj->probability(6437),4.57622951931424e-05);
ok($diceobj->probability(6438),2.28811475965712e-05);
ok($diceobj->probability(6442),2.53706359863281e-05);
ok($diceobj->probability(6443),5.07412719726563e-05);
ok($diceobj->probability(6444),7.61119079589844e-05);
ok($diceobj->probability(6445),0.000101482543945313);
ok($diceobj->probability(6446),0.000126853179931641);
ok($diceobj->probability(6447),0.000152223815917969);
ok($diceobj->probability(6448),0.000126853179931641);
ok($diceobj->probability(6449),0.000101482543945313);
ok($diceobj->probability(6450),7.6456184387207e-05);
ok($diceobj->probability(6451),5.14298248291016e-05);
ok($diceobj->probability(6452),2.64034652709961e-05);
ok($diceobj->probability(6453),1.37710571289062e-06);
ok($diceobj->probability(6454),1.72138214111328e-06);
ok($diceobj->probability(6455),2.06565856933594e-06);
ok($diceobj->probability(6456),1.72138214111328e-06);
ok($diceobj->probability(6457),1.37710571289062e-06);
ok($diceobj->probability(6458),1.03282928466797e-06);
ok($diceobj->probability(6459),6.88552856445312e-07);
ok($diceobj->probability(6460),3.44276428222656e-07);
ok($diceobj->probability(6462),1.21141052246094e-05);
ok($diceobj->probability(6463),2.42282104492188e-05);
ok($diceobj->probability(6464),3.63423156738281e-05);
ok($diceobj->probability(6465),4.84564208984375e-05);
ok($diceobj->probability(6466),6.05705261230469e-05);
ok($diceobj->probability(6467),7.26846313476563e-05);
ok($diceobj->probability(6468),6.05705261230469e-05);
ok($diceobj->probability(6469),4.84564208984375e-05);
ok($diceobj->probability(6470),6.51957321166992e-05);
ok($diceobj->probability(6471),8.19350433349609e-05);
ok($diceobj->probability(6472),9.86743545532227e-05);
ok($diceobj->probability(6473),0.000115413665771484);
ok($diceobj->probability(6474),0.000144267082214355);
ok($diceobj->probability(6475),0.000173120498657227);
ok($diceobj->probability(6476),0.000144267082214355);
ok($diceobj->probability(6477),0.000115413665771484);
ok($diceobj->probability(6478),8.65602493286133e-05);
ok($diceobj->probability(6479),5.77068328857422e-05);
ok($diceobj->probability(6480),2.88534164428711e-05);
ok($diceobj->probability(6481),2.02178955078125e-07);
ok($diceobj->probability(6482),4.35262891981337e-05);
ok($diceobj->probability(6483),8.68503994411892e-05);
ok($diceobj->probability(6484),0.000130174509684245);
ok($diceobj->probability(6485),0.0001734986199273);
ok($diceobj->probability(6486),0.000216822730170356);
ok($diceobj->probability(6487),0.000259742482503255);
ok($diceobj->probability(6488),0.0002164183722602);
ok($diceobj->probability(6489),0.000173094262017144);
ok($diceobj->probability(6490),0.000129770151774089);
ok($diceobj->probability(6491),8.6446041531033e-05);
ok($diceobj->probability(6492),4.31219312879774e-05);
ok($diceobj->probability(6498),3.32628885904948e-06);
ok($diceobj->probability(6499),6.65257771809896e-06);
ok($diceobj->probability(6500),1.39580620659722e-05);
ok($diceobj->probability(6501),2.12635464138455e-05);
ok($diceobj->probability(6502),4.79869333902995e-05);
ok($diceobj->probability(6503),7.47103203667535e-05);
ok($diceobj->probability(6504),9.47811296251085e-05);
ok($diceobj->probability(6505),0.000114851938883464);
ok($diceobj->probability(6506),0.000126964357164171);
ok($diceobj->probability(6507),0.000139076775444878);
ok($diceobj->probability(6508),0.000112353388468424);
ok($diceobj->probability(6509),8.56300014919705e-05);
ok($diceobj->probability(6510),6.2232903374566e-05);
ok($diceobj->probability(6511),3.88358052571615e-05);
ok($diceobj->probability(6512),1.98924933539497e-05);
ok($diceobj->probability(6513),9.49181450737847e-07);
ok($diceobj->probability(6514),1.42377217610677e-06);
ok($diceobj->probability(6515),1.89836290147569e-06);
ok($diceobj->probability(6516),2.37295362684462e-06);
ok($diceobj->probability(6517),2.84754435221354e-06);
ok($diceobj->probability(6518),2.37295362684462e-06);
ok($diceobj->probability(6519),1.89836290147569e-06);
ok($diceobj->probability(6520),1.42377217610677e-06);
ok($diceobj->probability(6521),9.49181450737847e-07);
ok($diceobj->probability(6522),4.74590725368924e-07);
ok($diceobj->probability(6527),2.01393551296658e-06);
ok($diceobj->probability(6528),4.02787102593316e-06);
ok($diceobj->probability(6529),6.04180653889974e-06);
ok($diceobj->probability(6530),2.31858062744141e-05);
ok($diceobj->probability(6531),4.03298060099284e-05);
ok($diceobj->probability(6532),5.74738057454427e-05);
ok($diceobj->probability(6533),7.05899344550239e-05);
ok($diceobj->probability(6534),8.3706063164605e-05);
ok($diceobj->probability(6535),9.68221918741862e-05);
ok($diceobj->probability(6536),8.49052810668945e-05);
ok($diceobj->probability(6537),7.29883702596029e-05);
ok($diceobj->probability(6538),6.10714594523112e-05);
ok($diceobj->probability(6539),5.11684841579861e-05);
ok($diceobj->probability(6540),4.1265508863661e-05);
ok($diceobj->probability(6541),3.13625335693359e-05);
ok($diceobj->probability(6542),2.61354446411133e-05);
ok($diceobj->probability(6543),2.09083557128906e-05);
ok($diceobj->probability(6544),1.5681266784668e-05);
ok($diceobj->probability(6545),1.04541778564453e-05);
ok($diceobj->probability(6546),5.22708892822266e-06);
ok($diceobj->probability(6554),4.8477300008138e-05);
ok($diceobj->probability(6555),9.6954600016276e-05);
ok($diceobj->probability(6556),0.000145431900024414);
ok($diceobj->probability(6557),0.000213458489312066);
ok($diceobj->probability(6558),0.000281485078599718);
ok($diceobj->probability(6559),0.00034951166788737);
ok($diceobj->probability(6560),0.000320583657158746);
ok($diceobj->probability(6561),0.000291655646430122);
ok($diceobj->probability(6562),0.000262727635701497);
ok($diceobj->probability(6563),0.000195006857977973);
ok($diceobj->probability(6564),0.000127286080254449);
ok($diceobj->probability(6565),5.95653025309245e-05);
ok($diceobj->probability(6566),4.03218248155382e-05);
ok($diceobj->probability(6567),2.10783471001519e-05);
ok($diceobj->probability(6568),1.83486938476562e-06);
ok($diceobj->probability(6569),1.52905782063802e-06);
ok($diceobj->probability(6570),1.22324625651042e-06);
ok($diceobj->probability(6571),9.17434692382812e-07);
ok($diceobj->probability(6572),6.11623128255208e-07);
ok($diceobj->probability(6573),3.05811564127604e-07);
ok($diceobj->probability(6580),2.66181945800781e-05);
ok($diceobj->probability(6581),5.32363891601563e-05);
ok($diceobj->probability(6582),7.98545837402344e-05);
ok($diceobj->probability(6583),0.000106472778320313);
ok($diceobj->probability(6584),0.000133090972900391);
ok($diceobj->probability(6585),0.000159709167480469);
ok($diceobj->probability(6586),0.000133090972900391);
ok($diceobj->probability(6587),0.000106472778320313);
ok($diceobj->probability(6588),7.98545837402344e-05);
ok($diceobj->probability(6589),5.32363891601563e-05);
ok($diceobj->probability(6590),2.66181945800781e-05);
ok($diceobj->probability(6602),4.20082219441732e-05);
ok($diceobj->probability(6603),8.40164438883464e-05);
ok($diceobj->probability(6604),0.00012602466583252);
ok($diceobj->probability(6605),0.000168032887776693);
ok($diceobj->probability(6606),0.000210041109720866);
ok($diceobj->probability(6607),0.000252049331665039);
ok($diceobj->probability(6608),0.000210041109720866);
ok($diceobj->probability(6609),0.000168032887776693);
ok($diceobj->probability(6610),0.00012602466583252);
ok($diceobj->probability(6611),8.40164438883464e-05);
ok($diceobj->probability(6612),4.20082219441732e-05);
ok($diceobj->probability(6614),2.70205603705512e-06);
ok($diceobj->probability(6615),5.40411207411024e-06);
ok($diceobj->probability(6616),8.10616811116536e-06);
ok($diceobj->probability(6617),2.18744489881727e-05);
ok($diceobj->probability(6618),3.56427298651801e-05);
ok($diceobj->probability(6619),4.94110107421875e-05);
ok($diceobj->probability(6620),5.77751795450846e-05);
ok($diceobj->probability(6621),6.61393483479818e-05);
ok($diceobj->probability(6622),7.45035171508789e-05);
ok($diceobj->probability(6623),6.07352362738715e-05);
ok($diceobj->probability(6624),4.69669553968642e-05);
ok($diceobj->probability(6625),3.31986745198568e-05);
ok($diceobj->probability(6626),5.05986531575521e-05);
ok($diceobj->probability(6627),6.79986317952474e-05);
ok($diceobj->probability(6628),8.53986104329427e-05);
ok($diceobj->probability(6629),0.00011386481391059);
ok($diceobj->probability(6630),0.000142331017388238);
ok($diceobj->probability(6631),0.000170797220865885);
ok($diceobj->probability(6632),0.000154897096421983);
ok($diceobj->probability(6633),0.000138996971978082);
ok($diceobj->probability(6634),0.00012309684753418);
ok($diceobj->probability(6635),0.000107196723090278);
ok($diceobj->probability(6636),9.12965986463759e-05);
ok($diceobj->probability(6637),7.5396474202474e-05);
ok($diceobj->probability(6638),6.28303951687283e-05);
ok($diceobj->probability(6639),5.02643161349826e-05);
ok($diceobj->probability(6640),3.7698237101237e-05);
ok($diceobj->probability(6641),2.51321580674913e-05);
ok($diceobj->probability(6642),1.25660790337457e-05);
ok($diceobj->probability(6649),6.66147867838542e-06);
ok($diceobj->probability(6650),1.33229573567708e-05);
ok($diceobj->probability(6651),1.99844360351563e-05);
ok($diceobj->probability(6652),4.24798329671224e-05);
ok($diceobj->probability(6653),6.49752298990885e-05);
ok($diceobj->probability(6654),8.74706268310547e-05);
ok($diceobj->probability(6655),9.664306640625e-05);
ok($diceobj->probability(6656),0.000105815505981445);
ok($diceobj->probability(6657),0.000114987945556641);
ok($diceobj->probability(6658),9.79131062825521e-05);
ok($diceobj->probability(6659),8.08382670084635e-05);
ok($diceobj->probability(6660),6.3763427734375e-05);
ok($diceobj->probability(6661),5.33500671386719e-05);
ok($diceobj->probability(6662),4.29367065429687e-05);
ok($diceobj->probability(6663),3.25233459472656e-05);
ok($diceobj->probability(6664),2.7102788289388e-05);
ok($diceobj->probability(6665),2.16822306315104e-05);
ok($diceobj->probability(6666),2.19008127848307e-05);
ok($diceobj->probability(6667),2.2119394938151e-05);
ok($diceobj->probability(6668),2.23379770914714e-05);
ok($diceobj->probability(6669),2.25565592447917e-05);
ok($diceobj->probability(6670),2.81956990559896e-05);
ok($diceobj->probability(6671),4.26103803846571e-05);
ok($diceobj->probability(6672),4.67382473415799e-05);
ok($diceobj->probability(6673),5.08661142985026e-05);
ok($diceobj->probability(6674),5.49939812554254e-05);
ok($diceobj->probability(6675),5.91218482123481e-05);
ok($diceobj->probability(6676),6.32497151692708e-05);
ok($diceobj->probability(6677),4.98264990912543e-05);
ok($diceobj->probability(6678),4.00594923231337e-05);
ok($diceobj->probability(6679),3.0292485555013e-05);
ok($diceobj->probability(6680),2.05254787868924e-05);
ok($diceobj->probability(6681),1.07584720187717e-05);
ok($diceobj->probability(6682),9.91465250651042e-07);
ok($diceobj->probability(6690),1.56867980957031e-05);
ok($diceobj->probability(6691),3.13735961914062e-05);
ok($diceobj->probability(6692),4.70603942871094e-05);
ok($diceobj->probability(6693),6.27471923828125e-05);
ok($diceobj->probability(6694),7.84339904785156e-05);
ok($diceobj->probability(6695),9.41207885742188e-05);
ok($diceobj->probability(6696),7.84339904785156e-05);
ok($diceobj->probability(6697),6.27471923828125e-05);
ok($diceobj->probability(6698),4.73636627197266e-05);
ok($diceobj->probability(6699),3.19801330566406e-05);
ok($diceobj->probability(6700),1.65966033935547e-05);
ok($diceobj->probability(6701),3.12137603759766e-06);
ok($diceobj->probability(6702),5.33294677734375e-06);
ok($diceobj->probability(6703),7.54451751708984e-06);
ok($diceobj->probability(6704),9.14955139160156e-06);
ok($diceobj->probability(6705),1.07545852661133e-05);
ok($diceobj->probability(6706),1.2359619140625e-05);
ok($diceobj->probability(6707),1.01480484008789e-05);
ok($diceobj->probability(6708),7.93647766113281e-06);
ok($diceobj->probability(6709),5.72490692138672e-06);
ok($diceobj->probability(6710),3.81660461425781e-06);
ok($diceobj->probability(6711),1.90830230712891e-06);
ok($diceobj->probability(6722),4.81151623196072e-05);
ok($diceobj->probability(6723),9.62303246392144e-05);
ok($diceobj->probability(6724),0.000144345486958822);
ok($diceobj->probability(6725),0.000192460649278429);
ok($diceobj->probability(6726),0.000240575811598036);
ok($diceobj->probability(6727),0.000288690973917643);
ok($diceobj->probability(6728),0.000240575811598036);
ok($diceobj->probability(6729),0.000192460649278429);
ok($diceobj->probability(6730),0.000144361063639323);
ok($diceobj->probability(6731),9.6261478000217e-05);
ok($diceobj->probability(6732),4.81618923611111e-05);
ok($diceobj->probability(6733),6.23067220052083e-08);
ok($diceobj->probability(6734),1.15975062052409e-05);
ok($diceobj->probability(6735),2.31327056884766e-05);
ok($diceobj->probability(6736),3.46367518107096e-05);
ok($diceobj->probability(6737),4.61407979329427e-05);
ok($diceobj->probability(6738),5.76448440551758e-05);
ok($diceobj->probability(6739),6.91488901774089e-05);
ok($diceobj->probability(6740),5.76136906941732e-05);
ok($diceobj->probability(6741),4.60784912109375e-05);
ok($diceobj->probability(6742),3.45588684082031e-05);
ok($diceobj->probability(6743),2.30392456054688e-05);
ok($diceobj->probability(6744),1.15196228027344e-05);
ok($diceobj->probability(6752),1.62209320068359e-05);
ok($diceobj->probability(6753),3.24418640136719e-05);
ok($diceobj->probability(6754),4.86627960205078e-05);
ok($diceobj->probability(6755),6.48837280273438e-05);
ok($diceobj->probability(6756),8.11046600341797e-05);
ok($diceobj->probability(6757),9.73255920410156e-05);
ok($diceobj->probability(6758),8.11046600341797e-05);
ok($diceobj->probability(6759),6.48837280273438e-05);
ok($diceobj->probability(6760),4.86627960205078e-05);
ok($diceobj->probability(6761),3.24418640136719e-05);
ok($diceobj->probability(6762),2.92373784383138e-05);
ok($diceobj->probability(6763),2.60328928629557e-05);
ok($diceobj->probability(6764),5.98089218139648e-05);
ok($diceobj->probability(6765),9.3584950764974e-05);
ok($diceobj->probability(6766),0.000127360979715983);
ok($diceobj->probability(6767),0.000161137008666992);
ok($diceobj->probability(6768),0.000168880144755046);
ok($diceobj->probability(6769),0.000176623280843099);
ok($diceobj->probability(6770),0.00014284725189209);
ok($diceobj->probability(6771),0.000109071222941081);
ok($diceobj->probability(6772),7.52951939900716e-05);
ok($diceobj->probability(6773),4.15191650390625e-05);
ok($diceobj->probability(6774),2.07595825195313e-05);
ok($diceobj->probability(6778),1.38067245483398e-05);
ok($diceobj->probability(6779),2.76134490966797e-05);
ok($diceobj->probability(6780),4.14201736450195e-05);
ok($diceobj->probability(6781),5.52268981933594e-05);
ok($diceobj->probability(6782),6.90336227416992e-05);
ok($diceobj->probability(6783),8.28403472900391e-05);
ok($diceobj->probability(6784),6.90336227416992e-05);
ok($diceobj->probability(6785),6.5773688422309e-05);
ok($diceobj->probability(6786),6.25137541029188e-05);
ok($diceobj->probability(6787),5.92538197835286e-05);
ok($diceobj->probability(6788),5.92089547051324e-05);
ok($diceobj->probability(6789),5.91640896267361e-05);
ok($diceobj->probability(6790),7.29259490966797e-05);
ok($diceobj->probability(6791),6.5594228108724e-05);
ok($diceobj->probability(6792),5.82625071207682e-05);
ok($diceobj->probability(6793),5.09307861328125e-05);
ok($diceobj->probability(6794),3.71689266628689e-05);
ok($diceobj->probability(6795),2.34070671929253e-05);
ok($diceobj->probability(6796),9.64520772298177e-06);
ok($diceobj->probability(6797),6.43013848198785e-06);
ok($diceobj->probability(6798),3.21506924099392e-06);
ok($diceobj->probability(6802),1.6695073445638e-05);
ok($diceobj->probability(6803),3.3390146891276e-05);
ok($diceobj->probability(6804),5.00852203369141e-05);
ok($diceobj->probability(6805),6.67802937825521e-05);
ok($diceobj->probability(6806),0.000103430493672689);
ok($diceobj->probability(6807),0.000140080693562826);
ok($diceobj->probability(6808),0.000143340746561686);
ok($diceobj->probability(6809),0.000146600799560547);
ok($diceobj->probability(6810),0.000149860852559408);
ok($diceobj->probability(6811),0.000153120905558268);
ok($diceobj->probability(6812),0.000116470705668132);
ok($diceobj->probability(6813),7.98205057779948e-05);
ok($diceobj->probability(6814),5.98653793334961e-05);
ok($diceobj->probability(6815),3.99102528889974e-05);
ok($diceobj->probability(6816),1.99551264444987e-05);
ok($diceobj->probability(6822),2.77519226074219e-07);
ok($diceobj->probability(6823),5.55038452148437e-07);
ok($diceobj->probability(6824),8.32557678222656e-07);
ok($diceobj->probability(6825),1.11007690429687e-06);
ok($diceobj->probability(6826),1.38759613037109e-06);
ok($diceobj->probability(6827),1.62795384724935e-05);
ok($diceobj->probability(6828),3.06164423624675e-05);
ok($diceobj->probability(6829),4.49533462524414e-05);
ok($diceobj->probability(6830),5.92902501424154e-05);
ok($diceobj->probability(6831),7.36271540323893e-05);
ok($diceobj->probability(6832),8.79640579223633e-05);
ok($diceobj->probability(6833),7.73728052775065e-05);
ok($diceobj->probability(6834),6.7059071858724e-05);
ok($diceobj->probability(6835),5.67453384399414e-05);
ok($diceobj->probability(6836),4.64316050211589e-05);
ok($diceobj->probability(6837),3.61178716023763e-05);
ok($diceobj->probability(6838),2.58041381835938e-05);
ok($diceobj->probability(6839),2.15034484863281e-05);
ok($diceobj->probability(6840),1.72027587890625e-05);
ok($diceobj->probability(6841),1.29020690917969e-05);
ok($diceobj->probability(6842),3.15512635972765e-05);
ok($diceobj->probability(6843),5.02004581027561e-05);
ok($diceobj->probability(6844),6.88496526082357e-05);
ok($diceobj->probability(6845),9.17995368109809e-05);
ok($diceobj->probability(6846),0.000114749421013726);
ok($diceobj->probability(6847),0.000137699305216471);
ok($diceobj->probability(6848),0.000114749421013726);
ok($diceobj->probability(6849),9.17995368109809e-05);
ok($diceobj->probability(6850),6.88496526082357e-05);
ok($diceobj->probability(6851),4.58997684054905e-05);
ok($diceobj->probability(6852),2.29498842027452e-05);
ok($diceobj->probability(6853),2.93095906575521e-07);
ok($diceobj->probability(6854),5.86191813151042e-07);
ok($diceobj->probability(6855),8.79287719726563e-07);
ok($diceobj->probability(6856),1.17238362630208e-06);
ok($diceobj->probability(6857),1.4654795328776e-06);
ok($diceobj->probability(6858),1.75857543945313e-06);
ok($diceobj->probability(6859),1.4654795328776e-06);
ok($diceobj->probability(6860),1.17238362630208e-06);
ok($diceobj->probability(6861),1.66600545247396e-06);
ok($diceobj->probability(6862),2.15962727864583e-06);
ok($diceobj->probability(6863),2.65324910481771e-06);
ok($diceobj->probability(6864),3.14687093098958e-06);
ok($diceobj->probability(6865),3.93358866373698e-06);
ok($diceobj->probability(6866),3.49237442016602e-05);
ok($diceobj->probability(6867),6.43404642740885e-05);
ok($diceobj->probability(6868),9.37571843465169e-05);
ok($diceobj->probability(6869),0.000123173904418945);
ok($diceobj->probability(6870),0.000152590624491374);
ok($diceobj->probability(6871),0.000182007344563802);
ok($diceobj->probability(6872),0.000151017189025879);
ok($diceobj->probability(6873),0.000120813751220703);
ok($diceobj->probability(6874),9.06103134155273e-05);
ok($diceobj->probability(6875),6.04068756103516e-05);
ok($diceobj->probability(6876),3.02034378051758e-05);
ok($diceobj->probability(6877),2.70366668701172e-06);
ok($diceobj->probability(6878),5.40733337402344e-06);
ok($diceobj->probability(6879),1.64361953735352e-05);
ok($diceobj->probability(6880),2.74650573730469e-05);
ok($diceobj->probability(6881),3.84939193725586e-05);
ok($diceobj->probability(6882),4.95227813720703e-05);
ok($diceobj->probability(6883),5.51443099975586e-05);
ok($diceobj->probability(6884),6.07658386230469e-05);
ok($diceobj->probability(6885),4.97369766235352e-05);
ok($diceobj->probability(6886),3.87081146240234e-05);
ok($diceobj->probability(6887),3.52597766452365e-05);
ok($diceobj->probability(6888),3.18114386664497e-05);
ok($diceobj->probability(6889),3.10667673746745e-05);
ok($diceobj->probability(6890),3.03220960828993e-05);
ok($diceobj->probability(6891),3.79026201036241e-05);
ok($diceobj->probability(6892),4.5483144124349e-05);
ok($diceobj->probability(6893),3.79026201036241e-05);
ok($diceobj->probability(6894),3.03220960828993e-05);
ok($diceobj->probability(6895),2.27415720621745e-05);
ok($diceobj->probability(6896),1.51610480414497e-05);
ok($diceobj->probability(6897),7.58052402072483e-06);
ok($diceobj->probability(6902),2.81466674804687e-05);
ok($diceobj->probability(6903),5.62933349609375e-05);
ok($diceobj->probability(6904),8.73392995198568e-05);
ok($diceobj->probability(6905),0.000118385264078776);
ok($diceobj->probability(6906),0.000149431228637695);
ok($diceobj->probability(6907),0.000180477193196615);
ok($diceobj->probability(6908),0.000155229822794596);
ok($diceobj->probability(6909),0.000129982452392578);
ok($diceobj->probability(6910),9.89364878336588e-05);
ok($diceobj->probability(6911),6.78905232747396e-05);
ok($diceobj->probability(6912),3.68445587158203e-05);
ok($diceobj->probability(6913),5.79859415690104e-06);
ok($diceobj->probability(6914),2.39987055460612e-05);
ok($diceobj->probability(6915),4.21988169352214e-05);
ok($diceobj->probability(6916),6.3298225402832e-05);
ok($diceobj->probability(6917),8.43976338704427e-05);
ok($diceobj->probability(6918),0.000122266451517741);
ok($diceobj->probability(6919),0.000160135269165039);
ok($diceobj->probability(6920),0.000155805269877116);
ok($diceobj->probability(6921),0.000151475270589193);
ok($diceobj->probability(6922),0.00014714527130127);
ok($diceobj->probability(6923),0.000142815272013346);
ok($diceobj->probability(6924),0.000104946454366048);
ok($diceobj->probability(6925),6.707763671875e-05);
ok($diceobj->probability(6926),5.03082275390625e-05);
ok($diceobj->probability(6927),3.3538818359375e-05);
ok($diceobj->probability(6928),1.67694091796875e-05);
ok($diceobj->probability(6932),1.95428848266602e-05);
ok($diceobj->probability(6933),3.90857696533203e-05);
ok($diceobj->probability(6934),5.86286544799805e-05);
ok($diceobj->probability(6935),7.81715393066406e-05);
ok($diceobj->probability(6936),9.77144241333008e-05);
ok($diceobj->probability(6937),0.000117257308959961);
ok($diceobj->probability(6938),0.000103053813510471);
ok($diceobj->probability(6939),8.88503180609809e-05);
ok($diceobj->probability(6940),7.46468226114909e-05);
ok($diceobj->probability(6941),6.04433271620009e-05);
ok($diceobj->probability(6942),4.62398317125108e-05);
ok($diceobj->probability(6943),3.20363362630208e-05);
ok($diceobj->probability(6944),2.66969468858507e-05);
ok($diceobj->probability(6945),2.13575575086806e-05);
ok($diceobj->probability(6946),1.63322448730469e-05);
ok($diceobj->probability(6947),1.13069322374132e-05);
ok($diceobj->probability(6948),6.28161960177951e-06);
ok($diceobj->probability(6949),1.25630696614583e-06);
ok($diceobj->probability(6950),1.57038370768229e-06);
ok($diceobj->probability(6951),1.88446044921875e-06);
ok($diceobj->probability(6952),1.57038370768229e-06);
ok($diceobj->probability(6953),1.25630696614583e-06);
ok($diceobj->probability(6954),9.42230224609375e-07);
ok($diceobj->probability(6955),6.28153483072917e-07);
ok($diceobj->probability(6956),3.14076741536458e-07);
ok($diceobj->probability(6962),6.04743533664279e-06);
ok($diceobj->probability(6963),1.20948706732856e-05);
ok($diceobj->probability(6964),1.81423060099284e-05);
ok($diceobj->probability(6965),2.41897413465712e-05);
ok($diceobj->probability(6966),3.0237176683214e-05);
ok($diceobj->probability(6967),3.62846120198568e-05);
ok($diceobj->probability(6968),3.0237176683214e-05);
ok($diceobj->probability(6969),2.41897413465712e-05);
ok($diceobj->probability(6970),1.81423060099284e-05);
ok($diceobj->probability(6971),1.20948706732856e-05);
ok($diceobj->probability(6972),6.04743533664279e-06);
ok($diceobj->probability(6977),1.85182359483507e-07);
ok($diceobj->probability(6978),3.70364718967014e-07);
ok($diceobj->probability(6979),5.55547078450521e-07);
ok($diceobj->probability(6980),7.40729437934028e-07);
ok($diceobj->probability(6981),9.25911797417535e-07);
ok($diceobj->probability(6982),1.11109415690104e-06);
ok($diceobj->probability(6983),9.25911797417535e-07);
ok($diceobj->probability(6984),7.40729437934028e-07);
ok($diceobj->probability(6985),5.55547078450521e-07);
ok($diceobj->probability(6986),3.70364718967014e-07);
ok($diceobj->probability(6987),1.85182359483507e-07);
ok($diceobj->probability(6994),1.2945556640625e-05);
ok($diceobj->probability(6995),2.589111328125e-05);
ok($diceobj->probability(6996),3.8836669921875e-05);
ok($diceobj->probability(6997),5.17822265625e-05);
ok($diceobj->probability(6998),6.4727783203125e-05);
ok($diceobj->probability(6999),7.767333984375e-05);
ok($diceobj->probability(7000),6.4727783203125e-05);
ok($diceobj->probability(7001),5.17822265625e-05);
ok($diceobj->probability(7002),5.44014358520508e-05);
ok($diceobj->probability(7003),5.70206451416016e-05);
ok($diceobj->probability(7004),5.96398544311523e-05);
ok($diceobj->probability(7005),6.22590637207031e-05);
ok($diceobj->probability(7006),7.78238296508789e-05);
ok($diceobj->probability(7007),9.33885955810547e-05);
ok($diceobj->probability(7008),7.78238296508789e-05);
ok($diceobj->probability(7009),6.22590637207031e-05);
ok($diceobj->probability(7010),4.66942977905273e-05);
ok($diceobj->probability(7011),3.11295318603516e-05);
ok($diceobj->probability(7012),1.55647659301758e-05);
ok($diceobj->probability(7020),1.61190032958984e-06);
ok($diceobj->probability(7021),3.22380065917969e-06);
ok($diceobj->probability(7022),2.52981736924913e-05);
ok($diceobj->probability(7023),4.73725467258029e-05);
ok($diceobj->probability(7024),6.94469197591146e-05);
ok($diceobj->probability(7025),9.15212927924262e-05);
ok($diceobj->probability(7026),0.000110371865166558);
ok($diceobj->probability(7027),0.00012922243754069);
ok($diceobj->probability(7028),0.000107148064507378);
ok($diceobj->probability(7029),8.50736914740668e-05);
ok($diceobj->probability(7030),6.29993184407552e-05);
ok($diceobj->probability(7031),4.09249454074436e-05);
ok($diceobj->probability(7032),2.04624727037218e-05);
ok($diceobj->probability(7040),9.54013400607639e-06);
ok($diceobj->probability(7041),1.90802680121528e-05);
ok($diceobj->probability(7042),4.24553553263346e-05);
ok($diceobj->probability(7043),6.58304426405165e-05);
ok($diceobj->probability(7044),8.92055299546984e-05);
ok($diceobj->probability(7045),0.00011258061726888);
ok($diceobj->probability(7046),0.000116875436570909);
ok($diceobj->probability(7047),0.000121170255872938);
ok($diceobj->probability(7048),9.77951685587565e-05);
ok($diceobj->probability(7049),7.46082517835829e-05);
ok($diceobj->probability(7050),5.14213350084093e-05);
ok($diceobj->probability(7051),2.82344182332357e-05);
ok($diceobj->probability(7052),1.45876354641385e-05);
ok($diceobj->probability(7053),9.40852695041233e-07);
ok($diceobj->probability(7054),1.12902323404948e-06);
ok($diceobj->probability(7055),9.40852695041233e-07);
ok($diceobj->probability(7056),7.52682156032986e-07);
ok($diceobj->probability(7057),5.6451161702474e-07);
ok($diceobj->probability(7058),3.355041080051e-05);
ok($diceobj->probability(7059),6.65363099839952e-05);
ok($diceobj->probability(7060),9.95222091674805e-05);
ok($diceobj->probability(7061),0.000132696278889974);
ok($diceobj->probability(7062),0.000165870348612467);
ok($diceobj->probability(7063),0.000199044418334961);
ok($diceobj->probability(7064),0.000165870348612467);
ok($diceobj->probability(7065),0.000132696278889974);
ok($diceobj->probability(7066),9.95222091674805e-05);
ok($diceobj->probability(7067),6.6348139444987e-05);
ok($diceobj->probability(7068),3.31740697224935e-05);
ok($diceobj->probability(7070),2.32484605577257e-07);
ok($diceobj->probability(7071),4.64969211154514e-07);
ok($diceobj->probability(7072),6.97453816731771e-07);
ok($diceobj->probability(7073),9.29938422309028e-07);
ok($diceobj->probability(7074),9.63626437717014e-06);
ok($diceobj->probability(7075),1.83425903320312e-05);
ok($diceobj->probability(7076),2.65839470757378e-05);
ok($diceobj->probability(7077),3.48253038194444e-05);
ok($diceobj->probability(7078),4.3066660563151e-05);
ok($diceobj->probability(7079),5.13080173068576e-05);
ok($diceobj->probability(7080),4.26016913519965e-05);
ok($diceobj->probability(7081),3.38953653971354e-05);
ok($diceobj->probability(7082),2.54215240478516e-05);
ok($diceobj->probability(7083),1.69476826985677e-05);
ok($diceobj->probability(7084),8.47384134928385e-06);
ok($diceobj->probability(7086),2.01805114746094e-05);
ok($diceobj->probability(7087),4.03610229492187e-05);
ok($diceobj->probability(7088),6.05415344238281e-05);
ok($diceobj->probability(7089),8.07220458984375e-05);
ok($diceobj->probability(7090),0.000100902557373047);
ok($diceobj->probability(7091),0.000121083068847656);
ok($diceobj->probability(7092),0.000100902557373047);
ok($diceobj->probability(7093),8.07220458984375e-05);
ok($diceobj->probability(7094),6.05415344238281e-05);
ok($diceobj->probability(7095),4.03610229492187e-05);
ok($diceobj->probability(7096),2.01805114746094e-05);
ok($diceobj->probability(7100),1.05937321980794e-05);
ok($diceobj->probability(7101),2.11874643961589e-05);
ok($diceobj->probability(7102),3.17811965942383e-05);
ok($diceobj->probability(7103),4.23749287923177e-05);
ok($diceobj->probability(7104),5.29686609903971e-05);
ok($diceobj->probability(7105),6.35623931884766e-05);
ok($diceobj->probability(7106),5.29686609903971e-05);
ok($diceobj->probability(7107),4.23749287923177e-05);
ok($diceobj->probability(7108),4.07587051391602e-05);
ok($diceobj->probability(7109),3.91424814860026e-05);
ok($diceobj->probability(7110),3.75262578328451e-05);
ok($diceobj->probability(7111),3.59100341796875e-05);
ok($diceobj->probability(7112),4.48875427246094e-05);
ok($diceobj->probability(7113),5.38650512695313e-05);
ok($diceobj->probability(7114),4.48875427246094e-05);
ok($diceobj->probability(7115),3.59100341796875e-05);
ok($diceobj->probability(7116),2.69325256347656e-05);
ok($diceobj->probability(7117),1.79550170898438e-05);
ok($diceobj->probability(7118),8.97750854492188e-06);
ok($diceobj->probability(7127),1.20151011149089e-05);
ok($diceobj->probability(7128),2.40302022298177e-05);
ok($diceobj->probability(7129),3.60453033447266e-05);
ok($diceobj->probability(7130),6.09489313761393e-05);
ok($diceobj->probability(7131),8.58525594075521e-05);
ok($diceobj->probability(7132),0.00011083324432373);
ok($diceobj->probability(7133),0.000111783727010091);
ok($diceobj->probability(7134),0.000112734209696452);
ok($diceobj->probability(7135),0.000113684692382813);
ok($diceobj->probability(7136),8.88581212361654e-05);
ok($diceobj->probability(7137),6.40315500895182e-05);
ok($diceobj->probability(7138),3.90508651733398e-05);
ok($diceobj->probability(7139),2.60852813720703e-05);
ok($diceobj->probability(7140),1.31196975708008e-05);
ok($diceobj->probability(7141),1.5411376953125e-07);
ok($diceobj->probability(7142),1.4641842312283e-05);
ok($diceobj->probability(7143),2.91295708550347e-05);
ok($diceobj->probability(7144),4.36943562825521e-05);
ok($diceobj->probability(7145),5.82591417100694e-05);
ok($diceobj->probability(7146),7.28239271375868e-05);
ok($diceobj->probability(7147),8.73887125651042e-05);
ok($diceobj->probability(7148),7.28239271375868e-05);
ok($diceobj->probability(7149),5.82591417100694e-05);
ok($diceobj->probability(7150),4.36943562825521e-05);
ok($diceobj->probability(7151),2.91295708550347e-05);
ok($diceobj->probability(7152),3.08422893948025e-05);
ok($diceobj->probability(7153),3.25550079345703e-05);
ok($diceobj->probability(7154),4.88325119018555e-05);
ok($diceobj->probability(7155),6.51100158691406e-05);
ok($diceobj->probability(7156),8.13875198364258e-05);
ok($diceobj->probability(7157),9.76650238037109e-05);
ok($diceobj->probability(7158),8.13875198364258e-05);
ok($diceobj->probability(7159),6.51100158691406e-05);
ok($diceobj->probability(7160),4.88325119018555e-05);
ok($diceobj->probability(7161),3.25550079345703e-05);
ok($diceobj->probability(7162),1.62775039672852e-05);
ok($diceobj->probability(7163),1.57356262207031e-07);
ok($diceobj->probability(7164),3.14712524414063e-07);
ok($diceobj->probability(7165),3.18406422932943e-06);
ok($diceobj->probability(7166),6.05341593424479e-06);
ok($diceobj->probability(7167),8.92276763916016e-06);
ok($diceobj->probability(7168),1.17921193440755e-05);
ok($diceobj->probability(7169),1.43467585245768e-05);
ok($diceobj->probability(7170),1.91255569458008e-05);
ok($diceobj->probability(7171),1.84803644816081e-05);
ok($diceobj->probability(7172),1.78351720174154e-05);
ok($diceobj->probability(7173),1.71899795532227e-05);
ok($diceobj->probability(7174),1.65447870890299e-05);
ok($diceobj->probability(7175),1.60569508870443e-05);
ok($diceobj->probability(7176),1.11207962036133e-05);
ok($diceobj->probability(7177),8.89663696289062e-06);
ok($diceobj->probability(7178),2.73304197523329e-05);
ok($diceobj->probability(7179),4.57642025417752e-05);
ok($diceobj->probability(7180),6.41979853312175e-05);
ok($diceobj->probability(7181),8.26317681206597e-05);
ok($diceobj->probability(7182),0.000103289710150825);
ok($diceobj->probability(7183),0.00012394765218099);
ok($diceobj->probability(7184),0.000116284942626953);
ok($diceobj->probability(7185),0.000108622233072917);
ok($diceobj->probability(7186),0.00010095952351888);
ok($diceobj->probability(7187),9.32968139648438e-05);
ok($diceobj->probability(7188),8.56341044108073e-05);
ok($diceobj->probability(7189),7.79713948567708e-05);
ok($diceobj->probability(7190),6.49761623806424e-05);
ok($diceobj->probability(7191),5.19809299045139e-05);
ok($diceobj->probability(7192),3.89856974283854e-05);
ok($diceobj->probability(7193),2.59904649522569e-05);
ok($diceobj->probability(7194),1.29974577162001e-05);
ok($diceobj->probability(7195),4.45048014322917e-09);
ok($diceobj->probability(7196),6.67572021484375e-09);
ok($diceobj->probability(7197),8.90096028645833e-09);
ok($diceobj->probability(7198),1.11262003580729e-08);
ok($diceobj->probability(7199),1.33514404296875e-08);
ok($diceobj->probability(7200),1.11262003580729e-08);
ok($diceobj->probability(7201),8.90096028645833e-09);
ok($diceobj->probability(7202),3.62893380059136e-05);
ok($diceobj->probability(7203),7.25697750515408e-05);
ok($diceobj->probability(7204),0.000108850212097168);
ok($diceobj->probability(7205),0.000145130649142795);
ok($diceobj->probability(7206),0.000181413311428494);
ok($diceobj->probability(7207),0.000217695973714193);
ok($diceobj->probability(7208),0.000181413311428494);
ok($diceobj->probability(7209),0.000145130649142795);
ok($diceobj->probability(7210),0.000108847986857096);
ok($diceobj->probability(7211),7.25653245713976e-05);
ok($diceobj->probability(7212),3.62826622856988e-05);
ok($diceobj->probability(7222),1.62727355957031e-06);
ok($diceobj->probability(7223),3.25454711914063e-06);
ok($diceobj->probability(7224),4.88182067871094e-06);
ok($diceobj->probability(7225),6.50909423828125e-06);
ok($diceobj->probability(7226),8.13636779785156e-06);
ok($diceobj->probability(7227),1.38683191935221e-05);
ok($diceobj->probability(7228),1.63457234700521e-05);
ok($diceobj->probability(7229),1.8823127746582e-05);
ok($diceobj->probability(7230),2.1300532023112e-05);
ok($diceobj->probability(7231),2.37779362996419e-05);
ok($diceobj->probability(7232),2.62553405761719e-05);
ok($diceobj->probability(7233),2.05233891805013e-05);
ok($diceobj->probability(7234),1.6418711344401e-05);
ok($diceobj->probability(7235),1.23140335083008e-05);
ok($diceobj->probability(7236),8.20935567220052e-06);
ok($diceobj->probability(7237),4.10467783610026e-06);
ok($diceobj->probability(7247),1.5531243218316e-05);
ok($diceobj->probability(7248),3.10624864366319e-05);
ok($diceobj->probability(7249),4.65937296549479e-05);
ok($diceobj->probability(7250),6.21249728732639e-05);
ok($diceobj->probability(7251),7.76562160915799e-05);
ok($diceobj->probability(7252),9.37910715738932e-05);
ok($diceobj->probability(7253),7.88634406195746e-05);
ok($diceobj->probability(7254),6.39358096652561e-05);
ok($diceobj->probability(7255),4.90081787109375e-05);
ok($diceobj->probability(7256),3.43610339694553e-05);
ok($diceobj->probability(7257),1.97138892279731e-05);
ok($diceobj->probability(7258),3.85951995849609e-06);
ok($diceobj->probability(7259),3.53639390733507e-06);
ok($diceobj->probability(7260),3.21326785617405e-06);
ok($diceobj->probability(7261),2.89014180501302e-06);
ok($diceobj->probability(7262),1.06045616997613e-05);
ok($diceobj->probability(7263),1.83189815945095e-05);
ok($diceobj->probability(7264),2.66370137532552e-05);
ok($diceobj->probability(7265),3.49550459120009e-05);
ok($diceobj->probability(7266),4.32730780707465e-05);
ok($diceobj->probability(7267),5.15911102294922e-05);
ok($diceobj->probability(7268),4.29925918579102e-05);
ok($diceobj->probability(7269),3.43940734863281e-05);
ok($diceobj->probability(7270),2.57955551147461e-05);
ok($diceobj->probability(7271),1.71970367431641e-05);
ok($diceobj->probability(7272),8.59851837158203e-06);
ok($diceobj->probability(7282),1.61088689168294e-05);
ok($diceobj->probability(7283),3.22177378336589e-05);
ok($diceobj->probability(7284),4.83266067504883e-05);
ok($diceobj->probability(7285),6.44354756673177e-05);
ok($diceobj->probability(7286),8.05443445841471e-05);
ok($diceobj->probability(7287),9.66532135009766e-05);
ok($diceobj->probability(7288),8.05443445841471e-05);
ok($diceobj->probability(7289),6.44354756673177e-05);
ok($diceobj->probability(7290),4.83266067504883e-05);
ok($diceobj->probability(7291),3.22177378336589e-05);
ok($diceobj->probability(7292),2.32063378228082e-05);
ok($diceobj->probability(7293),1.41949378119575e-05);
ok($diceobj->probability(7294),2.12924067179362e-05);
ok($diceobj->probability(7295),2.83898756239149e-05);
ok($diceobj->probability(7296),3.54873445298937e-05);
ok($diceobj->probability(7297),4.25848134358724e-05);
ok($diceobj->probability(7298),4.58955764770508e-05);
ok($diceobj->probability(7299),4.92063395182292e-05);
ok($diceobj->probability(7300),5.25171025594076e-05);
ok($diceobj->probability(7301),5.58278656005859e-05);
ok($diceobj->probability(7302),5.91386286417643e-05);
ok($diceobj->probability(7303),6.24493916829427e-05);
ok($diceobj->probability(7304),5.20411597357856e-05);
ok($diceobj->probability(7305),4.16329277886285e-05);
ok($diceobj->probability(7306),3.12246958414714e-05);
ok($diceobj->probability(7307),2.08164638943142e-05);
ok($diceobj->probability(7308),1.04082319471571e-05);
ok($diceobj->probability(7310),4.91044786241319e-06);
ok($diceobj->probability(7311),9.82089572482639e-06);
ok($diceobj->probability(7312),1.47313435872396e-05);
ok($diceobj->probability(7313),1.96417914496528e-05);
ok($diceobj->probability(7314),2.4552239312066e-05);
ok($diceobj->probability(7315),2.94626871744792e-05);
ok($diceobj->probability(7316),2.4552239312066e-05);
ok($diceobj->probability(7317),1.96417914496528e-05);
ok($diceobj->probability(7318),1.47313435872396e-05);
ok($diceobj->probability(7319),9.82089572482639e-06);
ok($diceobj->probability(7320),4.91044786241319e-06);
ok($diceobj->probability(7339),1.32522583007812e-06);
ok($diceobj->probability(7340),2.65045166015625e-06);
ok($diceobj->probability(7341),3.97567749023438e-06);
ok($diceobj->probability(7342),5.3009033203125e-06);
ok($diceobj->probability(7343),6.62612915039063e-06);
ok($diceobj->probability(7344),7.95135498046875e-06);
ok($diceobj->probability(7345),6.62612915039063e-06);
ok($diceobj->probability(7346),1.85847812228733e-05);
ok($diceobj->probability(7347),3.05434332953559e-05);
ok($diceobj->probability(7348),4.25020853678385e-05);
ok($diceobj->probability(7349),5.44607374403212e-05);
ok($diceobj->probability(7350),6.64193895128038e-05);
ok($diceobj->probability(7351),7.97032674153646e-05);
ok($diceobj->probability(7352),7.9148080613878e-05);
ok($diceobj->probability(7353),7.85928938123915e-05);
ok($diceobj->probability(7354),7.8037707010905e-05);
ok($diceobj->probability(7355),7.74825202094184e-05);
ok($diceobj->probability(7356),7.69273334079319e-05);
ok($diceobj->probability(7357),7.63721466064453e-05);
ok($diceobj->probability(7358),6.36434555053711e-05);
ok($diceobj->probability(7359),5.09147644042969e-05);
ok($diceobj->probability(7360),3.81860733032227e-05);
ok($diceobj->probability(7361),2.54573822021484e-05);
ok($diceobj->probability(7362),2.41352971394857e-05);
ok($diceobj->probability(7363),2.28132120768229e-05);
ok($diceobj->probability(7364),3.42198181152344e-05);
ok($diceobj->probability(7365),4.56264241536458e-05);
ok($diceobj->probability(7366),5.70330301920573e-05);
ok($diceobj->probability(7367),6.84396362304688e-05);
ok($diceobj->probability(7368),5.70330301920573e-05);
ok($diceobj->probability(7369),4.56264241536458e-05);
ok($diceobj->probability(7370),3.42198181152344e-05);
ok($diceobj->probability(7371),2.28132120768229e-05);
ok($diceobj->probability(7372),1.14066060384115e-05);
ok($diceobj->probability(7373),7.09862179226345e-06);
ok($diceobj->probability(7374),1.41972435845269e-05);
ok($diceobj->probability(7375),2.12958653767904e-05);
ok($diceobj->probability(7376),2.83944871690538e-05);
ok($diceobj->probability(7377),3.54931089613173e-05);
ok($diceobj->probability(7378),4.25917307535807e-05);
ok($diceobj->probability(7379),3.54931089613173e-05);
ok($diceobj->probability(7380),2.86602444118924e-05);
ok($diceobj->probability(7381),2.18273798624674e-05);
ok($diceobj->probability(7382),1.49945153130425e-05);
ok($diceobj->probability(7383),8.16165076361762e-06);
ok($diceobj->probability(7384),1.32878621419271e-06);
ok($diceobj->probability(7385),1.59454345703125e-06);
ok($diceobj->probability(7386),1.32878621419271e-06);
ok($diceobj->probability(7387),1.06302897135417e-06);
ok($diceobj->probability(7388),7.97271728515625e-07);
ok($diceobj->probability(7389),5.31514485677083e-07);
ok($diceobj->probability(7390),2.65757242838542e-07);
ok($diceobj->probability(7394),3.18553924560547e-05);
ok($diceobj->probability(7395),6.37107849121094e-05);
ok($diceobj->probability(7396),9.55661773681641e-05);
ok($diceobj->probability(7397),0.000129768719143338);
ok($diceobj->probability(7398),0.000163971260918511);
ok($diceobj->probability(7399),0.000198173802693685);
ok($diceobj->probability(7400),0.000168665559556749);
ok($diceobj->probability(7401),0.000139157316419813);
ok($diceobj->probability(7402),0.000109649073282878);
ok($diceobj->probability(7403),7.5446531507704e-05);
ok($diceobj->probability(7404),4.12439897325304e-05);
ok($diceobj->probability(7405),7.04144795735677e-06);
ok($diceobj->probability(7406),4.69429863823785e-06);
ok($diceobj->probability(7407),2.34714931911892e-06);
ok($diceobj->probability(7408),7.2509765625e-06);
ok($diceobj->probability(7409),1.4501953125e-05);
ok($diceobj->probability(7410),2.17529296875e-05);
ok($diceobj->probability(7411),2.900390625e-05);
ok($diceobj->probability(7412),4.60298750135634e-05);
ok($diceobj->probability(7413),6.30558437771267e-05);
ok($diceobj->probability(7414),6.55798594156901e-05);
ok($diceobj->probability(7415),6.81038750542535e-05);
ok($diceobj->probability(7416),7.06278906928168e-05);
ok($diceobj->probability(7417),7.31519063313802e-05);
ok($diceobj->probability(7418),5.61259375678168e-05);
ok($diceobj->probability(7419),3.90999688042535e-05);
ok($diceobj->probability(7420),2.93249766031901e-05);
ok($diceobj->probability(7421),1.95499844021267e-05);
ok($diceobj->probability(7422),9.77499220106337e-06);
ok($diceobj->probability(7426),1.11211140950521e-06);
ok($diceobj->probability(7427),4.84549204508464e-06);
ok($diceobj->probability(7428),8.57887268066406e-06);
ok($diceobj->probability(7429),1.23122533162435e-05);
ok($diceobj->probability(7430),1.60456339518229e-05);
ok($diceobj->probability(7431),2.72069931030273e-05);
ok($diceobj->probability(7432),3.61441294352214e-05);
ok($diceobj->probability(7433),3.98387273152669e-05);
ok($diceobj->probability(7434),4.35333251953125e-05);
ok($diceobj->probability(7435),4.72279230753581e-05);
ok($diceobj->probability(7436),5.09225209554036e-05);
ok($diceobj->probability(7437),3.97611618041992e-05);
ok($diceobj->probability(7438),4.00859832763672e-05);
ok($diceobj->probability(7439),4.30320739746094e-05);
ok($diceobj->probability(7440),4.59781646728516e-05);
ok($diceobj->probability(7441),4.89242553710938e-05);
ok($diceobj->probability(7442),5.24002287122938e-05);
ok($diceobj->probability(7443),6.33041805691189e-05);
ok($diceobj->probability(7444),5.34599939982096e-05);
ok($diceobj->probability(7445),4.36158074273003e-05);
ok($diceobj->probability(7446),3.37716208563911e-05);
ok($diceobj->probability(7447),2.39274342854818e-05);
ok($diceobj->probability(7448),1.30234824286567e-05);
ok($diceobj->probability(7449),2.1195305718316e-06);
ok($diceobj->probability(7450),6.22475941975911e-06);
ok($diceobj->probability(7451),1.03299882676866e-05);
ok($diceobj->probability(7452),1.44352171156141e-05);
ok($diceobj->probability(7453),1.85404459635417e-05);
ok($diceobj->probability(7454),3.09784783257378e-05);
ok($diceobj->probability(7455),4.3416510687934e-05);
ok($diceobj->probability(7456),4.65843200683594e-05);
ok($diceobj->probability(7457),4.97521294487847e-05);
ok($diceobj->probability(7458),5.29199388292101e-05);
ok($diceobj->probability(7459),5.60877482096354e-05);
ok($diceobj->probability(7460),4.36497158474392e-05);
ok($diceobj->probability(7461),3.12116834852431e-05);
ok($diceobj->probability(7462),2.34087626139323e-05);
ok($diceobj->probability(7463),1.56058417426215e-05);
ok($diceobj->probability(7464),7.80292087131076e-06);
ok($diceobj->probability(7477),1.01778666178385e-05);
ok($diceobj->probability(7478),2.03557332356771e-05);
ok($diceobj->probability(7479),3.05335998535156e-05);
ok($diceobj->probability(7480),4.07114664713542e-05);
ok($diceobj->probability(7481),5.08893330891927e-05);
ok($diceobj->probability(7482),6.8597412109375e-05);
ok($diceobj->probability(7483),6.59497578938802e-05);
ok($diceobj->probability(7484),6.33021036783854e-05);
ok($diceobj->probability(7485),6.06544494628906e-05);
ok($diceobj->probability(7486),5.80067952473958e-05);
ok($diceobj->probability(7487),5.5359141031901e-05);
ok($diceobj->probability(7488),3.76510620117187e-05);
ok($diceobj->probability(7489),3.0120849609375e-05);
ok($diceobj->probability(7490),4.05947579277886e-05);
ok($diceobj->probability(7491),5.10686662462023e-05);
ok($diceobj->probability(7492),6.15425745646159e-05);
ok($diceobj->probability(7493),7.20164828830295e-05);
ok($diceobj->probability(7494),9.00206036037869e-05);
ok($diceobj->probability(7495),0.000108024724324544);
ok($diceobj->probability(7496),9.00206036037869e-05);
ok($diceobj->probability(7497),7.20164828830295e-05);
ok($diceobj->probability(7498),5.40123621622721e-05);
ok($diceobj->probability(7499),3.98430718315972e-05);
ok($diceobj->probability(7500),2.56737815009223e-05);
ok($diceobj->probability(7501),1.15044911702474e-05);
ok($diceobj->probability(7502),2.94702445136176e-05);
ok($diceobj->probability(7503),4.74359978569878e-05);
ok($diceobj->probability(7504),6.55304972330729e-05);
ok($diceobj->probability(7505),7.59553358289931e-05);
ok($diceobj->probability(7506),8.63801744249132e-05);
ok($diceobj->probability(7507),9.68050130208333e-05);
ok($diceobj->probability(7508),7.8968005710178e-05);
ok($diceobj->probability(7509),6.11309983995226e-05);
ok($diceobj->probability(7510),4.30364990234375e-05);
ok($diceobj->probability(7511),2.87768300374349e-05);
ok($diceobj->probability(7512),1.45171610514323e-05);
ok($diceobj->probability(7513),2.57492065429688e-07);
ok($diceobj->probability(7514),1.28746032714844e-07);
ok($diceobj->probability(7516),2.97959645589193e-06);
ok($diceobj->probability(7517),5.95919291178385e-06);
ok($diceobj->probability(7518),8.93878936767578e-06);
ok($diceobj->probability(7519),1.19183858235677e-05);
ok($diceobj->probability(7520),1.48979822794596e-05);
ok($diceobj->probability(7521),1.78775787353516e-05);
ok($diceobj->probability(7522),1.48979822794596e-05);
ok($diceobj->probability(7523),1.19183858235677e-05);
ok($diceobj->probability(7524),8.93878936767578e-06);
ok($diceobj->probability(7525),5.95919291178385e-06);
ok($diceobj->probability(7526),7.48856862386068e-06);
ok($diceobj->probability(7527),9.0179443359375e-06);
ok($diceobj->probability(7528),1.35269165039062e-05);
ok($diceobj->probability(7529),1.8035888671875e-05);
ok($diceobj->probability(7530),2.25448608398438e-05);
ok($diceobj->probability(7531),2.70538330078125e-05);
ok($diceobj->probability(7532),2.25448608398438e-05);
ok($diceobj->probability(7533),1.8035888671875e-05);
ok($diceobj->probability(7534),1.35269165039062e-05);
ok($diceobj->probability(7535),9.03171963161892e-06);
ok($diceobj->probability(7536),4.5365227593316e-06);
ok($diceobj->probability(7537),4.13258870442708e-08);
ok($diceobj->probability(7538),5.51011827256944e-08);
ok($diceobj->probability(7539),6.8876478407118e-08);
ok($diceobj->probability(7540),8.26517740885417e-08);
ok($diceobj->probability(7541),6.8876478407118e-08);
ok($diceobj->probability(7542),2.96645270453559e-06);
ok($diceobj->probability(7543),5.86402893066406e-06);
ok($diceobj->probability(7544),8.76160515679254e-06);
ok($diceobj->probability(7545),1.1659181382921e-05);
ok($diceobj->probability(7546),1.45567576090495e-05);
ok($diceobj->probability(7547),1.74681091308594e-05);
ok($diceobj->probability(7548),1.45567576090495e-05);
ok($diceobj->probability(7549),1.16454060872396e-05);
ok($diceobj->probability(7550),8.73405456542969e-06);
ok($diceobj->probability(7551),5.82270304361979e-06);
ok($diceobj->probability(7552),2.9113515218099e-06);
ok($diceobj->probability(7562),2.9788564046224e-05);
ok($diceobj->probability(7563),5.95771280924479e-05);
ok($diceobj->probability(7564),8.93656921386719e-05);
ok($diceobj->probability(7565),0.000119154256184896);
ok($diceobj->probability(7566),0.00014894282023112);
ok($diceobj->probability(7567),0.000178731384277344);
ok($diceobj->probability(7568),0.00014894282023112);
ok($diceobj->probability(7569),0.000119154256184896);
ok($diceobj->probability(7570),8.93656921386719e-05);
ok($diceobj->probability(7571),5.96060562133789e-05);
ok($diceobj->probability(7572),2.98464202880859e-05);
ok($diceobj->probability(7573),8.67843627929687e-08);
ok($diceobj->probability(7574),1.15712483723958e-07);
ok($diceobj->probability(7575),1.44640604654948e-07);
ok($diceobj->probability(7576),1.73568725585937e-07);
ok($diceobj->probability(7577),1.44640604654948e-07);
ok($diceobj->probability(7578),1.15712483723958e-07);
ok($diceobj->probability(7579),8.67843627929687e-08);
ok($diceobj->probability(7580),5.78562418619792e-08);
ok($diceobj->probability(7581),2.89281209309896e-08);
ok($diceobj->probability(7583),1.31437513563368e-06);
ok($diceobj->probability(7584),2.62875027126736e-06);
ok($diceobj->probability(7585),3.94312540690104e-06);
ok($diceobj->probability(7586),5.25750054253472e-06);
ok($diceobj->probability(7587),6.5718756781684e-06);
ok($diceobj->probability(7588),7.88625081380208e-06);
ok($diceobj->probability(7589),6.5718756781684e-06);
ok($diceobj->probability(7590),5.25750054253472e-06);
ok($diceobj->probability(7591),3.94312540690104e-06);
ok($diceobj->probability(7592),1.63004726833767e-05);
ok($diceobj->probability(7593),2.86578199598524e-05);
ok($diceobj->probability(7594),4.10151672363281e-05);
ok($diceobj->probability(7595),5.46868896484375e-05);
ok($diceobj->probability(7596),6.83586120605469e-05);
ok($diceobj->probability(7597),8.20303344726562e-05);
ok($diceobj->probability(7598),6.83586120605469e-05);
ok($diceobj->probability(7599),5.46868896484375e-05);
ok($diceobj->probability(7600),4.10151672363281e-05);
ok($diceobj->probability(7601),2.73434448242187e-05);
ok($diceobj->probability(7602),2.26086680094401e-05);
ok($diceobj->probability(7603),1.78738911946615e-05);
ok($diceobj->probability(7604),2.68108367919922e-05);
ok($diceobj->probability(7605),3.57477823893229e-05);
ok($diceobj->probability(7606),4.46847279866536e-05);
ok($diceobj->probability(7607),5.36216735839844e-05);
ok($diceobj->probability(7608),4.46847279866536e-05);
ok($diceobj->probability(7609),3.57477823893229e-05);
ok($diceobj->probability(7610),2.68108367919922e-05);
ok($diceobj->probability(7611),1.78738911946615e-05);
ok($diceobj->probability(7612),8.93694559733073e-06);
ok($diceobj->probability(7618),3.45102945963542e-06);
ok($diceobj->probability(7619),6.90205891927083e-06);
ok($diceobj->probability(7620),1.03530883789062e-05);
ok($diceobj->probability(7621),1.38041178385417e-05);
ok($diceobj->probability(7622),1.72551472981771e-05);
ok($diceobj->probability(7623),2.07061767578125e-05);
ok($diceobj->probability(7624),1.72551472981771e-05);
ok($diceobj->probability(7625),1.38041178385417e-05);
ok($diceobj->probability(7626),1.03530883789062e-05);
ok($diceobj->probability(7627),6.90205891927083e-06);
ok($diceobj->probability(7628),3.45102945963542e-06);
ok($diceobj->probability(7646),1.35004255506727e-05);
ok($diceobj->probability(7647),2.70008511013455e-05);
ok($diceobj->probability(7648),4.05012766520182e-05);
ok($diceobj->probability(7649),5.4001702202691e-05);
ok($diceobj->probability(7650),6.75021277533637e-05);
ok($diceobj->probability(7651),8.10025533040365e-05);
ok($diceobj->probability(7652),7.42994689941406e-05);
ok($diceobj->probability(7653),6.75963846842448e-05);
ok($diceobj->probability(7654),6.0893300374349e-05);
ok($diceobj->probability(7655),5.41902160644531e-05);
ok($diceobj->probability(7656),4.74871317545573e-05);
ok($diceobj->probability(7657),4.07840474446615e-05);
ok($diceobj->probability(7658),3.68925518459744e-05);
ok($diceobj->probability(7659),3.32343885633681e-05);
ok($diceobj->probability(7660),2.95762252807617e-05);
ok($diceobj->probability(7661),2.59180619981554e-05);
ok($diceobj->probability(7662),2.2259898715549e-05);
ok($diceobj->probability(7663),1.86017354329427e-05);
ok($diceobj->probability(7664),1.59292221069336e-05);
ok($diceobj->probability(7665),1.2790044148763e-05);
ok($diceobj->probability(7666),9.65086619059245e-06);
ok($diceobj->probability(7667),6.51168823242188e-06);
ok($diceobj->probability(7668),3.3725102742513e-06);
ok($diceobj->probability(7669),2.33332316080729e-07);
ok($diceobj->probability(7682),9.65660095214844e-06);
ok($diceobj->probability(7683),1.93132019042969e-05);
ok($diceobj->probability(7684),2.89698028564453e-05);
ok($diceobj->probability(7685),3.86264038085937e-05);
ok($diceobj->probability(7686),4.82830047607422e-05);
ok($diceobj->probability(7687),5.79396057128906e-05);
ok($diceobj->probability(7688),4.82830047607422e-05);
ok($diceobj->probability(7689),3.86264038085937e-05);
ok($diceobj->probability(7690),2.89698028564453e-05);
ok($diceobj->probability(7691),1.93132019042969e-05);
ok($diceobj->probability(7692),9.65660095214844e-06);
ok($diceobj->probability(7697),5.84137810601128e-06);
ok($diceobj->probability(7698),1.16827562120226e-05);
ok($diceobj->probability(7699),1.75241343180339e-05);
ok($diceobj->probability(7700),2.33655124240451e-05);
ok($diceobj->probability(7701),2.92068905300564e-05);
ok($diceobj->probability(7702),4.73941548665365e-05);
ok($diceobj->probability(7703),5.38986629909939e-05);
ok($diceobj->probability(7704),6.04031711154514e-05);
ok($diceobj->probability(7705),6.69076792399089e-05);
ok($diceobj->probability(7706),7.34121873643663e-05);
ok($diceobj->probability(7707),7.99166954888238e-05);
ok($diceobj->probability(7708),6.17294311523437e-05);
ok($diceobj->probability(7709),4.9383544921875e-05);
ok($diceobj->probability(7710),3.70376586914062e-05);
ok($diceobj->probability(7711),2.46917724609375e-05);
ok($diceobj->probability(7712),1.23458862304688e-05);
ok($diceobj->probability(7716),2.37897237141927e-06);
ok($diceobj->probability(7717),4.75794474283854e-06);
ok($diceobj->probability(7718),7.13691711425781e-06);
ok($diceobj->probability(7719),9.51588948567708e-06);
ok($diceobj->probability(7720),1.18948618570964e-05);
ok($diceobj->probability(7721),1.42738342285156e-05);
ok($diceobj->probability(7722),1.18948618570964e-05);
ok($diceobj->probability(7723),9.51588948567708e-06);
ok($diceobj->probability(7724),1.50352478027344e-05);
ok($diceobj->probability(7725),2.05546061197917e-05);
ok($diceobj->probability(7726),2.6073964436849e-05);
ok($diceobj->probability(7727),3.15933227539063e-05);
ok($diceobj->probability(7728),3.94916534423828e-05);
ok($diceobj->probability(7729),4.73899841308594e-05);
ok($diceobj->probability(7730),6.40314314100477e-05);
ok($diceobj->probability(7731),8.06728786892361e-05);
ok($diceobj->probability(7732),9.73143259684245e-05);
ok($diceobj->probability(7733),0.000113955773247613);
ok($diceobj->probability(7734),0.000130597220526801);
ok($diceobj->probability(7735),0.00014723866780599);
ok($diceobj->probability(7736),0.000122698889838325);
ok($diceobj->probability(7737),9.81591118706597e-05);
ok($diceobj->probability(7738),7.36193339029948e-05);
ok($diceobj->probability(7739),4.90795559353299e-05);
ok($diceobj->probability(7740),2.45397779676649e-05);
ok($diceobj->probability(7746),5.15842437744141e-06);
ok($diceobj->probability(7747),1.03168487548828e-05);
ok($diceobj->probability(7748),1.54752731323242e-05);
ok($diceobj->probability(7749),2.06336975097656e-05);
ok($diceobj->probability(7750),2.5792121887207e-05);
ok($diceobj->probability(7751),3.09505462646484e-05);
ok($diceobj->probability(7752),2.58370717366536e-05);
ok($diceobj->probability(7753),2.07235972086589e-05);
ok($diceobj->probability(7754),2.15556250678168e-05);
ok($diceobj->probability(7755),2.23876529269748e-05);
ok($diceobj->probability(7756),2.32196807861328e-05);
ok($diceobj->probability(7757),2.40517086452908e-05);
ok($diceobj->probability(7758),2.9952261182997e-05);
ok($diceobj->probability(7759),3.58528137207031e-05);
ok($diceobj->probability(7760),2.98623614841037e-05);
ok($diceobj->probability(7761),2.38719092475043e-05);
ok($diceobj->probability(7762),1.78814570109049e-05);
ok($diceobj->probability(7763),1.18910047743056e-05);
ok($diceobj->probability(7764),5.94550238715278e-06);
ok($diceobj->probability(7776),7.37126668294271e-06);
ok($diceobj->probability(7777),1.47425333658854e-05);
ok($diceobj->probability(7778),3.2887691921658e-05);
ok($diceobj->probability(7779),5.10328504774306e-05);
ok($diceobj->probability(7780),6.91780090332031e-05);
ok($diceobj->probability(7781),8.73231675889757e-05);
ok($diceobj->probability(7782),9.07257927788628e-05);
ok($diceobj->probability(7783),9.412841796875e-05);
ok($diceobj->probability(7784),7.59832594129774e-05);
ok($diceobj->probability(7785),5.78381008572049e-05);
ok($diceobj->probability(7786),3.96929423014323e-05);
ok($diceobj->probability(7787),2.15477837456597e-05);
ok($diceobj->probability(7788),1.07738918728299e-05);
ok($diceobj->probability(7802),2.15647718641493e-05);
ok($diceobj->probability(7803),4.31295437282986e-05);
ok($diceobj->probability(7804),6.46943155924479e-05);
ok($diceobj->probability(7805),8.82566112942166e-05);
ok($diceobj->probability(7806),0.000111818906995985);
ok($diceobj->probability(7807),0.000135381202697754);
ok($diceobj->probability(7808),0.000115813954671224);
ok($diceobj->probability(7809),9.6246706644694e-05);
ok($diceobj->probability(7810),7.66794586181641e-05);
ok($diceobj->probability(7811),5.31171629163954e-05);
ok($diceobj->probability(7812),2.95548672146267e-05);
ok($diceobj->probability(7813),5.99257151285807e-06);
ok($diceobj->probability(7814),4.4147703382704e-06);
ok($diceobj->probability(7815),2.83696916368273e-06);
ok($diceobj->probability(7816),1.25916798909505e-06);
ok($diceobj->probability(7817),1.67889065212674e-06);
ok($diceobj->probability(7818),2.09861331515842e-06);
ok($diceobj->probability(7819),2.5183359781901e-06);
ok($diceobj->probability(7820),2.09861331515842e-06);
ok($diceobj->probability(7821),1.67889065212674e-06);
ok($diceobj->probability(7822),7.48434702555339e-06);
ok($diceobj->probability(7823),1.328980339898e-05);
ok($diceobj->probability(7824),1.90952597724067e-05);
ok($diceobj->probability(7825),2.49007161458333e-05);
ok($diceobj->probability(7826),3.11258951822917e-05);
ok($diceobj->probability(7827),3.735107421875e-05);
ok($diceobj->probability(7828),3.11258951822917e-05);
ok($diceobj->probability(7829),2.49007161458333e-05);
ok($diceobj->probability(7830),1.8675537109375e-05);
ok($diceobj->probability(7831),1.24503580729167e-05);
ok($diceobj->probability(7832),8.56573740641276e-06);
ok($diceobj->probability(7833),4.68111673990885e-06);
ok($diceobj->probability(7834),7.02167510986328e-06);
ok($diceobj->probability(7835),9.36223347981771e-06);
ok($diceobj->probability(7836),1.17027918497721e-05);
ok($diceobj->probability(7837),1.40433502197266e-05);
ok($diceobj->probability(7838),1.17027918497721e-05);
ok($diceobj->probability(7839),9.36223347981771e-06);
ok($diceobj->probability(7840),7.02167510986328e-06);
ok($diceobj->probability(7841),4.68111673990885e-06);
ok($diceobj->probability(7842),6.72115325927734e-06);
ok($diceobj->probability(7843),8.76118977864583e-06);
ok($diceobj->probability(7844),1.31417846679688e-05);
ok($diceobj->probability(7845),1.76253763834635e-05);
ok($diceobj->probability(7846),2.21089680989583e-05);
ok($diceobj->probability(7847),2.65925598144531e-05);
ok($diceobj->probability(7848),2.23149617513021e-05);
ok($diceobj->probability(7849),1.8037363688151e-05);
ok($diceobj->probability(7850),1.3759765625e-05);
ok($diceobj->probability(7851),9.27617390950521e-06);
ok($diceobj->probability(7852),4.79258219401042e-06);
ok($diceobj->probability(7853),3.08990478515625e-07);
ok($diceobj->probability(7854),2.0599365234375e-07);
ok($diceobj->probability(7855),1.02996826171875e-07);
ok($diceobj->probability(7856),6.5155029296875e-06);
ok($diceobj->probability(7857),1.3031005859375e-05);
ok($diceobj->probability(7858),1.95465087890625e-05);
ok($diceobj->probability(7859),2.606201171875e-05);
ok($diceobj->probability(7860),3.25775146484375e-05);
ok($diceobj->probability(7861),3.9093017578125e-05);
ok($diceobj->probability(7862),3.25775146484375e-05);
ok($diceobj->probability(7863),2.606201171875e-05);
ok($diceobj->probability(7864),1.95465087890625e-05);
ok($diceobj->probability(7865),1.3031005859375e-05);
ok($diceobj->probability(7866),6.5155029296875e-06);
ok($diceobj->probability(7868),3.73060438368056e-06);
ok($diceobj->probability(7869),7.46120876736111e-06);
ok($diceobj->probability(7870),1.11918131510417e-05);
ok($diceobj->probability(7871),1.49224175347222e-05);
ok($diceobj->probability(7872),1.86530219184028e-05);
ok($diceobj->probability(7873),2.23836263020833e-05);
ok($diceobj->probability(7874),1.86530219184028e-05);
ok($diceobj->probability(7875),1.49224175347222e-05);
ok($diceobj->probability(7876),1.11918131510417e-05);
ok($diceobj->probability(7877),1.69841554429796e-05);
ok($diceobj->probability(7878),2.27764977349175e-05);
ok($diceobj->probability(7879),2.85688400268555e-05);
ok($diceobj->probability(7880),3.8091786702474e-05);
ok($diceobj->probability(7881),4.76147333780924e-05);
ok($diceobj->probability(7882),5.71376800537109e-05);
ok($diceobj->probability(7883),4.76147333780924e-05);
ok($diceobj->probability(7884),3.8091786702474e-05);
ok($diceobj->probability(7885),2.85688400268555e-05);
ok($diceobj->probability(7886),1.9045893351237e-05);
ok($diceobj->probability(7887),9.52294667561849e-06);
ok($diceobj->probability(7890),1.74662272135417e-06);
ok($diceobj->probability(7891),3.49324544270833e-06);
ok($diceobj->probability(7892),5.2398681640625e-06);
ok($diceobj->probability(7893),6.98649088541667e-06);
ok($diceobj->probability(7894),8.73311360677083e-06);
ok($diceobj->probability(7895),1.0479736328125e-05);
ok($diceobj->probability(7896),8.73311360677083e-06);
ok($diceobj->probability(7897),6.98649088541667e-06);
ok($diceobj->probability(7898),5.2398681640625e-06);
ok($diceobj->probability(7899),3.49324544270833e-06);
ok($diceobj->probability(7900),1.74662272135417e-06);
ok($diceobj->probability(7906),5.81830342610677e-06);
ok($diceobj->probability(7907),1.18512895372179e-05);
ok($diceobj->probability(7908),1.7884275648329e-05);
ok($diceobj->probability(7909),2.39172617594401e-05);
ok($diceobj->probability(7910),2.99502478705512e-05);
ok($diceobj->probability(7911),3.59832339816623e-05);
ok($diceobj->probability(7912),3.03796132405599e-05);
ok($diceobj->probability(7913),2.43466271294488e-05);
ok($diceobj->probability(7914),1.83136410183377e-05);
ok($diceobj->probability(7915),1.22806549072266e-05);
ok($diceobj->probability(7916),6.24766879611545e-06);
ok($diceobj->probability(7917),2.1468268500434e-07);
ok($diceobj->probability(7919),2.19101376003689e-06);
ok($diceobj->probability(7920),4.38202752007378e-06);
ok($diceobj->probability(7921),6.57304128011068e-06);
ok($diceobj->probability(7922),2.37547090318468e-05);
ok($diceobj->probability(7923),4.09363767835829e-05);
ok($diceobj->probability(7924),5.8118044535319e-05);
ok($diceobj->probability(7925),7.09176847669813e-05);
ok($diceobj->probability(7926),8.37173249986437e-05);
ok($diceobj->probability(7927),9.6516965230306e-05);
ok($diceobj->probability(7928),7.93352974785699e-05);
ok($diceobj->probability(7929),6.21536297268338e-05);
ok($diceobj->probability(7930),4.49719619750977e-05);
ok($diceobj->probability(7931),2.99813079833984e-05);
ok($diceobj->probability(7932),1.49906539916992e-05);
ok($diceobj->probability(7937),5.4248046875e-06);
ok($diceobj->probability(7938),1.09529240926107e-05);
ok($diceobj->probability(7939),1.64810434977214e-05);
ok($diceobj->probability(7940),2.98353322347005e-05);
ok($diceobj->probability(7941),4.31896209716797e-05);
ok($diceobj->probability(7942),5.65439097086589e-05);
ok($diceobj->probability(7943),5.9048589070638e-05);
ok($diceobj->probability(7944),6.24651082356771e-05);
ok($diceobj->probability(7945),6.58816274007161e-05);
ok($diceobj->probability(7946),5.36458079020182e-05);
ok($diceobj->probability(7947),4.14099884033203e-05);
ok($diceobj->probability(7948),2.91741689046224e-05);
ok($diceobj->probability(7949),2.23631540934245e-05);
ok($diceobj->probability(7950),1.34185155232747e-05);
ok($diceobj->probability(7951),4.473876953125e-06);
ok($diceobj->probability(7952),3.35540771484375e-06);
ok($diceobj->probability(7953),2.2369384765625e-06);
ok($diceobj->probability(7954),1.11846923828125e-06);
ok($diceobj->probability(7958),4.26101684570312e-06);
ok($diceobj->probability(7959),8.52203369140625e-06);
ok($diceobj->probability(7960),1.27830505371094e-05);
ok($diceobj->probability(7961),1.70440673828125e-05);
ok($diceobj->probability(7962),2.13050842285156e-05);
ok($diceobj->probability(7963),2.55661010742187e-05);
ok($diceobj->probability(7964),2.13050842285156e-05);
ok($diceobj->probability(7965),1.70440673828125e-05);
ok($diceobj->probability(7966),1.27830505371094e-05);
ok($diceobj->probability(7967),8.52203369140625e-06);
ok($diceobj->probability(7968),4.26101684570312e-06);
ok($diceobj->probability(7977),8.06808471679687e-07);
ok($diceobj->probability(7978),1.61361694335937e-06);
ok($diceobj->probability(7979),2.42042541503906e-06);
ok($diceobj->probability(7980),3.22723388671875e-06);
ok($diceobj->probability(7981),4.03404235839844e-06);
ok($diceobj->probability(7982),1.0777096218533e-05);
ok($diceobj->probability(7983),1.59065331353082e-05);
ok($diceobj->probability(7984),2.10359700520833e-05);
ok($diceobj->probability(7985),2.61654069688585e-05);
ok($diceobj->probability(7986),3.12948438856337e-05);
ok($diceobj->probability(7987),3.64242808024089e-05);
ok($diceobj->probability(7988),2.96812269422743e-05);
ok($diceobj->probability(7989),2.37449815538194e-05);
ok($diceobj->probability(7990),1.78087361653646e-05);
ok($diceobj->probability(7991),1.18724907769097e-05);
ok($diceobj->probability(7992),5.93624538845486e-06);
ok($diceobj->probability(8002),7.13871002197266e-06);
ok($diceobj->probability(8003),1.42774200439453e-05);
ok($diceobj->probability(8004),2.1416130065918e-05);
ok($diceobj->probability(8005),2.85548400878906e-05);
ok($diceobj->probability(8006),3.72151056925456e-05);
ok($diceobj->probability(8007),4.58753712972005e-05);
ok($diceobj->probability(8008),4.02582168579102e-05);
ok($diceobj->probability(8009),3.46410624186198e-05);
ok($diceobj->probability(8010),4.15801747639974e-05);
ok($diceobj->probability(8011),4.8519287109375e-05);
ok($diceobj->probability(8012),5.2415288289388e-05);
ok($diceobj->probability(8013),5.6311289469401e-05);
ok($diceobj->probability(8014),6.73460006713867e-05);
ok($diceobj->probability(8015),7.83807118733724e-05);
ok($diceobj->probability(8016),6.43028895060221e-05);
ok($diceobj->probability(8017),5.02250671386719e-05);
ok($diceobj->probability(8018),3.76688003540039e-05);
ok($diceobj->probability(8019),2.51125335693359e-05);
ok($diceobj->probability(8020),1.2556266784668e-05);
ok($diceobj->probability(8021),6.35147094726563e-07);
ok($diceobj->probability(8022),1.27029418945313e-06);
ok($diceobj->probability(8023),1.90544128417969e-06);
ok($diceobj->probability(8024),2.54058837890625e-06);
ok($diceobj->probability(8025),3.17573547363281e-06);
ok($diceobj->probability(8026),3.81088256835937e-06);
ok($diceobj->probability(8027),3.17573547363281e-06);
ok($diceobj->probability(8028),2.54058837890625e-06);
ok($diceobj->probability(8029),1.90544128417969e-06);
ok($diceobj->probability(8030),1.27029418945313e-06);
ok($diceobj->probability(8031),6.35147094726563e-07);
ok($diceobj->probability(8052),8.86459350585937e-06);
ok($diceobj->probability(8053),1.77291870117187e-05);
ok($diceobj->probability(8054),2.65937805175781e-05);
ok($diceobj->probability(8055),3.54583740234375e-05);
ok($diceobj->probability(8056),4.43229675292969e-05);
ok($diceobj->probability(8057),5.31875610351563e-05);
ok($diceobj->probability(8058),4.43229675292969e-05);
ok($diceobj->probability(8059),3.54583740234375e-05);
ok($diceobj->probability(8060),2.65937805175781e-05);
ok($diceobj->probability(8061),1.77291870117187e-05);
ok($diceobj->probability(8062),9.10498301188151e-06);
ok($diceobj->probability(8063),4.80779012044271e-07);
ok($diceobj->probability(8064),7.21168518066406e-07);
ok($diceobj->probability(8065),9.61558024088542e-07);
ok($diceobj->probability(8066),1.8993165757921e-05);
ok($diceobj->probability(8067),3.70247734917535e-05);
ok($diceobj->probability(8068),5.45756022135417e-05);
ok($diceobj->probability(8069),7.21264309353299e-05);
ok($diceobj->probability(8070),8.96772596571181e-05);
ok($diceobj->probability(8071),0.000107228088378906);
ok($diceobj->probability(8072),8.91964806450738e-05);
ok($diceobj->probability(8073),7.11648729112413e-05);
ok($diceobj->probability(8074),5.3373654683431e-05);
ok($diceobj->probability(8075),4.0520265367296e-05);
ok($diceobj->probability(8076),2.7666876051161e-05);
ok($diceobj->probability(8077),1.93790435791016e-05);
ok($diceobj->probability(8078),2.88824293348524e-05);
ok($diceobj->probability(8079),3.83858150906033e-05);
ok($diceobj->probability(8080),4.78892008463542e-05);
ok($diceobj->probability(8081),4.75169287787543e-05);
ok($diceobj->probability(8082),4.71446567111545e-05);
ok($diceobj->probability(8083),3.76412709554036e-05);
ok($diceobj->probability(8084),2.81378851996528e-05);
ok($diceobj->probability(8085),1.86344994439019e-05);
ok($diceobj->probability(8086),9.13111368815104e-06);
ok($diceobj->probability(8087),4.56555684407552e-06);
ok($diceobj->probability(8093),4.13258870442708e-09);
ok($diceobj->probability(8094),1.2112299601237e-06);
ok($diceobj->probability(8095),2.41832733154297e-06);
ok($diceobj->probability(8096),3.62542470296224e-06);
ok($diceobj->probability(8097),4.83252207438151e-06);
ok($diceobj->probability(8098),1.45303726196289e-05);
ok($diceobj->probability(8099),2.42199579874674e-05);
ok($diceobj->probability(8100),3.15036137898763e-05);
ok($diceobj->probability(8101),3.87872695922852e-05);
ok($diceobj->probability(8102),5.69999482896593e-05);
ok($diceobj->probability(8103),7.52126269870334e-05);
ok($diceobj->probability(8104),7.64437993367513e-05);
ok($diceobj->probability(8105),7.76791042751736e-05);
ok($diceobj->probability(8106),8.01173739963108e-05);
ok($diceobj->probability(8107),8.25556437174479e-05);
ok($diceobj->probability(8108),6.31358676486545e-05);
ok($diceobj->probability(8109),4.37160915798611e-05);
ok($diceobj->probability(8110),3.27870686848958e-05);
ok($diceobj->probability(8111),2.18580457899306e-05);
ok($diceobj->probability(8112),1.09290228949653e-05);
ok($diceobj->probability(8114),7.49937693277995e-06);
ok($diceobj->probability(8115),1.49987538655599e-05);
ok($diceobj->probability(8116),2.24981307983398e-05);
ok($diceobj->probability(8117),2.99975077311198e-05);
ok($diceobj->probability(8118),3.74968846638997e-05);
ok($diceobj->probability(8119),4.49962615966797e-05);
ok($diceobj->probability(8120),3.74968846638997e-05);
ok($diceobj->probability(8121),2.99975077311198e-05);
ok($diceobj->probability(8122),2.48328399658203e-05);
ok($diceobj->probability(8123),1.96681722005208e-05);
ok($diceobj->probability(8124),1.45035044352214e-05);
ok($diceobj->probability(8125),9.33883666992187e-06);
ok($diceobj->probability(8126),1.16735458374023e-05);
ok($diceobj->probability(8127),1.71124649047852e-05);
ok($diceobj->probability(8128),1.7881965637207e-05);
ok($diceobj->probability(8129),1.86514663696289e-05);
ok($diceobj->probability(8130),1.94209671020508e-05);
ok($diceobj->probability(8131),2.01904678344727e-05);
ok($diceobj->probability(8132),2.09599685668945e-05);
ok($diceobj->probability(8133),1.55210494995117e-05);
ok($diceobj->probability(8134),1.24168395996094e-05);
ok($diceobj->probability(8135),9.31262969970703e-06);
ok($diceobj->probability(8136),6.20841979980469e-06);
ok($diceobj->probability(8137),3.10420989990234e-06);
ok($diceobj->probability(8162),5.71035597059462e-06);
ok($diceobj->probability(8163),1.14207119411892e-05);
ok($diceobj->probability(8164),1.71310679117839e-05);
ok($diceobj->probability(8165),2.28414238823785e-05);
ok($diceobj->probability(8166),2.85517798529731e-05);
ok($diceobj->probability(8167),3.42621358235677e-05);
ok($diceobj->probability(8168),2.85517798529731e-05);
ok($diceobj->probability(8169),2.28414238823785e-05);
ok($diceobj->probability(8170),1.71310679117839e-05);
ok($diceobj->probability(8171),1.14207119411892e-05);
ok($diceobj->probability(8172),5.71035597059462e-06);
ok($diceobj->probability(8186),2.27928161621094e-07);
ok($diceobj->probability(8187),4.55856323242187e-07);
ok($diceobj->probability(8188),6.83784484863281e-07);
ok($diceobj->probability(8189),9.11712646484375e-07);
ok($diceobj->probability(8190),1.13964080810547e-06);
ok($diceobj->probability(8191),1.36756896972656e-06);
ok($diceobj->probability(8192),8.89343685574002e-06);
ok($diceobj->probability(8193),1.64193047417535e-05);
ok($diceobj->probability(8194),2.39658355712891e-05);
ok($diceobj->probability(8195),3.15123664008247e-05);
ok($diceobj->probability(8196),3.90588972303602e-05);
ok($diceobj->probability(8197),4.66054280598958e-05);
ok($diceobj->probability(8198),3.88722949557834e-05);
ok($diceobj->probability(8199),3.1139161851671e-05);
ok($diceobj->probability(8200),2.33647028605143e-05);
ok($diceobj->probability(8201),1.55902438693576e-05);
ok($diceobj->probability(8202),7.81578487820095e-06);
ok($diceobj->probability(8203),4.13258870442708e-08);
ok($diceobj->probability(8204),2.06629435221354e-08);
ok($diceobj->probability(8210),6.85433281792535e-06);
ok($diceobj->probability(8211),1.37086656358507e-05);
ok($diceobj->probability(8212),2.0562998453776e-05);
ok($diceobj->probability(8213),3.27994452582465e-05);
ok($diceobj->probability(8214),4.5035892062717e-05);
ok($diceobj->probability(8215),5.72723388671875e-05);
ok($diceobj->probability(8216),5.58001200358073e-05);
ok($diceobj->probability(8217),5.43279012044271e-05);
ok($diceobj->probability(8218),5.28556823730469e-05);
ok($diceobj->probability(8219),4.06192355685764e-05);
ok($diceobj->probability(8220),2.83827887641059e-05);
ok($diceobj->probability(8221),1.61463419596354e-05);
ok($diceobj->probability(8222),1.07642279730903e-05);
ok($diceobj->probability(8223),5.38211398654514e-06);
ok($diceobj->probability(8230),2.76374816894531e-06);
ok($diceobj->probability(8231),5.52749633789063e-06);
ok($diceobj->probability(8232),8.29124450683594e-06);
ok($diceobj->probability(8233),1.10549926757813e-05);
ok($diceobj->probability(8234),1.75409317016602e-05);
ok($diceobj->probability(8235),2.40268707275391e-05);
ok($diceobj->probability(8236),2.49853134155273e-05);
ok($diceobj->probability(8237),2.59437561035156e-05);
ok($diceobj->probability(8238),2.69021987915039e-05);
ok($diceobj->probability(8239),2.78606414794922e-05);
ok($diceobj->probability(8240),2.13747024536133e-05);
ok($diceobj->probability(8241),1.48887634277344e-05);
ok($diceobj->probability(8242),1.11665725708008e-05);
ok($diceobj->probability(8243),7.44438171386719e-06);
ok($diceobj->probability(8244),3.72219085693359e-06);
ok($diceobj->probability(8248),2.04722086588542e-07);
ok($diceobj->probability(8249),4.09444173177083e-07);
ok($diceobj->probability(8250),6.14166259765625e-07);
ok($diceobj->probability(8251),8.18888346354167e-07);
ok($diceobj->probability(8252),9.38889821370443e-06);
ok($diceobj->probability(8253),1.79589080810547e-05);
ok($diceobj->probability(8254),2.61194737752279e-05);
ok($diceobj->probability(8255),3.4280039469401e-05);
ok($diceobj->probability(8256),4.24406051635742e-05);
ok($diceobj->probability(8257),5.06011708577474e-05);
ok($diceobj->probability(8258),4.20311609903971e-05);
ok($diceobj->probability(8259),3.34611511230469e-05);
ok($diceobj->probability(8260),2.50958633422852e-05);
ok($diceobj->probability(8261),1.67305755615234e-05);
ok($diceobj->probability(8262),8.36528778076172e-06);
ok($diceobj->probability(8264),2.85627577039931e-06);
ok($diceobj->probability(8265),5.71255154079861e-06);
ok($diceobj->probability(8266),8.56882731119792e-06);
ok($diceobj->probability(8267),1.32303619384766e-05);
ok($diceobj->probability(8268),1.78918965657552e-05);
ok($diceobj->probability(8269),2.25534311930339e-05);
ok($diceobj->probability(8270),2.15024142795139e-05);
ok($diceobj->probability(8271),2.04513973659939e-05);
ok($diceobj->probability(8272),1.9400380452474e-05);
ok($diceobj->probability(8273),1.47388458251953e-05);
ok($diceobj->probability(8274),1.00773111979167e-05);
ok($diceobj->probability(8275),5.41577657063802e-06);
ok($diceobj->probability(8276),3.61051771375868e-06);
ok($diceobj->probability(8277),1.80525885687934e-06);
ok($diceobj->probability(8282),1.20211622450087e-05);
ok($diceobj->probability(8283),2.40423244900174e-05);
ok($diceobj->probability(8284),3.6063486735026e-05);
ok($diceobj->probability(8285),4.80846489800347e-05);
ok($diceobj->probability(8286),6.01058112250434e-05);
ok($diceobj->probability(8287),7.21269734700521e-05);
ok($diceobj->probability(8288),6.01058112250434e-05);
ok($diceobj->probability(8289),4.80846489800347e-05);
ok($diceobj->probability(8290),3.6063486735026e-05);
ok($diceobj->probability(8291),2.40423244900174e-05);
ok($diceobj->probability(8292),1.20211622450087e-05);
ok($diceobj->probability(8296),2.43434906005859e-06);
ok($diceobj->probability(8297),4.86869812011719e-06);
ok($diceobj->probability(8298),7.30304718017578e-06);
ok($diceobj->probability(8299),9.73739624023437e-06);
ok($diceobj->probability(8300),1.2171745300293e-05);
ok($diceobj->probability(8301),1.46060943603516e-05);
ok($diceobj->probability(8302),1.2171745300293e-05);
ok($diceobj->probability(8303),9.73739624023437e-06);
ok($diceobj->probability(8304),7.30304718017578e-06);
ok($diceobj->probability(8305),5.79388936360677e-06);
ok($diceobj->probability(8306),4.28473154703776e-06);
ok($diceobj->probability(8307),2.77557373046875e-06);
ok($diceobj->probability(8308),3.70076497395833e-06);
ok($diceobj->probability(8309),4.62595621744792e-06);
ok($diceobj->probability(8310),5.5511474609375e-06);
ok($diceobj->probability(8311),4.62595621744792e-06);
ok($diceobj->probability(8312),3.70076497395833e-06);
ok($diceobj->probability(8313),2.77557373046875e-06);
ok($diceobj->probability(8314),1.85038248697917e-06);
ok($diceobj->probability(8315),9.25191243489583e-07);
ok($diceobj->probability(8318),8.78391265869141e-06);
ok($diceobj->probability(8319),1.75678253173828e-05);
ok($diceobj->probability(8320),2.63517379760742e-05);
ok($diceobj->probability(8321),3.51356506347656e-05);
ok($diceobj->probability(8322),4.90380096435547e-05);
ok($diceobj->probability(8323),6.29403686523437e-05);
ok($diceobj->probability(8324),5.927490234375e-05);
ok($diceobj->probability(8325),5.56094360351563e-05);
ok($diceobj->probability(8326),5.19439697265625e-05);
ok($diceobj->probability(8327),4.82785034179688e-05);
ok($diceobj->probability(8328),3.43761444091797e-05);
ok($diceobj->probability(8329),2.04737854003906e-05);
ok($diceobj->probability(8330),1.5355339050293e-05);
ok($diceobj->probability(8331),1.02368927001953e-05);
ok($diceobj->probability(8332),5.11844635009766e-06);
ok($diceobj->probability(8354),2.61741214328342e-06);
ok($diceobj->probability(8355),5.23482428656684e-06);
ok($diceobj->probability(8356),7.85223642985026e-06);
ok($diceobj->probability(8357),1.04696485731337e-05);
ok($diceobj->probability(8358),1.30870607164171e-05);
ok($diceobj->probability(8359),1.57044728597005e-05);
ok($diceobj->probability(8360),1.30870607164171e-05);
ok($diceobj->probability(8361),1.04696485731337e-05);
ok($diceobj->probability(8362),9.11886850992839e-06);
ok($diceobj->probability(8363),7.76808844672309e-06);
ok($diceobj->probability(8364),6.4173083835178e-06);
ok($diceobj->probability(8365),5.0665283203125e-06);
ok($diceobj->probability(8366),6.33316040039062e-06);
ok($diceobj->probability(8367),7.59979248046875e-06);
ok($diceobj->probability(8368),6.33316040039062e-06);
ok($diceobj->probability(8369),5.0665283203125e-06);
ok($diceobj->probability(8370),3.79989624023438e-06);
ok($diceobj->probability(8371),2.53326416015625e-06);
ok($diceobj->probability(8372),1.46887461344401e-06);
ok($diceobj->probability(8373),4.04485066731771e-07);
ok($diceobj->probability(8374),9.99902089436849e-06);
ok($diceobj->probability(8375),1.95935567220052e-05);
ok($diceobj->probability(8376),2.91880925496419e-05);
ok($diceobj->probability(8377),3.87826283772786e-05);
ok($diceobj->probability(8378),4.79726791381836e-05);
ok($diceobj->probability(8379),5.71627298990885e-05);
ok($diceobj->probability(8380),4.75681940714518e-05);
ok($diceobj->probability(8381),3.8521491156684e-05);
ok($diceobj->probability(8382),2.94747882419162e-05);
ok($diceobj->probability(8383),2.1046257019043e-05);
ok($diceobj->probability(8384),1.28199683295356e-05);
ok($diceobj->probability(8385),4.59367964002821e-06);
ok($diceobj->probability(8386),5.75968424479167e-06);
ok($diceobj->probability(8387),5.83002302381727e-06);
ok($diceobj->probability(8388),5.90036180284288e-06);
ok($diceobj->probability(8389),4.73435719807943e-06);
ok($diceobj->probability(8390),3.56835259331597e-06);
ok($diceobj->probability(8391),2.40234798855252e-06);
ok($diceobj->probability(8392),1.23634338378906e-06);
ok($diceobj->probability(8393),6.18171691894531e-07);
ok($diceobj->probability(8400),3.3117930094401e-06);
ok($diceobj->probability(8401),6.62358601888021e-06);
ok($diceobj->probability(8402),2.92526202731662e-05);
ok($diceobj->probability(8403),5.18816545274523e-05);
ok($diceobj->probability(8404),7.45106887817383e-05);
ok($diceobj->probability(8405),9.71397230360243e-05);
ok($diceobj->probability(8406),0.00011314517127143);
ok($diceobj->probability(8407),0.000129150619506836);
ok($diceobj->probability(8408),0.00010652158525255);
ok($diceobj->probability(8409),8.38925509982639e-05);
ok($diceobj->probability(8410),6.12635167439779e-05);
ok($diceobj->probability(8411),3.86344824896918e-05);
ok($diceobj->probability(8412),1.93621910942925e-05);
ok($diceobj->probability(8413),8.98996988932292e-08);
ok($diceobj->probability(8414),1.34849548339844e-07);
ok($diceobj->probability(8415),1.79799397786458e-07);
ok($diceobj->probability(8416),2.24749247233073e-07);
ok($diceobj->probability(8417),2.69699096679687e-07);
ok($diceobj->probability(8418),2.24749247233073e-07);
ok($diceobj->probability(8419),1.79799397786458e-07);
ok($diceobj->probability(8420),1.34849548339844e-07);
ok($diceobj->probability(8421),8.98996988932292e-08);
ok($diceobj->probability(8422),4.49498494466146e-08);
ok($diceobj->probability(8426),7.3907216389974e-06);
ok($diceobj->probability(8427),1.47814432779948e-05);
ok($diceobj->probability(8428),2.21721649169922e-05);
ok($diceobj->probability(8429),2.95628865559896e-05);
ok($diceobj->probability(8430),3.6953608194987e-05);
ok($diceobj->probability(8431),4.43443298339844e-05);
ok($diceobj->probability(8432),3.6953608194987e-05);
ok($diceobj->probability(8433),2.95628865559896e-05);
ok($diceobj->probability(8434),2.23311106363932e-05);
ok($diceobj->probability(8435),1.50993347167969e-05);
ok($diceobj->probability(8436),7.86755879720052e-06);
ok($diceobj->probability(8437),6.35782877604167e-07);
ok($diceobj->probability(8438),7.94728597005208e-07);
ok($diceobj->probability(8439),9.5367431640625e-07);
ok($diceobj->probability(8440),7.94728597005208e-07);
ok($diceobj->probability(8441),6.35782877604167e-07);
ok($diceobj->probability(8442),4.76837158203125e-07);
ok($diceobj->probability(8443),3.17891438802083e-07);
ok($diceobj->probability(8444),1.58945719401042e-07);
ok($diceobj->probability(8450),6.80980682373047e-06);
ok($diceobj->probability(8451),1.36196136474609e-05);
ok($diceobj->probability(8452),2.49231338500977e-05);
ok($diceobj->probability(8453),3.62266540527344e-05);
ok($diceobj->probability(8454),4.75301742553711e-05);
ok($diceobj->probability(8455),5.88336944580078e-05);
ok($diceobj->probability(8456),5.65176010131836e-05);
ok($diceobj->probability(8457),5.42015075683594e-05);
ok($diceobj->probability(8458),4.28979873657227e-05);
ok($diceobj->probability(8459),3.15944671630859e-05);
ok($diceobj->probability(8460),2.02909469604492e-05);
ok($diceobj->probability(8461),8.9874267578125e-06);
ok($diceobj->probability(8462),4.49371337890625e-06);
ok($diceobj->probability(8465),1.80668301052517e-07);
ok($diceobj->probability(8466),3.85254753960503e-06);
ok($diceobj->probability(8467),7.52442677815755e-06);
ok($diceobj->probability(8468),1.11963060167101e-05);
ok($diceobj->probability(8469),1.48681852552626e-05);
ok($diceobj->probability(8470),1.85400644938151e-05);
ok($diceobj->probability(8471),2.18506071302626e-05);
ok($diceobj->probability(8472),1.81787278917101e-05);
ok($diceobj->probability(8473),1.45068486531576e-05);
ok($diceobj->probability(8474),1.0834969414605e-05);
ok($diceobj->probability(8475),7.16309017605252e-06);
ok($diceobj->probability(8476),3.4912109375e-06);
ok($diceobj->probability(8502),3.8214111328125e-06);
ok($diceobj->probability(8503),7.642822265625e-06);
ok($diceobj->probability(8504),1.14642333984375e-05);
ok($diceobj->probability(8505),1.528564453125e-05);
ok($diceobj->probability(8506),1.91070556640625e-05);
ok($diceobj->probability(8507),2.75540203518338e-05);
ok($diceobj->probability(8508),2.835816277398e-05);
ok($diceobj->probability(8509),2.91623051961263e-05);
ok($diceobj->probability(8510),2.99664476182726e-05);
ok($diceobj->probability(8511),3.07705900404188e-05);
ok($diceobj->probability(8512),3.15747324625651e-05);
ok($diceobj->probability(8513),2.31277677747938e-05);
ok($diceobj->probability(8514),2.08724127875434e-05);
ok($diceobj->probability(8515),1.8617057800293e-05);
ok($diceobj->probability(8516),1.63617028130425e-05);
ok($diceobj->probability(8517),1.41063478257921e-05);
ok($diceobj->probability(8518),1.18509928385417e-05);
ok($diceobj->probability(8519),1.422119140625e-05);
ok($diceobj->probability(8520),1.18509928385417e-05);
ok($diceobj->probability(8521),9.48079427083333e-06);
ok($diceobj->probability(8522),7.110595703125e-06);
ok($diceobj->probability(8523),4.74039713541667e-06);
ok($diceobj->probability(8524),2.37019856770833e-06);
ok($diceobj->probability(8527),6.00814819335938e-08);
ok($diceobj->probability(8528),2.02846527099609e-06);
ok($diceobj->probability(8529),3.99684906005859e-06);
ok($diceobj->probability(8530),5.96523284912109e-06);
ok($diceobj->probability(8531),7.93361663818359e-06);
ok($diceobj->probability(8532),9.90200042724609e-06);
ok($diceobj->probability(8533),1.17502212524414e-05);
ok($diceobj->probability(8534),9.78183746337891e-06);
ok($diceobj->probability(8535),7.81345367431641e-06);
ok($diceobj->probability(8536),5.84506988525391e-06);
ok($diceobj->probability(8537),3.87668609619141e-06);
ok($diceobj->probability(8538),1.90830230712891e-06);
ok($diceobj->probability(8552),2.99825880262587e-06);
ok($diceobj->probability(8553),5.99651760525174e-06);
ok($diceobj->probability(8554),8.9947764078776e-06);
ok($diceobj->probability(8555),1.19930352105035e-05);
ok($diceobj->probability(8556),1.49912940131293e-05);
ok($diceobj->probability(8557),1.79895528157552e-05);
ok($diceobj->probability(8558),1.51095496283637e-05);
ok($diceobj->probability(8559),1.22295464409722e-05);
ok($diceobj->probability(8560),9.34954325358073e-06);
ok($diceobj->probability(8561),6.46954006618924e-06);
ok($diceobj->probability(8562),3.58953687879774e-06);
ok($diceobj->probability(8563),7.0953369140625e-07);
ok($diceobj->probability(8564),5.91278076171875e-07);
ok($diceobj->probability(8565),4.730224609375e-07);
ok($diceobj->probability(8566),3.54766845703125e-07);
ok($diceobj->probability(8567),2.3651123046875e-07);
ok($diceobj->probability(8568),1.18255615234375e-07);
ok($diceobj->probability(8570),6.02213541666667e-06);
ok($diceobj->probability(8571),1.20442708333333e-05);
ok($diceobj->probability(8572),1.806640625e-05);
ok($diceobj->probability(8573),2.40885416666667e-05);
ok($diceobj->probability(8574),3.01106770833333e-05);
ok($diceobj->probability(8575),3.61328125e-05);
ok($diceobj->probability(8576),3.01106770833333e-05);
ok($diceobj->probability(8577),2.40885416666667e-05);
ok($diceobj->probability(8578),1.806640625e-05);
ok($diceobj->probability(8579),1.20442708333333e-05);
ok($diceobj->probability(8580),6.02213541666667e-06);
ok($diceobj->probability(8582),6.77566528320313e-06);
ok($diceobj->probability(8583),1.35513305664063e-05);
ok($diceobj->probability(8584),2.03269958496094e-05);
ok($diceobj->probability(8585),2.71026611328125e-05);
ok($diceobj->probability(8586),3.38783264160156e-05);
ok($diceobj->probability(8587),4.06539916992187e-05);
ok($diceobj->probability(8588),3.38783264160156e-05);
ok($diceobj->probability(8589),2.71026611328125e-05);
ok($diceobj->probability(8590),2.03269958496094e-05);
ok($diceobj->probability(8591),1.35513305664063e-05);
ok($diceobj->probability(8592),6.77566528320313e-06);
ok($diceobj->probability(8604),4.56085205078125e-06);
ok($diceobj->probability(8605),9.1217041015625e-06);
ok($diceobj->probability(8606),1.36825561523438e-05);
ok($diceobj->probability(8607),1.8243408203125e-05);
ok($diceobj->probability(8608),2.28042602539062e-05);
ok($diceobj->probability(8609),2.73651123046875e-05);
ok($diceobj->probability(8610),2.28042602539062e-05);
ok($diceobj->probability(8611),1.8243408203125e-05);
ok($diceobj->probability(8612),1.36825561523438e-05);
ok($diceobj->probability(8613),9.1217041015625e-06);
ok($diceobj->probability(8614),4.56085205078125e-06);
ok($diceobj->probability(8615),3.90815734863281e-07);
ok($diceobj->probability(8616),7.81631469726562e-07);
ok($diceobj->probability(8617),1.17244720458984e-06);
ok($diceobj->probability(8618),1.56326293945312e-06);
ok($diceobj->probability(8619),1.95407867431641e-06);
ok($diceobj->probability(8620),2.34489440917969e-06);
ok($diceobj->probability(8621),1.95407867431641e-06);
ok($diceobj->probability(8622),1.56326293945312e-06);
ok($diceobj->probability(8623),1.17244720458984e-06);
ok($diceobj->probability(8624),7.81631469726562e-07);
ok($diceobj->probability(8625),3.90815734863281e-07);
ok($diceobj->probability(8626),3.37657928466797e-06);
ok($diceobj->probability(8627),1.33851877848307e-05);
ok($diceobj->probability(8628),2.33937962849935e-05);
ok($diceobj->probability(8629),3.34024047851563e-05);
ok($diceobj->probability(8630),4.3411013285319e-05);
ok($diceobj->probability(8631),5.34196217854818e-05);
ok($diceobj->probability(8632),5.66750717163086e-05);
ok($diceobj->probability(8633),4.66664632161458e-05);
ok($diceobj->probability(8634),3.66578547159831e-05);
ok($diceobj->probability(8635),2.66492462158203e-05);
ok($diceobj->probability(8636),1.66406377156576e-05);
ok($diceobj->probability(8637),6.63202921549479e-06);
ok($diceobj->probability(8642),1.01285086737739e-05);
ok($diceobj->probability(8643),2.02570173475477e-05);
ok($diceobj->probability(8644),3.03855260213216e-05);
ok($diceobj->probability(8645),4.05140346950955e-05);
ok($diceobj->probability(8646),5.06425433688694e-05);
ok($diceobj->probability(8647),6.07710520426432e-05);
ok($diceobj->probability(8648),5.06425433688694e-05);
ok($diceobj->probability(8649),4.05140346950955e-05);
ok($diceobj->probability(8650),3.03855260213216e-05);
ok($diceobj->probability(8651),2.02570173475477e-05);
ok($diceobj->probability(8652),1.01285086737739e-05);
ok($diceobj->probability(8666),7.40390353732639e-07);
ok($diceobj->probability(8667),1.48078070746528e-06);
ok($diceobj->probability(8668),2.22117106119792e-06);
ok($diceobj->probability(8669),2.96156141493056e-06);
ok($diceobj->probability(8670),3.70195176866319e-06);
ok($diceobj->probability(8671),4.44234212239583e-06);
ok($diceobj->probability(8672),3.94509633382161e-06);
ok($diceobj->probability(8673),4.96940612792969e-06);
ok($diceobj->probability(8674),5.99371592203776e-06);
ok($diceobj->probability(8675),7.01802571614583e-06);
ok($diceobj->probability(8676),8.04233551025391e-06);
ok($diceobj->probability(8677),9.06664530436198e-06);
ok($diceobj->probability(8678),1.03450563218859e-05);
ok($diceobj->probability(8679),8.58035617404514e-06);
ok($diceobj->probability(8680),6.81565602620443e-06);
ok($diceobj->probability(8681),5.05095587836371e-06);
ok($diceobj->probability(8682),3.48080529106988e-06);
ok($diceobj->probability(8683),1.91065470377604e-06);
ok($diceobj->probability(8684),5.83648681640625e-07);
ok($diceobj->probability(8685),7.781982421875e-07);
ok($diceobj->probability(8686),9.72747802734375e-07);
ok($diceobj->probability(8687),1.16729736328125e-06);
ok($diceobj->probability(8688),9.72747802734375e-07);
ok($diceobj->probability(8689),7.781982421875e-07);
ok($diceobj->probability(8690),5.83648681640625e-07);
ok($diceobj->probability(8691),3.8909912109375e-07);
ok($diceobj->probability(8692),1.94549560546875e-07);
ok($diceobj->probability(8696),6.60730997721354e-06);
ok($diceobj->probability(8697),1.32146199544271e-05);
ok($diceobj->probability(8698),1.98219299316406e-05);
ok($diceobj->probability(8699),2.64292399088542e-05);
ok($diceobj->probability(8700),3.30365498860677e-05);
ok($diceobj->probability(8701),3.96438598632813e-05);
ok($diceobj->probability(8702),3.56172943115234e-05);
ok($diceobj->probability(8703),3.15907287597656e-05);
ok($diceobj->probability(8704),2.75641632080078e-05);
ok($diceobj->probability(8705),2.353759765625e-05);
ok($diceobj->probability(8706),1.95428212483724e-05);
ok($diceobj->probability(8707),1.55480448404948e-05);
ok($diceobj->probability(8708),1.29990895589193e-05);
ok($diceobj->probability(8709),1.04501342773438e-05);
ok($diceobj->probability(8710),7.90117899576823e-06);
ok($diceobj->probability(8711),5.35222371419271e-06);
ok($diceobj->probability(8712),2.73969014485677e-06);
ok($diceobj->probability(8713),1.27156575520833e-07);
ok($diceobj->probability(8714),1.27983093261719e-06);
ok($diceobj->probability(8715),2.43250528971354e-06);
ok($diceobj->probability(8716),3.5851796468099e-06);
ok($diceobj->probability(8717),4.73785400390625e-06);
ok($diceobj->probability(8718),5.92231750488281e-06);
ok($diceobj->probability(8719),7.10678100585937e-06);
ok($diceobj->probability(8720),5.92231750488281e-06);
ok($diceobj->probability(8721),4.73785400390625e-06);
ok($diceobj->probability(8722),3.55339050292969e-06);
ok($diceobj->probability(8723),4.58861456976997e-06);
ok($diceobj->probability(8724),5.62383863661024e-06);
ok($diceobj->probability(8725),6.65906270345052e-06);
ok($diceobj->probability(8726),8.87875027126736e-06);
ok($diceobj->probability(8727),1.10984378390842e-05);
ok($diceobj->probability(8728),1.3318125406901e-05);
ok($diceobj->probability(8729),1.10984378390842e-05);
ok($diceobj->probability(8730),8.87875027126736e-06);
ok($diceobj->probability(8731),6.65906270345052e-06);
ok($diceobj->probability(8732),4.43937513563368e-06);
ok($diceobj->probability(8733),2.21968756781684e-06);
ok($diceobj->probability(8738),1.3272582160102e-05);
ok($diceobj->probability(8739),2.6545164320204e-05);
ok($diceobj->probability(8740),3.9817746480306e-05);
ok($diceobj->probability(8741),5.3090328640408e-05);
ok($diceobj->probability(8742),6.74100706312391e-05);
ok($diceobj->probability(8743),8.17298126220703e-05);
ok($diceobj->probability(8744),6.95043902926975e-05);
ok($diceobj->probability(8745),5.72789679633246e-05);
ok($diceobj->probability(8746),4.50535456339518e-05);
ok($diceobj->probability(8747),3.2828123304579e-05);
ok($diceobj->probability(8748),1.85083813137478e-05);
ok($diceobj->probability(8749),4.18863932291667e-06);
ok($diceobj->probability(8750),4.72794850667318e-06);
ok($diceobj->probability(8751),5.26725769042969e-06);
ok($diceobj->probability(8752),8.51023356119792e-06);
ok($diceobj->probability(8753),1.17532094319661e-05);
ok($diceobj->probability(8754),1.60433451334635e-05);
ok($diceobj->probability(8755),2.03334808349609e-05);
ok($diceobj->probability(8756),2.1450678507487e-05);
ok($diceobj->probability(8757),2.2567876180013e-05);
ok($diceobj->probability(8758),1.82777404785156e-05);
ok($diceobj->probability(8759),1.39876047770182e-05);
ok($diceobj->probability(8760),9.69746907552083e-06);
ok($diceobj->probability(8761),5.40733337402344e-06);
ok($diceobj->probability(8762),2.70366668701172e-06);
ok($diceobj->probability(8777),3.00960540771484e-06);
ok($diceobj->probability(8778),6.01921081542969e-06);
ok($diceobj->probability(8779),9.02881622314453e-06);
ok($diceobj->probability(8780),1.29692077636719e-05);
ok($diceobj->probability(8781),1.69095993041992e-05);
ok($diceobj->probability(8782),2.08499908447266e-05);
ok($diceobj->probability(8783),1.87711715698242e-05);
ok($diceobj->probability(8784),1.66923522949219e-05);
ok($diceobj->probability(8785),1.46135330200195e-05);
ok($diceobj->probability(8786),1.06731414794922e-05);
ok($diceobj->probability(8787),6.73274993896484e-06);
ok($diceobj->probability(8788),2.7923583984375e-06);
ok($diceobj->probability(8789),1.861572265625e-06);
ok($diceobj->probability(8790),2.55680084228516e-06);
ok($diceobj->probability(8791),3.25202941894531e-06);
ok($diceobj->probability(8792),4.87804412841797e-06);
ok($diceobj->probability(8793),6.50405883789063e-06);
ok($diceobj->probability(8794),8.13007354736328e-06);
ok($diceobj->probability(8795),9.75608825683594e-06);
ok($diceobj->probability(8796),8.13007354736328e-06);
ok($diceobj->probability(8797),6.50405883789063e-06);
ok($diceobj->probability(8798),4.87804412841797e-06);
ok($diceobj->probability(8799),3.25202941894531e-06);
ok($diceobj->probability(8800),1.62601470947266e-06);
ok($diceobj->probability(8802),5.40534973144531e-06);
ok($diceobj->probability(8803),1.08106994628906e-05);
ok($diceobj->probability(8804),1.62160491943359e-05);
ok($diceobj->probability(8805),2.16213989257812e-05);
ok($diceobj->probability(8806),2.70267486572266e-05);
ok($diceobj->probability(8807),3.24320983886719e-05);
ok($diceobj->probability(8808),2.70267486572266e-05);
ok($diceobj->probability(8809),2.16213989257812e-05);
ok($diceobj->probability(8810),1.62160491943359e-05);
ok($diceobj->probability(8811),1.08106994628906e-05);
ok($diceobj->probability(8812),5.40534973144531e-06);
ok($diceobj->probability(8818),1.19552612304688e-06);
ok($diceobj->probability(8819),2.39105224609375e-06);
ok($diceobj->probability(8820),3.58657836914063e-06);
ok($diceobj->probability(8821),4.7821044921875e-06);
ok($diceobj->probability(8822),9.61295233832465e-06);
ok($diceobj->probability(8823),1.44438001844618e-05);
ok($diceobj->probability(8824),1.68835957845052e-05);
ok($diceobj->probability(8825),1.93233913845486e-05);
ok($diceobj->probability(8826),2.1763186984592e-05);
ok($diceobj->probability(8827),2.42029825846354e-05);
ok($diceobj->probability(8828),1.93721347384983e-05);
ok($diceobj->probability(8829),1.45412868923611e-05);
ok($diceobj->probability(8830),1.09059651692708e-05);
ok($diceobj->probability(8831),7.27064344618056e-06);
ok($diceobj->probability(8832),3.63532172309028e-06);
ok($diceobj->probability(8834),5.5954827202691e-06);
ok($diceobj->probability(8835),1.11909654405382e-05);
ok($diceobj->probability(8836),1.67864481608073e-05);
ok($diceobj->probability(8837),2.2537358601888e-05);
ok($diceobj->probability(8838),2.82882690429688e-05);
ok($diceobj->probability(8839),3.40391794840495e-05);
ok($diceobj->probability(8840),2.8599124484592e-05);
ok($diceobj->probability(8841),2.31590694851345e-05);
ok($diceobj->probability(8842),2.04900105794271e-05);
ok($diceobj->probability(8843),1.75100962320964e-05);
ok($diceobj->probability(8844),1.45301818847656e-05);
ok($diceobj->probability(8845),1.15502675374349e-05);
ok($diceobj->probability(8846),1.41658359103733e-05);
ok($diceobj->probability(8847),1.67814042833116e-05);
ok($diceobj->probability(8848),1.385498046875e-05);
ok($diceobj->probability(8849),1.1083984375e-05);
ok($diceobj->probability(8850),8.31298828125e-06);
ok($diceobj->probability(8851),5.5419921875e-06);
ok($diceobj->probability(8852),2.77099609375e-06);
ok($diceobj->probability(8868),1.9073486328125e-07);
ok($diceobj->probability(8869),3.814697265625e-07);
ok($diceobj->probability(8870),5.7220458984375e-07);
ok($diceobj->probability(8871),7.62939453125e-07);
ok($diceobj->probability(8872),9.5367431640625e-07);
ok($diceobj->probability(8873),1.1444091796875e-06);
ok($diceobj->probability(8874),9.5367431640625e-07);
ok($diceobj->probability(8875),7.62939453125e-07);
ok($diceobj->probability(8876),1.45560370551215e-06);
ok($diceobj->probability(8877),2.14826795789931e-06);
ok($diceobj->probability(8878),2.84093221028646e-06);
ok($diceobj->probability(8879),3.53359646267361e-06);
ok($diceobj->probability(8880),4.41699557834201e-06);
ok($diceobj->probability(8881),5.30039469401042e-06);
ok($diceobj->probability(8882),4.41699557834201e-06);
ok($diceobj->probability(8883),3.53359646267361e-06);
ok($diceobj->probability(8884),2.65019734700521e-06);
ok($diceobj->probability(8885),1.76679823133681e-06);
ok($diceobj->probability(8886),8.83399115668403e-07);
ok($diceobj->probability(8894),1.6632080078125e-06);
ok($diceobj->probability(8895),3.326416015625e-06);
ok($diceobj->probability(8896),4.9896240234375e-06);
ok($diceobj->probability(8897),6.65283203125e-06);
ok($diceobj->probability(8898),8.3160400390625e-06);
ok($diceobj->probability(8899),9.979248046875e-06);
ok($diceobj->probability(8900),8.3160400390625e-06);
ok($diceobj->probability(8901),6.65283203125e-06);
ok($diceobj->probability(8902),4.9896240234375e-06);
ok($diceobj->probability(8903),3.326416015625e-06);
ok($diceobj->probability(8904),1.6632080078125e-06);
ok($diceobj->probability(8912),4.05998229980469e-06);
ok($diceobj->probability(8913),8.11996459960938e-06);
ok($diceobj->probability(8914),1.21799468994141e-05);
ok($diceobj->probability(8915),1.62399291992188e-05);
ok($diceobj->probability(8916),2.02999114990234e-05);
ok($diceobj->probability(8917),2.43598937988281e-05);
ok($diceobj->probability(8918),2.02999114990234e-05);
ok($diceobj->probability(8919),1.62399291992188e-05);
ok($diceobj->probability(8920),1.21799468994141e-05);
ok($diceobj->probability(8921),8.11996459960938e-06);
ok($diceobj->probability(8922),4.05998229980469e-06);
ok($diceobj->probability(8927),3.30003102620443e-06);
ok($diceobj->probability(8928),6.60006205240885e-06);
ok($diceobj->probability(8929),9.90009307861328e-06);
ok($diceobj->probability(8930),1.3416502210829e-05);
ok($diceobj->probability(8931),1.69329113430447e-05);
ok($diceobj->probability(8932),2.04493204752604e-05);
ok($diceobj->probability(8933),1.73656675550673e-05);
ok($diceobj->probability(8934),1.61290910508898e-05);
ok($diceobj->probability(8935),1.48925145467122e-05);
ok($diceobj->probability(8936),1.32231818305122e-05);
ok($diceobj->probability(8937),1.15538491143121e-05);
ok($diceobj->probability(8938),9.88451639811198e-06);
ok($diceobj->probability(8939),1.15152147081163e-05);
ok($diceobj->probability(8940),9.45176018608941e-06);
ok($diceobj->probability(8941),7.3883056640625e-06);
ok($diceobj->probability(8942),5.54122924804687e-06);
ok($diceobj->probability(8943),3.69415283203125e-06);
ok($diceobj->probability(8944),1.84707641601563e-06);
ok($diceobj->probability(8961),5.56310017903646e-08);
ok($diceobj->probability(8962),2.19599405924479e-06);
ok($diceobj->probability(8963),4.33635711669922e-06);
ok($diceobj->probability(8964),6.47672017415365e-06);
ok($diceobj->probability(8965),8.61708323160807e-06);
ok($diceobj->probability(8966),1.07574462890625e-05);
ok($diceobj->probability(8967),1.27865473429362e-05);
ok($diceobj->probability(8968),1.06461842854818e-05);
ok($diceobj->probability(8969),8.50582122802734e-06);
ok($diceobj->probability(8970),6.36545817057292e-06);
ok($diceobj->probability(8971),4.22509511311849e-06);
ok($diceobj->probability(8972),7.47396681043837e-06);
ok($diceobj->probability(8973),1.07784695095486e-05);
ok($diceobj->probability(8974),1.61677042643229e-05);
ok($diceobj->probability(8975),2.15569390190972e-05);
ok($diceobj->probability(8976),2.69461737738715e-05);
ok($diceobj->probability(8977),3.23354085286458e-05);
ok($diceobj->probability(8978),3.05884467230903e-05);
ok($diceobj->probability(8979),2.88414849175347e-05);
ok($diceobj->probability(8980),2.70945231119792e-05);
ok($diceobj->probability(8981),2.53475613064236e-05);
ok($diceobj->probability(8982),2.36005995008681e-05);
ok($diceobj->probability(8983),2.18536376953125e-05);
ok($diceobj->probability(8984),1.82113647460938e-05);
ok($diceobj->probability(8985),1.4569091796875e-05);
ok($diceobj->probability(8986),1.09268188476562e-05);
ok($diceobj->probability(8987),7.2845458984375e-06);
ok($diceobj->probability(8988),3.64227294921875e-06);
ok($diceobj->probability(8992),6.42140706380208e-09);
ok($diceobj->probability(8993),1.28428141276042e-08);
ok($diceobj->probability(8994),1.92642211914062e-08);
ok($diceobj->probability(8995),1.90556844075521e-06);
ok($diceobj->probability(8996),3.79187266031901e-06);
ok($diceobj->probability(8997),5.67817687988281e-06);
ok($diceobj->probability(8998),7.55163828531901e-06);
ok($diceobj->probability(8999),9.42509969075521e-06);
ok($diceobj->probability(9000),1.12985610961914e-05);
ok($diceobj->probability(9001),9.4122568766276e-06);
ok($diceobj->probability(9002),1.55092196994358e-05);
ok($diceobj->probability(9003),2.16061825222439e-05);
ok($diceobj->probability(9004),2.77095667521159e-05);
ok($diceobj->probability(9005),3.38129509819878e-05);
ok($diceobj->probability(9006),3.99163352118598e-05);
ok($diceobj->probability(9007),4.78996022542318e-05);
ok($diceobj->probability(9008),3.99163352118598e-05);
ok($diceobj->probability(9009),3.19330681694879e-05);
ok($diceobj->probability(9010),2.39498011271159e-05);
ok($diceobj->probability(9011),1.59665340847439e-05);
ok($diceobj->probability(9012),7.98326704237196e-06);
ok($diceobj->probability(9018),2.58865356445312e-06);
ok($diceobj->probability(9019),5.17730712890625e-06);
ok($diceobj->probability(9020),7.76596069335938e-06);
ok($diceobj->probability(9021),1.03546142578125e-05);
ok($diceobj->probability(9022),1.29432678222656e-05);
ok($diceobj->probability(9023),1.55319213867188e-05);
ok($diceobj->probability(9024),1.29432678222656e-05);
ok($diceobj->probability(9025),1.03546142578125e-05);
ok($diceobj->probability(9026),7.76596069335938e-06);
ok($diceobj->probability(9027),5.74576059977214e-06);
ok($diceobj->probability(9028),3.7255605061849e-06);
ok($diceobj->probability(9029),1.70536041259766e-06);
ok($diceobj->probability(9030),2.27381388346354e-06);
ok($diceobj->probability(9031),2.84226735432943e-06);
ok($diceobj->probability(9032),3.41072082519531e-06);
ok($diceobj->probability(9033),2.84226735432943e-06);
ok($diceobj->probability(9034),2.27381388346354e-06);
ok($diceobj->probability(9035),1.70536041259766e-06);
ok($diceobj->probability(9036),1.13690694173177e-06);
ok($diceobj->probability(9037),5.68453470865885e-07);
ok($diceobj->probability(9046),1.33654276529948e-06);
ok($diceobj->probability(9047),2.67308553059896e-06);
ok($diceobj->probability(9048),4.00962829589844e-06);
ok($diceobj->probability(9049),5.34617106119792e-06);
ok($diceobj->probability(9050),8.56429206000434e-06);
ok($diceobj->probability(9051),1.17824130588108e-05);
ok($diceobj->probability(9052),1.23274485270182e-05);
ok($diceobj->probability(9053),1.28724839952257e-05);
ok($diceobj->probability(9054),1.34175194634332e-05);
ok($diceobj->probability(9055),1.39625549316406e-05);
ok($diceobj->probability(9056),1.07444339328342e-05);
ok($diceobj->probability(9057),7.52631293402778e-06);
ok($diceobj->probability(9058),5.64473470052083e-06);
ok($diceobj->probability(9059),3.76315646701389e-06);
ok($diceobj->probability(9060),1.88157823350694e-06);
ok($diceobj->probability(9074),9.64088439941406e-06);
ok($diceobj->probability(9075),1.92817687988281e-05);
ok($diceobj->probability(9076),2.89226531982422e-05);
ok($diceobj->probability(9077),3.85635375976562e-05);
ok($diceobj->probability(9078),4.82044219970703e-05);
ok($diceobj->probability(9079),5.78453063964844e-05);
ok($diceobj->probability(9080),4.82044219970703e-05);
ok($diceobj->probability(9081),3.85635375976562e-05);
ok($diceobj->probability(9082),2.89226531982422e-05);
ok($diceobj->probability(9083),1.92817687988281e-05);
ok($diceobj->probability(9084),9.64088439941406e-06);
ok($diceobj->probability(9102),5.72516123453776e-06);
ok($diceobj->probability(9103),1.14503224690755e-05);
ok($diceobj->probability(9104),1.71754837036133e-05);
ok($diceobj->probability(9105),2.2900644938151e-05);
ok($diceobj->probability(9106),2.86258061726888e-05);
ok($diceobj->probability(9107),3.43509674072266e-05);
ok($diceobj->probability(9108),2.86258061726888e-05);
ok($diceobj->probability(9109),2.2900644938151e-05);
ok($diceobj->probability(9110),1.91301345825195e-05);
ok($diceobj->probability(9111),1.5359624226888e-05);
ok($diceobj->probability(9112),1.15891138712565e-05);
ok($diceobj->probability(9113),7.818603515625e-06);
ok($diceobj->probability(9114),9.77325439453125e-06);
ok($diceobj->probability(9115),1.17279052734375e-05);
ok($diceobj->probability(9116),9.93061065673828e-06);
ok($diceobj->probability(9117),8.13331604003906e-06);
ok($diceobj->probability(9118),6.33602142333984e-06);
ok($diceobj->probability(9119),4.53872680664062e-06);
ok($diceobj->probability(9120),2.74143218994141e-06);
ok($diceobj->probability(9121),9.44137573242187e-07);
ok($diceobj->probability(9122),2.12264590793186e-06);
ok($diceobj->probability(9123),3.30115424262153e-06);
ok($diceobj->probability(9124),4.4796625773112e-06);
ok($diceobj->probability(9125),5.65817091200087e-06);
ok($diceobj->probability(9126),6.83667924669054e-06);
ok($diceobj->probability(9127),8.01518758138021e-06);
ok($diceobj->probability(9128),8.85719723171658e-06);
ok($diceobj->probability(9129),9.69920688205295e-06);
ok($diceobj->probability(9130),1.05412165323893e-05);
ok($diceobj->probability(9131),1.13832261827257e-05);
ok($diceobj->probability(9132),1.22252358330621e-05);
ok($diceobj->probability(9133),1.30672454833984e-05);
ok($diceobj->probability(9134),1.08893712361654e-05);
ok($diceobj->probability(9135),8.71149698893229e-06);
ok($diceobj->probability(9136),6.53362274169922e-06);
ok($diceobj->probability(9137),5.78344133165148e-06);
ok($diceobj->probability(9138),5.03325992160373e-06);
ok($diceobj->probability(9139),4.28307851155599e-06);
ok($diceobj->probability(9140),5.71077134874132e-06);
ok($diceobj->probability(9141),7.13846418592665e-06);
ok($diceobj->probability(9142),8.56615702311198e-06);
ok($diceobj->probability(9143),7.13846418592665e-06);
ok($diceobj->probability(9144),5.71077134874132e-06);
ok($diceobj->probability(9145),4.28307851155599e-06);
ok($diceobj->probability(9146),2.85538567437066e-06);
ok($diceobj->probability(9147),1.42769283718533e-06);
ok($diceobj->probability(9154),3.79467010498047e-06);
ok($diceobj->probability(9155),7.58934020996094e-06);
ok($diceobj->probability(9156),1.13840103149414e-05);
ok($diceobj->probability(9157),1.51786804199219e-05);
ok($diceobj->probability(9158),1.89733505249023e-05);
ok($diceobj->probability(9159),2.27680206298828e-05);
ok($diceobj->probability(9160),1.89733505249023e-05);
ok($diceobj->probability(9161),1.51786804199219e-05);
ok($diceobj->probability(9162),1.13840103149414e-05);
ok($diceobj->probability(9163),7.58934020996094e-06);
ok($diceobj->probability(9164),3.79467010498047e-06);
ok($diceobj->probability(9179),7.68873426649306e-07);
ok($diceobj->probability(9180),1.53774685329861e-06);
ok($diceobj->probability(9181),2.30662027994792e-06);
ok($diceobj->probability(9182),5.27894761827257e-06);
ok($diceobj->probability(9183),8.25127495659722e-06);
ok($diceobj->probability(9184),1.12236022949219e-05);
ok($diceobj->probability(9185),1.26581827799479e-05);
ok($diceobj->probability(9186),1.4092763264974e-05);
ok($diceobj->probability(9187),1.552734375e-05);
ok($diceobj->probability(9188),1.25550164116753e-05);
ok($diceobj->probability(9189),9.58268907335069e-06);
ok($diceobj->probability(9190),6.61036173502604e-06);
ok($diceobj->probability(9191),4.40690782335069e-06);
ok($diceobj->probability(9192),2.20345391167535e-06);
ok($diceobj->probability(9198),3.94821166992187e-07);
ok($diceobj->probability(9199),7.89642333984375e-07);
ok($diceobj->probability(9200),1.18446350097656e-06);
ok($diceobj->probability(9201),1.57928466796875e-06);
ok($diceobj->probability(9202),6.41466776529948e-06);
ok($diceobj->probability(9203),1.12500508626302e-05);
ok($diceobj->probability(9204),1.52957916259766e-05);
ok($diceobj->probability(9205),1.93415323893229e-05);
ok($diceobj->probability(9206),2.33872731526693e-05);
ok($diceobj->probability(9207),2.74330139160156e-05);
ok($diceobj->probability(9208),2.25976308186849e-05);
ok($diceobj->probability(9209),1.77908579508464e-05);
ok($diceobj->probability(9210),1.337890625e-05);
ok($diceobj->probability(9211),8.96695454915365e-06);
ok($diceobj->probability(9212),4.55500284830729e-06);
ok($diceobj->probability(9213),1.43051147460937e-07);
ok($diceobj->probability(9214),1.71661376953125e-07);
ok($diceobj->probability(9215),1.43051147460937e-07);
ok($diceobj->probability(9216),1.1444091796875e-07);
ok($diceobj->probability(9217),8.58306884765625e-08);
ok($diceobj->probability(9218),2.32217576768663e-06);
ok($diceobj->probability(9219),4.5585208468967e-06);
ok($diceobj->probability(9220),6.79486592610677e-06);
ok($diceobj->probability(9221),9.05982123480903e-06);
ok($diceobj->probability(9222),1.13247765435113e-05);
ok($diceobj->probability(9223),1.35897318522135e-05);
ok($diceobj->probability(9224),1.13247765435113e-05);
ok($diceobj->probability(9225),9.05982123480903e-06);
ok($diceobj->probability(9226),6.79486592610677e-06);
ok($diceobj->probability(9227),4.52991061740451e-06);
ok($diceobj->probability(9228),2.26495530870226e-06);
ok($diceobj->probability(9236),1.11473931206597e-06);
ok($diceobj->probability(9237),2.22947862413194e-06);
ok($diceobj->probability(9238),3.34421793619792e-06);
ok($diceobj->probability(9239),4.45895724826389e-06);
ok($diceobj->probability(9240),5.57369656032986e-06);
ok($diceobj->probability(9241),6.68843587239583e-06);
ok($diceobj->probability(9242),8.82690853542752e-06);
ok($diceobj->probability(9243),1.09653811984592e-05);
ok($diceobj->probability(9244),1.31038538614909e-05);
ok($diceobj->probability(9245),1.52423265245226e-05);
ok($diceobj->probability(9246),1.73807991875543e-05);
ok($diceobj->probability(9247),1.95192718505859e-05);
ok($diceobj->probability(9248),1.62660598754883e-05);
ok($diceobj->probability(9249),1.30128479003906e-05);
ok($diceobj->probability(9250),9.77076212565104e-06);
ok($diceobj->probability(9251),6.52867635091146e-06);
ok($diceobj->probability(9252),3.28659057617187e-06);
ok($diceobj->probability(9253),1.04586283365885e-07);
ok($diceobj->probability(9254),1.75793965657552e-07);
ok($diceobj->probability(9255),2.47001647949219e-07);
ok($diceobj->probability(9256),2.9595692952474e-07);
ok($diceobj->probability(9257),3.4491221110026e-07);
ok($diceobj->probability(9258),3.93867492675781e-07);
ok($diceobj->probability(9259),3.22659810384115e-07);
ok($diceobj->probability(9260),2.51452128092448e-07);
ok($diceobj->probability(9261),1.80244445800781e-07);
ok($diceobj->probability(9262),1.20162963867188e-07);
ok($diceobj->probability(9263),6.00814819335938e-08);
ok($diceobj->probability(9271),1.18255615234375e-07);
ok($diceobj->probability(9272),2.3651123046875e-07);
ok($diceobj->probability(9273),3.54766845703125e-07);
ok($diceobj->probability(9274),4.730224609375e-07);
ok($diceobj->probability(9275),5.91278076171875e-07);
ok($diceobj->probability(9276),7.0953369140625e-07);
ok($diceobj->probability(9277),5.91278076171875e-07);
ok($diceobj->probability(9278),4.730224609375e-07);
ok($diceobj->probability(9279),3.54766845703125e-07);
ok($diceobj->probability(9280),2.3651123046875e-07);
ok($diceobj->probability(9281),1.18255615234375e-07);
ok($diceobj->probability(9282),1.0507074991862e-06);
ok($diceobj->probability(9283),2.1014149983724e-06);
ok($diceobj->probability(9284),5.54425557454427e-06);
ok($diceobj->probability(9285),8.98709615071615e-06);
ok($diceobj->probability(9286),1.2429936726888e-05);
ok($diceobj->probability(9287),1.58727773030599e-05);
ok($diceobj->probability(9288),1.72142028808594e-05);
ok($diceobj->probability(9289),1.85556284586589e-05);
ok($diceobj->probability(9290),1.5112787882487e-05);
ok($diceobj->probability(9291),1.16699473063151e-05);
ok($diceobj->probability(9292),8.22710673014323e-06);
ok($diceobj->probability(9293),4.78426615397135e-06);
ok($diceobj->probability(9294),2.39213307698568e-06);
ok($diceobj->probability(9302),2.0751953125e-07);
ok($diceobj->probability(9303),4.150390625e-07);
ok($diceobj->probability(9304),6.2255859375e-07);
ok($diceobj->probability(9305),8.30078125e-07);
ok($diceobj->probability(9306),1.03759765625e-06);
ok($diceobj->probability(9307),1.2451171875e-06);
ok($diceobj->probability(9308),1.03759765625e-06);
ok($diceobj->probability(9309),8.30078125e-07);
ok($diceobj->probability(9310),6.2255859375e-07);
ok($diceobj->probability(9311),4.150390625e-07);
ok($diceobj->probability(9312),2.0751953125e-07);
ok($diceobj->probability(9317),3.2175530327691e-06);
ok($diceobj->probability(9318),6.43510606553819e-06);
ok($diceobj->probability(9319),9.65265909830729e-06);
ok($diceobj->probability(9320),1.28702121310764e-05);
ok($diceobj->probability(9321),1.60877651638455e-05);
ok($diceobj->probability(9322),1.93053181966146e-05);
ok($diceobj->probability(9323),1.60877651638455e-05);
ok($diceobj->probability(9324),1.28702121310764e-05);
ok($diceobj->probability(9325),9.65265909830729e-06);
ok($diceobj->probability(9326),6.43510606553819e-06);
ok($diceobj->probability(9327),3.2175530327691e-06);
ok($diceobj->probability(9340),1.32522583007812e-06);
ok($diceobj->probability(9341),2.65045166015625e-06);
ok($diceobj->probability(9342),3.97567749023438e-06);
ok($diceobj->probability(9343),5.3009033203125e-06);
ok($diceobj->probability(9344),6.62612915039063e-06);
ok($diceobj->probability(9345),7.95135498046875e-06);
ok($diceobj->probability(9346),6.62612915039063e-06);
ok($diceobj->probability(9347),5.3009033203125e-06);
ok($diceobj->probability(9348),3.97567749023438e-06);
ok($diceobj->probability(9349),2.65045166015625e-06);
ok($diceobj->probability(9350),1.32522583007812e-06);
ok($diceobj->probability(9352),2.79178619384766e-06);
ok($diceobj->probability(9353),5.58357238769531e-06);
ok($diceobj->probability(9354),8.37535858154297e-06);
ok($diceobj->probability(9355),1.11671447753906e-05);
ok($diceobj->probability(9356),1.39589309692383e-05);
ok($diceobj->probability(9357),1.67507171630859e-05);
ok($diceobj->probability(9358),1.39589309692383e-05);
ok($diceobj->probability(9359),1.11671447753906e-05);
ok($diceobj->probability(9360),8.37535858154297e-06);
ok($diceobj->probability(9361),5.58357238769531e-06);
ok($diceobj->probability(9362),8.57664744059245e-06);
ok($diceobj->probability(9363),1.15697224934896e-05);
ok($diceobj->probability(9364),1.73545837402344e-05);
ok($diceobj->probability(9365),2.31394449869792e-05);
ok($diceobj->probability(9366),2.8924306233724e-05);
ok($diceobj->probability(9367),3.47091674804688e-05);
ok($diceobj->probability(9368),2.8924306233724e-05);
ok($diceobj->probability(9369),2.38254547119141e-05);
ok($diceobj->probability(9370),1.87266031901042e-05);
ok($diceobj->probability(9371),1.36277516682943e-05);
ok($diceobj->probability(9372),8.52890014648437e-06);
ok($diceobj->probability(9373),3.43004862467448e-06);
ok($diceobj->probability(9374),4.11605834960937e-06);
ok($diceobj->probability(9375),3.43004862467448e-06);
ok($diceobj->probability(9376),2.74403889973958e-06);
ok($diceobj->probability(9377),4.08077239990234e-06);
ok($diceobj->probability(9378),5.4175059000651e-06);
ok($diceobj->probability(9379),6.75423940022786e-06);
ok($diceobj->probability(9380),8.09097290039062e-06);
ok($diceobj->probability(9381),1.01137161254883e-05);
ok($diceobj->probability(9382),1.21364593505859e-05);
ok($diceobj->probability(9383),1.01137161254883e-05);
ok($diceobj->probability(9384),8.09097290039062e-06);
ok($diceobj->probability(9385),6.06822967529297e-06);
ok($diceobj->probability(9386),7.0457034640842e-06);
ok($diceobj->probability(9387),8.02317725287543e-06);
ok($diceobj->probability(9388),9.41295623779297e-06);
ok($diceobj->probability(9389),1.28254784478082e-05);
ok($diceobj->probability(9390),1.62380006578234e-05);
ok($diceobj->probability(9391),1.96505228678385e-05);
ok($diceobj->probability(9392),1.7062611050076e-05);
ok($diceobj->probability(9393),1.44746992323134e-05);
ok($diceobj->probability(9394),1.10621770222982e-05);
ok($diceobj->probability(9395),7.64965481228299e-06);
ok($diceobj->probability(9396),4.2371326022678e-06);
ok($diceobj->probability(9397),8.24610392252604e-07);
ok($diceobj->probability(9398),1.12607744004991e-06);
ok($diceobj->probability(9399),1.42754448784722e-06);
ok($diceobj->probability(9400),2.14131673177083e-06);
ok($diceobj->probability(9401),2.85508897569444e-06);
ok($diceobj->probability(9402),3.56886121961806e-06);
ok($diceobj->probability(9403),4.28263346354167e-06);
ok($diceobj->probability(9404),3.56886121961806e-06);
ok($diceobj->probability(9405),2.85508897569444e-06);
ok($diceobj->probability(9406),2.14131673177083e-06);
ok($diceobj->probability(9407),1.42754448784722e-06);
ok($diceobj->probability(9408),7.13772243923611e-07);
ok($diceobj->probability(9410),4.14996676974826e-06);
ok($diceobj->probability(9411),8.29993353949653e-06);
ok($diceobj->probability(9412),1.24499003092448e-05);
ok($diceobj->probability(9413),1.65998670789931e-05);
ok($diceobj->probability(9414),2.07498338487413e-05);
ok($diceobj->probability(9415),2.48998006184896e-05);
ok($diceobj->probability(9416),2.07498338487413e-05);
ok($diceobj->probability(9417),1.65998670789931e-05);
ok($diceobj->probability(9418),1.24499003092448e-05);
ok($diceobj->probability(9419),8.29993353949653e-06);
ok($diceobj->probability(9420),4.14996676974826e-06);
ok($diceobj->probability(9426),1.02996826171875e-07);
ok($diceobj->probability(9427),1.13232930501302e-06);
ok($diceobj->probability(9428),2.16166178385417e-06);
ok($diceobj->probability(9429),3.19099426269531e-06);
ok($diceobj->probability(9430),4.22032674153646e-06);
ok($diceobj->probability(9431),5.2496592203776e-06);
ok($diceobj->probability(9432),6.072998046875e-06);
ok($diceobj->probability(9433),5.04366556803385e-06);
ok($diceobj->probability(9434),4.01433308919271e-06);
ok($diceobj->probability(9435),2.98500061035156e-06);
ok($diceobj->probability(9436),1.95566813151042e-06);
ok($diceobj->probability(9437),9.26335652669271e-07);
ok($diceobj->probability(9452),4.58994971381293e-06);
ok($diceobj->probability(9453),9.17989942762587e-06);
ok($diceobj->probability(9454),1.37698491414388e-05);
ok($diceobj->probability(9455),1.83597988552517e-05);
ok($diceobj->probability(9456),2.29497485690647e-05);
ok($diceobj->probability(9457),2.75396982828776e-05);
ok($diceobj->probability(9458),2.29497485690647e-05);
ok($diceobj->probability(9459),1.83597988552517e-05);
ok($diceobj->probability(9460),1.37698491414388e-05);
ok($diceobj->probability(9461),9.17989942762587e-06);
ok($diceobj->probability(9462),4.58994971381293e-06);
ok($diceobj->probability(9466),2.72687276204427e-06);
ok($diceobj->probability(9467),5.45374552408854e-06);
ok($diceobj->probability(9468),8.18061828613281e-06);
ok($diceobj->probability(9469),1.09074910481771e-05);
ok($diceobj->probability(9470),1.36343638102214e-05);
ok($diceobj->probability(9471),1.63612365722656e-05);
ok($diceobj->probability(9472),1.36343638102214e-05);
ok($diceobj->probability(9473),1.09074910481771e-05);
ok($diceobj->probability(9474),8.18061828613281e-06);
ok($diceobj->probability(9475),5.45374552408854e-06);
ok($diceobj->probability(9476),2.72687276204427e-06);
ok($diceobj->probability(9479),7.29242960611979e-07);
ok($diceobj->probability(9480),1.45848592122396e-06);
ok($diceobj->probability(9481),2.18772888183594e-06);
ok($diceobj->probability(9482),2.91697184244792e-06);
ok($diceobj->probability(9483),3.6462148030599e-06);
ok($diceobj->probability(9484),4.37545776367188e-06);
ok($diceobj->probability(9485),3.6462148030599e-06);
ok($diceobj->probability(9486),2.91697184244792e-06);
ok($diceobj->probability(9487),2.18772888183594e-06);
ok($diceobj->probability(9488),1.5364752875434e-06);
ok($diceobj->probability(9489),8.85221693250868e-07);
ok($diceobj->probability(9490),2.33968098958333e-07);
ok($diceobj->probability(9491),3.11957465277778e-07);
ok($diceobj->probability(9492),3.89946831597222e-07);
ok($diceobj->probability(9493),4.67936197916667e-07);
ok($diceobj->probability(9494),3.89946831597222e-07);
ok($diceobj->probability(9495),3.11957465277778e-07);
ok($diceobj->probability(9496),2.33968098958333e-07);
ok($diceobj->probability(9497),1.55978732638889e-07);
ok($diceobj->probability(9498),7.79893663194444e-08);
ok($diceobj->probability(9502),6.42852783203125e-07);
ok($diceobj->probability(9503),1.28570556640625e-06);
ok($diceobj->probability(9504),1.92855834960938e-06);
ok($diceobj->probability(9505),2.5714111328125e-06);
ok($diceobj->probability(9506),7.29770660400391e-06);
ok($diceobj->probability(9507),1.20240020751953e-05);
ok($diceobj->probability(9508),1.54645919799805e-05);
ok($diceobj->probability(9509),1.89051818847656e-05);
ok($diceobj->probability(9510),2.23457717895508e-05);
ok($diceobj->probability(9511),2.57863616943359e-05);
ok($diceobj->probability(9512),2.10600662231445e-05);
ok($diceobj->probability(9513),1.63337707519531e-05);
ok($diceobj->probability(9514),1.22503280639648e-05);
ok($diceobj->probability(9515),8.16688537597656e-06);
ok($diceobj->probability(9516),4.08344268798828e-06);
ok($diceobj->probability(9522),1.11806233723958e-06);
ok($diceobj->probability(9523),2.23612467447917e-06);
ok($diceobj->probability(9524),4.15985107421875e-06);
ok($diceobj->probability(9525),6.08357747395833e-06);
ok($diceobj->probability(9526),8.00730387369792e-06);
ok($diceobj->probability(9527),9.9310302734375e-06);
ok($diceobj->probability(9528),9.61863199869792e-06);
ok($diceobj->probability(9529),9.30623372395833e-06);
ok($diceobj->probability(9530),7.38250732421875e-06);
ok($diceobj->probability(9531),5.45878092447917e-06);
ok($diceobj->probability(9532),3.53505452473958e-06);
ok($diceobj->probability(9533),1.611328125e-06);
ok($diceobj->probability(9534),8.056640625e-07);
ok($diceobj->probability(9550),1.45912170410156e-07);
ok($diceobj->probability(9551),2.91824340820312e-07);
ok($diceobj->probability(9552),4.37736511230469e-07);
ok($diceobj->probability(9553),5.83648681640625e-07);
ok($diceobj->probability(9554),7.29560852050781e-07);
ok($diceobj->probability(9555),8.75473022460938e-07);
ok($diceobj->probability(9556),7.29560852050781e-07);
ok($diceobj->probability(9557),5.83648681640625e-07);
ok($diceobj->probability(9558),4.37736511230469e-07);
ok($diceobj->probability(9559),2.91824340820312e-07);
ok($diceobj->probability(9560),1.45912170410156e-07);
ok($diceobj->probability(9570),3.11482747395833e-06);
ok($diceobj->probability(9571),6.22965494791667e-06);
ok($diceobj->probability(9572),1.05961990356445e-05);
ok($diceobj->probability(9573),1.49627431233724e-05);
ok($diceobj->probability(9574),1.93292872111003e-05);
ok($diceobj->probability(9575),2.36958312988281e-05);
ok($diceobj->probability(9576),2.18327204386393e-05);
ok($diceobj->probability(9577),1.99696095784505e-05);
ok($diceobj->probability(9578),1.68888727823893e-05);
ok($diceobj->probability(9579),1.38081359863281e-05);
ok($diceobj->probability(9580),1.07273991902669e-05);
ok($diceobj->probability(9581),7.64666239420573e-06);
ok($diceobj->probability(9582),7.68075307210286e-06);
ok($diceobj->probability(9583),7.71484375e-06);
ok($diceobj->probability(9584),6.42903645833333e-06);
ok($diceobj->probability(9585),5.14322916666667e-06);
ok($diceobj->probability(9586),3.857421875e-06);
ok($diceobj->probability(9587),2.57161458333333e-06);
ok($diceobj->probability(9588),1.28580729166667e-06);
ok($diceobj->probability(9602),3.99008009168837e-06);
ok($diceobj->probability(9603),7.98016018337674e-06);
ok($diceobj->probability(9604),1.19702402750651e-05);
ok($diceobj->probability(9605),1.59603203667535e-05);
ok($diceobj->probability(9606),1.99504004584418e-05);
ok($diceobj->probability(9607),2.39404805501302e-05);
ok($diceobj->probability(9608),1.99504004584418e-05);
ok($diceobj->probability(9609),1.59603203667535e-05);
ok($diceobj->probability(9610),1.19702402750651e-05);
ok($diceobj->probability(9611),7.98016018337674e-06);
ok($diceobj->probability(9612),3.99008009168837e-06);
ok($diceobj->probability(9616),6.5155029296875e-07);
ok($diceobj->probability(9617),1.3031005859375e-06);
ok($diceobj->probability(9618),1.95465087890625e-06);
ok($diceobj->probability(9619),2.606201171875e-06);
ok($diceobj->probability(9620),3.25775146484375e-06);
ok($diceobj->probability(9621),3.9093017578125e-06);
ok($diceobj->probability(9622),3.25775146484375e-06);
ok($diceobj->probability(9623),2.606201171875e-06);
ok($diceobj->probability(9624),1.95465087890625e-06);
ok($diceobj->probability(9625),1.3031005859375e-06);
ok($diceobj->probability(9626),6.5155029296875e-07);
ok($diceobj->probability(9641),1.60291459825304e-06);
ok($diceobj->probability(9642),3.20582919650608e-06);
ok($diceobj->probability(9643),4.80874379475911e-06);
ok($diceobj->probability(9644),6.41165839301215e-06);
ok($diceobj->probability(9645),8.01457299126519e-06);
ok($diceobj->probability(9646),9.61748758951823e-06);
ok($diceobj->probability(9647),8.01457299126519e-06);
ok($diceobj->probability(9648),6.41165839301215e-06);
ok($diceobj->probability(9649),4.80874379475911e-06);
ok($diceobj->probability(9650),3.20582919650608e-06);
ok($diceobj->probability(9651),1.60291459825304e-06);
ok($diceobj->probability(9662),2.60087754991319e-06);
ok($diceobj->probability(9663),5.20175509982639e-06);
ok($diceobj->probability(9664),7.80263264973958e-06);
ok($diceobj->probability(9665),1.04035101996528e-05);
ok($diceobj->probability(9666),1.3004387749566e-05);
ok($diceobj->probability(9667),1.56052652994792e-05);
ok($diceobj->probability(9668),1.3004387749566e-05);
ok($diceobj->probability(9669),1.04035101996528e-05);
ok($diceobj->probability(9670),7.80263264973958e-06);
ok($diceobj->probability(9671),5.20175509982639e-06);
ok($diceobj->probability(9672),2.60087754991319e-06);
ok($diceobj->probability(9674),1.41249762641059e-07);
ok($diceobj->probability(9675),2.82499525282118e-07);
ok($diceobj->probability(9676),4.23749287923177e-07);
ok($diceobj->probability(9677),5.64999050564236e-07);
ok($diceobj->probability(9678),7.06248813205295e-07);
ok($diceobj->probability(9679),8.47498575846354e-07);
ok($diceobj->probability(9680),7.06248813205295e-07);
ok($diceobj->probability(9681),5.64999050564236e-07);
ok($diceobj->probability(9682),5.02713521321615e-07);
ok($diceobj->probability(9683),4.40427992078993e-07);
ok($diceobj->probability(9684),3.78142462836372e-07);
ok($diceobj->probability(9685),3.1585693359375e-07);
ok($diceobj->probability(9686),3.94821166992187e-07);
ok($diceobj->probability(9687),4.73785400390625e-07);
ok($diceobj->probability(9688),3.94821166992187e-07);
ok($diceobj->probability(9689),3.1585693359375e-07);
ok($diceobj->probability(9690),2.36892700195313e-07);
ok($diceobj->probability(9691),1.57928466796875e-07);
ok($diceobj->probability(9692),3.47052680121528e-07);
ok($diceobj->probability(9693),5.36176893446181e-07);
ok($diceobj->probability(9694),8.04265340169271e-07);
ok($diceobj->probability(9695),1.07235378689236e-06);
ok($diceobj->probability(9696),1.34044223361545e-06);
ok($diceobj->probability(9697),1.60853068033854e-06);
ok($diceobj->probability(9698),1.34044223361545e-06);
ok($diceobj->probability(9699),1.07235378689236e-06);
ok($diceobj->probability(9700),8.04265340169271e-07);
ok($diceobj->probability(9701),5.36176893446181e-07);
ok($diceobj->probability(9702),2.6808844672309e-07);
ok($diceobj->probability(9722),3.66726345486111e-06);
ok($diceobj->probability(9723),7.33452690972222e-06);
ok($diceobj->probability(9724),1.10017903645833e-05);
ok($diceobj->probability(9725),1.46690538194444e-05);
ok($diceobj->probability(9726),2.03590604994032e-05);
ok($diceobj->probability(9727),2.6049067179362e-05);
ok($diceobj->probability(9728),2.44045469495985e-05);
ok($diceobj->probability(9729),2.27600267198351e-05);
ok($diceobj->probability(9730),2.1136105855306e-05);
ok($diceobj->probability(9731),1.95121849907769e-05);
ok($diceobj->probability(9732),1.38427776760525e-05);
ok($diceobj->probability(9733),8.17337036132812e-06);
ok($diceobj->probability(9734),6.17122650146484e-06);
ok($diceobj->probability(9735),4.16908264160156e-06);
ok($diceobj->probability(9736),2.12574005126953e-06);
ok($diceobj->probability(9737),8.23974609375e-08);
ok($diceobj->probability(9738),6.1798095703125e-08);
ok($diceobj->probability(9739),4.119873046875e-08);
ok($diceobj->probability(9740),2.0599365234375e-08);
ok($diceobj->probability(9746),2.24397447374132e-06);
ok($diceobj->probability(9747),4.48794894748264e-06);
ok($diceobj->probability(9748),6.73192342122396e-06);
ok($diceobj->probability(9749),9.25223032633463e-06);
ok($diceobj->probability(9750),1.17725372314453e-05);
ok($diceobj->probability(9751),1.4292844136556e-05);
ok($diceobj->probability(9752),1.56081305609809e-05);
ok($diceobj->probability(9753),1.69234169854058e-05);
ok($diceobj->probability(9754),1.82387034098307e-05);
ok($diceobj->probability(9755),1.90013249715169e-05);
ok($diceobj->probability(9756),1.97639465332031e-05);
ok($diceobj->probability(9757),2.05265680948893e-05);
ok($diceobj->probability(9758),1.69673071967231e-05);
ok($diceobj->probability(9759),1.34080462985569e-05);
ok($diceobj->probability(9760),9.84878540039062e-06);
ok($diceobj->probability(9761),6.56585693359375e-06);
ok($diceobj->probability(9762),3.28292846679688e-06);
ok($diceobj->probability(9767),1.17725796169705e-07);
ok($diceobj->probability(9768),2.3545159233941e-07);
ok($diceobj->probability(9769),3.53177388509115e-07);
ok($diceobj->probability(9770),4.70903184678819e-07);
ok($diceobj->probability(9771),5.88628980848524e-07);
ok($diceobj->probability(9772),7.06354777018229e-07);
ok($diceobj->probability(9773),5.88628980848524e-07);
ok($diceobj->probability(9774),4.70903184678819e-07);
ok($diceobj->probability(9775),3.53177388509115e-07);
ok($diceobj->probability(9776),2.3545159233941e-07);
ok($diceobj->probability(9777),2.41595374213325e-06);
ok($diceobj->probability(9778),4.59645589192708e-06);
ok($diceobj->probability(9779),6.89468383789062e-06);
ok($diceobj->probability(9780),9.19291178385417e-06);
ok($diceobj->probability(9781),1.14911397298177e-05);
ok($diceobj->probability(9782),1.37893676757812e-05);
ok($diceobj->probability(9783),1.14911397298177e-05);
ok($diceobj->probability(9784),9.19291178385417e-06);
ok($diceobj->probability(9785),6.89468383789062e-06);
ok($diceobj->probability(9786),4.59645589192708e-06);
ok($diceobj->probability(9787),2.29822794596354e-06);
ok($diceobj->probability(9794),1.21188693576389e-06);
ok($diceobj->probability(9795),2.42377387152778e-06);
ok($diceobj->probability(9796),3.63566080729167e-06);
ok($diceobj->probability(9797),4.84754774305556e-06);
ok($diceobj->probability(9798),6.05943467881944e-06);
ok($diceobj->probability(9799),7.27132161458333e-06);
ok($diceobj->probability(9800),6.05943467881944e-06);
ok($diceobj->probability(9801),4.84754774305556e-06);
ok($diceobj->probability(9802),5.21322886149089e-06);
ok($diceobj->probability(9803),5.57890997992622e-06);
ok($diceobj->probability(9804),6.61470625135634e-06);
ok($diceobj->probability(9805),7.65050252278646e-06);
ok($diceobj->probability(9806),9.89818572998047e-06);
ok($diceobj->probability(9807),1.21458689371745e-05);
ok($diceobj->probability(9808),1.12384160359701e-05);
ok($diceobj->probability(9809),1.03309631347656e-05);
ok($diceobj->probability(9810),8.08327992757161e-06);
ok($diceobj->probability(9811),5.8355967203776e-06);
ok($diceobj->probability(9812),3.58791351318359e-06);
ok($diceobj->probability(9813),1.34023030598958e-06);
ok($diceobj->probability(9814),6.70115152994792e-07);
ok($diceobj->probability(9830),3.79977756076389e-06);
ok($diceobj->probability(9831),7.59955512152778e-06);
ok($diceobj->probability(9832),1.13993326822917e-05);
ok($diceobj->probability(9833),1.51991102430556e-05);
ok($diceobj->probability(9834),1.89988878038194e-05);
ok($diceobj->probability(9835),2.27986653645833e-05);
ok($diceobj->probability(9836),1.89988878038194e-05);
ok($diceobj->probability(9837),1.51991102430556e-05);
ok($diceobj->probability(9838),1.13993326822917e-05);
ok($diceobj->probability(9839),7.59955512152778e-06);
ok($diceobj->probability(9840),3.79977756076389e-06);
ok($diceobj->probability(9858),1.544189453125e-06);
ok($diceobj->probability(9859),3.08837890625e-06);
ok($diceobj->probability(9860),4.632568359375e-06);
ok($diceobj->probability(9861),6.1767578125e-06);
ok($diceobj->probability(9862),8.29447428385417e-06);
ok($diceobj->probability(9863),1.04121907552083e-05);
ok($diceobj->probability(9864),9.4415283203125e-06);
ok($diceobj->probability(9865),8.47086588541667e-06);
ok($diceobj->probability(9866),7.50020345052083e-06);
ok($diceobj->probability(9867),6.529541015625e-06);
ok($diceobj->probability(9868),4.41182454427083e-06);
ok($diceobj->probability(9869),2.29410807291667e-06);
ok($diceobj->probability(9870),1.7205810546875e-06);
ok($diceobj->probability(9871),1.14705403645833e-06);
ok($diceobj->probability(9872),5.73527018229167e-07);
ok($diceobj->probability(9882),4.66156005859375e-07);
ok($diceobj->probability(9883),9.3231201171875e-07);
ok($diceobj->probability(9884),1.39846801757812e-06);
ok($diceobj->probability(9885),1.8646240234375e-06);
ok($diceobj->probability(9886),2.33078002929687e-06);
ok($diceobj->probability(9887),2.79693603515625e-06);
ok($diceobj->probability(9888),2.33078002929687e-06);
ok($diceobj->probability(9889),1.8646240234375e-06);
ok($diceobj->probability(9890),1.39846801757812e-06);
ok($diceobj->probability(9891),9.40895080566406e-07);
ok($diceobj->probability(9892),4.83322143554688e-07);
ok($diceobj->probability(9893),2.57492065429687e-08);
ok($diceobj->probability(9894),3.4332275390625e-08);
ok($diceobj->probability(9895),4.29153442382812e-08);
ok($diceobj->probability(9896),5.14984130859375e-08);
ok($diceobj->probability(9897),4.29153442382812e-08);
ok($diceobj->probability(9898),3.4332275390625e-08);
ok($diceobj->probability(9899),2.57492065429687e-08);
ok($diceobj->probability(9900),1.71661376953125e-08);
ok($diceobj->probability(9901),8.58306884765625e-09);
ok($diceobj->probability(9902),1.67125701904297e-06);
ok($diceobj->probability(9903),3.34251403808594e-06);
ok($diceobj->probability(9904),5.01377105712891e-06);
ok($diceobj->probability(9905),6.68502807617187e-06);
ok($diceobj->probability(9906),8.35628509521484e-06);
ok($diceobj->probability(9907),1.00275421142578e-05);
ok($diceobj->probability(9908),8.35628509521484e-06);
ok($diceobj->probability(9909),6.68502807617187e-06);
ok($diceobj->probability(9910),5.01377105712891e-06);
ok($diceobj->probability(9911),3.34251403808594e-06);
ok($diceobj->probability(9912),1.67125701904297e-06);
ok($diceobj->probability(9920),3.44509548611111e-07);
ok($diceobj->probability(9921),6.89019097222222e-07);
ok($diceobj->probability(9922),1.12190246582031e-06);
ok($diceobj->probability(9923),1.5547858344184e-06);
ok($diceobj->probability(9924),1.98766920301649e-06);
ok($diceobj->probability(9925),2.42055257161458e-06);
ok($diceobj->probability(9926),2.16441684299045e-06);
ok($diceobj->probability(9927),1.90828111436632e-06);
ok($diceobj->probability(9928),1.47539774576823e-06);
ok($diceobj->probability(9929),1.04251437717014e-06);
ok($diceobj->probability(9930),6.09631008572049e-07);
ok($diceobj->probability(9931),1.76747639973958e-07);
ok($diceobj->probability(9932),8.83738199869792e-08);
ok($diceobj->probability(9938),3.35650973849826e-06);
ok($diceobj->probability(9939),6.71301947699653e-06);
ok($diceobj->probability(9940),1.00695292154948e-05);
ok($diceobj->probability(9941),1.34260389539931e-05);
ok($diceobj->probability(9942),1.67825486924913e-05);
ok($diceobj->probability(9943),2.01390584309896e-05);
ok($diceobj->probability(9944),1.67825486924913e-05);
ok($diceobj->probability(9945),1.34260389539931e-05);
ok($diceobj->probability(9946),1.00695292154948e-05);
ok($diceobj->probability(9947),6.71301947699653e-06);
ok($diceobj->probability(9948),3.35650973849826e-06);
ok($diceobj->probability(9977),4.7143300374349e-07);
ok($diceobj->probability(9978),9.42866007486979e-07);
ok($diceobj->probability(9979),1.41429901123047e-06);
ok($diceobj->probability(9980),1.88573201497396e-06);
ok($diceobj->probability(9981),2.35716501871745e-06);
ok($diceobj->probability(9982),2.82859802246094e-06);
ok($diceobj->probability(9983),2.35716501871745e-06);
ok($diceobj->probability(9984),1.98872884114583e-06);
ok($diceobj->probability(9985),1.62029266357422e-06);
ok($diceobj->probability(9986),3.74312930636936e-06);
ok($diceobj->probability(9987),5.8659659491645e-06);
ok($diceobj->probability(9988),7.98880259195964e-06);
ok($diceobj->probability(9989),1.05830722384983e-05);
ok($diceobj->probability(9990),1.29713482326931e-05);
ok($diceobj->probability(9991),1.5359624226888e-05);
ok($diceobj->probability(9992),1.27653545803494e-05);
ok($diceobj->probability(9993),1.01710849338108e-05);
ok($diceobj->probability(9994),7.57681528727214e-06);
ok($diceobj->probability(9995),4.98254564073351e-06);
ok($diceobj->probability(9996),2.49127282036675e-06);
ok($diceobj->probability(9998),9.65012444390191e-07);
ok($diceobj->probability(9999),1.93002488878038e-06);
ok($diceobj->probability(10000),2.89503733317057e-06);
ok($diceobj->probability(10001),3.86004977756076e-06);
ok($diceobj->probability(10002),6.23266008165148e-06);
ok($diceobj->probability(10003),8.60527038574219e-06);
ok($diceobj->probability(10004),9.04785580105252e-06);
ok($diceobj->probability(10005),9.49044121636285e-06);
ok($diceobj->probability(10006),9.93302663167318e-06);
ok($diceobj->probability(10007),1.13670772976345e-05);
ok($diceobj->probability(10008),9.98593224419488e-06);
ok($diceobj->probability(10009),8.60478719075521e-06);
ok($diceobj->probability(10010),8.18865458170573e-06);
ok($diceobj->probability(10011),7.77252197265625e-06);
ok($diceobj->probability(10012),7.35638936360677e-06);
ok($diceobj->probability(10013),4.95732625325521e-06);
ok($diceobj->probability(10014),3.96586100260417e-06);
ok($diceobj->probability(10015),3.03352355957031e-06);
ok($diceobj->probability(10016),2.10118611653646e-06);
ok($diceobj->probability(10017),1.1688486735026e-06);
ok($diceobj->probability(10018),2.3651123046875e-07);
ok($diceobj->probability(10019),2.95639038085937e-07);
ok($diceobj->probability(10020),3.54766845703125e-07);
ok($diceobj->probability(10021),2.95639038085937e-07);
ok($diceobj->probability(10022),2.3651123046875e-07);
ok($diceobj->probability(10023),1.77383422851562e-07);
ok($diceobj->probability(10024),1.18255615234375e-07);
ok($diceobj->probability(10025),5.91278076171875e-08);
ok($diceobj->probability(10034),5.2032470703125e-07);
ok($diceobj->probability(10035),1.0406494140625e-06);
ok($diceobj->probability(10036),1.56097412109375e-06);
ok($diceobj->probability(10037),2.081298828125e-06);
ok($diceobj->probability(10038),2.60162353515625e-06);
ok($diceobj->probability(10039),3.1219482421875e-06);
ok($diceobj->probability(10040),2.60162353515625e-06);
ok($diceobj->probability(10041),2.081298828125e-06);
ok($diceobj->probability(10042),1.56097412109375e-06);
ok($diceobj->probability(10043),1.0406494140625e-06);
ok($diceobj->probability(10044),5.2032470703125e-07);
ok($diceobj->probability(10046),5.60548570421007e-08);
ok($diceobj->probability(10047),1.12109714084201e-07);
ok($diceobj->probability(10048),1.68164571126302e-07);
ok($diceobj->probability(10049),2.24219428168403e-07);
ok($diceobj->probability(10050),2.80274285210503e-07);
ok($diceobj->probability(10051),3.36329142252604e-07);
ok($diceobj->probability(10052),2.80274285210503e-07);
ok($diceobj->probability(10053),4.92774115668403e-07);
ok($diceobj->probability(10054),7.05273946126302e-07);
ok($diceobj->probability(10055),9.17773776584201e-07);
ok($diceobj->probability(10056),1.1302736070421e-06);
ok($diceobj->probability(10057),1.3427734375e-06);
ok($diceobj->probability(10058),1.611328125e-06);
ok($diceobj->probability(10059),1.3427734375e-06);
ok($diceobj->probability(10060),1.07421875e-06);
ok($diceobj->probability(10061),8.056640625e-07);
ok($diceobj->probability(10062),5.37109375e-07);
ok($diceobj->probability(10063),2.685546875e-07);
ok($diceobj->probability(10077),6.89824422200521e-08);
ok($diceobj->probability(10078),1.37964884440104e-07);
ok($diceobj->probability(10079),2.06947326660156e-07);
ok($diceobj->probability(10080),2.75929768880208e-07);
ok($diceobj->probability(10081),3.4491221110026e-07);
ok($diceobj->probability(10082),3.46710628933377e-06);
ok($diceobj->probability(10083),6.45133548312717e-06);
ok($diceobj->probability(10084),9.43556467692057e-06);
ok($diceobj->probability(10085),1.2419793870714e-05);
ok($diceobj->probability(10086),1.54040230645074e-05);
ok($diceobj->probability(10087),1.83882522583008e-05);
ok($diceobj->probability(10088),1.52660581800673e-05);
ok($diceobj->probability(10089),1.22128465440538e-05);
ok($diceobj->probability(10090),9.15963490804036e-06);
ok($diceobj->probability(10091),6.10642327202691e-06);
ok($diceobj->probability(10092),3.05321163601345e-06);
ok($diceobj->probability(10094),6.89824422200521e-08);
ok($diceobj->probability(10095),1.37964884440104e-07);
ok($diceobj->probability(10096),2.06947326660156e-07);
ok($diceobj->probability(10097),2.75929768880208e-07);
ok($diceobj->probability(10098),3.4491221110026e-07);
ok($diceobj->probability(10099),4.13894653320312e-07);
ok($diceobj->probability(10100),1.70008341471354e-06);
ok($diceobj->probability(10101),2.98627217610677e-06);
ok($diceobj->probability(10102),4.2724609375e-06);
ok($diceobj->probability(10103),5.55864969889323e-06);
ok($diceobj->probability(10104),6.84483846028646e-06);
ok($diceobj->probability(10105),8.13102722167969e-06);
ok($diceobj->probability(10106),6.77585601806641e-06);
ok($diceobj->probability(10107),5.42068481445313e-06);
ok($diceobj->probability(10108),4.06551361083984e-06);
ok($diceobj->probability(10109),2.71034240722656e-06);
ok($diceobj->probability(10110),1.52155558268229e-06);
ok($diceobj->probability(10111),3.32768758138021e-07);
ok($diceobj->probability(10112),4.99153137207031e-07);
ok($diceobj->probability(10113),6.65537516276042e-07);
ok($diceobj->probability(10114),8.31921895345052e-07);
ok($diceobj->probability(10115),9.98306274414062e-07);
ok($diceobj->probability(10116),8.31921895345052e-07);
ok($diceobj->probability(10117),6.65537516276042e-07);
ok($diceobj->probability(10118),4.99153137207031e-07);
ok($diceobj->probability(10119),3.32768758138021e-07);
ok($diceobj->probability(10120),1.6638437906901e-07);
ok($diceobj->probability(10122),1.3031005859375e-07);
ok($diceobj->probability(10123),2.606201171875e-07);
ok($diceobj->probability(10124),3.9093017578125e-07);
ok($diceobj->probability(10125),5.21240234375e-07);
ok($diceobj->probability(10126),6.5155029296875e-07);
ok($diceobj->probability(10127),2.74295806884766e-06);
ok($diceobj->probability(10128),4.57374572753906e-06);
ok($diceobj->probability(10129),6.40453338623047e-06);
ok($diceobj->probability(10130),8.23532104492188e-06);
ok($diceobj->probability(10131),1.00661087036133e-05);
ok($diceobj->probability(10132),1.18968963623047e-05);
ok($diceobj->probability(10133),9.80548858642578e-06);
ok($diceobj->probability(10134),7.84439086914063e-06);
ok($diceobj->probability(10135),5.88329315185547e-06);
ok($diceobj->probability(10136),3.92219543457031e-06);
ok($diceobj->probability(10137),1.96109771728516e-06);
ok($diceobj->probability(10142),1.31575266520182e-06);
ok($diceobj->probability(10143),2.63150533040365e-06);
ok($diceobj->probability(10144),3.94725799560547e-06);
ok($diceobj->probability(10145),5.26301066080729e-06);
ok($diceobj->probability(10146),6.57876332600911e-06);
ok($diceobj->probability(10147),7.89451599121094e-06);
ok($diceobj->probability(10148),6.57876332600911e-06);
ok($diceobj->probability(10149),5.26301066080729e-06);
ok($diceobj->probability(10150),3.94725799560547e-06);
ok($diceobj->probability(10151),2.63150533040365e-06);
ok($diceobj->probability(10152),2.12256113688151e-06);
ok($diceobj->probability(10153),1.61361694335937e-06);
ok($diceobj->probability(10154),2.42042541503906e-06);
ok($diceobj->probability(10155),3.22723388671875e-06);
ok($diceobj->probability(10156),4.03404235839844e-06);
ok($diceobj->probability(10157),4.84085083007812e-06);
ok($diceobj->probability(10158),4.03404235839844e-06);
ok($diceobj->probability(10159),3.22723388671875e-06);
ok($diceobj->probability(10160),2.42042541503906e-06);
ok($diceobj->probability(10161),1.61361694335937e-06);
ok($diceobj->probability(10162),8.06808471679687e-07);
ok($diceobj->probability(10168),1.66447957356771e-06);
ok($diceobj->probability(10169),3.32895914713542e-06);
ok($diceobj->probability(10170),4.99343872070312e-06);
ok($diceobj->probability(10171),6.65791829427083e-06);
ok($diceobj->probability(10172),8.32239786783854e-06);
ok($diceobj->probability(10173),9.98687744140625e-06);
ok($diceobj->probability(10174),8.32239786783854e-06);
ok($diceobj->probability(10175),6.65791829427083e-06);
ok($diceobj->probability(10176),4.99343872070312e-06);
ok($diceobj->probability(10177),3.32895914713542e-06);
ok($diceobj->probability(10178),1.66447957356771e-06);
ok($diceobj->probability(10181),4.48714362250434e-07);
ok($diceobj->probability(10182),8.97428724500868e-07);
ok($diceobj->probability(10183),1.3461430867513e-06);
ok($diceobj->probability(10184),1.79485744900174e-06);
ok($diceobj->probability(10185),2.24357181125217e-06);
ok($diceobj->probability(10186),2.6922861735026e-06);
ok($diceobj->probability(10187),2.24357181125217e-06);
ok($diceobj->probability(10188),1.79485744900174e-06);
ok($diceobj->probability(10189),1.3461430867513e-06);
ok($diceobj->probability(10190),8.97428724500868e-07);
ok($diceobj->probability(10191),4.48714362250434e-07);
ok($diceobj->probability(10194),1.40565236409505e-06);
ok($diceobj->probability(10195),2.8113047281901e-06);
ok($diceobj->probability(10196),4.21695709228516e-06);
ok($diceobj->probability(10197),5.62260945638021e-06);
ok($diceobj->probability(10198),7.02826182047526e-06);
ok($diceobj->probability(10199),8.43391418457031e-06);
ok($diceobj->probability(10200),7.02826182047526e-06);
ok($diceobj->probability(10201),5.62260945638021e-06);
ok($diceobj->probability(10202),6.27216339111328e-06);
ok($diceobj->probability(10203),6.92171732584635e-06);
ok($diceobj->probability(10204),7.57127126057943e-06);
ok($diceobj->probability(10205),8.2208251953125e-06);
ok($diceobj->probability(10206),1.02760314941406e-05);
ok($diceobj->probability(10207),1.23312377929687e-05);
ok($diceobj->probability(10208),1.15981419881185e-05);
ok($diceobj->probability(10209),1.08650461832682e-05);
ok($diceobj->probability(10210),1.09097671508789e-05);
ok($diceobj->probability(10211),1.09544881184896e-05);
ok($diceobj->probability(10212),1.09992090861003e-05);
ok($diceobj->probability(10213),1.10439300537109e-05);
ok($diceobj->probability(10214),1.0499636332194e-05);
ok($diceobj->probability(10215),9.95534261067708e-06);
ok($diceobj->probability(10216),7.85541534423828e-06);
ok($diceobj->probability(10217),5.75548807779948e-06);
ok($diceobj->probability(10218),3.65556081136068e-06);
ok($diceobj->probability(10219),1.55563354492187e-06);
ok($diceobj->probability(10220),7.77816772460937e-07);
ok($diceobj->probability(10232),9.918212890625e-08);
ok($diceobj->probability(10233),1.983642578125e-07);
ok($diceobj->probability(10234),2.9754638671875e-07);
ok($diceobj->probability(10235),3.96728515625e-07);
ok($diceobj->probability(10236),4.9591064453125e-07);
ok($diceobj->probability(10237),5.950927734375e-07);
ok($diceobj->probability(10238),4.9591064453125e-07);
ok($diceobj->probability(10239),3.96728515625e-07);
ok($diceobj->probability(10240),2.9754638671875e-07);
ok($diceobj->probability(10241),1.983642578125e-07);
ok($diceobj->probability(10242),1.16856892903646e-07);
ok($diceobj->probability(10243),3.53495279947917e-08);
ok($diceobj->probability(10244),5.30242919921875e-08);
ok($diceobj->probability(10245),7.06990559895833e-08);
ok($diceobj->probability(10246),8.83738199869792e-08);
ok($diceobj->probability(10247),1.06048583984375e-07);
ok($diceobj->probability(10248),8.83738199869792e-08);
ok($diceobj->probability(10249),7.06990559895833e-08);
ok($diceobj->probability(10250),5.30242919921875e-08);
ok($diceobj->probability(10251),3.53495279947917e-08);
ok($diceobj->probability(10252),1.76747639973958e-08);
ok($diceobj->probability(10262),4.47014702690972e-07);
ok($diceobj->probability(10263),8.94029405381944e-07);
ok($diceobj->probability(10264),1.34104410807292e-06);
ok($diceobj->probability(10265),1.78805881076389e-06);
ok($diceobj->probability(10266),2.23507351345486e-06);
ok($diceobj->probability(10267),2.68208821614583e-06);
ok($diceobj->probability(10268),2.23507351345486e-06);
ok($diceobj->probability(10269),1.78805881076389e-06);
ok($diceobj->probability(10270),1.34104410807292e-06);
ok($diceobj->probability(10271),8.94029405381944e-07);
ok($diceobj->probability(10272),4.47014702690972e-07);
ok($diceobj->probability(10298),8.66889953613281e-07);
ok($diceobj->probability(10299),1.73377990722656e-06);
ok($diceobj->probability(10300),2.60066986083984e-06);
ok($diceobj->probability(10301),3.46755981445313e-06);
ok($diceobj->probability(10302),4.33444976806641e-06);
ok($diceobj->probability(10303),5.20133972167969e-06);
ok($diceobj->probability(10304),4.33444976806641e-06);
ok($diceobj->probability(10305),3.46755981445313e-06);
ok($diceobj->probability(10306),3.86765797932943e-06);
ok($diceobj->probability(10307),4.26775614420573e-06);
ok($diceobj->probability(10308),4.66785430908203e-06);
ok($diceobj->probability(10309),5.06795247395833e-06);
ok($diceobj->probability(10310),6.33494059244792e-06);
ok($diceobj->probability(10311),7.6019287109375e-06);
ok($diceobj->probability(10312),6.33494059244792e-06);
ok($diceobj->probability(10313),5.06795247395833e-06);
ok($diceobj->probability(10314),3.80096435546875e-06);
ok($diceobj->probability(10315),2.53397623697917e-06);
ok($diceobj->probability(10316),1.26698811848958e-06);
ok($diceobj->probability(10338),1.18255615234375e-08);
ok($diceobj->probability(10339),2.3651123046875e-08);
ok($diceobj->probability(10340),3.54766845703125e-08);
ok($diceobj->probability(10341),4.730224609375e-08);
ok($diceobj->probability(10342),5.91278076171875e-08);
ok($diceobj->probability(10343),7.0953369140625e-08);
ok($diceobj->probability(10344),5.91278076171875e-08);
ok($diceobj->probability(10345),4.730224609375e-08);
ok($diceobj->probability(10346),3.54766845703125e-08);
ok($diceobj->probability(10347),2.3651123046875e-08);
ok($diceobj->probability(10348),1.18255615234375e-08);
ok($diceobj->probability(10352),1.36681450737847e-06);
ok($diceobj->probability(10353),2.73362901475694e-06);
ok($diceobj->probability(10354),4.10044352213542e-06);
ok($diceobj->probability(10355),5.96200307210286e-06);
ok($diceobj->probability(10356),7.82356262207031e-06);
ok($diceobj->probability(10357),9.68512217203776e-06);
ok($diceobj->probability(10358),8.81305270724826e-06);
ok($diceobj->probability(10359),7.94098324245877e-06);
ok($diceobj->probability(10360),7.06891377766927e-06);
ok($diceobj->probability(10361),5.20735422770182e-06);
ok($diceobj->probability(10362),3.34579467773437e-06);
ok($diceobj->probability(10363),1.48423512776693e-06);
ok($diceobj->probability(10364),9.89490085177951e-07);
ok($diceobj->probability(10365),4.94745042588976e-07);
ok($diceobj->probability(10370),2.17363569471571e-06);
ok($diceobj->probability(10371),4.34727138943142e-06);
ok($diceobj->probability(10372),6.52090708414714e-06);
ok($diceobj->probability(10373),8.69454277886285e-06);
ok($diceobj->probability(10374),1.08681784735786e-05);
ok($diceobj->probability(10375),1.30418141682943e-05);
ok($diceobj->probability(10376),1.12099117702908e-05);
ok($diceobj->probability(10377),9.37800937228733e-06);
ok($diceobj->probability(10378),7.54610697428385e-06);
ok($diceobj->probability(10379),5.71420457628038e-06);
ok($diceobj->probability(10380),3.88230217827691e-06);
ok($diceobj->probability(10381),2.05039978027344e-06);
ok($diceobj->probability(10382),1.7086664835612e-06);
ok($diceobj->probability(10383),1.36693318684896e-06);
ok($diceobj->probability(10384),1.02519989013672e-06);
ok($diceobj->probability(10385),6.83466593424479e-07);
ok($diceobj->probability(10386),3.4173329671224e-07);
ok($diceobj->probability(10402),1.97499593098958e-06);
ok($diceobj->probability(10403),3.94999186197917e-06);
ok($diceobj->probability(10404),5.92498779296875e-06);
ok($diceobj->probability(10405),7.89998372395833e-06);
ok($diceobj->probability(10406),9.87497965494792e-06);
ok($diceobj->probability(10407),1.18499755859375e-05);
ok($diceobj->probability(10408),9.87497965494792e-06);
ok($diceobj->probability(10409),7.89998372395833e-06);
ok($diceobj->probability(10410),5.92498779296875e-06);
ok($diceobj->probability(10411),3.94999186197917e-06);
ok($diceobj->probability(10412),1.97499593098958e-06);
ok($diceobj->probability(10418),1.75582038031684e-07);
ok($diceobj->probability(10419),3.51164076063368e-07);
ok($diceobj->probability(10420),5.26746114095052e-07);
ok($diceobj->probability(10421),7.02328152126736e-07);
ok($diceobj->probability(10422),8.7791019015842e-07);
ok($diceobj->probability(10423),1.0534922281901e-06);
ok($diceobj->probability(10424),8.7791019015842e-07);
ok($diceobj->probability(10425),7.02328152126736e-07);
ok($diceobj->probability(10426),5.26746114095052e-07);
ok($diceobj->probability(10427),3.51164076063368e-07);
ok($diceobj->probability(10428),1.75582038031684e-07);
ok($diceobj->probability(10442),1.09786139594184e-06);
ok($diceobj->probability(10443),2.19572279188368e-06);
ok($diceobj->probability(10444),3.29358418782552e-06);
ok($diceobj->probability(10445),4.39144558376736e-06);
ok($diceobj->probability(10446),5.4893069797092e-06);
ok($diceobj->probability(10447),6.58716837565104e-06);
ok($diceobj->probability(10448),5.4893069797092e-06);
ok($diceobj->probability(10449),4.39144558376736e-06);
ok($diceobj->probability(10450),3.29358418782552e-06);
ok($diceobj->probability(10451),2.19572279188368e-06);
ok($diceobj->probability(10452),1.49668799506293e-06);
ok($diceobj->probability(10453),7.97653198242188e-07);
ok($diceobj->probability(10454),1.19647979736328e-06);
ok($diceobj->probability(10455),1.59530639648438e-06);
ok($diceobj->probability(10456),1.99413299560547e-06);
ok($diceobj->probability(10457),2.39295959472656e-06);
ok($diceobj->probability(10458),1.99413299560547e-06);
ok($diceobj->probability(10459),1.59530639648438e-06);
ok($diceobj->probability(10460),1.19647979736328e-06);
ok($diceobj->probability(10461),7.97653198242188e-07);
ok($diceobj->probability(10462),3.98826599121094e-07);
ok($diceobj->probability(10471),8.53856404622396e-08);
ok($diceobj->probability(10472),1.70771280924479e-07);
ok($diceobj->probability(10473),2.56156921386719e-07);
ok($diceobj->probability(10474),1.15731557210286e-06);
ok($diceobj->probability(10475),2.05847422281901e-06);
ok($diceobj->probability(10476),2.95963287353516e-06);
ok($diceobj->probability(10477),3.69002024332682e-06);
ok($diceobj->probability(10478),4.42040761311849e-06);
ok($diceobj->probability(10479),5.15079498291016e-06);
ok($diceobj->probability(10480),4.29890950520833e-06);
ok($diceobj->probability(10481),3.44702402750651e-06);
ok($diceobj->probability(10482),2.59513854980469e-06);
ok($diceobj->probability(10483),1.8286387125651e-06);
ok($diceobj->probability(10484),1.06213887532552e-06);
ok($diceobj->probability(10485),2.95639038085937e-07);
ok($diceobj->probability(10486),2.46365865071615e-07);
ok($diceobj->probability(10487),1.97092692057292e-07);
ok($diceobj->probability(10488),1.47819519042969e-07);
ok($diceobj->probability(10489),9.85463460286458e-08);
ok($diceobj->probability(10490),4.77875603569878e-07);
ok($diceobj->probability(10491),8.57204861111111e-07);
ok($diceobj->probability(10492),1.28580729166667e-06);
ok($diceobj->probability(10493),1.71440972222222e-06);
ok($diceobj->probability(10494),2.14301215277778e-06);
ok($diceobj->probability(10495),2.57161458333333e-06);
ok($diceobj->probability(10496),2.14301215277778e-06);
ok($diceobj->probability(10497),1.71440972222222e-06);
ok($diceobj->probability(10498),1.28580729166667e-06);
ok($diceobj->probability(10499),8.57204861111111e-07);
ok($diceobj->probability(10500),4.28602430555556e-07);
ok($diceobj->probability(10502),1.58353169759115e-06);
ok($diceobj->probability(10503),3.16706339518229e-06);
ok($diceobj->probability(10504),4.75059509277344e-06);
ok($diceobj->probability(10505),6.33412679036458e-06);
ok($diceobj->probability(10506),7.91765848795573e-06);
ok($diceobj->probability(10507),9.50119018554687e-06);
ok($diceobj->probability(10508),7.91765848795573e-06);
ok($diceobj->probability(10509),6.33412679036458e-06);
ok($diceobj->probability(10510),4.75059509277344e-06);
ok($diceobj->probability(10511),3.16706339518229e-06);
ok($diceobj->probability(10512),1.58353169759115e-06);
ok($diceobj->probability(10532),1.5906016031901e-06);
ok($diceobj->probability(10533),3.18120320638021e-06);
ok($diceobj->probability(10534),4.77180480957031e-06);
ok($diceobj->probability(10535),6.36240641276042e-06);
ok($diceobj->probability(10536),7.95300801595052e-06);
ok($diceobj->probability(10537),9.54360961914062e-06);
ok($diceobj->probability(10538),7.95300801595052e-06);
ok($diceobj->probability(10539),6.36240641276042e-06);
ok($diceobj->probability(10540),4.77180480957031e-06);
ok($diceobj->probability(10541),3.18120320638021e-06);
ok($diceobj->probability(10542),1.63892110188802e-06);
ok($diceobj->probability(10543),9.66389973958333e-08);
ok($diceobj->probability(10544),1.4495849609375e-07);
ok($diceobj->probability(10545),1.93277994791667e-07);
ok($diceobj->probability(10546),2.41597493489583e-07);
ok($diceobj->probability(10547),2.899169921875e-07);
ok($diceobj->probability(10548),2.41597493489583e-07);
ok($diceobj->probability(10549),1.93277994791667e-07);
ok($diceobj->probability(10550),1.4495849609375e-07);
ok($diceobj->probability(10551),9.66389973958333e-08);
ok($diceobj->probability(10552),4.83194986979167e-08);
ok($diceobj->probability(10558),8.53665669759115e-07);
ok($diceobj->probability(10559),2.82232496473524e-06);
ok($diceobj->probability(10560),4.79098425971137e-06);
ok($diceobj->probability(10561),6.7596435546875e-06);
ok($diceobj->probability(10562),9.15223015679253e-06);
ok($diceobj->probability(10563),1.15448167588976e-05);
ok($diceobj->probability(10564),1.22300720214844e-05);
ok($diceobj->probability(10565),1.06853400336372e-05);
ok($diceobj->probability(10566),9.14060804578993e-06);
ok($diceobj->probability(10567),7.59587605794271e-06);
ok($diceobj->probability(10568),5.20328945583767e-06);
ok($diceobj->probability(10569),2.81070285373264e-06);
ok($diceobj->probability(10570),1.27178192138672e-06);
ok($diceobj->probability(10571),8.47854614257813e-07);
ok($diceobj->probability(10572),4.23927307128906e-07);
ok($diceobj->probability(10582),5.37109375e-08);
ok($diceobj->probability(10583),1.07421875e-07);
ok($diceobj->probability(10584),1.611328125e-07);
ok($diceobj->probability(10585),2.1484375e-07);
ok($diceobj->probability(10586),1.44659678141276e-06);
ok($diceobj->probability(10587),2.67834981282552e-06);
ok($diceobj->probability(10588),3.80268096923828e-06);
ok($diceobj->probability(10589),4.92701212565104e-06);
ok($diceobj->probability(10590),6.0513432820638e-06);
ok($diceobj->probability(10591),7.17567443847656e-06);
ok($diceobj->probability(10592),5.9439214070638e-06);
ok($diceobj->probability(10593),4.71216837565104e-06);
ok($diceobj->probability(10594),3.53412628173828e-06);
ok($diceobj->probability(10595),2.35608418782552e-06);
ok($diceobj->probability(10596),1.17804209391276e-06);
ok($diceobj->probability(10604),2.96698676215278e-08);
ok($diceobj->probability(10605),5.93397352430556e-08);
ok($diceobj->probability(10606),8.90096028645833e-08);
ok($diceobj->probability(10607),1.18679470486111e-07);
ok($diceobj->probability(10608),1.48349338107639e-07);
ok($diceobj->probability(10609),1.78019205729167e-07);
ok($diceobj->probability(10610),1.47459242078993e-06);
ok($diceobj->probability(10611),2.77116563585069e-06);
ok($diceobj->probability(10612),4.06773885091146e-06);
ok($diceobj->probability(10613),5.36431206597222e-06);
ok($diceobj->probability(10614),6.66088528103299e-06);
ok($diceobj->probability(10615),7.95745849609375e-06);
ok($diceobj->probability(10616),6.63121541341146e-06);
ok($diceobj->probability(10617),5.30497233072917e-06);
ok($diceobj->probability(10618),3.97872924804687e-06);
ok($diceobj->probability(10619),2.65248616536458e-06);
ok($diceobj->probability(10620),1.32624308268229e-06);
ok($diceobj->probability(10627),7.00950622558594e-07);
ok($diceobj->probability(10628),1.40190124511719e-06);
ok($diceobj->probability(10629),2.10285186767578e-06);
ok($diceobj->probability(10630),2.80380249023437e-06);
ok($diceobj->probability(10631),3.50475311279297e-06);
ok($diceobj->probability(10632),4.20570373535156e-06);
ok($diceobj->probability(10633),3.50475311279297e-06);
ok($diceobj->probability(10634),2.80380249023437e-06);
ok($diceobj->probability(10635),2.10285186767578e-06);
ok($diceobj->probability(10636),1.40190124511719e-06);
ok($diceobj->probability(10637),7.00950622558594e-07);
ok($diceobj->probability(10642),1.88090006510417e-07);
ok($diceobj->probability(10643),3.76180013020833e-07);
ok($diceobj->probability(10644),5.6427001953125e-07);
ok($diceobj->probability(10645),7.52360026041667e-07);
ok($diceobj->probability(10646),9.40450032552083e-07);
ok($diceobj->probability(10647),1.1285400390625e-06);
ok($diceobj->probability(10648),9.40450032552083e-07);
ok($diceobj->probability(10649),7.52360026041667e-07);
ok($diceobj->probability(10650),5.6427001953125e-07);
ok($diceobj->probability(10651),3.76180013020833e-07);
ok($diceobj->probability(10652),1.88090006510417e-07);
ok($diceobj->probability(10674),6.38071695963542e-07);
ok($diceobj->probability(10675),1.27614339192708e-06);
ok($diceobj->probability(10676),1.91421508789063e-06);
ok($diceobj->probability(10677),2.55228678385417e-06);
ok($diceobj->probability(10678),3.19035847981771e-06);
ok($diceobj->probability(10679),3.82843017578125e-06);
ok($diceobj->probability(10680),3.19035847981771e-06);
ok($diceobj->probability(10681),2.55228678385417e-06);
ok($diceobj->probability(10682),1.91421508789063e-06);
ok($diceobj->probability(10683),1.27614339192708e-06);
ok($diceobj->probability(10684),6.38071695963542e-07);
ok($diceobj->probability(10694),5.80787658691406e-07);
ok($diceobj->probability(10695),1.16157531738281e-06);
ok($diceobj->probability(10696),1.74236297607422e-06);
ok($diceobj->probability(10697),2.40020751953125e-06);
ok($diceobj->probability(10698),3.05805206298828e-06);
ok($diceobj->probability(10699),3.71589660644531e-06);
ok($diceobj->probability(10700),3.21216583251953e-06);
ok($diceobj->probability(10701),2.70843505859375e-06);
ok($diceobj->probability(10702),2.20470428466797e-06);
ok($diceobj->probability(10703),1.54685974121094e-06);
ok($diceobj->probability(10704),8.89015197753906e-07);
ok($diceobj->probability(10705),2.31170654296875e-07);
ok($diceobj->probability(10706),1.5411376953125e-07);
ok($diceobj->probability(10707),7.7056884765625e-08);
ok($diceobj->probability(10712),1.92112392849392e-07);
ok($diceobj->probability(10713),3.84224785698785e-07);
ok($diceobj->probability(10714),5.76337178548177e-07);
ok($diceobj->probability(10715),7.68449571397569e-07);
ok($diceobj->probability(10716),9.60561964246962e-07);
ok($diceobj->probability(10717),1.15267435709635e-06);
ok($diceobj->probability(10718),9.60561964246962e-07);
ok($diceobj->probability(10719),7.68449571397569e-07);
ok($diceobj->probability(10720),5.76337178548177e-07);
ok($diceobj->probability(10721),3.84224785698785e-07);
ok($diceobj->probability(10722),1.92112392849392e-07);
ok($diceobj->probability(10754),1.02803972032335e-06);
ok($diceobj->probability(10755),2.0560794406467e-06);
ok($diceobj->probability(10756),3.08411916097005e-06);
ok($diceobj->probability(10757),4.1121588812934e-06);
ok($diceobj->probability(10758),5.14019860161675e-06);
ok($diceobj->probability(10759),6.1682383219401e-06);
ok($diceobj->probability(10760),5.14019860161675e-06);
ok($diceobj->probability(10761),4.1121588812934e-06);
ok($diceobj->probability(10762),3.08411916097005e-06);
ok($diceobj->probability(10763),2.0560794406467e-06);
ok($diceobj->probability(10764),1.02803972032335e-06);
ok($diceobj->probability(10766),7.13348388671875e-07);
ok($diceobj->probability(10767),1.42669677734375e-06);
ok($diceobj->probability(10768),2.14004516601563e-06);
ok($diceobj->probability(10769),2.8533935546875e-06);
ok($diceobj->probability(10770),3.56674194335938e-06);
ok($diceobj->probability(10771),4.28009033203125e-06);
ok($diceobj->probability(10772),3.56674194335938e-06);
ok($diceobj->probability(10773),2.8533935546875e-06);
ok($diceobj->probability(10774),2.14004516601563e-06);
ok($diceobj->probability(10775),1.65568457709418e-06);
ok($diceobj->probability(10776),1.17132398817274e-06);
ok($diceobj->probability(10777),6.86963399251302e-07);
ok($diceobj->probability(10778),9.15951199001736e-07);
ok($diceobj->probability(10779),1.14493899875217e-06);
ok($diceobj->probability(10780),1.3739267985026e-06);
ok($diceobj->probability(10781),1.14493899875217e-06);
ok($diceobj->probability(10782),9.15951199001736e-07);
ok($diceobj->probability(10783),6.86963399251302e-07);
ok($diceobj->probability(10784),4.57975599500868e-07);
ok($diceobj->probability(10785),2.28987799750434e-07);
ok($diceobj->probability(10790),9.85463460286458e-09);
ok($diceobj->probability(10791),1.97092692057292e-08);
ok($diceobj->probability(10792),2.95639038085937e-08);
ok($diceobj->probability(10793),3.94185384114583e-08);
ok($diceobj->probability(10794),4.92731730143229e-08);
ok($diceobj->probability(10795),5.91278076171875e-08);
ok($diceobj->probability(10796),4.92731730143229e-08);
ok($diceobj->probability(10797),3.94185384114583e-08);
ok($diceobj->probability(10798),2.95639038085937e-08);
ok($diceobj->probability(10799),1.97092692057292e-08);
ok($diceobj->probability(10800),9.85463460286458e-09);
ok($diceobj->probability(10802),2.51121097140842e-06);
ok($diceobj->probability(10803),5.02242194281684e-06);
ok($diceobj->probability(10804),7.53363291422526e-06);
ok($diceobj->probability(10805),1.00448438856337e-05);
ok($diceobj->probability(10806),1.25560548570421e-05);
ok($diceobj->probability(10807),1.50672658284505e-05);
ok($diceobj->probability(10808),1.25560548570421e-05);
ok($diceobj->probability(10809),1.00448438856337e-05);
ok($diceobj->probability(10810),7.53363291422526e-06);
ok($diceobj->probability(10811),5.02242194281684e-06);
ok($diceobj->probability(10812),2.51121097140842e-06);
ok($diceobj->probability(10818),6.91731770833333e-07);
ok($diceobj->probability(10819),1.38346354166667e-06);
ok($diceobj->probability(10820),2.0751953125e-06);
ok($diceobj->probability(10821),2.76692708333333e-06);
ok($diceobj->probability(10822),3.45865885416667e-06);
ok($diceobj->probability(10823),4.150390625e-06);
ok($diceobj->probability(10824),3.45865885416667e-06);
ok($diceobj->probability(10825),2.76692708333333e-06);
ok($diceobj->probability(10826),2.0751953125e-06);
ok($diceobj->probability(10827),1.38346354166667e-06);
ok($diceobj->probability(10828),6.91731770833333e-07);
ok($diceobj->probability(10832),3.33362155490451e-08);
ok($diceobj->probability(10833),6.66724310980903e-08);
ok($diceobj->probability(10834),1.00008646647135e-07);
ok($diceobj->probability(10835),1.33344862196181e-07);
ok($diceobj->probability(10836),1.66681077745226e-07);
ok($diceobj->probability(10837),2.00017293294271e-07);
ok($diceobj->probability(10838),1.66681077745226e-07);
ok($diceobj->probability(10839),1.33344862196181e-07);
ok($diceobj->probability(10840),1.00008646647135e-07);
ok($diceobj->probability(10841),6.66724310980903e-08);
ok($diceobj->probability(10842),3.33362155490451e-08);
ok($diceobj->probability(10848),4.17900085449219e-07);
ok($diceobj->probability(10849),8.35800170898437e-07);
ok($diceobj->probability(10850),1.25370025634766e-06);
ok($diceobj->probability(10851),1.67160034179687e-06);
ok($diceobj->probability(10852),2.14958190917969e-06);
ok($diceobj->probability(10853),2.6275634765625e-06);
ok($diceobj->probability(10854),2.26974487304687e-06);
ok($diceobj->probability(10855),1.91192626953125e-06);
ok($diceobj->probability(10856),1.55410766601562e-06);
ok($diceobj->probability(10857),1.1962890625e-06);
ok($diceobj->probability(10858),7.18307495117187e-07);
ok($diceobj->probability(10859),2.40325927734375e-07);
ok($diceobj->probability(10860),1.80244445800781e-07);
ok($diceobj->probability(10861),1.20162963867188e-07);
ok($diceobj->probability(10862),6.00814819335938e-08);
ok($diceobj->probability(10870),2.88963317871094e-07);
ok($diceobj->probability(10871),5.77926635742187e-07);
ok($diceobj->probability(10872),8.66889953613281e-07);
ok($diceobj->probability(10873),1.15585327148437e-06);
ok($diceobj->probability(10874),1.44481658935547e-06);
ok($diceobj->probability(10875),1.73377990722656e-06);
ok($diceobj->probability(10876),1.44481658935547e-06);
ok($diceobj->probability(10877),1.75946553548177e-06);
ok($diceobj->probability(10878),2.07411448160807e-06);
ok($diceobj->probability(10879),2.38876342773437e-06);
ok($diceobj->probability(10880),2.70341237386068e-06);
ok($diceobj->probability(10881),3.01806131998698e-06);
ok($diceobj->probability(10882),3.63133748372396e-06);
ok($diceobj->probability(10883),3.07023790147569e-06);
ok($diceobj->probability(10884),2.50913831922743e-06);
ok($diceobj->probability(10885),1.94803873697917e-06);
ok($diceobj->probability(10886),1.3869391547309e-06);
ok($diceobj->probability(10887),8.25839572482639e-07);
ok($diceobj->probability(10888),2.45412190755208e-07);
ok($diceobj->probability(10889),2.02899509006076e-07);
ok($diceobj->probability(10890),1.60386827256944e-07);
ok($diceobj->probability(10891),1.17874145507813e-07);
ok($diceobj->probability(10892),7.53614637586805e-08);
ok($diceobj->probability(10893),3.28487820095486e-08);
ok($diceobj->probability(10914),6.19888305664063e-08);
ok($diceobj->probability(10915),1.23977661132813e-07);
ok($diceobj->probability(10916),1.85966491699219e-07);
ok($diceobj->probability(10917),2.47955322265625e-07);
ok($diceobj->probability(10918),3.09944152832031e-07);
ok($diceobj->probability(10919),3.71932983398438e-07);
ok($diceobj->probability(10920),3.09944152832031e-07);
ok($diceobj->probability(10921),2.47955322265625e-07);
ok($diceobj->probability(10922),1.43466525607639e-06);
ok($diceobj->probability(10923),2.62137518988715e-06);
ok($diceobj->probability(10924),3.80808512369792e-06);
ok($diceobj->probability(10925),4.99479505750868e-06);
ok($diceobj->probability(10926),6.24349382188585e-06);
ok($diceobj->probability(10927),7.82051086425781e-06);
ok($diceobj->probability(10928),6.90013037787543e-06);
ok($diceobj->probability(10929),5.97974989149306e-06);
ok($diceobj->probability(10930),5.05936940511068e-06);
ok($diceobj->probability(10931),4.1389889187283e-06);
ok($diceobj->probability(10932),3.21860843234592e-06);
ok($diceobj->probability(10933),1.64159138997396e-06);
ok($diceobj->probability(10934),1.31327311197917e-06);
ok($diceobj->probability(10935),1.05393727620443e-06);
ok($diceobj->probability(10936),7.94601440429688e-07);
ok($diceobj->probability(10937),1.0104497273763e-06);
ok($diceobj->probability(10938),1.22629801432292e-06);
ok($diceobj->probability(10939),1.77046457926432e-06);
ok($diceobj->probability(10940),2.31463114420573e-06);
ok($diceobj->probability(10941),2.72083282470703e-06);
ok($diceobj->probability(10942),3.12703450520833e-06);
ok($diceobj->probability(10943),2.58286794026693e-06);
ok($diceobj->probability(10944),2.03870137532552e-06);
ok($diceobj->probability(10945),1.49453481038411e-06);
ok($diceobj->probability(10946),1.12720065646701e-06);
ok($diceobj->probability(10947),8.28848944769965e-07);
ok($diceobj->probability(10948),5.30497233072917e-07);
ok($diceobj->probability(10949),7.07329644097222e-07);
ok($diceobj->probability(10950),1.55529446072049e-06);
ok($diceobj->probability(10951),2.40325927734375e-06);
ok($diceobj->probability(10952),2.8975592719184e-06);
ok($diceobj->probability(10953),3.39185926649306e-06);
ok($diceobj->probability(10954),3.88615926106771e-06);
ok($diceobj->probability(10955),4.38045925564236e-06);
ok($diceobj->probability(10956),3.5324944390191e-06);
ok($diceobj->probability(10957),2.68452962239583e-06);
ok($diceobj->probability(10958),2.01339721679688e-06);
ok($diceobj->probability(10959),1.34226481119792e-06);
ok($diceobj->probability(10960),6.71132405598958e-07);
ok($diceobj->probability(10964),6.02849324544271e-07);
ok($diceobj->probability(10965),1.20569864908854e-06);
ok($diceobj->probability(10966),1.80854797363281e-06);
ok($diceobj->probability(10967),2.41139729817708e-06);
ok($diceobj->probability(10968),3.01424662272135e-06);
ok($diceobj->probability(10969),3.61709594726563e-06);
ok($diceobj->probability(10970),3.01424662272135e-06);
ok($diceobj->probability(10971),2.41139729817708e-06);
ok($diceobj->probability(10972),1.80854797363281e-06);
ok($diceobj->probability(10973),1.20569864908854e-06);
ok($diceobj->probability(10974),6.02849324544271e-07);
ok($diceobj->probability(10978),2.30026245117187e-07);
ok($diceobj->probability(10979),4.60052490234375e-07);
ok($diceobj->probability(10980),6.90078735351563e-07);
ok($diceobj->probability(10981),9.2010498046875e-07);
ok($diceobj->probability(10982),1.15013122558594e-06);
ok($diceobj->probability(10983),1.38015747070313e-06);
ok($diceobj->probability(10984),1.15013122558594e-06);
ok($diceobj->probability(10985),9.2010498046875e-07);
ok($diceobj->probability(10986),6.90078735351563e-07);
ok($diceobj->probability(10987),4.60052490234375e-07);
ok($diceobj->probability(10988),2.30026245117187e-07);
ok($diceobj->probability(11002),7.97653198242188e-08);
ok($diceobj->probability(11003),1.59530639648438e-07);
ok($diceobj->probability(11004),2.39295959472656e-07);
ok($diceobj->probability(11005),3.19061279296875e-07);
ok($diceobj->probability(11006),3.98826599121094e-07);
ok($diceobj->probability(11007),4.78591918945312e-07);
ok($diceobj->probability(11008),3.98826599121094e-07);
ok($diceobj->probability(11009),3.19061279296875e-07);
ok($diceobj->probability(11010),2.39295959472656e-07);
ok($diceobj->probability(11011),1.59530639648438e-07);
ok($diceobj->probability(11012),7.97653198242188e-08);
ok($diceobj->probability(11018),8.88315836588542e-07);
ok($diceobj->probability(11019),1.77663167317708e-06);
ok($diceobj->probability(11020),2.66494750976562e-06);
ok($diceobj->probability(11021),3.55326334635417e-06);
ok($diceobj->probability(11022),4.53806559244792e-06);
ok($diceobj->probability(11023),5.52286783854167e-06);
ok($diceobj->probability(11024),4.73103841145833e-06);
ok($diceobj->probability(11025),3.939208984375e-06);
ok($diceobj->probability(11026),3.14737955729167e-06);
ok($diceobj->probability(11027),2.35555013020833e-06);
ok($diceobj->probability(11028),1.37074788411458e-06);
ok($diceobj->probability(11029),3.85945638020833e-07);
ok($diceobj->probability(11030),2.89459228515625e-07);
ok($diceobj->probability(11031),1.92972819010417e-07);
ok($diceobj->probability(11032),9.64864095052083e-08);
ok($diceobj->probability(11042),3.46883138020833e-07);
ok($diceobj->probability(11043),6.93766276041667e-07);
ok($diceobj->probability(11044),1.0406494140625e-06);
ok($diceobj->probability(11045),1.38753255208333e-06);
ok($diceobj->probability(11046),1.73441569010417e-06);
ok($diceobj->probability(11047),2.081298828125e-06);
ok($diceobj->probability(11048),1.73441569010417e-06);
ok($diceobj->probability(11049),1.38753255208333e-06);
ok($diceobj->probability(11050),1.0406494140625e-06);
ok($diceobj->probability(11051),6.93766276041667e-07);
ok($diceobj->probability(11052),1.36159261067708e-06);
ok($diceobj->probability(11053),2.0294189453125e-06);
ok($diceobj->probability(11054),3.04412841796875e-06);
ok($diceobj->probability(11055),4.058837890625e-06);
ok($diceobj->probability(11056),5.07354736328125e-06);
ok($diceobj->probability(11057),6.0882568359375e-06);
ok($diceobj->probability(11058),5.07354736328125e-06);
ok($diceobj->probability(11059),4.058837890625e-06);
ok($diceobj->probability(11060),3.04412841796875e-06);
ok($diceobj->probability(11061),2.0294189453125e-06);
ok($diceobj->probability(11062),1.01470947265625e-06);
ok($diceobj->probability(11069),4.07960679796007e-08);
ok($diceobj->probability(11070),8.15921359592014e-08);
ok($diceobj->probability(11071),1.22388203938802e-07);
ok($diceobj->probability(11072),1.63184271918403e-07);
ok($diceobj->probability(11073),2.03980339898003e-07);
ok($diceobj->probability(11074),2.44776407877604e-07);
ok($diceobj->probability(11075),2.03980339898003e-07);
ok($diceobj->probability(11076),1.63184271918403e-07);
ok($diceobj->probability(11077),1.22388203938802e-07);
ok($diceobj->probability(11078),8.15921359592014e-08);
ok($diceobj->probability(11079),4.07960679796007e-08);
ok($diceobj->probability(11090),3.49617004394531e-07);
ok($diceobj->probability(11091),6.99234008789062e-07);
ok($diceobj->probability(11092),1.04885101318359e-06);
ok($diceobj->probability(11093),1.39846801757812e-06);
ok($diceobj->probability(11094),1.74808502197266e-06);
ok($diceobj->probability(11095),2.09770202636719e-06);
ok($diceobj->probability(11096),1.74808502197266e-06);
ok($diceobj->probability(11097),1.39846801757812e-06);
ok($diceobj->probability(11098),1.04885101318359e-06);
ok($diceobj->probability(11099),6.99234008789062e-07);
ok($diceobj->probability(11100),3.49617004394531e-07);
ok($diceobj->probability(11138),5.10003831651476e-07);
ok($diceobj->probability(11139),1.02000766330295e-06);
ok($diceobj->probability(11140),1.53001149495443e-06);
ok($diceobj->probability(11141),2.0400153266059e-06);
ok($diceobj->probability(11142),2.55001915825738e-06);
ok($diceobj->probability(11143),3.06002298990885e-06);
ok($diceobj->probability(11144),2.55001915825738e-06);
ok($diceobj->probability(11145),2.0400153266059e-06);
ok($diceobj->probability(11146),1.53001149495443e-06);
ok($diceobj->probability(11147),1.02000766330295e-06);
ok($diceobj->probability(11148),5.10003831651476e-07);
ok($diceobj->probability(11162),8.4792243109809e-08);
ok($diceobj->probability(11163),1.69584486219618e-07);
ok($diceobj->probability(11164),2.54376729329427e-07);
ok($diceobj->probability(11165),3.39168972439236e-07);
ok($diceobj->probability(11166),4.23961215549045e-07);
ok($diceobj->probability(11167),5.08753458658854e-07);
ok($diceobj->probability(11168),4.23961215549045e-07);
ok($diceobj->probability(11169),3.39168972439236e-07);
ok($diceobj->probability(11170),2.54376729329427e-07);
ok($diceobj->probability(11171),1.69584486219618e-07);
ok($diceobj->probability(11172),8.4792243109809e-08);
ok($diceobj->probability(11174),1.3785892062717e-07);
ok($diceobj->probability(11175),2.7571784125434e-07);
ok($diceobj->probability(11176),4.1357676188151e-07);
ok($diceobj->probability(11177),5.51435682508681e-07);
ok($diceobj->probability(11178),6.89294603135851e-07);
ok($diceobj->probability(11179),8.27153523763021e-07);
ok($diceobj->probability(11180),1.16714901394314e-06);
ok($diceobj->probability(11181),1.50714450412326e-06);
ok($diceobj->probability(11182),1.84713999430339e-06);
ok($diceobj->probability(11183),2.18713548448351e-06);
ok($diceobj->probability(11184),2.52713097466363e-06);
ok($diceobj->probability(11185),2.86712646484375e-06);
ok($diceobj->probability(11186),2.38927205403646e-06);
ok($diceobj->probability(11187),1.91141764322917e-06);
ok($diceobj->probability(11188),1.43356323242188e-06);
ok($diceobj->probability(11189),9.55708821614583e-07);
ok($diceobj->probability(11190),4.77854410807292e-07);
ok($diceobj->probability(11193),7.31150309244792e-09);
ok($diceobj->probability(11194),1.46230061848958e-08);
ok($diceobj->probability(11195),2.19345092773437e-08);
ok($diceobj->probability(11196),2.92460123697917e-08);
ok($diceobj->probability(11197),3.65575154622396e-08);
ok($diceobj->probability(11198),4.38690185546875e-08);
ok($diceobj->probability(11199),3.65575154622396e-08);
ok($diceobj->probability(11200),2.92460123697917e-08);
ok($diceobj->probability(11201),2.19345092773437e-08);
ok($diceobj->probability(11202),8.17171732584635e-07);
ok($diceobj->probability(11203),1.61240895589193e-06);
ok($diceobj->probability(11204),2.40764617919922e-06);
ok($diceobj->probability(11205),3.21019490559896e-06);
ok($diceobj->probability(11206),4.0127436319987e-06);
ok($diceobj->probability(11207),4.81529235839844e-06);
ok($diceobj->probability(11208),4.0127436319987e-06);
ok($diceobj->probability(11209),3.21019490559896e-06);
ok($diceobj->probability(11210),2.40764617919922e-06);
ok($diceobj->probability(11211),1.60509745279948e-06);
ok($diceobj->probability(11212),8.0254872639974e-07);
ok($diceobj->probability(11222),1.61552429199219e-07);
ok($diceobj->probability(11223),3.23104858398437e-07);
ok($diceobj->probability(11224),4.84657287597656e-07);
ok($diceobj->probability(11225),6.46209716796875e-07);
ok($diceobj->probability(11226),8.07762145996094e-07);
ok($diceobj->probability(11227),9.69314575195312e-07);
ok($diceobj->probability(11228),8.07762145996094e-07);
ok($diceobj->probability(11229),6.46209716796875e-07);
ok($diceobj->probability(11230),4.84657287597656e-07);
ok($diceobj->probability(11231),3.23104858398437e-07);
ok($diceobj->probability(11232),1.61552429199219e-07);
ok($diceobj->probability(11234),1.48826175265842e-06);
ok($diceobj->probability(11235),2.97652350531684e-06);
ok($diceobj->probability(11236),4.46478525797526e-06);
ok($diceobj->probability(11237),5.95304701063368e-06);
ok($diceobj->probability(11238),7.4413087632921e-06);
ok($diceobj->probability(11239),8.92957051595052e-06);
ok($diceobj->probability(11240),7.4413087632921e-06);
ok($diceobj->probability(11241),5.95304701063368e-06);
ok($diceobj->probability(11242),4.46478525797526e-06);
ok($diceobj->probability(11243),2.97652350531684e-06);
ok($diceobj->probability(11244),1.48826175265842e-06);
ok($diceobj->probability(11252),5.31578063964844e-07);
ok($diceobj->probability(11253),1.06315612792969e-06);
ok($diceobj->probability(11254),1.59473419189453e-06);
ok($diceobj->probability(11255),2.12631225585938e-06);
ok($diceobj->probability(11256),2.65789031982422e-06);
ok($diceobj->probability(11257),3.18946838378906e-06);
ok($diceobj->probability(11258),2.65789031982422e-06);
ok($diceobj->probability(11259),2.12631225585938e-06);
ok($diceobj->probability(11260),1.59473419189453e-06);
ok($diceobj->probability(11261),1.06315612792969e-06);
ok($diceobj->probability(11262),5.31578063964844e-07);
ok($diceobj->probability(11266),1.23977661132812e-08);
ok($diceobj->probability(11267),2.47955322265625e-08);
ok($diceobj->probability(11268),3.71932983398437e-08);
ok($diceobj->probability(11269),4.9591064453125e-08);
ok($diceobj->probability(11270),6.19888305664063e-08);
ok($diceobj->probability(11271),7.43865966796875e-08);
ok($diceobj->probability(11272),6.19888305664063e-08);
ok($diceobj->probability(11273),4.9591064453125e-08);
ok($diceobj->probability(11274),3.71932983398437e-08);
ok($diceobj->probability(11275),2.47955322265625e-08);
ok($diceobj->probability(11276),1.23977661132812e-08);
ok($diceobj->probability(11286),6.26246134440104e-08);
ok($diceobj->probability(11287),1.25249226888021e-07);
ok($diceobj->probability(11288),3.814697265625e-07);
ok($diceobj->probability(11289),6.37690226236979e-07);
ok($diceobj->probability(11290),8.93910725911458e-07);
ok($diceobj->probability(11291),1.15013122558594e-06);
ok($diceobj->probability(11292),1.2811024983724e-06);
ok($diceobj->probability(11293),1.41207377115885e-06);
ok($diceobj->probability(11294),1.15585327148437e-06);
ok($diceobj->probability(11295),8.99632771809896e-07);
ok($diceobj->probability(11296),6.43412272135417e-07);
ok($diceobj->probability(11297),3.87191772460938e-07);
ok($diceobj->probability(11298),1.93595886230469e-07);
ok($diceobj->probability(11312),4.89213731553819e-07);
ok($diceobj->probability(11313),9.78427463107639e-07);
ok($diceobj->probability(11314),1.46764119466146e-06);
ok($diceobj->probability(11315),1.95685492621528e-06);
ok($diceobj->probability(11316),2.4460686577691e-06);
ok($diceobj->probability(11317),2.93528238932292e-06);
ok($diceobj->probability(11318),2.4460686577691e-06);
ok($diceobj->probability(11319),1.95685492621528e-06);
ok($diceobj->probability(11320),1.46764119466146e-06);
ok($diceobj->probability(11321),9.78427463107639e-07);
ok($diceobj->probability(11322),4.89213731553819e-07);
ok($diceobj->probability(11341),3.43577067057292e-07);
ok($diceobj->probability(11342),1.53656429714627e-06);
ok($diceobj->probability(11343),2.72955152723524e-06);
ok($diceobj->probability(11344),3.92253875732422e-06);
ok($diceobj->probability(11345),5.11552598741319e-06);
ok($diceobj->probability(11346),6.30851321750217e-06);
ok($diceobj->probability(11347),6.81434631347656e-06);
ok($diceobj->probability(11348),5.62135908338759e-06);
ok($diceobj->probability(11349),4.42837185329861e-06);
ok($diceobj->probability(11350),3.23538462320964e-06);
ok($diceobj->probability(11351),2.04239739312066e-06);
ok($diceobj->probability(11352),8.49410163031684e-07);
ok($diceobj->probability(11364),2.37782796223958e-07);
ok($diceobj->probability(11365),4.75565592447917e-07);
ok($diceobj->probability(11366),7.13348388671875e-07);
ok($diceobj->probability(11367),9.51131184895833e-07);
ok($diceobj->probability(11368),1.18891398111979e-06);
ok($diceobj->probability(11369),1.42669677734375e-06);
ok($diceobj->probability(11370),1.42409006754557e-06);
ok($diceobj->probability(11371),1.4214833577474e-06);
ok($diceobj->probability(11372),1.41887664794922e-06);
ok($diceobj->probability(11373),1.41626993815104e-06);
ok($diceobj->probability(11374),1.41366322835286e-06);
ok($diceobj->probability(11375),1.41105651855469e-06);
ok($diceobj->probability(11376),1.17588043212891e-06);
ok($diceobj->probability(11377),9.40704345703125e-07);
ok($diceobj->probability(11378),7.05528259277344e-07);
ok($diceobj->probability(11379),4.70352172851563e-07);
ok($diceobj->probability(11380),2.35176086425781e-07);
ok($diceobj->probability(11402),2.99275716145833e-07);
ok($diceobj->probability(11403),5.98551432291667e-07);
ok($diceobj->probability(11404),8.978271484375e-07);
ok($diceobj->probability(11405),1.19710286458333e-06);
ok($diceobj->probability(11406),1.49637858072917e-06);
ok($diceobj->probability(11407),1.795654296875e-06);
ok($diceobj->probability(11408),1.49637858072917e-06);
ok($diceobj->probability(11409),1.19710286458333e-06);
ok($diceobj->probability(11410),9.47418212890625e-07);
ok($diceobj->probability(11411),6.97733561197917e-07);
ok($diceobj->probability(11412),4.48048909505208e-07);
ok($diceobj->probability(11413),1.983642578125e-07);
ok($diceobj->probability(11414),2.47955322265625e-07);
ok($diceobj->probability(11415),2.9754638671875e-07);
ok($diceobj->probability(11416),2.47955322265625e-07);
ok($diceobj->probability(11417),1.983642578125e-07);
ok($diceobj->probability(11418),1.48773193359375e-07);
ok($diceobj->probability(11419),9.918212890625e-08);
ok($diceobj->probability(11420),4.9591064453125e-08);
ok($diceobj->probability(11426),5.42810228135851e-07);
ok($diceobj->probability(11427),1.0856204562717e-06);
ok($diceobj->probability(11428),1.62843068440755e-06);
ok($diceobj->probability(11429),2.1712409125434e-06);
ok($diceobj->probability(11430),2.71405114067925e-06);
ok($diceobj->probability(11431),3.2568613688151e-06);
ok($diceobj->probability(11432),2.71405114067925e-06);
ok($diceobj->probability(11433),2.1712409125434e-06);
ok($diceobj->probability(11434),1.62843068440755e-06);
ok($diceobj->probability(11435),1.0856204562717e-06);
ok($diceobj->probability(11436),5.42810228135851e-07);
ok($diceobj->probability(11442),5.77926635742188e-08);
ok($diceobj->probability(11443),1.15585327148438e-07);
ok($diceobj->probability(11444),1.73377990722656e-07);
ok($diceobj->probability(11445),2.31170654296875e-07);
ok($diceobj->probability(11446),2.88963317871094e-07);
ok($diceobj->probability(11447),3.46755981445312e-07);
ok($diceobj->probability(11448),2.88963317871094e-07);
ok($diceobj->probability(11449),2.31170654296875e-07);
ok($diceobj->probability(11450),1.73377990722656e-07);
ok($diceobj->probability(11451),1.15585327148438e-07);
ok($diceobj->probability(11452),5.77926635742188e-08);
ok($diceobj->probability(11477),6.79588317871094e-07);
ok($diceobj->probability(11478),1.35917663574219e-06);
ok($diceobj->probability(11479),2.03876495361328e-06);
ok($diceobj->probability(11480),2.71835327148438e-06);
ok($diceobj->probability(11481),3.39794158935547e-06);
ok($diceobj->probability(11482),4.07752990722656e-06);
ok($diceobj->probability(11483),3.39794158935547e-06);
ok($diceobj->probability(11484),2.71835327148438e-06);
ok($diceobj->probability(11485),2.03876495361328e-06);
ok($diceobj->probability(11486),1.53827667236328e-06);
ok($diceobj->probability(11487),1.03778839111328e-06);
ok($diceobj->probability(11488),5.37300109863281e-07);
ok($diceobj->probability(11489),7.16400146484375e-07);
ok($diceobj->probability(11490),8.95500183105469e-07);
ok($diceobj->probability(11491),1.07460021972656e-06);
ok($diceobj->probability(11492),8.95500183105469e-07);
ok($diceobj->probability(11493),7.16400146484375e-07);
ok($diceobj->probability(11494),9.04464721679688e-07);
ok($diceobj->probability(11495),1.092529296875e-06);
ok($diceobj->probability(11496),1.28059387207031e-06);
ok($diceobj->probability(11497),1.46865844726563e-06);
ok($diceobj->probability(11498),1.83582305908203e-06);
ok($diceobj->probability(11499),2.20298767089844e-06);
ok($diceobj->probability(11500),1.83582305908203e-06);
ok($diceobj->probability(11501),1.46865844726563e-06);
ok($diceobj->probability(11502),1.16715749104818e-06);
ok($diceobj->probability(11503),8.65656534830729e-07);
ok($diceobj->probability(11504),5.64155578613281e-07);
ok($diceobj->probability(11505),2.62654622395833e-07);
ok($diceobj->probability(11506),3.28318277994792e-07);
ok($diceobj->probability(11507),3.9398193359375e-07);
ok($diceobj->probability(11508),3.28318277994792e-07);
ok($diceobj->probability(11509),2.62654622395833e-07);
ok($diceobj->probability(11510),1.96990966796875e-07);
ok($diceobj->probability(11511),1.31327311197917e-07);
ok($diceobj->probability(11512),6.56636555989583e-08);
ok($diceobj->probability(11522),2.4619632297092e-07);
ok($diceobj->probability(11523),4.9239264594184e-07);
ok($diceobj->probability(11524),7.3858896891276e-07);
ok($diceobj->probability(11525),9.84785291883681e-07);
ok($diceobj->probability(11526),1.2309816148546e-06);
ok($diceobj->probability(11527),1.47717793782552e-06);
ok($diceobj->probability(11528),1.2309816148546e-06);
ok($diceobj->probability(11529),9.84785291883681e-07);
ok($diceobj->probability(11530),7.3858896891276e-07);
ok($diceobj->probability(11531),4.9239264594184e-07);
ok($diceobj->probability(11532),2.4619632297092e-07);
ok($diceobj->probability(11554),1.46230061848958e-09);
ok($diceobj->probability(11555),2.92460123697917e-09);
ok($diceobj->probability(11556),4.38690185546875e-09);
ok($diceobj->probability(11557),5.84920247395833e-09);
ok($diceobj->probability(11558),7.31150309244792e-09);
ok($diceobj->probability(11559),8.7738037109375e-09);
ok($diceobj->probability(11560),7.31150309244792e-09);
ok($diceobj->probability(11561),5.84920247395833e-09);
ok($diceobj->probability(11562),4.38690185546875e-09);
ok($diceobj->probability(11563),2.92460123697917e-09);
ok($diceobj->probability(11564),1.46230061848958e-09);
ok($diceobj->probability(11573),7.06778632269965e-08);
ok($diceobj->probability(11574),1.41355726453993e-07);
ok($diceobj->probability(11575),2.1203358968099e-07);
ok($diceobj->probability(11576),2.82711452907986e-07);
ok($diceobj->probability(11577),3.53389316134983e-07);
ok($diceobj->probability(11578),4.24067179361979e-07);
ok($diceobj->probability(11579),3.53389316134983e-07);
ok($diceobj->probability(11580),2.82711452907986e-07);
ok($diceobj->probability(11581),2.1203358968099e-07);
ok($diceobj->probability(11582),1.41355726453993e-07);
ok($diceobj->probability(11583),7.06778632269965e-08);
ok($diceobj->probability(11594),2.87628173828125e-07);
ok($diceobj->probability(11595),5.7525634765625e-07);
ok($diceobj->probability(11596),8.96263122558594e-07);
ok($diceobj->probability(11597),1.21726989746094e-06);
ok($diceobj->probability(11598),1.53827667236328e-06);
ok($diceobj->probability(11599),1.85928344726562e-06);
ok($diceobj->probability(11600),1.60503387451172e-06);
ok($diceobj->probability(11601),1.35078430175781e-06);
ok($diceobj->probability(11602),1.43412272135417e-06);
ok($diceobj->probability(11603),1.51746114095052e-06);
ok($diceobj->probability(11604),1.60079956054688e-06);
ok($diceobj->probability(11605),1.68413798014323e-06);
ok($diceobj->probability(11606),2.05510457356771e-06);
ok($diceobj->probability(11607),2.42607116699219e-06);
ok($diceobj->probability(11608),2.02172597249349e-06);
ok($diceobj->probability(11609),1.61738077799479e-06);
ok($diceobj->probability(11610),1.21303558349609e-06);
ok($diceobj->probability(11611),8.08690388997396e-07);
ok($diceobj->probability(11612),4.04345194498698e-07);
ok($diceobj->probability(11627),4.49498494466146e-08);
ok($diceobj->probability(11628),8.98996988932292e-08);
ok($diceobj->probability(11629),1.34849548339844e-07);
ok($diceobj->probability(11630),1.79799397786458e-07);
ok($diceobj->probability(11631),2.24749247233073e-07);
ok($diceobj->probability(11632),2.69699096679687e-07);
ok($diceobj->probability(11633),2.24749247233073e-07);
ok($diceobj->probability(11634),1.79799397786458e-07);
ok($diceobj->probability(11635),1.34849548339844e-07);
ok($diceobj->probability(11636),8.98996988932292e-08);
ok($diceobj->probability(11637),4.49498494466146e-08);
ok($diceobj->probability(11650),5.62159220377604e-07);
ok($diceobj->probability(11651),1.12431844075521e-06);
ok($diceobj->probability(11652),1.68647766113281e-06);
ok($diceobj->probability(11653),2.24863688151042e-06);
ok($diceobj->probability(11654),2.81079610188802e-06);
ok($diceobj->probability(11655),3.37295532226562e-06);
ok($diceobj->probability(11656),2.81079610188802e-06);
ok($diceobj->probability(11657),2.24863688151042e-06);
ok($diceobj->probability(11658),1.68647766113281e-06);
ok($diceobj->probability(11659),1.12431844075521e-06);
ok($diceobj->probability(11660),5.62159220377604e-07);
ok($diceobj->probability(11666),6.86518351236979e-07);
ok($diceobj->probability(11667),1.37303670247396e-06);
ok($diceobj->probability(11668),2.05955505371094e-06);
ok($diceobj->probability(11669),2.74607340494792e-06);
ok($diceobj->probability(11670),3.4325917561849e-06);
ok($diceobj->probability(11671),4.11911010742188e-06);
ok($diceobj->probability(11672),3.4325917561849e-06);
ok($diceobj->probability(11673),2.74607340494792e-06);
ok($diceobj->probability(11674),2.05955505371094e-06);
ok($diceobj->probability(11675),1.37303670247396e-06);
ok($diceobj->probability(11676),6.86518351236979e-07);
ok($diceobj->probability(11689),9.85463460286458e-09);
ok($diceobj->probability(11690),1.97092692057292e-08);
ok($diceobj->probability(11691),2.95639038085937e-08);
ok($diceobj->probability(11692),3.94185384114583e-08);
ok($diceobj->probability(11693),4.92731730143229e-08);
ok($diceobj->probability(11694),5.91278076171875e-08);
ok($diceobj->probability(11695),4.92731730143229e-08);
ok($diceobj->probability(11696),3.94185384114583e-08);
ok($diceobj->probability(11697),2.95639038085937e-08);
ok($diceobj->probability(11698),1.97092692057292e-08);
ok($diceobj->probability(11699),9.85463460286458e-09);
ok($diceobj->probability(11702),6.11686706542969e-07);
ok($diceobj->probability(11703),1.22337341308594e-06);
ok($diceobj->probability(11704),1.83506011962891e-06);
ok($diceobj->probability(11705),2.44674682617187e-06);
ok($diceobj->probability(11706),3.17497253417969e-06);
ok($diceobj->probability(11707),3.9031982421875e-06);
ok($diceobj->probability(11708),3.40805053710937e-06);
ok($diceobj->probability(11709),2.91290283203125e-06);
ok($diceobj->probability(11710),2.41775512695313e-06);
ok($diceobj->probability(11711),1.922607421875e-06);
ok($diceobj->probability(11712),1.19438171386719e-06);
ok($diceobj->probability(11713),4.66156005859375e-07);
ok($diceobj->probability(11714),3.49617004394531e-07);
ok($diceobj->probability(11715),2.33078002929688e-07);
ok($diceobj->probability(11716),1.16539001464844e-07);
ok($diceobj->probability(11720),4.60942586263021e-08);
ok($diceobj->probability(11721),9.21885172526042e-08);
ok($diceobj->probability(11722),1.38282775878906e-07);
ok($diceobj->probability(11723),1.84377034505208e-07);
ok($diceobj->probability(11724),2.3047129313151e-07);
ok($diceobj->probability(11725),2.76565551757812e-07);
ok($diceobj->probability(11726),2.3047129313151e-07);
ok($diceobj->probability(11727),1.84377034505208e-07);
ok($diceobj->probability(11728),1.38282775878906e-07);
ok($diceobj->probability(11729),9.21885172526042e-08);
ok($diceobj->probability(11730),4.60942586263021e-08);
ok($diceobj->probability(11732),1.32327609592014e-07);
ok($diceobj->probability(11733),2.64655219184028e-07);
ok($diceobj->probability(11734),3.96982828776042e-07);
ok($diceobj->probability(11735),5.29310438368056e-07);
ok($diceobj->probability(11736),6.61638047960069e-07);
ok($diceobj->probability(11737),7.93965657552083e-07);
ok($diceobj->probability(11738),6.61638047960069e-07);
ok($diceobj->probability(11739),5.29310438368056e-07);
ok($diceobj->probability(11740),3.96982828776042e-07);
ok($diceobj->probability(11741),2.64655219184028e-07);
ok($diceobj->probability(11742),1.32327609592014e-07);
ok($diceobj->probability(11747),2.92388068305122e-07);
ok($diceobj->probability(11748),5.84776136610243e-07);
ok($diceobj->probability(11749),8.77164204915365e-07);
ok($diceobj->probability(11750),1.16955227322049e-06);
ok($diceobj->probability(11751),1.46194034152561e-06);
ok($diceobj->probability(11752),1.75432840983073e-06);
ok($diceobj->probability(11753),1.46194034152561e-06);
ok($diceobj->probability(11754),1.16955227322049e-06);
ok($diceobj->probability(11755),8.77164204915365e-07);
ok($diceobj->probability(11756),5.84776136610243e-07);
ok($diceobj->probability(11757),2.92388068305122e-07);
ok($diceobj->probability(11762),2.89501614040799e-07);
ok($diceobj->probability(11763),5.79003228081597e-07);
ok($diceobj->probability(11764),8.68504842122396e-07);
ok($diceobj->probability(11765),1.15800645616319e-06);
ok($diceobj->probability(11766),1.44750807020399e-06);
ok($diceobj->probability(11767),1.73700968424479e-06);
ok($diceobj->probability(11768),1.44750807020399e-06);
ok($diceobj->probability(11769),1.15800645616319e-06);
ok($diceobj->probability(11770),8.68504842122396e-07);
ok($diceobj->probability(11771),5.79003228081597e-07);
ok($diceobj->probability(11772),2.89501614040799e-07);
ok($diceobj->probability(11776),6.00814819335938e-08);
ok($diceobj->probability(11777),1.20162963867188e-07);
ok($diceobj->probability(11778),1.90162658691406e-07);
ok($diceobj->probability(11779),2.60162353515625e-07);
ok($diceobj->probability(11780),3.30162048339844e-07);
ok($diceobj->probability(11781),4.00161743164062e-07);
ok($diceobj->probability(11782),3.58136494954427e-07);
ok($diceobj->probability(11783),3.16111246744792e-07);
ok($diceobj->probability(11784),2.54249572753906e-07);
ok($diceobj->probability(11785),1.92387898763021e-07);
ok($diceobj->probability(11786),1.30526224772135e-07);
ok($diceobj->probability(11787),6.866455078125e-08);
ok($diceobj->probability(11788),5.06083170572917e-08);
ok($diceobj->probability(11789),3.25520833333333e-08);
ok($diceobj->probability(11790),2.44140625e-08);
ok($diceobj->probability(11791),1.62760416666667e-08);
ok($diceobj->probability(11792),8.13802083333333e-09);
ok($diceobj->probability(11801),1.59284803602431e-07);
ok($diceobj->probability(11802),3.18569607204861e-07);
ok($diceobj->probability(11803),4.77854410807292e-07);
ok($diceobj->probability(11804),6.37139214409722e-07);
ok($diceobj->probability(11805),7.96424018012153e-07);
ok($diceobj->probability(11806),9.55708821614583e-07);
ok($diceobj->probability(11807),7.96424018012153e-07);
ok($diceobj->probability(11808),6.37139214409722e-07);
ok($diceobj->probability(11809),4.77854410807292e-07);
ok($diceobj->probability(11810),3.18569607204861e-07);
ok($diceobj->probability(11811),1.59284803602431e-07);
ok($diceobj->probability(11834),2.73556179470486e-07);
ok($diceobj->probability(11835),5.47112358940972e-07);
ok($diceobj->probability(11836),8.20668538411458e-07);
ok($diceobj->probability(11837),1.09422471788194e-06);
ok($diceobj->probability(11838),1.36778089735243e-06);
ok($diceobj->probability(11839),1.64133707682292e-06);
ok($diceobj->probability(11840),1.36778089735243e-06);
ok($diceobj->probability(11841),1.09422471788194e-06);
ok($diceobj->probability(11842),8.20668538411458e-07);
ok($diceobj->probability(11843),5.47112358940972e-07);
ok($diceobj->probability(11844),2.73556179470486e-07);
ok($diceobj->probability(11858),1.89463297526042e-07);
ok($diceobj->probability(11859),3.78926595052083e-07);
ok($diceobj->probability(11860),5.68389892578125e-07);
ok($diceobj->probability(11861),7.57853190104167e-07);
ok($diceobj->probability(11862),9.47316487630208e-07);
ok($diceobj->probability(11863),1.13677978515625e-06);
ok($diceobj->probability(11864),9.47316487630208e-07);
ok($diceobj->probability(11865),7.57853190104167e-07);
ok($diceobj->probability(11866),5.68389892578125e-07);
ok($diceobj->probability(11867),3.78926595052083e-07);
ok($diceobj->probability(11868),1.89463297526042e-07);
ok($diceobj->probability(11877),1.00135803222656e-07);
ok($diceobj->probability(11878),2.00271606445312e-07);
ok($diceobj->probability(11879),3.00407409667969e-07);
ok($diceobj->probability(11880),4.00543212890625e-07);
ok($diceobj->probability(11881),5.00679016113281e-07);
ok($diceobj->probability(11882),7.08770751953125e-07);
ok($diceobj->probability(11883),7.16590881347656e-07);
ok($diceobj->probability(11884),7.24411010742188e-07);
ok($diceobj->probability(11885),7.32231140136719e-07);
ok($diceobj->probability(11886),7.4005126953125e-07);
ok($diceobj->probability(11887),7.47871398925781e-07);
ok($diceobj->probability(11888),5.39779663085937e-07);
ok($diceobj->probability(11889),4.3182373046875e-07);
ok($diceobj->probability(11890),3.23867797851563e-07);
ok($diceobj->probability(11891),2.15911865234375e-07);
ok($diceobj->probability(11892),1.07955932617187e-07);
ok($diceobj->probability(11902),4.0899912516276e-07);
ok($diceobj->probability(11903),8.17998250325521e-07);
ok($diceobj->probability(11904),1.22699737548828e-06);
ok($diceobj->probability(11905),1.63599650065104e-06);
ok($diceobj->probability(11906),2.08356645372179e-06);
ok($diceobj->probability(11907),2.53113640679253e-06);
ok($diceobj->probability(11908),2.16070810953776e-06);
ok($diceobj->probability(11909),1.79027981228299e-06);
ok($diceobj->probability(11910),1.41985151502821e-06);
ok($diceobj->probability(11911),1.04942321777344e-06);
ok($diceobj->probability(11912),6.01853264702691e-07);
ok($diceobj->probability(11913),1.54283311631944e-07);
ok($diceobj->probability(11914),1.15712483723958e-07);
ok($diceobj->probability(11915),7.71416558159722e-08);
ok($diceobj->probability(11916),3.85708279079861e-08);
ok($diceobj->probability(11936),4.91778055826823e-07);
ok($diceobj->probability(11937),9.83556111653646e-07);
ok($diceobj->probability(11938),1.47533416748047e-06);
ok($diceobj->probability(11939),1.96711222330729e-06);
ok($diceobj->probability(11940),2.45889027913411e-06);
ok($diceobj->probability(11941),2.95066833496094e-06);
ok($diceobj->probability(11942),2.45889027913411e-06);
ok($diceobj->probability(11943),1.96711222330729e-06);
ok($diceobj->probability(11944),1.47533416748047e-06);
ok($diceobj->probability(11945),9.83556111653646e-07);
ok($diceobj->probability(11946),4.91778055826823e-07);
ok($diceobj->probability(11962),4.75565592447917e-08);
ok($diceobj->probability(11963),9.51131184895833e-08);
ok($diceobj->probability(11964),1.42669677734375e-07);
ok($diceobj->probability(11965),1.90226236979167e-07);
ok($diceobj->probability(11966),2.37782796223958e-07);
ok($diceobj->probability(11967),2.8533935546875e-07);
ok($diceobj->probability(11968),2.37782796223958e-07);
ok($diceobj->probability(11969),1.90226236979167e-07);
ok($diceobj->probability(11970),1.49345397949219e-07);
ok($diceobj->probability(11971),1.08464558919271e-07);
ok($diceobj->probability(11972),9.50283474392361e-08);
ok($diceobj->probability(11973),8.15921359592014e-08);
ok($diceobj->probability(11974),1.15712483723958e-07);
ok($diceobj->probability(11975),1.49832831488715e-07);
ok($diceobj->probability(11976),1.70601738823785e-07);
ok($diceobj->probability(11977),1.91370646158854e-07);
ok($diceobj->probability(11978),1.57250298394097e-07);
ok($diceobj->probability(11979),1.2312995062934e-07);
ok($diceobj->probability(11980),8.90096028645833e-08);
ok($diceobj->probability(11981),5.48892550998264e-08);
ok($diceobj->probability(11982),2.74446275499132e-08);
ok($diceobj->probability(12002),2.16284857855903e-07);
ok($diceobj->probability(12003),4.32569715711806e-07);
ok($diceobj->probability(12004),6.48854573567708e-07);
ok($diceobj->probability(12005),8.65139431423611e-07);
ok($diceobj->probability(12006),1.08142428927951e-06);
ok($diceobj->probability(12007),1.29770914713542e-06);
ok($diceobj->probability(12008),1.22867160373264e-06);
ok($diceobj->probability(12009),1.15963406032986e-06);
ok($diceobj->probability(12010),1.09059651692708e-06);
ok($diceobj->probability(12011),1.02155897352431e-06);
ok($diceobj->probability(12012),9.52521430121528e-07);
ok($diceobj->probability(12013),8.8348388671875e-07);
ok($diceobj->probability(12014),7.36236572265625e-07);
ok($diceobj->probability(12015),5.889892578125e-07);
ok($diceobj->probability(12016),4.41741943359375e-07);
ok($diceobj->probability(12017),2.9449462890625e-07);
ok($diceobj->probability(12018),1.47247314453125e-07);
ok($diceobj->probability(12066),2.82986958821615e-07);
ok($diceobj->probability(12067),5.65973917643229e-07);
ok($diceobj->probability(12068),8.48960876464844e-07);
ok($diceobj->probability(12069),1.13194783528646e-06);
ok($diceobj->probability(12070),1.41493479410807e-06);
ok($diceobj->probability(12071),1.69792175292969e-06);
ok($diceobj->probability(12072),1.41493479410807e-06);
ok($diceobj->probability(12073),1.13194783528646e-06);
ok($diceobj->probability(12074),8.48960876464844e-07);
ok($diceobj->probability(12075),5.65973917643229e-07);
ok($diceobj->probability(12076),2.82986958821615e-07);
ok($diceobj->probability(12092),3.53919135199653e-08);
ok($diceobj->probability(12093),7.07838270399306e-08);
ok($diceobj->probability(12094),1.06175740559896e-07);
ok($diceobj->probability(12095),1.41567654079861e-07);
ok($diceobj->probability(12096),1.76959567599826e-07);
ok($diceobj->probability(12097),2.12351481119792e-07);
ok($diceobj->probability(12098),7.83390469021267e-07);
ok($diceobj->probability(12099),1.35442945692274e-06);
ok($diceobj->probability(12100),1.92546844482422e-06);
ok($diceobj->probability(12101),2.49650743272569e-06);
ok($diceobj->probability(12102),3.06754642062717e-06);
ok($diceobj->probability(12103),3.63858540852865e-06);
ok($diceobj->probability(12104),3.0321545071072e-06);
ok($diceobj->probability(12105),2.42572360568576e-06);
ok($diceobj->probability(12106),1.81929270426432e-06);
ok($diceobj->probability(12107),1.21286180284288e-06);
ok($diceobj->probability(12108),6.06430901421441e-07);
ok($diceobj->probability(12123),2.6702880859375e-08);
ok($diceobj->probability(12124),1.13105773925781e-07);
ok($diceobj->probability(12125),1.99508666992187e-07);
ok($diceobj->probability(12126),2.85911560058594e-07);
ok($diceobj->probability(12127),3.72314453125e-07);
ok($diceobj->probability(12128),4.58717346191406e-07);
ok($diceobj->probability(12129),4.91714477539062e-07);
ok($diceobj->probability(12130),4.05311584472656e-07);
ok($diceobj->probability(12131),3.1890869140625e-07);
ok($diceobj->probability(12132),2.32505798339844e-07);
ok($diceobj->probability(12133),1.46102905273438e-07);
ok($diceobj->probability(12134),5.97000122070313e-08);
ok($diceobj->probability(12152),4.02984619140625e-07);
ok($diceobj->probability(12153),8.0596923828125e-07);
ok($diceobj->probability(12154),1.22611999511719e-06);
ok($diceobj->probability(12155),1.64627075195312e-06);
ok($diceobj->probability(12156),2.06642150878906e-06);
ok($diceobj->probability(12157),2.486572265625e-06);
ok($diceobj->probability(12158),2.10075378417969e-06);
ok($diceobj->probability(12159),1.71493530273438e-06);
ok($diceobj->probability(12160),1.29478454589844e-06);
ok($diceobj->probability(12161),8.746337890625e-07);
ok($diceobj->probability(12162),4.56110636393229e-07);
ok($diceobj->probability(12163),3.75874837239583e-08);
ok($diceobj->probability(12164),2.20489501953125e-08);
ok($diceobj->probability(12165),6.51041666666667e-09);
ok($diceobj->probability(12166),8.13802083333333e-09);
ok($diceobj->probability(12167),9.765625e-09);
ok($diceobj->probability(12168),8.13802083333333e-09);
ok($diceobj->probability(12169),6.51041666666667e-09);
ok($diceobj->probability(12170),1.62239074707031e-07);
ok($diceobj->probability(12171),3.17967732747396e-07);
ok($diceobj->probability(12172),4.7369639078776e-07);
ok($diceobj->probability(12173),6.29425048828125e-07);
ok($diceobj->probability(12174),7.86781311035156e-07);
ok($diceobj->probability(12175),9.44137573242187e-07);
ok($diceobj->probability(12176),7.86781311035156e-07);
ok($diceobj->probability(12177),6.29425048828125e-07);
ok($diceobj->probability(12178),4.72068786621094e-07);
ok($diceobj->probability(12179),3.14712524414063e-07);
ok($diceobj->probability(12180),1.57356262207031e-07);
ok($diceobj->probability(12182),2.35858493381076e-07);
ok($diceobj->probability(12183),4.71716986762153e-07);
ok($diceobj->probability(12184),7.07575480143229e-07);
ok($diceobj->probability(12185),9.43433973524306e-07);
ok($diceobj->probability(12186),1.17929246690538e-06);
ok($diceobj->probability(12187),1.41515096028646e-06);
ok($diceobj->probability(12188),1.17929246690538e-06);
ok($diceobj->probability(12189),9.43433973524306e-07);
ok($diceobj->probability(12190),7.07575480143229e-07);
ok($diceobj->probability(12191),4.71716986762153e-07);
ok($diceobj->probability(12192),2.35858493381076e-07);
ok($diceobj->probability(12238),9.58760579427083e-08);
ok($diceobj->probability(12239),1.91752115885417e-07);
ok($diceobj->probability(12240),2.87628173828125e-07);
ok($diceobj->probability(12241),3.83504231770833e-07);
ok($diceobj->probability(12242),5.8441162109375e-07);
ok($diceobj->probability(12243),7.85319010416667e-07);
ok($diceobj->probability(12244),7.94474283854167e-07);
ok($diceobj->probability(12245),8.03629557291667e-07);
ok($diceobj->probability(12246),8.12784830729167e-07);
ok($diceobj->probability(12247),8.21940104166667e-07);
ok($diceobj->probability(12248),6.2103271484375e-07);
ok($diceobj->probability(12249),4.20125325520833e-07);
ok($diceobj->probability(12250),3.15093994140625e-07);
ok($diceobj->probability(12251),2.10062662760417e-07);
ok($diceobj->probability(12252),1.05031331380208e-07);
ok($diceobj->probability(12278),1.43051147460937e-08);
ok($diceobj->probability(12279),2.86102294921875e-08);
ok($diceobj->probability(12280),4.29153442382812e-08);
ok($diceobj->probability(12281),5.7220458984375e-08);
ok($diceobj->probability(12282),7.15255737304687e-08);
ok($diceobj->probability(12283),8.58306884765625e-08);
ok($diceobj->probability(12284),7.15255737304687e-08);
ok($diceobj->probability(12285),5.7220458984375e-08);
ok($diceobj->probability(12286),4.29153442382812e-08);
ok($diceobj->probability(12287),2.86102294921875e-08);
ok($diceobj->probability(12288),1.43051147460937e-08);
ok($diceobj->probability(12290),7.71416558159722e-09);
ok($diceobj->probability(12291),1.54283311631944e-08);
ok($diceobj->probability(12292),2.31424967447917e-08);
ok($diceobj->probability(12293),3.08566623263889e-08);
ok($diceobj->probability(12294),3.85708279079861e-08);
ok($diceobj->probability(12295),4.62849934895833e-08);
ok($diceobj->probability(12296),3.85708279079861e-08);
ok($diceobj->probability(12297),3.08566623263889e-08);
ok($diceobj->probability(12298),2.31424967447917e-08);
ok($diceobj->probability(12299),1.54283311631944e-08);
ok($diceobj->probability(12300),7.71416558159722e-09);
ok($diceobj->probability(12314),1.26902262369792e-07);
ok($diceobj->probability(12315),2.53804524739583e-07);
ok($diceobj->probability(12316),3.80706787109375e-07);
ok($diceobj->probability(12317),5.07609049479167e-07);
ok($diceobj->probability(12318),6.34511311848958e-07);
ok($diceobj->probability(12319),7.6141357421875e-07);
ok($diceobj->probability(12320),6.34511311848958e-07);
ok($diceobj->probability(12321),5.07609049479167e-07);
ok($diceobj->probability(12322),4.04014587402344e-07);
ok($diceobj->probability(12323),3.00420125325521e-07);
ok($diceobj->probability(12324),1.96825663248698e-07);
ok($diceobj->probability(12325),9.3231201171875e-08);
ok($diceobj->probability(12326),1.16539001464844e-07);
ok($diceobj->probability(12327),3.49019368489583e-07);
ok($diceobj->probability(12328),5.34884134928385e-07);
ok($diceobj->probability(12329),7.20748901367187e-07);
ok($diceobj->probability(12330),9.0661366780599e-07);
ok($diceobj->probability(12331),1.09247843424479e-06);
ok($diceobj->probability(12332),1.27834320068359e-06);
ok($diceobj->probability(12333),1.04586283365885e-06);
ok($diceobj->probability(12334),8.36690266927083e-07);
ok($diceobj->probability(12335),6.27517700195313e-07);
ok($diceobj->probability(12336),4.18345133463542e-07);
ok($diceobj->probability(12337),2.09172566731771e-07);
ok($diceobj->probability(12352),1.4495849609375e-07);
ok($diceobj->probability(12353),2.899169921875e-07);
ok($diceobj->probability(12354),4.3487548828125e-07);
ok($diceobj->probability(12355),5.79833984375e-07);
ok($diceobj->probability(12356),7.2479248046875e-07);
ok($diceobj->probability(12357),8.697509765625e-07);
ok($diceobj->probability(12358),7.2479248046875e-07);
ok($diceobj->probability(12359),5.79833984375e-07);
ok($diceobj->probability(12360),4.3487548828125e-07);
ok($diceobj->probability(12361),2.899169921875e-07);
ok($diceobj->probability(12362),1.4495849609375e-07);
ok($diceobj->probability(12371),5.82800971137153e-09);
ok($diceobj->probability(12372),1.16560194227431e-08);
ok($diceobj->probability(12373),1.74840291341146e-08);
ok($diceobj->probability(12374),2.33120388454861e-08);
ok($diceobj->probability(12375),2.91400485568576e-08);
ok($diceobj->probability(12376),3.49680582682292e-08);
ok($diceobj->probability(12377),2.91400485568576e-08);
ok($diceobj->probability(12378),3.19268968370226e-07);
ok($diceobj->probability(12379),6.09397888183594e-07);
ok($diceobj->probability(12380),8.99526807996962e-07);
ok($diceobj->probability(12381),1.18965572781033e-06);
ok($diceobj->probability(12382),1.4797846476237e-06);
ok($diceobj->probability(12383),1.77574157714844e-06);
ok($diceobj->probability(12384),1.4797846476237e-06);
ok($diceobj->probability(12385),1.18382771809896e-06);
ok($diceobj->probability(12386),8.87870788574219e-07);
ok($diceobj->probability(12387),5.91913859049479e-07);
ok($diceobj->probability(12388),2.9595692952474e-07);
ok($diceobj->probability(12395),1.64667765299479e-07);
ok($diceobj->probability(12396),3.29335530598958e-07);
ok($diceobj->probability(12397),4.94003295898438e-07);
ok($diceobj->probability(12398),6.58671061197917e-07);
ok($diceobj->probability(12399),8.23338826497396e-07);
ok($diceobj->probability(12400),9.88006591796875e-07);
ok($diceobj->probability(12401),8.23338826497396e-07);
ok($diceobj->probability(12402),6.88934326171875e-07);
ok($diceobj->probability(12403),5.54529825846354e-07);
ok($diceobj->probability(12404),4.20125325520833e-07);
ok($diceobj->probability(12405),2.85720825195312e-07);
ok($diceobj->probability(12406),1.51316324869792e-07);
ok($diceobj->probability(12407),1.8157958984375e-07);
ok($diceobj->probability(12408),1.51316324869792e-07);
ok($diceobj->probability(12409),1.21053059895833e-07);
ok($diceobj->probability(12410),9.0789794921875e-08);
ok($diceobj->probability(12411),6.05265299479167e-08);
ok($diceobj->probability(12412),3.02632649739583e-08);
ok($diceobj->probability(12422),8.85687934027778e-08);
ok($diceobj->probability(12423),1.77137586805556e-07);
ok($diceobj->probability(12424),2.65706380208333e-07);
ok($diceobj->probability(12425),3.54275173611111e-07);
ok($diceobj->probability(12426),4.42843967013889e-07);
ok($diceobj->probability(12427),5.31412760416667e-07);
ok($diceobj->probability(12428),4.42843967013889e-07);
ok($diceobj->probability(12429),3.54275173611111e-07);
ok($diceobj->probability(12430),2.65706380208333e-07);
ok($diceobj->probability(12431),1.77137586805556e-07);
ok($diceobj->probability(12432),8.85687934027778e-08);
ok($diceobj->probability(12482),1.52418348524306e-07);
ok($diceobj->probability(12483),3.04836697048611e-07);
ok($diceobj->probability(12484),4.57255045572917e-07);
ok($diceobj->probability(12485),6.09673394097222e-07);
ok($diceobj->probability(12486),7.62091742621528e-07);
ok($diceobj->probability(12487),9.14510091145833e-07);
ok($diceobj->probability(12488),7.62091742621528e-07);
ok($diceobj->probability(12489),6.09673394097222e-07);
ok($diceobj->probability(12490),4.57255045572917e-07);
ok($diceobj->probability(12491),3.04836697048611e-07);
ok($diceobj->probability(12492),1.52418348524306e-07);
ok($diceobj->probability(12502),2.00271606445313e-08);
ok($diceobj->probability(12503),4.00543212890625e-08);
ok($diceobj->probability(12504),6.00814819335938e-08);
ok($diceobj->probability(12505),8.0108642578125e-08);
ok($diceobj->probability(12506),1.00135803222656e-07);
ok($diceobj->probability(12507),1.20162963867188e-07);
ok($diceobj->probability(12508),1.00135803222656e-07);
ok($diceobj->probability(12509),8.0108642578125e-08);
ok($diceobj->probability(12510),6.00814819335938e-08);
ok($diceobj->probability(12511),4.00543212890625e-08);
ok($diceobj->probability(12512),2.00271606445313e-08);
ok($diceobj->probability(12514),5.340576171875e-09);
ok($diceobj->probability(12515),1.068115234375e-08);
ok($diceobj->probability(12516),1.6021728515625e-08);
ok($diceobj->probability(12517),2.13623046875e-08);
ok($diceobj->probability(12518),2.6702880859375e-08);
ok($diceobj->probability(12519),3.204345703125e-08);
ok($diceobj->probability(12520),2.6702880859375e-08);
ok($diceobj->probability(12521),2.13623046875e-08);
ok($diceobj->probability(12522),1.6021728515625e-08);
ok($diceobj->probability(12523),1.068115234375e-08);
ok($diceobj->probability(12524),5.340576171875e-09);
ok($diceobj->probability(12530),3.05408901638455e-07);
ok($diceobj->probability(12531),6.1081780327691e-07);
ok($diceobj->probability(12532),9.16226704915365e-07);
ok($diceobj->probability(12533),1.22163560655382e-06);
ok($diceobj->probability(12534),1.52704450819227e-06);
ok($diceobj->probability(12535),1.83245340983073e-06);
ok($diceobj->probability(12536),1.52704450819227e-06);
ok($diceobj->probability(12537),1.22163560655382e-06);
ok($diceobj->probability(12538),9.16226704915365e-07);
ok($diceobj->probability(12539),6.1081780327691e-07);
ok($diceobj->probability(12540),3.05408901638455e-07);
ok($diceobj->probability(12542),2.30789184570312e-08);
ok($diceobj->probability(12543),4.61578369140625e-08);
ok($diceobj->probability(12544),6.92367553710937e-08);
ok($diceobj->probability(12545),9.2315673828125e-08);
ok($diceobj->probability(12546),2.29581197102865e-07);
ok($diceobj->probability(12547),3.66846720377604e-07);
ok($diceobj->probability(12548),4.57954406738281e-07);
ok($diceobj->probability(12549),5.49062093098958e-07);
ok($diceobj->probability(12550),6.40169779459635e-07);
ok($diceobj->probability(12551),7.31277465820313e-07);
ok($diceobj->probability(12552),5.94011942545573e-07);
ok($diceobj->probability(12553),4.56746419270833e-07);
ok($diceobj->probability(12554),3.42559814453125e-07);
ok($diceobj->probability(12555),2.28373209635417e-07);
ok($diceobj->probability(12556),1.14186604817708e-07);
ok($diceobj->probability(12557),2.14046902126736e-08);
ok($diceobj->probability(12558),4.28093804253472e-08);
ok($diceobj->probability(12559),6.42140706380208e-08);
ok($diceobj->probability(12560),8.56187608506944e-08);
ok($diceobj->probability(12561),1.07023451063368e-07);
ok($diceobj->probability(12562),1.28428141276042e-07);
ok($diceobj->probability(12563),1.07023451063368e-07);
ok($diceobj->probability(12564),8.56187608506944e-08);
ok($diceobj->probability(12565),6.42140706380208e-08);
ok($diceobj->probability(12566),4.28093804253472e-08);
ok($diceobj->probability(12567),2.14046902126736e-08);
ok($diceobj->probability(12588),8.58306884765625e-09);
ok($diceobj->probability(12589),1.71661376953125e-08);
ok($diceobj->probability(12590),2.57492065429687e-08);
ok($diceobj->probability(12591),3.4332275390625e-08);
ok($diceobj->probability(12592),4.29153442382812e-08);
ok($diceobj->probability(12593),5.14984130859375e-08);
ok($diceobj->probability(12594),4.29153442382812e-08);
ok($diceobj->probability(12595),3.4332275390625e-08);
ok($diceobj->probability(12596),2.57492065429687e-08);
ok($diceobj->probability(12597),1.71661376953125e-08);
ok($diceobj->probability(12598),8.58306884765625e-09);
ok($diceobj->probability(12602),2.56568060980903e-07);
ok($diceobj->probability(12603),5.13136121961806e-07);
ok($diceobj->probability(12604),7.69704182942708e-07);
ok($diceobj->probability(12605),1.02627224392361e-06);
ok($diceobj->probability(12606),1.28284030490451e-06);
ok($diceobj->probability(12607),1.53940836588542e-06);
ok($diceobj->probability(12608),1.28284030490451e-06);
ok($diceobj->probability(12609),1.02627224392361e-06);
ok($diceobj->probability(12610),7.69704182942708e-07);
ok($diceobj->probability(12611),5.13136121961806e-07);
ok($diceobj->probability(12612),2.56568060980903e-07);
ok($diceobj->probability(12617),4.49498494466146e-08);
ok($diceobj->probability(12618),8.98996988932292e-08);
ok($diceobj->probability(12619),1.34849548339844e-07);
ok($diceobj->probability(12620),1.79799397786458e-07);
ok($diceobj->probability(12621),2.24749247233073e-07);
ok($diceobj->probability(12622),2.69699096679687e-07);
ok($diceobj->probability(12623),2.24749247233073e-07);
ok($diceobj->probability(12624),1.79799397786458e-07);
ok($diceobj->probability(12625),1.34849548339844e-07);
ok($diceobj->probability(12626),8.98996988932292e-08);
ok($diceobj->probability(12627),4.49498494466146e-08);
ok($diceobj->probability(12638),2.10762023925781e-07);
ok($diceobj->probability(12639),4.21524047851563e-07);
ok($diceobj->probability(12640),6.32286071777344e-07);
ok($diceobj->probability(12641),8.43048095703125e-07);
ok($diceobj->probability(12642),1.05381011962891e-06);
ok($diceobj->probability(12643),1.26457214355469e-06);
ok($diceobj->probability(12644),1.05381011962891e-06);
ok($diceobj->probability(12645),8.43048095703125e-07);
ok($diceobj->probability(12646),6.32286071777344e-07);
ok($diceobj->probability(12647),4.21524047851563e-07);
ok($diceobj->probability(12648),2.10762023925781e-07);
ok($diceobj->probability(12650),2.07689073350694e-08);
ok($diceobj->probability(12651),4.15378146701389e-08);
ok($diceobj->probability(12652),6.23067220052083e-08);
ok($diceobj->probability(12653),8.30756293402778e-08);
ok($diceobj->probability(12654),1.03844536675347e-07);
ok($diceobj->probability(12655),1.24613444010417e-07);
ok($diceobj->probability(12656),1.03844536675347e-07);
ok($diceobj->probability(12657),8.30756293402778e-08);
ok($diceobj->probability(12658),6.23067220052083e-08);
ok($diceobj->probability(12659),4.15378146701389e-08);
ok($diceobj->probability(12660),2.07689073350694e-08);
ok($diceobj->probability(12674),2.86102294921875e-09);
ok($diceobj->probability(12675),5.48044840494792e-08);
ok($diceobj->probability(12676),1.0674794514974e-07);
ok($diceobj->probability(12677),1.5869140625e-07);
ok($diceobj->probability(12678),2.1063486735026e-07);
ok($diceobj->probability(12679),2.62578328450521e-07);
ok($diceobj->probability(12680),3.08799743652344e-07);
ok($diceobj->probability(12681),2.56856282552083e-07);
ok($diceobj->probability(12682),2.04912821451823e-07);
ok($diceobj->probability(12683),1.52969360351562e-07);
ok($diceobj->probability(12684),1.01025899251302e-07);
ok($diceobj->probability(12685),4.90824381510417e-08);
ok($diceobj->probability(12752),8.0108642578125e-08);
ok($diceobj->probability(12753),1.6021728515625e-07);
ok($diceobj->probability(12754),2.40325927734375e-07);
ok($diceobj->probability(12755),3.204345703125e-07);
ok($diceobj->probability(12756),4.00543212890625e-07);
ok($diceobj->probability(12757),4.8065185546875e-07);
ok($diceobj->probability(12758),4.00543212890625e-07);
ok($diceobj->probability(12759),3.204345703125e-07);
ok($diceobj->probability(12760),2.40325927734375e-07);
ok($diceobj->probability(12761),1.6021728515625e-07);
ok($diceobj->probability(12762),9.20486450195312e-08);
ok($diceobj->probability(12763),2.38800048828125e-08);
ok($diceobj->probability(12764),3.58200073242188e-08);
ok($diceobj->probability(12765),4.7760009765625e-08);
ok($diceobj->probability(12766),5.97000122070313e-08);
ok($diceobj->probability(12767),7.16400146484375e-08);
ok($diceobj->probability(12768),5.97000122070313e-08);
ok($diceobj->probability(12769),4.7760009765625e-08);
ok($diceobj->probability(12770),1.1336432562934e-07);
ok($diceobj->probability(12771),1.78968641493056e-07);
ok($diceobj->probability(12772),2.44572957356771e-07);
ok($diceobj->probability(12773),3.10177273220486e-07);
ok($diceobj->probability(12774),3.87721591525608e-07);
ok($diceobj->probability(12775),4.65265909830729e-07);
ok($diceobj->probability(12776),3.87721591525608e-07);
ok($diceobj->probability(12777),3.10177273220486e-07);
ok($diceobj->probability(12778),2.32632954915365e-07);
ok($diceobj->probability(12779),1.55088636610243e-07);
ok($diceobj->probability(12780),7.75443183051215e-08);
ok($diceobj->probability(12802),6.05265299479167e-09);
ok($diceobj->probability(12803),1.21053059895833e-08);
ok($diceobj->probability(12804),1.8157958984375e-08);
ok($diceobj->probability(12805),2.42106119791667e-08);
ok($diceobj->probability(12806),3.02632649739583e-08);
ok($diceobj->probability(12807),3.631591796875e-08);
ok($diceobj->probability(12808),3.02632649739583e-08);
ok($diceobj->probability(12809),2.42106119791667e-08);
ok($diceobj->probability(12810),1.8157958984375e-08);
ok($diceobj->probability(12811),1.21053059895833e-08);
ok($diceobj->probability(12812),6.05265299479167e-09);
ok($diceobj->probability(12820),1.51316324869792e-07);
ok($diceobj->probability(12821),3.02632649739583e-07);
ok($diceobj->probability(12822),4.53948974609375e-07);
ok($diceobj->probability(12823),6.05265299479167e-07);
ok($diceobj->probability(12824),7.56581624348958e-07);
ok($diceobj->probability(12825),9.0789794921875e-07);
ok($diceobj->probability(12826),7.56581624348958e-07);
ok($diceobj->probability(12827),7.02349344889323e-07);
ok($diceobj->probability(12828),6.48117065429687e-07);
ok($diceobj->probability(12829),5.93884785970052e-07);
ok($diceobj->probability(12830),5.39652506510417e-07);
ok($diceobj->probability(12831),4.85420227050781e-07);
ok($diceobj->probability(12832),5.82504272460938e-07);
ok($diceobj->probability(12833),4.85420227050781e-07);
ok($diceobj->probability(12834),3.88336181640625e-07);
ok($diceobj->probability(12835),2.91252136230469e-07);
ok($diceobj->probability(12836),2.05612182617188e-07);
ok($diceobj->probability(12837),1.19972229003906e-07);
ok($diceobj->probability(12838),3.4332275390625e-08);
ok($diceobj->probability(12839),4.57763671875e-08);
ok($diceobj->probability(12840),5.7220458984375e-08);
ok($diceobj->probability(12841),6.866455078125e-08);
ok($diceobj->probability(12842),5.7220458984375e-08);
ok($diceobj->probability(12843),4.57763671875e-08);
ok($diceobj->probability(12844),3.4332275390625e-08);
ok($diceobj->probability(12845),2.288818359375e-08);
ok($diceobj->probability(12846),6.38961791992188e-08);
ok($diceobj->probability(12847),1.04904174804688e-07);
ok($diceobj->probability(12848),1.57356262207031e-07);
ok($diceobj->probability(12849),2.09808349609375e-07);
ok($diceobj->probability(12850),2.62260437011719e-07);
ok($diceobj->probability(12851),3.14712524414063e-07);
ok($diceobj->probability(12852),2.62260437011719e-07);
ok($diceobj->probability(12853),2.09808349609375e-07);
ok($diceobj->probability(12854),3.55550977918837e-07);
ok($diceobj->probability(12855),5.01293606228299e-07);
ok($diceobj->probability(12856),6.4703623453776e-07);
ok($diceobj->probability(12857),7.92778862847222e-07);
ok($diceobj->probability(12858),9.90973578559028e-07);
ok($diceobj->probability(12859),1.18916829427083e-06);
ok($diceobj->probability(12860),9.90973578559028e-07);
ok($diceobj->probability(12861),7.92778862847222e-07);
ok($diceobj->probability(12862),5.94584147135417e-07);
ok($diceobj->probability(12863),3.96389431423611e-07);
ok($diceobj->probability(12864),1.98194715711806e-07);
ok($diceobj->probability(12882),1.91752115885417e-08);
ok($diceobj->probability(12883),3.83504231770833e-08);
ok($diceobj->probability(12884),5.7525634765625e-08);
ok($diceobj->probability(12885),7.67008463541667e-08);
ok($diceobj->probability(12886),9.58760579427083e-08);
ok($diceobj->probability(12887),1.1505126953125e-07);
ok($diceobj->probability(12888),9.58760579427083e-08);
ok($diceobj->probability(12889),7.67008463541667e-08);
ok($diceobj->probability(12890),5.7525634765625e-08);
ok($diceobj->probability(12891),3.83504231770833e-08);
ok($diceobj->probability(12892),1.91752115885417e-08);
ok($diceobj->probability(12898),2.06629435221354e-08);
ok($diceobj->probability(12899),4.13258870442708e-08);
ok($diceobj->probability(12900),6.19888305664063e-08);
ok($diceobj->probability(12901),8.26517740885417e-08);
ok($diceobj->probability(12902),1.03314717610677e-07);
ok($diceobj->probability(12903),1.23977661132813e-07);
ok($diceobj->probability(12904),1.03314717610677e-07);
ok($diceobj->probability(12905),8.26517740885417e-08);
ok($diceobj->probability(12906),6.19888305664063e-08);
ok($diceobj->probability(12907),4.13258870442708e-08);
ok($diceobj->probability(12908),2.06629435221354e-08);
ok($diceobj->probability(12960),4.76837158203125e-09);
ok($diceobj->probability(12961),9.5367431640625e-09);
ok($diceobj->probability(12962),1.60886976453993e-07);
ok($diceobj->probability(12963),3.12237209743924e-07);
ok($diceobj->probability(12964),4.63587443033854e-07);
ok($diceobj->probability(12965),6.14937676323785e-07);
ok($diceobj->probability(12966),7.56751166449653e-07);
ok($diceobj->probability(12967),8.98564656575521e-07);
ok($diceobj->probability(12968),7.4721442328559e-07);
ok($diceobj->probability(12969),5.9586418999566e-07);
ok($diceobj->probability(12970),4.44513956705729e-07);
ok($diceobj->probability(12971),2.93163723415799e-07);
ok($diceobj->probability(12972),1.46581861707899e-07);
ok($diceobj->probability(12994),1.14949544270833e-07);
ok($diceobj->probability(12995),2.29899088541667e-07);
ok($diceobj->probability(12996),3.448486328125e-07);
ok($diceobj->probability(12997),4.59798177083333e-07);
ok($diceobj->probability(12998),5.74747721354167e-07);
ok($diceobj->probability(12999),6.89697265625e-07);
ok($diceobj->probability(13000),5.74747721354167e-07);
ok($diceobj->probability(13001),4.59798177083333e-07);
ok($diceobj->probability(13002),3.7384033203125e-07);
ok($diceobj->probability(13003),2.87882486979167e-07);
ok($diceobj->probability(13004),2.01924641927083e-07);
ok($diceobj->probability(13005),1.15966796875e-07);
ok($diceobj->probability(13006),1.4495849609375e-07);
ok($diceobj->probability(13007),1.739501953125e-07);
ok($diceobj->probability(13008),1.4495849609375e-07);
ok($diceobj->probability(13009),1.15966796875e-07);
ok($diceobj->probability(13010),8.697509765625e-08);
ok($diceobj->probability(13011),5.79833984375e-08);
ok($diceobj->probability(13012),2.899169921875e-08);
ok($diceobj->probability(13022),1.68694390190972e-08);
ok($diceobj->probability(13023),3.37388780381944e-08);
ok($diceobj->probability(13024),5.06083170572917e-08);
ok($diceobj->probability(13025),6.74777560763889e-08);
ok($diceobj->probability(13026),8.43471950954861e-08);
ok($diceobj->probability(13027),1.01216634114583e-07);
ok($diceobj->probability(13028),8.43471950954861e-08);
ok($diceobj->probability(13029),6.74777560763889e-08);
ok($diceobj->probability(13030),5.06083170572917e-08);
ok($diceobj->probability(13031),3.37388780381944e-08);
ok($diceobj->probability(13032),1.68694390190972e-08);
ok($diceobj->probability(13052),1.23892890082465e-07);
ok($diceobj->probability(13053),2.47785780164931e-07);
ok($diceobj->probability(13054),3.71678670247396e-07);
ok($diceobj->probability(13055),4.95571560329861e-07);
ok($diceobj->probability(13056),6.19464450412326e-07);
ok($diceobj->probability(13057),7.43357340494792e-07);
ok($diceobj->probability(13058),6.2361823187934e-07);
ok($diceobj->probability(13059),5.03879123263889e-07);
ok($diceobj->probability(13060),3.84140014648437e-07);
ok($diceobj->probability(13061),2.64400906032986e-07);
ok($diceobj->probability(13062),1.44661797417535e-07);
ok($diceobj->probability(13063),2.49226888020833e-08);
ok($diceobj->probability(13064),2.07689073350694e-08);
ok($diceobj->probability(13065),1.66151258680556e-08);
ok($diceobj->probability(13066),1.24613444010417e-08);
ok($diceobj->probability(13067),8.30756293402778e-09);
ok($diceobj->probability(13068),4.15378146701389e-09);
ok($diceobj->probability(13106),1.26838684082031e-07);
ok($diceobj->probability(13107),2.53677368164063e-07);
ok($diceobj->probability(13108),3.80516052246094e-07);
ok($diceobj->probability(13109),5.07354736328125e-07);
ok($diceobj->probability(13110),6.34193420410156e-07);
ok($diceobj->probability(13111),7.61032104492188e-07);
ok($diceobj->probability(13112),6.53097364637587e-07);
ok($diceobj->probability(13113),5.45162624782986e-07);
ok($diceobj->probability(13114),4.37227884928385e-07);
ok($diceobj->probability(13115),3.29293145073785e-07);
ok($diceobj->probability(13116),2.21358405219184e-07);
ok($diceobj->probability(13117),1.13423665364583e-07);
ok($diceobj->probability(13118),9.45197211371528e-08);
ok($diceobj->probability(13119),7.56157769097222e-08);
ok($diceobj->probability(13120),5.67118326822917e-08);
ok($diceobj->probability(13121),3.78078884548611e-08);
ok($diceobj->probability(13122),1.89039442274306e-08);
ok($diceobj->probability(13124),7.05718994140625e-08);
ok($diceobj->probability(13125),1.41143798828125e-07);
ok($diceobj->probability(13126),2.11715698242188e-07);
ok($diceobj->probability(13127),2.8228759765625e-07);
ok($diceobj->probability(13128),3.52859497070312e-07);
ok($diceobj->probability(13129),4.23431396484375e-07);
ok($diceobj->probability(13130),3.52859497070312e-07);
ok($diceobj->probability(13131),2.8228759765625e-07);
ok($diceobj->probability(13132),2.11715698242188e-07);
ok($diceobj->probability(13133),1.41143798828125e-07);
ok($diceobj->probability(13134),7.05718994140625e-08);
ok($diceobj->probability(13177),1.55766805013021e-08);
ok($diceobj->probability(13178),3.11533610026042e-08);
ok($diceobj->probability(13179),4.67300415039063e-08);
ok($diceobj->probability(13180),6.23067220052083e-08);
ok($diceobj->probability(13181),7.78834025065104e-08);
ok($diceobj->probability(13182),9.34600830078125e-08);
ok($diceobj->probability(13183),7.78834025065104e-08);
ok($diceobj->probability(13184),6.23067220052083e-08);
ok($diceobj->probability(13185),4.67300415039063e-08);
ok($diceobj->probability(13186),3.11533610026042e-08);
ok($diceobj->probability(13187),1.55766805013021e-08);
ok($diceobj->probability(13202),4.61578369140625e-09);
ok($diceobj->probability(13203),9.2315673828125e-09);
ok($diceobj->probability(13204),1.38473510742187e-08);
ok($diceobj->probability(13205),1.8463134765625e-08);
ok($diceobj->probability(13206),2.30789184570312e-08);
ok($diceobj->probability(13207),2.76947021484375e-08);
ok($diceobj->probability(13208),2.30789184570312e-08);
ok($diceobj->probability(13209),1.8463134765625e-08);
ok($diceobj->probability(13210),1.38473510742187e-08);
ok($diceobj->probability(13211),9.2315673828125e-09);
ok($diceobj->probability(13212),4.61578369140625e-09);
ok($diceobj->probability(13226),3.90794542100694e-08);
ok($diceobj->probability(13227),7.81589084201389e-08);
ok($diceobj->probability(13228),1.17238362630208e-07);
ok($diceobj->probability(13229),1.56317816840278e-07);
ok($diceobj->probability(13230),1.95397271050347e-07);
ok($diceobj->probability(13231),2.34476725260417e-07);
ok($diceobj->probability(13232),1.95397271050347e-07);
ok($diceobj->probability(13233),1.56317816840278e-07);
ok($diceobj->probability(13234),1.17238362630208e-07);
ok($diceobj->probability(13235),7.81589084201389e-08);
ok($diceobj->probability(13236),3.90794542100694e-08);
ok($diceobj->probability(13250),2.288818359375e-09);
ok($diceobj->probability(13251),4.57763671875e-09);
ok($diceobj->probability(13252),6.866455078125e-09);
ok($diceobj->probability(13253),9.1552734375e-09);
ok($diceobj->probability(13254),1.1444091796875e-08);
ok($diceobj->probability(13255),1.373291015625e-08);
ok($diceobj->probability(13256),1.1444091796875e-08);
ok($diceobj->probability(13257),9.1552734375e-09);
ok($diceobj->probability(13258),6.866455078125e-09);
ok($diceobj->probability(13259),4.57763671875e-09);
ok($diceobj->probability(13260),2.288818359375e-09);
ok($diceobj->probability(13262),5.78562418619792e-08);
ok($diceobj->probability(13263),1.15712483723958e-07);
ok($diceobj->probability(13264),1.73568725585937e-07);
ok($diceobj->probability(13265),2.31424967447917e-07);
ok($diceobj->probability(13266),2.89281209309896e-07);
ok($diceobj->probability(13267),3.47137451171875e-07);
ok($diceobj->probability(13268),2.89281209309896e-07);
ok($diceobj->probability(13269),2.31424967447917e-07);
ok($diceobj->probability(13270),1.73568725585937e-07);
ok($diceobj->probability(13271),1.15712483723958e-07);
ok($diceobj->probability(13272),5.78562418619792e-08);
ok($diceobj->probability(13302),5.84284464518229e-08);
ok($diceobj->probability(13303),1.16856892903646e-07);
ok($diceobj->probability(13304),1.75285339355469e-07);
ok($diceobj->probability(13305),2.33713785807292e-07);
ok($diceobj->probability(13306),2.92142232259115e-07);
ok($diceobj->probability(13307),3.50570678710937e-07);
ok($diceobj->probability(13308),2.92142232259115e-07);
ok($diceobj->probability(13309),2.33713785807292e-07);
ok($diceobj->probability(13310),1.75285339355469e-07);
ok($diceobj->probability(13311),1.16856892903646e-07);
ok($diceobj->probability(13312),5.84284464518229e-08);
ok($diceobj->probability(13313),1.01322597927517e-07);
ok($diceobj->probability(13314),2.06777784559462e-07);
ok($diceobj->probability(13315),3.12232971191406e-07);
ok($diceobj->probability(13316),4.17688157823351e-07);
ok($diceobj->probability(13317),5.23143344455295e-07);
ok($diceobj->probability(13318),6.2859853108724e-07);
ok($diceobj->probability(13319),5.31408521864149e-07);
ok($diceobj->probability(13320),4.25953335232205e-07);
ok($diceobj->probability(13321),3.2049814860026e-07);
ok($diceobj->probability(13322),2.15042961968316e-07);
ok($diceobj->probability(13323),1.09587775336372e-07);
ok($diceobj->probability(13324),4.13258870442708e-09);
ok($diceobj->probability(13330),5.96364339192708e-08);
ok($diceobj->probability(13331),1.19272867838542e-07);
ok($diceobj->probability(13332),1.78909301757812e-07);
ok($diceobj->probability(13333),2.38545735677083e-07);
ok($diceobj->probability(13334),2.98182169596354e-07);
ok($diceobj->probability(13335),3.57818603515625e-07);
ok($diceobj->probability(13336),2.98182169596354e-07);
ok($diceobj->probability(13337),2.38545735677083e-07);
ok($diceobj->probability(13338),1.78909301757812e-07);
ok($diceobj->probability(13339),1.19272867838542e-07);
ok($diceobj->probability(13340),1.29890441894531e-07);
ok($diceobj->probability(13341),1.40508015950521e-07);
ok($diceobj->probability(13342),2.2057851155599e-07);
ok($diceobj->probability(13343),3.00649007161458e-07);
ok($diceobj->probability(13344),3.80719502766927e-07);
ok($diceobj->probability(13345),4.60789998372396e-07);
ok($diceobj->probability(13346),4.00352478027344e-07);
ok($diceobj->probability(13347),3.39914957682292e-07);
ok($diceobj->probability(13348),2.59844462076823e-07);
ok($diceobj->probability(13349),1.79773966471354e-07);
ok($diceobj->probability(13350),9.97034708658854e-08);
ok($diceobj->probability(13351),1.96329752604167e-08);
ok($diceobj->probability(13352),9.81648763020833e-09);
ok($diceobj->probability(13378),9.5367431640625e-10);
ok($diceobj->probability(13379),1.9073486328125e-09);
ok($diceobj->probability(13380),2.86102294921875e-09);
ok($diceobj->probability(13381),3.814697265625e-09);
ok($diceobj->probability(13382),4.76837158203125e-09);
ok($diceobj->probability(13383),5.7220458984375e-09);
ok($diceobj->probability(13384),4.76837158203125e-09);
ok($diceobj->probability(13385),3.814697265625e-09);
ok($diceobj->probability(13386),2.86102294921875e-09);
ok($diceobj->probability(13387),1.9073486328125e-09);
ok($diceobj->probability(13388),9.5367431640625e-10);
ok($diceobj->probability(13394),2.26762559678819e-08);
ok($diceobj->probability(13395),4.53525119357639e-08);
ok($diceobj->probability(13396),6.80287679036458e-08);
ok($diceobj->probability(13397),9.07050238715278e-08);
ok($diceobj->probability(13398),1.1338127983941e-07);
ok($diceobj->probability(13399),1.36057535807292e-07);
ok($diceobj->probability(13400),1.1338127983941e-07);
ok($diceobj->probability(13401),9.07050238715278e-08);
ok($diceobj->probability(13402),6.80287679036458e-08);
ok($diceobj->probability(13403),4.53525119357639e-08);
ok($diceobj->probability(13404),2.26762559678819e-08);
ok($diceobj->probability(13442),6.1904059516059e-08);
ok($diceobj->probability(13443),1.23808119032118e-07);
ok($diceobj->probability(13444),1.85712178548177e-07);
ok($diceobj->probability(13445),2.47616238064236e-07);
ok($diceobj->probability(13446),3.09520297580295e-07);
ok($diceobj->probability(13447),3.71424357096354e-07);
ok($diceobj->probability(13448),3.09520297580295e-07);
ok($diceobj->probability(13449),2.47616238064236e-07);
ok($diceobj->probability(13450),1.85712178548177e-07);
ok($diceobj->probability(13451),1.23808119032118e-07);
ok($diceobj->probability(13452),6.1904059516059e-08);
ok($diceobj->probability(13458),2.89281209309896e-08);
ok($diceobj->probability(13459),5.78562418619792e-08);
ok($diceobj->probability(13460),8.67843627929687e-08);
ok($diceobj->probability(13461),1.15712483723958e-07);
ok($diceobj->probability(13462),1.44640604654948e-07);
ok($diceobj->probability(13463),1.73568725585937e-07);
ok($diceobj->probability(13464),1.44640604654948e-07);
ok($diceobj->probability(13465),1.15712483723958e-07);
ok($diceobj->probability(13466),8.67843627929687e-08);
ok($diceobj->probability(13467),5.78562418619792e-08);
ok($diceobj->probability(13468),2.89281209309896e-08);
ok($diceobj->probability(13487),6.42140706380208e-09);
ok($diceobj->probability(13488),1.28428141276042e-08);
ok($diceobj->probability(13489),1.92642211914062e-08);
ok($diceobj->probability(13490),2.56856282552083e-08);
ok($diceobj->probability(13491),3.21070353190104e-08);
ok($diceobj->probability(13492),3.85284423828125e-08);
ok($diceobj->probability(13493),3.21070353190104e-08);
ok($diceobj->probability(13494),2.56856282552083e-08);
ok($diceobj->probability(13495),1.92642211914062e-08);
ok($diceobj->probability(13496),1.28428141276042e-08);
ok($diceobj->probability(13497),6.42140706380208e-09);
ok($diceobj->probability(13502),6.01704915364583e-08);
ok($diceobj->probability(13503),1.20340983072917e-07);
ok($diceobj->probability(13504),1.80511474609375e-07);
ok($diceobj->probability(13505),2.40681966145833e-07);
ok($diceobj->probability(13506),3.00852457682292e-07);
ok($diceobj->probability(13507),3.6102294921875e-07);
ok($diceobj->probability(13508),3.00852457682292e-07);
ok($diceobj->probability(13509),2.40681966145833e-07);
ok($diceobj->probability(13510),1.80511474609375e-07);
ok($diceobj->probability(13511),1.20340983072917e-07);
ok($diceobj->probability(13512),6.01704915364583e-08);
ok($diceobj->probability(13522),1.04904174804687e-08);
ok($diceobj->probability(13523),2.09808349609375e-08);
ok($diceobj->probability(13524),3.14712524414063e-08);
ok($diceobj->probability(13525),4.1961669921875e-08);
ok($diceobj->probability(13526),5.24520874023438e-08);
ok($diceobj->probability(13527),6.29425048828125e-08);
ok($diceobj->probability(13528),5.24520874023438e-08);
ok($diceobj->probability(13529),4.1961669921875e-08);
ok($diceobj->probability(13530),3.14712524414063e-08);
ok($diceobj->probability(13531),2.09808349609375e-08);
ok($diceobj->probability(13532),1.04904174804687e-08);
ok($diceobj->probability(13549),3.814697265625e-09);
ok($diceobj->probability(13550),7.62939453125e-09);
ok($diceobj->probability(13551),1.1444091796875e-08);
ok($diceobj->probability(13552),1.52587890625e-08);
ok($diceobj->probability(13553),1.9073486328125e-08);
ok($diceobj->probability(13554),2.288818359375e-08);
ok($diceobj->probability(13555),1.9073486328125e-08);
ok($diceobj->probability(13556),1.52587890625e-08);
ok($diceobj->probability(13557),1.1444091796875e-08);
ok($diceobj->probability(13558),7.62939453125e-09);
ok($diceobj->probability(13559),3.814697265625e-09);
ok($diceobj->probability(13574),6.4849853515625e-08);
ok($diceobj->probability(13575),1.2969970703125e-07);
ok($diceobj->probability(13576),1.94549560546875e-07);
ok($diceobj->probability(13577),2.593994140625e-07);
ok($diceobj->probability(13578),3.24249267578125e-07);
ok($diceobj->probability(13579),3.8909912109375e-07);
ok($diceobj->probability(13580),3.24249267578125e-07);
ok($diceobj->probability(13581),2.593994140625e-07);
ok($diceobj->probability(13582),1.94549560546875e-07);
ok($diceobj->probability(13583),1.2969970703125e-07);
ok($diceobj->probability(13584),6.4849853515625e-08);
ok($diceobj->probability(13602),3.11533610026042e-09);
ok($diceobj->probability(13603),6.23067220052083e-09);
ok($diceobj->probability(13604),9.34600830078125e-09);
ok($diceobj->probability(13605),1.24613444010417e-08);
ok($diceobj->probability(13606),1.55766805013021e-08);
ok($diceobj->probability(13607),1.86920166015625e-08);
ok($diceobj->probability(13608),1.55766805013021e-08);
ok($diceobj->probability(13609),1.24613444010417e-08);
ok($diceobj->probability(13610),9.42866007486979e-08);
ok($diceobj->probability(13611),1.76111857096354e-07);
ok($diceobj->probability(13612),2.5793711344401e-07);
ok($diceobj->probability(13613),3.39762369791667e-07);
ok($diceobj->probability(13614),4.24702962239583e-07);
ok($diceobj->probability(13615),5.096435546875e-07);
ok($diceobj->probability(13616),4.24702962239583e-07);
ok($diceobj->probability(13617),3.39762369791667e-07);
ok($diceobj->probability(13618),2.5482177734375e-07);
ok($diceobj->probability(13619),1.69881184895833e-07);
ok($diceobj->probability(13620),8.49405924479167e-08);
ok($diceobj->probability(13642),9.5367431640625e-10);
ok($diceobj->probability(13643),1.9073486328125e-09);
ok($diceobj->probability(13644),2.86102294921875e-09);
ok($diceobj->probability(13645),3.814697265625e-09);
ok($diceobj->probability(13646),4.76837158203125e-09);
ok($diceobj->probability(13647),5.7220458984375e-09);
ok($diceobj->probability(13648),4.76837158203125e-09);
ok($diceobj->probability(13649),3.814697265625e-09);
ok($diceobj->probability(13650),2.86102294921875e-09);
ok($diceobj->probability(13651),1.9073486328125e-09);
ok($diceobj->probability(13652),9.5367431640625e-10);
ok($diceobj->probability(13682),1.50044759114583e-08);
ok($diceobj->probability(13683),3.00089518229167e-08);
ok($diceobj->probability(13684),4.5013427734375e-08);
ok($diceobj->probability(13685),6.00179036458333e-08);
ok($diceobj->probability(13686),7.50223795572917e-08);
ok($diceobj->probability(13687),9.002685546875e-08);
ok($diceobj->probability(13688),7.50223795572917e-08);
ok($diceobj->probability(13689),6.00179036458333e-08);
ok($diceobj->probability(13690),4.5013427734375e-08);
ok($diceobj->probability(13691),3.00089518229167e-08);
ok($diceobj->probability(13692),1.50044759114583e-08);
ok($diceobj->probability(13704),1.11262003580729e-08);
ok($diceobj->probability(13705),2.22524007161458e-08);
ok($diceobj->probability(13706),3.33786010742188e-08);
ok($diceobj->probability(13707),4.45048014322917e-08);
ok($diceobj->probability(13708),5.56310017903646e-08);
ok($diceobj->probability(13709),6.67572021484375e-08);
ok($diceobj->probability(13710),5.56310017903646e-08);
ok($diceobj->probability(13711),4.45048014322917e-08);
ok($diceobj->probability(13712),3.33786010742188e-08);
ok($diceobj->probability(13713),2.22524007161458e-08);
ok($diceobj->probability(13714),1.11262003580729e-08);
ok($diceobj->probability(13772),3.87191772460937e-08);
ok($diceobj->probability(13773),7.74383544921875e-08);
ok($diceobj->probability(13774),1.16157531738281e-07);
ok($diceobj->probability(13775),1.54876708984375e-07);
ok($diceobj->probability(13776),1.93595886230469e-07);
ok($diceobj->probability(13777),2.62196858723958e-07);
ok($diceobj->probability(13778),2.5335947672526e-07);
ok($diceobj->probability(13779),2.44522094726563e-07);
ok($diceobj->probability(13780),2.35684712727865e-07);
ok($diceobj->probability(13781),2.26847330729167e-07);
ok($diceobj->probability(13782),2.18009948730469e-07);
ok($diceobj->probability(13783),1.49408976236979e-07);
ok($diceobj->probability(13784),1.19527180989583e-07);
ok($diceobj->probability(13785),8.96453857421875e-08);
ok($diceobj->probability(13786),5.97635904947917e-08);
ok($diceobj->probability(13787),2.98817952473958e-08);
ok($diceobj->probability(13802),3.78078884548611e-09);
ok($diceobj->probability(13803),7.56157769097222e-09);
ok($diceobj->probability(13804),1.13423665364583e-08);
ok($diceobj->probability(13805),1.51231553819444e-08);
ok($diceobj->probability(13806),7.98755221896701e-08);
ok($diceobj->probability(13807),1.44627888997396e-07);
ok($diceobj->probability(13808),2.01818678114149e-07);
ok($diceobj->probability(13809),2.59009467230903e-07);
ok($diceobj->probability(13810),3.16200256347656e-07);
ok($diceobj->probability(13811),3.7339104546441e-07);
ok($diceobj->probability(13812),3.08638678656684e-07);
ok($diceobj->probability(13813),2.43886311848958e-07);
ok($diceobj->probability(13814),1.82914733886719e-07);
ok($diceobj->probability(13815),1.21943155924479e-07);
ok($diceobj->probability(13816),6.09715779622396e-08);
ok($diceobj->probability(13826),4.53525119357639e-09);
ok($diceobj->probability(13827),9.07050238715278e-09);
ok($diceobj->probability(13828),1.36057535807292e-08);
ok($diceobj->probability(13829),1.81410047743056e-08);
ok($diceobj->probability(13830),2.26762559678819e-08);
ok($diceobj->probability(13831),2.72115071614583e-08);
ok($diceobj->probability(13832),2.26762559678819e-08);
ok($diceobj->probability(13833),1.81410047743056e-08);
ok($diceobj->probability(13834),5.58853149414062e-08);
ok($diceobj->probability(13835),9.36296251085069e-08);
ok($diceobj->probability(13836),1.31373935275608e-07);
ok($diceobj->probability(13837),1.69118245442708e-07);
ok($diceobj->probability(13838),2.11397806803385e-07);
ok($diceobj->probability(13839),2.53677368164063e-07);
ok($diceobj->probability(13840),2.11397806803385e-07);
ok($diceobj->probability(13841),1.69118245442708e-07);
ok($diceobj->probability(13842),1.26838684082031e-07);
ok($diceobj->probability(13843),8.45591227213542e-08);
ok($diceobj->probability(13844),4.22795613606771e-08);
ok($diceobj->probability(13853),2.35239664713542e-08);
ok($diceobj->probability(13854),4.70479329427083e-08);
ok($diceobj->probability(13855),7.05718994140625e-08);
ok($diceobj->probability(13856),9.40958658854167e-08);
ok($diceobj->probability(13857),1.17619832356771e-07);
ok($diceobj->probability(13858),1.41143798828125e-07);
ok($diceobj->probability(13859),1.17619832356771e-07);
ok($diceobj->probability(13860),9.40958658854167e-08);
ok($diceobj->probability(13861),7.05718994140625e-08);
ok($diceobj->probability(13862),4.70479329427083e-08);
ok($diceobj->probability(13863),2.35239664713542e-08);
ok($diceobj->probability(13890),8.26517740885417e-09);
ok($diceobj->probability(13891),1.65303548177083e-08);
ok($diceobj->probability(13892),2.47955322265625e-08);
ok($diceobj->probability(13893),3.30607096354167e-08);
ok($diceobj->probability(13894),4.13258870442708e-08);
ok($diceobj->probability(13895),4.9591064453125e-08);
ok($diceobj->probability(13896),4.13258870442708e-08);
ok($diceobj->probability(13897),3.30607096354167e-08);
ok($diceobj->probability(13898),2.47955322265625e-08);
ok($diceobj->probability(13899),1.65303548177083e-08);
ok($diceobj->probability(13900),8.26517740885417e-09);
ok($diceobj->probability(13922),3.11406453450521e-08);
ok($diceobj->probability(13923),6.22812906901042e-08);
ok($diceobj->probability(13924),9.34219360351563e-08);
ok($diceobj->probability(13925),1.24562581380208e-07);
ok($diceobj->probability(13926),1.5570322672526e-07);
ok($diceobj->probability(13927),1.86843872070313e-07);
ok($diceobj->probability(13928),1.5570322672526e-07);
ok($diceobj->probability(13929),1.24562581380208e-07);
ok($diceobj->probability(13930),9.34219360351563e-08);
ok($diceobj->probability(13931),6.22812906901042e-08);
ok($diceobj->probability(13932),3.11406453450521e-08);
ok($diceobj->probability(13952),8.81618923611111e-09);
ok($diceobj->probability(13953),1.76323784722222e-08);
ok($diceobj->probability(13954),2.64485677083333e-08);
ok($diceobj->probability(13955),3.52647569444444e-08);
ok($diceobj->probability(13956),4.40809461805556e-08);
ok($diceobj->probability(13957),5.28971354166667e-08);
ok($diceobj->probability(13958),4.40809461805556e-08);
ok($diceobj->probability(13959),3.52647569444444e-08);
ok($diceobj->probability(13960),2.64485677083333e-08);
ok($diceobj->probability(13961),1.76323784722222e-08);
ok($diceobj->probability(13962),8.81618923611111e-09);
ok($diceobj->probability(13986),7.62939453125e-10);
ok($diceobj->probability(13987),1.52587890625e-09);
ok($diceobj->probability(13988),2.288818359375e-09);
ok($diceobj->probability(13989),3.0517578125e-09);
ok($diceobj->probability(13990),3.814697265625e-09);
ok($diceobj->probability(13991),4.57763671875e-09);
ok($diceobj->probability(13992),3.814697265625e-09);
ok($diceobj->probability(13993),3.0517578125e-09);
ok($diceobj->probability(13994),2.288818359375e-09);
ok($diceobj->probability(13995),1.52587890625e-09);
ok($diceobj->probability(13996),7.62939453125e-10);
ok($diceobj->probability(14002),1.16856892903646e-08);
ok($diceobj->probability(14003),2.33713785807292e-08);
ok($diceobj->probability(14004),3.50570678710938e-08);
ok($diceobj->probability(14005),4.67427571614583e-08);
ok($diceobj->probability(14006),5.84284464518229e-08);
ok($diceobj->probability(14007),7.01141357421875e-08);
ok($diceobj->probability(14008),5.84284464518229e-08);
ok($diceobj->probability(14009),4.67427571614583e-08);
ok($diceobj->probability(14010),3.50570678710938e-08);
ok($diceobj->probability(14011),2.33713785807292e-08);
ok($diceobj->probability(14012),1.16856892903646e-08);
ok($diceobj->probability(14042),3.88463338216146e-08);
ok($diceobj->probability(14043),7.76926676432292e-08);
ok($diceobj->probability(14044),1.16539001464844e-07);
ok($diceobj->probability(14045),1.55385335286458e-07);
ok($diceobj->probability(14046),1.94231669108073e-07);
ok($diceobj->probability(14047),2.33078002929688e-07);
ok($diceobj->probability(14048),1.94231669108073e-07);
ok($diceobj->probability(14049),1.55385335286458e-07);
ok($diceobj->probability(14050),1.16539001464844e-07);
ok($diceobj->probability(14051),7.76926676432292e-08);
ok($diceobj->probability(14052),3.88463338216146e-08);
ok($diceobj->probability(14082),1.9073486328125e-10);
ok($diceobj->probability(14083),3.814697265625e-10);
ok($diceobj->probability(14084),5.7220458984375e-10);
ok($diceobj->probability(14085),7.62939453125e-10);
ok($diceobj->probability(14086),9.5367431640625e-10);
ok($diceobj->probability(14087),1.1444091796875e-09);
ok($diceobj->probability(14088),9.5367431640625e-10);
ok($diceobj->probability(14089),7.62939453125e-10);
ok($diceobj->probability(14090),5.7220458984375e-10);
ok($diceobj->probability(14091),3.814697265625e-10);
ok($diceobj->probability(14092),1.9073486328125e-10);
ok($diceobj->probability(14096),4.34239705403646e-08);
ok($diceobj->probability(14097),8.68479410807292e-08);
ok($diceobj->probability(14098),1.30271911621094e-07);
ok($diceobj->probability(14099),1.73695882161458e-07);
ok($diceobj->probability(14100),2.17119852701823e-07);
ok($diceobj->probability(14101),2.60543823242187e-07);
ok($diceobj->probability(14102),2.17119852701823e-07);
ok($diceobj->probability(14103),1.73695882161458e-07);
ok($diceobj->probability(14104),1.30271911621094e-07);
ok($diceobj->probability(14105),8.68479410807292e-08);
ok($diceobj->probability(14106),4.34239705403646e-08);
ok($diceobj->probability(14114),2.55584716796875e-08);
ok($diceobj->probability(14115),5.1116943359375e-08);
ok($diceobj->probability(14116),7.66754150390625e-08);
ok($diceobj->probability(14117),1.0223388671875e-07);
ok($diceobj->probability(14118),1.27792358398438e-07);
ok($diceobj->probability(14119),1.53350830078125e-07);
ok($diceobj->probability(14120),1.27792358398438e-07);
ok($diceobj->probability(14121),1.0223388671875e-07);
ok($diceobj->probability(14122),7.66754150390625e-08);
ok($diceobj->probability(14123),5.1116943359375e-08);
ok($diceobj->probability(14124),2.55584716796875e-08);
ok($diceobj->probability(14138),2.96698676215278e-09);
ok($diceobj->probability(14139),5.93397352430556e-09);
ok($diceobj->probability(14140),8.90096028645833e-09);
ok($diceobj->probability(14141),1.18679470486111e-08);
ok($diceobj->probability(14142),1.48349338107639e-08);
ok($diceobj->probability(14143),1.78019205729167e-08);
ok($diceobj->probability(14144),1.48349338107639e-08);
ok($diceobj->probability(14145),1.18679470486111e-08);
ok($diceobj->probability(14146),1.11262003580729e-08);
ok($diceobj->probability(14147),1.03844536675347e-08);
ok($diceobj->probability(14148),9.64270697699653e-09);
ok($diceobj->probability(14149),8.90096028645833e-09);
ok($diceobj->probability(14150),1.11262003580729e-08);
ok($diceobj->probability(14151),1.33514404296875e-08);
ok($diceobj->probability(14152),1.11262003580729e-08);
ok($diceobj->probability(14153),8.90096028645833e-09);
ok($diceobj->probability(14154),6.67572021484375e-09);
ok($diceobj->probability(14155),4.45048014322917e-09);
ok($diceobj->probability(14156),2.22524007161458e-09);
ok($diceobj->probability(14231),7.41746690538194e-09);
ok($diceobj->probability(14232),1.48349338107639e-08);
ok($diceobj->probability(14233),2.22524007161458e-08);
ok($diceobj->probability(14234),2.96698676215278e-08);
ok($diceobj->probability(14235),3.70873345269097e-08);
ok($diceobj->probability(14236),4.45048014322917e-08);
ok($diceobj->probability(14237),3.70873345269097e-08);
ok($diceobj->probability(14238),2.96698676215278e-08);
ok($diceobj->probability(14239),2.22524007161458e-08);
ok($diceobj->probability(14240),1.48349338107639e-08);
ok($diceobj->probability(14241),7.41746690538194e-09);
ok($diceobj->probability(14252),1.1444091796875e-08);
ok($diceobj->probability(14253),2.288818359375e-08);
ok($diceobj->probability(14254),3.4332275390625e-08);
ok($diceobj->probability(14255),4.57763671875e-08);
ok($diceobj->probability(14256),5.7220458984375e-08);
ok($diceobj->probability(14257),6.866455078125e-08);
ok($diceobj->probability(14258),5.7220458984375e-08);
ok($diceobj->probability(14259),4.57763671875e-08);
ok($diceobj->probability(14260),3.4332275390625e-08);
ok($diceobj->probability(14261),2.288818359375e-08);
ok($diceobj->probability(14262),1.220703125e-08);
ok($diceobj->probability(14263),1.52587890625e-09);
ok($diceobj->probability(14264),2.288818359375e-09);
ok($diceobj->probability(14265),3.0517578125e-09);
ok($diceobj->probability(14266),3.814697265625e-09);
ok($diceobj->probability(14267),4.57763671875e-09);
ok($diceobj->probability(14268),3.814697265625e-09);
ok($diceobj->probability(14269),3.0517578125e-09);
ok($diceobj->probability(14270),2.288818359375e-09);
ok($diceobj->probability(14271),1.52587890625e-09);
ok($diceobj->probability(14272),7.62939453125e-10);
ok($diceobj->probability(14282),2.32908460828993e-08);
ok($diceobj->probability(14283),4.65816921657986e-08);
ok($diceobj->probability(14284),6.98725382486979e-08);
ok($diceobj->probability(14285),9.31633843315972e-08);
ok($diceobj->probability(14286),1.16454230414497e-07);
ok($diceobj->probability(14287),1.39745076497396e-07);
ok($diceobj->probability(14288),1.16454230414497e-07);
ok($diceobj->probability(14289),9.31633843315972e-08);
ok($diceobj->probability(14290),6.98725382486979e-08);
ok($diceobj->probability(14291),4.65816921657986e-08);
ok($diceobj->probability(14292),2.32908460828993e-08);
ok($diceobj->probability(14299),1.55766805013021e-08);
ok($diceobj->probability(14300),3.11533610026042e-08);
ok($diceobj->probability(14301),4.67300415039063e-08);
ok($diceobj->probability(14302),6.23067220052083e-08);
ok($diceobj->probability(14303),7.78834025065104e-08);
ok($diceobj->probability(14304),9.34600830078125e-08);
ok($diceobj->probability(14305),7.78834025065104e-08);
ok($diceobj->probability(14306),6.23067220052083e-08);
ok($diceobj->probability(14307),4.67300415039063e-08);
ok($diceobj->probability(14308),3.11533610026042e-08);
ok($diceobj->probability(14309),1.55766805013021e-08);
ok($diceobj->probability(14328),2.16166178385417e-08);
ok($diceobj->probability(14329),4.32332356770833e-08);
ok($diceobj->probability(14330),6.4849853515625e-08);
ok($diceobj->probability(14331),8.64664713541667e-08);
ok($diceobj->probability(14332),1.08083089192708e-07);
ok($diceobj->probability(14333),1.2969970703125e-07);
ok($diceobj->probability(14334),1.08083089192708e-07);
ok($diceobj->probability(14335),8.64664713541667e-08);
ok($diceobj->probability(14336),6.4849853515625e-08);
ok($diceobj->probability(14337),4.32332356770833e-08);
ok($diceobj->probability(14338),2.32696533203125e-08);
ok($diceobj->probability(14339),3.30607096354167e-09);
ok($diceobj->probability(14340),4.9591064453125e-09);
ok($diceobj->probability(14341),6.61214192708333e-09);
ok($diceobj->probability(14342),8.26517740885417e-09);
ok($diceobj->probability(14343),9.918212890625e-09);
ok($diceobj->probability(14344),8.26517740885417e-09);
ok($diceobj->probability(14345),6.61214192708333e-09);
ok($diceobj->probability(14346),4.9591064453125e-09);
ok($diceobj->probability(14347),3.30607096354167e-09);
ok($diceobj->probability(14348),1.65303548177083e-09);
ok($diceobj->probability(14366),2.83135308159722e-08);
ok($diceobj->probability(14367),5.66270616319444e-08);
ok($diceobj->probability(14368),8.49405924479167e-08);
ok($diceobj->probability(14369),1.13254123263889e-07);
ok($diceobj->probability(14370),1.41567654079861e-07);
ok($diceobj->probability(14371),1.69881184895833e-07);
ok($diceobj->probability(14372),1.41567654079861e-07);
ok($diceobj->probability(14373),1.13254123263889e-07);
ok($diceobj->probability(14374),8.49405924479167e-08);
ok($diceobj->probability(14375),5.66270616319444e-08);
ok($diceobj->probability(14376),2.83135308159722e-08);
ok($diceobj->probability(14386),4.13258870442708e-09);
ok($diceobj->probability(14387),8.26517740885417e-09);
ok($diceobj->probability(14388),1.23977661132812e-08);
ok($diceobj->probability(14389),1.65303548177083e-08);
ok($diceobj->probability(14390),2.06629435221354e-08);
ok($diceobj->probability(14391),2.47955322265625e-08);
ok($diceobj->probability(14392),2.06629435221354e-08);
ok($diceobj->probability(14393),1.65303548177083e-08);
ok($diceobj->probability(14394),1.23977661132812e-08);
ok($diceobj->probability(14395),8.26517740885417e-09);
ok($diceobj->probability(14396),4.13258870442708e-09);
ok($diceobj->probability(14402),8.89672173394097e-09);
ok($diceobj->probability(14403),1.77934434678819e-08);
ok($diceobj->probability(14404),2.66901652018229e-08);
ok($diceobj->probability(14405),3.55868869357639e-08);
ok($diceobj->probability(14406),4.44836086697049e-08);
ok($diceobj->probability(14407),5.33803304036458e-08);
ok($diceobj->probability(14408),4.44836086697049e-08);
ok($diceobj->probability(14409),3.55868869357639e-08);
ok($diceobj->probability(14410),2.66901652018229e-08);
ok($diceobj->probability(14411),1.77934434678819e-08);
ok($diceobj->probability(14412),8.89672173394097e-09);
ok($diceobj->probability(14502),5.97635904947917e-09);
ok($diceobj->probability(14503),1.19527180989583e-08);
ok($diceobj->probability(14504),1.79290771484375e-08);
ok($diceobj->probability(14505),2.39054361979167e-08);
ok($diceobj->probability(14506),2.98817952473958e-08);
ok($diceobj->probability(14507),3.5858154296875e-08);
ok($diceobj->probability(14508),2.98817952473958e-08);
ok($diceobj->probability(14509),2.39054361979167e-08);
ok($diceobj->probability(14510),2.26974487304688e-08);
ok($diceobj->probability(14511),2.14894612630208e-08);
ok($diceobj->probability(14512),2.02814737955729e-08);
ok($diceobj->probability(14513),1.9073486328125e-08);
ok($diceobj->probability(14514),2.38418579101563e-08);
ok($diceobj->probability(14515),2.86102294921875e-08);
ok($diceobj->probability(14516),2.38418579101563e-08);
ok($diceobj->probability(14517),1.9073486328125e-08);
ok($diceobj->probability(14518),1.43051147460937e-08);
ok($diceobj->probability(14519),9.5367431640625e-09);
ok($diceobj->probability(14520),4.76837158203125e-09);
ok($diceobj->probability(14562),8.45591227213542e-09);
ok($diceobj->probability(14563),1.69118245442708e-08);
ok($diceobj->probability(14564),2.53677368164062e-08);
ok($diceobj->probability(14565),3.38236490885417e-08);
ok($diceobj->probability(14566),4.22795613606771e-08);
ok($diceobj->probability(14567),5.07354736328125e-08);
ok($diceobj->probability(14568),4.22795613606771e-08);
ok($diceobj->probability(14569),3.38236490885417e-08);
ok($diceobj->probability(14570),2.53677368164062e-08);
ok($diceobj->probability(14571),1.69118245442708e-08);
ok($diceobj->probability(14572),8.45591227213542e-09);
ok($diceobj->probability(14582),2.12987263997396e-08);
ok($diceobj->probability(14583),4.25974527994792e-08);
ok($diceobj->probability(14584),6.38961791992188e-08);
ok($diceobj->probability(14585),8.51949055989583e-08);
ok($diceobj->probability(14586),1.06493631998698e-07);
ok($diceobj->probability(14587),1.27792358398438e-07);
ok($diceobj->probability(14588),1.06493631998698e-07);
ok($diceobj->probability(14589),8.51949055989583e-08);
ok($diceobj->probability(14590),6.38961791992188e-08);
ok($diceobj->probability(14591),4.25974527994792e-08);
ok($diceobj->probability(14592),2.12987263997396e-08);
ok($diceobj->probability(14594),5.93397352430556e-10);
ok($diceobj->probability(14595),1.18679470486111e-09);
ok($diceobj->probability(14596),1.78019205729167e-09);
ok($diceobj->probability(14597),2.37358940972222e-09);
ok($diceobj->probability(14598),2.96698676215278e-09);
ok($diceobj->probability(14599),3.56038411458333e-09);
ok($diceobj->probability(14600),2.96698676215278e-09);
ok($diceobj->probability(14601),2.37358940972222e-09);
ok($diceobj->probability(14602),1.78019205729167e-09);
ok($diceobj->probability(14603),1.18679470486111e-09);
ok($diceobj->probability(14604),5.93397352430556e-10);
ok($diceobj->probability(14618),2.61306762695313e-08);
ok($diceobj->probability(14619),5.22613525390625e-08);
ok($diceobj->probability(14620),7.83920288085937e-08);
ok($diceobj->probability(14621),1.04522705078125e-07);
ok($diceobj->probability(14622),1.30653381347656e-07);
ok($diceobj->probability(14623),1.56784057617187e-07);
ok($diceobj->probability(14624),1.30653381347656e-07);
ok($diceobj->probability(14625),1.04522705078125e-07);
ok($diceobj->probability(14626),7.83920288085937e-08);
ok($diceobj->probability(14627),5.22613525390625e-08);
ok($diceobj->probability(14628),2.61306762695313e-08);
ok($diceobj->probability(14690),1.48349338107639e-09);
ok($diceobj->probability(14691),2.96698676215278e-09);
ok($diceobj->probability(14692),4.45048014322917e-09);
ok($diceobj->probability(14693),5.93397352430556e-09);
ok($diceobj->probability(14694),7.41746690538194e-09);
ok($diceobj->probability(14695),8.90096028645833e-09);
ok($diceobj->probability(14696),7.41746690538194e-09);
ok($diceobj->probability(14697),5.93397352430556e-09);
ok($diceobj->probability(14698),4.45048014322917e-09);
ok($diceobj->probability(14699),2.96698676215278e-09);
ok($diceobj->probability(14700),1.48349338107639e-09);
ok($diceobj->probability(14722),1.52587890625e-10);
ok($diceobj->probability(14723),3.0517578125e-10);
ok($diceobj->probability(14724),4.57763671875e-10);
ok($diceobj->probability(14725),6.103515625e-10);
ok($diceobj->probability(14726),7.62939453125e-10);
ok($diceobj->probability(14727),3.14076741536458e-09);
ok($diceobj->probability(14728),5.21341959635417e-09);
ok($diceobj->probability(14729),7.28607177734375e-09);
ok($diceobj->probability(14730),9.35872395833333e-09);
ok($diceobj->probability(14731),1.14313761393229e-08);
ok($diceobj->probability(14732),1.35040283203125e-08);
ok($diceobj->probability(14733),1.11262003580729e-08);
ok($diceobj->probability(14734),8.90096028645833e-09);
ok($diceobj->probability(14735),6.67572021484375e-09);
ok($diceobj->probability(14736),4.45048014322917e-09);
ok($diceobj->probability(14737),2.22524007161458e-09);
ok($diceobj->probability(14758),4.45048014322917e-09);
ok($diceobj->probability(14759),8.90096028645833e-09);
ok($diceobj->probability(14760),1.33514404296875e-08);
ok($diceobj->probability(14761),1.78019205729167e-08);
ok($diceobj->probability(14762),2.22524007161458e-08);
ok($diceobj->probability(14763),2.6702880859375e-08);
ok($diceobj->probability(14764),2.22524007161458e-08);
ok($diceobj->probability(14765),1.78019205729167e-08);
ok($diceobj->probability(14766),1.33514404296875e-08);
ok($diceobj->probability(14767),8.90096028645833e-09);
ok($diceobj->probability(14768),4.45048014322917e-09);
ok($diceobj->probability(14792),1.18679470486111e-08);
ok($diceobj->probability(14793),2.37358940972222e-08);
ok($diceobj->probability(14794),3.56038411458333e-08);
ok($diceobj->probability(14795),4.74717881944444e-08);
ok($diceobj->probability(14796),5.93397352430556e-08);
ok($diceobj->probability(14797),7.12076822916667e-08);
ok($diceobj->probability(14798),5.93397352430556e-08);
ok($diceobj->probability(14799),4.74717881944444e-08);
ok($diceobj->probability(14800),3.56038411458333e-08);
ok($diceobj->probability(14801),2.37358940972222e-08);
ok($diceobj->probability(14802),1.18679470486111e-08);
ok($diceobj->probability(14822),8.26517740885417e-09);
ok($diceobj->probability(14823),1.65303548177083e-08);
ok($diceobj->probability(14824),2.47955322265625e-08);
ok($diceobj->probability(14825),3.30607096354167e-08);
ok($diceobj->probability(14826),4.13258870442708e-08);
ok($diceobj->probability(14827),4.9591064453125e-08);
ok($diceobj->probability(14828),4.13258870442708e-08);
ok($diceobj->probability(14829),3.30607096354167e-08);
ok($diceobj->probability(14830),2.47955322265625e-08);
ok($diceobj->probability(14831),1.65303548177083e-08);
ok($diceobj->probability(14832),8.26517740885417e-09);
ok($diceobj->probability(14850),8.26517740885417e-10);
ok($diceobj->probability(14851),1.65303548177083e-09);
ok($diceobj->probability(14852),2.47955322265625e-09);
ok($diceobj->probability(14853),3.30607096354167e-09);
ok($diceobj->probability(14854),4.13258870442708e-09);
ok($diceobj->probability(14855),4.9591064453125e-09);
ok($diceobj->probability(14856),4.13258870442708e-09);
ok($diceobj->probability(14857),3.30607096354167e-09);
ok($diceobj->probability(14858),2.47955322265625e-09);
ok($diceobj->probability(14859),1.65303548177083e-09);
ok($diceobj->probability(14860),8.26517740885417e-10);
ok($diceobj->probability(14879),1.44746568467882e-08);
ok($diceobj->probability(14880),2.89493136935764e-08);
ok($diceobj->probability(14881),4.34239705403646e-08);
ok($diceobj->probability(14882),5.98695543077257e-08);
ok($diceobj->probability(14883),7.63151380750868e-08);
ok($diceobj->probability(14884),9.27607218424479e-08);
ok($diceobj->probability(14885),8.02569919162326e-08);
ok($diceobj->probability(14886),6.77532619900174e-08);
ok($diceobj->probability(14887),5.52495320638021e-08);
ok($diceobj->probability(14888),3.8803948296441e-08);
ok($diceobj->probability(14889),2.23583645290799e-08);
ok($diceobj->probability(14890),5.91278076171875e-09);
ok($diceobj->probability(14891),3.94185384114583e-09);
ok($diceobj->probability(14892),1.97092692057292e-09);
ok($diceobj->probability(14898),8.51949055989583e-09);
ok($diceobj->probability(14899),1.70389811197917e-08);
ok($diceobj->probability(14900),2.55584716796875e-08);
ok($diceobj->probability(14901),3.40779622395833e-08);
ok($diceobj->probability(14902),4.25974527994792e-08);
ok($diceobj->probability(14903),5.1116943359375e-08);
ok($diceobj->probability(14904),4.25974527994792e-08);
ok($diceobj->probability(14905),3.40779622395833e-08);
ok($diceobj->probability(14906),2.55584716796875e-08);
ok($diceobj->probability(14907),1.70389811197917e-08);
ok($diceobj->probability(14908),8.51949055989583e-09);
ok($diceobj->probability(14978),9.5367431640625e-10);
ok($diceobj->probability(14979),1.9073486328125e-09);
ok($diceobj->probability(14980),2.86102294921875e-09);
ok($diceobj->probability(14981),3.814697265625e-09);
ok($diceobj->probability(14982),4.76837158203125e-09);
ok($diceobj->probability(14983),5.7220458984375e-09);
ok($diceobj->probability(14984),4.76837158203125e-09);
ok($diceobj->probability(14985),3.814697265625e-09);
ok($diceobj->probability(14986),2.86102294921875e-09);
ok($diceobj->probability(14987),1.9073486328125e-09);
ok($diceobj->probability(14988),9.5367431640625e-10);
ok($diceobj->probability(15002),2.288818359375e-09);
ok($diceobj->probability(15003),4.57763671875e-09);
ok($diceobj->probability(15004),6.866455078125e-09);
ok($diceobj->probability(15005),9.1552734375e-09);
ok($diceobj->probability(15006),1.1444091796875e-08);
ok($diceobj->probability(15007),1.373291015625e-08);
ok($diceobj->probability(15008),1.1444091796875e-08);
ok($diceobj->probability(15009),9.1552734375e-09);
ok($diceobj->probability(15010),6.866455078125e-09);
ok($diceobj->probability(15011),4.57763671875e-09);
ok($diceobj->probability(15012),2.288818359375e-09);
ok($diceobj->probability(15068),3.17891438802083e-09);
ok($diceobj->probability(15069),6.35782877604167e-09);
ok($diceobj->probability(15070),9.5367431640625e-09);
ok($diceobj->probability(15071),1.27156575520833e-08);
ok($diceobj->probability(15072),1.58945719401042e-08);
ok($diceobj->probability(15073),1.9073486328125e-08);
ok($diceobj->probability(15074),1.58945719401042e-08);
ok($diceobj->probability(15075),1.27156575520833e-08);
ok($diceobj->probability(15076),9.5367431640625e-09);
ok($diceobj->probability(15077),6.35782877604167e-09);
ok($diceobj->probability(15078),3.17891438802083e-09);
ok($diceobj->probability(15082),4.32332356770833e-09);
ok($diceobj->probability(15083),8.64664713541667e-09);
ok($diceobj->probability(15084),1.2969970703125e-08);
ok($diceobj->probability(15085),1.72932942708333e-08);
ok($diceobj->probability(15086),2.16166178385417e-08);
ok($diceobj->probability(15087),2.593994140625e-08);
ok($diceobj->probability(15088),2.16166178385417e-08);
ok($diceobj->probability(15089),1.72932942708333e-08);
ok($diceobj->probability(15090),1.2969970703125e-08);
ok($diceobj->probability(15091),8.64664713541667e-09);
ok($diceobj->probability(15092),4.32332356770833e-09);
ok($diceobj->probability(15122),1.56444973415799e-08);
ok($diceobj->probability(15123),3.12889946831597e-08);
ok($diceobj->probability(15124),4.69334920247396e-08);
ok($diceobj->probability(15125),6.25779893663194e-08);
ok($diceobj->probability(15126),7.82224867078993e-08);
ok($diceobj->probability(15127),9.38669840494792e-08);
ok($diceobj->probability(15128),7.82224867078993e-08);
ok($diceobj->probability(15129),6.25779893663194e-08);
ok($diceobj->probability(15130),4.69334920247396e-08);
ok($diceobj->probability(15131),3.12889946831597e-08);
ok($diceobj->probability(15132),1.56444973415799e-08);
ok($diceobj->probability(15140),6.67572021484375e-09);
ok($diceobj->probability(15141),1.33514404296875e-08);
ok($diceobj->probability(15142),2.00271606445313e-08);
ok($diceobj->probability(15143),2.6702880859375e-08);
ok($diceobj->probability(15144),3.33786010742188e-08);
ok($diceobj->probability(15145),4.00543212890625e-08);
ok($diceobj->probability(15146),3.33786010742188e-08);
ok($diceobj->probability(15147),2.6702880859375e-08);
ok($diceobj->probability(15148),2.00271606445313e-08);
ok($diceobj->probability(15149),1.33514404296875e-08);
ok($diceobj->probability(15150),6.67572021484375e-09);
ok($diceobj->probability(15202),4.45048014322917e-10);
ok($diceobj->probability(15203),8.90096028645833e-10);
ok($diceobj->probability(15204),1.33514404296875e-09);
ok($diceobj->probability(15205),1.78019205729167e-09);
ok($diceobj->probability(15206),2.22524007161458e-09);
ok($diceobj->probability(15207),2.6702880859375e-09);
ok($diceobj->probability(15208),2.22524007161458e-09);
ok($diceobj->probability(15209),1.78019205729167e-09);
ok($diceobj->probability(15210),1.33514404296875e-09);
ok($diceobj->probability(15211),8.90096028645833e-10);
ok($diceobj->probability(15212),4.45048014322917e-10);
ok($diceobj->probability(15234),8.90096028645833e-10);
ok($diceobj->probability(15235),1.78019205729167e-09);
ok($diceobj->probability(15236),2.6702880859375e-09);
ok($diceobj->probability(15237),3.56038411458333e-09);
ok($diceobj->probability(15238),4.45048014322917e-09);
ok($diceobj->probability(15239),5.340576171875e-09);
ok($diceobj->probability(15240),4.45048014322917e-09);
ok($diceobj->probability(15241),3.56038411458333e-09);
ok($diceobj->probability(15242),2.6702880859375e-09);
ok($diceobj->probability(15243),1.78019205729167e-09);
ok($diceobj->probability(15244),8.90096028645833e-10);
ok($diceobj->probability(15285),2.22524007161458e-09);
ok($diceobj->probability(15286),4.45048014322917e-09);
ok($diceobj->probability(15287),6.67572021484375e-09);
ok($diceobj->probability(15288),8.90096028645833e-09);
ok($diceobj->probability(15289),1.11262003580729e-08);
ok($diceobj->probability(15290),1.33514404296875e-08);
ok($diceobj->probability(15291),1.11262003580729e-08);
ok($diceobj->probability(15292),8.90096028645833e-09);
ok($diceobj->probability(15293),6.67572021484375e-09);
ok($diceobj->probability(15294),4.45048014322917e-09);
ok($diceobj->probability(15295),2.22524007161458e-09);
ok($diceobj->probability(15302),2.22524007161458e-09);
ok($diceobj->probability(15303),4.45048014322917e-09);
ok($diceobj->probability(15304),6.67572021484375e-09);
ok($diceobj->probability(15305),8.90096028645833e-09);
ok($diceobj->probability(15306),1.11262003580729e-08);
ok($diceobj->probability(15307),1.33514404296875e-08);
ok($diceobj->probability(15308),1.11262003580729e-08);
ok($diceobj->probability(15309),8.90096028645833e-09);
ok($diceobj->probability(15310),6.67572021484375e-09);
ok($diceobj->probability(15311),4.45048014322917e-09);
ok($diceobj->probability(15312),2.22524007161458e-09);
ok($diceobj->probability(15316),1.58945719401042e-09);
ok($diceobj->probability(15317),3.17891438802083e-09);
ok($diceobj->probability(15318),4.76837158203125e-09);
ok($diceobj->probability(15319),6.35782877604167e-09);
ok($diceobj->probability(15320),7.94728597005208e-09);
ok($diceobj->probability(15321),9.5367431640625e-09);
ok($diceobj->probability(15322),7.94728597005208e-09);
ok($diceobj->probability(15323),6.35782877604167e-09);
ok($diceobj->probability(15324),4.76837158203125e-09);
ok($diceobj->probability(15325),3.17891438802083e-09);
ok($diceobj->probability(15326),1.58945719401042e-09);
ok($diceobj->probability(15362),3.94185384114583e-10);
ok($diceobj->probability(15363),7.88370768229167e-10);
ok($diceobj->probability(15364),1.18255615234375e-09);
ok($diceobj->probability(15365),1.57674153645833e-09);
ok($diceobj->probability(15366),1.97092692057292e-09);
ok($diceobj->probability(15367),2.3651123046875e-09);
ok($diceobj->probability(15368),1.97092692057292e-09);
ok($diceobj->probability(15369),1.57674153645833e-09);
ok($diceobj->probability(15370),1.18255615234375e-09);
ok($diceobj->probability(15371),7.88370768229167e-10);
ok($diceobj->probability(15372),3.94185384114583e-10);
ok($diceobj->probability(15392),5.53131103515625e-09);
ok($diceobj->probability(15393),1.10626220703125e-08);
ok($diceobj->probability(15394),1.65939331054687e-08);
ok($diceobj->probability(15395),2.2125244140625e-08);
ok($diceobj->probability(15396),2.76565551757813e-08);
ok($diceobj->probability(15397),3.31878662109375e-08);
ok($diceobj->probability(15398),2.76565551757813e-08);
ok($diceobj->probability(15399),2.2125244140625e-08);
ok($diceobj->probability(15400),1.65939331054687e-08);
ok($diceobj->probability(15401),1.10626220703125e-08);
ok($diceobj->probability(15402),5.53131103515625e-09);
ok($diceobj->probability(15430),8.71022542317708e-09);
ok($diceobj->probability(15431),1.74204508463542e-08);
ok($diceobj->probability(15432),2.61306762695313e-08);
ok($diceobj->probability(15433),3.48409016927083e-08);
ok($diceobj->probability(15434),4.35511271158854e-08);
ok($diceobj->probability(15435),5.22613525390625e-08);
ok($diceobj->probability(15436),4.35511271158854e-08);
ok($diceobj->probability(15437),3.48409016927083e-08);
ok($diceobj->probability(15438),2.61306762695313e-08);
ok($diceobj->probability(15439),1.74204508463542e-08);
ok($diceobj->probability(15440),8.71022542317708e-09);
ok($diceobj->probability(15502),4.45048014322917e-10);
ok($diceobj->probability(15503),8.90096028645833e-10);
ok($diceobj->probability(15504),1.33514404296875e-09);
ok($diceobj->probability(15505),1.78019205729167e-09);
ok($diceobj->probability(15506),2.22524007161458e-09);
ok($diceobj->probability(15507),2.6702880859375e-09);
ok($diceobj->probability(15508),2.22524007161458e-09);
ok($diceobj->probability(15509),1.78019205729167e-09);
ok($diceobj->probability(15510),1.33514404296875e-09);
ok($diceobj->probability(15511),8.90096028645833e-10);
ok($diceobj->probability(15512),4.45048014322917e-10);
ok($diceobj->probability(15554),6.35782877604167e-10);
ok($diceobj->probability(15555),1.27156575520833e-09);
ok($diceobj->probability(15556),1.9073486328125e-09);
ok($diceobj->probability(15557),2.54313151041667e-09);
ok($diceobj->probability(15558),3.17891438802083e-09);
ok($diceobj->probability(15559),3.814697265625e-09);
ok($diceobj->probability(15560),3.17891438802083e-09);
ok($diceobj->probability(15561),2.54313151041667e-09);
ok($diceobj->probability(15562),1.9073486328125e-09);
ok($diceobj->probability(15563),1.27156575520833e-09);
ok($diceobj->probability(15564),6.35782877604167e-10);
ok($diceobj->probability(15602),1.65303548177083e-09);
ok($diceobj->probability(15603),3.30607096354167e-09);
ok($diceobj->probability(15604),4.9591064453125e-09);
ok($diceobj->probability(15605),6.61214192708333e-09);
ok($diceobj->probability(15606),8.26517740885417e-09);
ok($diceobj->probability(15607),9.918212890625e-09);
ok($diceobj->probability(15608),8.26517740885417e-09);
ok($diceobj->probability(15609),6.61214192708333e-09);
ok($diceobj->probability(15610),4.9591064453125e-09);
ok($diceobj->probability(15611),3.30607096354167e-09);
ok($diceobj->probability(15612),1.65303548177083e-09);
ok($diceobj->probability(15626),1.9073486328125e-09);
ok($diceobj->probability(15627),3.814697265625e-09);
ok($diceobj->probability(15628),5.7220458984375e-09);
ok($diceobj->probability(15629),7.62939453125e-09);
ok($diceobj->probability(15630),9.5367431640625e-09);
ok($diceobj->probability(15631),1.1444091796875e-08);
ok($diceobj->probability(15632),9.5367431640625e-09);
ok($diceobj->probability(15633),7.62939453125e-09);
ok($diceobj->probability(15634),5.7220458984375e-09);
ok($diceobj->probability(15635),3.814697265625e-09);
ok($diceobj->probability(15636),1.9073486328125e-09);
ok($diceobj->probability(15662),7.98119439019097e-09);
ok($diceobj->probability(15663),1.59623887803819e-08);
ok($diceobj->probability(15664),2.39435831705729e-08);
ok($diceobj->probability(15665),3.19247775607639e-08);
ok($diceobj->probability(15666),3.99059719509549e-08);
ok($diceobj->probability(15667),4.78871663411458e-08);
ok($diceobj->probability(15668),3.99059719509549e-08);
ok($diceobj->probability(15669),3.19247775607639e-08);
ok($diceobj->probability(15670),2.39435831705729e-08);
ok($diceobj->probability(15671),1.59623887803819e-08);
ok($diceobj->probability(15672),7.98119439019097e-09);
ok($diceobj->probability(15682),1.70389811197917e-09);
ok($diceobj->probability(15683),3.40779622395833e-09);
ok($diceobj->probability(15684),5.1116943359375e-09);
ok($diceobj->probability(15685),6.81559244791667e-09);
ok($diceobj->probability(15686),8.51949055989583e-09);
ok($diceobj->probability(15687),1.0223388671875e-08);
ok($diceobj->probability(15688),8.51949055989583e-09);
ok($diceobj->probability(15689),6.81559244791667e-09);
ok($diceobj->probability(15690),5.1116943359375e-09);
ok($diceobj->probability(15691),3.40779622395833e-09);
ok($diceobj->probability(15692),1.70389811197917e-09);
ok($diceobj->probability(15778),4.45048014322917e-10);
ok($diceobj->probability(15779),8.90096028645833e-10);
ok($diceobj->probability(15780),1.33514404296875e-09);
ok($diceobj->probability(15781),1.78019205729167e-09);
ok($diceobj->probability(15782),2.22524007161458e-09);
ok($diceobj->probability(15783),2.6702880859375e-09);
ok($diceobj->probability(15784),2.22524007161458e-09);
ok($diceobj->probability(15785),1.78019205729167e-09);
ok($diceobj->probability(15786),1.33514404296875e-09);
ok($diceobj->probability(15787),8.90096028645833e-10);
ok($diceobj->probability(15788),4.45048014322917e-10);
ok($diceobj->probability(15810),3.17891438802083e-10);
ok($diceobj->probability(15811),6.35782877604167e-10);
ok($diceobj->probability(15812),1.69542100694444e-09);
ok($diceobj->probability(15813),2.75505913628472e-09);
ok($diceobj->probability(15814),3.814697265625e-09);
ok($diceobj->probability(15815),4.87433539496528e-09);
ok($diceobj->probability(15816),5.29819064670139e-09);
ok($diceobj->probability(15817),5.7220458984375e-09);
ok($diceobj->probability(15818),4.66240776909722e-09);
ok($diceobj->probability(15819),3.60276963975694e-09);
ok($diceobj->probability(15820),2.54313151041667e-09);
ok($diceobj->probability(15821),1.48349338107639e-09);
ok($diceobj->probability(15822),7.41746690538194e-10);
ok($diceobj->probability(15905),1.05963812934028e-09);
ok($diceobj->probability(15906),2.11927625868056e-09);
ok($diceobj->probability(15907),3.17891438802083e-09);
ok($diceobj->probability(15908),4.23855251736111e-09);
ok($diceobj->probability(15909),5.29819064670139e-09);
ok($diceobj->probability(15910),6.35782877604167e-09);
ok($diceobj->probability(15911),5.29819064670139e-09);
ok($diceobj->probability(15912),4.23855251736111e-09);
ok($diceobj->probability(15913),3.17891438802083e-09);
ok($diceobj->probability(15914),2.11927625868056e-09);
ok($diceobj->probability(15915),1.05963812934028e-09);
ok($diceobj->probability(15962),3.32726372612847e-09);
ok($diceobj->probability(15963),6.65452745225694e-09);
ok($diceobj->probability(15964),9.98179117838542e-09);
ok($diceobj->probability(15965),1.33090549045139e-08);
ok($diceobj->probability(15966),1.66363186306424e-08);
ok($diceobj->probability(15967),1.99635823567708e-08);
ok($diceobj->probability(15968),1.66363186306424e-08);
ok($diceobj->probability(15969),1.33090549045139e-08);
ok($diceobj->probability(15970),9.98179117838542e-09);
ok($diceobj->probability(15971),6.65452745225694e-09);
ok($diceobj->probability(15972),3.32726372612847e-09);
ok($diceobj->probability(15981),2.22524007161458e-09);
ok($diceobj->probability(15982),4.45048014322917e-09);
ok($diceobj->probability(15983),6.67572021484375e-09);
ok($diceobj->probability(15984),8.90096028645833e-09);
ok($diceobj->probability(15985),1.11262003580729e-08);
ok($diceobj->probability(15986),1.33514404296875e-08);
ok($diceobj->probability(15987),1.11262003580729e-08);
ok($diceobj->probability(15988),8.90096028645833e-09);
ok($diceobj->probability(15989),6.67572021484375e-09);
ok($diceobj->probability(15990),4.45048014322917e-09);
ok($diceobj->probability(15991),2.22524007161458e-09);
ok($diceobj->probability(16002),8.90096028645833e-11);
ok($diceobj->probability(16003),1.78019205729167e-10);
ok($diceobj->probability(16004),2.6702880859375e-10);
ok($diceobj->probability(16005),3.56038411458333e-10);
ok($diceobj->probability(16006),4.45048014322917e-10);
ok($diceobj->probability(16007),5.340576171875e-10);
ok($diceobj->probability(16008),4.45048014322917e-10);
ok($diceobj->probability(16009),3.56038411458333e-10);
ok($diceobj->probability(16010),2.6702880859375e-10);
ok($diceobj->probability(16011),1.78019205729167e-10);
ok($diceobj->probability(16012),8.90096028645833e-11);
ok($diceobj->probability(16122),3.17891438802083e-10);
ok($diceobj->probability(16123),6.35782877604167e-10);
ok($diceobj->probability(16124),9.5367431640625e-10);
ok($diceobj->probability(16125),1.27156575520833e-09);
ok($diceobj->probability(16126),1.58945719401042e-09);
ok($diceobj->probability(16127),1.9073486328125e-09);
ok($diceobj->probability(16128),1.58945719401042e-09);
ok($diceobj->probability(16129),1.27156575520833e-09);
ok($diceobj->probability(16130),1.33514404296875e-09);
ok($diceobj->probability(16131),1.39872233072917e-09);
ok($diceobj->probability(16132),1.46230061848958e-09);
ok($diceobj->probability(16133),1.52587890625e-09);
ok($diceobj->probability(16134),1.9073486328125e-09);
ok($diceobj->probability(16135),2.288818359375e-09);
ok($diceobj->probability(16136),1.9073486328125e-09);
ok($diceobj->probability(16137),1.52587890625e-09);
ok($diceobj->probability(16138),1.1444091796875e-09);
ok($diceobj->probability(16139),7.62939453125e-10);
ok($diceobj->probability(16140),3.814697265625e-10);
ok($diceobj->probability(16184),9.5367431640625e-10);
ok($diceobj->probability(16185),1.9073486328125e-09);
ok($diceobj->probability(16186),2.86102294921875e-09);
ok($diceobj->probability(16187),3.814697265625e-09);
ok($diceobj->probability(16188),4.76837158203125e-09);
ok($diceobj->probability(16189),5.7220458984375e-09);
ok($diceobj->probability(16190),4.76837158203125e-09);
ok($diceobj->probability(16191),3.814697265625e-09);
ok($diceobj->probability(16192),2.86102294921875e-09);
ok($diceobj->probability(16193),1.9073486328125e-09);
ok($diceobj->probability(16194),9.5367431640625e-10);
ok($diceobj->probability(16202),2.0599365234375e-09);
ok($diceobj->probability(16203),4.119873046875e-09);
ok($diceobj->probability(16204),6.1798095703125e-09);
ok($diceobj->probability(16205),8.23974609375e-09);
ok($diceobj->probability(16206),1.02996826171875e-08);
ok($diceobj->probability(16207),1.2359619140625e-08);
ok($diceobj->probability(16208),1.02996826171875e-08);
ok($diceobj->probability(16209),8.23974609375e-09);
ok($diceobj->probability(16210),6.1798095703125e-09);
ok($diceobj->probability(16211),4.119873046875e-09);
ok($diceobj->probability(16212),2.0599365234375e-09);
ok($diceobj->probability(16242),1.74204508463542e-09);
ok($diceobj->probability(16243),3.48409016927083e-09);
ok($diceobj->probability(16244),5.22613525390625e-09);
ok($diceobj->probability(16245),6.96818033854167e-09);
ok($diceobj->probability(16246),8.71022542317708e-09);
ok($diceobj->probability(16247),1.04522705078125e-08);
ok($diceobj->probability(16248),8.71022542317708e-09);
ok($diceobj->probability(16249),6.96818033854167e-09);
ok($diceobj->probability(16250),5.22613525390625e-09);
ok($diceobj->probability(16251),3.48409016927083e-09);
ok($diceobj->probability(16252),1.74204508463542e-09);
ok($diceobj->probability(16322),1.48349338107639e-10);
ok($diceobj->probability(16323),2.96698676215278e-10);
ok($diceobj->probability(16324),4.45048014322917e-10);
ok($diceobj->probability(16325),5.93397352430556e-10);
ok($diceobj->probability(16326),7.41746690538194e-10);
ok($diceobj->probability(16327),8.90096028645833e-10);
ok($diceobj->probability(16328),7.41746690538194e-10);
ok($diceobj->probability(16329),5.93397352430556e-10);
ok($diceobj->probability(16330),4.45048014322917e-10);
ok($diceobj->probability(16331),2.96698676215278e-10);
ok($diceobj->probability(16332),1.48349338107639e-10);
ok($diceobj->probability(16418),2.11927625868056e-10);
ok($diceobj->probability(16419),4.23855251736111e-10);
ok($diceobj->probability(16420),6.35782877604167e-10);
ok($diceobj->probability(16421),8.47710503472222e-10);
ok($diceobj->probability(16422),1.05963812934028e-09);
ok($diceobj->probability(16423),1.27156575520833e-09);
ok($diceobj->probability(16424),1.05963812934028e-09);
ok($diceobj->probability(16425),8.47710503472222e-10);
ok($diceobj->probability(16426),6.35782877604167e-10);
ok($diceobj->probability(16427),4.23855251736111e-10);
ok($diceobj->probability(16428),2.11927625868056e-10);
ok($diceobj->probability(16494),6.35782877604167e-10);
ok($diceobj->probability(16495),1.27156575520833e-09);
ok($diceobj->probability(16496),1.9073486328125e-09);
ok($diceobj->probability(16497),2.54313151041667e-09);
ok($diceobj->probability(16498),3.17891438802083e-09);
ok($diceobj->probability(16499),3.814697265625e-09);
ok($diceobj->probability(16500),3.17891438802083e-09);
ok($diceobj->probability(16501),2.54313151041667e-09);
ok($diceobj->probability(16502),1.9073486328125e-09);
ok($diceobj->probability(16503),1.27156575520833e-09);
ok($diceobj->probability(16504),6.35782877604167e-10);
ok($diceobj->probability(16532),1.69542100694444e-09);
ok($diceobj->probability(16533),3.39084201388889e-09);
ok($diceobj->probability(16534),5.08626302083333e-09);
ok($diceobj->probability(16535),6.78168402777778e-09);
ok($diceobj->probability(16536),8.47710503472222e-09);
ok($diceobj->probability(16537),1.01725260416667e-08);
ok($diceobj->probability(16538),8.47710503472222e-09);
ok($diceobj->probability(16539),6.78168402777778e-09);
ok($diceobj->probability(16540),5.08626302083333e-09);
ok($diceobj->probability(16541),3.39084201388889e-09);
ok($diceobj->probability(16542),1.69542100694444e-09);
ok($diceobj->probability(16642),6.35782877604167e-11);
ok($diceobj->probability(16643),1.27156575520833e-10);
ok($diceobj->probability(16644),1.9073486328125e-10);
ok($diceobj->probability(16645),2.54313151041667e-10);
ok($diceobj->probability(16646),3.17891438802083e-10);
ok($diceobj->probability(16647),3.814697265625e-10);
ok($diceobj->probability(16648),3.17891438802083e-10);
ok($diceobj->probability(16649),2.54313151041667e-10);
ok($diceobj->probability(16650),1.9073486328125e-10);
ok($diceobj->probability(16651),1.27156575520833e-10);
ok($diceobj->probability(16652),6.35782877604167e-11);
ok($diceobj->probability(16706),1.9073486328125e-10);
ok($diceobj->probability(16707),3.814697265625e-10);
ok($diceobj->probability(16708),5.7220458984375e-10);
ok($diceobj->probability(16709),7.62939453125e-10);
ok($diceobj->probability(16710),9.5367431640625e-10);
ok($diceobj->probability(16711),1.1444091796875e-09);
ok($diceobj->probability(16712),9.5367431640625e-10);
ok($diceobj->probability(16713),7.62939453125e-10);
ok($diceobj->probability(16714),5.7220458984375e-10);
ok($diceobj->probability(16715),3.814697265625e-10);
ok($diceobj->probability(16716),1.9073486328125e-10);
ok($diceobj->probability(16742),5.29819064670139e-10);
ok($diceobj->probability(16743),1.05963812934028e-09);
ok($diceobj->probability(16744),1.58945719401042e-09);
ok($diceobj->probability(16745),2.11927625868056e-09);
ok($diceobj->probability(16746),2.64909532335069e-09);
ok($diceobj->probability(16747),3.17891438802083e-09);
ok($diceobj->probability(16748),2.64909532335069e-09);
ok($diceobj->probability(16749),2.11927625868056e-09);
ok($diceobj->probability(16750),1.58945719401042e-09);
ok($diceobj->probability(16751),1.05963812934028e-09);
ok($diceobj->probability(16752),5.29819064670139e-10);
ok($diceobj->probability(16802),6.65452745225694e-10);
ok($diceobj->probability(16803),1.33090549045139e-09);
ok($diceobj->probability(16804),1.99635823567708e-09);
ok($diceobj->probability(16805),2.66181098090278e-09);
ok($diceobj->probability(16806),3.32726372612847e-09);
ok($diceobj->probability(16807),3.99271647135417e-09);
ok($diceobj->probability(16808),3.32726372612847e-09);
ok($diceobj->probability(16809),2.66181098090278e-09);
ok($diceobj->probability(16810),1.99635823567708e-09);
ok($diceobj->probability(16811),1.33090549045139e-09);
ok($diceobj->probability(16812),6.65452745225694e-10);
ok($diceobj->probability(16822),4.45048014322917e-10);
ok($diceobj->probability(16823),8.90096028645833e-10);
ok($diceobj->probability(16824),1.33514404296875e-09);
ok($diceobj->probability(16825),1.78019205729167e-09);
ok($diceobj->probability(16826),2.22524007161458e-09);
ok($diceobj->probability(16827),2.6702880859375e-09);
ok($diceobj->probability(16828),2.22524007161458e-09);
ok($diceobj->probability(16829),1.78019205729167e-09);
ok($diceobj->probability(16830),1.33514404296875e-09);
ok($diceobj->probability(16831),8.90096028645833e-10);
ok($diceobj->probability(16832),4.45048014322917e-10);
ok($diceobj->probability(17026),1.27156575520833e-10);
ok($diceobj->probability(17027),2.54313151041667e-10);
ok($diceobj->probability(17028),3.814697265625e-10);
ok($diceobj->probability(17029),5.08626302083333e-10);
ok($diceobj->probability(17030),6.35782877604167e-10);
ok($diceobj->probability(17031),7.62939453125e-10);
ok($diceobj->probability(17032),6.35782877604167e-10);
ok($diceobj->probability(17033),5.08626302083333e-10);
ok($diceobj->probability(17034),3.814697265625e-10);
ok($diceobj->probability(17035),2.54313151041667e-10);
ok($diceobj->probability(17036),1.27156575520833e-10);
ok($diceobj->probability(17083),3.17891438802083e-10);
ok($diceobj->probability(17084),6.35782877604167e-10);
ok($diceobj->probability(17085),9.5367431640625e-10);
ok($diceobj->probability(17086),1.27156575520833e-09);
ok($diceobj->probability(17087),1.58945719401042e-09);
ok($diceobj->probability(17088),1.9073486328125e-09);
ok($diceobj->probability(17089),1.58945719401042e-09);
ok($diceobj->probability(17090),1.27156575520833e-09);
ok($diceobj->probability(17091),9.5367431640625e-10);
ok($diceobj->probability(17092),6.35782877604167e-10);
ok($diceobj->probability(17093),3.17891438802083e-10);
ok($diceobj->probability(17102),3.17891438802083e-10);
ok($diceobj->probability(17103),6.35782877604167e-10);
ok($diceobj->probability(17104),9.5367431640625e-10);
ok($diceobj->probability(17105),1.27156575520833e-09);
ok($diceobj->probability(17106),1.58945719401042e-09);
ok($diceobj->probability(17107),1.9073486328125e-09);
ok($diceobj->probability(17108),1.58945719401042e-09);
ok($diceobj->probability(17109),1.27156575520833e-09);
ok($diceobj->probability(17110),9.5367431640625e-10);
ok($diceobj->probability(17111),6.35782877604167e-10);
ok($diceobj->probability(17112),3.17891438802083e-10);
ok($diceobj->probability(17282),1.05963812934028e-10);
ok($diceobj->probability(17283),2.11927625868056e-10);
ok($diceobj->probability(17284),3.17891438802083e-10);
ok($diceobj->probability(17285),4.23855251736111e-10);
ok($diceobj->probability(17286),5.29819064670139e-10);
ok($diceobj->probability(17287),6.35782877604167e-10);
ok($diceobj->probability(17288),5.29819064670139e-10);
ok($diceobj->probability(17289),4.23855251736111e-10);
ok($diceobj->probability(17290),3.17891438802083e-10);
ok($diceobj->probability(17291),2.11927625868056e-10);
ok($diceobj->probability(17292),1.05963812934028e-10);
ok($diceobj->probability(17362),1.27156575520833e-10);
ok($diceobj->probability(17363),2.54313151041667e-10);
ok($diceobj->probability(17364),3.814697265625e-10);
ok($diceobj->probability(17365),5.08626302083333e-10);
ok($diceobj->probability(17366),6.35782877604167e-10);
ok($diceobj->probability(17367),7.62939453125e-10);
ok($diceobj->probability(17368),6.35782877604167e-10);
ok($diceobj->probability(17369),5.08626302083333e-10);
ok($diceobj->probability(17370),3.814697265625e-10);
ok($diceobj->probability(17371),2.54313151041667e-10);
ok($diceobj->probability(17372),1.27156575520833e-10);
ok($diceobj->probability(17402),3.39084201388889e-10);
ok($diceobj->probability(17403),6.78168402777778e-10);
ok($diceobj->probability(17404),1.01725260416667e-09);
ok($diceobj->probability(17405),1.35633680555556e-09);
ok($diceobj->probability(17406),1.69542100694444e-09);
ok($diceobj->probability(17407),2.03450520833333e-09);
ok($diceobj->probability(17408),1.69542100694444e-09);
ok($diceobj->probability(17409),1.35633680555556e-09);
ok($diceobj->probability(17410),1.01725260416667e-09);
ok($diceobj->probability(17411),6.78168402777778e-10);
ok($diceobj->probability(17412),3.39084201388889e-10);
ok($diceobj->probability(17634),6.35782877604167e-11);
ok($diceobj->probability(17635),1.27156575520833e-10);
ok($diceobj->probability(17636),1.9073486328125e-10);
ok($diceobj->probability(17637),2.54313151041667e-10);
ok($diceobj->probability(17638),3.17891438802083e-10);
ok($diceobj->probability(17639),3.814697265625e-10);
ok($diceobj->probability(17640),3.17891438802083e-10);
ok($diceobj->probability(17641),2.54313151041667e-10);
ok($diceobj->probability(17642),1.9073486328125e-10);
ok($diceobj->probability(17643),1.27156575520833e-10);
ok($diceobj->probability(17644),6.35782877604167e-11);
ok($diceobj->probability(17672),1.05963812934028e-10);
ok($diceobj->probability(17673),2.11927625868056e-10);
ok($diceobj->probability(17674),3.17891438802083e-10);
ok($diceobj->probability(17675),4.23855251736111e-10);
ok($diceobj->probability(17676),5.29819064670139e-10);
ok($diceobj->probability(17677),6.35782877604167e-10);
ok($diceobj->probability(17678),5.29819064670139e-10);
ok($diceobj->probability(17679),4.23855251736111e-10);
ok($diceobj->probability(17680),3.17891438802083e-10);
ok($diceobj->probability(17681),2.11927625868056e-10);
ok($diceobj->probability(17682),1.05963812934028e-10);
ok($diceobj->probability(17922),2.54313151041667e-11);
ok($diceobj->probability(17923),5.08626302083333e-11);
ok($diceobj->probability(17924),7.62939453125e-11);
ok($diceobj->probability(17925),1.01725260416667e-10);
ok($diceobj->probability(17926),1.27156575520833e-10);
ok($diceobj->probability(17927),1.52587890625e-10);
ok($diceobj->probability(17928),1.27156575520833e-10);
ok($diceobj->probability(17929),1.01725260416667e-10);
ok($diceobj->probability(17930),7.62939453125e-11);
ok($diceobj->probability(17931),5.08626302083333e-11);
ok($diceobj->probability(17932),2.54313151041667e-11);
ok($diceobj->probability(17982),6.35782877604167e-11);
ok($diceobj->probability(17983),1.27156575520833e-10);
ok($diceobj->probability(17984),1.9073486328125e-10);
ok($diceobj->probability(17985),2.54313151041667e-10);
ok($diceobj->probability(17986),3.17891438802083e-10);
ok($diceobj->probability(17987),3.814697265625e-10);
ok($diceobj->probability(17988),3.17891438802083e-10);
ok($diceobj->probability(17989),2.54313151041667e-10);
ok($diceobj->probability(17990),1.9073486328125e-10);
ok($diceobj->probability(17991),1.27156575520833e-10);
ok($diceobj->probability(17992),6.35782877604167e-11);
ok($diceobj->probability(18002),6.35782877604167e-11);
ok($diceobj->probability(18003),1.27156575520833e-10);
ok($diceobj->probability(18004),1.9073486328125e-10);
ok($diceobj->probability(18005),2.54313151041667e-10);
ok($diceobj->probability(18006),3.17891438802083e-10);
ok($diceobj->probability(18007),3.814697265625e-10);
ok($diceobj->probability(18008),3.17891438802083e-10);
ok($diceobj->probability(18009),2.54313151041667e-10);
ok($diceobj->probability(18010),1.9073486328125e-10);
ok($diceobj->probability(18011),1.27156575520833e-10);
ok($diceobj->probability(18012),6.35782877604167e-11);
ok($diceobj->probability(18242),2.11927625868056e-11);
ok($diceobj->probability(18243),4.23855251736111e-11);
ok($diceobj->probability(18244),6.35782877604167e-11);
ok($diceobj->probability(18245),8.47710503472222e-11);
ok($diceobj->probability(18246),1.05963812934028e-10);
ok($diceobj->probability(18247),1.27156575520833e-10);
ok($diceobj->probability(18248),1.05963812934028e-10);
ok($diceobj->probability(18249),8.47710503472222e-11);
ok($diceobj->probability(18250),6.35782877604167e-11);
ok($diceobj->probability(18251),4.23855251736111e-11);
ok($diceobj->probability(18252),2.11927625868056e-11);
ok($diceobj->probability(18562),1.27156575520833e-11);
ok($diceobj->probability(18563),2.54313151041667e-11);
ok($diceobj->probability(18564),3.814697265625e-11);
ok($diceobj->probability(18565),5.08626302083333e-11);
ok($diceobj->probability(18566),6.35782877604167e-11);
ok($diceobj->probability(18567),7.62939453125e-11);
ok($diceobj->probability(18568),6.35782877604167e-11);
ok($diceobj->probability(18569),5.08626302083333e-11);
ok($diceobj->probability(18570),3.814697265625e-11);
ok($diceobj->probability(18571),2.54313151041667e-11);
ok($diceobj->probability(18572),1.27156575520833e-11);
ok($diceobj->probability(18602),2.11927625868056e-11);
ok($diceobj->probability(18603),4.23855251736111e-11);
ok($diceobj->probability(18604),6.35782877604167e-11);
ok($diceobj->probability(18605),8.47710503472222e-11);
ok($diceobj->probability(18606),1.05963812934028e-10);
ok($diceobj->probability(18607),1.27156575520833e-10);
ok($diceobj->probability(18608),1.05963812934028e-10);
ok($diceobj->probability(18609),8.47710503472222e-11);
ok($diceobj->probability(18610),6.35782877604167e-11);
ok($diceobj->probability(18611),4.23855251736111e-11);
ok($diceobj->probability(18612),2.11927625868056e-11);
ok($diceobj->probability(19202),4.23855251736111e-12);
ok($diceobj->probability(19203),8.47710503472222e-12);
ok($diceobj->probability(19204),1.27156575520833e-11);
ok($diceobj->probability(19205),1.69542100694444e-11);
ok($diceobj->probability(19206),2.11927625868056e-11);
ok($diceobj->probability(19207),2.54313151041667e-11);
ok($diceobj->probability(19208),2.11927625868056e-11);
ok($diceobj->probability(19209),1.69542100694444e-11);
ok($diceobj->probability(19210),1.27156575520833e-11);
ok($diceobj->probability(19211),8.47710503472222e-12);
ok($diceobj->probability(19212),4.23855251736111e-12);

ok(1); # If we made it this far, we're ok.

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

