package Graphics::ColorObject;

%PRIMARIES = (
'Adobe RGB (1998)' => [ 2.2, 'D65', 0.6400, 0.3300, 0.297361, 0.2100, 0.7100, 0.627355, 0.1500, 0.0600, 0.075285 ],
'Apple RGB' => [ 1.8, 'D65', 0.6250, 0.3400, 0.244634, 0.2800, 0.5950, 0.672034, 0.1550, 0.0700, 0.083332 ],
'Best RGB' => [ 2.2, 'D50', 0.7347, 0.2653, 0.228457, 0.2150, 0.7750, 0.737352, 0.1300, 0.0350, 0.034191 ],
'Beta RGB' => [ 2.2, 'D50', 0.6888, 0.3112, 0.303273, 0.1986, 0.7551, 0.663786, 0.1265, 0.0352, 0.032941 ],
'Bruce RGB' => [ 2.2, 'D65', 0.6400, 0.3300, 0.240995, 0.2800, 0.6500, 0.683554, 0.1500, 0.0600, 0.075452 ],
'CIE RGB' => [ 2.2, 'E', 0.7350, 0.2650, 0.176204, 0.2740, 0.7170, 0.812985, 0.1670, 0.0090, 0.010811 ],
'ColorMatch RGB' => [ 1.8, 'D50', 0.6300, 0.3400, 0.274884, 0.2950, 0.6050, 0.658132, 0.1500, 0.0750, 0.066985 ],
'Don RGB 4' => [ 2.2, 'D50', 0.6960, 0.3000, 0.278350, 0.2150, 0.7650, 0.687970, 0.1300, 0.0350, 0.033680 ],
'ECI RGB' => [ 1.8, 'D50', 0.6700, 0.3300, 0.320250, 0.2100, 0.7100, 0.602071, 0.1400, 0.0800, 0.077679 ],
'Ekta Space PS5' => [ 2.2, 'D50', 0.6950, 0.3050, 0.260629, 0.2600, 0.7000, 0.734946, 0.1100, 0.0050, 0.004425 ],
'NTSC RGB' => [ 2.2, 'C', 0.6700, 0.3300, 0.298839, 0.2100, 0.7100, 0.586811, 0.1400, 0.0800, 0.114350 ],
'PAL/SECAM RGB' => [ 2.2, 'D65', 0.6400, 0.3300, 0.222021, 0.2900, 0.6000, 0.706645, 0.1500, 0.0600, 0.071334 ],
'ProPhoto RGB' => [ 1.8, 'D50', 0.7347, 0.2653, 0.288040, 0.1596, 0.8404, 0.711874, 0.0366, 0.0001, 0.000086 ],
'SMPTE-C RGB' => [ 2.2, 'D65', 0.6300, 0.3400, 0.212395, 0.3100, 0.5950, 0.701049, 0.1550, 0.0700, 0.086556 ],
'sRGB' => [ 2.2, 'D65', 0.6400, 0.3300, 0.212656, 0.3000, 0.6000, 0.715158, 0.1500, 0.0600, 0.072186 ],
'Wide Gamut RGB' => [ 2.2, 'D50', 0.7350, 0.2650, 0.258187, 0.1150, 0.8260, 0.724938, 0.1570, 0.0180, 0.016875 ],
);

use PDL;
use PDL::Slatec;

foreach my $space (sort keys %PRIMARIES)
{
	my $d = $PRIMARIES{$space};
	my $r_xyy = [ @{$d}[2..4] ];
	my $g_xyy = [ @{$d}[5..7] ];
	my $b_xyy = [ @{$d}[8..10] ];
	
	my $r_xyz = pdl &xyY_to_XYZ($r_xyy);
	my $g_xyz = pdl &xyY_to_XYZ($g_xyy);
	my $b_xyz = pdl &xyY_to_XYZ($b_xyy);

	my $white = $r_xyz + $g_xyz + $b_xyz;

	my $m1 = cat($r_xyz, $g_xyz, $b_xyz);

	my $s = inner($white, transpose (matinv($m1)));

	print "s = ", $s, "\n";

	my $m = $m1 * transpose($s);
	$m = transpose($m);
	my $mstar = matinv($m);

	print $space, "\n";
	print 'm     => ';
	&_print_m33($m);
	print "\n", 'mstar => ';
	&_print_m33($mstar);
	print "\n\n";

}

sub _print_m33
{
	my ($m) = @_;
	my $str = '';
	$str .= '[ ';
	foreach my $i (0..2)
	{
		$str .= '[ ';
		foreach my $j (0..2)
		{
			$str .= sprintf('% 18.16f', $m->at($i, $j)); # $m->at($i, $j); # ;
			$str .= ', ';
		}
		$str =~ s!, $!!;
		$str .= ' ], ';
	}
	$str =~ s!, $!!;
	$str .= ' ], ';
	print $str;
}
