# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::GB;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230112200226;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1(?:
                3(?:
                  [0-58]\\d\\d|
                  73[0235]
                )|
                4(?:
                  [0-5]\\d\\d|
                  69[7-9]|
                  70[0-579]
                )|
                (?:
                  (?:
                    5[0-26-9]|
                    [78][0-49]
                  )\\d|
                  6(?:
                    [0-4]\\d|
                    50
                  )
                )\\d
              )|
              2(?:
                (?:
                  0[024-9]|
                  2[3-9]|
                  3[3-79]|
                  4[1-689]|
                  [58][02-9]|
                  6[0-47-9]|
                  7[013-9]|
                  9\\d
                )\\d\\d|
                1(?:
                  [0-7]\\d\\d|
                  8(?:
                    [02]\\d|
                    1[0-246-9]
                  )
                )
              )|
              (?:
                3(?:
                  0\\d|
                  1[0-8]|
                  [25][02-9]|
                  3[02-579]|
                  [468][0-46-9]|
                  7[1-35-79]|
                  9[2-578]
                )|
                4(?:
                  0[03-9]|
                  [137]\\d|
                  [28][02-57-9]|
                  4[02-69]|
                  5[0-8]|
                  [69][0-79]
                )|
                5(?:
                  0[1-35-9]|
                  [16]\\d|
                  2[024-9]|
                  3[015689]|
                  4[02-9]|
                  5[03-9]|
                  7[0-35-9]|
                  8[0-468]|
                  9[0-57-9]
                )|
                6(?:
                  0[034689]|
                  1\\d|
                  2[0-35689]|
                  [38][013-9]|
                  4[1-467]|
                  5[0-69]|
                  6[13-9]|
                  7[0-8]|
                  9[0-24578]
                )|
                7(?:
                  0[0246-9]|
                  2\\d|
                  3[0236-8]|
                  4[03-9]|
                  5[0-46-9]|
                  6[013-9]|
                  7[0-35-9]|
                  8[024-9]|
                  9[02-9]
                )|
                8(?:
                  0[35-9]|
                  2[1-57-9]|
                  3[02-578]|
                  4[0-578]|
                  5[124-9]|
                  6[2-69]|
                  7\\d|
                  8[02-9]|
                  9[02569]
                )|
                9(?:
                  0[02-589]|
                  [18]\\d|
                  2[02-689]|
                  3[1-57-9]|
                  4[2-9]|
                  5[0-579]|
                  6[2-47-9]|
                  7[0-24578]|
                  9[2-57]
                )
              )\\d\\d
            )|
            2(?:
              0[013478]|
              3[0189]|
              4[017]|
              8[0-46-9]|
              9[0-2]
            )\\d{3}
          )\\d{4}|
          1(?:
            2(?:
              0(?:
                46[1-4]|
                87[2-9]
              )|
              545[1-79]|
              76(?:
                2\\d|
                3[1-8]|
                6[1-6]
              )|
              9(?:
                7(?:
                  2[0-4]|
                  3[2-5]
                )|
                8(?:
                  2[2-8]|
                  7[0-47-9]|
                  8[3-5]
                )
              )
            )|
            3(?:
              6(?:
                38[2-5]|
                47[23]
              )|
              8(?:
                47[04-9]|
                64[0157-9]
              )
            )|
            4(?:
              044[1-7]|
              20(?:
                2[23]|
                8\\d
              )|
              6(?:
                0(?:
                  30|
                  5[2-57]|
                  6[1-8]|
                  7[2-8]
                )|
                140
              )|
              8(?:
                052|
                87[1-3]
              )
            )|
            5(?:
              2(?:
                4(?:
                  3[2-79]|
                  6\\d
                )|
                76\\d
              )|
              6(?:
                26[06-9]|
                686
              )
            )|
            6(?:
              06(?:
                4\\d|
                7[4-79]
              )|
              295[5-7]|
              35[34]\\d|
              47(?:
                24|
                61
              )|
              59(?:
                5[08]|
                6[67]|
                74
              )|
              9(?:
                55[0-4]|
                77[23]
              )
            )|
            7(?:
              26(?:
                6[13-9]|
                7[0-7]
              )|
              (?:
                442|
                688
              )\\d|
              50(?:
                2[0-3]|
                [3-68]2|
                76
              )
            )|
            8(?:
              27[56]\\d|
              37(?:
                5[2-5]|
                8[239]
              )|
              843[2-58]
            )|
            9(?:
              0(?:
                0(?:
                  6[1-8]|
                  85
                )|
                52\\d
              )|
              3583|
              4(?:
                66[1-8]|
                9(?:
                  2[01]|
                  81
                )
              )|
              63(?:
                23|
                3[1-4]
              )|
              9561
            )
          )\\d{3}
        ',
                'geographic' => '
          (?:
            1(?:
              1(?:
                3(?:
                  [0-58]\\d\\d|
                  73[0235]
                )|
                4(?:
                  [0-5]\\d\\d|
                  69[7-9]|
                  70[0-579]
                )|
                (?:
                  (?:
                    5[0-26-9]|
                    [78][0-49]
                  )\\d|
                  6(?:
                    [0-4]\\d|
                    50
                  )
                )\\d
              )|
              2(?:
                (?:
                  0[024-9]|
                  2[3-9]|
                  3[3-79]|
                  4[1-689]|
                  [58][02-9]|
                  6[0-47-9]|
                  7[013-9]|
                  9\\d
                )\\d\\d|
                1(?:
                  [0-7]\\d\\d|
                  8(?:
                    [02]\\d|
                    1[0-246-9]
                  )
                )
              )|
              (?:
                3(?:
                  0\\d|
                  1[0-8]|
                  [25][02-9]|
                  3[02-579]|
                  [468][0-46-9]|
                  7[1-35-79]|
                  9[2-578]
                )|
                4(?:
                  0[03-9]|
                  [137]\\d|
                  [28][02-57-9]|
                  4[02-69]|
                  5[0-8]|
                  [69][0-79]
                )|
                5(?:
                  0[1-35-9]|
                  [16]\\d|
                  2[024-9]|
                  3[015689]|
                  4[02-9]|
                  5[03-9]|
                  7[0-35-9]|
                  8[0-468]|
                  9[0-57-9]
                )|
                6(?:
                  0[034689]|
                  1\\d|
                  2[0-35689]|
                  [38][013-9]|
                  4[1-467]|
                  5[0-69]|
                  6[13-9]|
                  7[0-8]|
                  9[0-24578]
                )|
                7(?:
                  0[0246-9]|
                  2\\d|
                  3[0236-8]|
                  4[03-9]|
                  5[0-46-9]|
                  6[013-9]|
                  7[0-35-9]|
                  8[024-9]|
                  9[02-9]
                )|
                8(?:
                  0[35-9]|
                  2[1-57-9]|
                  3[02-578]|
                  4[0-578]|
                  5[124-9]|
                  6[2-69]|
                  7\\d|
                  8[02-9]|
                  9[02569]
                )|
                9(?:
                  0[02-589]|
                  [18]\\d|
                  2[02-689]|
                  3[1-57-9]|
                  4[2-9]|
                  5[0-579]|
                  6[2-47-9]|
                  7[0-24578]|
                  9[2-57]
                )
              )\\d\\d
            )|
            2(?:
              0[013478]|
              3[0189]|
              4[017]|
              8[0-46-9]|
              9[0-2]
            )\\d{3}
          )\\d{4}|
          1(?:
            2(?:
              0(?:
                46[1-4]|
                87[2-9]
              )|
              545[1-79]|
              76(?:
                2\\d|
                3[1-8]|
                6[1-6]
              )|
              9(?:
                7(?:
                  2[0-4]|
                  3[2-5]
                )|
                8(?:
                  2[2-8]|
                  7[0-47-9]|
                  8[3-5]
                )
              )
            )|
            3(?:
              6(?:
                38[2-5]|
                47[23]
              )|
              8(?:
                47[04-9]|
                64[0157-9]
              )
            )|
            4(?:
              044[1-7]|
              20(?:
                2[23]|
                8\\d
              )|
              6(?:
                0(?:
                  30|
                  5[2-57]|
                  6[1-8]|
                  7[2-8]
                )|
                140
              )|
              8(?:
                052|
                87[1-3]
              )
            )|
            5(?:
              2(?:
                4(?:
                  3[2-79]|
                  6\\d
                )|
                76\\d
              )|
              6(?:
                26[06-9]|
                686
              )
            )|
            6(?:
              06(?:
                4\\d|
                7[4-79]
              )|
              295[5-7]|
              35[34]\\d|
              47(?:
                24|
                61
              )|
              59(?:
                5[08]|
                6[67]|
                74
              )|
              9(?:
                55[0-4]|
                77[23]
              )
            )|
            7(?:
              26(?:
                6[13-9]|
                7[0-7]
              )|
              (?:
                442|
                688
              )\\d|
              50(?:
                2[0-3]|
                [3-68]2|
                76
              )
            )|
            8(?:
              27[56]\\d|
              37(?:
                5[2-5]|
                8[239]
              )|
              843[2-58]
            )|
            9(?:
              0(?:
                0(?:
                  6[1-8]|
                  85
                )|
                52\\d
              )|
              3583|
              4(?:
                66[1-8]|
                9(?:
                  2[01]|
                  81
                )
              )|
              63(?:
                23|
                3[1-4]
              )|
              9561
            )
          )\\d{3}
        ',
                'mobile' => '
          7(?:
            457[0-57-9]|
            700[01]|
            911[028]
          )\\d{5}|
          7(?:
            [1-3]\\d\\d|
            4(?:
              [0-46-9]\\d|
              5[0-689]
            )|
            5(?:
              0[0-8]|
              [13-9]\\d|
              2[0-35-9]
            )|
            7(?:
              0[1-9]|
              [1-7]\\d|
              8[02-9]|
              9[0-689]
            )|
            8(?:
              [014-9]\\d|
              [23][0-8]
            )|
            9(?:
              [024-9]\\d|
              1[02-9]|
              3[0-689]
            )
          )\\d{6}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-28]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            8[14]|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          (?:
            8(?:
              4[2-5]|
              7[0-3]
            )|
            9(?:
              [01]\\d|
              8[2-49]
            )
          )\\d{7}|
          845464\\d
        )|(
          (?:
            3[0347]|
            55
          )\\d{8}
        )',
                'toll_free' => '
          80[08]\\d{7}|
          800\\d{6}|
          8001111
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"4412291", "Barrow\-in\-Furness\/Millom",
"441506", "Bathgate",
"441622", "Maidstone",
"441670", "Morpeth",
"441435", "Heathfield",
"441464", "Insch",
"441838", "Dalmally",
"441257", "Coppull",
"441923", "Watford",
"4418903", "Coldstream",
"441878", "Lochboisdale",
"441947", "Whitby",
"441256", "Basingstoke",
"441630", "Market\ Drayton",
"441946", "Whitehaven",
"441475", "Greenock",
"4414307", "Market\ Weighton",
"441546", "Lochgilphead",
"441324", "Falkirk",
"441547", "Knighton",
"4418471", "Thurso\/Tongue",
"441286", "Caernarfon",
"441287", "Guisborough",
"44292", "Cardiff",
"4414306", "Market\ Weighton",
"441454", "Chipping\ Sodbury",
"442820", "Ballycastle",
"441995", "Garstang",
"441267", "Carmarthen",
"4415396", "Sedbergh",
"441833", "Barnard\ Castle",
"4414349", "Bellingham",
"441604", "Northampton",
"441752", "Plymouth",
"441342", "East\ Grinstead",
"441873", "Abergavenny",
"441928", "Runcorn",
"441528", "Laggan",
"441782", "Stoke\-on\-Trent",
"441919", "Durham",
"4414342", "Bellingham",
"441371", "Great\ Dunmow",
"442841", "Rostrevor",
"441644", "New\ Galloway",
"441290", "Cumnock",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"44287", "Northern\ Ireland",
"441239", "Cardigan",
"441484", "Huddersfield",
"441302", "Doncaster",
"44283", "Northern\ Ireland",
"441279", "Bishops\ Stortford",
"4415078", "Alford\ \(Lincs\)",
"441852", "Kilmelford",
"441733", "Peterborough",
"441773", "Ripley",
"441597", "Llandrindod\ Wells",
"441609", "Northallerton",
"4414378", "Haverfordwest",
"4413391", "Aboyne\/Ballater",
"442868", "Kesh",
"441914", "Tyneside",
"441489", "Bishops\ Waltham",
"441234", "Bedford",
"442883", "Northern\ Ireland",
"441560", "Moscow",
"4418904", "Coldstream",
"441882", "Kinloch\ Rannoch",
"441997", "Strathpeffer",
"441274", "Bradford",
"442891", "Bangor\ \(Co\.\ Down\)",
"441738", "Perth",
"441905", "Worcester",
"441778", "Bourne",
"441469", "Killingholme",
"441862", "Tain",
"441285", "Cirencester",
"441580", "Cranbrook",
"441694", "Church\ Stretton",
"441950", "Sandwick",
"441545", "Llanarth",
"441476", "Grantham",
"441945", "Wisbech",
"441550", "Llandovery",
"441329", "Fareham",
"441255", "Clacton\-on\-Sea",
"441477", "Holmes\ Chapel",
"441980", "Amesbury",
"441436", "Helensburgh",
"441392", "Exeter",
"442888", "Northern\ Ireland",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441200", "Clitheroe",
"441505", "Johnstone",
"441634", "Medway",
"441665", "Alnwick",
"441249", "Chippenham",
"441803", "Torquay",
"441959", "Westerham",
"441460", "Chard",
"441674", "Montrose",
"441725", "Rockbourne",
"4418475", "Thurso",
"442871", "Londonderry",
"441341", "Barmouth",
"441798", "Pulborough",
"441751", "Pickering",
"441843", "Thanet",
"441209", "Redruth",
"441827", "Tamworth",
"441372", "Esher",
"442842", "Kircubbin",
"4414346", "Hexham",
"441332", "Derby",
"44280", "Northern\ Ireland",
"441301", "Arrochar",
"441989", "Ross\-on\-Wye",
"441496", "Port\ Ellen",
"441497", "Hay\-on\-Wye",
"4412295", "Barrow\-in\-Furness",
"441320", "Fort\ Augustus",
"441559", "Llandysul",
"4414347", "Hexham",
"441621", "Maldon",
"441808", "Tomatin",
"441405", "Goole",
"4414309", "Market\ Weighton",
"441600", "Monmouth",
"441761", "Temple\ Cloud",
"441655", "Maybole",
"441969", "Leyburn",
"441536", "Kettering",
"441577", "Kinross",
"441793", "Swindon",
"442824", "Northern\ Ireland",
"441450", "Hawick",
"441576", "Lockerbie",
"441445", "Gairloch",
"441977", "Pontefract",
"441848", "Thornhill",
"441685", "Merthyr\ Tydfil",
"441937", "Wetherby",
"441480", "Huntingdon",
"441569", "Stonehaven",
"441294", "Ardrossan",
"4414302", "North\ Cave",
"442892", "Lisburn",
"4420", "London",
"441388", "Bishop\ Auckland",
"441935", "Yeovil",
"441708", "Romford",
"442829", "Kilrea",
"441687", "Mallaig",
"441446", "Barry",
"441575", "Kirriemuir",
"441270", "Crewe",
"4413395", "Aboyne",
"441363", "Crediton",
"441299", "Bewdley",
"441564", "Lapworth",
"441535", "Keighley",
"441656", "Bridgend",
"441748", "Richmond",
"441910", "Tyneside\/Durham\/Sunderland",
"4418518", "Stornoway",
"441358", "Ellon",
"441406", "Holbeach",
"441407", "Holyhead",
"441954", "Madingley",
"441690", "Betws\-y\-Coed",
"441244", "Chester",
"441639", "Neath",
"441584", "Ludlow",
"441383", "Dunfermline",
"441495", "Pontypool",
"441825", "Uckfield",
"442311", "Southampton",
"441428", "Haslemere",
"44238", "Southampton",
"4414238", "Harrogate",
"4416868", "Newtown",
"4419758", "Strathdon",
"441204", "Bolton",
"4414300", "North\ Cave\/Market\ Weighton",
"4417687", "Keswick",
"441368", "Dunbar",
"4419648", "Hornsea",
"441726", "St\ Austell",
"441727", "St\ Albans",
"441984", "Watchet\ \(Williton\)",
"441743", "Shrewsbury",
"441666", "Malmesbury",
"441353", "Ely",
"441554", "Llanelli",
"441667", "Nairn",
"441340", "Craigellachie\ \(Aberlour\)",
"442870", "Coleraine",
"44118", "Reading",
"442830", "Newry",
"441750", "Selkirk",
"441493", "Great\ Yarmouth",
"442899", "Northern\ Ireland",
"441938", "Welshpool",
"441978", "Wrexham",
"441823", "Taunton",
"441461", "Gretna",
"442822", "Northern\ Ireland",
"441300", "Cerne\ Abbas",
"441578", "Lauder",
"441538", "Ipstones",
"441292", "Ayr",
"441745", "Rhyl",
"441806", "Shetland",
"441780", "Stamford",
"441355", "East\ Kilbride",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441807", "Ballindalloch",
"44115", "Nottingham",
"44141", "Glasgow",
"4412298", "Barrow\-in\-Furness",
"4414303", "North\ Cave",
"441451", "Stow\-on\-the\-Wold",
"441895", "Uxbridge",
"441672", "Marlborough",
"441933", "Wellingborough",
"441620", "North\ Berwick",
"441425", "Ringwood",
"441828", "Coupar\ Angus",
"441760", "Swaffham",
"4418478", "Thurso",
"441573", "Kelso",
"441797", "Rye",
"441796", "Pitlochry",
"442844", "Downpatrick",
"4418906", "Ayton",
"44116", "Leicester",
"441334", "St\ Andrews",
"441641", "Strathy",
"441481", "Guernsey",
"4418907", "Ayton",
"441952", "Telford",
"441668", "Bamburgh",
"441242", "Cheltenham",
"441403", "Horsham",
"4413885", "Stanhope\ \(Eastgate\)",
"441728", "Saxmundham",
"441582", "Luton",
"4415394", "Hawkshead",
"441653", "Malton",
"4416865", "Newtown",
"4414235", "Harrogate",
"441367", "Faringdon",
"4419755", "Alford\ \(Aberdeen\)",
"441366", "Downham\ Market",
"441795", "Sittingbourne",
"4419645", "Hornsea",
"441443", "Pontypridd",
"441427", "Gainsborough",
"442849", "Northern\ Ireland",
"441379", "Diss",
"441202", "Bournemouth",
"441911", "Tyneside\/Durham\/Sunderland",
"441683", "Moffat",
"441896", "Galashiels",
"441271", "Barnstaple",
"441982", "Builth\ Wells",
"4418515", "Stornoway",
"441356", "Brechin",
"441408", "Golspie",
"441663", "New\ Mills",
"441805", "Torrington",
"441357", "Strathaven",
"442894", "Antrim",
"441746", "Bridgnorth",
"442310", "Portsmouth",
"441747", "Shaftesbury",
"441723", "Scarborough",
"4413398", "Aboyne",
"441962", "Winchester",
"441691", "Oswestry",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441845", "Thirsk",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441707", "Welwyn\ Garden\ City",
"4414304", "North\ Cave",
"441562", "Kidderminster",
"441880", "Tarbert",
"441706", "Rochdale",
"441387", "Dumfries",
"441386", "Evesham",
"441224", "Aberdeen",
"441452", "Gloucester",
"441903", "Worthing",
"441671", "Newton\ Stewart",
"441859", "Harris",
"441631", "Oban",
"4415075", "Spilsby\ \(Horncastle\)",
"441283", "Burton\-on\-Trent",
"441754", "Skegness",
"4418909", "Ayton",
"441526", "Martin",
"441527", "Redditch",
"441344", "Bracknell",
"441543", "Cannock",
"441784", "Staines",
"441943", "Guiseley",
"4417684", "Pooley\ Bridge",
"441253", "Blackpool",
"441926", "Warwick",
"4418902", "Coldstream",
"441268", "Basildon",
"441642", "Middlesbrough",
"441889", "Rugeley",
"441482", "Kingston\-upon\-Hull",
"441304", "Dover",
"441503", "Looe",
"441764", "Crieff",
"441908", "Milton\ Keynes",
"441775", "Spalding",
"441624", "Isle\ of\ Man",
"441869", "Bicester",
"441288", "Bude",
"442821", "Martinstown",
"441462", "Hitchin",
"441548", "Kingsbridge",
"4414343", "Haltwhistle",
"441876", "Lochmaddy",
"441322", "Dartford",
"441258", "Blandford",
"441877", "Callander",
"441291", "Chepstow",
"441948", "Whitchurch",
"441837", "Okehampton",
"4416973", "Wigton",
"441330", "Banchory",
"442885", "Ballygawley",
"441263", "Cromer",
"442840", "Banbridge",
"441508", "Brooke",
"441769", "South\ Molton",
"442887", "Dungannon",
"441993", "Witney",
"442886", "Cookstown",
"4417683", "Appleby",
"441629", "Matlock",
"441835", "St\ Boswells",
"441438", "Stevenage",
"441864", "Abington\ \(Crawford\)",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"4415242", "Hornby",
"441692", "North\ Walsham",
"441875", "Tranent",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441561", "Laurencekirk",
"4414231", "Harrogate\/Boroughbridge",
"4416861", "Newtown\/Llanidloes",
"4419641", "Hornsea\/Patrington",
"441394", "Felixstowe",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441777", "Retford",
"441593", "Lybster",
"4418900", "Coldstream\/Ayton",
"441776", "Stranraer",
"441736", "Penzance",
"441737", "Redhill",
"441854", "Ullapool",
"441581", "New\ Luce",
"4416974", "Raughton\ Head",
"441951", "Colonsay",
"441241", "Arbroath",
"441759", "Pocklington",
"441433", "Hathersage",
"442890", "Belfast",
"441925", "Warrington",
"441349", "Dingwall",
"442879", "Magherafelt",
"441473", "Ipswich",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441789", "Stratford\-upon\-Avon",
"441525", "Leighton\ Buzzard",
"442867", "Lisnaskea",
"441912", "Tyneside",
"442866", "Enniskillen",
"4414344", "Bellingham",
"441598", "Lynton",
"44247", "Coventry",
"4418511", "Great\ Bernera\/Stornoway",
"441884", "Tiverton",
"44151", "Liverpool",
"441981", "Wormbridge",
"441309", "Forres",
"441970", "Aberystwyth",
"441763", "Royston",
"441647", "Moretonhampstead",
"441623", "Mansfield",
"441646", "Milford\ Haven",
"441487", "Warboys",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441758", "Pwllheli",
"442838", "Portadown",
"441348", "Fishguard",
"441922", "Walsall",
"4414236", "Harrogate",
"4416866", "Newtown",
"441522", "Lincoln",
"441788", "Rugby",
"4419756", "Strathdon",
"441606", "Northwich",
"441915", "Sunderland",
"4419646", "Patrington",
"4414379", "Haverfordwest",
"441235", "Abingdon",
"4419757", "Strathdon",
"441530", "Coalville",
"441264", "Andover",
"4414237", "Harrogate",
"4416867", "Llanidloes",
"441599", "Kyle",
"4419647", "Patrington",
"441457", "Glossop",
"441308", "Bridport",
"441456", "Glenurquhart",
"441275", "Clevedon",
"441570", "Lampeter",
"441768", "Penrith",
"441904", "York",
"441628", "Maidenhead",
"441832", "Clopton",
"441490", "Corwen",
"441753", "Slough",
"441284", "Bury\ St\ Edmunds",
"441439", "Helmsley",
"441326", "Falmouth",
"441479", "Grantown\-on\-Spey",
"441327", "Daventry",
"441872", "Truro",
"441544", "Kington",
"441343", "Elgin",
"441695", "Skelmersdale",
"441254", "Blackburn",
"441944", "West\ Heslerton",
"4418517", "Stornoway",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441466", "Huntly",
"441841", "Newquay\ \(Padstow\)",
"441467", "Inverurie",
"4418516", "Great\ Bernera",
"441303", "Folkestone",
"441909", "Worksop",
"441381", "Fortrose",
"441732", "Sevenoaks",
"441772", "Preston",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441289", "Berwick\-upon\-Tweed",
"441720", "Isles\ of\ Scilly",
"441465", "Girvan",
"441549", "Lairg",
"441474", "Gravesend",
"441949", "Whatton",
"441697", "Brampton",
"441325", "Darlington",
"441259", "Alloa",
"442882", "Omagh",
"441398", "Dulverton",
"441883", "Caterham",
"44131", "Edinburgh",
"441509", "Loughborough",
"441276", "Camberley",
"441455", "Hinckley",
"441858", "Market\ Harborough",
"4415079", "Alford\ \(Lincs\)",
"441277", "Brentwood",
"441237", "Bideford",
"441236", "Coatbridge",
"441650", "Cemmaes\ Road",
"441994", "St\ Clears",
"441916", "Tyneside",
"441917", "Sunderland",
"441863", "Ardgay",
"4418905", "Ayton",
"44239", "Portsmouth",
"441400", "Honington",
"441361", "Duns",
"4414348", "Hexham",
"441594", "Lydney",
"441269", "Ammanford",
"441888", "Turriff",
"441485", "Hunstanton",
"4415072", "Spilsby\ \(Horncastle\)",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"44286", "Northern\ Ireland",
"441440", "Haverhill",
"441409", "Holsworthy",
"4418519", "Great\ Bernera",
"441934", "Weston\-super\-Mare",
"441296", "Aylesbury",
"441659", "Sanquhar",
"441871", "Castlebay",
"441297", "Axminster",
"441974", "Llanon",
"441373", "Frome",
"442826", "Northern\ Ireland",
"441689", "Orpington",
"441842", "Thetford",
"442827", "Ballymoney",
"441449", "Stowmarket",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441260", "Congleton",
"441565", "Knutsford",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441534", "Jersey",
"4418512", "Stornoway",
"4413873", "Langholm",
"441245", "Chelmsford",
"441669", "Rothbury",
"441540", "Kingussie",
"441955", "Wick",
"4414377", "Haverfordwest",
"441280", "Buckingham",
"441729", "Settle",
"441494", "High\ Wycombe",
"4414376", "Haverfordwest",
"4419649", "Hornsea",
"441792", "Swansea",
"4412294", "Barrow\-in\-Furness",
"4419759", "Alford\ \(Aberdeen\)",
"441824", "Ruthin",
"441900", "Workington",
"4416869", "Newtown",
"4414239", "Boroughbridge",
"4414232", "Harrogate",
"442848", "Northern\ Ireland",
"4416862", "Llanidloes",
"4413393", "Aboyne",
"441205", "Boston",
"4419752", "Alford\ \(Aberdeen\)",
"4419642", "Hornsea",
"441676", "Meriden",
"441985", "Warminster",
"4413882", "Stanhope\ \(Eastgate\)",
"441677", "Bedale",
"441637", "Newquay",
"441250", "Blairgowrie",
"441555", "Lanark",
"441636", "Newark\-on\-Trent",
"4418474", "Thurso",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441635", "Newbury",
"441556", "Castle\ Douglas",
"441557", "Kirkcudbright",
"441664", "Melton\ Mowbray",
"441499", "Inveraray",
"442893", "Ballyclare",
"441986", "Bungay",
"441724", "Scunthorpe",
"441675", "Coleshill",
"441892", "Tunbridge\ Wells",
"441987", "Ebbsfleet",
"441206", "Colchester",
"441422", "Halifax",
"441829", "Tarporley",
"441207", "Consett",
"441362", "Dereham",
"4415077", "Louth",
"4418510", "Great\ Bernera\/Stornoway",
"4419467", "Gosforth",
"441586", "Campbeltown",
"4415076", "Louth",
"441957", "Mid\ Yell",
"441223", "Cambridge",
"441246", "Chesterfield",
"441771", "Maud",
"44281", "Northern\ Ireland",
"441404", "Honiton",
"441382", "Dundee",
"4413394", "Ballater",
"442898", "Belfast",
"4418473", "Thurso",
"441702", "Southend\-on\-Sea",
"441567", "Killin",
"441654", "Machynlleth",
"441566", "Launceston",
"441939", "Wem",
"442825", "Ballymena",
"441444", "Haywards\ Heath",
"441579", "Liskeard",
"441684", "Malvern",
"441539", "Kendal",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441590", "Lymington",
"4418901", "Coldstream\/Ayton",
"441295", "Banbury",
"441967", "Strontian",
"4419640", "Hornsea\/Patrington",
"4412293", "Millom",
"4414308", "Market\ Weighton",
"442881", "Newtownstewart",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"4414230", "Harrogate\/Boroughbridge",
"4416860", "Newtown\/Llanidloes",
"441228", "Carlisle",
"441352", "Mold",
"441870", "Isle\ of\ Benbecula",
"4418513", "Stornoway",
"441638", "Newmarket",
"441899", "Biggar",
"441678", "Bala",
"441830", "Kirkwhelpington",
"441492", "Colwyn\ Bay",
"441337", "Ladybank",
"441794", "Romsey",
"442846", "Northern\ Ireland",
"441822", "Tavistock",
"441377", "Driffield",
"442847", "Northern\ Ireland",
"441429", "Hartlepool",
"442823", "Northern\ Ireland",
"441376", "Braintree",
"441293", "Crawley",
"441369", "Dunoon",
"441261", "Banff",
"441633", "Newport",
"44241", "Coventry",
"441920", "Ware",
"442895", "Belfast",
"441673", "Market\ Rasen",
"441389", "Dumbarton",
"4413392", "Aboyne",
"441932", "Weybridge",
"4416863", "Llanidloes",
"4414233", "Boroughbridge",
"4419753", "Strathdon",
"441709", "Rotherham",
"442828", "Larne",
"4412290", "Barrow\-in\-Furness\/Millom",
"441972", "Glenborrodale",
"4419643", "Patrington",
"44121", "Birmingham",
"441844", "Thame",
"441572", "Oakham",
"441298", "Buxton",
"4413399", "Ballater",
"441501", "Harthill",
"441749", "Shepton\ Mallet",
"441520", "Lochcarron",
"441359", "Pakenham",
"441225", "Bath",
"4418470", "Thurso\/Tongue",
"441243", "Chichester",
"441809", "Tomdoun",
"441953", "Wymondham",
"441227", "Canterbury",
"4414305", "North\ Cave",
"441226", "Barnsley",
"441384", "Dudley",
"441583", "Carradale",
"441704", "Southport",
"441968", "Penicuik",
"441652", "Brigg",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441431", "Helmsdale",
"441442", "Hemel\ Hempstead",
"4418514", "Great\ Bernera",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441568", "Leominster",
"442897", "Saintfield",
"442896", "Belfast",
"441744", "St\ Helens",
"441983", "Isle\ of\ Wight",
"441553", "Kings\ Lynn",
"441354", "Chatteris",
"4412292", "Barrow\-in\-Furness",
"441248", "Bangor\ \(Gwynedd\)",
"441722", "Salisbury",
"441588", "Bishops\ Castle",
"4413390", "Aboyne\/Ballater",
"441963", "Wincanton",
"441770", "Isle\ of\ Arran",
"441730", "Petersfield",
"441424", "Hastings",
"4418479", "Tongue",
"441799", "Saffron\ Walden",
"441375", "Grays\ Thurrock",
"44117", "Bristol",
"441208", "Bodmin",
"4415395", "Grange\-over\-Sands",
"4418472", "Thurso",
"442845", "Northern\ Ireland",
"441563", "Kilmarnock",
"441364", "Ashburton",
"442880", "Carrickmore",
"441335", "Ashbourne",
"44113", "Leeds",
"4419644", "Patrington",
"441988", "Wigtown",
"441591", "Llanwrtyd\ Wells",
"4412299", "Millom",
"441558", "Llandeilo",
"4419754", "Alford\ \(Aberdeen\)",
"4414234", "Boroughbridge",
"4416864", "Llanidloes",
"441453", "Dursley",
"441790", "Spilsby",
"4413397", "Ballater",
"441902", "Wolverhampton",
"441779", "Peterhead",
"4413396", "Ballater",
"441834", "Narberth",
"441971", "Scourie",
"441603", "Norwich",
"441865", "Oxford",
"441282", "Burnley",
"441931", "Shap",
"441874", "Brecon",
"441542", "Keith",
"441328", "Fakenham",
"441252", "Aldershot",
"441942", "Wigan",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441531", "Ledbury",
"441571", "Lochinver",
"441395", "Budleigh\ Salterton",
"441643", "Minehead",
"441483", "Guildford",
"441626", "Newton\ Abbot",
"442889", "Fivemiletown",
"441502", "Lowestoft",
"441767", "Sandy",
"441766", "Porthmadog",
"441307", "Forfar",
"441855", "Ballachulish",
"441306", "Dorking",
"441458", "Glastonbury",
"441491", "Henley\-on\-Thames",
"441608", "Chipping\ Norton",
"441821", "Kinrossie",
"441463", "Inverness",
"441787", "Sudbury",
"441924", "Wakefield",
"441786", "Stirling",
"441346", "Fraserburgh",
"442877", "Limavady",
"441524", "Lancaster",
"4415074", "Alford\ \(Lincs\)",
"441347", "Easingwold",
"441323", "Eastbourne",
"441756", "Skipton",
"442837", "Armagh",
"441757", "Selby",
"441488", "Hungerford",
"441262", "Bridlington",
"441885", "Pencombe",
"441840", "Camelford",
"441721", "Peebles",
"4412296", "Barrow\-in\-Furness",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441700", "Rothesay",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441992", "Lea\ Valley",
"441661", "Prudhoe",
"441887", "Aberfeldy",
"4412297", "Millom",
"441380", "Devizes",
"4414345", "Haltwhistle",
"441929", "Wareham",
"44114", "Sheffield",
"441785", "Stafford",
"441350", "Dunkeld",
"4418476", "Tongue",
"441529", "Sleaford",
"441740", "Sedgefield",
"4418908", "Coldstream",
"441918", "Tyneside",
"441592", "Kirkcaldy",
"4414301", "North\ Cave\/Market\ Weighton",
"4418477", "Tongue",
"441857", "Sanday",
"441278", "Bridgwater",
"441305", "Dorchester",
"441856", "Orkney",
"441765", "Ripon",
"44291", "Cardiff",
"441420", "Alton",
"441397", "Fort\ William",
"441625", "Macclesfield",
"4415073", "Louth",
"441432", "Hereford",
"44161", "Manchester",
"441698", "Motherwell",
"441879", "Scarinish",
"441651", "Oldmeldrum",
"441472", "Grimsby",
"441866", "Kilchrenan",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441913", "Durham",
"442884", "Northern\ Ireland",
"441233", "Ashford\ \(Kent\)",
"441360", "Killearn",
"441273", "Brighton",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;