# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::BG;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230305170049;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '1',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            43[1-6]|
            70[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [356]|
            4[124-7]|
            7[1-9]|
            8[1-6]|
            9[1-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              70|
              8
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            43[1-7]|
            7
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [48]|
            9[08]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '9',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'geographic' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'mobile' => '
          (?:
            43[07-9]|
            99[69]\\d
          )\\d{5}|
          (?:
            8[7-9]|
            98
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(700\\d{5})|(90\\d{6})',
                'toll_free' => '
          (?:
            00800\\d\\d|
            800
          )\\d{5}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"3593776", "Raykova\ mogila",
"3593324", "Izbeglii",
"3593728", "Slavyanovo\,\ Hask\.",
"35961303", "Gorna\ Lipnitsa",
"35960389", "Kardam\,\ Targ\.",
"3594132", "Orizovo",
"3593100", "Belashtitsa",
"3594743", "Mamarchevo",
"35931602", "Tatarevo\,\ Plovdiv",
"35941330", "Tsenovo\,\ St\.\ Zagora",
"3596165", "Asenovo\,\ V\.\ Tarnovo",
"35941116", "Sladak\ Kladenets",
"3599541", "Doktor\ Yosifovo",
"3595351", "Smyadovo",
"3597548", "Godeshevo",
"3593712", "Malevo\,\ Hask\.",
"3597177", "Aldomirovtsi",
"35931707", "Chernozemen",
"3596560", "Kreta\,\ Pleven",
"3593785", "Dryanovo\,\ Hask\.",
"3593557", "Byaga",
"3594729", "Kirilovo\,\ Yambol",
"3594595", "Sborishte",
"3599185", "Beli\ Izvor",
"3593674", "Samodiva",
"3595574", "Saedinenie\,\ Burgas",
"35957304", "Dabovik",
"3595749", "Krapets\,\ Dobr\.",
"3593933", "Stransko",
"3599112", "Banitsa",
"3598122", "Tsenovo\,\ Ruse",
"3596981", "Petrevene",
"3596178", "Strelets\,\ V\.\ Tarnovo",
"3596547", "Dragash\ voyvoda",
"3598663", "Sitovo\,\ Silistra",
"3596126", "Tserova\ koria",
"3597058", "Stob",
"3596582", "Belene",
"35963561", "Grivitsa",
"3596967", "Kaleytsa",
"3596515", "Slavyanovo\,\ Pleven",
"3599176", "Leskovets\,\ Vratsa",
"3599128", "Eliseyna",
"3595723", "Gurkovo\,\ Dobr\.",
"3598118", "Nikolovo\,\ Ruse",
"35969245", "Devetaki",
"3593175", "Dalgo\ pole\,\ Plovdiv",
"35941144", "Kaloyanovets",
"35974327", "Novo\ Delchevo",
"3595163", "Mlada\ gvardia",
"3594340", "Panicherevo",
"359678", "Teteven",
"3593518", "Dragor",
"3597742", "Kalishte",
"3597133", "Pravets",
"35991202", "Kunino",
"3595731", "General\ Toshevo\,\ Dobr\.",
"359650", "Levski\,\ Pleven",
"3594519", "Samuilovo\,\ Sliven",
"3596022", "Probuda\,\ Targ\.",
"35981262", "Bistrentsi",
"35961607", "Balkantsi\,\ V\.\ Tarnovo",
"35967305", "Stokite",
"35967392", "Yavorets",
"3593522", "Gelemenovo",
"35931992", "Padarsko",
"3593921", "Merichleri",
"359601", "Targovishte",
"3597034", "Dzherman",
"3597045", "Golem\ Varbovnik",
"3595316", "Salmanovo",
"3594367", "Tazha",
"35961309", "Gorsko\ Kalugerovo",
"35960383", "Berkovski",
"3595513", "Gabar",
"3596725", "Gostilitsa",
"3595320", "Pet\ mogili\,\ Shumen",
"3593168", "Ezerovo\,\ Plovdiv",
"3598477", "Samuil",
"3593661", "Ivaylovgrad",
"3596536", "Asparuhovo\,\ Pleven",
"3595941", "Skalak\,\ Burgas",
"3597531", "Dolno\ Dryanovo",
"35963204", "Delyanovtsi",
"3599352", "Druzhba",
"3595755", "Kolartsi",
"3593642", "Potochnitsa",
"3593036", "Mogilitsa",
"3597932", "Shipochano",
"35947202", "Zhrebino",
"359659", "Cherven\ bryag",
"35981268", "Krivina\,\ Ruse",
"35935419", "Sveta\ Petka",
"359309", "Pamporovo",
"35967398", "Damyanovo",
"35931998", "Choba",
"35935393", "Smilets\,\ Pazardzhik",
"3593340", "Novi\ izvor",
"35984743", "Brestovene",
"35961105", "Prisovo",
"359953", "Berkovitsa",
"3594518", "Topolchane",
"35930475", "Stomanevo",
"3593519", "Velichkovo\,\ Pazardzhik",
"3597713", "Rudartsi",
"35937701", "Sladun",
"3597422", "Topolnitsa\,\ Blag\.",
"359416", "Chirpan",
"3594522", "Korten",
"3597184", "Koprivshtitsa",
"3599129", "Sinyo\ bardo",
"35984749", "Sevar",
"3599327", "Chuprene",
"3596179", "Krusheto",
"3598694", "Zebil",
"35951104", "Dolishte\,\ Varna",
"3599143", "Enitsa",
"3593190", "Varben\,\ Plovdiv",
"35971505", "Churek",
"3595748", "Durankulak",
"3595335", "Milanovo\,\ Shumen",
"3599554", "Chiprovtsi",
"3595344", "Velino",
"35956", "Burgas",
"35977226", "Debeli\ lag",
"3594728", "Melnitsa",
"3594324", "Shipka",
"3593743", "Silen",
"3597549", "Dolen\,\ Blag\.",
"3596321", "Gorna\ Studena",
"35937420", "Podkrepa",
"3593132", "Banya\,\ Plovdiv",
"3594100", "Stoletovo\,\ St\.\ Zagora",
"35959404", "Yasenovo\,\ Burgas",
"3594712", "Kabile",
"3597523", "Garmen",
"3594557", "Bikovo",
"3593729", "Krivo\ pole",
"3593772", "Momkovo",
"3597117", "Gradets\,\ Sofia",
"3593108", "Boykovo",
"3595164", "Neofit\ Rilski",
"359817", "Byala\,\ Ruse",
"35969248", "Skobelevo\,\ Lovech",
"35967193", "Kmetovtsi",
"3597145", "Mirovo\,\ Sofia",
"3597134", "Vrachesh",
"3594136", "Cherna\ gora\,\ St\.\ Zagora",
"3593720", "Madzharovo",
"35984463", "Prelez",
"35974201", "Kapatovo",
"3596568", "Dabovan",
"3594355", "Buzovgrad",
"35984711", "Mortagonovo",
"3592", "Sofia",
"3598165", "Smirnenski\,\ Ruse",
"3594109", "Trakia",
"3596948", "Karpachevo",
"35953435", "Izgrev\,\ Shumen",
"3599525", "Dolno\ Ozirovo",
"3593075", "Dolen\,\ Smol\.",
"3593691", "Chernoochene",
"3596118", "Voneshta\ voda",
"35971502", "Eleshnitsa\,\ Sofia",
"3597033", "Kraynitsi",
"3599116", "Kostelevo",
"3596575", "Telish",
"35941276", "Mogila\,\ St\.\ Zagora",
"3596586", "Belene",
"3596122", "Belyakovets",
"3597915", "Nevestino\,\ Kyust\.",
"35936401", "Strandzhevo",
"35984778", "Bogdantsi\,\ Razgrad",
"3599172", "Selanovtsi",
"359306", "Rudozem",
"3593637", "Gruevo",
"35971306", "Rashkovo",
"3595537", "Sadievo\,\ Burgas",
"3593510", "Ovchepoltsi",
"3596955", "Dalbok\ dol",
"3593323", "Bolyartsi\,\ Plovdiv",
"3596907", "Gradezhnitsa",
"35930472", "Mihalkovo",
"3594744", "Golyamo\ Krushevo",
"3594348", "Dunavtsi\,\ St\.\ Zagora",
"3597158", "Doganovo",
"3593115", "Kuklen",
"3596026", "Makariopolsko",
"35961102", "Pchelishte",
"3593349", "Boyantsi",
"3593526", "Dinkata",
"3593147", "Novo\ selo\,\ Plovdiv",
"3599782", "Bukovets\,\ Mont\.",
"35973", "Blagoevgrad",
"35984469", "Bozhurovo\,\ Razgrad",
"3595573", "Vezenkovo",
"3593673", "Tihomir",
"3599747", "Mokresh\,\ Mont\.",
"3593934", "Skobelevo\,\ Hask\.",
"3596065", "Bistra\,\ Targ\.",
"3595312", "Dibich",
"35967308", "Lovnidol",
"3593751", "Lyubimets",
"35960376", "Lyublen",
"3596157", "Slivovitsa",
"3598664", "Polyana\,\ Silistra",
"3596359", "Glava",
"3595724", "Dropla\,\ Dobr\.",
"359357", "Panagyurishte",
"3595328", "Nikola\ Kozlevo",
"3595329", "Mirovtsi",
"3596532", "Balgarene\,\ Pleven",
"3596931", "Ugarchin",
"3594751", "Voynika",
"3595127", "Manastir\,\ Varna",
"3599356", "Kalenik\,\ Vidin",
"3597936", "Slokoshtitsa",
"3593646", "Tokachka",
"3593032", "Srednogortsi",
"3595343", "Venets\,\ Shumen",
"3599553", "Prevala",
"3599135", "Bardarski\ geran",
"3599144", "Nivyanin",
"35961108", "Plakovo",
"3598693", "Zvenimir",
"359457", "Nova\ Zagora",
"35941353", "Plodovitovo",
"3596997", "Dobrevtsi\,\ Lovech",
"3598445", "Yuper",
"35958", "Dobrich",
"359747", "Razlog",
"3594323", "Tulovo",
"35937603", "Rogozinovo",
"3594510", "Zhelyu\ voyvoda",
"3593348", "Dobralak",
"35992", "Vratsa",
"35931995", "Streltsi\,\ Plovdiv",
"3597159", "Aprilovo\,\ Sofia",
"35967302", "Kravenik",
"3593744", "Sarnitsa\,\ Hask\.",
"35967395", "Gorna\ Rositsa",
"35930411", "Devin",
"3594115", "Kirilovo\,\ St\.\ Zagora",
"35961705", "Gorski\ dolen\ Trambesh",
"35981466", "Pomen",
"3594147", "Lyubenovo\,\ St\.\ Zagora",
"3597426", "Marikostinovo",
"3596590", "Rakita\,\ Pleven",
"3594526", "Mlekarevo",
"3597524", "Ablanitsa\,\ Blag\.",
"35953221", "Stoyan\ Mihaylovski",
"35984764", "Seydol",
"35969242", "Presyaka",
"3594331", "Gurkovo\,\ St\.\ Zagora",
"3598671", "Silistra",
"3593198", "Chehlare",
"3596119", "Dichin",
"3595740", "Gorichane",
"3596738", "Dobromirka",
"35984733", "Ludogortsi",
"3594772", "Simeonovo\,\ Yambol",
"3594108", "Vasil\ Levski\,\ St\.\ Zagora",
"3596569", "Lenkovo",
"3593136", "Rozino\,\ Plovdiv",
"3597714", "Meshtitsa",
"3594716", "Veselinovo\,\ Yambol",
"3595767", "Zhitnitsa\,\ Dobr\.",
"35961393", "Gorsko\ Kosovo",
"35941359", "Izvorovo\,\ St\.\ Zagora",
"35971338", "Osikovska\ Lakavitsa",
"3599311", "Kutovo",
"3596923", "Goran",
"35931605", "Bukovo\,\ Plovdiv",
"3597183", "Dushantsi",
"3595781", "Svoboda\,\ Dobr\.",
"3598627", "Babuk",
"3593109", "Lilkovo",
"3595108", "Sadovo\,\ Varna",
"3593164", "Dalbok\ izvor",
"3595772", "Telerig",
"3598660", "Tutrakan",
"3596325", "Kozlovets",
"35947356", "Mramor\,\ Yambol",
"35931403", "Trivoditsi",
"3595716", "Paskalevo",
"35930528", "Manastir\,\ Plovdiv",
"35960453", "Moravka",
"35984727", "Kamenovo\,\ Razgrad",
"3596113", "Balvan",
"359936", "Belogradchik",
"35961503", "Chakali",
"3596943", "Gorsko\ Slivovo",
"3595397", "Metodievo\,\ Shumen",
"35930410", "Breze\,\ Smol\.",
"35936702", "Gorski\ izvor\,\ Kardzh\.",
"3598647", "Paisievo",
"3596563", "Brest\,\ Pleven",
"3594152", "Obruchishte",
"35941112", "Starozagorski\ bani",
"35931606", "Voden\,\ Plovdiv",
"3593514", "Chernogorovo\,\ Pazardzhik",
"3595958", "Gramatikovo",
"35959407", "Sini\ rid",
"3596929", "Radyuvene",
"35971398", "Osikovitsa",
"3593537", "Panagyurski\ kolonii",
"3597189", "Chavdar\,\ Sofia",
"3593103", "Milevo",
"3595323", "Pliska",
"3597192", "Gintsi",
"3598114", "Pirgovo",
"3599124", "Tipchenitsa",
"35953220", "Pamukchii\,\ Shumen",
"3596174", "Draganovo\,\ V\.\ Tarnovo",
"3598137", "Golyamo\ Vranovo",
"3597054", "Rila",
"3599559", "Gorna\ Kovachitsa",
"359860", "Silistra",
"3595349", "Studenitsa",
"3595115", "General\ Kantardzhievo",
"3598699", "Tarnovtsi\,\ Silistra",
"3595578", "Terziysko\,\ Burgas",
"3593678", "Chakalarovo",
"3595147", "Pchelnik\,\ Varna",
"3595526", "Klikach",
"3593626", "Perperek",
"35931996", "Svezhen",
"35984392", "Belintsi",
"3594329", "Dolno\ Sahrane",
"3595917", "Izvor\,\ Burgas",
"3593665", "Svirachi",
"35967396", "Berievo",
"35981266", "Starmen\,\ Ruse",
"3595751", "Tervel\,\ Dobr\.",
"3597446", "Eleshnitsa\,\ Blag\.",
"3595945", "Dobromir",
"3597544", "Osina",
"35981465", "Batin",
"359848", "Kubrat",
"3594343", "Konare\,\ St\.\ Zagora",
"3593328", "Dolnoslav",
"35971471", "Ochusha",
"3593724", "Susam",
"35961706", "Pisarevo\,\ V\.\ Tarnovo",
"3596046", "Vrani\ kon",
"35961604", "Mirovo\,\ V\.\ Tarnovo",
"3593127", "Tsaratsovo",
"3597041", "Shatrovo",
"3593343", "Kozanovo",
"35984710", "Osenets",
"35938", "Haskovo",
"35974324", "Struma",
"3597726", "Dren",
"3594724", "Razdel\,\ Yambol",
"3597102", "Lopyan",
"3598636", "Glavinitsa\,\ Silistra",
"35965617", "Iskar\,\ Pleven",
"3596556", "Gorna\ Mitropolia",
"3593679", "Kirkovo",
"3595579", "Vedrovo",
"3599332", "Rakovitsa",
"3595735", "Krasen\,\ Dobr\.",
"3593056", "Chepintsi\,\ Smol\.",
"35975214", "Gaytaninovo",
"3598698", "Shumentsi",
"3599558", "Gavril\ Genovo",
"3595348", "Trem",
"35984269", "Nedoklan",
"3599727", "Medkovets",
"35960375", "Garchinovo",
"3593925", "Krum",
"359777", "Radomir",
"35931704", "Ivan\ Vazovo",
"3597188", "Petrich\,\ Sofia",
"3599181", "Kravoder",
"35941171", "Dalboki",
"3596928", "Kakrina",
"3595959", "Zvezdets",
"3597520", "Kornitsa",
"3599167", "Lipnitsa\,\ Vratsa",
"359726", "Svoge",
"35953436", "Chernoglavtsi",
"3596985", "Rumyantsevo",
"3594514", "Krushare",
"3597125", "Govedartsi",
"3596912", "Bahovitsa",
"3594103", "Byal\ izvor\,\ St\.\ Zagora",
"3597437", "Melnik",
"3593740", "Pchelari",
"35974401", "Gorno\ Draglishte",
"3596511", "Pobeda\,\ Pleven",
"35977222", "Gorna\ Dikanya",
"3597166", "Vlado\ Trichkov",
"3596733", "Kormyansko",
"3596142", "Obedinenie",
"3599140", "Gabare",
"3593193", "Borets",
"35941275", "Lyaskovo\,\ St\.\ Zagora",
"3595136", "Brestak",
"3596161", "Strazhitsa\,\ V\.\ Tarnovo",
"3597927", "Treklyano",
"35941118", "Ostra\ mogila\,\ St\.\ Zagora",
"3597039", "Samoranovo",
"35957307", "Zhiten\,\ Dobr\.",
"3599545", "Gabrovnitsa",
"3593767", "Branitsa",
"3596001", "Cherkovna\,\ Targ\.",
"3599517", "Kobilyak",
"359519", "Devnya",
"3593781", "Simeonovgrad",
"3599123", "Roman",
"3598113", "Novo\ selo\,\ Ruse",
"35971302", "Bozhenitsa",
"3595324", "Harsovo\,\ Shumen",
"3595776", "Cherna\,\ Dobr\.",
"3597053", "Kocherinovo",
"3595100", "Sindel",
"3596173", "Dolna\ Oryahovitsa",
"3598668", "Popina",
"3599149", "Bukovets\,\ Vratsa",
"3599315", "Gradets\,\ Vidin",
"3595712", "Stozher",
"35991180", "Lesura",
"3593657", "Zhaltusha",
"3597030", "Resilovo",
"35971506", "Gabra",
"3595557", "Bistrets\,\ Burgas",
"3599347", "Bela\ Rada",
"35931390", "Moskovets",
"3593749", "Garvanovo",
"3596074", "Lyubichevo",
"3597154", "Stolnik",
"3594156", "Aprilovo\,\ St\.\ Zagora",
"3598675", "Aydemir",
"3594748", "Voden\,\ Yambol",
"3594335", "Razhena",
"3594344", "Shanovo",
"3597529", "Breznitsa",
"35946", "Yambol",
"3593163", "Iskra\,\ Plovdiv",
"35931620", "Dobri\ dol\,\ Plovdiv",
"35960372", "Krepcha",
"3595518", "Rudnik\,\ Burgas",
"3595570", "Manolich",
"3596137", "Butovo",
"3595522", "Iskra\,\ Burgas",
"3593622", "Stremtsi",
"3596114", "Kilifarevo",
"3596935", "Sopot\,\ Lovech",
"3596944", "Krushuna",
"3597442", "Yakoruda",
"3594587", "Yablanovo",
"3596564", "Zagrazhden\,\ Pleven",
"35937421", "Dolno\ pole",
"35961106", "Novo\ selo\,\ V\.\ Tarnovo",
"359361", "Kardzhali",
"3594755", "Tamarino",
"3599131", "Dobrolevo",
"3593320", "Oreshets\,\ Plovdiv",
"3597138", "Litakovo",
"3597719", "Yardzhilovtsi",
"359729", "Godech",
"3593513", "Malo\ Konare",
"3593104", "Yagodovo\,\ Plovdiv",
"3595168", "Petrov\ dol\,\ Varna",
"35930476", "Selcha",
"3593561", "Septemvri",
"3596042", "Iliyno",
"35981462", "Volovo",
"3595169", "Momchilovo",
"35941331", "Granit",
"35941489", "Bozduganovo",
"3596061", "Golyamo\ Sokolovo",
"3593542", "Rakitovo",
"3593755", "Belitsa\,\ Hask\.",
"3597718", "Dragichevo",
"3593707", "Nikolovo\,\ Hask\.",
"3595367", "Todor\ Ikonomovo",
"3593587", "Sestrimo",
"35960378", "Tsar\ Asen\,\ Targ\.",
"3597139", "Dzhurovo",
"35967306", "Gradishte\,\ Gabr\.",
"3594513", "Gavrailovoc",
"3594104", "Kravino",
"3597106", "Yamna",
"3598632", "Zafirovo",
"3593194", "Zelenikovo\,\ Plovdiv",
"3598690", "Silistra",
"3596734", "Petko\ Slaveykov",
"3596552", "Dolna\ Mitropolia",
"3595340", "Visoka\ polyana\,\ Shumen",
"3599550", "Mitrovtsi",
"3599336", "Staropatitsa",
"3593052", "Laki\,\ Plovdiv",
"359720", "Etropole",
"3596717", "Lesicharka",
"3593111", "Parvenets\,\ Plovdiv",
"3595519", "Zidarovo",
"35963579", "Ralevo",
"3594797", "Galabintsi",
"35963560", "Radishevo",
"3593695", "Komuniga",
"3596920", "Lesidren",
"3597528", "Hadzhidimovo",
"3599521", "Zamfirovo",
"3593071", "Zlatograd",
"35984776", "Harsovo\,\ Razgrad",
"3593156", "Shishmantsi",
"3596571", "Lepitsa",
"3594749", "Ruzhitsa\,\ Yambol",
"3597911", "Granitsa",
"3593344", "Novakovo\,\ Plovdiv",
"3593748", "Lyaskovets\,\ Hask\.",
"359675", "Sevlievo",
"35941115", "Borilovo",
"3596916", "Brestovo\,\ Lovech",
"3594723", "Boyanovo\,\ Yambol",
"35963573", "Disevitsa",
"3597162", "Lakatnik",
"3596527", "Odarne",
"3596146", "Polski\ Senovets",
"3595132", "Mihalich\,\ Varna",
"3593027", "Slaveyno",
"3599148", "Barkachevo",
"3595743", "Shabla",
"3598669", "Garvan\,\ Silistra",
"3598161", "Vetovo",
"3594351", "Koprinka",
"3598187", "Tetovo",
"3598142", "Bazovets\,\ Ruse",
"3596076", "Taymishte",
"3596028", "Vardun",
"3594154", "Mednikarovo",
"3597156", "Ravno\ pole",
"3593528", "Govedare",
"359537", "Novi\ pazar\,\ Shumen",
"35931308", "Bogdan\,\ Plovdiv",
"3596151", "Elena\,\ V\.\ Tarnovo",
"3593705", "Vaglarovo",
"3593757", "Georgi\ Dobrevo",
"3594529", "Sadievo\,\ Sliven",
"3595365", "Lyatno",
"35976", "Pernik",
"3593585", "Akandzhievo",
"3593512", "Hadzhievo",
"3599741", "Dolni\ Tsibar",
"3594346", "Golyamo\ Dryanovo",
"3597939", "Tsarvaritsa",
"35941336", "Yazdach",
"3595969", "Galabets\,\ Burgas",
"3593162", "Gradina\,\ Plovdiv",
"3594795", "Skalitsa",
"3595326", "Varbyane",
"3595774", "Koriten",
"3593623", "Boyno",
"3595523", "Krumovo\ gradishte",
"3595310", "Radko\ Dimitrievo",
"359725", "Elin\ Pelin",
"35936700", "Shoptsi",
"35930412", "Devin",
"35951429", "Solnik",
"35967301", "Idilevo",
"3596901", "Glozhene\,\ Lovech",
"35969612", "Terziysko\,\ Lovech",
"35941110", "Starozagorski\ bani",
"3596566", "Dolni\ Vit",
"3593631", "Momchilgrad",
"359670", "Troyan\,\ Lovech",
"3597755", "Velkovtsi\,\ Pernik",
"35984718", "Dryanovets\,\ Razgrad",
"3593718", "Voyvodovo\,\ Hask\.",
"3599568", "Blagovo\,\ Mont\.",
"3596946", "Chavdartsi",
"359308", "Madan\,\ Smol\.",
"35930517", "Zabardo",
"3593106", "Stroevo",
"3593722", "Mineralni\ bani\,\ Hask\.",
"35953222", "Markovo\,\ Shumen",
"3594138", "Gita",
"35963565", "Mechka\,\ Pleven",
"35960454", "Zmeyno",
"35969241", "Yoglav",
"3598185", "Senovo",
"3596588", "Dekov",
"3597052", "Pastra",
"3599122", "Zverino",
"3596116", "Golemanite",
"3593025", "Banite",
"3596525", "Barkach",
"3598128", "Polsko\ Kosovo",
"3595713", "Stefanovo\,\ Dobr\.",
"3599345", "Vinarovo\,\ Vidin",
"3595555", "Fakia",
"3595742", "Rakovski\,\ Dobr\.",
"3598129", "Lom\ Cherkovna",
"35974496", "Filipovo\,\ Blag\.",
"3599119", "Tishevitsa",
"3598621", "Silistra",
"35984712", "Kostandenets",
"3595133", "General\ Kolevo\,\ Varna",
"3597731", "Tran",
"3599317", "Archar",
"3593196", "Drangovo\,\ Plovdiv",
"35931703", "Zhitnitsa\,\ Plovdiv",
"3596736", "Gradnitsa\,\ Gabr\.",
"3597163", "Iskrets",
"3595761", "Batovo",
"3598143", "Obretenik",
"35961307", "Stambolovo\,\ V\.\ Tarnovo",
"3596589", "Kulina\ voda",
"35974202", "Klyuch",
"3594718", "Roza",
"359973", "Kozloduy",
"3594139", "Svoboda\,\ St\.\ Zagora",
"3598677", "Srebarna",
"3594337", "Yasenovo\,\ St\.\ Zagora",
"35931258", "Glavatar",
"35936402", "Gorna\ kula",
"3594722", "Granitovo\,\ Yambol",
"3594106", "Pastren",
"3597104", "Laga",
"3599569", "Lipen",
"3593719", "Knizhovnik",
"3593138", "Vedrare",
"3594770", "General\ Inzovo",
"35961101", "Velchevo\,\ V\.\ Tarnovo",
"35961603", "Lozen\,\ V\.\ Tarnovo",
"3593053", "Hvoyna",
"3596553", "Oryahovitsa\,\ Pleven",
"3596144", "Dolna\ Lipnitsa",
"3596135", "Varbovka",
"35931395", "Iganovo",
"35993212", "Karbintsi",
"35974323", "Lozenitsa",
"35937705", "Pastrogor",
"3593030", "Shiroka\ laka",
"3595968", "Kableshkovo\,\ Burgas",
"3596530", "Tranchovitsa",
"3593648", "Golyamo\ Kamenyane",
"3597938", "Dolno\ Uyno",
"35930456", "Chavdar\,\ Smol\.",
"3596991", "Yablanitsa",
"35931709", "Mihiltsi",
"3593154", "Chalakovi",
"3593543", "Dorkovo",
"3597428", "Gabrene",
"3596043", "Dolno\ Novkovo",
"3594528", "Lyubenova\ mahala",
"35962", "Veliko\ Tarnovo",
"3598633", "Staro\ selo\,\ Silistra",
"3594585", "Zheravna",
"35991185", "Pudria",
"3596914", "Slivek",
"3594757", "Nedyalsko",
"3595121", "Tutrakantsi",
"3597723", "Dolni\ Rakovets",
"359596", "Pomorie",
"35954", "Shumen",
"3593529", "Mokrishte",
"3596029", "Nadarevo",
"35961406", "Karantsi",
"35930418", "Buynovo\,\ Smol\.",
"3596937", "Sokolovo\,\ Lovech",
"3593346", "Muldava",
"3594512", "Blatets\,\ Sliven",
"359554", "Sunny\ Beach",
"35960387", "Gloginka",
"3593520", "Miryantsi",
"3596072", "Dobrotitsa\,\ Targ\.",
"35971224", "Shipochane",
"35941270", "Malka\ Vereya",
"35931388", "Beguntsi",
"35947201", "Izgrev\,\ Yambol",
"3597152", "Gorna\ Malina",
"35991182", "Osen\,\ Vratsa",
"35941357", "Zetyovo\,\ St\.\ Zagora",
"3596020", "Lilyak",
"3594361", "Pavel\ banya",
"3593125", "Razhevo\ Konare",
"3598151", "Prosena",
"3593516", "Tsrancha\,\ Pazardzhik",
"3594342", "Ovoshtnik",
"35937702", "Mustrak",
"3593927", "Chernogorovo\,\ Hask\.",
"3593039", "Polkovnik\ Serafimovo",
"35947192", "Zavoy",
"3597193", "Golesh\,\ Sofia",
"359318", "Saedinenie\,\ Plovdiv",
"3596539", "Gradishte\,\ Pleven",
"3599725", "Komoshtitsa",
"3593166", "Byala\ reka\,\ Plovdiv",
"3595737", "Lyulyakovo\,\ Dobr\.",
"35931392", "Dabene",
"3595714", "Karapelit",
"3595318", "Srednya",
"359676", "Dryanovo\,\ Gabr\.",
"3599560", "Bezdenitsa",
"3594153", "Madrets\,\ St\.\ Zagora",
"3597435", "Sklave",
"3597127", "Shiroki\ dol",
"3597444", "Belitsa\,\ Blag\.",
"3596562", "Gigen",
"3597546", "Slashten",
"3596942", "Aleksandrovo\,\ Lovech",
"3594779", "Hanovo",
"3596541", "Nikopol",
"3593710", "Uzundzhovo",
"3596987", "Karlukovo",
"3594130", "Spasovo\,\ St\.\ Zagora",
"3593102", "Karadzhovo",
"3593778", "Studena\,\ Hask\.",
"35978", "Kyustendil",
"3599165", "Sofronievo",
"3593726", "Klokotnitsa",
"35935257", "Saraya",
"35960370", "Golyamo\ gradishte",
"3596176", "Polikraishte",
"3599515", "Madan\,\ Mont\.",
"35961397", "Musina",
"3597056", "Mursalevo",
"3596128", "Hotnitsa",
"3595773", "Lozenets\,\ Dobr\.",
"3599547", "Vinishte",
"35963568", "Bukovlak",
"3598116", "Ivanovo\,\ Ruse",
"3599126", "Kameno\ pole",
"3593765", "Ivanovo\,\ Hask\.",
"3596580", "Tatari",
"35974406", "Dobarsko",
"3599110", "Virovsko",
"3595524", "Ekzarh\ Antimovo",
"35984737", "Raynino",
"3596112", "Samovodene",
"3597925", "Gyueshevo",
"3593624", "Chiflik\,\ Kardzh\.",
"3595746", "Belgun",
"3593054", "Podvis\,\ Smol\.",
"3594551", "Byala\,\ Sliven",
"3593192", "Babek",
"3596143", "Maslarevo",
"359590", "Tsarevo",
"3596732", "Sennik",
"3596554", "Krushovene",
"3596327", "Ovcha\ mogila",
"35963574", "Todorovo\,\ Pleven",
"3596129", "Gabrovtsi",
"35984467", "Seslav",
"3593535", "Levski\,\ Pazardzhik",
"3593544", "Kostandovo",
"3593153", "Stryama",
"35941484", "Zemlen",
"3594710", "Bolyarsko",
"3596035", "Palamartsa",
"3593779", "Siva\ reka",
"3596044", "Dolno\ Kozarevo",
"35963562", "Komarevo\,\ Pleven",
"3595395", "Chernookovo\,\ Shumen",
"3597724", "Izvor\,\ Pernik",
"3594726", "Malomirovo",
"3593130", "Karavelovo\,\ Plovdiv",
"3596913", "Slavyani",
"3594102", "Yastrebovo\,\ St\.\ Zagora",
"3598634", "Nova\ Cherna",
"3594778", "Pobeda\,\ Yambol",
"3598645", "Mezhden",
"3595145", "Grozdyovo",
"3595134", "Cherventsi",
"3595319", "Drumevo",
"35991188", "Galatin",
"3599333", "Boynitsa",
"35969615", "Balabansko",
"3597164", "Rebrovo",
"3595117", "Botevo\,\ Varna",
"359865", "Silistra",
"35930415", "Devin",
"35967391", "Stolat",
"359418", "Galabovo\,\ St\.\ Zagora",
"3596538", "Obnova",
"3597930", "Eremia",
"3596352", "Dolni\ Lukovit",
"3598144", "Batishnitsa",
"3598135", "Babovo",
"35991201", "Lyuti\ brod",
"3593038", "Chokmanovo",
"3594520", "Konyovo",
"35951536", "Nikolaevka",
"35982", "Ruse",
"3594125", "Mihaylovo\,\ St\.\ Zagora",
"3597103", "Brusen\,\ Sofia",
"3595947", "Prosenik",
"35993342", "Kireevo",
"3593342", "Narechenski\ bani",
"35931398", "Slatina\,\ Plovdiv",
"3594516", "Kermen",
"35995276", "Draganitsa",
"3595915", "Balgarovo",
"3593667", "Pokrovan",
"35969616", "Staro\ selo\,\ Lovech",
"3595313", "Madara",
"35955504", "Bogdanovo\,\ Burgas",
"3599339", "Makresh",
"35930416", "Gyovren",
"3598124", "Novgrad",
"3595520", "Cherkovo",
"3593672", "Chorbadzhiysko",
"35991401", "Vranyak",
"3595572", "Beronovo",
"3599783", "Brusartsi",
"3599137", "Popitsa",
"3595125", "Gradinarovo",
"35981461", "Karan\ Varbovka",
"359723", "Botevgrad",
"359331", "Asenovgrad",
"3596584", "Belene",
"3595516", "Indzhe\ voyvoda",
"35941332", "Naydenovo",
"3594567", "Banya\,\ Sliven",
"35930458", "Lyubcha",
"3594145", "Znamenosets",
"3594134", "Bratya\ Daskalovi",
"3597136", "Novachene\,\ Sofia",
"35960384", "Gagovo",
"3593322", "Zlatovrah",
"3595166", "Dobroplodno",
"359518", "Provadia",
"3599564", "Stubel",
"3593936", "Gorski\ izvor\,\ Hask\.",
"3597032", "Yahinovo",
"3596149", "Kutsina",
"3595710", "Pobeda\,\ Dobr\.",
"35967390", "Shumata",
"35961304", "Dimcha",
"3595726", "Tsarichino",
"3599173", "Galovo",
"35943616", "Turia",
"3595102", "Padina\,\ Varna",
"359868", "Silistra",
"3596123", "Bukovets\,\ V\.\ Tarnovo",
"3598666", "Tutrakan",
"35941149", "Lovets\,\ St\.\ Zagora",
"3595952", "Malko\ Tarnovo",
"3597744", "Elovdol\,\ Pernik",
"3594746", "Popovo\,\ Yambol",
"3597735", "Leva\ reka",
"3595551", "Sredets\,\ Burgas",
"3599341", "Dimovo\,\ Vidin",
"3593651", "Ardino",
"3593159", "Belozem",
"3598625", "Oven",
"35974347", "Razdol",
"3595765", "Lovchantsi",
"3593773", "Kapitan\ Andreevo",
"3593524", "Apriltsi\,\ Pazardzhik",
"3596919", "Slatina\,\ Lovech",
"3594158", "Iskritsa",
"3596024", "Ruets",
"3593746", "Sirakovo\,\ Hask\.",
"3596918", "Drenov",
"3594357", "Gorno\ Sahrane",
"35984723", "Dyankovo",
"3594773", "Okop",
"3598167", "Tserovets",
"3597147", "Pchelin\,\ Sofia",
"3597424", "Karnalovo",
"3597182", "Mirkovo",
"3594524", "Kamenovo\,\ Sliven",
"3597526", "Ribnovo",
"3596922", "Leshnitsa\,\ Lovech",
"35951103", "Lyuben\ Karavelovo",
"3596521", "Sadovets",
"3595153", "Suvorovo",
"3597751", "Breznik",
"3595535", "Lyaskovo\,\ Burgas",
"3598140", "Borovo\,\ Ruse",
"3599354", "Antimovo\,\ Vidin",
"35941175", "Kolena",
"35959403", "Rechitsa",
"3597934", "Bunovo\,\ Kyust\.",
"3593644", "Egrek",
"35941019", "Venets\,\ St\.\ Zagora",
"3597917", "Tavalichevo",
"3595130", "General\ Kiselovo",
"3596577", "Breste",
"3596148", "Pavel",
"3593077", "Sredets\,\ Smol\.",
"3599527", "Varshets",
"35974405", "Kraishte\,\ Blag\.",
"3599146", "Sokolare",
"3597720", "Priboy",
"35963203", "Hadzhidimitrovo\,\ V\.\ Tarnovo",
"35961402", "Stefan\ Stambolovo",
"3598630", "Silistra",
"3593145", "Krichim",
"3593134", "Sopot\,\ Plovdiv",
"3594322", "Yagoda",
"3593117", "Katunitsa",
"35959409", "Cheresha",
"3594737", "Sinapovo",
"3596711", "Kozi\ rog",
"35951314", "Voyvodino",
"35935394", "Oborishte\,\ Pazardzhik",
"3594714", "Drazhevo",
"35941338", "Tselina",
"3596957", "Golyama\ Zhelyazna",
"3596905", "Divchovoto",
"35984729", "Ezerche",
"3596155", "Konstantin",
"35984744", "Belovets",
"3596533", "Stezherovo",
"3593050", "Bukova\ polyana",
"3593581", "Belovo",
"3595361", "Kaolinovo",
"3593701", "Elena\,\ Hask\.",
"3596067", "Kralevo\,\ Targ\.",
"3598692", "Stefan\ Karadzha\,\ Silistra",
"3599338", "Shishentsi",
"3593567", "Kovachevo\,\ Pazardzhik",
"3595342", "Kapitan\ Petko",
"3599552", "Belimel",
"35937422", "Dolni\ Glavanak",
"3599745", "Zlatia\,\ Mont\.",
"359431", "Kazanlak",
"3596550", "Stavertsi",
"35931396", "Domlyan",
"3593059", "Kutela",
"3596559", "Gostilya",
"3593676", "Benkovski\,\ Kardzh\.",
"3595576", "Lozarevo",
"3593628", "Miladinovo",
"359337", "Hisarya",
"3595528", "Nevestino\,\ Burgas",
"3599174", "Gorni\ Vadin",
"35944", "Sliven",
"3594121", "Lyulyak",
"3595757", "Bezmer\,\ Dobr\.",
"35951538", "Izgrev\,\ Varna",
"3598475", "Loznitsa\,\ Razgrad",
"3596124", "Ledenik",
"35937706", "Chernodab",
"359454", "Tvarditsa\,\ Sliven",
"3597132", "Radotina",
"3595141", "Staro\ Oryahovo",
"3597743", "Divlya",
"3593549", "Grashevo",
"3593774", "Levka",
"3596049", "Kamburovo",
"3595162", "Belogradets",
"3593326", "Patriarh\ Evtimovo",
"35930256", "Galabovo\,\ Smol\.",
"35961405", "Petko\ Karavelovo",
"3598639", "Kolarovo\,\ Silistra",
"3598131", "Borisovo\,\ Ruse",
"3593523", "Sinitevo",
"3597729", "Dolna\ Dikanya",
"35991186", "Baurene",
"3597448", "Bachevo",
"3596023", "Podgoritsa",
"3599113", "Mramoren",
"3595718", "Smolnitsa",
"3598123", "Bosilkovtsi",
"3597036", "Balanovo",
"3593932", "Bodrovo",
"35967194", "Grablevtsi",
"35984464", "Veselets\,\ Razgrad",
"3595139", "Oborishte\,\ Varna",
"3595314", "Belokopitovo",
"3599784", "Kiselevo",
"35974402", "Godlevo",
"35974495", "Yurukovo",
"3597169", "Tompsan",
"35963577", "Pelishat",
"3595337", "Kochovo",
"3599325", "Belo\ pole\,\ Vidin",
"35941172", "Gorno\ Botevo",
"35951127", "Razdelna\,\ Varna",
"3598149", "Katselovo",
"3598641", "Okorsh",
"3595391", "Varbitsa\,\ Shumen",
"3595106", "Avren\,\ Varna",
"3596583", "Belene",
"3598662", "Dobrotitsa\,\ Silistra",
"3594742", "Stefan\ Karadzhovo",
"3594761", "Straldzha",
"359938", "Kula",
"35977221", "Kondofrey",
"3593713", "Dinevo",
"3593133", "Kalofer",
"3596910", "Malinovo",
"3593787", "Tyanevo\,\ Hask\.",
"35935254", "Dobrovnitsa",
"3593555", "Nova\ mahala\,\ Pazardzhik",
"3596007", "Ralitsa",
"35974408", "Obidim",
"35984763", "Beli\ Lom",
"3597175", "Gaber",
"35963566", "Brashlyanitsa",
"3597921", "Zhilentsi",
"35941178", "Oryahovitsa\,\ St\.\ Zagora",
"3596167", "Kesarevo",
"3597522", "Dabnitsa",
"3597186", "Anton",
"3596926", "Gorno\ Pavlikene",
"3594713", "Stara\ reka\,\ Yambol",
"3596517", "Podem",
"3596965", "Beli\ Osam",
"359751", "Gotse\ Delchev",
"3593034", "Levochevo",
"359728", "Zlatitsa",
"3593045", "Dospat",
"3596534", "Malchika",
"3596545", "Lyubenovo\,\ Pleven",
"35984734", "Todorovo\,\ Razgrad",
"3598148", "Gorno\ Ablanovo",
"3599161", "Mizia",
"3597168", "Bov",
"35961394", "Daskot",
"35941111", "Starozagorski\ bani",
"3595138", "Dobrotich",
"3594597", "Borov\ dol",
"3599187", "Lyutadzhik",
"3599142", "Lazarovo",
"3595719", "Donchevo",
"359697", "Lukovit",
"3597728", "Drugan",
"3599721", "Dolno\ Tserovene",
"3594774", "Krumovo\,\ Yambol",
"3598638", "Bogdantsi\,\ Silistra",
"3594326", "Enina",
"3594523", "Stoil\ voyvoda",
"35941354", "Malko\ Tranovo",
"3597423", "Kolarovo\,\ Blag\.",
"3596048", "Izvorovo\,\ Targ\.",
"3593548", "Pashovo",
"3597712", "Batanovtsi",
"35971227", "Beli\ Iskar",
"3593177", "Novo\ Zhelezare",
"35969240", "Hlevene",
"3593643", "Golyama\ Chinka",
"3597933", "Gramazhdano",
"35984769", "Gorotsvet",
"3599353", "Koshava",
"35941335", "Mogilovo",
"35937604", "Varbovo\,\ Hask\.",
"3596727", "Ganchovets",
"35934", "Pazardzhik",
"3597047", "Usoyka",
"3595529", "Krushovo\,\ Burgas",
"3593121", "Rogosh",
"3599330", "Rabrovo",
"3593629", "Most",
"3596558", "Slavovitsa\,\ Pleven",
"3598696", "Suhodol\,\ Silistra",
"3593058", "Mugla",
"3599556", "Govezhda",
"3595346", "Kamenyak\,\ Shumen",
"3593176", "Starosel",
"3596551", "Trastenik\,\ Pleven",
"35931397", "Hristo\ Danovo",
"35967303", "Batoshevo",
"3596952", "Oreshak\,\ Lovech",
"3593128", "Zlatitrap",
"3594732", "Ustrem",
"3594554", "Trapoklovo",
"3593700", "Trakiets",
"35969249", "Doyrentsi",
"3593051", "Chepelare",
"35937602", "Cherna\ mogila\,\ Hask\.",
"3594143", "Sarnevo\,\ St\.\ Zagora",
"359677", "Tryavna",
"3595919", "Marinka",
"3594327", "Sheynovo",
"3593112", "Markovo\,\ Plovdiv",
"35955505", "Drachevo",
"35937707", "Shtit",
"3594129", "Madzherito",
"3598697", "Sokol\,\ Silistra",
"3599785", "Vasilovtsi\,\ Mont\.",
"3593562", "Slavovitsa\,\ Pazardzhik",
"3595347", "Zhivkovo\,\ Shumen",
"3599557", "Gorno\ Tserovene",
"3597046", "Boboshevo",
"3596062", "Strazha\,\ Targ\.",
"3595315", "Tsarev\ brod",
"3595149", "Golitsa",
"3596710", "Donino",
"35941352", "Vinarovo\,\ St\.\ Zagora",
"35984760", "Trapishte",
"35960385", "Lomtsi",
"3596726", "Skalsko",
"35930257", "Vishnevo",
"3598631", "Silistra",
"3599324", "Ruzhintsi",
"35984779", "Zdravets\,\ Razgrad",
"3599728", "Slivata",
"3595123", "Ravna\,\ Varna",
"3596927", "Umarevtsi",
"3596039", "Opaka",
"3593775", "Generalovo",
"3595763", "Plachidol",
"3599168", "Butan",
"3597142", "Kostenets",
"3598623", "Golesh\,\ Silistra",
"35963576", "Tuchenitsa",
"359618", "Gorna\ Oryahovitsa",
"35984732", "Yonkovo",
"3596166", "Vinograd",
"3597187", "Bunovo\,\ Sofia",
"3597733", "Filipovtsi",
"3595131", "Valchi\ dol",
"3597438", "Katuntsi",
"3596006", "Presian",
"3594352", "Gorno\ Cherkovishte",
"3598141", "Dve\ mogili",
"3598649", "Yarebitsa",
"3593786", "Navasen",
"35961305", "Lesicheri",
"3596520", "Nikolaevo\,\ Pleven",
"3593072", "Nedelino",
"3599186", "Zgorigrad",
"35935252", "Topoli\ dol",
"3599522", "Kotenovtsi",
"35969243", "Kazachevo",
"3597928", "Garlyano",
"3596572", "Suhache",
"35931627", "Krushevo\,\ Plovdiv",
"35967309", "Agatovo",
"3593020", "Davidkovo",
"3599518", "Marchevo",
"359453", "Kotel",
"3597912", "Gorna\ Grashtitsa",
"3596125", "Pushevo",
"3599175", "Ostrov",
"3596516", "Iskar\,\ Pleven",
"3593768", "Dositeevo",
"3593769", "Oreshets\,\ Hask\.",
"3595533", "Pirne",
"3593633", "Rogozche",
"35984738", "Kitanchevo",
"35971503", "Dolno\ Kamartsi",
"35963567", "Gradina\,\ Pleven",
"3595336", "Imrenchevo",
"35961109", "Vaglevtsi",
"3594768", "Zimnitsa\,\ Yambol",
"3597929", "Sovolyano",
"3599340", "Septemvriytsi\,\ Vidin",
"3594364", "Osetenovo",
"35935258", "Tsar\ Asen\,\ Pazardzhik",
"35984462", "Ostrovo",
"3594775", "Karavelovo\,\ Yambol",
"3598648", "Sekulovo",
"35974404", "Babyak",
"3597439", "Ploski",
"35941174", "Podslon\,\ St\.\ Zagora",
"3593538", "Elshitsa",
"3595711", "Ovcharovo\,\ Dobr\.",
"35931701", "Krastevich",
"3599169", "Rogozen",
"3596535", "Kozar\ Belene",
"3596544", "Novachene\,\ Pleven",
"3599729", "Rasovo",
"3596153", "Zlataritsa",
"3598138", "Brashlen",
"3594562", "Kriva\ krusha",
"3596964", "Velchevo\,\ Lovech",
"3593035", "Varbina",
"3593044", "Lyaskovo\,\ Smol\.",
"3595756", "Bozhan",
"3593677", "Drangovo\,\ Kardzh\.",
"3595148", "Rudnik\,\ Varna",
"3595577", "Podvis\,\ Burgas",
"3599132", "Knezha",
"3598442", "Zavet\,\ Razgrad",
"35930205", "Starnitsa",
"3597174", "Kalotina",
"3593143", "Perushtitsa",
"3594580", "Borintsi",
"3593554", "Kozarsko",
"3595918", "Rusokastro",
"35974321", "Harsovo\,\ Blag\.",
"35941358", "Opalchenets",
"3593327", "Bachkovo",
"3598196", "Nisovo",
"3594112", "Badeshte",
"35965165", "Pisarovo\,\ Pleven",
"3593129", "Skutare",
"3595521", "Venets\,\ Burgas",
"35931387", "Prolom",
"35984745", "Vladimirovtsi",
"35961103", "Rusalya",
"3595764", "Vladimirovo\,\ Dobr\.",
"3597717", "Divotino",
"3593708", "Orlovo\,\ Hask\.",
"35930417", "Grohotno",
"35960388", "Goritsa\,\ Targ\.",
"3596956", "Lomets\,\ Lovech",
"3593588", "Menenkyovo",
"3595368", "Takach",
"3597745", "Egalnitsa",
"3597734", "Glavanovtsi\,\ Pernik",
"3594736", "Svetlina",
"3598624", "Kalipetrovo",
"3593120", "Hrabrino",
"3593116", "Krumovo\,\ Plovdiv",
"3596025", "Alvanovo",
"359910", "Mezdra",
"35937424", "Kozlets",
"35959400", "Daskotna",
"3593566", "Boshulya",
"3596718", "Draganovtsi",
"3597042", "Korkina",
"359608", "Popovo\,\ Targ\.",
"3596066", "Buynovo\,\ Targ\.",
"35984720", "Topchii",
"3599720", "Kovachitsa",
"35935392", "Dyulevo\,\ Pazardzhik",
"3596722", "Sokolovo\,\ Gabr\.",
"35947203", "Trankovo\,\ Yambol",
"3596770", "Plachkovtsi",
"3594798", "Savino",
"35931791", "Begovo",
"3596141", "Polski\ Trambesh",
"3594144", "Kovachevo\,\ St\.\ Zagora",
"3597146", "Chernyovo",
"35984266", "Prostorno",
"3597527", "Gorno\ Dryanovo",
"3599160", "Glozhene\,\ Vratsa",
"3594553", "Rakovo\,\ Sliven",
"3594356", "Hadzhidimitrovo\,\ St\.\ Zagora",
"3596002", "Saedinenie\,\ Targ\.",
"35984465", "Savin",
"3598166", "Svalenik",
"3593782", "Kalugerovo\,\ Hask\.",
"3597430", "Damyanitsa",
"3593747", "Tatarevo\,\ Hask\.",
"3599526", "Slatina\,\ Mont\.",
"3594592", "Byala\ palanka",
"3599182", "Devene",
"3593076", "Tsatsarovtsi",
"3599147", "Borovan",
"3593028", "Arda",
"3596528", "Valchitran",
"3596994", "Brestnitsa\,\ Lovech",
"3598125", "Koprivets",
"35974346", "Tsaparevo",
"35961308", "Vishovgrad",
"3596576", "Radomirtsi",
"3599115", "Chiren",
"3593151", "Rakovski\,\ Plovdiv",
"3597920", "Skrinyano",
"3599349", "Slanotran",
"3595559", "Kubadin",
"35942", "Stara\ Zagora",
"3596585", "Belene",
"3597916", "Bagrentsi",
"359724", "Ihtiman",
"3596512", "Gorni\ Dabnik",
"3595124", "Komarevo\,\ Varna",
"3599323", "Drenovets",
"3596911", "Lisets\,\ Lovech",
"3596154", "Buynovtsi",
"3596543", "Muselievo",
"3598667", "Belitsa\,\ Silistra",
"3595727", "Senokos\,\ Dobr\.",
"35969032", "Balgarski\ izvor",
"3593043", "Zmeitsa",
"3596963", "Balkanets",
"3595558", "Debelt",
"3599348", "Negovanovtsi",
"35932", "Plovdiv",
"3593658", "Padina\,\ Kardzh\.",
"35935418", "Krastava",
"3599744", "Valchedram",
"3596529", "Koilovtsi",
"35935255", "Rosen\,\ Pazardzhik",
"3595332", "Dragoevo",
"3593029", "Petkovo\,\ Smol\.",
"35947353", "Balgarska\ polyana",
"35967399", "Malki\ Varshets",
"3593937", "Yabalkovo\,\ Hask\.",
"3595771", "Krushari",
"35974207", "General\ Todorov",
"35931603", "Vinitsa",
"3593553", "Batak\,\ Pazardzhik",
"3593135", "Karnare",
"35961395", "Paskalevets",
"3598640", "Pravda\,\ Silistra",
"35961302", "Batak\,\ V\.\ Tarnovo",
"3594715", "Kalchevo",
"3596030", "Svetlen\,\ Targ\.",
"35984735", "Sveshtari",
"3594747", "Dennitsa\,\ Yambol",
"3593530", "Poibrene",
"35984717", "Pobit\ kamak\,\ Razgrad",
"3594799", "Golyam\ manastir",
"359470", "Topolovgrad",
"359748", "Simitli",
"35960382", "Kovachevets",
"3595517", "Ravnets\,\ Burgas",
"3594566", "Pitovo",
"35941355", "Yavorovo",
"3593634", "Pripek\,\ Kardzh\.",
"3597935", "Dolno\ selo",
"3593645", "Avren\,\ Kardzh\.",
"3595534", "Karageorgievo",
"3595752", "Nova\ Kamena",
"3599355", "Kosovo\,\ Vidin",
"3599136", "Galiche",
"3595140", "Shkorpilovtsi",
"3594363", "Gabarevo",
"3596138", "Nedan",
"35955502", "Suhodol\,\ Burgas",
"3594588", "Filaretovo",
"35991203", "Lik",
"3595910", "Cherni\ vrah\,\ Burgas",
"35974388", "Gorno\ Spanchevo",
"35961703", "Varbitsa\,\ V\.\ Tarnovo",
"3595167", "Venchan",
"3598192", "Hotantsa",
"3594116", "Rakitnitsa\,\ St\.\ Zagora",
"35967393", "Dushevo",
"35931993", "Sarnegor",
"3593589", "Tserovo\,\ Pazardzhik",
"3597137", "Skravena",
"359379", "Svilengrad",
"3597425", "Kulata",
"3594525", "Omarchevo\,\ Sliven",
"3593709", "Karamantsi",
"35941334", "Saedinenie\,\ St\.\ Zagora",
"3594793", "Boyadzhik",
"3593764", "Polyanovo\,\ Hask\.",
"3599514", "Vladimirovo\,\ Mont\.",
"3595120", "Bozveliysko",
"35941356", "Rupkite",
"3595116", "Krumovo\,\ Varna",
"3594369", "Aleksandrovo\,\ St\.\ Zagora",
"3596713", "Vranilovtsi",
"3598159", "Koshov",
"3593625", "Shiroko\ pole",
"3597924", "Shishkovtsi",
"3596990", "Malak\ izvor\,\ Lovech",
"3595525", "Devetak",
"35971228", "Maritsa",
"359558", "Aytos",
"359336", "Parvomay\,\ Plovdiv",
"3596932", "Mikre",
"359570", "Kavarna",
"3594517", "Ichera",
"3596531", "Izgrev\,\ Pleven",
"3593666", "Popsko",
"3597434", "Strumyani",
"3597445", "Banya\,\ Blag\.",
"35981463", "Mogilino",
"3594752", "Parvenets\,\ Yambol",
"3595946", "Tranak",
"35937606", "Shishmanovo",
"35981886", "Chereshovo\,\ Ruse",
"3595363", "Gusla",
"3593583", "Gabrovitsa",
"3594140", "Polski\ Gradets",
"3599164", "Krushovitsa\,\ Vratsa",
"3593703", "Zhalti\ bryag",
"3599328", "Dolni\ Lom",
"3594771", "Malomir\,\ Yambol",
"3596549", "Sanadinovo",
"3599724", "Stanevo",
"3593049", "Beden",
"3596326", "Morava",
"3596969", "Beklemeto",
"35963564", "Bivolare",
"3595715", "Popgrigorovo",
"3599312", "Bregovo\,\ Vidin",
"3596523", "Krushovitsa\,\ Pleven",
"359745", "Petrich\,\ Blag\.",
"3595747", "Vaklino",
"3593023", "Momchilovtsi",
"3595782", "Benkovski\,\ Dobr\.",
"35935256", "Sbor\,\ Pazardzhik",
"3597179", "Golemo\ Malovo",
"3593559", "Kapitan\ Dimitrievo",
"3597753", "Noevtsi",
"3594727", "Malak\ manastir",
"35984736", "Podayva",
"3595760", "Bozhurovo\,\ Dobr\.",
"3598672", "Bradvari",
"35974407", "Kremen\,\ Blag\.",
"3594332", "Vetren\,\ St\.\ Zagora",
"35963572", "Yasen\,\ Pleven",
"3593124", "Kalekovets",
"3598620", "Silistra",
"3597110", "Opitsvet",
"3593727", "Nova\ Nadezhda",
"35964", "Pleven",
"3596121", "Nikyup",
"3595914", "Atia",
"3596986", "Daben",
"3593558", "Isperihovo",
"35952", "Varna",
"3594124", "Zmeyovo",
"3597126", "Gorni\ Okol",
"35984466", "Zvanartsi",
"3597178", "Prolesha",
"3599171", "Oryahovo\,\ Vratsa",
"3597547", "Valkosel",
"3597165", "Milanovo\,\ Sofia",
"359722", "Samokov",
"3595144", "Kamchia",
"3595135", "Stefan\ Karadzha\,\ Varna",
"3595553", "Orlintsi",
"3599343", "Gomotartsi",
"3593653", "Mlechino",
"35959694", "Gaberovo",
"3599546", "Slavotin",
"3596968", "Dobrodan",
"3599127", "Lyutidol",
"35984721", "Lipnik",
"3598117", "Marten",
"35963578", "Opanets\,\ Pleven",
"3596548", "Debovo",
"359605", "Omurtag",
"3596177", "Yantra\,\ V\.\ Tarnovo",
"3598145", "Trastenik\,\ Ruse",
"3595530", "Peshtersko",
"3598134", "Malko\ Vranovo",
"3599329", "Rabisha",
"3597057", "Malo\ selo",
"3593517", "Lesichovo",
"35937704", "Mladinovo",
"3596900", "Vasilyovo",
"3596034", "Slavyanovo\,\ Targ\.",
"3593752", "Malko\ gradishte",
"3593534", "Popintsi",
"3593545", "Draginovo",
"3595311", "Gradishte\,\ Shumen",
"359701", "Dupnitsa",
"35941279", "Strelets\,\ St\.\ Zagora",
"3597725", "Klenovik",
"3595394", "Byala\ reka\,\ Shumen",
"35931394", "Vasil\ Levski\,\ Plovdiv",
"3598635", "Tsar\ Samuil",
"3598644", "Chernolik",
"3594583", "Kipilovo",
"3596133", "Mihaltsi",
"3598158", "Mechka\,\ Ruse",
"35951537", "Chernevo",
"3594764", "Malenovo",
"359750", "Borovets\,\ Sofia",
"35935502", "Fotinovo\,\ Pazardzhik",
"3599740", "Septemvriytsi\,\ Mont\.",
"3594368", "Tarnicheni",
"35960373", "Posabina",
"3596555", "Baykal",
"35991184", "Rakevo",
"3593055", "Elhovets",
"3595736", "Vasilevo",
"3596150", "Zlataritsa",
"3593167", "Bryagovo\,\ Plovdiv",
"3593926", "Dobrich\,\ Hask\.",
"35995277", "Cherkaski",
"359579", "Albena",
"3595589", "Vinarsko",
"3599723", "Traykovo",
"3595128", "Zhitnitsa\,\ Varna",
"3596159", "Zlataritsa",
"3595580", "Troyanovo\,\ Burgas",
"3598184", "Glodzhevo",
"3595112", "Beloslav",
"3596524", "Petarnitsa",
"3599749", "Cherni\ vrah\,\ Mont\.",
"35974386", "Pirin",
"3596998", "Golyam\ izvor\,\ Lovech",
"35971225", "Novo\ selo\,\ Sofia",
"3593024", "Taran",
"35977229", "Galabnik",
"3593347", "Lenovo",
"35941337", "Sarnevets",
"3593662", "Zhelezino",
"3593149", "Tsalapitsa",
"3593641", "Krumovgrad",
"3599351", "Izvor\,\ Vidin",
"3597754", "Kosharevo",
"3594756", "Polyana\,\ Yambol",
"3597532", "Bukovo\,\ Blag\.",
"3595942", "Lyulyakovo\,\ Burgas",
"3596909", "Malka\ Zhelyazna",
"35931700", "Belovitsa",
"3593123", "Kaloyanovo\,\ Plovdiv",
"3593763", "Balgarin",
"3595775", "Polkovnik\ Dyakovo",
"3594794", "Ovchi\ kladenets",
"3593639", "Nanovitsa\,\ Kardzh\.",
"3599320", "Stakevtsi",
"3595539", "Chernograd",
"3596322", "Alekovo\,\ V\.\ Tarnovo",
"3599513", "Boychinovtsi",
"3599316", "Novo\ selo\,\ Vidin",
"3593197", "Tyurkmen",
"3596737", "Krushevo\,\ Gabr\.",
"3594711", "Bezmer\,\ Yambol",
"3597923", "Vrattsa",
"3596714", "Popovtsi",
"3597433", "Kresna",
"3594155", "Glavan\,\ St\.\ Zagora",
"3594107", "Sredets\,\ St\.\ Zagora",
"3598676", "Vetren\,\ Silistra",
"3594336", "Dolno\ Izvorovo",
"3598628", "Tsar\ Asen\,\ Silistra",
"3597119", "Dramsha",
"359631", "Svishtov",
"35974204", "Gega",
"3595768", "Odrintsi\,\ Dobr\.",
"3593704", "Bryagovo\,\ Hask\.",
"3599163", "Harlets",
"3593584", "Vetren\,\ Pazardzhik",
"35960458", "Verentsi",
"3596033", "Medovina",
"3593696", "Pchelarovo\,\ Kardzh\.",
"35963575", "Bohot",
"3595769", "Hitovo",
"359339", "Stamboliyski\,\ Plovdiv",
"35941113", "Pryaporets\,\ St\.\ Zagora",
"3599111", "Chelopek",
"3597118", "Dragovishtitsa\,\ Sofia",
"3598629", "Smilets\,\ Silistra",
"3593107", "Graf\ Ignatievo",
"3593155", "Momino\ selo",
"35984", "Razgrad",
"35961502", "Gorsko\ Novo\ Selo",
"3593533", "Bata",
"35974348", "Igralishte",
"35961306", "Patresh",
"3596581", "Byala\ voda\,\ Pleven",
"3596982", "aglen",
"3594584", "Ticha",
"3596915", "Smochan",
"3598643", "Zlatoklas",
"3596567", "Somovit",
"35951125", "Konstantinovo\,\ Varna",
"3595393", "Ivanovo\,\ Shumen",
"35931402", "Skobelevo\,\ Plovdiv",
"3594763", "Irechekovo",
"3596145", "Strahilovo",
"3596134", "Byala\ cherkva\,\ V\.\ Tarnovo",
"3596117", "Debelets\,\ V\.\ Tarnovo",
"3596540", "Asenovo\,\ Pleven",
"3593711", "Dolno\ Botevo",
"3599542", "Smolyanovtsi",
"3595352", "Yankovo",
"35984761", "Gradina\,\ Razgrad",
"3595538", "Karanovo\,\ Burgas",
"3593638", "Zvezdel",
"3596960", "Belish",
"3599561", "Sumer",
"3593040", "Trigrad",
"3594347", "Rozovo\,\ St\.\ Zagora",
"3593756", "Valche\ pole",
"35984393", "Vazovo",
"359391", "Dimitrovgrad",
"3594149", "Trankovo\,\ St\.\ Zagora",
"3596908", "Glogovo",
"3595913", "Krushevets",
"3593148", "Yoakim\ Gruevo",
"35930414", "Devin",
"35971798", "Vasilovtsi\,Sof\.",
"3596077", "Stevrek",
"35969614", "Gorno\ trape",
"3597105", "Malki\ Iskar",
"3597157", "Sarantsi",
"359707", "Sapareva\ banya",
"3594123", "Bogomilovo",
"35996", "Montana",
"35930457", "Kasak",
"3599344", "Vrav",
"3598150", "Semerdzhievo",
"3595554", "Momina\ tsarkva",
"3595732", "Petleshkovo",
"3599335", "Tsar\ Petrovo",
"3597741", "Zemen",
"3599748", "Dalgodeltsi",
"3595143", "Byala\,\ Varna",
"35941119", "Elhovo\,\ St\.\ Zagora",
"3596021", "Buhovtsi",
"3595327", "Kaspichan\,\ Shumen",
"3593922", "Brod",
"3596158", "Sredni\ kolibi",
"3598133", "Ryahovo",
"35960386", "Voditsa\,\ Targ\.",
"3593521", "Zvanichevo",
"3595129", "Blaskovo",
"3596565", "Milkovitsa",
"3596917", "Balgarene\,\ Lovech",
"3594358", "Skobelevo\,\ St\.\ Zagora",
"3594754", "Kamenets\,\ Yambol",
"35963563", "Borislav",
"3596934", "Katunets",
"35971337", "Kalugerovo\,\ Sofia",
"3593105", "Manolsko\ Konare",
"3598431", "Isperih",
"3593157", "Bolyarino",
"3599162", "Mihaylovo\,\ Vratsa",
"3599141", "Malorad",
"3597148", "Muhovo",
"35969031", "Galata",
"35984766", "Kamenar\,\ Razgrad",
"3593741", "Mandra",
"3599512", "Beli\ breg",
"35967774", "Belitsa\,\ Gabr\.",
"3596510", "Totleben",
"3597918", "Yabalkovo\,\ Kyust\.",
"3596323", "Balgarsko\ slivovo",
"3593762", "Izvorovo\,\ Hask\.",
"3597521", "Koprivlen",
"3599528", "Gaganitsa",
"3596115", "Resen",
"3597922", "Dragovishtitsa\,\ Kyust\.",
"3593026", "Smilyan",
"35961301", "Byala\ reka\,\ V\.\ Tarnovo",
"3599180", "Golyamo\ Peshtene",
"3596526", "Varbitsa\,\ Pleven",
"3596147", "Ivancha\,\ V\.\ Tarnovo",
"3596578", "Reselets",
"3595943", "Vresovo",
"359610", "Pavlikeni\,\ V\.\ Tarnovo",
"3597533", "Osikovo\,\ Blag\.",
"3593118", "Sadovo\,\ Plovdiv",
"3597155", "Lesnovo",
"3593706", "Tankovo\,\ Hask\.",
"359538", "Veliki\ Preslav",
"3593586", "Borimechkovo",
"3595366", "Branichevo",
"3596958", "Apriltsi\,\ Lovech",
"3593122", "Manole",
"35941480", "Kolarovo\,\ St\.\ Zagora",
"3594738", "Hlyabovo",
"3598674", "Profesor\ Ishirkovo",
"3594334", "Elhovo\,\ St\.\ Zagora\,\ mun\.\ Nikolaevo",
"359971", "Lom",
"3594345", "Raduntsi",
"35981464", "Ostritsa\,\ Ruse",
"35963570", "Staroseltsi",
"35961107", "Momin\ sbor",
"3596720", "Kereka",
"3599722", "Staliyska\ mahala",
"3594796", "General\ Toshevo\,\ Yambol",
"35963569", "Kamenets\,\ Pleven",
"3595325", "Voyvoda",
"3599337", "Gramada",
"3593568", "Vinogradets",
"3596716", "Zhaltesh",
"3595784", "Vrachantsi",
"3599314", "Dunavtsi\,\ Vidin",
"3599139", "Tarnava\,\ Vratsa",
"3597711", "Kladnitsa",
"3596068", "Bozhurka",
"3596069", "Vasil\ Levski\,\ Targ\.",
"3599719", "Asparuhovo\,\ Mont\.",
"3595142", "Dolni\ chiflik",
"3595733", "Kardam\,\ Dobr\.",
"3599138", "Altimir",
"35991888", "Veslets\,\ Vratsa",
"35937703", "Dimitrovche",
"3598448", "Terter",
"3595161", "Vetrino",
"35974325", "Lilyanovo",
"35947193", "Mogila\,\ Yambol",
"3593569", "Karabunar",
"3596136", "Suhindol",
"35931393", "Voynyagovo",
"3595750", "Kableshkovo\,\ Dobr\.",
"3598132", "Yudelnik",
"3593923", "Radievo",
"35967307", "Mlechevo",
"35961605", "Novo\ gradishte",
"359619", "Lyaskovets\,\ V\.\ Tarnovo",
"359373", "Harmanli",
"35935391", "Blatnitsa",
"3594118", "Pamukchii\,\ St\.\ Zagora",
"3594739", "Radovets",
"3596959", "Debnevo",
"35991668", "Manastirishte",
"35960374", "Gorsko\ Ablanovo",
"35991183", "Furen",
"3594586", "Neykovo\,\ Sliven",
"359746", "Sandanski",
"3594122", "Elenino",
"3595511", "Lukoil\ Neftochim",
"3593345", "Lyaskovo\,\ Plovdiv",
"3593119", "Galabovo\,\ Plovdiv",
"3595912", "Polski\ izvor",
"35961203", "Emen",
"35975215", "Teshovo",
"3596579", "Ruptsi\,\ Pleven",
"3599346", "Sinagovtsi",
"3595556", "Golyamo\ Bukovo",
"359335", "Karlovo",
"3594741", "Bolyarovo",
"35991189", "Tri\ kladentsi",
"3594762", "Vodenichane",
"3593195", "Rozovets",
"3595330", "Zlatar",
"3599529", "Borovtsi",
"3593079", "Kozarka",
"35931792", "Chernichevo\,\ Plovdiv",
"35931705", "Gorna\ mahala",
"35953234", "Zlatna\ niva",
"3595353", "Veselinovo\,\ Shumen",
"3593754", "Lozen\,\ Hask\.",
"3593532", "Strelcha",
"35971304", "Lipnitsa\,\ Sofia",
"3593931", "Kasnakovo",
"3597149", "Zhivkovo\,\ Sofia",
"3596032", "Zaraevo",
"35969247", "Gostinya",
"3595392", "Mengishevo",
"35941274", "Samuilovo\,\ St\.\ Zagora",
"35971220", "Gutsal",
"3598642", "Dulovo",
"35931108", "Bogdanitsa",
"3594105", "Byalo\ pole",
"3594157", "Razdelna\,\ St\.\ Zagora",
"3597123", "Kovachevtsi\,\ Sofia",
"3596983", "Dermantsi",
"3598661", "Tutrakan",
"3594359", "Asen\,\ St\.\ Zagora",
"3597436", "Levunovo",
"3597752", "Rezhantsi",
"3597545", "Kochan",
"3595944", "Ruen\,\ Burgas",
"359301", "Smolyan",
"3594350", "Gorno\ Izvorovo",
"35951106", "Osenovo\,\ Varna",
"3593664", "Plevun",
"35931309", "Kliment\,\ Plovdiv",
"3599166", "Hayredin",
"359749", "Bansko",
"3593725", "Stamboliyski\,\ Hask\.",
"35971587", "Golema\ Rakovitsa",
"3594333", "Dabovo\,\ St\.\ Zagora",
"3598673", "Alfatar",
"35984726", "Ushintsi",
"3596168", "Sushitsa\,\ V\.\ Tarnovo",
"3599516", "Lehchevo",
"3596175", "Parvomaytsi",
"35931702", "Dolna\ mahala\,\ Plovdiv",
"3598147", "Baniska",
"3598424", "Tsar\ Kaloyan\,\ Razgrad",
"3596518", "Riben",
"3597910", "Bersin",
"35984713", "Blagoevo\,\ Razgrad",
"3598115", "Chervena\ voda",
"3599125", "Gorna\ Beshovitsa",
"359350", "Peshtera\,\ Pazardzhik",
"3593766", "Biser",
"35974203", "Rupite",
"3595783", "Kotlentsi",
"3595137", "Kaloyan",
"3599188", "Gorno\ Peshtene",
"3597181", "Pirdop",
"35959406", "Razboyna\,\ Burgas",
"3593022", "Vievo",
"3597926", "Konyavo",
"3596570", "Deventsi",
"3595114", "Ezerovo\,\ Varna",
"3597167", "Tserovo\,\ Sofia",
"3599520", "Gorno\ Ozirovo",
"3596522", "Zgalevo",
"35951428", "Gospodinovo\,\ Varna",
"3596921", "Ablanitsa\,\ Lovech",
"3599313", "Kapitanovtsi",
"3594753", "Zornitsa\,\ Yambol",
"3597727", "Kovachevtsi\,\ Pernik",
"35984719", "Balkanski",
"3598637", "Malak\ Preslavets",
"3593110", "Popovitsa",
"3596933", "Golets",
"3593178", "Krasnovo",
"3593547", "Sarnitsa\,\ Pazardzhik",
"3594730", "Knyazhevo",
"3593702", "Tsareva\ polyana",
"3593126", "Trud",
"3595362", "Kliment\,\ Shumen",
"3593582", "Momina\ klisura",
"3595341", "Hitrino",
"3599551", "Georgi\ Damyanovo",
"3593515", "Kalugerovo\,\ Pazardzhik",
"3596047", "Zelena\ morava",
"3596950", "Gumoshtnik",
"3598691", "Silistra",
"35967397", "Ryahovtsite",
"3596324", "Vardim",
"3595759", "Kochmar",
"35931997", "Zlatosel",
"3596728", "Burya",
"3594321", "Maglizh",
"35961602", "Tsarski\ izvor",
"3594792", "Botevo\,\ Yambol",
"3593165", "Karadzhalovo",
"3599726", "Zamfir",
"3593057", "Plovdivtsi",
"3596712", "Gabene",
"3596060", "Ovcharovo\,\ Targ\.",
"35974322", "Petrovo\,\ Blag\.",
"3597048", "Blazhievo",
"3596557", "Bregare",
"3595146", "Goren\ chiflik",
"35984394", "Duhovets",
"3595527", "Sokolovo\,\ Burgas",
"3593321", "Topolovo\,\ Plovdiv",
"3599130", "Tlachene",
"3596132", "Karaisen",
"35930413", "Devin",
"35969613", "Chiflik\,\ Lovech",
"3598136", "Stambolovo\,\ Ruse",
"359417", "Radnevo",
"3595354", "Rish",
"3599544", "Studeno\ buche",
"35941146", "Hristianovo",
"3595758", "Kladentsi",
"35941351", "Partizanin",
"3593753", "Oryahovo\,\ Hask\.",
"35960450", "Dolna\ Hubavka",
"3595571", "Sungurlare",
"35961608", "Gorski\ Senovets",
"3593671", "Podkova",
"3594126", "Hrishteni",
"3597447", "Dobrinishte",
"3597124", "Belchinski\ bani",
"3594582", "Gradets\,\ Sliven",
"3597415", "Selishte\,\ Blag\.",
"3595916", "Rosen\,\ Burgas",
"3596984", "Bezhanovo\,\ Lovech",
"3594515", "Mokren",
"3593652", "Byal\ izvor\,\ Kardzh\.",
"3595745", "Vranino",
"3599342", "Inovo",
"3595734", "Preselentsi",
"3595552", "Dyulevo\,\ Burgas",
"3595338", "Troitsa",
"3595717", "Vedrina",
"359478", "Elhovo\,\ Yambol",
"3594599", "Chervenakovo",
"3599189", "Pavolche",
"35941114", "Lozen\,\ St\.\ Zagora",
"35961391", "Slomer",
"3593924", "Krepost",
"35953437", "Gabritsa\,\ Shumen",
"3596519", "Beglezh",
"3593019", "Pisanitsa",
"3593536", "Banya\,\ Pazardzhik",
"35931708", "Pesnopoy\,\ Plovdiv",
"3596169", "Blagoevo\,\ V\.\ Tarnovo",
"3597031", "Gorna\ Koznitsa",
"3593693", "Lyaskovo\,\ Kardzh\.",
"3596036", "Sadina",
"3595101", "Dabravino",
"3595396", "Lovets\,\ Shumen",
"3594725", "Lesovo",
"35935251", "Bratanitsa",
"3598646", "Vokil",
"35957306", "Izvorovo\,\ Dobr\.",
"359359", "Velingrad",
"35930419", "Yagodina",
"35953223", "Tsarkvitsa",
"3593935", "Varbitsa\,\ Hask\.",
"3599318", "Bukovets\,\ Vidin",
"3596064", "Golyamo\ Novo",
"3593564", "Semchinovo",
"3599183", "Lilyache",
"3594593", "Shivachevo",
"3594101", "Opan",
"3599322", "Oreshets\,\ Vidin",
"3596513", "Pordim",
"35951539", "Levski\,\ Varna",
"35984774", "Golyam\ izvor\,\ Razgrad",
"3598665", "Iskra\,\ Silistra",
"3598678", "Sratsimir\,\ Silistra",
"3594745", "Sharkovo",
"3594734", "Srem",
"3594552", "Stara\ reka\,\ Sliven",
"3596163", "Kamen\,\ V\.\ Tarnovo",
"35941350", "Mirovo\,\ St\.\ Zagora",
"3598626", "Sredishte\,\ Silistra",
"3594338", "Kran",
"3595766", "Metodievo\,\ Dobr\.",
"359550", "Sozopol",
"35941277", "Zagore",
"3594717", "Chargan",
"35969244", "Tepava",
"35960451", "Obitel",
"3595599", "Hadzhiite",
"3596954", "Vrabevo",
"3593699", "Gabrovo\,\ Kardzh\.",
"3593191", "Brezovo\,\ Plovdiv",
"35931401", "Kadievo",
"3593783", "Svirkovo",
"3593137", "Klisura\,\ Plovdiv",
"3593114", "Brestnik",
"3596003", "Preselets",
"35957305", "Rositsa\,\ Dobr\.",
"3596574", "Chomakovtsi",
"3597043", "Golemo\ selo",
"3599524", "Yagodovo\,\ Mont\.",
"3593074", "Erma\ reka",
"35967304", "Kramolin",
"3595126", "Cherkovna\,\ Varna",
"35941145", "Arnautito",
"3593647", "Chernichevo\,\ Kardzh\.",
"3597937", "Razhdavitsa",
"3596723", "Tsareva\ livada",
"35984730", "Golyam\ Porovets",
"3595515", "Kameno",
"3593341", "Konush\,\ Plovdiv",
"3597914", "Vaksevo",
"3595967", "Bata",
"3597427", "Parvomay\,\ Blag\.",
"3594146", "Dinya",
"3597144", "Kostenets",
"3597135", "Trudovets",
"3593759", "Borislavtsi",
"3594527", "Zagortsi\,\ Sliven",
"3595165", "Nevsha",
"3593173", "Panicheri",
"3596938", "Kalenik\,\ Lovech",
"359517", "Dalgopol",
"35931324", "Mrachenik",
"35960377", "Aprilovo\,\ Targ\.",
"3594354", "Zimnitsa\,\ St\.\ Zagora",
"3598164", "Pisanets",
"359915", "Byala\ Slatina",
"3593527", "Aleko\ Konstantinovo",
"3593146", "Kurtovo\ Konare",
"35974409", "Mesta",
"359702", "Bobov\ dol",
"3595321", "Praventsi",
"3596027", "Dralfa",
"3596939", "Dragana",
"35941179", "Han\ Asparuhovo",
"3597715", "Studena\,\ Pernik",
"3593758", "Yerusalimovo",
"3596906", "Cherni\ Vit",
"35963205", "Chervena",
"3595753", "Orlyak",
"3593920", "Zlatopole",
"3596071", "Antonovo",
"3596156", "Rodina",
"3598152", "Krasen\,\ Ruse",
"35961104", "Vodoley",
"3594362", "Manolovo",
"3594341", "Cherganovo",
"35966", "Gabrovo",
"3599746", "Razgrad\,\ Mont\.",
"3599567", "Dolna\ Verenitsa",
"3597120", "Dolna\ banya",
"3593745", "Malak\ izvor\,\ Hask\.",
"3593552", "Bratsigovo",
"35971504", "Belopoptsi",
"3593717", "Konush\,\ Hask\.",
"3596980", "Belentsi",
"3597172", "Dragoman",
"3596111", "Kapinovo\,\ V\.\ Tarnovo",
"3594137", "Veren",
"3597525", "Banichan",
"35984725", "Kichenitsa",
"3594339", "Yulievo",
"3597116", "Petarch",
"3598679", "Kaynardzha",
"35974403", "Dolno\ Draglishte",
"35984768", "Sinya\ voda",
"3596962", "Cherni\ Osam",
"3596561", "Gulyantsi",
"3593042", "Borino",
"3593636", "Raven",
"3595536", "Maglen",
"3599540", "Belotintsi",
"3596542", "Vabel\,\ Pleven",
"359721", "Kostinbrod",
"3596587", "Petokladentsi",
"3594564", "Novoselets",
"3596941", "Letnitsa",
"359559", "Karnobat",
"3593101", "Voyvodinovo",
"3599117", "Krivodol",
"3598127", "Karamanovo",
"35941173", "Bratya\ Kunchevi",
"3595333", "Han\ Krum",
"35959405", "Zaychar",
"3599319", "Gamzovo",
"3599134", "Tarnak",
"3599145", "Brenitsa\,\ Vratsa",
"3597035", "Cherven\ breg",
"3597044", "Babino",
"3596573", "Koynare",
"35930200", "Zagrazhden\,\ Smol\.",
"35957308", "Chernookovo\,\ Dobr\.",
"35953434", "Yasenkovo",
"3593073", "Startsevo",
"3599523", "Barzia",
"3599326", "Gorni\ Lom",
"3595105", "Priseltsi\,\ Varna",
"35941117", "Kazanka",
"359861", "Silistra",
"3596328", "Oresh",
"3597913", "Rashka\ Grashtitsa",
"35984740", "Bisertsi",
"35930459", "Brashten",
"3596724", "Yantra\,\ Gabr\.",
"3599549", "Dolna\ Riksa",
"35931706", "Suhozem",
"3597732", "Vukan",
"3594556", "Sotirya",
"35984722", "Yasenovets",
"3598622", "Alekovo\,\ Silistra",
"3597143", "Vakarel",
"3595762", "Stefan\ Karadzha\,\ Dobr\.",
"3598670", "Silistra",
"3593174", "Staro\ Zhelezare",
"3594330", "Nikolaevo\,\ St\.\ Zagora",
"3597129", "Raduil",
"3598163", "Bazan",
"3596989", "Toros",
"3594777", "Tenevo",
"3594353", "Srednogorovo",
"3596591", "Gornik",
"3596063", "Bayachevo",
"3595118", "Voditsa\,\ Varna",
"3596992", "Zlatna\ Panega",
"3595739", "Pchelarovo\,\ Dobr\.",
"3595575", "Prilep\,\ Burgas",
"3599184", "Ohoden",
"3593675", "Fotinovo\,\ Kardzh\.",
"3593563", "Varvara\,\ Pazardzhik",
"35961606", "Vladislav",
"3596514", "Dolni\ Dabnik",
"3595122", "Slaveykovo\,\ Varna",
"359556", "Obzor",
"3593929", "Golyamo\ Asenovo",
"35937423", "Golemantsi",
"3593037", "Sivino",
"3596537", "Asenovtsi",
"3594511", "Slivenski\ mineralni\ bani",
"3594142", "Troyanovo\,\ St\.\ Zagora",
"3596164", "Bryagovitsa",
"3594733", "Orlov\ dol",
"3593325", "Cherven\,\ Plovdiv",
"3596953", "Borima",
"35963202", "Dragomirovo\,\ V\.\ Tarnovo",
"35961403", "Orlovets",
"3593784", "Konstantinovo\,\ Hask\.",
"35947204", "Pchela",
"35935501", "Ravnogor",
"35971221", "Yarlovo",
"3596930", "Slavshtitsa",
"3596004", "Makovo",
"3593113", "Branipole",
"3595948", "Snyagovo\,\ Burgas",
"3595949", "Planinitsa\,\ Burgas",
"3593142", "Brestovitsa\,\ Plovdiv",
"3594325", "Kanchevo",
"3596902", "Ribaritsa\,\ Lovech",
"3594113", "Preslaven",
"35961704", "Pravda\,\ V\.\ Tarnovo",
"3596152", "Bebrovo",
"35941018", "Knyazhevsko",
"3593928", "Dolno\ Belevo",
"3598156", "Cherven\,\ Ruse",
"35981264", "Piperkovo",
"35941333", "Sredno\ gradishte",
"3595317", "Ivanski",
"3595738", "Spasovo\,\ Dobr\.",
"3599133", "Komarevo\,\ Vratsa",
"3599787", "Smirnenski\,\ Mont\.",
"3598695", "Nozharevo",
"35967394", "Bogatovo",
"3595119", "Ignatievo",
"3595334", "Osmar",
"3599742", "Yakimovo",
"3593511", "Ognyanovo\,\ Pazardzhik",
"3599555", "Kopilovtsi\,\ Mont\.",
"3595345", "Razvigorovo",
"3593556", "Radilovo",
"3596988", "Peshterna",
"35994", "Vidin",
"3598111", "Shtraklevo",
"3599121", "Tsarevets\,\ Vratsa",
"35959408", "Razhitsa",
"3597176", "Hrabarsko",
"35947354", "Kamenna\ reka",
"3597185", "Chelopech",
"35960380", "Drinovo",
"35984765", "Veselina",
"3593777", "Mezek",
"3596925", "Vladinya",
"3598194", "Sandrovo",
"3595590", "Zhitosvyat",
"35941339", "Dimitrievo",
"3596966", "Shipkovo",
"35984728", "Rakovski\,\ Razgrad",
"35963571", "Brestovets",
"3599548", "Krapchene",
"3597541", "Satovcha",
"3593046", "Barutin",
"3593632", "Dzhebel",
"3596329", "Tsarevets\,\ V\.\ Tarnovo",
"3595754", "Zarnevo",
"3595532", "Topolitsa",
"3596546", "Lozitsa\,\ Pleven",
"35931604", "Dragoynovo",
"3593721", "Stambolovo\,\ Hask\.",
"35951108", "Izvorsko",
"35968", "Lovech",
"359727", "Slivnitsa\,\ Sofia",};
$areanames{bg} = {"3599353", "Кошава",
"35984769", "Гороцвет",
"3597933", "Грамаждано",
"3593643", "Голяма\ Чинка",
"35941335", "Могилово",
"35937604", "Върбово\,\ Хаск\.",
"3596727", "Ганчовец",
"3593629", "Мост",
"3599330", "Раброво",
"3593121", "Рогош",
"3595529", "Крушово\,\ Бургас",
"3597047", "Усойка",
"35934", "Пазарджик",
"3596558", "Славовица\,\ Плевен",
"3593058", "Мугла",
"3598696", "Суходол\,\ Силистра",
"3599556", "Говежда",
"3595346", "Каменяк\,\ Шумен",
"3599721", "Долно\ Церовене",
"3597728", "Друган",
"3594326", "Енина",
"3598638", "Богданци\,\ Силистра",
"3594774", "Крумово\,\ Ямбол",
"35941354", "Малко\ Тръново",
"3594523", "Стоил\ войвода",
"3597423", "Коларово\,\ Благ\.",
"3596048", "Изворово\,\ Търг\.",
"35969240", "Хлевене",
"3593177", "Ново\ Железаре",
"3597712", "Батановци",
"35971227", "Бели\ Искър",
"3593548", "Пашово",
"3596965", "Бели\ Осъм",
"3596517", "Подем",
"3593045", "Доспат",
"359728", "Златица",
"3593034", "Левочево",
"359751", "Гоце\ Делчев",
"3596545", "Любеново\,\ Плевен",
"3596534", "Малчика",
"35984734", "Тодорово\,\ Разград",
"3598148", "Горно\ Абланово",
"3597168", "Бов",
"3599161", "Мизия",
"3594597", "Боров\ дол",
"3599187", "Лютаджик",
"3595138", "Добротич",
"35941111", "Старозагорски\ бани",
"35961394", "Дъскот",
"359697", "Луковит",
"3595719", "Дончево",
"3599142", "Лазарово",
"35935254", "Добровница",
"3596910", "Малиново",
"3593787", "Тянево\,\ Хаск\.",
"3593133", "Калофер",
"3593555", "Нова\ махала\,\ Пазарджик",
"35984763", "Бели\ Лом",
"35974408", "Обидим",
"3596007", "Ралица",
"3597175", "Габер",
"3597921", "Жиленци",
"35941178", "Оряховица\,\ Ст\.\ Загора",
"35963566", "Бръшляница",
"3597186", "Антон",
"3597522", "Дъбница",
"3596167", "Кесарево",
"3596926", "Горно\ Павликене",
"3594713", "Стара\ река\,\ Ямбол",
"3594742", "Стефан\ Караджово",
"359938", "Кула",
"3594761", "Стралджа",
"35977221", "Кондофрей",
"3593713", "Динево",
"3593932", "Бодрово",
"35967194", "Гръблевци",
"3597036", "Баланово",
"3598123", "Босилковци",
"3595718", "Смолница",
"3599113", "Мраморен",
"3595314", "Белокопитово",
"3595139", "Оборище\,\ Варна",
"35984464", "Веселец\,\ Разград",
"35974495", "Юруково",
"35974402", "Годлево",
"3599784", "Киселево",
"3595337", "Кочово",
"3597169", "Томпсън",
"35963577", "Пелишат",
"3598641", "Окорш",
"3598149", "Кацелово",
"35951127", "Разделна\,\ Варна",
"35941172", "Горно\ Ботево",
"3599325", "Бело\ поле\,\ Видин",
"3595106", "Аврен\,\ Варна",
"3595391", "Върбица\,\ Шумен",
"3596583", "Белене",
"3598662", "Добротица\,\ Силистра",
"3597132", "Радотина",
"3593549", "Грашево",
"3597743", "Дивля",
"3595141", "Старо\ Оряхово",
"3593326", "Патриарх\ Евтимово",
"3595162", "Белоградец",
"3596049", "Камбурово",
"3593774", "Левка",
"3598131", "Борисово\,\ Русе",
"3598639", "Коларово\,\ Силистра",
"35961405", "Петко\ Каравелово",
"35930256", "Гълъбово\,\ Смол\.",
"3597729", "Долна\ Диканя",
"3593523", "Синитево",
"3596023", "Подгорица",
"35991186", "Баурене",
"3597448", "Бачево",
"3593059", "Кутела",
"35931396", "Домлян",
"3595576", "Лозарево",
"3593676", "Бенковски\,\ Кърдж\.",
"3596559", "Гостиля",
"3595528", "Невестино\,\ Бургас",
"359337", "Хисаря",
"3593628", "Миладиново",
"3599174", "Горни\ Вадин",
"3595757", "Безмер\,\ Добр\.",
"3594121", "Люляк",
"35944", "Сливен",
"3598475", "Лозница\,\ Разград",
"35951538", "Изгрев\,\ Варна",
"359454", "Твърдица\,\ Сливен",
"35937706", "Чернодъб",
"3596124", "Леденик",
"35984729", "Езерче",
"35984744", "Беловец",
"3596155", "Константин",
"3596533", "Стежерово",
"3593581", "Белово",
"3595361", "Каолиново",
"3593050", "Букова\ поляна",
"3596067", "Кралево\,\ Търг\.",
"3593701", "Елена\,\ Хаск\.",
"3593567", "Ковачево\,\ Пазарджик",
"3599338", "Шишенци",
"3598692", "Стефан\ Караджа\,\ Силистра",
"3596550", "Ставерци",
"359431", "Казанлък",
"3599745", "Златия\,\ Монт\.",
"3599552", "Белимел",
"3595342", "Капитан\ Петко",
"35937422", "Долни\ Главанак",
"35963203", "Хаджидимитрово\,\ В\.\ Търново",
"3597720", "Прибой",
"3593134", "Сопот\,\ Пловдив",
"3593145", "Кричим",
"3598630", "Силистра",
"35961402", "Стефан\ Стамболово",
"35959409", "Череша",
"3593117", "Катуница",
"3594322", "Ягода",
"3596711", "Кози\ рог",
"3594737", "Синапово",
"35935394", "Оборище\,\ Пазарджик",
"35951314", "Войводино",
"3594714", "Дражево",
"3596957", "Голяма\ Желязна",
"3596905", "Дивчовото",
"35941338", "Целина",
"3597751", "Брезник",
"3595153", "Суворово",
"3593644", "Егрек",
"35959403", "Речица",
"3597934", "Буново\,\ Кюст\.",
"3598140", "Борово\,\ Русе",
"3599354", "Антимово\,\ Видин",
"35941175", "Колена",
"3595535", "Лясково\,\ Бургас",
"35941019", "Венец\,\ Ст\.\ Загора",
"3597917", "Таваличево",
"3595130", "Генерал\ Киселово",
"3596148", "Павел",
"3596577", "Бресте",
"3599527", "Вършец",
"3593077", "Средец\,\ Смол\.",
"3599146", "Соколаре",
"35974405", "Краище\,\ Благ\.",
"3593746", "Сираково\,\ Хаск\.",
"3594773", "Окоп",
"35984723", "Дянково",
"3594357", "Горно\ Сахране",
"3596918", "Дренов",
"3598167", "Церовец",
"3597424", "Кърналово",
"3597147", "Пчелин\,\ София",
"3597526", "Рибново",
"3594524", "Каменово\,\ Сливен",
"3597182", "Мирково",
"35951103", "Любен\ Каравелово",
"3596922", "Лешница\,\ Ловеч",
"3596521", "Садовец",
"3597735", "Лева\ река",
"3597744", "Еловдол\,\ Перник",
"3594746", "Попово\,\ Ямбол",
"3595952", "Малко\ Търново",
"35941149", "Ловец\,\ Ст\.\ Загора",
"3593159", "Белозем",
"3598625", "Овен",
"3593651", "Ардино",
"3599341", "Димово\,\ Видин",
"3595551", "Средец\,\ Бургас",
"3595765", "Ловчанци",
"35974347", "Раздол",
"3593773", "Капитан\ Андреево",
"3593524", "Априлци\,\ Пазарджик",
"3596919", "Слатина\,\ Ловеч",
"3596024", "Руец",
"3594158", "Искрица",
"3597032", "Яхиново",
"3593936", "Горски\ извор\,\ Хаск\.",
"35967390", "Шумата",
"3595710", "Победа\,\ Добр\.",
"3596149", "Куцина",
"35961304", "Димча",
"3595726", "Царичино",
"3595102", "Падина\,\ Варна",
"35943616", "Турия",
"3599173", "Галово",
"3596123", "Буковец\,\ В\.\ Търново",
"359868", "Силистра",
"3598666", "Тутракан",
"3597136", "Новачене\,\ София",
"3594134", "Братя\ Даскалови",
"3594145", "Знаменосец",
"35960384", "Гагово",
"3595166", "Доброплодно",
"3593322", "Златовръх",
"359518", "Провадия",
"3599564", "Стубел",
"35955504", "Богданово\,\ Бургас",
"35969616", "Старо\ село\,\ Ловеч",
"3595313", "Мадара",
"3595520", "Черково",
"3598124", "Новград",
"35930416", "Гьоврен",
"3599339", "Макреш",
"3595572", "Бероново",
"35991401", "Враняк",
"3593672", "Чорбаджийско",
"3599137", "Попица",
"3599783", "Брусарци",
"359723", "Ботевград",
"35981461", "Каран\ Върбовка",
"3595125", "Градинарово",
"359331", "Асеновград",
"35941332", "Найденово",
"3595516", "Индже\ войвода",
"35930458", "Любча",
"3594567", "Баня\,\ Сливен",
"3596584", "Белене",
"3594520", "Коньово",
"35951536", "Николаевка",
"35982", "Русе",
"3597103", "Брусен\,\ София",
"3594125", "Михайлово\,\ Ст\.\ Загора",
"3595947", "Просеник",
"35931398", "Слатина\,\ Пловдив",
"35993342", "Киреево",
"3593342", "Нареченски\ бани",
"3593667", "Покрован",
"3595915", "Българово",
"3594516", "Кермен",
"35995276", "Драганица",
"3595319", "Друмево",
"3595134", "Червенци",
"3595145", "Гроздьово",
"3599333", "Бойница",
"35991188", "Галатин",
"359865", "Силистра",
"3597164", "Реброво",
"3595117", "Ботево\,\ Варна",
"35969615", "Балабанско",
"359418", "Гълъбово\,\ Ст\.\ Загора",
"35967391", "Столът",
"35930415", "Девин",
"3596538", "Обнова",
"3598135", "Бабово",
"3598144", "Батишница",
"3596352", "Долни\ Луковит",
"3597930", "Еремия",
"35991201", "Люти\ брод",
"3593038", "Чокманово",
"3593544", "Костандово",
"3593535", "Левски\,\ Пазарджик",
"3593153", "Стряма",
"3594710", "Болярско",
"35941484", "Землен",
"35963562", "Комарево\,\ Плевен",
"3596044", "Долно\ Козарево",
"3593779", "Сива\ река",
"3596035", "Паламарца",
"3597724", "Извор\,\ Перник",
"3595395", "Чернооково\,\ Шумен",
"3594726", "Маломирово",
"3594778", "Победа\,\ Ямбол",
"3598645", "Межден",
"3598634", "Нова\ Черна",
"3594102", "Ястребово\,\ Ст\.\ Загора",
"3596913", "Славяни",
"3593130", "Каравелово\,\ Пловдив",
"3593054", "Подвис\,\ Смол\.",
"3595746", "Белгун",
"3594551", "Бяла\,\ Сливен",
"359590", "Царево",
"3596143", "Масларево",
"3593192", "Бабек",
"3596732", "Сенник",
"3596554", "Крушовене",
"3596327", "Овча\ могила",
"35963574", "Тодорово\,\ Плевен",
"3596129", "Габровци",
"35984467", "Сеслав",
"35961397", "Мусина",
"3596176", "Поликраище",
"3599515", "Мадан\,\ Монт\.",
"3596128", "Хотница",
"3597056", "Мурсалево",
"3599547", "Винище",
"3595773", "Лозенец\,\ Добр\.",
"3596580", "Татари",
"3593765", "Иваново\,\ Хаск\.",
"3599126", "Камено\ поле",
"35963568", "Буковлък",
"3598116", "Иваново\,\ Русе",
"3597925", "Гюешево",
"3596112", "Самоводене",
"3593624", "Чифлик\,\ Кърдж\.",
"35984737", "Райнино",
"3595524", "Екзарх\ Антимово",
"3599110", "Вировско",
"35974406", "Добърско",
"3596562", "Гиген",
"3597444", "Белица\,\ Благ\.",
"3597127", "Широки\ дол",
"3597435", "Склаве",
"3599560", "Безденица",
"3594153", "Мъдрец\,\ Ст\.\ Загора",
"3597546", "Слащен",
"3594779", "Ханово",
"3596942", "Александрово\,\ Ловеч",
"3593710", "Узунджово",
"3596987", "Карлуково",
"3596541", "Никопол",
"3593778", "Студена\,\ Хаск\.",
"3593102", "Караджово",
"3594130", "Спасово\,\ Ст\.\ Загора",
"3593726", "Клокотница",
"3599165", "Софрониево",
"35978", "Кюстендил",
"35935257", "Сарая",
"35960370", "Голямо\ градище",
"3593039", "Полковник\ Серафимово",
"35937702", "Мустрак",
"3593927", "Черногорово\,\ Хаск\.",
"35947192", "Завой",
"359318", "Съединение\,\ Пловдив",
"3597193", "Голеш\,\ София",
"3593166", "Бяла\ река\,\ Пловдив",
"3599725", "Комощица",
"3596539", "Градище\,\ Плевен",
"3595737", "Люляково\,\ Добр\.",
"3595714", "Карапелит",
"35931392", "Дъбене",
"359676", "Дряново\,\ Габр\.",
"3595318", "Средня",
"35941270", "Малка\ Верея",
"3596072", "Добротица\,\ Търг\.",
"35971224", "Шипочане",
"3593520", "Мирянци",
"35991182", "Осен\,\ Враца",
"3597152", "Горна\ Малина",
"35947201", "Изгрев\,\ Ямбол",
"35931388", "Бегунци",
"35941357", "Зетьово\,\ Ст\.\ Загора",
"3596020", "Лиляк",
"3594361", "Павел\ баня",
"3598151", "Просена",
"3593125", "Ръжево\ Конаре",
"3593516", "Црънча\,\ Пазарджик",
"3594342", "Овощник",
"3593154", "Чалъкови",
"3596991", "Ябланица",
"35931709", "Михилци",
"35930456", "Чавдар\,\ Смол\.",
"3593543", "Дорково",
"3596043", "Долно\ Новково",
"3597428", "Габрене",
"3594528", "Любенова\ махала",
"3596914", "Сливек",
"35991185", "Пудрия",
"3594585", "Жеравна",
"3598633", "Старо\ село\,\ Силистра",
"35962", "Велико\ Търново",
"3593529", "Мокрище",
"359596", "Поморие",
"35954", "Шумен",
"3597723", "Долни\ Раковец",
"3595121", "Тутраканци",
"3594757", "Недялско",
"3593346", "Мулдава",
"3596937", "Соколово\,\ Ловеч",
"35930418", "Буйново\,\ Смол\.",
"3596029", "Надарево",
"35961406", "Каранци",
"35960387", "Глогинка",
"359554", "Слънчев\ бряг",
"3594512", "Блатец\,\ Сливен",
"35961101", "Велчево\,\ В\.\ Търново",
"3593053", "Хвойна",
"35961603", "Лозен\,\ В\.\ Търново",
"3596553", "Оряховица\,\ Плевен",
"35993212", "Карбинци",
"3596135", "Върбовка",
"35931395", "Иганово",
"3596144", "Долна\ Липница",
"35974323", "Лозеница",
"35937705", "Пъстрогор",
"3593030", "Широка\ лъка",
"3595968", "Каблешково\,\ Бургас",
"3596530", "Трънчовица",
"3597938", "Долно\ Уйно",
"3593648", "Голямо\ Каменяне",
"3594718", "Роза",
"3594139", "Свобода\,\ Ст\.\ Загора",
"359973", "Козлодуй",
"3598677", "Сребърна",
"35936402", "Горна\ кула",
"35931258", "Главатар",
"3594337", "Ясеново\,\ Ст\.\ Загора",
"3594722", "Гранитово\,\ Ямбол",
"3599569", "Липен",
"3594106", "Пъстрен",
"3597104", "Лъга",
"3593719", "Книжовник",
"3594770", "Генерал\ Инзово",
"3593138", "Ведраре",
"3599119", "Тишевица",
"35974496", "Филипово\,\ Благ\.",
"3598621", "Силистра",
"3598129", "Лом\ Черковна",
"3595742", "Раковски\,\ Добр\.",
"3599345", "Винарово\,\ Видин",
"3595555", "Факия",
"3597731", "Трън",
"3595133", "Генерал\ Колево\,\ Варна",
"35984712", "Костанденец",
"35931703", "Житница\,\ Пловдив",
"3599317", "Арчар",
"3593196", "Дрангово\,\ Пловдив",
"3595761", "Батово",
"3597163", "Искрец",
"3596736", "Градница\,\ Габр\.",
"3598143", "Обретеник",
"35961307", "Стамболово\,\ В\.\ Търново",
"35974202", "Ключ",
"3596589", "Кулина\ вода",
"3598185", "Сеново",
"3596588", "Деков",
"3597052", "Пастра",
"3599122", "Зверино",
"3593025", "Баните",
"3596116", "Големаните",
"3596525", "Бъркач",
"3598128", "Полско\ Косово",
"3595713", "Стефаново\,\ Добр\.",
"3593631", "Момчилград",
"359670", "Троян\,\ Ловеч",
"3596566", "Долни\ Вит",
"35984718", "Дряновец\,\ Разград",
"3593718", "Войводово\,\ Хаск\.",
"3597755", "Велковци\,\ Перник",
"359308", "Мадан\,\ Смол\.",
"3596946", "Чавдарци",
"3599568", "Благово\,\ Монт\.",
"35930517", "Забърдо",
"3593106", "Строево",
"3593722", "Минерални\ бани\,\ Хаск\.",
"35953222", "Марково\,\ Шумен",
"35963565", "Мечка\,\ Плевен",
"3594138", "Гита",
"35969241", "Йоглав",
"35960454", "Змейно",
"35941336", "Яздач",
"3597939", "Църварица",
"3595969", "Гълъбец\,\ Бургас",
"3595774", "Коритен",
"3594795", "Скалица",
"3595326", "Върбяне",
"3593162", "Градина\,\ Пловдив",
"3595523", "Крумово\ градище",
"3593623", "Бойно",
"359725", "Елин\ Пелин",
"3595310", "Радко\ Димитриево",
"3596901", "Гложене\,\ Ловеч",
"35967301", "Идилево",
"35930412", "Девин",
"35936700", "Шопци",
"35951429", "Солник",
"35941110", "Старозагорски\ бани",
"35969612", "Терзийско\,\ Ловеч",
"3596076", "Таймище",
"3594154", "Медникарово",
"3597156", "Равно\ поле",
"3596028", "Вардун",
"359537", "Нови\ пазар\,\ Шумен",
"3593528", "Говедаре",
"3596151", "Елена\,\ В\.\ Търново",
"35931308", "Богдан\,\ Пловдив",
"3594529", "Съдиево\,\ Сливен",
"3593705", "Въгларово",
"3593757", "Георги\ Добрево",
"35976", "Перник",
"3593585", "Аканджиево",
"3595365", "Лятно",
"3599741", "Долни\ Цибър",
"3593512", "Хаджиево",
"3594346", "Голямо\ Дряново",
"3596527", "Одърне",
"3597162", "Лакатник",
"3596146", "Полски\ Сеновец",
"3595132", "Михалич\,\ Варна",
"3595743", "Шабла",
"3599148", "Бъркачево",
"3593027", "Славейно",
"3598161", "Ветово",
"3598669", "Гарван\,\ Силистра",
"3594351", "Копринка",
"3598187", "Тетово",
"3598142", "Бъзовец\,\ Русе",
"3596920", "Лесидрен",
"3593695", "Комунига",
"35984776", "Хърсово\,\ Разград",
"3593071", "Златоград",
"3599521", "Замфирово",
"3597528", "Хаджидимово",
"3596571", "Лепица",
"3593156", "Шишманци",
"3594749", "Ружица\,\ Ямбол",
"3593344", "Новаково\,\ Пловдив",
"3597911", "Граница",
"3593748", "Лясковец\,\ Хаск\.",
"3596916", "Брестово\,\ Ловеч",
"35941115", "Борилово",
"359675", "Севлиево",
"35963573", "Дисевица",
"3594723", "Бояново\,\ Ямбол",
"3598690", "Силистра",
"3593194", "Зелениково\,\ Пловдив",
"3599550", "Митровци",
"3595340", "Висока\ поляна\,\ Шумен",
"3596734", "Петко\ Славейков",
"3596552", "Долна\ Митрополия",
"3593052", "Лъки\,\ Пловдив",
"3599336", "Старопатица",
"3596717", "Лесичарка",
"359720", "Етрополе",
"3595519", "Зидарово",
"3593111", "Първенец\,\ Пловдив",
"35963579", "Ралево",
"3594797", "Гълъбинци",
"35963560", "Радишево",
"3595169", "Момчилово",
"35981462", "Волово",
"3593561", "Септември",
"3596042", "Илийно",
"3593707", "Николово\,\ Хаск\.",
"3597718", "Драгичево",
"3593755", "Белица\,\ Хаск\.",
"3593542", "Ракитово",
"3596061", "Голямо\ Соколово",
"35941489", "Боздуганово",
"35941331", "Гранит",
"35960378", "Цар\ Асен\,\ Търг\.",
"3597139", "Джурово",
"3593587", "Сестримо",
"3595367", "Тодор\ Икономово",
"3594513", "Гавраилово",
"35967306", "Градище\,\ Габр\.",
"3598632", "Зафирово",
"3597106", "Ямна",
"3594104", "Кравино",
"3596944", "Крушуна",
"3596935", "Сопот\,\ Ловеч",
"35937421", "Долно\ поле",
"35961106", "Ново\ село\,\ В\.\ Търново",
"3596564", "Загражден\,\ Плевен",
"3594587", "Ябланово",
"3597442", "Якоруда",
"3594755", "Тамарино",
"359361", "Кърджали",
"3597138", "Литаково",
"3599131", "Добролево",
"3593320", "Орешец\,\ Пловдив",
"3593513", "Мало\ Конаре",
"359729", "Годеч",
"3597719", "Ярджиловци",
"35930476", "Селча",
"3593104", "Ягодово\,\ Пловдив",
"3595168", "Петров\ дол\,\ Варна",
"3593163", "Искра\,\ Пловдив",
"35931620", "Добри\ дол\,\ Пловдив",
"3595518", "Рудник\,\ Бургас",
"35960372", "Крепча",
"3595570", "Манолич",
"3596137", "Бутово",
"3593622", "Стремци",
"3596114", "Килифарево",
"3595522", "Искра\,\ Бургас",
"3596074", "Любичево",
"3593749", "Гарваново",
"35931390", "Московец",
"3597154", "Столник",
"3594156", "Априлово\,\ Ст\.\ Загора",
"3594748", "Воден\,\ Ямбол",
"3598675", "Айдемир",
"3594344", "Шаново",
"3594335", "Ръжена",
"3597529", "Брезница",
"35946", "Ямбол",
"3598113", "Ново\ село\,\ Русе",
"35971302", "Боженица",
"3599123", "Роман",
"3595776", "Черна\,\ Добр\.",
"3595324", "Хърсово\,\ Шумен",
"3597053", "Кочериново",
"3598668", "Попина",
"3595100", "Синдел",
"3596173", "Долна\ Оряховица",
"3595712", "Стожер",
"3599315", "Градец\,\ Видин",
"3599149", "Буковец\,\ Враца",
"35991180", "Лесура",
"3595557", "Бистрец\,\ Бургас",
"3599347", "Бела\ Рада",
"35971506", "Габра",
"3597030", "Ресилово",
"3593657", "Жълтуша",
"3596733", "Кормянско",
"3597166", "Владо\ Тричков",
"35977222", "Горна\ Диканя",
"35941275", "Лясково\,\ Ст\.\ Загора",
"3593193", "Борец",
"3599140", "Габаре",
"3596142", "Обединение",
"3596161", "Стражица\,\ В\.\ Търново",
"3595136", "Брестак",
"3597039", "Самораново",
"35941118", "Остра\ могила\,\ Ст\.\ Загора",
"3597927", "Трекляно",
"3599545", "Габровница",
"35957307", "Житен\,\ Добр\.",
"3596001", "Черковна\,\ Търг\.",
"3593767", "Браница",
"3599517", "Кобиляк",
"359519", "Девня",
"3593781", "Симеоновград",
"35931704", "Иван\ Вазово",
"35941171", "Дълбоки",
"3599181", "Краводер",
"3597188", "Петрич\,\ София",
"3596928", "Къкрина",
"3599167", "Липница\,\ Враца",
"3597520", "Корница",
"3595959", "Звездец",
"359726", "Своге",
"3594514", "Крушаре",
"35953436", "Черноглавци",
"3596985", "Румянцево",
"3597437", "Мелник",
"3594103", "Бял\ извор\,\ Ст\.\ Загора",
"3596912", "Баховица",
"3597125", "Говедарци",
"3596511", "Победа\,\ Плевен",
"35974401", "Горно\ Драглище",
"3593740", "Пчелари",
"3595579", "Ведрово",
"3593679", "Кирково",
"35965617", "Искър\,\ Плевен",
"3596556", "Горна\ Митрополия",
"3598698", "Шуменци",
"3593056", "Чепинци\,\ Смол\.",
"35975214", "Гайтаниново",
"3595735", "Красен\,\ Добр\.",
"3599332", "Раковица",
"3599558", "Гаврил\ Геново",
"3595348", "Трем",
"3599727", "Медковец",
"35984269", "Недоклан",
"3593925", "Крум",
"35960375", "Гърчиново",
"359777", "Радомир",
"3596046", "Врани\ кон",
"3597041", "Шатрово",
"35961604", "Мирово\,\ В\.\ Търново",
"3593127", "Царацово",
"35984710", "Осенец",
"3593343", "Козаново",
"3594724", "Раздел\,\ Ямбол",
"3597726", "Дрен",
"35938", "Хасково",
"35974324", "Струма",
"3598636", "Главиница\,\ Силистра",
"3597102", "Лопян",
"3594329", "Долно\ Сахране",
"35984392", "Белинци",
"35931996", "Свежен",
"35967396", "Бериево",
"3595917", "Извор\,\ Бургас",
"3593665", "Свирачи",
"3597446", "Елешница\,\ Благ\.",
"3595751", "Тервел\,\ Добр\.",
"35981266", "Стърмен\,\ Русе",
"3597544", "Осина",
"3595945", "Добромир",
"3594343", "Конаре\,\ Ст\.\ Загора",
"359848", "Кубрат",
"35981465", "Батин",
"3593328", "Долнослав",
"35961706", "Писарево\,\ В\.\ Търново",
"3593724", "Сусам",
"35971471", "Очуша",
"3595323", "Плиска",
"35953220", "Памукчии\,\ Шумен",
"3599124", "Типченица",
"3598114", "Пиргово",
"3597192", "Гинци",
"3596174", "Драганово\,\ В\.\ Търново",
"3597054", "Рила",
"3598137", "Голямо\ Враново",
"3595115", "Генерал\ Кантарджиево",
"3599559", "Горна\ Ковачица",
"3595349", "Студеница",
"359860", "Силистра",
"3598699", "Търновци\,\ Силистра",
"3595147", "Пчелник\,\ Варна",
"3593678", "Чакаларово",
"3595578", "Терзийско\,\ Бургас",
"3593626", "Перперек",
"3595526", "Кликач",
"35961503", "Чакали",
"3596943", "Горско\ Сливово",
"3595397", "Методиево\,\ Шумен",
"35930410", "Брезе\,\ Смол\.",
"35936702", "Горски\ извор\,\ Кърдж\.",
"35941112", "Старозагорски\ бани",
"3594152", "Обручище",
"3596563", "Брест\,\ Плевен",
"3598647", "Паисиево",
"3595958", "Граматиково",
"3593514", "Черногорово\,\ Пазарджик",
"35931606", "Воден\,\ Пловдив",
"35971398", "Осиковица",
"3596929", "Радювене",
"35959407", "Сини\ рид",
"3597189", "Чавдар\,\ София",
"3593537", "Панагюрски\ колонии",
"3593103", "Милево",
"3595772", "Телериг",
"3598660", "Тутракан",
"3595108", "Садово\,\ Варна",
"3593164", "Дълбок\ извор",
"3596325", "Козловец",
"35947356", "Мрамор\,\ Ямбол",
"35931403", "Триводици",
"35930528", "Манастир\,\ Пловдив",
"3595716", "Паскалево",
"35960453", "Моравка",
"359936", "Белоградчик",
"3596113", "Балван",
"35984727", "Каменово\,\ Разград",
"3594108", "Васил\ Левски\,\ Ст\.\ Загора",
"3594772", "Симеоново\,\ Ямбол",
"35984733", "Лудогорци",
"3593136", "Розино\,\ Пловдив",
"3596569", "Ленково",
"35941359", "Изворово\,\ Ст\.\ Загора",
"35961393", "Горско\ Косово",
"3594716", "Веселиново\,\ Ямбол",
"3597714", "Мещица",
"3595767", "Житница\,\ Добр\.",
"3599311", "Кутово",
"3596923", "Горан",
"35971338", "Осиковска\ Лакавица",
"3595781", "Свобода\,\ Добр\.",
"3597183", "Душанци",
"35931605", "Буково\,\ Пловдив",
"3593109", "Лилково",
"3598627", "Бабук",
"35984764", "Сейдол",
"35953221", "Стоян\ Михайловски",
"35969242", "Пресяка",
"3594331", "Гурково\,\ Ст\.\ Загора",
"3598671", "Силистра",
"3595740", "Горичане",
"3593198", "Чехларе",
"3596119", "Дичин",
"3596738", "Добромирка",
"3594323", "Тулово",
"35937603", "Рогозиново",
"3594510", "Желю\ войвода",
"3597159", "Априлово\,\ София",
"35931995", "Стрелци\,\ Пловдив",
"35992", "Враца",
"3593348", "Добралък",
"35930411", "Девин",
"35967395", "Горна\ Росица",
"3593744", "Сърница\,\ Хаск\.",
"35967302", "Кръвеник",
"3594115", "Кирилово\,\ Ст\.\ Загора",
"35961705", "Горски\ долен\ Тръмбеш",
"3594147", "Любеново\,\ Ст\.\ Загора",
"3597426", "Марикостиново",
"35981466", "Помен",
"3594526", "Млекарево",
"3597524", "Абланица\,\ Благ\.",
"3596590", "Ракита\,\ Плевен",
"3596532", "Българене\,\ Плевен",
"3595329", "Мировци",
"3596931", "Угърчин",
"3595127", "Манастир\,\ Варна",
"3594751", "Войника",
"3593646", "Токачка",
"3593032", "Средногорци",
"3597936", "Слокощица",
"3599356", "Каленик\,\ Видин",
"3595343", "Венец\,\ Шумен",
"3599553", "Превала",
"3598693", "Звенимир",
"35961108", "Плаково",
"3599144", "Нивянин",
"3599135", "Бърдарски\ геран",
"35941353", "Плодовитово",
"359457", "Нова\ Загора",
"359747", "Разлог",
"35958", "Добрич",
"3596997", "Добревци\,\ Ловеч",
"3598445", "Юпер",
"35973", "Благоевград",
"3599782", "Буковец\,\ Монт\.",
"3599747", "Мокреш\,\ Монт\.",
"3593673", "Тихомир",
"35984469", "Божурово\,\ Разград",
"3595573", "Везенково",
"3593934", "Скобелево\,\ Хаск\.",
"3593751", "Любимец",
"35967308", "Ловнидол",
"3595312", "Дибич",
"3596065", "Бистра\,\ Търг\.",
"3596157", "Сливовица",
"35960376", "Люблен",
"3598664", "Поляна\,\ Силистра",
"3595724", "Дропла\,\ Добр\.",
"3596359", "Глава",
"3595328", "Никола\ Козлево",
"359357", "Панагюрище",
"3593510", "Овчеполци",
"35930472", "Михалково",
"3596907", "Градежница",
"3596955", "Дълбок\ дол",
"3593323", "Болярци\,\ Пловдив",
"3594744", "Голямо\ Крушево",
"3594348", "Дунавци\,\ Ст\.\ Загора",
"3593349", "Боянци",
"35961102", "Пчелище",
"3596026", "Макариополско",
"3593115", "Куклен",
"3597158", "Доганово",
"3593526", "Динката",
"3593147", "Ново\ село\,\ Пловдив",
"3593075", "Долен\,\ Смол\.",
"3599525", "Долно\ Озирово",
"35971502", "Елешница\,\ София",
"3596118", "Вонеща\ вода",
"3593691", "Черноочeне",
"35941276", "Могила\,\ Ст\.\ Загора",
"3599116", "Костелево",
"3596575", "Телиш",
"3597033", "Крайници",
"3596122", "Беляковец",
"3597915", "Невестино\,\ Кюст\.",
"3596586", "Белене",
"3599172", "Селановци",
"35936401", "Странджево",
"35984778", "Богданци\,\ Разград",
"3595537", "Съдиево\,\ Бургас",
"35971306", "Рашково",
"3593637", "Груево",
"359306", "Рудозем",
"3593108", "Бойково",
"3597117", "Градец\,\ София",
"3595164", "Неофит\ Рилски",
"3593772", "Момково",
"3594136", "Черна\ гора\,\ Ст\.\ Загора",
"3597134", "Врачеш",
"35967193", "Кметовци",
"3597145", "Мирово\,\ София",
"35969248", "Скобелево\,\ Ловеч",
"359817", "Бяла\,\ Русе",
"35974201", "Капатово",
"3593720", "Маджарово",
"35984463", "Прелез",
"35984711", "Мортагоново",
"3592", "София",
"3594355", "Бузовград",
"3596568", "Дъбован",
"3598165", "Смирненски\,\ Русе",
"3596948", "Кърпачево",
"3594109", "Тракия",
"35953435", "Изгрев\,\ Шумен",
"3594728", "Мелница",
"3594324", "Шипка",
"3597549", "Долен\,\ Благ\.",
"3593743", "Силен",
"3594100", "Столетово\,\ Ст\.\ Загора",
"35959404", "Ясеново\,\ Бургас",
"3593132", "Баня\,\ Пловдив",
"3596321", "Горна\ Студена",
"35937420", "Подкрепа",
"3594712", "Кабиле",
"3593729", "Криво\ поле",
"3594557", "Биково",
"3597523", "Гърмен",
"3599129", "Синьо\ бърдо",
"3599327", "Чупрене",
"35984749", "Севар",
"3596179", "Крушето",
"3595748", "Дуранкулак",
"3599143", "Еница",
"35971505", "Чурек",
"3593190", "Върбен\,\ Пловдив",
"35951104", "Долище\,\ Варна",
"3598694", "Зебил",
"3595344", "Велино",
"3599554", "Чипровци",
"3595335", "Миланово\,\ Шумен",
"35977226", "Дебели\ лаг",
"35956", "Бургас",
"35984743", "Брестовене",
"35961105", "Присово",
"3593340", "Нови\ извор",
"359953", "Берковица",
"3594518", "Тополчане",
"35930475", "Стоманево",
"35937701", "Сладун",
"3597713", "Рударци",
"3593519", "Величково\,\ Пазарджик",
"359416", "Чирпан",
"3597422", "Тополница\,\ Благ\.",
"3597184", "Копривщица",
"3594522", "Кортен",
"3596536", "Аспарухово\,\ Плевен",
"3598477", "Самуил",
"3593661", "Ивайловград",
"35963204", "Деляновци",
"3597531", "Долно\ Дряново",
"3595941", "Скалак\,\ Бургас",
"3597932", "Шипочано",
"3593642", "Поточница",
"3593036", "Могилица",
"3595755", "Коларци",
"3599352", "Дружба",
"35947202", "Жребино",
"35935419", "Света\ Петка",
"35981268", "Кривина\,\ Русе",
"359659", "Червен\ бряг",
"35967398", "Дамяново",
"359309", "Пампорово",
"35935393", "Смилец\,\ Пазарджик",
"35931998", "Чоба",
"359601", "Търговище",
"3597045", "Голем\ Върбовник",
"3597034", "Джерман",
"35961309", "Горско\ Калугерово",
"3595316", "Салманово",
"3594367", "Тъжа",
"35960383", "Берковски",
"3595513", "Габър",
"3595320", "Пет\ могили\,\ Шумен",
"3596725", "Гостилица",
"3593168", "Езерово\,\ Пловдив",
"35974327", "Ново\ Делчево",
"35941144", "Калояновец",
"3593175", "Дълго\ поле\,\ Пловдив",
"3594340", "Паничерево",
"3595163", "Млада\ гвардия",
"3597742", "Калище",
"3593518", "Драгор",
"359678", "Тетевен",
"359650", "Левски\,\ Плевен",
"3595731", "Генерал\ Тошево\,\ Добр\.",
"35991202", "Кунино",
"3597133", "Правец",
"3594519", "Самуилово\,\ Сливен",
"35961607", "Балканци\,\ В\.\ Търново",
"35981262", "Бистренци",
"3596022", "Пробуда\,\ Търг\.",
"35967392", "Яворец",
"3593522", "Гелеменово",
"35967305", "Стоките",
"3593921", "Меричлери",
"35931992", "Пъдарско",
"3595574", "Съединение\,\ Бургас",
"3593674", "Самодива",
"3594595", "Сборище",
"3599185", "Бели\ Извор",
"35957304", "Дъбовик",
"3598122", "Ценово\,\ Русе",
"3599112", "Баница",
"3593933", "Странско",
"3595749", "Крапец\,\ Добр\.",
"3598663", "Ситово\,\ Силистра",
"3596547", "Драгаш\ войвода",
"3596178", "Стрелец\,\ В\.\ Търново",
"3596981", "Петревене",
"3596582", "Белене",
"3597058", "Стоб",
"3596126", "Церова\ кория",
"3596515", "Славяново\,\ Плевен",
"3599176", "Лесковец\,\ Враца",
"3596967", "Калейца",
"35963561", "Гривица",
"35969245", "Деветаки",
"3598118", "Николово\,\ Русе",
"3595723", "Гурково\,\ Добр\.",
"3599128", "Елисейна",
"3593324", "Избеглии",
"3593776", "Райкова\ могила",
"35961303", "Горна\ Липница",
"35960389", "Кардам\,\ Търг\.",
"3593728", "Славяново\,\ Хаск\.",
"3593100", "Белащица",
"3594132", "Оризово",
"3596165", "Асеново\,\ В\.\ Търново",
"35941330", "Ценово\,\ Ст\.\ Загора",
"35931602", "Татарево\,\ Пловдив",
"3594743", "Мамарчево",
"35941116", "Сладък\ Кладенец",
"3597177", "Алдомировци",
"3593712", "Малево\,\ Хаск\.",
"3597548", "Годешево",
"3599541", "Доктор\ Йосифово",
"3595351", "Смядово",
"3593785", "Дряново\,\ Хаск\.",
"35931707", "Черноземен",
"3596560", "Крета\,\ Плевен",
"3594729", "Кирилово\,\ Ямбол",
"3593557", "Бяга",
"3599548", "Крапчене",
"3597541", "Сатовча",
"35963571", "Брестовец",
"35984728", "Раковски\,\ Разград",
"3596966", "Шипково",
"3595754", "Зърнево",
"3596329", "Царевец\,\ В\.\ Търново",
"3595532", "Тополица",
"3593046", "Барутин",
"3593632", "Джебел",
"3596546", "Лозица\,\ Плевен",
"35931604", "Драгойново",
"35951108", "Изворско",
"3593721", "Стамболово\,\ Хаск\.",
"35968", "Ловеч",
"359727", "Сливница\,\ София",
"3596988", "Пещерна",
"3593556", "Радилово",
"3599121", "Царевец\,\ Враца",
"3598111", "Щръклево",
"35994", "Видин",
"3597176", "Храбърско",
"35959408", "Ръжица",
"35947354", "Каменна\ река",
"35960380", "Дриново",
"35984765", "Веселина",
"3597185", "Челопеч",
"3598194", "Сандрово",
"3596925", "Владиня",
"3595590", "Житосвят",
"3593777", "Мезек",
"35941339", "Димитриево",
"35961704", "Правда\,\ В\.\ Търново",
"3596152", "Беброво",
"3593928", "Долно\ Белево",
"35941018", "Княжевско",
"3598156", "Червен\,\ Русе",
"3595317", "Ивански",
"35941333", "Средно\ градище",
"35981264", "Пиперково",
"3598695", "Ножарево",
"35967394", "Богатово",
"3599787", "Смирненски\,\ Монт\.",
"3599133", "Комарево\,\ Враца",
"3595738", "Спасово\,\ Добр\.",
"3599555", "Копиловци\,\ Монт\.",
"3595345", "Развигорово",
"3593511", "Огняново\,\ Пазарджик",
"3599742", "Якимово",
"3595334", "Осмар",
"3595119", "Игнатиево",
"3595949", "Планиница\,\ Бургас",
"3593142", "Брестовица\,\ Пловдив",
"3594325", "Кънчево",
"3594113", "Преславен",
"3596902", "Рибарица\,\ Ловеч",
"3594142", "Трояново\,\ Ст\.\ Загора",
"3594733", "Орлов\ дол",
"3596164", "Бряговица",
"35963202", "Драгомирово\,\ В\.\ Търново",
"3596953", "Борима",
"3593325", "Червен\,\ Пловдив",
"35961403", "Орловец",
"35935501", "Равногор",
"35947204", "Пчела",
"3593784", "Константиново\,\ Хаск\.",
"35971221", "Ярлово",
"3593113", "Браниполе",
"3596930", "Славщица",
"3596004", "Маково",
"3595948", "Снягово\,\ Бургас",
"3595118", "Водица\,\ Варна",
"3596063", "Баячево",
"3596591", "Горник",
"3595739", "Пчеларово\,\ Добр\.",
"3596992", "Златна\ Панега",
"3593675", "Фотиново\,\ Кърдж\.",
"3599184", "Оходен",
"3595575", "Прилеп\,\ Бургас",
"3593563", "Варвара\,\ Пазарджик",
"3595122", "Славейково\,\ Варна",
"3596514", "Долни\ Дъбник",
"35961606", "Владислав",
"3593037", "Сивино",
"3593929", "Голямо\ Асеново",
"35937423", "Големанци",
"359556", "Обзор",
"3594511", "Сливенски\ минерални\ бани",
"3596537", "Асеновци",
"35984722", "Ясеновец",
"3597732", "Вукан",
"3594556", "Сотиря",
"3597143", "Вакарел",
"3598622", "Алеково\,\ Силистра",
"3593174", "Старо\ Железаре",
"3595762", "Стефан\ Караджа\,\ Добр\.",
"3598670", "Силистра",
"3594330", "Николаево\,\ Ст\.\ Загора",
"3597129", "Радуил",
"3596989", "Торос",
"3598163", "Бъзън",
"3594353", "Средногорово",
"3594777", "Тенево",
"3596573", "Койнаре",
"3597044", "Бабино",
"3597035", "Червен\ брег",
"35930200", "Загражден\,\ Смол\.",
"35953434", "Ясенково",
"35957308", "Чернооково\,\ Добр\.",
"3599523", "Бързия",
"3593073", "Старцево",
"3599326", "Горни\ Лом",
"359861", "Силистра",
"35941117", "Казанка",
"3595105", "Приселци\,\ Варна",
"35984740", "Бисерци",
"3596328", "Ореш",
"3597913", "Рашка\ Гращица",
"35931706", "Сухозем",
"3599549", "Долна\ Рикса",
"3596724", "Янтра\,\ Габр\.",
"35930459", "Бръщен",
"35984768", "Синя\ вода",
"3596962", "Черни\ Осъм",
"35974403", "Долно\ Драглище",
"3595536", "Мъглен",
"3593636", "Равен",
"3596561", "Гулянци",
"3593042", "Борино",
"359721", "Костинброд",
"3596542", "Въбел\,\ Плевен",
"3599540", "Белотинци",
"3596941", "Летница",
"3594564", "Новоселец",
"3596587", "Петокладенци",
"359559", "Карнобат",
"3598127", "Караманово",
"3593101", "Войводиново",
"3599117", "Криводол",
"35959405", "Зайчар",
"3595333", "Хан\ Крум",
"35941173", "Братя\ Кунчеви",
"3599145", "Бреница\,\ Враца",
"3599134", "Търнак",
"3599319", "Гъмзово",
"3597120", "Долна\ баня",
"3599567", "Долна\ Вереница",
"35971504", "Белопопци",
"3593552", "Брацигово",
"3593745", "Малък\ извор\,\ Хаск\.",
"3597172", "Драгоман",
"3596980", "Беленци",
"3593717", "Конуш\,\ Хаск\.",
"3594137", "Верен",
"3596111", "Къпиново\,\ В\.\ Търново",
"35984725", "Киченица",
"3597525", "Баничан",
"3597116", "Петърч",
"3594339", "Юлиево",
"3598679", "Кайнарджа",
"3593920", "Златополе",
"3595753", "Орляк",
"3596071", "Антоново",
"3596156", "Родина",
"3598152", "Красен\,\ Русе",
"3594362", "Манолово",
"35961104", "Водолей",
"35966", "Габрово",
"3594341", "Черганово",
"3599746", "Разград\,\ Монт\.",
"359915", "Бяла\ Слатина",
"3593527", "Алеко\ Константиново",
"3593146", "Куртово\ Конаре",
"3595321", "Правенци",
"35974409", "Места",
"359702", "Бобов\ дол",
"3596939", "Драгана",
"3596027", "Дралфа",
"35941179", "Хан\ Аспарухово",
"3593758", "Йерусалимово",
"3597715", "Студена\,\ Перник",
"35963205", "Червена",
"3596906", "Черни\ Вит",
"3597135", "Трудовец",
"3597144", "Костенец",
"3597427", "Първомай\,\ Благ\.",
"3594146", "Диня",
"3594527", "Загорци\,\ Сливен",
"3593759", "Бориславци",
"3595165", "Невша",
"3593173", "Паничери",
"3596938", "Каленик\,\ Ловеч",
"35960377", "Априлово\,\ Търг\.",
"35931324", "Мраченик",
"359517", "Дългопол",
"3594354", "Зимница\,\ Ст\.\ Загора",
"3598164", "Писанец",
"3597043", "Големо\ село",
"3596574", "Чомаковци",
"3593074", "Ерма\ река",
"3599524", "Ягодово\,\ Монт\.",
"35967304", "Крамолин",
"3595126", "Черковна\,\ Варна",
"3597937", "Ръждавица",
"3593647", "Черничево\,\ Кърдж\.",
"35941145", "Арнаутито",
"3596723", "Царева\ ливада",
"3597914", "Ваксево",
"3595967", "Бата",
"3593341", "Конуш\,\ Пловдив",
"3595515", "Камено",
"35984730", "Голям\ Поровец",
"35941350", "Мирово\,\ Ст\.\ Загора",
"3596163", "Камен\,\ В\.\ Търново",
"3594552", "Стара\ река\,\ Сливен",
"3594734", "Срем",
"3598678", "Срацимир\,\ Силистра",
"3594745", "Шарково",
"3594338", "Крън",
"3598626", "Средище\,\ Силистра",
"35960451", "Обител",
"35969244", "Тепава",
"359550", "Созопол",
"3595766", "Методиево\,\ Добр\.",
"3594717", "Чарган",
"35941277", "Загоре",
"3593191", "Брезово\,\ Пловдив",
"3593699", "Габрово\,\ Кърдж\.",
"3596954", "Врабево",
"3595599", "Хаджиите",
"35931401", "Кадиево",
"3593137", "Клисура\,\ Пловдив",
"3593783", "Свирково",
"35957305", "Росица\,\ Добр\.",
"3596003", "Преселец",
"3593114", "Брестник",
"3599318", "Буковец\,\ Видин",
"3593935", "Върбица\,\ Хаск\.",
"3596064", "Голямо\ Ново",
"3593564", "Семчиново",
"3599183", "Лиляче",
"3594593", "Шивачево",
"3599322", "Орешец\,\ Видин",
"3594101", "Опан",
"3596513", "Пордим",
"35984774", "Голям\ извор\,\ Разград",
"35951539", "Левски\,\ Варна",
"3598665", "Искра\,\ Силистра",
"35931708", "Песнопой\,\ Пловдив",
"3596169", "Благоево\,\ В\.\ Търново",
"3593536", "Баня\,\ Пазарджик",
"3597031", "Горна\ Козница",
"3596036", "Садина",
"3593693", "Лясково\,\ Кърдж\.",
"3594725", "Лесово",
"3595396", "Ловец\,\ Шумен",
"3595101", "Дъбравино",
"35957306", "Изворово\,\ Добр\.",
"359359", "Велинград",
"35935251", "Братаница",
"3598646", "Вокил",
"35930419", "Ягодина",
"35953223", "Църквица",
"3595552", "Дюлево\,\ Бургас",
"3599342", "Иново",
"3595734", "Преселенци",
"3595745", "Вранино",
"3593652", "Бял\ извор\,\ Кърдж\.",
"3595338", "Троица",
"3595717", "Ведрина",
"35961391", "Сломер",
"35941114", "Лозен\,\ Ст\.\ Загора",
"3599189", "Паволче",
"3594599", "Червенаково",
"359478", "Елхово\,\ Ямбол",
"35953437", "Габрица\,\ Шумен",
"3593924", "Крепост",
"3596519", "Беглеж",
"3593019", "Писаница",
"3593753", "Оряхово\,\ Хаск\.",
"35941351", "Партизанин",
"3593671", "Подкова",
"35961608", "Горски\ Сеновец",
"35960450", "Долна\ Хубавка",
"3595571", "Сунгурларе",
"3594582", "Градец\,\ Сливен",
"3597447", "Добринище",
"3594126", "Хрищени",
"3597124", "Белчински\ бани",
"3597415", "Селище\,\ Благ\.",
"3594515", "Мокрен",
"3596984", "Бежаново\,\ Ловеч",
"3595916", "Росен\,\ Бургас",
"35984394", "Духовец",
"3595146", "Горен\ чифлик",
"3595527", "Соколово\,\ Бургас",
"3596132", "Караисен",
"3593321", "Тополово\,\ Пловдив",
"3599130", "Тлачене",
"35930413", "Девин",
"359417", "Раднево",
"3598136", "Стамболово\,\ Русе",
"35969613", "Чифлик\,\ Ловеч",
"3599544", "Студено\ буче",
"3595354", "Риш",
"3595758", "Кладенци",
"35941146", "Християново",
"3596324", "Вардим",
"3595759", "Кочмар",
"35967397", "Ряховците",
"35931997", "Златосел",
"3596728", "Буря",
"3594321", "Мъглиж",
"3599726", "Замфир",
"3593165", "Караджалово",
"3594792", "Ботево\,\ Ямбол",
"35961602", "Царски\ извор",
"3593057", "Пловдивци",
"3596060", "Овчарово\,\ Търг\.",
"3596712", "Гъбене",
"3597048", "Блажиево",
"35974322", "Петрово\,\ Благ\.",
"3596557", "Брегаре",
"3597727", "Ковачевци\,\ Перник",
"3594753", "Зорница\,\ Ямбол",
"3598637", "Малък\ Преславец",
"35984719", "Балкански",
"3596933", "Голец",
"3593110", "Поповица",
"3593702", "Царева\ поляна",
"3594730", "Княжево",
"3593547", "Сърница\,\ Пазарджик",
"3593178", "Красново",
"3593582", "Момина\ клисура",
"3595362", "Климент\,\ Шумен",
"3593126", "Труд",
"3593515", "Калугерово\,\ Пазарджик",
"3599551", "Георги\ Дамяново",
"3595341", "Хитрино",
"3598691", "Силистра",
"3596950", "Гумощник",
"3596047", "Зелена\ морава",
"35931702", "Долна\ махала\,\ Пловдив",
"3599516", "Лехчево",
"3596175", "Първомайци",
"3598424", "Цар\ Калоян\,\ Разград",
"3598147", "Баниска",
"3596518", "Рибен",
"359350", "Пещера\,\ Пазарджик",
"3599125", "Горна\ Бешовица",
"3593766", "Бисер",
"3598115", "Червена\ вода",
"35984713", "Благоево\,\ Разград",
"3597910", "Берсин",
"35959406", "Разбойна\,\ Бургас",
"3599188", "Горно\ Пещене",
"3597181", "Пирдоп",
"3595783", "Котленци",
"35974203", "Рупите",
"3595137", "Калоян",
"3596570", "Девенци",
"3597926", "Коняво",
"3593022", "Виево",
"35951428", "Господиново\,\ Варна",
"3596522", "Згалево",
"3599520", "Горно\ Озирово",
"3597167", "Церово\,\ София",
"3595114", "Езерово\,\ Варна",
"3599313", "Капитановци",
"3596921", "Абланица\,\ Ловеч",
"3597436", "Левуново",
"3595944", "Руен\,\ Бургас",
"359301", "Смолян",
"3597545", "Кочан",
"3597752", "Режанци",
"3594350", "Горно\ Изворово",
"35931309", "Климент\,\ Пловдив",
"3593664", "Плевун",
"35951106", "Осеново\,\ Варна",
"3593725", "Стамболийски\,\ Хаск\.",
"3599166", "Хайредин",
"359749", "Банско",
"35971587", "Голема\ Раковица",
"3594333", "Дъбово\,\ Ст\.\ Загора",
"35984726", "Ушинци",
"3596168", "Сушица\,\ В\.\ Търново",
"3598673", "Алфатар",
"35971304", "Липница\,\ София",
"3593754", "Лозен\,\ Хаск\.",
"3593532", "Стрелча",
"3597149", "Живково\,\ София",
"3593931", "Каснаково",
"3596032", "Зараево",
"35971220", "Гуцал",
"35941274", "Самуилово\,\ Ст\.\ Загора",
"3595392", "Менгишево",
"35969247", "Гостиня",
"3597123", "Ковачевци\,\ София",
"3594157", "Разделна\,\ Ст\.\ Загора",
"3594105", "Бяло\ поле",
"35931108", "Богданица",
"3598642", "Дулово",
"3598661", "Тутракан",
"3596983", "Дерманци",
"3594359", "Асен\,\ Ст\.\ Загора",
"3595556", "Голямо\ Буково",
"3599346", "Синаговци",
"3596579", "Рупци\,\ Плевен",
"35991189", "Три\ кладенци",
"359335", "Карлово",
"3594741", "Болярово",
"3593195", "Розовец",
"3594762", "Воденичане",
"3593079", "Козарка",
"3599529", "Боровци",
"3595330", "Златар",
"35931705", "Горна\ махала",
"35931792", "Черничево\,\ Пловдив",
"35953234", "Златна\ нива",
"3595353", "Веселиново\,\ Шумен",
"3594118", "Памукчии\,\ Ст\.\ Загора",
"35935391", "Блатница",
"3594739", "Радовец",
"3596959", "Дебнево",
"35991183", "Фурен",
"35991668", "Манастирище",
"35960374", "Горско\ Абланово",
"3594122", "Еленино",
"3594586", "Нейково\,\ Сливен",
"359746", "Сандански",
"3593119", "Гълъбово\,\ Пловдив",
"3595511", "Лукойл\ Нефтохим",
"3593345", "Лясково\,\ Пловдив",
"35975215", "Тешово",
"35961203", "Емен",
"3595912", "Полски\ извор",
"3595142", "Долни\ чифлик",
"3599719", "Аспарухово\,\ Монт\.",
"3596069", "Васил\ Левски\,\ Търг\.",
"3599138", "Алтимир",
"3595733", "Кардам\,\ Добр\.",
"35991888", "Веслец\,\ Враца",
"35937703", "Димитровче",
"3596136", "Сухиндол",
"35947193", "Могила\,\ Ямбол",
"3593569", "Карабунар",
"3595161", "Ветрино",
"35974325", "Лиляново",
"3598448", "Тертер",
"35931393", "Войнягово",
"35967307", "Млечево",
"3593923", "Радиево",
"3595750", "Каблешково\,\ Добр\.",
"3598132", "Юделник",
"359619", "Лясковец\,\ В\.\ Търново",
"35961605", "Ново\ градище",
"359373", "Харманли",
"35963570", "Староселци",
"35981464", "Острица\,\ Русе",
"3595325", "Войвода",
"35963569", "Каменец\,\ Плевен",
"3594796", "Генерал\ Тошево\,\ Ямбол",
"3599722", "Сталийска\ махала",
"35961107", "Момин\ сбор",
"3596720", "Керека",
"3593568", "Виноградец",
"3599337", "Грамада",
"3595784", "Врачанци",
"3596716", "Жълтеш",
"3599139", "Търнава\,\ Враца",
"3599314", "Дунавци\,\ Видин",
"3596068", "Божурка",
"3597711", "Кладница",
"3597533", "Осиково\,\ Благ\.",
"3595943", "Вресово",
"359610", "Павликени\,\ В\.\ Търново",
"3593118", "Садово\,\ Пловдив",
"3597155", "Лесново",
"3593706", "Тънково\,\ Хаск\.",
"359538", "Велики\ Преслав",
"3593122", "Маноле",
"3596958", "Априлци\,\ Ловеч",
"3593586", "Боримечково",
"3595366", "Браничево",
"3598674", "Професор\ Иширково",
"3594738", "Хлябово",
"35941480", "Коларово\,\ Ст\.\ Загора",
"3594345", "Радунци",
"359971", "Лом",
"3594334", "Елхово\,\ Ст\.\ Загора\,\ общ\.\ Николаево",
"35967774", "Белица\,\ Габр\.",
"3596510", "Тотлебен",
"3599512", "Бели\ брег",
"3593741", "Мандра",
"3597918", "Ябълково\,\ Кюст\.",
"3596323", "Българско\ сливово",
"3593762", "Изворово\,\ Хаск\.",
"3597521", "Копривлен",
"3599528", "Гаганица",
"3593026", "Смилян",
"3597922", "Драговищица\,\ Кюст\.",
"3596115", "Ресен",
"3596526", "Върбица\,\ Плевен",
"3599180", "Голямо\ Пещене",
"35961301", "Бяла\ река\,\ В\.\ Търново",
"3596578", "Реселец",
"3596147", "Иванча\,\ В\.\ Търново",
"3594358", "Скобелево\,\ Ст\.\ Загора",
"3596917", "Българене\,\ Ловеч",
"3596565", "Милковица",
"35963563", "Борислав",
"3594754", "Каменец\,\ Ямбол",
"3596934", "Катунец",
"35971337", "Калугерово\,\ София",
"3593105", "Манолско\ Конаре",
"3598431", "Исперих",
"3593157", "Болярино",
"3599162", "Михайлово\,\ Враца",
"3599141", "Малорад",
"3597148", "Мухово",
"35984766", "Каменар\,\ Разград",
"35969031", "Галата",
"35996", "Монтана",
"35930457", "Късак",
"3599335", "Цар\ Петрово",
"3599344", "Връв",
"3598150", "Семерджиево",
"3595732", "Петлешково",
"3595554", "Момина\ църква",
"35941119", "Елхово\,\ Ст\.\ Загора",
"3595143", "Бяла\,\ Варна",
"3597741", "Земен",
"3599748", "Дългоделци",
"3596021", "Буховци",
"3595327", "Каспичан\,\ Шумен",
"35960386", "Водица\,\ Търг\.",
"3598133", "Ряхово",
"3596158", "Средни\ колиби",
"3593922", "Брод",
"3595129", "Блъсково",
"3593521", "Звъничево",
"3594347", "Розово\,\ Ст\.\ Загора",
"359391", "Димитровград",
"35984393", "Вазово",
"3593756", "Вълче\ поле",
"3596908", "Глогово",
"3594149", "Трънково\,\ Ст\.\ Загора",
"3595913", "Крушевец",
"3593148", "Йоаким\ Груево",
"3596077", "Стеврек",
"35971798", "Василовци\,Соф\.",
"35930414", "Девин",
"359707", "Сапарева\ баня",
"3594123", "Богомилово",
"3597157", "Саранци",
"3597105", "Малки\ Искър",
"35969614", "Горно\ трапе",
"3596134", "Бяла\ черква\,\ В\.\ Търново",
"3596145", "Страхилово",
"35931402", "Скобелево\,\ Пловдив",
"3594763", "Иречеково",
"3596117", "Дебелец\,\ В\.\ Търново",
"3599542", "Смоляновци",
"3595352", "Янково",
"3593711", "Долно\ Ботево",
"3596540", "Асеново\,\ Плевен",
"3593638", "Звездел",
"3595538", "Караново\,\ Бургас",
"35984761", "Градина\,\ Разград",
"3596960", "Белиш",
"3593040", "Триград",
"3599561", "Сумер",
"35963575", "Бохот",
"3593696", "Пчеларово\,\ Кърдж\.",
"3596033", "Медовина",
"359339", "Стамболийски\,\ Пловдив",
"35941113", "Пряпорец\,\ Ст\.\ Загора",
"3595769", "Хитово",
"35961502", "Горско\ Ново\ Село",
"35984", "Разград",
"3593155", "Момино\ село",
"3599111", "Челопек",
"3598629", "Смилец\,\ Силистра",
"3597118", "Драговищица\,\ София",
"3593107", "Граф\ Игнатиево",
"3593533", "Бъта",
"35974348", "Игралище",
"3596581", "Бяла\ вода\,\ Плевен",
"35961306", "Патреш",
"3596982", "Ъглен",
"3596567", "Сомовит",
"3598643", "Златоклас",
"3596915", "Смочан",
"3594584", "Тича",
"3595393", "Иваново\,\ Шумен",
"35951125", "Константиново\,\ Варна",
"3597433", "Кресна",
"3594107", "Средец\,\ Ст\.\ Загора",
"3594155", "Главан\,\ Ст\.\ Загора",
"3598676", "Ветрен\,\ Силистра",
"3597119", "Дръмша",
"3598628", "Цар\ Асен\,\ Силистра",
"3594336", "Долно\ Изворово",
"3599163", "Хърлец",
"3595768", "Одринци\,\ Добр\.",
"3593704", "Брягово\,\ Хаск\.",
"359631", "Свищов",
"35974204", "Гега",
"35960458", "Веренци",
"3593584", "Ветрен\,\ Пазарджик",
"3593763", "Българин",
"3594794", "Овчи\ кладенец",
"3595775", "Полковник\ Дяково",
"3596322", "Алеково\,\ В\.\ Търново",
"3595539", "Черноград",
"3599320", "Стакевци",
"3593639", "Нановица\,\ Кърдж\.",
"3599513", "Бойчиновци",
"3599316", "Ново\ село\,\ Видин",
"3593197", "Тюркмен",
"3594711", "Безмер\,\ Ямбол",
"3596737", "Крушево\,\ Габр\.",
"3597923", "Вратца",
"3596714", "Поповци",
"3593347", "Леново",
"35977229", "Гълъбник",
"3593662", "Железино",
"35941337", "Сърневец",
"3599351", "Извор\,\ Видин",
"3593641", "Крумовград",
"3593149", "Цалапица",
"3595942", "Люляково\,\ Бургас",
"3597754", "Кошарево",
"3597532", "Буково\,\ Благ\.",
"3594756", "Поляна\,\ Ямбол",
"35931700", "Беловица",
"3596909", "Малка\ Желязна",
"3593123", "Калояново\,\ Пловдив",
"3595128", "Житница\,\ Варна",
"3599723", "Трайково",
"3596159", "Златарица",
"3598184", "Глоджево",
"3595580", "Трояново\,\ Бургас",
"3596524", "Петърница",
"3599749", "Черни\ връх\,\ Монт\.",
"3595112", "Белослав",
"35974386", "Пирин",
"35971225", "Ново\ село\,\ София",
"3596998", "Голям\ извор\,\ Ловеч",
"3593024", "Търън",
"359750", "Боровец\,\ София",
"3594764", "Маленово",
"3598158", "Мечка\,\ Русе",
"35951537", "Чернево",
"3596133", "Михалци",
"35991184", "Ракево",
"3596555", "Байкал",
"3594368", "Търничени",
"35960373", "Посабина",
"35935502", "Фотиново\,\ Пазарджик",
"3599740", "Септемврийци\,\ Монт\.",
"3595736", "Василево",
"3593055", "Елховец",
"3596150", "Златарица",
"3593167", "Брягово\,\ Пловдив",
"35995277", "Черкаски",
"3593926", "Добрич\,\ Хаск\.",
"3595589", "Винарско",
"359579", "Албена",
"35937704", "Младиново",
"3593517", "Лесичово",
"3596900", "Васильово",
"3596034", "Славяново\,\ Търг\.",
"359701", "Дупница",
"3593545", "Драгиново",
"3595311", "Градище\,\ Шумен",
"3593534", "Попинци",
"3593752", "Малко\ градище",
"35941279", "Стрелец\,\ Ст\.\ Загора",
"3595394", "Бяла\ река\,\ Шумен",
"3597725", "Кленовик",
"35931394", "Васил\ Левски\,\ Пловдив",
"3594583", "Кипилово",
"3598644", "Чернолик",
"3598635", "Цар\ Самуил",
"3597165", "Миланово\,\ София",
"3595135", "Стефан\ Караджа\,\ Варна",
"3595144", "Камчия",
"359722", "Самоков",
"3593653", "Млечино",
"3599343", "Гомотарци",
"3595553", "Орлинци",
"3596968", "Добродан",
"3599546", "Славотин",
"35959694", "Габерово",
"3598117", "Мартен",
"35963578", "Опанец\,\ Плевен",
"35984721", "Липник",
"3599127", "Лютидол",
"3596177", "Янтра\,\ В\.\ Търново",
"359605", "Омуртаг",
"3596548", "Дебово",
"3597057", "Мало\ село",
"3599329", "Рабиша",
"3595530", "Пещерско",
"3598134", "Малко\ Враново",
"3598145", "Тръстеник\,\ Русе",
"3597110", "Опицвет",
"3593727", "Нова\ Надежда",
"3596121", "Никюп",
"35964", "Плевен",
"3593558", "Исперихово",
"35952", "Варна",
"3596986", "Дъбен",
"3595914", "Атия",
"35984466", "Звънарци",
"3594124", "Змейово",
"3597126", "Горни\ Окол",
"3597547", "Вълкосел",
"3597178", "Пролеша",
"3599171", "Оряхово\,\ Враца",
"3597179", "Големо\ Малово",
"3594727", "Малък\ манастир",
"3597753", "Ноевци",
"3593559", "Капитан\ Димитриево",
"3598672", "Брадвари",
"3595760", "Божурово\,\ Добр\.",
"35974407", "Кремен\,\ Благ\.",
"35984736", "Подайва",
"35963572", "Ясен\,\ Плевен",
"3594332", "Ветрен\,\ Ст\.\ Загора",
"3598620", "Силистра",
"3593124", "Калековец",
"3594771", "Маломир\,\ Ямбол",
"3599328", "Долни\ Лом",
"3596549", "Санадиново",
"3599724", "Станево",
"3596326", "Морава",
"3593049", "Беден",
"35963564", "Биволаре",
"3596969", "Беклемето",
"3599312", "Брегово\,\ Видин",
"3595715", "Попгригорово",
"359745", "Петрич\,\ Благ\.",
"3596523", "Крушовица\,\ Плевен",
"3593023", "Момчиловци",
"3595747", "Ваклино",
"35935256", "Сбор\,\ Пазарджик",
"3595782", "Бенковски\,\ Добр\.",
"3596932", "Микре",
"359336", "Първомай\,\ Пловдив",
"359558", "Айтос",
"35971228", "Марица",
"3596531", "Изгрев\,\ Плевен",
"3593666", "Попско",
"359570", "Каварна",
"3594517", "Ичера",
"3597445", "Баня\,\ Благ\.",
"3597434", "Струмяни",
"3595946", "Трънак",
"35981463", "Могилино",
"3594752", "Първенец\,\ Ямбол",
"35937606", "Шишманово",
"35981886", "Черешово\,\ Русе",
"3594140", "Полски\ Градец",
"3595363", "Гусла",
"3593583", "Габровица",
"3593703", "Жълти\ бряг",
"3599164", "Крушовица\,\ Враца",
"3594793", "Бояджик",
"3593764", "Поляново\,\ Хаск\.",
"3595120", "Бозвелийско",
"3599514", "Владимирово\,\ Монт\.",
"35941356", "Рупките",
"3595116", "Крумово\,\ Варна",
"3596713", "Враниловци",
"3594369", "Александрово\,\ Ст\.\ Загора",
"3595525", "Деветак",
"3596990", "Малък\ извор\,\ Ловеч",
"3597924", "Шишковци",
"3598159", "Кошов",
"3593625", "Широко\ поле",
"3594588", "Филаретово",
"35955502", "Суходол\,\ Бургас",
"3595910", "Черни\ връх\,\ Бургас",
"35991203", "Лик",
"35961703", "Върбица\,\ В\.\ Търново",
"35974388", "Горно\ Спанчево",
"35967393", "Душево",
"3598192", "Хотанца",
"3595167", "Венчан",
"3594116", "Ракитница\,\ Ст\.\ Загора",
"35931993", "Сърнегор",
"3597425", "Кулата",
"359379", "Свиленград",
"3597137", "Скравена",
"3593589", "Церово\,\ Пазарджик",
"35941334", "Съединение\,\ Ст\.\ Загора",
"3593709", "Караманци",
"3594525", "Омарчево\,\ Сливен",
"3594799", "Голям\ манастир",
"35941355", "Яворово",
"359748", "Симитли",
"35960382", "Ковачевец",
"3595517", "Равнец\,\ Бургас",
"3594566", "Питово",
"359470", "Тополовград",
"3599355", "Косово\,\ Видин",
"3595752", "Нова\ Камена",
"3595534", "Карагеоргиево",
"3593645", "Аврен\,\ Кърдж\.",
"3597935", "Долно\ село",
"3593634", "Припек\,\ Кърдж\.",
"3599136", "Галиче",
"3595140", "Шкорпиловци",
"3594363", "Габарево",
"3596138", "Недан",
"35974207", "Генерал\ Тодоров",
"3595771", "Крушари",
"35931603", "Виница",
"3593553", "Батак\,\ Пазарджик",
"35961302", "Батак\,\ В\.\ Търново",
"3598640", "Правда\,\ Силистра",
"3593135", "Кърнаре",
"35961395", "Паскалевец",
"3594715", "Калчево",
"3596030", "Светлен\,\ Търг\.",
"3594747", "Денница\,\ Ямбол",
"3593530", "Поибрене",
"35984735", "Свещари",
"35984717", "Побит\ камък\,\ Разград",
"3596154", "Буйновци",
"3598667", "Белица\,\ Силистра",
"3596543", "Муселиево",
"3593043", "Змеица",
"3595727", "Сенокос\,\ Добр\.",
"35969032", "Български\ извор",
"3596963", "Балканец",
"3593658", "Падина\,\ Кърдж\.",
"35932", "Пловдив",
"3599348", "Неговановци",
"3595558", "Дебелт",
"3596529", "Коиловци",
"3599744", "Вълчедръм",
"3595332", "Драгоево",
"35935255", "Росен\,\ Пазарджик",
"35935418", "Кръстава",
"3593937", "Ябълково\,\ Хаск\.",
"35967399", "Малки\ Вършец",
"35947353", "Българска\ поляна",
"3593029", "Петково\,\ Смол\.",
"3599182", "Девене",
"3594592", "Бяла\ паланка",
"3593076", "Цацаровци",
"3599526", "Слатина\,\ Монт\.",
"3593028", "Арда",
"3599147", "Борован",
"3596528", "Вълчитрън",
"3599349", "Сланотрън",
"3597920", "Скриняно",
"3595559", "Кубадин",
"3593151", "Раковски\,\ Пловдив",
"3599115", "Чирен",
"3596576", "Радомирци",
"35974346", "Цапарево",
"3598125", "Копривец",
"3596994", "Брестница\,\ Ловеч",
"35961308", "Вишовград",
"3597916", "Багренци",
"3596585", "Белене",
"35942", "Стара\ Загора",
"3595124", "Комарево\,\ Варна",
"3596512", "Горни\ Дъбник",
"359724", "Ихтиман",
"3596911", "Лисец\,\ Ловеч",
"3599323", "Дреновец",
"35931791", "Бегово",
"3596141", "Полски\ Тръмбеш",
"35984266", "Просторно",
"3594144", "Ковачево\,\ Ст\.\ Загора",
"3597146", "Черньово",
"3599160", "Гложене\,\ Враца",
"3594553", "Раково\,\ Сливен",
"3597527", "Горно\ Дряново",
"35984465", "Савин",
"3594356", "Хаджидимитрово\,\ Ст\.\ Загора",
"3596002", "Съединение\,\ Търг\.",
"3598166", "Сваленик",
"3597430", "Дамяница",
"3593782", "Калугерово\,\ Хаск\.",
"3593747", "Татарево\,\ Хаск\.",
"3593566", "Бошуля",
"3596718", "Драгановци",
"359608", "Попово\,\ Търг\.",
"3597042", "Коркина",
"3596066", "Буйново\,\ Търг\.",
"35984720", "Топчии",
"3596722", "Соколово\,\ Габр\.",
"35935392", "Дюлево\,\ Пазарджик",
"3599720", "Ковачица",
"35947203", "Трънково\,\ Ямбол",
"3596770", "Плачковци",
"3594798", "Савино",
"35930417", "Грохотно",
"3597717", "Дивотино",
"3595764", "Владимирово\,\ Добр\.",
"3593708", "Орлово\,\ Хаск\.",
"3595368", "Тъкач",
"3593588", "Мененкьово",
"3596956", "Ломец\,\ Ловеч",
"35960388", "Горица\,\ Търг\.",
"3597734", "Главановци\,\ Перник",
"3594736", "Светлина",
"3597745", "Егълница",
"3593120", "Храбрино",
"3598624", "Калипетрово",
"3596025", "Алваново",
"3593116", "Крумово\,\ Пловдив",
"359910", "Мездра",
"35959400", "Дъскотна",
"35937424", "Козлец",
"35930205", "Стърница",
"3597174", "Калотина",
"3594580", "Боринци",
"3593143", "Перущица",
"35974321", "Хърсово\,\ Благ\.",
"3595918", "Русокастро",
"3593554", "Козарско",
"3598196", "Нисово",
"3594112", "Бъдеще",
"3593327", "Бачково",
"35941358", "Опълченец",
"35965165", "Писарово\,\ Плевен",
"3595521", "Венец\,\ Бургас",
"3593129", "Скутаре",
"35961103", "Русаля",
"35984745", "Владимировци",
"35931387", "Пролом",
"3599729", "Расово",
"3596544", "Новачене\,\ Плевен",
"3596535", "Козар\ Белене",
"3594562", "Крива\ круша",
"3598138", "Бръшлен",
"3596153", "Златарица",
"3596964", "Велчево\,\ Ловеч",
"3595756", "Божан",
"3593044", "Лясково\,\ Смол\.",
"3593035", "Върбина",
"3595577", "Подвис\,\ Бургас",
"3595148", "Рудник\,\ Варна",
"3593677", "Дрангово\,\ Кърдж\.",
"3599132", "Кнежа",
"3598442", "Завет\,\ Разград",
"35935258", "Цар\ Асен\,\ Пазарджик",
"3598648", "Секулово",
"3594775", "Каравелово\,\ Ямбол",
"35984462", "Острово",
"35974404", "Бабяк",
"3597439", "Плоски",
"3593538", "Елшица",
"35941174", "Подслон\,\ Ст\.\ Загора",
"35931701", "Кръстевич",
"3595711", "Овчарово\,\ Добр\.",
"3599169", "Рогозен",
"3593769", "Орешец\,\ Хаск\.",
"3593633", "Рогозче",
"3595533", "Пирне",
"35971503", "Долно\ Камарци",
"35984738", "Китанчево",
"35961109", "Въглевци",
"3595336", "Имренчево",
"35963567", "Градина\,\ Плевен",
"3599340", "Септемврийци\,\ Видин",
"3597929", "Соволяно",
"3594768", "Зимница\,\ Ямбол",
"3594364", "Осетеново",
"35969243", "Казачево",
"3599522", "Котеновци",
"3593072", "Неделино",
"3599186", "Згориград",
"35935252", "Тополи\ дол",
"3596520", "Николаево\,\ Плевен",
"3597928", "Гърляно",
"3593020", "Давидково",
"35967309", "Агатово",
"3596572", "Сухаче",
"35931627", "Крушево\,\ Пловдив",
"3599518", "Мърчево",
"3596125", "Пушево",
"3597912", "Горна\ Гращица",
"359453", "Котел",
"3596516", "Искър\,\ Плевен",
"3599175", "Остров",
"3593768", "Доситеево",
"3596039", "Опака",
"3593775", "Генералово",
"3596927", "Умаревци",
"3599168", "Бутан",
"3595763", "Плачидол",
"359618", "Горна\ Оряховица",
"35963576", "Тученица",
"3598623", "Голеш\,\ Силистра",
"3597142", "Костенец",
"3595131", "Вълчи\ дол",
"3597733", "Филиповци",
"3597187", "Буново\,\ София",
"3596166", "Виноград",
"35984732", "Йонково",
"3597438", "Катунци",
"3596006", "Пресиян",
"3594352", "Горно\ Черковище",
"35961305", "Лесичери",
"3598649", "Яребица",
"3593786", "Навъсен",
"3598141", "Две\ могили",
"3593562", "Славовица\,\ Пазарджик",
"3599785", "Василовци\,\ Монт\.",
"3598697", "Сокол\,\ Силистра",
"3599557", "Горно\ Церовене",
"3595347", "Живково\,\ Шумен",
"3597046", "Бобошево",
"3596710", "Донино",
"3595149", "Голица",
"3596062", "Стража\,\ Търг\.",
"3595315", "Царев\ брод",
"35984760", "Трапище",
"35960385", "Ломци",
"35941352", "Винарово\,\ Ст\.\ Загора",
"35930257", "Вишнево",
"3596726", "Скалско",
"35984779", "Здравец\,\ Разград",
"3599324", "Ружинци",
"3598631", "Силистра",
"3595123", "Равна\,\ Варна",
"3599728", "Сливата",
"35931397", "Христо\ Даново",
"3596551", "Тръстеник\,\ Плевен",
"3593176", "Старосел",
"3593128", "Златитрап",
"3596952", "Орешак\,\ Ловеч",
"35967303", "Батошево",
"35969249", "Дойренци",
"3593700", "Тракиец",
"3594554", "Трапоклово",
"3594732", "Устрем",
"35937602", "Черна\ могила\,\ Хаск\.",
"3594143", "Сърнево\,\ Ст\.\ Загора",
"3593051", "Чепеларе",
"3595919", "Маринка",
"359677", "Трявна",
"35955505", "Драчево",
"3593112", "Марково\,\ Пловдив",
"3594327", "Шейново",
"35937707", "Щит",
"3594129", "Маджерито",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+359|\D)//g;
      my $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;