module Info.Properties where

data Property = PROP_INLINE | PROP_MULTISPECIALIZE | PROP_NOINLINE | PROP_SRCLOC_ANNOTATE | PROP_SUPERINLINE | PROP_NOETA | PROP_CYCLIC | PROP_EXPORTED | PROP_INSTANCE | PROP_JOINPOINT | PROP_METHOD | PROP_ONESHOT | PROP_PLACEHOLDER | PROP_RULEBINDER | PROP_SCRUTINIZED | PROP_SPECIALIZATION | PROP_SRCLOC_ANNOTATE_FUN | PROP_SUPERSPECIALIZE | PROP_UNSHARED | PROP_WHNF | PROP_WORKER | PROP_WRAPPER | PROP_HASRULE
    deriving(Eq,Ord,Enum,Bounded)

instance Show Property where
   show PROP_INLINE = "INLINE"
   show PROP_MULTISPECIALIZE = "MULTISPECIALIZE"
   show PROP_NOINLINE = "NOINLINE"
   show PROP_SRCLOC_ANNOTATE = "SRCLOC_ANNOTATE"
   show PROP_SUPERINLINE = "SUPERINLINE"
   show PROP_NOETA = "NOETA"
   show PROP_CYCLIC = "_CYCLIC"
   show PROP_EXPORTED = "_EXPORTED"
   show PROP_INSTANCE = "_INSTANCE"
   show PROP_JOINPOINT = "_JOINPOINT"
   show PROP_METHOD = "_METHOD"
   show PROP_ONESHOT = "_ONESHOT"
   show PROP_PLACEHOLDER = "_PLACEHOLDER"
   show PROP_RULEBINDER = "_RULEBINDER"
   show PROP_SCRUTINIZED = "_SCRUTINIZED"
   show PROP_SPECIALIZATION = "_SPECIALIZATION"
   show PROP_SRCLOC_ANNOTATE_FUN = "_SRCLOC_ANNOTATE_FUN"
   show PROP_SUPERSPECIALIZE = "_SUPERSPECIALIZE"
   show PROP_UNSHARED = "_UNSHARED"
   show PROP_WHNF = "_WHNF"
   show PROP_WORKER = "_WORKER"
   show PROP_WRAPPER = "_WRAPPER"
   show PROP_HASRULE = "_HASRULE"


{-# NOINLINE readProp #-}
readProp "INLINE" = return PROP_INLINE
readProp "MULTISPECIALIZE" = return PROP_MULTISPECIALIZE
readProp "NOINLINE" = return PROP_NOINLINE
readProp "SRCLOC_ANNOTATE" = return PROP_SRCLOC_ANNOTATE
readProp "SUPERINLINE" = return PROP_SUPERINLINE
readProp "NOETA" = return PROP_NOETA
readProp p = fail $ "Invalid Property: " ++ p

prop_INLINE = PROP_INLINE
prop_MULTISPECIALIZE = PROP_MULTISPECIALIZE
prop_NOINLINE = PROP_NOINLINE
prop_SRCLOC_ANNOTATE = PROP_SRCLOC_ANNOTATE
prop_SUPERINLINE = PROP_SUPERINLINE
prop_NOETA = PROP_NOETA
prop_CYCLIC = PROP_CYCLIC
prop_EXPORTED = PROP_EXPORTED
prop_INSTANCE = PROP_INSTANCE
prop_JOINPOINT = PROP_JOINPOINT
prop_METHOD = PROP_METHOD
prop_ONESHOT = PROP_ONESHOT
prop_PLACEHOLDER = PROP_PLACEHOLDER
prop_RULEBINDER = PROP_RULEBINDER
prop_SCRUTINIZED = PROP_SCRUTINIZED
prop_SPECIALIZATION = PROP_SPECIALIZATION
prop_SRCLOC_ANNOTATE_FUN = PROP_SRCLOC_ANNOTATE_FUN
prop_SUPERSPECIALIZE = PROP_SUPERSPECIALIZE
prop_UNSHARED = PROP_UNSHARED
prop_WHNF = PROP_WHNF
prop_WORKER = PROP_WORKER
prop_WRAPPER = PROP_WRAPPER
prop_HASRULE = PROP_HASRULE
