/****************************************************************************/
/*  Mesh hierarchy traversal:   first(), next(), ...       		    */
/****************************************************************************/

#if FE_DIM==3
typedef HELEMENT3D   GRAPE_ELEMENT;
typedef HMESH3D      GRAPE_MESH;
typedef GENMESH3D    GRAPE_GENMESH;
typedef F_HEL_INFO3D F_EL_INFO;
typedef F_HDATA3D    F_DATA;
#define Grape_Mesh  HMesh3d
#else
typedef HELEMENT2D   GRAPE_ELEMENT;
typedef HMESH2D      GRAPE_MESH;
typedef GENMESH2D    GRAPE_GENMESH;
typedef F_HEL_INFO2D F_EL_INFO;
typedef F_HDATA2D    F_DATA;
#define Grape_Mesh  HMesh2d
#endif

static int        traverse_level     = -1;
static FLAGS      traverse_fill_flag = FILL_COORDS | FILL_BOUND | FILL_NEIGH
#if FE_DIM==3
                                        | FILL_ORIENTATION
#endif
                                        | CALL_LEAF_EL;
static const EL_INFO *el_info;

/* coord has to be double [n][3], because hmesh in grape is always 
 * of dimension 3 and for FE_DIM == 2 we set the third component to zero */
static double        coord[N_VERTICES_MAX][3];
static int           vindex[N_VERTICES_MAX];
static GRAPE_ELEMENT element;

static double  *vertex[N_VERTICES_MAX] = {coord[0], coord[1],
					  coord[2], coord[3] };

/* implementation of functions */

void setup_traverse(int level, FLAGS fill_flag)
{
  traverse_level     = level;
  traverse_fill_flag = fill_flag;
  return;
}

/****************************************************************************/

static void fill_grape_element(void)
{
  int      i, j;

  for (i = 0; i < N_VERTICES(FE_DIM); i++)
  {
    vindex[i] = el_info->el->dof[i][0]; 
    for (j = 0; j < DIM_OF_WORLD; j++) {
      coord[i][j] = el_info->coord[i][j]; /* double to float conv */
    }
  }
  element.vertex = (double G_CONST*G_CONST*) vertex;
  element.vindex = vindex;

#if FE_DIM == 3
  if (el_info->orientation > 0) 
    element.descr = &tetra_description_even;
  else
    element.descr = &tetra_description_odd;
#else
    element.descr = &tria_description;
#endif

  element.eindex = INDEX(el_info->el);
  element.user_data = (void *)el_info;
}

/****************************************************************************/
static TRAVERSE_STACK *stack = nil;

/***************************************************************************/

/* returns first leaf element, which is treated like a macro element */
/* because traverse_fill_flag contains the CALL_LEAF_EL flag */
static GRAPE_ELEMENT *first_grape_element(GRAPE_GENMESH *grape_mesh,
					  MESH_ELEMENT_FLAGS flags)
{
  if (!stack) stack = get_traverse_stack();
  el_info = traverse_first(stack, (MESH *)(grape_mesh->user_data),
			   traverse_level, traverse_fill_flag);
  if (el_info)
  {
    fill_grape_element();
    element.mesh = (GRAPE_GENMESH *) grape_mesh;
    return(&element);
  }
  else
    return(nil);
}

/****************************************************************************/

/* returns next leaf element, which is treated like a macro element */
/* because traverse_fill_flag contains the CALL_LEAF_EL flag */
static GRAPE_ELEMENT *next_grape_element(GRAPE_ELEMENT *el,
					 MESH_ELEMENT_FLAGS flags)
{
  if ((el_info = traverse_next(stack, (EL_INFO *)el->user_data)))
  {
    fill_grape_element();
    return(&element);
  }
  else
    return(nil);
}

/* we have no children */
static GRAPE_ELEMENT *fake_child(GRAPE_ELEMENT *el,MESH_ELEMENT_FLAGS flags)
{
  return (nil);
}
/* we dont want to select no child */
static GRAPE_ELEMENT *fake_select(GRAPE_ELEMENT *el,double *parent_coord,
            double * child_coord, MESH_ELEMENT_FLAGS flags)
{
  return (nil);
}

/****************************************************************************/
static GRAPE_ELEMENT *complete_grape_element(GRAPE_ELEMENT *el,
					 MESH_ELEMENT_FLAGS flags)
{
  if(el_info)
    return(&element);
  else
    return(nil);
}

/* mkae copy of element is not used, because we are acting on leaf level */
static GRAPE_ELEMENT *copy_grape_element(GRAPE_ELEMENT *el,
					 MESH_ELEMENT_FLAGS flags)
{
  FUNCNAME("copy_grape_element");

  MSG("not implemented yet!\n");
  return ( nil );
}

/****************************************************************************/
/* not used, because copy_element is not implemented */
static void free_grape_element(GRAPE_ELEMENT *el)
{
  return;
}

/****************************************************************************/

static void f_bounds(GRAPE_ELEMENT *el, double* min, double* max, 
                   void *function_data)
{
  (*min) =  1.0E+308;
  (*max) = -1.0E+308;
}

/****************************************************************************/

static void grape_get_vertex_estimate(GRAPE_ELEMENT *el, double *value, 
                                      void *function_data)
{
  *value = 0.0;
  return;
}

/****************************************************************************/

static double grape_get_element_estimate(GRAPE_ELEMENT *el, void *function_data)
{
  return 0.0;
}


/****************************************************************************/
static void f_real(GRAPE_ELEMENT *el, int ind, double G_CONST *coord, 
		   double *val, void *function_data)
{
  FUNCNAME("f_real");
  EL_INFO         *el_info = (EL_INFO *)(el->user_data);
  F_DATA          *f_data = (F_DATA *)el->mesh->f_data;
  
  DOF_REAL_VEC    *u_h;
  const REAL      *uh_loc;
  const BAS_FCTS  *bas_fcts;

  static REAL     vert_coords[N_VERTICES_MAX][N_LAMBDA] = 
    {{1.0,0.0,0.0,0.0},
     {0.0,1.0,0.0,0.0},
     {0.0,0.0,1.0,0.0},
     {0.0,0.0,0.0,1.0}};
              
  if (f_data)
  {
    u_h = (DOF_REAL_VEC *)(f_data->function_data);
    if (u_h) 
    {
      if (u_h->fe_space && (bas_fcts = u_h->fe_space->bas_fcts)) {
	uh_loc   = bas_fcts->get_real_vec(el_info->el, u_h, nil);
	if (coord) 
	{
	  val[0] = eval_uh(coord, uh_loc, bas_fcts);
	}
	else 
	{
	  if ((ind >= 0) && (ind < N_VERTICES(FE_DIM)))
	  {
	    val[0] = eval_uh(vert_coords[ind], uh_loc, bas_fcts);
	  }
	  else 
	  {
	    MSG("invalid vertex number %d\n",ind);
	    val[0] = 0.0;
	  }
	}
      }
      else {
	MSG("no fe_space or bas_fcts in dof_real_vec <%s>\n", u_h->name);
	val[0] = 0.0;
      }
    }
    else {
      MSG("no dof_real_vec in f_data->user_data\n");
      val[0] = 0.0;
    }
  }
  else {
    MSG("no f_data\n");
    val[0] = 0.0;
  }
}


static void f_real_el_info(GRAPE_ELEMENT *el, F_EL_INFO *f_el_info,
			   void *function_data)
{
  FUNCNAME("f_real_el_info");
  DOF_REAL_VEC *u_h = (DOF_REAL_VEC *)(function_data);

  if (u_h && u_h->fe_space && u_h->fe_space->bas_fcts) {
    f_el_info->polynomial_degree = u_h->fe_space->bas_fcts->degree;
  }
  else {
    ERROR("no uh or fe_space or bas_fcts\n");
    f_el_info->polynomial_degree = 1;
  }

  return;
}

/****************************************************************************/

static void f_real_d(GRAPE_ELEMENT *el, int ind, double G_CONST *coord,
		     double *val, void *function_data)
{
  FUNCNAME("f_real_d");
  EL_INFO         *el_info = (EL_INFO *)(el->user_data);
  F_DATA          *f_data = (void *)el->mesh->f_data;
  DOF_REAL_D_VEC  *u_h;
  const REAL_D    *uh_loc;
  const BAS_FCTS  *bas_fcts;
  static REAL     vert_coords[N_VERTICES_MAX][N_LAMBDA] = 
    {{1.0,0.0,0.0,0.0},
     {0.0,1.0,0.0,0.0},
     {0.0,0.0,1.0,0.0},
     {0.0,0.0,0.0,1.0}};
              
  if (f_data)
  {
    u_h = (DOF_REAL_D_VEC *)(f_data->function_data);
    if (u_h) 
    {
      if (u_h->fe_space && (bas_fcts = u_h->fe_space->bas_fcts)) {
	uh_loc   = bas_fcts->get_real_d_vec(el_info->el, u_h, nil);
	if (coord) 
	{
	  eval_uh_d(coord, uh_loc, bas_fcts, val);
	}
	else 
	{
	  if ((ind >= 0) && (ind < N_VERTICES(FE_DIM)))
	  {
	    eval_uh_d(vert_coords[ind], uh_loc, bas_fcts, val);
	  }
	  else 
	  {
	    MSG("invalid vertex number %d\n",ind);
	    val[0] = 0.0;
	  }
	}
      }
      else {
	MSG("no fe_space or bas_fcts in dof_real_vec <%s>\n", u_h->name);
	val[0] = 0.0;
      }
    }
    else {
      MSG("no dof_real_vec in f_data->user_data\n");
      val[0] = 0.0;
    }
  }
  else {
    MSG("no f_data\n");
    val[0] = 0.0;
  }
}


static void f_real_d_el_info(GRAPE_ELEMENT *el, F_EL_INFO *f_el_info,
			     void *function_data)
{
  FUNCNAME("f_real_el_info");
  DOF_REAL_D_VEC *u_h = (DOF_REAL_D_VEC *)(function_data);

  if (u_h && u_h->fe_space && u_h->fe_space->bas_fcts) {
    f_el_info->polynomial_degree = u_h->fe_space->bas_fcts->degree;
  }
  else {
    ERROR("no uh or fe_space or bas_fcts\n");
    f_el_info->polynomial_degree = 1;
  }

  return;
}

/****************************************************************************/

static void f_schar(GRAPE_ELEMENT *el, int ind, double G_CONST *coord,
		    double *val, void *function_data)
{
  FUNCNAME("f_schar");
  EL_INFO         *el_info = (EL_INFO *)(el->user_data);
  DOF             **dof;
  const DOF_ADMIN *admin;
  F_DATA          *f_data = (void *)el->mesh->f_data;
  DOF_SCHAR_VEC   *sc_freiburg;
  int             i, n0;

  if (f_data)
  {
    sc_freiburg = (DOF_SCHAR_VEC *)(f_data->function_data);
    if (sc_freiburg) 
    {
      if (sc_freiburg->fe_space && (admin = sc_freiburg->fe_space->admin)) {
	if (admin->n_dof[VERTEX] < 1)
	{
	  MSG("no vertex dofs in admin\n");
	  val[0] = 0.0;
	  return;
	}
	dof = el_info->el->dof;
	n0 = sc_freiburg->fe_space->admin->n0_dof[VERTEX];
	if (coord) 
	{
	  val[0] = 0.0;
	  for (i = 0; i < N_VERTICES(FE_DIM); i++) {
	    val[0] += coord[i] * sc_freiburg->vec[dof[i][n0]];
	  }
	}
	else 
	{
	  if ((ind >= 0) && (ind < N_VERTICES(FE_DIM)))
	  {
	    val[0] = sc_freiburg->vec[dof[ind][n0]];
	  }
	  else 
	  {
	    MSG("invalid vertex number %d\n",ind);
	    val[0] = 0.0;
	  }
	}
      }
      else {
	MSG("no fe_space or dof_admin dof_schar_vec <%s>\n",
	    sc_freiburg->name);
      }
    }
    else {
      MSG("no dof_real_vec in f_data->user_data\n");
      val[0] = 0.0;
    }
  }
  else {
    MSG("no f_data\n");
    val[0] = 0.0;
  }
}

static void f_schar_el_info(GRAPE_ELEMENT *el, F_EL_INFO *f_el_info,
			    void *function_data)
{
  f_el_info->polynomial_degree = 1;
  return;
}

/*************************************************************************/


void grape_ini_f_data(GRAPE_MESH *grape_mesh, DOF_REAL_VEC *dof_vec)
{
  FUNCNAME("grape_ini_f_data");
  F_DATA *f_data = NULL;

  if (!grape_mesh)
  {
    MSG("no grape_mesh\n");
    return;
  }

  if (dof_vec && dof_vec->vec)
  {
    for (f_data = (void *)grape_mesh->f_data; f_data;
	       f_data = (void *)f_data->next)
    {
      if (f_data->function_data == dof_vec)
      	break;
    }

    if (!f_data)
        for (f_data = (void *)grape_mesh->f_data; f_data;
	        f_data = (void *)f_data->last)
    {     
	    if (f_data->function_data == dof_vec)
	      break;
    }


    if (!f_data) 
    {
      MSG("generate f_data for `%s'\n", dof_vec->name);
      f_data = (F_DATA *)g_mem_alloc(sizeof(F_DATA));
      f_data->name = (char *) dof_vec->name;
      f_data->dimension_of_value = 1;
      if (strstr(dof_vec->fe_space->bas_fcts->name, "disc"))
      	f_data->continuous_data    = 0;
      else
      	f_data->continuous_data    = 1;

      f_data->f                   = f_real;
      f_data->f_el_info           = f_real_el_info;
      f_data->next = grape_mesh->f_data;
      f_data->last = grape_mesh->f_data ? grape_mesh->f_data->last : nil;
      f_data->function_data = (void *) dof_vec;

      f_data->get_bounds      = f_bounds;
      f_data->get_vertex_estimate   = grape_get_vertex_estimate;
      f_data->get_element_estimate  = grape_get_element_estimate;
      f_data->threshold     = 0.0;
#if FE_DIM == 3
      f_data->geometry_threshold     = 0.0;
#endif
      f_data->hp_threshold    = 0.0;
      f_data->hp_maxlevel     = 0;

      grape_mesh->f_data = (GENMESH_FDATA *) f_data;
    
    }
    else if (grape_mesh->f_data != (GENMESH_FDATA *)f_data)
    {
      MSG("select f_data for `%s'\n", dof_vec->name);
      grape_mesh->f_data = (GENMESH_FDATA *)f_data;
    }
  }  
  else
  {
    MSG("no dof_vec, or no vec\n");
  }

  return;
}

void grape_ini_f_data_d(GRAPE_MESH *grape_mesh, DOF_REAL_D_VEC *dof_vec)
{
  FUNCNAME("grape_ini_f_data_d");
  F_DATA *f_data=NULL;

  if (!grape_mesh)
  {
    MSG("no grape_mesh\n");
    return;
  }

  if (dof_vec && dof_vec->vec)
  {
    for (f_data = (void *)grape_mesh->f_data; f_data;
	       f_data = (void *)f_data->next)
    {
      if (f_data->function_data == dof_vec)
      	break;
    }

    if (!f_data)
      for (f_data = (void *)grape_mesh->f_data; f_data;
	      f_data = (void *)f_data->last)
      {     
	      if (f_data->function_data == dof_vec)
	        break;
      }


    if (!f_data) 
    {
      MSG("generate f_data for `%s'\n", dof_vec->name);
      f_data = (F_DATA *)g_mem_alloc(sizeof(F_DATA));
      f_data->name = (char *) dof_vec->name;
      f_data->dimension_of_value = DIM_OF_WORLD;
      if (strstr(dof_vec->fe_space->bas_fcts->name, "disc"))
      	f_data->continuous_data    = 0;
      else
      	f_data->continuous_data    = 1;

      f_data->f                   = f_real_d;
      f_data->f_el_info           = f_real_d_el_info;
      f_data->next = grape_mesh->f_data;
      f_data->last = grape_mesh->f_data ? grape_mesh->f_data->last : nil;
      f_data->function_data = (void *) dof_vec;

      f_data->get_bounds      = f_bounds;
      f_data->get_vertex_estimate   = grape_get_vertex_estimate;
      f_data->get_element_estimate  = grape_get_element_estimate;
      f_data->threshold     = 0.0;
#if FE_DIM == 3
      f_data->geometry_threshold     = 0.0;
#endif

      f_data->hp_threshold    = 0.0;
      f_data->hp_maxlevel     = 0;

      
      grape_mesh->f_data = (GENMESH_FDATA *)f_data;
    }
    else if (grape_mesh->f_data != (GENMESH_FDATA *)f_data)
    {
      MSG("select f_data for `%s'\n", dof_vec->name);
      grape_mesh->f_data = (GENMESH_FDATA *)f_data;
    }
  }  
  else
  {
    MSG("no dof_vec, or no vec\n");
  }

  return;
}

void grape_ini_f_data_s_vec(GRAPE_MESH *grape_mesh, DOF_SCHAR_VEC *dof_vec)
{
  FUNCNAME("grape_ini_f_data_s_vec");
  F_DATA  *f_data;

  if (!grape_mesh)
  {
    MSG("no grape_mesh\n");
    return;
  }

  if (dof_vec && dof_vec->vec)
  {
    for (f_data = (void *)grape_mesh->f_data; f_data;
	       f_data = (void *)f_data->next)
    {
      if (f_data->function_data == dof_vec)
      	break;
    }

    if (!f_data)
        for (f_data = (void *)grape_mesh->f_data; f_data;
	        f_data = (void *)f_data->last)
    {     
	    if (f_data->function_data == dof_vec)
	      break;
    }


    if (!f_data) 
    {
      MSG("generate f_data for `%s'\n", dof_vec->name);
      f_data = (F_DATA *)g_mem_alloc(sizeof(F_DATA));
      f_data->name = (char *) dof_vec->name;
      f_data->dimension_of_value = 1;
     	f_data->continuous_data    = 1;

      f_data->f                   = f_schar;
      f_data->f_el_info           = f_schar_el_info;
      f_data->next = grape_mesh->f_data;
      f_data->last = grape_mesh->f_data ? grape_mesh->f_data->last : nil;
      f_data->function_data = (void *) dof_vec;

      f_data->get_bounds      = f_bounds;
      f_data->get_vertex_estimate   = grape_get_vertex_estimate;
      f_data->get_element_estimate  = grape_get_element_estimate;
      f_data->threshold     = 0.0;
#if FE_DIM == 3
      f_data->geometry_threshold     = 0.0;
#endif
      f_data->hp_threshold    = 0.0;
      f_data->hp_maxlevel     = 0;

      grape_mesh->f_data = (GENMESH_FDATA *)f_data;
    
    }
    else if (grape_mesh->f_data != (GENMESH_FDATA *)f_data)
    {
      MSG("select f_data for `%s'\n", dof_vec->name);
      grape_mesh->f_data = (GENMESH_FDATA *)f_data;
    }
  }  
  else
  {
    MSG("no dof_vec, or no vec\n");
  }

  return;
}

/****************************************************************************/
/* handling of multiple functions (selection by next/last)                  */
/****************************************************************************/

static GRAPE_MESH *next_f_data_send(void)
{
  GRAPE_MESH *self;

  self = (GRAPE_MESH *)START_METHOD(G_INSTANCE);
  ASSURE(self, "", END_METHOD(NULL));

  if (self->f_data && self->f_data->next)
  {
    self->f_data->next->last = self->f_data;  /*only to be sure...*/
    self->f_data = self->f_data->next;
  }
  if (self->f_data)
    printf("new f_data is: %s\n", self->f_data->name);

  END_METHOD(self);
}

static GRAPE_MESH *prev_f_data_send(void)
{
  GRAPE_MESH *self;

  self = (GRAPE_MESH *)START_METHOD(G_INSTANCE);
  ASSURE(self, "", END_METHOD(NULL));

  if (self->f_data && self->f_data->last)
  {
    self->f_data->last->next = self->f_data;  /*only to be sure...*/
    self->f_data = self->f_data->last;
  }
  if (self->f_data)
    printf("new f_data is: %s\n", self->f_data->name);

  END_METHOD(self);
}

static void grape_add_methods(void)
{
  static int first=1;

  if (first) {
    first = 0;
    GRAPE(Grape_Mesh,"add-method")("next-f-data-send",next_f_data_send);
    GRAPE(Grape_Mesh,"add-method")("prev-f-data-send",prev_f_data_send);
  }
}

/****************************************************************************/
/* convert ALBERTA mesh into GRAPE mesh                                      */
/****************************************************************************/

GRAPE_MESH *setup_grape_mesh(MESH *mesh, char *name)
{
  FUNCNAME("setup_grape_mesh");
  GRAPE_MESH *grape_mesh;
  int        i, j;

  grape_add_methods();

  ASSURE((grape_mesh = (GRAPE_MESH *)GRAPE(Grape_Mesh,"new-instance")(name)),
	       "can't get Grape Mesh instance",
	       return(nil));

  grape_mesh->max_level = 0;

  for(i=0; i<N_VERTICES(FE_DIM); i++)
    for(j=0; j<3; j++)
      coord[i][j] = 0.0;

  /* Funktioniert halt nur fuer alle leaf Element, gell! */
  grape_mesh->first_child  = fake_child;
  grape_mesh->next_child   = fake_child;
  grape_mesh->first_macro  = first_grape_element;
  grape_mesh->next_macro   = next_grape_element;
  grape_mesh->copy_element  = copy_grape_element;
  grape_mesh->free_element  = free_grape_element;

  grape_mesh->select_child = fake_select;
  grape_mesh->complete_element = complete_grape_element;
  
  /* robert: hier lieber nitch NULL setzen, wer weiss?
    grape_mesh->get_lens_element_estimate = NULL;
    grape_mesh->get_geometry_element_estimate = NULL;
    grape_mesh->get_geometry_vertex_estimate = NULL;
    grape_mesh->set_time = NULL;
    grape_mesh->get_time = NULL;
  */


  grape_mesh->max_number_of_vertices = N_VERTICES(FE_DIM);
  grape_mesh->max_eindex = mesh->n_hier_elements;
  grape_mesh->max_vindex = mesh->n_vertices;
  grape_mesh->max_dimension_of_coord = N_VERTICES(FE_DIM);

  grape_mesh->max_dindex = 1;

  grape_mesh->level_of_interest = grape_mesh->max_level;

#if FE_DIM==2
#if (DIM_OF_WORLD > 2) || ADD_Z
  grape_mesh->dimension_of_world = 3;  /* !!!! */
#else
  grape_mesh->dimension_of_world = 2;
#endif
#endif

  grape_mesh->user_data = (void *)mesh;
 
  element.mesh  = (GRAPE_GENMESH *) grape_mesh;
#if FE_DIM==2
  element.descr = &tria_description;
#else
  element.descr = &tetra_description_even;
#endif

  /* adjust max_vindex such that simple algorithm is ok. (dof[v][0]) */
  for (i = 0; i < mesh->n_dof_admin; i++) {
    if ((mesh->dof_admin[i]->n_dof[VERTEX] > 0) &&
	(mesh->dof_admin[i]->n0_dof[VERTEX] == 0)) {
      grape_mesh->max_vindex = mesh->dof_admin[i]->size_used;
      MSG("use admin <%s> for vertex numbering, max=%d\n",
	  NAME(mesh->dof_admin[i]), mesh->dof_admin[i]->size_used);
      break;
    }
  }


  return(grape_mesh);
}

/****************************************************************************/
