/*--------------------------------------------------------------------------*/
/* ALBERTA:  an Adaptive multi Level finite element toolbox using           */
/*           Bisectioning refinement and Error control by Residual          */
/*           Techniques for scientific Applications                         */
/*                                                                          */
/* file:     Common/element.c                                               */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  authors:   Alfred Schmidt                                               */
/*             Zentrum fuer Technomathematik                                */
/*             Fachbereich 3 Mathematik/Informatik                          */
/*             Univesitaet Bremen                                           */
/*             Bibliothekstr. 2                                             */
/*             D-28359 Bremen, Germany                                      */
/*                                                                          */
/*             Kunibert G. Siebert                                          */
/*             Institut fuer Mathematik                                     */
/*             Universitaet Augsburg                                        */
/*             Universitaetsstr. 14                                         */
/*             D-86159 Augsburg, Germany                                    */
/*                                                                          */
/*  http://www.mathematik.uni-freiburg.de/IAM/ALBERTA                       */
/*                                                                          */
/*  (c) by A. Schmidt and K.G. Siebert (1996-2003)                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

#include "alberta.h"

#include "element_0d.c"
#include "element_1d.c"
#if DIM_OF_WORLD > 1
#include "element_2d.c"
#if DIM_OF_WORLD > 2
#include "element_3d.c"
#endif
#endif


int *sorted_wall_indices(const int dim, int wall, int permno)
{
  FUNCNAME("wall_orientation");

  switch(dim) {
  case 0:
    WARNING("Does not makes sense for dim == 0!\n");
    break;
  case 1:
    return sorted_wall_indices_1d(wall, permno);
    break;
#if DIM_OF_WORLD > 1
  case 2:
    return sorted_wall_indices_2d(wall, permno);
    break;
#if DIM_OF_WORLD > 2
  case 3:
    return sorted_wall_indices_3d(wall, permno);
    break;
#endif
#endif
  default:
    ERROR_EXIT("Illegal dim!\n");
  }

  return nil;                                 /* Statement is not reached. */
}

int wall_orientation(const int dim,
		     const EL *el, int wall, int **vecp)
{
  FUNCNAME("wall_orientation");

  switch(dim) {
  case 0:
    WARNING("Does not makes sense for dim == 0!\n");
    break;
  case 1:
    return wall_orientation_1d(el, wall, vecp);
    break;
#if DIM_OF_WORLD > 1
  case 2:
    return wall_orientation_2d(el, wall, vecp);
    break;
#if DIM_OF_WORLD > 2
  case 3:
    return wall_orientation_3d(el, wall, vecp);
    break;
#endif
#endif
  default:
    ERROR_EXIT("Illegal dim!\n");
  }

  return -1;                                 /* Statement is not reached. */
}

int *sort_wall_indices(const int dim,
			     const EL *el, int wall, int *vec)
{
  FUNCNAME("sort_wall_indices");

  switch(dim) {
  case 0:
    WARNING("Does not makes sense for dim == 0!\n");
    break;
  case 1:
    return sort_wall_indices_1d(el, wall, vec);
    break;
#if DIM_OF_WORLD > 1
  case 2:
    return sort_wall_indices_2d(el, wall, vec);
    break;
#if DIM_OF_WORLD > 2
  case 3:
    return sort_wall_indices_3d(el, wall, vec);
    break;
#endif
#endif
  default:
    ERROR_EXIT("Illegal dim!\n");
  }

  return nil;                                 /* Statement is not reached. */
}
