#
# $1: name of the enable-switch (e.g. el-index)
# $2: help string
# $3: one of {0,1}, default value
#
# _OR_
#
# $1: name of the enable/disable option
# $2: help string
# $3: default value
# $4: name of the preprocessor/Makefile/shell variable
#
# Results: declare proper AC_ARG_ENABLE(), define make-file
# subsitution (e.g. EL_INDEX), define automake conditional
# (e.g. EL_INDEX).
#
AC_DEFUN([ALBERTA_ENABLE_FLAG],
[m4_if($#,3,
       [m4_define([FLAGNAME], [m4_bpatsubst(m4_toupper([$1]),-,_)])],
       [m4_define([FLAGNAME], [m4_bpatsubst(m4_toupper([$4]),-,_)])])
m4_if([$3],[1],
      [m4_define([NEGDEFAULT],[disable])
       m4_define([DEFAULT],[enabled])],
      [m4_define([NEGDEFAULT],[enable])
       m4_define([DEFAULT],[disabled])])
AC_ARG_ENABLE($1,
	AC_HELP_STRING(--[]NEGDEFAULT[]-$1,
			[$2 (default: DEFAULT)]),
	[case "$enableval" in
		yes)
			FLAGNAME=1
			;;
		no)
			FLAGNAME=0
			;;
		*)
			AC_MSG_ERROR(["--[]NEGDEFAULT[]-$1" does not take an argument.])
			;;
	esac],
	[FLAGNAME=$3])
AC_SUBST(FLAGNAME)
AM_CONDITIONAL(FLAGNAME, [test "$[]FLAGNAME" -eq 1])
])
