macro(PARSE_ARGUMENTS LIST_VARS BOOLEAN_VARS DEFAULT_VAR)
    set(CURRENT_VAR ${DEFAULT_VAR})
    foreach (arg ${ARGN})
        set(skip_this_arg FALSE)
        foreach(var ${LIST_VARS})
            if (${arg} STREQUAL ${var})
                set(CURRENT_VAR ${var})
                set(skip_this_arg TRUE)
                break()
            endif()
        endforeach ()
        if (NOT skip_this_arg)
            set(skip_this_arg FALSE)
            foreach(var ${BOOLEAN_VARS})
                if (${arg} STREQUAL ${var})
                    set(${var} TRUE)
                    set(skip_this_arg TRUE)
                    break()
                endif()
            endforeach()
            if (NOT skip_this_arg)
                set(${CURRENT_VAR} ${${CURRENT_VAR}} ${arg})
            endif()
        endif()
    endforeach ()
endmacro()

function(NEW_EXECUTABLE EXECUTABLE)
    set(EXCLUDE_FROM_ALL)
    set(SOURCES)
    set(LIBRARIES)
    set(DEFAULT)
    PARSE_ARGUMENTS("SOURCES;LIBRARIES" "EXCLUDE_FROM_ALL" "DEFAULT" ${ARGN})
    set(SOURCES ${DEFAULT} ${SOURCES})
    if (EXCLUDE_FROM_ALL)
        set(EXCLUDE_FROM_ALL EXCLUDE_FROM_ALL)
    endif()
    add_executable(${EXECUTABLE} ${EXCLUDE_FROM_ALL} ${SOURCES})
    target_link_libraries(${EXECUTABLE} ${LIBRARIES})
endfunction()
