/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

#ifdef USE_OLD_FUNCTIONS
int sci_mysql_create_db(char * fname)
{
  int m_sql_pointer_in,  n_sql_pointer_in, * sql_pointer_in = NULL;
  int * db = NULL;
  int m_out = 1, n_out = 1, l_out;
  MYSQL * mysql_ptr = NULL;
  void * ptr_in = NULL;
  char * cdb = NULL;
  SciErr _SciErr;
  double result;

  CheckRhs(2,2);
  CheckLhs(0,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_res_pointer_in);
  getPointer(pvApiCtx, sql_res_pointer_in, &ptr_in);
  mysql_res_ptr = (MYSQL *)ptr_in;

  if (mysql_ptr==NULL)
    {
      Scierror(999,"%s: problem with the mysql pointer\n", fname);
      return 0;
    }

  _SciErr = getVarAddressFromPosition(pvApiCtx, 2, &db);
  getAllocatedSingleString(pvApiCtx, db, &cdb);

  result = (double)mysql_create_db(mysql_ptr, cdb);
  
  createScalarDouble(pvApiCtx, Rhs+1, result);

  LhsVar(1) = Rhs + 1;

  freeAllocatedSingleString(cdb);

  return 0;
}
#endif
