/* Driver template for the LEMON parser generator.
** Copyright 1991-1995 by D. Richard Hipp.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
** 
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the
** Free Software Foundation, Inc., 59 Temple Place - Suite 330,
** Boston, MA  02111-1307, USA.
**
** Modified 1997 to make it suitable for use with makeheaders.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 53 "cpp/PreExprParser.lem"

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "Puma/Limits.h"
#include "Puma/PreExpr.h"
#include "Puma/Location.h"
#include "Puma/ErrorStream.h"
#include "Puma/PreExprParser.h"
#include "Puma/PreExprLexer.h"

#ifdef _MSC_VER
#define strtoull(nptr,endptr,base) _strtoui64(nptr,endptr,base)
#define strtold(nptr,endptr) strtod(nptr,endptr)
#endif

using namespace Puma;

void *PreExprParserAlloc (void *(*mallocProc)(...));
void PreExprParser       (void *pParser, int TokenID, char *TokenValue, int &result);
void PreExprParserFree   (void *pParser, void (*freeProc)(...));
void PreExprParserTrace  (FILE *TraceFILE, char *zTracePrompt);

namespace Puma {

extern int          TRACE_CPP;
static bool         parse_error;
static bool         at_eos;
static char        *current_token;
static ErrorStream *err;
static Location     location;

// Constructor.
PreExpr::PreExpr (ErrorStream *_err, Location _location) {
  err      = _err;
  location = _location;
  _result  = false;
}

// Convert char to integer.
long double PreExpr::convertChar(char *value) {
  long double cval;

  char *p = value;
  if (*++p == '\\') {
    p++;
    if (*p == 'x' || *p == 'X') {
      char *copy = new char[strlen (value) + 1];
      strcpy (copy, value);
      *(copy + 1) = '0';
      cval = strtoull (copy + 1, NULL, 16);
      delete[] copy;
    }
    else if (*p >= '0' && *p <= '9') {
      cval = strtoull (p, NULL, 8);
      if (cval > 255) cval = 255;
    }
    else {
      switch (*p) {
        case 'a': cval = 7; break;
        case 'b': cval = 8; break;
        case 't': cval = 9; break;
        case 'n': cval = 10; break;
        case 'v': cval = 11; break;
        case 'f': cval = 12; break;
        case 'r': cval = 13; break;
        default: cval = *p;
      }
    }
  } else
    cval = (long double) value[1];

  return cval;
}

// Evaluate the given expression string.
void PreExpr::evaluatePreExpr (char *token_list) {
  parse_error = false;
  at_eos = false;
  int result = 0, token;
  bool empty_expr = true;

  // Generate the Lemon parser.
  void *pParser = PreExprParserAlloc ((void* (*)(...))malloc);

#ifndef NDEBUG
  // Enable tracing if requested.
  if (TRACE_CPP)
    PreExprParserTrace (stdout, "CPP_EXPR_TRACE: ");
#endif

  // Initialize the scan buffer with the expression string.
  PreExprLexer &lexer = PreExprLexer::instance ();
  LexerBuffer lexer_buffer;
  lexer_buffer.init (token_list);
  PreExprLexer::State lexer_state (lexer, lexer_buffer);

//  cout << "---" << endl;
  while (lexer_state.next ()) {
    if (lexer_state.error ()) {
      *err << sev_error << location
        << "Invalid token '" << lexer_state.text ().c_str () << "' in preprocessor expression" << endMessage;
      break;
    }
    else {
//      std::cout << "Id: " << lexer_state.id ()
//           << " Text: " << lexer_state.text ()
//           << std::endl;
      token = lexer_state.id();
      if (token != TOK_EXPR_WSPACE) {
        empty_expr = false;
        current_token = StrCol::dup(lexer_state.text().c_str());
        // Parse the current token.
        if (TRACE_CPP)
          printf ("%sToken '%s' %i\n", "CPP_EXPR_TRACE: ", current_token, token);
        PreExprParser (pParser, token, current_token, result);
      }
    }
  }

  // Finish and then free the parser.
  if (! parse_error && ! empty_expr) {
    at_eos = true; // Catch EOS parse errors
    PreExprParser (pParser, 0, (char*) 0, result);
  }
  PreExprParserFree (pParser, (void (*)(...))::free);

  if (empty_expr) {
    *err << location << sev_warning
         << "empty expression in conditional"
         << endMessage;
  }

  if (result && ! parse_error)
    _result = true;
  else
    _result = false;
}

// Handle positive and negative value overflow
long double overflow(long double value) {
  if (value > ULLONG_MAX)
  {
    value = overflow(value - ULLONG_MAX);
  }
  else if (value < LLONG_MIN)
  {
    value = overflow(LLONG_MAX - (-value + LLONG_MIN - 1));
  }
  return value;
}

} // namespace Puma

#line 180 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    PreExprParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is PreExprParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    PreExprParserARGDECL       is a declaration of a 3rd argument to the
**                       parser, or null if there is no extra argument.
**    PreExprParserKRARGDECL     A version of PreExprParserARGDECL for K&R C.
**    PreExprParserANSIARGDECL   A version of PreExprParserARGDECL for ANSI C.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 39
#define YYACTIONTYPE unsigned char
#define PreExprParserTOKENTYPE char*
typedef union {
  PreExprParserTOKENTYPE yy0;
  PreExpr* yy25;
  int yy77;
} YYMINORTYPE;
#define YYSTACKDEPTH 1000
#define PreExprParserARGDECL ,result
#define PreExprParserXARGDECL int &result;
#define PreExprParserANSIARGDECL ,int &result
#define YYNSTATE 61
#define YYNRULE 33
#define YYERRORSYMBOL 34
#define YYERRSYMDT yy77
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)
/* Next is the action table.  Each entry in this table contains
**
**  +  An integer which is the number representing the look-ahead
**     token
**
**  +  An integer indicating what action to take.  Number (N) between
**     0 and YYNSTATE-1 mean shift the look-ahead and go to state N.
**     Numbers between YYNSTATE and YYNSTATE+YYNRULE-1 mean reduce by
**     rule N-YYNSTATE.  Number YYNSTATE+YYNRULE means that a syntax
**     error has occurred.  Number YYNSTATE+YYNRULE+1 means the parser
**     accepts its input.
**
**  +  A pointer to the next entry with the same hash value.
**
** The action table is really a series of hash tables.  Each hash
** table contains a number of entries which is a power of two.  The
** "state" table (which follows) contains information about the starting
** point and size of each hash table.
*/
struct yyActionEntry {
  YYCODETYPE   lookahead;   /* The value of the look-ahead token */
  YYACTIONTYPE action;      /* Action to take for this look-ahead */
  struct yyActionEntry *next; /* Next look-ahead with the same hash, or NULL */
};
static struct yyActionEntry yyActionTable[] = {
/* State 0 */
  {  32,   1, &yyActionTable[   2] }, /* conditional_expression shift  1 */
  {  33,   2, &yyActionTable[   6] }, /*    constant_expression shift  2 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  35,  95, &yyActionTable[   8] }, /*         pre_expression accept */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[   9] }, /*       unary_expression shift  7 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  23,   9, &yyActionTable[  11] }, /*          TOK_EXPR_PLUS shift  9 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  21,  17, &yyActionTable[  12] }, /*           TOK_EXPR_OCT shift  17 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {  29,  13, &yyActionTable[  14] }, /*         TOK_EXPR_TILDE shift  13 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
/* State 1 */
  {   0,  61, 0                    }, /*                      $ reduce 0 */
/* State 2 */
  {YYNOCODE,0,0}, /* Unused */
  {   1,  27, 0                    }, /*           TOK_EXPR_AND shift  27 */
  {   2,  33, 0                    }, /*        TOK_EXPR_BITAND shift  33 */
  {   3,  29, 0                    }, /*         TOK_EXPR_BITOR shift  29 */
  {   4,  31, 0                    }, /*        TOK_EXPR_BITXOR shift  31 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {   9,  35, 0                    }, /*            TOK_EXPR_EQ shift  35 */
  {YYNOCODE,0,0}, /* Unused */
  {  11,  45, 0                    }, /*           TOK_EXPR_GEQ shift  45 */
  {  12,  41, 0                    }, /*       TOK_EXPR_GREATER shift  41 */
  {YYNOCODE,0,0}, /* Unused */
  {  14,  43, 0                    }, /*           TOK_EXPR_LEQ shift  43 */
  {  15,  39, 0                    }, /*          TOK_EXPR_LESS shift  39 */
  {YYNOCODE,0,0}, /* Unused */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {YYNOCODE,0,0}, /* Unused */
  {  20,  37, 0                    }, /*         TOK_EXPR_NOTEQ shift  37 */
  {YYNOCODE,0,0}, /* Unused */
  {  22,  25, 0                    }, /*            TOK_EXPR_OR shift  25 */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
  {  24,   3, 0                    }, /*      TOK_EXPR_QUESTION shift  3 */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  57, 0                    }, /*        TOK_EXPR_SHIFTL shift  57 */
  {  27,  59, 0                    }, /*        TOK_EXPR_SHIFTR shift  59 */
  {  28,  51, 0                    }, /*          TOK_EXPR_STAR shift  51 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 3 */
  {  32,   4, &yyActionTable[  51] }, /* conditional_expression shift  4 */
  {  33,   2, &yyActionTable[  55] }, /*    constant_expression shift  2 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[  57] }, /*       unary_expression shift  7 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  23,   9, &yyActionTable[  58] }, /*          TOK_EXPR_PLUS shift  9 */
  {  21,  17, &yyActionTable[  60] }, /*           TOK_EXPR_OCT shift  17 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {  29,  13, &yyActionTable[  61] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 4 */
  {   6,   5, 0                    }, /*         TOK_EXPR_COLON shift  5 */
/* State 5 */
  {  32,   6, &yyActionTable[  68] }, /* conditional_expression shift  6 */
  {  33,   2, &yyActionTable[  72] }, /*    constant_expression shift  2 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[  74] }, /*       unary_expression shift  7 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  23,   9, &yyActionTable[  75] }, /*          TOK_EXPR_PLUS shift  9 */
  {  21,  17, &yyActionTable[  77] }, /*           TOK_EXPR_OCT shift  17 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {  29,  13, &yyActionTable[  78] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 6 */
  {YYNOCODE,0,0}, /* Unused */
/* State 7 */
  {YYNOCODE,0,0}, /* Unused */
/* State 8 */
  {YYNOCODE,0,0}, /* Unused */
/* State 9 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  21,  17, &yyActionTable[  91] }, /*           TOK_EXPR_OCT shift  17 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,  10, &yyActionTable[  87] }, /*       unary_expression shift  10 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {  23,   9, &yyActionTable[  93] }, /*          TOK_EXPR_PLUS shift  9 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[  94] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 10 */
  {YYNOCODE,0,0}, /* Unused */
/* State 11 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  21,  17, &yyActionTable[ 108] }, /*           TOK_EXPR_OCT shift  17 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,  12, &yyActionTable[ 104] }, /*       unary_expression shift  12 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {  23,   9, &yyActionTable[ 110] }, /*          TOK_EXPR_PLUS shift  9 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 111] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 12 */
  {YYNOCODE,0,0}, /* Unused */
/* State 13 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  21,  17, &yyActionTable[ 125] }, /*           TOK_EXPR_OCT shift  17 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,  14, &yyActionTable[ 121] }, /*       unary_expression shift  14 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {  23,   9, &yyActionTable[ 127] }, /*          TOK_EXPR_PLUS shift  9 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 128] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 14 */
  {YYNOCODE,0,0}, /* Unused */
/* State 15 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  21,  17, &yyActionTable[ 142] }, /*           TOK_EXPR_OCT shift  17 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,  16, &yyActionTable[ 138] }, /*       unary_expression shift  16 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {  23,   9, &yyActionTable[ 144] }, /*          TOK_EXPR_PLUS shift  9 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 145] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 16 */
  {YYNOCODE,0,0}, /* Unused */
/* State 17 */
  {YYNOCODE,0,0}, /* Unused */
/* State 18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 19 */
  {YYNOCODE,0,0}, /* Unused */
/* State 20 */
  {YYNOCODE,0,0}, /* Unused */
/* State 21 */
  {YYNOCODE,0,0}, /* Unused */
/* State 22 */
  {  32,  23, &yyActionTable[ 160] }, /* conditional_expression shift  23 */
  {  33,   2, &yyActionTable[ 164] }, /*    constant_expression shift  2 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 166] }, /*       unary_expression shift  7 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  23,   9, &yyActionTable[ 167] }, /*          TOK_EXPR_PLUS shift  9 */
  {  21,  17, &yyActionTable[ 169] }, /*           TOK_EXPR_OCT shift  17 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {  29,  13, &yyActionTable[ 170] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 23 */
  {  25,  24, 0                    }, /*        TOK_EXPR_RPAREN shift  24 */
/* State 24 */
  {YYNOCODE,0,0}, /* Unused */
/* State 25 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  26, &yyActionTable[ 178] }, /*    constant_expression shift  26 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 182] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 184] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 185] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 187] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 26 */
  {YYNOCODE,0,0}, /* Unused */
  {   1,  27, 0                    }, /*           TOK_EXPR_AND shift  27 */
  {   2,  33, 0                    }, /*        TOK_EXPR_BITAND shift  33 */
  {   3,  29, 0                    }, /*         TOK_EXPR_BITOR shift  29 */
  {   4,  31, 0                    }, /*        TOK_EXPR_BITXOR shift  31 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {   9,  35, 0                    }, /*            TOK_EXPR_EQ shift  35 */
  {YYNOCODE,0,0}, /* Unused */
  {  11,  45, 0                    }, /*           TOK_EXPR_GEQ shift  45 */
  {  12,  41, 0                    }, /*       TOK_EXPR_GREATER shift  41 */
  {YYNOCODE,0,0}, /* Unused */
  {  14,  43, 0                    }, /*           TOK_EXPR_LEQ shift  43 */
  {  15,  39, 0                    }, /*          TOK_EXPR_LESS shift  39 */
  {YYNOCODE,0,0}, /* Unused */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {YYNOCODE,0,0}, /* Unused */
  {  20,  37, 0                    }, /*         TOK_EXPR_NOTEQ shift  37 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  57, 0                    }, /*        TOK_EXPR_SHIFTL shift  57 */
  {  27,  59, 0                    }, /*        TOK_EXPR_SHIFTR shift  59 */
  {  28,  51, 0                    }, /*          TOK_EXPR_STAR shift  51 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 27 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  28, &yyActionTable[ 226] }, /*    constant_expression shift  28 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 230] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 232] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 233] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 235] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 28 */
  {   2,  33, 0                    }, /*        TOK_EXPR_BITAND shift  33 */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  18,  55, &yyActionTable[ 240] }, /*           TOK_EXPR_MOD shift  55 */
  {   3,  29, 0                    }, /*         TOK_EXPR_BITOR shift  29 */
  {  20,  37, &yyActionTable[ 245] }, /*         TOK_EXPR_NOTEQ shift  37 */
  {   4,  31, 0                    }, /*        TOK_EXPR_BITXOR shift  31 */
  {  11,  45, 0                    }, /*           TOK_EXPR_GEQ shift  45 */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {   9,  35, 0                    }, /*            TOK_EXPR_EQ shift  35 */
  {  26,  57, 0                    }, /*        TOK_EXPR_SHIFTL shift  57 */
  {  27,  59, &yyActionTable[ 246] }, /*        TOK_EXPR_SHIFTR shift  59 */
  {  28,  51, &yyActionTable[ 253] }, /*          TOK_EXPR_STAR shift  51 */
  {  12,  41, 0                    }, /*       TOK_EXPR_GREATER shift  41 */
  {  14,  43, 0                    }, /*           TOK_EXPR_LEQ shift  43 */
  {  15,  39, 0                    }, /*          TOK_EXPR_LESS shift  39 */
/* State 29 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  30, &yyActionTable[ 258] }, /*    constant_expression shift  30 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 262] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 264] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 265] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 267] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 30 */
  {   2,  33, 0                    }, /*        TOK_EXPR_BITAND shift  33 */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  18,  55, &yyActionTable[ 272] }, /*           TOK_EXPR_MOD shift  55 */
  {   4,  31, 0                    }, /*        TOK_EXPR_BITXOR shift  31 */
  {  20,  37, &yyActionTable[ 275] }, /*         TOK_EXPR_NOTEQ shift  37 */
  {  11,  45, 0                    }, /*           TOK_EXPR_GEQ shift  45 */
  {  12,  41, 0                    }, /*       TOK_EXPR_GREATER shift  41 */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {   9,  35, 0                    }, /*            TOK_EXPR_EQ shift  35 */
  {  26,  57, 0                    }, /*        TOK_EXPR_SHIFTL shift  57 */
  {  27,  59, &yyActionTable[ 277] }, /*        TOK_EXPR_SHIFTR shift  59 */
  {  28,  51, &yyActionTable[ 278] }, /*          TOK_EXPR_STAR shift  51 */
  {YYNOCODE,0,0}, /* Unused */
  {  14,  43, 0                    }, /*           TOK_EXPR_LEQ shift  43 */
  {  15,  39, 0                    }, /*          TOK_EXPR_LESS shift  39 */
/* State 31 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  32, &yyActionTable[ 290] }, /*    constant_expression shift  32 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 294] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 296] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 297] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 299] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 32 */
  {   2,  33, 0                    }, /*        TOK_EXPR_BITAND shift  33 */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  18,  55, &yyActionTable[ 304] }, /*           TOK_EXPR_MOD shift  55 */
  {  11,  45, 0                    }, /*           TOK_EXPR_GEQ shift  45 */
  {  20,  37, 0                    }, /*         TOK_EXPR_NOTEQ shift  37 */
  {  12,  41, 0                    }, /*       TOK_EXPR_GREATER shift  41 */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {   9,  35, 0                    }, /*            TOK_EXPR_EQ shift  35 */
  {  26,  57, 0                    }, /*        TOK_EXPR_SHIFTL shift  57 */
  {  27,  59, &yyActionTable[ 307] }, /*        TOK_EXPR_SHIFTR shift  59 */
  {  28,  51, &yyActionTable[ 309] }, /*          TOK_EXPR_STAR shift  51 */
  {YYNOCODE,0,0}, /* Unused */
  {  14,  43, 0                    }, /*           TOK_EXPR_LEQ shift  43 */
  {  15,  39, 0                    }, /*          TOK_EXPR_LESS shift  39 */
/* State 33 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  34, &yyActionTable[ 322] }, /*    constant_expression shift  34 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 326] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 328] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 329] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 331] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 34 */
  {  11,  45, 0                    }, /*           TOK_EXPR_GEQ shift  45 */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {  12,  41, 0                    }, /*       TOK_EXPR_GREATER shift  41 */
  {  20,  37, 0                    }, /*         TOK_EXPR_NOTEQ shift  37 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {   9,  35, 0                    }, /*            TOK_EXPR_EQ shift  35 */
  {  26,  57, 0                    }, /*        TOK_EXPR_SHIFTL shift  57 */
  {  27,  59, &yyActionTable[ 336] }, /*        TOK_EXPR_SHIFTR shift  59 */
  {  28,  51, &yyActionTable[ 339] }, /*          TOK_EXPR_STAR shift  51 */
  {YYNOCODE,0,0}, /* Unused */
  {  14,  43, 0                    }, /*           TOK_EXPR_LEQ shift  43 */
  {  15,  39, 0                    }, /*          TOK_EXPR_LESS shift  39 */
/* State 35 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  36, &yyActionTable[ 354] }, /*    constant_expression shift  36 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 358] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 360] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 361] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 363] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 36 */
  {  11,  45, 0                    }, /*           TOK_EXPR_GEQ shift  45 */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {  12,  41, 0                    }, /*       TOK_EXPR_GREATER shift  41 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  57, 0                    }, /*        TOK_EXPR_SHIFTL shift  57 */
  {  27,  59, &yyActionTable[ 368] }, /*        TOK_EXPR_SHIFTR shift  59 */
  {  28,  51, &yyActionTable[ 371] }, /*          TOK_EXPR_STAR shift  51 */
  {YYNOCODE,0,0}, /* Unused */
  {  14,  43, 0                    }, /*           TOK_EXPR_LEQ shift  43 */
  {  15,  39, 0                    }, /*          TOK_EXPR_LESS shift  39 */
/* State 37 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  38, &yyActionTable[ 386] }, /*    constant_expression shift  38 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 390] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 392] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 393] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 395] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 38 */
  {  11,  45, 0                    }, /*           TOK_EXPR_GEQ shift  45 */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {  12,  41, 0                    }, /*       TOK_EXPR_GREATER shift  41 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  57, 0                    }, /*        TOK_EXPR_SHIFTL shift  57 */
  {  27,  59, &yyActionTable[ 400] }, /*        TOK_EXPR_SHIFTR shift  59 */
  {  28,  51, &yyActionTable[ 403] }, /*          TOK_EXPR_STAR shift  51 */
  {YYNOCODE,0,0}, /* Unused */
  {  14,  43, 0                    }, /*           TOK_EXPR_LEQ shift  43 */
  {  15,  39, 0                    }, /*          TOK_EXPR_LESS shift  39 */
/* State 39 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  40, &yyActionTable[ 418] }, /*    constant_expression shift  40 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 422] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 424] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 425] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 427] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 40 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  26,  57, &yyActionTable[ 437] }, /*        TOK_EXPR_SHIFTL shift  57 */
  {  27,  59, 0                    }, /*        TOK_EXPR_SHIFTR shift  59 */
  {  28,  51, 0                    }, /*          TOK_EXPR_STAR shift  51 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
/* State 41 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  42, &yyActionTable[ 442] }, /*    constant_expression shift  42 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 446] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 448] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 449] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 451] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 42 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  26,  57, &yyActionTable[ 461] }, /*        TOK_EXPR_SHIFTL shift  57 */
  {  27,  59, 0                    }, /*        TOK_EXPR_SHIFTR shift  59 */
  {  28,  51, 0                    }, /*          TOK_EXPR_STAR shift  51 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
/* State 43 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  44, &yyActionTable[ 466] }, /*    constant_expression shift  44 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 470] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 472] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 473] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 475] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 44 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  26,  57, &yyActionTable[ 485] }, /*        TOK_EXPR_SHIFTL shift  57 */
  {  27,  59, 0                    }, /*        TOK_EXPR_SHIFTR shift  59 */
  {  28,  51, 0                    }, /*          TOK_EXPR_STAR shift  51 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
/* State 45 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  46, &yyActionTable[ 490] }, /*    constant_expression shift  46 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 494] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 496] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 497] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 499] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 46 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  26,  57, &yyActionTable[ 509] }, /*        TOK_EXPR_SHIFTL shift  57 */
  {  27,  59, 0                    }, /*        TOK_EXPR_SHIFTR shift  59 */
  {  28,  51, 0                    }, /*          TOK_EXPR_STAR shift  51 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
/* State 47 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  48, &yyActionTable[ 514] }, /*    constant_expression shift  48 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 518] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 520] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 521] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 523] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 48 */
  {  28,  51, &yyActionTable[ 529] }, /*          TOK_EXPR_STAR shift  51 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {YYNOCODE,0,0}, /* Unused */
/* State 49 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  50, &yyActionTable[ 534] }, /*    constant_expression shift  50 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 538] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 540] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 541] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 543] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 50 */
  {  28,  51, &yyActionTable[ 549] }, /*          TOK_EXPR_STAR shift  51 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {YYNOCODE,0,0}, /* Unused */
/* State 51 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  52, &yyActionTable[ 554] }, /*    constant_expression shift  52 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 558] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 560] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 561] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 563] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 52 */
  {YYNOCODE,0,0}, /* Unused */
/* State 53 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  54, &yyActionTable[ 571] }, /*    constant_expression shift  54 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 575] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 577] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 578] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 580] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 54 */
  {YYNOCODE,0,0}, /* Unused */
/* State 55 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  56, &yyActionTable[ 588] }, /*    constant_expression shift  56 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 592] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 594] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 595] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 597] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 56 */
  {YYNOCODE,0,0}, /* Unused */
/* State 57 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  58, &yyActionTable[ 605] }, /*    constant_expression shift  58 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 609] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 611] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 612] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 614] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 58 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {YYNOCODE,0,0}, /* Unused */
  {  28,  51, 0                    }, /*          TOK_EXPR_STAR shift  51 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
/* State 59 */
  {  16,  22, 0                    }, /*        TOK_EXPR_LPAREN shift  22 */
  {  33,  60, &yyActionTable[ 629] }, /*    constant_expression shift  60 */
  {  17,  11, 0                    }, /*         TOK_EXPR_MINUS shift  11 */
  {  19,  15, 0                    }, /*           TOK_EXPR_NOT shift  15 */
  {  36,   8, 0                    }, /*     primary_expression shift  8 */
  {  37,   7, &yyActionTable[ 633] }, /*       unary_expression shift  7 */
  {  21,  17, &yyActionTable[ 635] }, /*           TOK_EXPR_OCT shift  17 */
  {  23,   9, &yyActionTable[ 636] }, /*          TOK_EXPR_PLUS shift  9 */
  {   5,  20, 0                    }, /*          TOK_EXPR_CHAR shift  20 */
  {   7,  18, 0                    }, /*           TOK_EXPR_DEC shift  18 */
  {  10,  21, 0                    }, /*         TOK_EXPR_FLOAT shift  21 */
  {  13,  19, 0                    }, /*           TOK_EXPR_HEX shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  13, &yyActionTable[ 638] }, /*         TOK_EXPR_TILDE shift  13 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 60 */
  {   8,  53, 0                    }, /*           TOK_EXPR_DIV shift  53 */
  {  17,  49, 0                    }, /*         TOK_EXPR_MINUS shift  49 */
  {  18,  55, 0                    }, /*           TOK_EXPR_MOD shift  55 */
  {YYNOCODE,0,0}, /* Unused */
  {  28,  51, 0                    }, /*          TOK_EXPR_STAR shift  51 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  47, 0                    }, /*          TOK_EXPR_PLUS shift  47 */
};

/* The state table contains information needed to look up the correct
** action in the action table, given the current state of the parser.
** Information needed includes:
**
**  +  A pointer to the start of the action hash table in yyActionTable.
**
**  +  A mask used to hash the look-ahead token.  The mask is an integer
**     which is one less than the size of the hash table.  
**
**  +  The default action.  This is the action to take if no entry for
**     the given look-ahead is found in the action hash table.
*/
struct yyStateEntry {
  struct yyActionEntry *hashtbl; /* Start of the hash table in yyActionTable */
  int mask;                      /* Mask used for hashing the look-ahead */
  YYACTIONTYPE actionDefault;    /* Default action if look-ahead not found */
};
static struct yyStateEntry yyStateTable[] = {
  { &yyActionTable[0], 15, 94},
  { &yyActionTable[16], 0, 94},
  { &yyActionTable[17], 31, 62},
  { &yyActionTable[49], 15, 94},
  { &yyActionTable[65], 0, 94},
  { &yyActionTable[66], 15, 94},
  { &yyActionTable[82], 0, 63},
  { &yyActionTable[83], 0, 82},
  { &yyActionTable[84], 0, 83},
  { &yyActionTable[85], 15, 94},
  { &yyActionTable[101], 0, 84},
  { &yyActionTable[102], 15, 94},
  { &yyActionTable[118], 0, 85},
  { &yyActionTable[119], 15, 94},
  { &yyActionTable[135], 0, 86},
  { &yyActionTable[136], 15, 94},
  { &yyActionTable[152], 0, 87},
  { &yyActionTable[153], 0, 88},
  { &yyActionTable[154], 0, 89},
  { &yyActionTable[155], 0, 90},
  { &yyActionTable[156], 0, 91},
  { &yyActionTable[157], 0, 92},
  { &yyActionTable[158], 15, 94},
  { &yyActionTable[174], 0, 94},
  { &yyActionTable[175], 0, 93},
  { &yyActionTable[176], 15, 94},
  { &yyActionTable[192], 31, 64},
  { &yyActionTable[224], 15, 94},
  { &yyActionTable[240], 15, 65},
  { &yyActionTable[256], 15, 94},
  { &yyActionTable[272], 15, 66},
  { &yyActionTable[288], 15, 94},
  { &yyActionTable[304], 15, 67},
  { &yyActionTable[320], 15, 94},
  { &yyActionTable[336], 15, 68},
  { &yyActionTable[352], 15, 94},
  { &yyActionTable[368], 15, 69},
  { &yyActionTable[384], 15, 94},
  { &yyActionTable[400], 15, 70},
  { &yyActionTable[416], 15, 94},
  { &yyActionTable[432], 7, 71},
  { &yyActionTable[440], 15, 94},
  { &yyActionTable[456], 7, 72},
  { &yyActionTable[464], 15, 94},
  { &yyActionTable[480], 7, 73},
  { &yyActionTable[488], 15, 94},
  { &yyActionTable[504], 7, 74},
  { &yyActionTable[512], 15, 94},
  { &yyActionTable[528], 3, 75},
  { &yyActionTable[532], 15, 94},
  { &yyActionTable[548], 3, 76},
  { &yyActionTable[552], 15, 94},
  { &yyActionTable[568], 0, 77},
  { &yyActionTable[569], 15, 94},
  { &yyActionTable[585], 0, 78},
  { &yyActionTable[586], 15, 94},
  { &yyActionTable[602], 0, 79},
  { &yyActionTable[603], 15, 94},
  { &yyActionTable[619], 7, 80},
  { &yyActionTable[627], 15, 94},
  { &yyActionTable[643], 7, 81},
};

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int idx;                            /* Index of top element in stack */
  int errcnt;                         /* Shifts left before out of the error */
  struct yyStackEntry *top;           /* Pointer to the top stack element */
  struct yyStackEntry stack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;

/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void PreExprParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}

/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static char *yyTokenName[] = { 
  "$",             "TOK_EXPR_AND",  "TOK_EXPR_BITAND",  "TOK_EXPR_BITOR",
  "TOK_EXPR_BITXOR",  "TOK_EXPR_CHAR",  "TOK_EXPR_COLON",  "TOK_EXPR_DEC",
  "TOK_EXPR_DIV",  "TOK_EXPR_EQ",   "TOK_EXPR_FLOAT",  "TOK_EXPR_GEQ",
  "TOK_EXPR_GREATER",  "TOK_EXPR_HEX",  "TOK_EXPR_LEQ",  "TOK_EXPR_LESS",
  "TOK_EXPR_LPAREN",  "TOK_EXPR_MINUS",  "TOK_EXPR_MOD",  "TOK_EXPR_NOT",
  "TOK_EXPR_NOTEQ",  "TOK_EXPR_OCT",  "TOK_EXPR_OR",   "TOK_EXPR_PLUS",
  "TOK_EXPR_QUESTION",  "TOK_EXPR_RPAREN",  "TOK_EXPR_SHIFTL",  "TOK_EXPR_SHIFTR",
  "TOK_EXPR_STAR",  "TOK_EXPR_TILDE",  "TOK_EXPR_WSPACE",  "TOK_PRE_UNARY",
  "conditional_expression",  "constant_expression",  "error",         "pre_expression",
  "primary_expression",  "unary_expression",
};
#define YYTRACE(X) if( yyTraceFILE ) fprintf(yyTraceFILE,"%sReduce [%s].\n",yyTracePrompt,X);
#else
#define YYTRACE(X)
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to PreExprParser and PreExprParserFree.
*/
void *PreExprParserAlloc(void *(*mallocProc)(...)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( sizeof(yyParser), __FILE__, __LINE__ );
  if( pParser ){
    pParser->idx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;

  if( pParser->idx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->idx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[pParser->top->major]);
  }
#endif
  yymajor = pParser->top->major;
  yy_destructor( yymajor, &pParser->top->minor);
  pParser->idx--;
  pParser->top--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from PreExprParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void PreExprParserFree(
  void *p,               /* The parser to be deleted */
  void (*freeProc)(...)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->idx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)(pParser, __FILE__, __LINE__);
}

/*
** Find the appropriate action for a parser given the look-ahead token.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_parser_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead             /* The look-ahead token */
){
  struct yyStateEntry *pState;   /* Appropriate entry in the state table */
  struct yyActionEntry *pAction; /* Action appropriate for the look-ahead */
 
  /* if( pParser->idx<0 ) return YY_NO_ACTION;  */
  pState = &yyStateTable[pParser->top->stateno];
  if( iLookAhead!=YYNOCODE ){
    pAction = &pState->hashtbl[iLookAhead & pState->mask];
    while( pAction ){
      if( pAction->lookahead==iLookAhead ) return pAction->action;
      pAction = pAction->next;
    }
  }else if( pState->mask!=0 || pState->hashtbl->lookahead!=YYNOCODE ){
    return YY_NO_ACTION;
  }
  return pState->actionDefault;
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yypParser->idx++;
  yypParser->top++;
  if( yypParser->idx>=YYSTACKDEPTH ){
     yypParser->idx--;
     yypParser->top--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
#line 210 "cpp/PreExprParser.lem"

    *err << location << sev_fatal
         << "giving up, preprocessor expression parser stack overflow (>1000)"
         << endMessage;
    parse_error = true;

#line 1291 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
     return;
  }
  yypParser->top->stateno = yyNewState;
  yypParser->top->major = yyMajor;
  yypParser->top->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->idx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->idx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->stack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 35, 1 },
  { 32, 1 },
  { 32, 5 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 3 },
  { 33, 1 },
  { 37, 1 },
  { 37, 2 },
  { 37, 2 },
  { 37, 2 },
  { 37, 2 },
  { 36, 1 },
  { 36, 1 },
  { 36, 1 },
  { 36, 1 },
  { 36, 1 },
  { 36, 3 },
};

static void yy_accept(
  yyParser *yypParser           /* The parser */
  PreExprParserANSIARGDECL              /* Extra arguments (if any) */
);  /* Forward declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
  PreExprParserANSIARGDECL
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  struct yyStackEntry *yymsp;     /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  yymsp = yypParser->top;
  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **     YYTRACE("<text of the rule>");
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        YYTRACE("pre_expression ::= conditional_expression")
#line 233 "cpp/PreExprParser.lem"
{
        if (yymsp[0].minor.yy25->val > 0)
          result = 1;
        else
          result = 0;
        delete yymsp[0].minor.yy25;
    }
#line 1391 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 1:
        YYTRACE("conditional_expression ::= constant_expression")
#line 246 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = yymsp[0].minor.yy25;
    }
#line 1399 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 2:
        YYTRACE("conditional_expression ::= constant_expression TOK_EXPR_QUESTION conditional_expression TOK_EXPR_COLON conditional_expression")
#line 252 "cpp/PreExprParser.lem"
{
        if (yymsp[-4].minor.yy25->val > 0) {
          yygotominor.yy25 = yymsp[-2].minor.yy25;
          delete yymsp[0].minor.yy25;
        } else {
          yygotominor.yy25 = yymsp[0].minor.yy25;
          delete yymsp[-2].minor.yy25;
        }
        delete yymsp[-4].minor.yy25;
        delete[] yymsp[-3].minor.yy0;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1416 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 3:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_OR constant_expression")
#line 270 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr ();
        if (yymsp[-2].minor.yy25->val > 0 || yymsp[0].minor.yy25->val > 0)
          yygotominor.yy25->val = 1;
        else
          yygotominor.yy25->val = 0;
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1431 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 4:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_AND constant_expression")
#line 281 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr ();
        if (yymsp[-2].minor.yy25->val > 0 && yymsp[0].minor.yy25->val > 0)
          yygotominor.yy25->val = 1;
        else
          yygotominor.yy25->val = 0;
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1446 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 5:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_BITOR constant_expression")
#line 292 "cpp/PreExprParser.lem"
{
        if (yymsp[-2].minor.yy25->val < 0 && yymsp[0].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toSignedInt() | yymsp[0].minor.yy25->toSignedInt()));
        else if (yymsp[-2].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toSignedInt() | yymsp[0].minor.yy25->toUnsignedInt()));
        else if (yymsp[0].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toUnsignedInt() | yymsp[0].minor.yy25->toSignedInt()));
        else
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toUnsignedInt() | yymsp[0].minor.yy25->toUnsignedInt()));
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1464 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 6:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_BITXOR constant_expression")
#line 306 "cpp/PreExprParser.lem"
{
        if (yymsp[-2].minor.yy25->val < 0 && yymsp[0].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toSignedInt() ^ yymsp[0].minor.yy25->toSignedInt()));
        else if (yymsp[-2].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toSignedInt() ^ yymsp[0].minor.yy25->toUnsignedInt()));
        else if (yymsp[0].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toUnsignedInt() ^ yymsp[0].minor.yy25->toSignedInt()));
        else
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toUnsignedInt() ^ yymsp[0].minor.yy25->toUnsignedInt()));
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1482 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 7:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_BITAND constant_expression")
#line 320 "cpp/PreExprParser.lem"
{
        if (yymsp[-2].minor.yy25->val < 0 && yymsp[0].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toSignedInt() & yymsp[0].minor.yy25->toSignedInt()));
        else if (yymsp[-2].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toSignedInt() & yymsp[0].minor.yy25->toUnsignedInt()));
        else if (yymsp[0].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toUnsignedInt() & yymsp[0].minor.yy25->toSignedInt()));
        else
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toUnsignedInt() & yymsp[0].minor.yy25->toUnsignedInt()));
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1500 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 8:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_EQ constant_expression")
#line 334 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr ();
        if (yymsp[-2].minor.yy25->val == yymsp[0].minor.yy25->val)
          yygotominor.yy25->val = 1;
        else
          yygotominor.yy25->val = 0;
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1515 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 9:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_NOTEQ constant_expression")
#line 345 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr ();
        if (yymsp[-2].minor.yy25->val != yymsp[0].minor.yy25->val)
          yygotominor.yy25->val = 1;
        else
          yygotominor.yy25->val = 0;
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1530 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 10:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_LESS constant_expression")
#line 356 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr ();
        if (yymsp[-2].minor.yy25->val < yymsp[0].minor.yy25->val)
          yygotominor.yy25->val = 1;
        else
          yygotominor.yy25->val = 0;
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1545 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 11:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_GREATER constant_expression")
#line 367 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr ();
        if (yymsp[-2].minor.yy25->val > yymsp[0].minor.yy25->val)
          yygotominor.yy25->val = 1;
        else
          yygotominor.yy25->val = 0;
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1560 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 12:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_LEQ constant_expression")
#line 378 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr ();
        if (yymsp[-2].minor.yy25->val <= yymsp[0].minor.yy25->val)
          yygotominor.yy25->val = 1;
        else
          yygotominor.yy25->val = 0;
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1575 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 13:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_GEQ constant_expression")
#line 389 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr ();
        if (yymsp[-2].minor.yy25->val >= yymsp[0].minor.yy25->val)
          yygotominor.yy25->val = 1;
        else
          yygotominor.yy25->val = 0;
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1590 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 14:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_PLUS constant_expression")
#line 400 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->val + yymsp[0].minor.yy25->val));
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1601 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 15:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_MINUS constant_expression")
#line 407 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->val - yymsp[0].minor.yy25->val));
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1612 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 16:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_STAR constant_expression")
#line 414 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->val * yymsp[0].minor.yy25->val));
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1623 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 17:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_DIV constant_expression")
#line 421 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr (floorl(yymsp[-2].minor.yy25->val / yymsp[0].minor.yy25->val));
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1634 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 18:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_MOD constant_expression")
#line 428 "cpp/PreExprParser.lem"
{
        if (yymsp[-2].minor.yy25->val < 0 && yymsp[0].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toSignedInt() % yymsp[0].minor.yy25->toSignedInt()));
        else if (yymsp[-2].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toSignedInt() % yymsp[0].minor.yy25->toUnsignedInt()));
        else if (yymsp[0].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toUnsignedInt() % yymsp[0].minor.yy25->toSignedInt()));
        else
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toUnsignedInt() % yymsp[0].minor.yy25->toUnsignedInt()));
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1652 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 19:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_SHIFTL constant_expression")
#line 442 "cpp/PreExprParser.lem"
{
        if (yymsp[-2].minor.yy25->val < 0 && yymsp[0].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toSignedInt() << yymsp[0].minor.yy25->toSignedInt()));
        else if (yymsp[-2].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toSignedInt() << yymsp[0].minor.yy25->toUnsignedInt()));
        else if (yymsp[0].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toUnsignedInt() << yymsp[0].minor.yy25->toSignedInt()));
        else
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toUnsignedInt() << yymsp[0].minor.yy25->toUnsignedInt()));
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1670 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 20:
        YYTRACE("constant_expression ::= constant_expression TOK_EXPR_SHIFTR constant_expression")
#line 456 "cpp/PreExprParser.lem"
{
        if (yymsp[-2].minor.yy25->val < 0 && yymsp[0].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toSignedInt() >> yymsp[0].minor.yy25->toSignedInt()));
        else if (yymsp[-2].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toSignedInt() >> yymsp[0].minor.yy25->toUnsignedInt()));
        else if (yymsp[0].minor.yy25->val < 0)
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toUnsignedInt() >> yymsp[0].minor.yy25->toSignedInt()));
        else
          yygotominor.yy25 = new PreExpr (overflow(yymsp[-2].minor.yy25->toUnsignedInt() >> yymsp[0].minor.yy25->toUnsignedInt()));
        delete yymsp[-2].minor.yy25;
        delete yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1688 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 21:
        YYTRACE("constant_expression ::= unary_expression")
#line 470 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = yymsp[0].minor.yy25;
    }
#line 1696 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 22:
        YYTRACE("unary_expression ::= primary_expression")
#line 479 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = yymsp[0].minor.yy25;
    }
#line 1704 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 23:
        YYTRACE("unary_expression ::= TOK_EXPR_PLUS unary_expression")
#line 483 "cpp/PreExprParser.lem"
{
        yymsp[0].minor.yy25->val = overflow(+yymsp[0].minor.yy25->val); yygotominor.yy25 = yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1713 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 24:
        YYTRACE("unary_expression ::= TOK_EXPR_MINUS unary_expression")
#line 488 "cpp/PreExprParser.lem"
{
        yymsp[0].minor.yy25->val = overflow(-yymsp[0].minor.yy25->val); yygotominor.yy25 = yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1722 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 25:
        YYTRACE("unary_expression ::= TOK_EXPR_TILDE unary_expression")
#line 493 "cpp/PreExprParser.lem"
{
        if (yymsp[0].minor.yy25->val < 0)
          yymsp[0].minor.yy25->val = ~yymsp[0].minor.yy25->toSignedInt();
        else
          yymsp[0].minor.yy25->val = ~yymsp[0].minor.yy25->toUnsignedInt();
        yygotominor.yy25 = yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1735 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 26:
        YYTRACE("unary_expression ::= TOK_EXPR_NOT unary_expression")
#line 502 "cpp/PreExprParser.lem"
{
        yymsp[0].minor.yy25->val = !yymsp[0].minor.yy25->val; yygotominor.yy25 = yymsp[0].minor.yy25;
        delete[] yymsp[-1].minor.yy0;
    }
#line 1744 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 27:
        YYTRACE("primary_expression ::= TOK_EXPR_OCT")
#line 512 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr (strtoull (yymsp[0].minor.yy0, NULL, 8));
        delete[] yymsp[0].minor.yy0;
    }
#line 1753 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 28:
        YYTRACE("primary_expression ::= TOK_EXPR_DEC")
#line 517 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr (strtoull (yymsp[0].minor.yy0, NULL, 10));
        delete[] yymsp[0].minor.yy0;
    }
#line 1762 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 29:
        YYTRACE("primary_expression ::= TOK_EXPR_HEX")
#line 522 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr (strtoull (yymsp[0].minor.yy0, NULL, 16));
        delete[] yymsp[0].minor.yy0;
    }
#line 1771 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 30:
        YYTRACE("primary_expression ::= TOK_EXPR_CHAR")
#line 527 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = new PreExpr (overflow(PreExpr::convertChar (yymsp[0].minor.yy0)));
        delete[] yymsp[0].minor.yy0;
    }
#line 1780 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 31:
        YYTRACE("primary_expression ::= TOK_EXPR_FLOAT")
#line 532 "cpp/PreExprParser.lem"
{
        *err << location << sev_warning
             << "floating constant in preprocessor expression, truncate to integer"
             << endMessage;
        yygotominor.yy25 = new PreExpr (overflow(floorl(strtold (yymsp[0].minor.yy0, NULL))));
        delete[] yymsp[0].minor.yy0;
    }
#line 1792 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
      case 32:
        YYTRACE("primary_expression ::= TOK_EXPR_LPAREN conditional_expression TOK_EXPR_RPAREN")
#line 540 "cpp/PreExprParser.lem"
{
        yygotominor.yy25 = yymsp[-1].minor.yy25;
        delete[] yymsp[-2].minor.yy0;
        delete[] yymsp[0].minor.yy0;
    }
#line 1802 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->idx -= yysize;
  yypParser->top -= yysize;
  yyact = yy_find_parser_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser PreExprParserARGDECL);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
  PreExprParserANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
  PreExprParserANSIARGDECL               /* Extra arguments (if any) */
){
#define TOKEN (yyminor.yy0)
#line 217 "cpp/PreExprParser.lem"

    *err << location << sev_error;
    if (at_eos)
      *err << "unexpected end of conditional";
    else
      *err << "unexpected token `" << current_token << "' in conditional";
    *err << endMessage;
    parse_error = true;

#line 1854 "/home/akut/Akut/package/aspectc++/Puma/gen-release/step1/src/PreExprParser.cc"
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
  PreExprParserANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "PreExprParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void PreExprParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  PreExprParserTOKENTYPE yyminor       /* The value for the token */
  PreExprParserANSIARGDECL
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->idx<0 ){
    /* Olaf: Empty files must be parse too!  if( yymajor==0 ) return; */
    yypParser->idx = 0;
    yypParser->errcnt = -1;
    yypParser->top = &yypParser->stack[0];
    yypParser->top->stateno = 0;
    yypParser->top->major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_parser_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->errcnt--;
      if( yyendofinput && yypParser->idx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE PreExprParserARGDECL);
    }else if( yyact == YY_ERROR_ACTION ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->errcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion PreExprParserARGDECL);
      }
      if( yypParser->top->major==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->idx >= 0 &&
          yypParser->top->major != YYERRORSYMBOL &&
          (yyact = yy_find_parser_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->idx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser PreExprParserARGDECL);
          yymajor = YYNOCODE;
        }else if( yypParser->top->major!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->errcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->errcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion PreExprParserARGDECL);
      }
      yypParser->errcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser PreExprParserARGDECL);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser PreExprParserARGDECL);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->idx>=0 );
  return;
}
