/*
Copyright 2010, 2012, 2014 Jose Robson Mariano Alves

This file is part of bgfinancas.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*/

package Ajuda;

import Biblioteca.Botoes;
import Biblioteca.JanelaModal;
import Biblioteca.Visual;
import Principal.TelaPrincipal;

public final class Tutorial extends JanelaModal {

    private final TelaPrincipal Principal;
    private final Boolean PrimeiroCadastro;
    private int DicaAtual = 1;
    private final int QtdDicas = 10;
    
    public Tutorial(boolean modal, TelaPrincipal _Principal, Boolean _PrimeiroCadastro) {
        super(_Principal, modal);
        initComponents();
        Visual.JanelaModal(this.getJanela());
        Principal = _Principal;
        PrimeiroCadastro = _PrimeiroCadastro;
        BarraDeFerramentas.add(Botoes.Sair(this));
        VerificarBotoes();
        Dica();
    }
    
    @Override
    public void Botoes(String acao)
    {
        if(acao.equals(Lingua.getMensagem("sair"))){
            Tutorial.this.dispose();
        }
    }
    
    public void Dica(){
        switch(DicaAtual){
            case 1:
                dica_titulo.setText(Lingua.getMensagem("contas"));
                dica_conteudo.setText(Lingua.getMensagem("tutorial_contas"));
                break;
            case 2:
                dica_titulo.setText(Lingua.getMensagem("despesas"));
                dica_conteudo.setText(Lingua.getMensagem("tutorial_despesas"));
                break;
            case 3:
                dica_titulo.setText(Lingua.getMensagem("receitas"));
                dica_conteudo.setText(Lingua.getMensagem("tutorial_receitas"));
                break;
            case 4:
                dica_titulo.setText(Lingua.getMensagem("transferencias"));
                dica_conteudo.setText(Lingua.getMensagem("tutorial_transferencias"));
                break;
            case 5:
                dica_titulo.setText(Lingua.getMensagem("grupos"));
                dica_conteudo.setText(Lingua.getMensagem("tutorial_grupos"));
                break;
            case 6:
                dica_titulo.setText(Lingua.getMensagem("planejamento"));
                dica_conteudo.setText(Lingua.getMensagem("tutorial_planejamento"));
                break;
            case 7:
                dica_titulo.setText(Lingua.getMensagem("agenda"));
                dica_conteudo.setText(Lingua.getMensagem("tutorial_agenda"));
                break;
            case 8:
                dica_titulo.setText(Lingua.getMensagem("relatorios"));
                dica_conteudo.setText(Lingua.getMensagem("tutorial_relatorios"));
                break;
            case 9:
                dica_titulo.setText(Lingua.getMensagem("usuarios"));
                dica_conteudo.setText(Lingua.getMensagem("tutorial_usuarios"));
                break;
            case 10:
                dica_titulo.setText(Lingua.getMensagem("configuracao"));
                dica_conteudo.setText(Lingua.getMensagem("tutorial_configuracao"));
                break;
            default:
                break;
        }
    }
    
    public void Proximo(){
        DicaAtual++;
        passos.setText(DicaAtual+" / "+QtdDicas);
        VerificarBotoes();
    }
    
    public void Anterior(){
        DicaAtual--;
        passos.setText(DicaAtual+" / "+QtdDicas);
        VerificarBotoes();
    }
    
    public void VerificarBotoes(){
        if(DicaAtual<2){
            anterior.setEnabled(false);
        }else{
            anterior.setEnabled(true);
        }
        if(DicaAtual>=QtdDicas){
            proximo.setEnabled(false);
        }else{
            proximo.setEnabled(true);
        }
        Dica();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        BarraDeFerramentas = new javax.swing.JToolBar();
        PainelUsuarios = new javax.swing.JPanel();
        anterior = new javax.swing.JButton();
        passos = new javax.swing.JLabel();
        proximo = new javax.swing.JButton();
        dica_titulo = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        dica_conteudo = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(Lingua.getMensagem("tutorial_rapido")
        );
        setFont(FonteFinancas);
        setForeground(java.awt.Color.cyan);
        setResizable(false);
        getContentPane().setLayout(null);

        BarraDeFerramentas.setFloatable(false);
        BarraDeFerramentas.setRollover(true);
        getContentPane().add(BarraDeFerramentas);
        BarraDeFerramentas.setBounds(0, 0, 580, 45);

        PainelUsuarios.setBorder(javax.swing.BorderFactory.createTitledBorder(null, Lingua.getMensagem("primeiros_passos"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, FonteFinancas, new java.awt.Color(0, 102, 204)));
        PainelUsuarios.setForeground(new java.awt.Color(51, 94, 168));
        PainelUsuarios.setLayout(null);

        anterior.setFont(FonteFinancas);
        anterior.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Imagens/outros/seta_esquerda.png"))); // NOI18N
        anterior.setText(Lingua.getMensagem("anterior"));
        anterior.setFocusPainted(false);
        anterior.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        anterior.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                anteriorActionPerformed(evt);
            }
        });
        PainelUsuarios.add(anterior);
        anterior.setBounds(50, 170, 120, 20);

        passos.setFont(FonteFinancasNegrito);
        passos.setForeground(new java.awt.Color(51, 94, 168));
        passos.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        passos.setText("1 / 10");
        PainelUsuarios.add(passos);
        passos.setBounds(170, 170, 80, 20);

        proximo.setFont(FonteFinancas);
        proximo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/Imagens/outros/seta_direita.png"))); // NOI18N
        proximo.setText(Lingua.getMensagem("proximo"));
        proximo.setFocusPainted(false);
        proximo.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        proximo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                proximoActionPerformed(evt);
            }
        });
        PainelUsuarios.add(proximo);
        proximo.setBounds(250, 170, 120, 20);

        dica_titulo.setFont(FonteFinancasNegrito);
        dica_titulo.setForeground(new java.awt.Color(51, 94, 168));
        dica_titulo.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        dica_titulo.setText("...");
        PainelUsuarios.add(dica_titulo);
        dica_titulo.setBounds(10, 20, 400, 20);

        jScrollPane1.setBorder(null);

        dica_conteudo.setEditable(false);
        dica_conteudo.setColumns(20);
        dica_conteudo.setFont(FonteFinancas);
        dica_conteudo.setForeground(new java.awt.Color(70, 70, 70));
        dica_conteudo.setLineWrap(true);
        dica_conteudo.setRows(5);
        dica_conteudo.setWrapStyleWord(true);
        dica_conteudo.setBorder(null);
        dica_conteudo.setFocusable(false);
        dica_conteudo.setOpaque(false);
        dica_conteudo.setRequestFocusEnabled(false);
        dica_conteudo.setVerifyInputWhenFocusTarget(false);
        jScrollPane1.setViewportView(dica_conteudo);

        PainelUsuarios.add(jScrollPane1);
        jScrollPane1.setBounds(20, 50, 390, 110);

        getContentPane().add(PainelUsuarios);
        PainelUsuarios.setBounds(20, 60, 430, 210);

        setSize(new java.awt.Dimension(471, 313));
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

private void anteriorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_anteriorActionPerformed
    Anterior();
}//GEN-LAST:event_anteriorActionPerformed

    private void proximoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_proximoActionPerformed
        Proximo();
    }//GEN-LAST:event_proximoActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JToolBar BarraDeFerramentas;
    private javax.swing.JPanel PainelUsuarios;
    private javax.swing.JButton anterior;
    private javax.swing.JTextArea dica_conteudo;
    private javax.swing.JLabel dica_titulo;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel passos;
    private javax.swing.JButton proximo;
    // End of variables declaration//GEN-END:variables

}
