//  ************************************************************************************************
//
//  qt-mvvm: Model-view-view-model framework for large GUI applications
//
//! @file      mvvm/model/mvvm/standarditems/data2ditem.h
//! @brief     Defines class CLASS?
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2020
//! @authors   Gennady Pospelov et al, Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_MVVM_MODEL_MVVM_STANDARDITEMS_DATA2DITEM_H
#define BORNAGAIN_MVVM_MODEL_MVVM_STANDARDITEMS_DATA2DITEM_H

#include "mvvm/model/compounditem.h"
#include <vector>

namespace ModelView {

class BinnedAxisItem;

//! Represents two-dimensional data (axes definition and 2d array of values).
//! Values are stored in Data2DItem itself, axes are attached as children. Corresponding plot
//! properties will be served by ColorMapItem.

class MVVM_MODEL_EXPORT Data2DItem : public CompoundItem {
public:
    static inline const std::string T_XAXIS = "T_XAXIS";
    static inline const std::string T_YAXIS = "T_YAXIS";

    Data2DItem();

    void setAxes(std::unique_ptr<BinnedAxisItem> x_axis, std::unique_ptr<BinnedAxisItem> y_axis);

    BinnedAxisItem* xAxis() const;

    BinnedAxisItem* yAxis() const;

    void setContent(const std::vector<double>& data);

    std::vector<double> content() const;

private:
    void insert_axis(std::unique_ptr<BinnedAxisItem> axis, const std::string& tag);
};

} // namespace ModelView

#endif // BORNAGAIN_MVVM_MODEL_MVVM_STANDARDITEMS_DATA2DITEM_H
