#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Copyright (c) 2009 Sascha Steinbiss <steinbiss@zbh.uni-hamburg.de>
# Copyright (c) 2009 Center for Bioinformatics, University of Hamburg
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#

from gt.dlload import gtlib


class NodeVisitor(object):

    def __init__(self):
        raise NotImplementedError, \
            'Please call the constructor of a NodeVisitor implementation.'

    def __del__(self):
        gtlib.gt_node_visitor_delete(self.gv)

    def from_param(cls, obj):
        if not isinstance(obj, NodeVisitor):
            raise TypeError, "argument must be a NodeVisitor"
        return obj._as_parameter_

    from_param = classmethod(from_param)
    
    def register(cls, gtlib):
        from ctypes import c_void_p
        gtlib.gt_node_visitor_delete.restype = None
        gtlib.gt_node_visitor_delete.argtypes = [c_void_p]
    
    register = classmethod(register)
