/*---------------------------------------------------------------------------*\
	cputime.h
	Hi-res time checking for VoiceTronix drivers
	Split from hda.c for reuse points.
	Date: 	14 June 2006
	
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 2001, 2006 Voicetronix www.voicetronix.com.au

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#include <asm/msr.h>

typedef struct {
	u32 lo;
	u32 hi;
} timestamp_t;

void timestamp(timestamp_t *pstamp)
{
	rdtsc(pstamp->lo, pstamp->hi);
}

/* acc = sub - acc */
void timestamp_sub(timestamp_t *sub, timestamp_t *acc)
{
	unsigned long lo = acc->lo - sub->lo;
	unsigned long hi = acc->hi - sub->hi;
	if (lo < 0) {
		lo += 0x10000000L;
		hi--;
	}
	acc->hi = hi;
	acc->lo = lo;
}

// Alternatively, you can use rdtscll() to return the full count as a long long
// or rdtscl() to read just the low order half of the count as a simple long

