/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MAINDIALOG_H
#define MAINDIALOG_H

class Playlist;
#ifdef XSID_HAVE_TSID
class TSID;
#endif
#ifdef XSID_HAVE_TSID2
class TSID2;
#endif

#include <qapplication.h>
#include <qbitmap.h>
#include <qdict.h>
#include <qfiledialog.h>
#include <qkeycode.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qtooltip.h>

#ifdef XSID_HAVE_LIRC
#include <lirc/lirc_client.h>
#endif

class AudioDialog;
class EmuDialog;
class FilterDialog;
class HistoryDialog;
class HVSC_Dialog;
class MixerDialog;
class PlaylistDialog;
class PlaylistEditDialog;
class StilDialog;
class TSID2Dialog;
class SidIdDialog;

class ConfigFile;
class AudioConfig;
struct emuConfig;
class HVSC_Config;
class MixerConfig;
class Player;
class PlaylistItem;
class SidTuneWrapper;
class TSID2Config;
class SidId;

#include "MainDialogData.h"
#include "stilview/stil.h"

class MainDialog : public MainDialogData
{
    Q_OBJECT

public:

    MainDialog(QWidget* parent = 0, const char* name = 0);
    ~MainDialog();

    void playerButtonsOff();
    void playerButtonsForceStart();
    void setPrevBtnState();
    void setNextBtnState();
    
    void showSidTuneInfo();
    void clearSidTuneInfo();
    
    void showStilInfo();
    bool initStilViewClass();
    // For config saver and internal use as wrapper.
    bool isStilInfoEnabled();
    void setStilInfoEnabled(bool);

    bool initSongLengthDB();
    // For config saver and internal use as wrapper.
    bool isSongLenDbEnabled();
    void setSongLenDbEnabled(bool);
    int querySongLengthDB(SidTuneWrapper*, int song);

    void setup(ConfigFile*, const QString&, Player*);
    bool writeConfig();

    void setAudioConfig(const AudioConfig&);
    void setEmuConfig(const emuConfig&);

public slots:
    void playerButtonsForceStop();
    
    void receiveEmuConfig(const emuConfig&);
    void receiveHVSC_Config(const HVSC_Config&);
    void receiveMixerConfig(const MixerConfig&);
    
    void playFile(const QString&);
    void playHistoryFile(const QString&);
    void playPlaylistFile(const PlaylistItem&);
    void playFileMain( const QString&, int song, const PlaylistItem&, bool putInHistory, bool enablePlaylist );
    
    void openFile();
    void saveAs();
    void quit();
    void loadPlaylist();
    void savePlaylistAs();
    void saveHotlist();
    void markTune();
    void markPlaylist();
    
    void openAudioDialog();
    void openEmulatorDialog();
    void openFilterDialog();
    void openHVSC_Dialog();
    void openSidIdDialog();
    void openHistoryDialog();
    void openMixerDialog();
    void openTSID2Dialog();

    void openPlaylistDialog();
    void openPlaylistEditDialog();
    void openPlaylistOptions();
    void addTuneToPlaylist();
    void addDirToPlaylist();
    void addTreeToPlaylist();
    void addHotlistToPlaylist();
    void updatePlaylist();

    void toggleStilDialog();
    void toggleSongLengthDB();

    void about();
    void aboutQt();

 protected:
    Playlist* hotlist;

    // sub-dialogs

    QFileDialog* myFileDlg;

    AudioDialog* myAudioDlg;
    EmuDialog* myEmuDlg;
    FilterDialog* myFilterDlg;
    HistoryDialog* myHistoryDlg;
    HVSC_Dialog* myHVSC_Dlg;
    SidIdDialog* mySidIdDlg;
    MixerDialog* myMixerDlg;
#ifdef XSID_HAVE_TSID2
    TSID2Dialog* myTSID2Dlg;
#endif
    PlaylistDialog* myPlaylistDlg;
    PlaylistEditDialog* myPlaylistEditDlg;
    StilDialog* myStilDlg;

    QPixmap* prevPic;
    QPixmap* stopPic;
    QPixmap* playPic;
    QPixmap* pausePic;
    QPixmap* ffPic;
    QPixmap* nextPic;

    QPixmap* stop_pPic;
    QPixmap* pause_pPic;
    QPixmap* ff_pPic;
    
    QPixmap* prev_lPic;
    QPixmap* stop_lPic;
    QPixmap* play_lPic;
    QPixmap* pause_lPic;
    QPixmap* ff_lPic;
    QPixmap* next_lPic;
    
    QPixmap* prev_l_pPic;
    QPixmap* stop_l_pPic;
    QPixmap* play_l_pPic;
    QPixmap* next_l_pPic;

    void programExitHook();
    
    void addTuneToPlaylistMain(PlaylistItem*);
    void addDirMain(bool recurse);
    void addDirTraverse(QString, bool recurse, SidTuneWrapper*);

    const QString& fetchLastDir(const char* group);
    void storeLastDir(const char* group, const QString&);
    
    void resetTimeDisplay();

    void closeEvent(QCloseEvent*);
    void resizeEvent(QResizeEvent*);

#ifdef XSID_HAVE_TSID
    void addTSID();
#endif
#ifdef XSID_HAVE_TSID2
    void addTSID2();
#endif

 protected slots:

    void prevSongPressed();
    void prevSongReleased();
    void stopSongPressed();
    void stopSongReleased();
    void playSongPressed();
    void playSongReleased();
    void forwardSongPressed();
    void forwardSongReleased();
    void nextSongPressed();
    void nextSongReleased();
    void newSubSong(int);
    void updateSubSongSlider();

    void setPlaylistEnabled(bool);
    void setLoopPlayEnabled(bool);
    void setRandomPlayEnabled(bool);
    
    void lircEvent(int);

 private:
    
    QMenuBar *menuBar;
    QPopupMenu *extraMenu;
    int stilID, songLenDbID;

    ConfigFile* config;
    QString configPath;
    
    long int usage;  // a local copy of the listening mileage

    Player* player;
    
    int playtimeDefault, fadeoutDefault;
    
    void createHVSCfileName(const QString& fileName);
                        
    STIL mySTIL;
    // The currently active file name, and the part of it
    // which is relative to the HVSC root (if any).
    QString sidFileNameFull, sidFileNameHVSC;
    
#ifdef XSID_HAVE_TSID
    TSID* myTSID;
#endif
#ifdef XSID_HAVE_TSID2
    TSID2* myTSID2;
#endif
  SidId* mySidId;

#ifdef XSID_HAVE_LIRC
  int lircfh;
  struct lirc_config *lircConfig;
#endif

};

inline bool MainDialog::isStilInfoEnabled()
{
    return extraMenu->isItemChecked(stilID);
}

inline void MainDialog::setStilInfoEnabled(bool val)
{
    extraMenu->setItemChecked(stilID,val);
}

inline bool MainDialog::isSongLenDbEnabled()
{
    return extraMenu->isItemChecked(songLenDbID);
}

inline void MainDialog::setSongLenDbEnabled(bool val)
{
    extraMenu->setItemChecked(songLenDbID,val);
}

#endif  /* MAINDIALOG_H */
